/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Util;
import java.math.BigInteger;
import java.util.Random;

public class Randoms {
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = new BigInteger("2");
    private static final int ERR_VAL = 100;
    private static StringBuffer[] digits = new StringBuffer[]{new StringBuffer("0"), new StringBuffer("1"), new StringBuffer("2"), new StringBuffer("3"), new StringBuffer("4"), new StringBuffer("5"), new StringBuffer("6"), new StringBuffer("7"), new StringBuffer("8"), new StringBuffer("9")};

    public static byte[] getRandom() {
        BigInteger big_s;
        BigInteger big_n;
        boolean isPr;
        BigInteger big_p = Randoms.getPrimeNunber();
        while (!(isPr = big_p.mod(new BigInteger("4")).equals(new BigInteger("3")))) {
            big_p = Randoms.getPrimeNunber();
        }
        BigInteger big_q = Randoms.getPrimeNunber();
        while (!(isPr = big_q.mod(new BigInteger("4")).equals(new BigInteger("3")))) {
            big_q = Randoms.getPrimeNunber();
        }
        BigInteger big_k = big_n = big_p.multiply(big_q);
        big_k = big_k.add(BigInteger.ONE.negate());
        do {
            Random rand = new Random();
            int rand_i = rand.nextInt();
            big_s = big_k.multiply(new BigInteger(String.valueOf(rand_i), 16));
        } while ((big_s = big_s.add(BigInteger.ONE)).mod(big_q) == BigInteger.ZERO || big_s.mod(big_p) == BigInteger.ZERO);
        byte[] random_b = new byte[32];
        BigInteger last_ = big_s.multiply(big_s).mod(big_n);
        int i = 0;
        while (i < 32) {
            byte i_ = 0;
            int j = 0;
            while (j < 8) {
                byte[] rand_b = last_.mod(new BigInteger("2")).toByteArray();
                i_ = (byte)(i_ | rand_b[0] << j);
                last_ = last_.multiply(last_).mod(big_n);
                ++j;
            }
            random_b[i] = i_;
            ++i;
        }
        return random_b;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 5) {
            System.out.println(Util.byteArrayToString(Randoms.getRandom(), 0));
            ++i;
        }
    }

    private static BigInteger getPrimeNunber() {
        int numDigits;
        try {
            numDigits = Integer.parseInt("15");
        }
        catch (Exception e) {
            numDigits = 128;
        }
        BigInteger start = Randoms.bigRandom(numDigits);
        start = Randoms.nextPrime(start);
        BigInteger end = Randoms.bigRandom(5);
        end = Randoms.nextPrime(end);
        BigInteger result = start.multiply(end);
        return result;
    }

    private static StringBuffer randomDigit(boolean isZeroOK) {
        int index = isZeroOK ? (int)Math.floor(Math.random() * 10.0) : 1 + (int)Math.floor(Math.random() * 9.0);
        return digits[index];
    }

    private static BigInteger bigRandom(int numDigits) {
        StringBuffer s = new StringBuffer("");
        int i = 0;
        while (i < numDigits) {
            if (i == 0) {
                s.append(Randoms.randomDigit(false));
            } else {
                s.append(Randoms.randomDigit(true));
            }
            ++i;
        }
        return new BigInteger(s.toString());
    }

    private static boolean isEven(BigInteger n) {
        return n.mod(TWO).equals(ZERO);
    }

    private static BigInteger nextPrime(BigInteger start) {
        if ((start = Randoms.isEven(start) ? start.add(ONE) : start.add(TWO)).isProbablePrime(100)) {
            return start;
        }
        return Randoms.nextPrime(start);
    }
}

