/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Base64;
import com.custle.security.algorithm.imple.soft.sm2.Constants;
import com.custle.security.algorithm.imple.soft.sm2.EccPoint;
import com.custle.security.algorithm.imple.soft.sm2.ErrCode;
import com.custle.security.algorithm.imple.soft.sm2.Randoms;
import com.custle.security.algorithm.imple.soft.sm2.SM2PrivateKey;
import com.custle.security.algorithm.imple.soft.sm2.SM2PublicKey;
import com.custle.security.algorithm.imple.soft.sm2.Util;
import java.math.BigInteger;
import java.util.Random;

public class KeyPairExt {
    private byte[] mPriKey = null;
    private byte[] mPubKey = null;

    public byte[] getPrivateKey() {
        return this.mPriKey;
    }

    private static BigInteger[] genSM2KeyPair(BigInteger Xg, BigInteger Yg, BigInteger big_a, BigInteger big_b, BigInteger big_n, BigInteger big_p, BigInteger big_rand) {
        BigInteger Ya;
        BigInteger Xa;
        BigInteger big_pri_Da;
        if (Xg.equals(null) || Yg.equals(null) || big_a.equals(null) || big_b.equals(null) || big_n.equals(null) || big_p.equals(null)) {
            ErrCode.mKeyPairLastError = ErrCode.KEY_GENKEY_BIG_PARAM_ERR;
            return null;
        }
        BigInteger[] keyPair = new BigInteger[3];
        int iter = 0;
        do {
            BigInteger big_rand_k;
            if (big_rand == null) {
                int[] iRandom = new int[8];
                byte[] bytGenRand = new byte[32];
                int i = 0;
                while (i < 8) {
                    Random random = new Random();
                    iRandom[i] = random.nextInt();
                    ++i;
                }
                i = 0;
                while (i < 8) {
                    System.arraycopy(Util.int2ByteArray(iRandom[i], 4), 0, bytGenRand, i * 4, 4);
                    ++i;
                }
                String strGenRand = Util.byteArrayToString(bytGenRand, 0);
                big_rand_k = new BigInteger(strGenRand, 16);
                big_rand_k = big_rand_k.add(big_n.negate()).mod(big_n);
            } else {
                big_rand_k = big_rand;
                big_rand_k = big_rand_k.add(big_n.negate()).mod(big_n);
            }
            big_pri_Da = big_rand_k;
            BigInteger[] pubKeyXY = EccPoint.eccPointMul(Xg, Yg, big_rand_k, big_a, big_p);
            if (pubKeyXY == null) {
                ErrCode.mKeyPairLastError = ErrCode.KEY_GENKEY_POINT_MUL_ERR;
                return null;
            }
            Xa = pubKeyXY[0];
            Ya = pubKeyXY[1];
            boolean isXaYaOnCurve = EccPoint.isXYOnSM2Curve(Xa, Ya, big_a, big_b, big_p);
            if (!isXaYaOnCurve) {
                ErrCode.mKeyPairLastError = ErrCode.KEY_GENKEY_POINT_NOT_ON_CURVE_ERR;
                continue;
            }
            BigInteger[] XY = EccPoint.eccPointMul(Xa, Ya, big_n, big_a, big_p);
            if (XY == null) {
                ErrCode.mKeyPairLastError = ErrCode.KEY_GENKEY_POINT_MUL_ERR;
                return null;
            }
            BigInteger big_inf_X = XY[0];
            BigInteger big_inf_Y = XY[1];
            if (!big_inf_X.equals(BigInteger.ZERO) && !big_inf_Y.equals(BigInteger.ZERO)) break;
            ++iter;
        } while (iter < 100);
        if (iter == 100) {
            ErrCode.mKeyPairLastError = ErrCode.KEY_GENKEY_FAILED_ERR;
            return null;
        }
        keyPair[0] = Xa;
        keyPair[1] = Ya;
        keyPair[2] = big_pri_Da;
        return keyPair;
    }

    public byte[] genSM2KeyPair(byte[] bytRandNumber) {
        int i;
        BigInteger[] big_keyPair = new BigInteger[3];
        BigInteger big_Xg = new BigInteger(Constants.SM2_G_X, 16);
        BigInteger big_Yg = new BigInteger(Constants.SM2_G_Y, 16);
        BigInteger big_a = new BigInteger(Constants.SM2_A, 16);
        BigInteger big_b = new BigInteger(Constants.SM2_B, 16);
        BigInteger big_n = new BigInteger(Constants.SM2_N, 16);
        BigInteger big_p = new BigInteger(Constants.SM2_P, 16);
        BigInteger big_rand = bytRandNumber != null ? new BigInteger(Util.byteArrayToString(bytRandNumber, 0), 16) : null;
        big_keyPair = KeyPairExt.genSM2KeyPair(big_Xg, big_Yg, big_a, big_b, big_n, big_p, big_rand);
        if (big_keyPair == null) {
            return null;
        }
        BigInteger big_Xa = big_keyPair[0];
        BigInteger big_Ya = big_keyPair[1];
        BigInteger big_pri_Da = big_keyPair[2];
        String strXa = big_Xa.toString(16);
        String strYa = big_Ya.toString(16);
        String strPriDa = big_pri_Da.toString(16);
        int lenXa = strXa.length();
        int lenYa = strYa.length();
        int lenPriDa = strPriDa.length();
        if (lenXa < 64) {
            i = 0;
            while (i < 64 - lenXa) {
                strXa = "0" + strXa;
                ++i;
            }
        }
        if (lenYa < 64) {
            i = 0;
            while (i < 64 - lenYa) {
                strYa = "0" + strYa;
                ++i;
            }
        }
        if (lenPriDa < 64) {
            i = 0;
            while (i < 64 - lenPriDa) {
                strPriDa = "0" + strPriDa;
                ++i;
            }
        }
        byte[] bytXa = Util.stringToByteArray(strXa);
        byte[] bytYa = Util.stringToByteArray(strYa);
        byte[] bytPriDa = Util.stringToByteArray(strPriDa);
        if (bytXa.length + bytYa.length != 64 || bytPriDa.length != 32) {
            ErrCode.mKeyPairLastError = ErrCode.UNKNOWN_ERR;
            return null;
        }
        byte[] pubKey = new byte[64];
        byte[] priKey = new byte[32];
        System.arraycopy(bytXa, 0, pubKey, 0, 32);
        System.arraycopy(bytYa, 0, pubKey, 32, 32);
        System.arraycopy(bytPriDa, 0, priKey, 0, 32);
        this.mPriKey = priKey;
        this.mPubKey = pubKey;
        return this.mPubKey;
    }

    public SM2PublicKey genSM2KeyPairDer(byte[] bytRandNumber) {
        byte[] pk = this.genSM2KeyPair(bytRandNumber);
        if (pk != null) {
            SM2PublicKey sm2PublicKey = new SM2PublicKey(pk);
            return sm2PublicKey;
        }
        return null;
    }

    public SM2PrivateKey getPrivateKeyDer() {
        SM2PrivateKey sm2PrivateKey = new SM2PrivateKey(this.mPubKey, this.mPriKey);
        return sm2PrivateKey;
    }

    public static void main(String[] args) {
        KeyPairExt keyPair = new KeyPairExt();
        byte[] bytKeyPairRand = Randoms.getRandom();
        SM2PublicKey pk = keyPair.genSM2KeyPairDer(bytKeyPairRand);
        System.out.println("Alg:" + pk.getAlgorithm());
        System.out.println("PublicKey:" + new String(Base64.encodeToString(pk.getEncoded())));
        System.out.println("PrivateKey:" + new String(Base64.encodeToString(keyPair.getPrivateKeyDer().getEncoded())));
    }
}

