/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Constants;
import com.custle.security.algorithm.imple.soft.sm2.ErrCode;
import com.custle.security.algorithm.imple.soft.sm2.Util;
import java.math.BigInteger;

public class EccPoint {
    public static BigInteger[] eccPointAdd(BigInteger X1, BigInteger Y1, BigInteger X2, BigInteger Y2, BigInteger a, BigInteger p) {
        if (X1.equals(null) || Y1.equals(null) || X2.equals(null) || Y2.equals(null) || a.equals(null) || p.equals(null)) {
            ErrCode.mEccPointLastError = ErrCode.ECC_BIG_PARAM_ERR;
            return null;
        }
        BigInteger[] resultXY = new BigInteger[2];
        if (X1.equals(BigInteger.ZERO) && Y1.equals(BigInteger.ZERO) && X2.equals(BigInteger.ZERO) && Y2.equals(BigInteger.ZERO)) {
            resultXY[0] = BigInteger.ZERO;
            resultXY[1] = BigInteger.ZERO;
            return resultXY;
        }
        if (X1.equals(BigInteger.ZERO) && Y1.equals(BigInteger.ZERO)) {
            resultXY[0] = X2;
            resultXY[1] = Y2;
            return resultXY;
        }
        if (X2.equals(BigInteger.ZERO) && Y2.equals(BigInteger.ZERO)) {
            resultXY[0] = X1;
            resultXY[1] = Y1;
            return resultXY;
        }
        BigInteger tmp_r = BigInteger.ZERO;
        tmp_r = Y1.add(Y2);
        if (X1.equals(X2) && tmp_r.equals(BigInteger.ZERO)) {
            resultXY[0] = BigInteger.ZERO;
            resultXY[1] = BigInteger.ZERO;
            return resultXY;
        }
        BigInteger tmp1 = BigInteger.ZERO;
        BigInteger tmp2 = BigInteger.ZERO;
        BigInteger Lambda = BigInteger.ZERO;
        BigInteger top = BigInteger.ZERO;
        BigInteger bottom = BigInteger.ZERO;
        if (X1.equals(X2)) {
            tmp1 = X1.multiply(X1);
            tmp2 = tmp1.add(tmp1).add(tmp1);
            top = tmp2.add(a).mod(p);
            tmp1 = Y1.add(Y1);
            bottom = tmp1.modInverse(p);
            Lambda = top.multiply(bottom).mod(p);
        } else {
            top = Y2.add(Y1.negate()).mod(p);
            tmp1 = X2.add(X1.negate()).mod(p);
            bottom = tmp1.modInverse(p);
            Lambda = top.multiply(bottom).mod(p);
        }
        tmp1 = Lambda.multiply(Lambda);
        tmp2 = tmp1.add(X1.negate());
        resultXY[0] = tmp2.add(X2.negate()).mod(p);
        tmp1 = X1.add(resultXY[0].negate());
        tmp2 = Lambda.multiply(tmp1);
        resultXY[1] = tmp2.add(Y1.negate()).mod(p);
        return resultXY;
    }

    public static BigInteger[] eccPointMul(BigInteger Px, BigInteger Py, BigInteger d, BigInteger a, BigInteger p) {
        if (Px.equals(null) || Py.equals(null) || d.equals(null) || a.equals(null) || p.equals(null)) {
            ErrCode.mEccPointLastError = ErrCode.ECC_BIG_PARAM_ERR;
            return null;
        }
        BigInteger[] resultXY = new BigInteger[2];
        BigInteger A = a;
        BigInteger P = p;
        BigInteger Qx = BigInteger.ZERO;
        BigInteger Qy = BigInteger.ZERO;
        BigInteger tmp_Qx = BigInteger.ZERO;
        BigInteger tmp_Qy = BigInteger.ZERO;
        byte[] bytD = d.toByteArray();
        boolean[] tmp_d = new boolean[bytD.length * 8];
        int i = 0;
        while (i < bytD.length) {
            tmp_d[8 * i] = (bytD[i] & 0x80) == 128;
            tmp_d[8 * i + 1] = (bytD[i] & 0x40) == 64;
            tmp_d[8 * i + 2] = (bytD[i] & 0x20) == 32;
            tmp_d[8 * i + 3] = (bytD[i] & 0x10) == 16;
            tmp_d[8 * i + 4] = (bytD[i] & 8) == 8;
            tmp_d[8 * i + 5] = (bytD[i] & 4) == 4;
            tmp_d[8 * i + 6] = (bytD[i] & 2) == 2;
            tmp_d[8 * i + 7] = (bytD[i] & 1) == 1;
            ++i;
        }
        i = 0;
        while (i < tmp_d.length) {
            BigInteger[] tmp_Qxy = EccPoint.eccPointAdd(Qx, Qy, Qx, Qy, A, P);
            if (tmp_Qxy == null) {
                return null;
            }
            tmp_Qx = tmp_Qxy[0];
            tmp_Qy = tmp_Qxy[1];
            if (tmp_d[i]) {
                BigInteger[] Qxy = EccPoint.eccPointAdd(tmp_Qx, tmp_Qy, Px, Py, A, P);
                if (Qxy == null) {
                    return null;
                }
                Qx = Qxy[0];
                Qy = Qxy[1];
                tmp_Qx = Qx;
                tmp_Qy = Qy;
            }
            Qx = tmp_Qx;
            Qy = tmp_Qy;
            ++i;
        }
        resultXY[0] = tmp_Qx;
        resultXY[1] = tmp_Qy;
        return resultXY;
    }

    public static boolean isXYOnSM2Curve(BigInteger big_x, BigInteger big_y, BigInteger big_a, BigInteger big_b, BigInteger big_p) {
        if (big_x.equals(null) || big_y.equals(null) || big_a.equals(null) || big_b.equals(null) || big_p.equals(null)) {
            ErrCode.mEccPointLastError = ErrCode.ECC_BIG_PARAM_ERR;
            return false;
        }
        if (big_x.equals(BigInteger.ZERO) && big_y.equals(BigInteger.ZERO)) {
            ErrCode.mEccPointLastError = ErrCode.ECC_INFINITE_POINT_ERR;
            return false;
        }
        if (big_x.compareTo(BigInteger.ZERO) < 0 || big_x.compareTo(big_p) >= 0 || big_y.compareTo(BigInteger.ZERO) < 0 || big_y.compareTo(big_p) >= 0) {
            ErrCode.mEccPointLastError = ErrCode.ECC_POINT_NOT_ON_CURVE_ERR;
            return false;
        }
        BigInteger left = big_y.multiply(big_y).mod(big_p);
        BigInteger big_tmp1 = big_x.multiply(big_x).multiply(big_x);
        BigInteger big_tmp2 = big_x.multiply(big_a);
        BigInteger right = (big_tmp1 = big_tmp1.add(big_tmp2)).add(big_b).mod(big_p);
        if (left.compareTo(right) != 0) {
            ErrCode.mEccPointLastError = ErrCode.ECC_POINT_NOT_ON_CURVE_ERR;
            return false;
        }
        return true;
    }

    public static boolean isXYOnSM2Curve(byte[] pubKey) {
        if (pubKey == null || pubKey.length != 64) {
            ErrCode.mEccPointLastError = ErrCode.ECC_PARAM_ERR;
            return false;
        }
        byte[] bytX = new byte[32];
        byte[] bytY = new byte[32];
        BigInteger big_a = new BigInteger(Constants.SM2_A, 16);
        BigInteger big_b = new BigInteger(Constants.SM2_B, 16);
        BigInteger big_p = new BigInteger(Constants.SM2_P, 16);
        System.arraycopy(pubKey, 0, bytX, 0, 32);
        System.arraycopy(pubKey, 32, bytY, 0, 32);
        BigInteger big_x = new BigInteger(Util.byteArrayToString(bytX, 0), 16);
        BigInteger big_y = new BigInteger(Util.byteArrayToString(bytY, 0), 16);
        return EccPoint.isXYOnSM2Curve(big_x, big_y, big_a, big_b, big_p);
    }
}

