/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Constants;
import com.custle.security.algorithm.imple.soft.sm2.EccPoint;
import com.custle.security.algorithm.imple.soft.sm2.ErrCode;
import com.custle.security.algorithm.imple.soft.sm2.SM3Hash;
import com.custle.security.algorithm.imple.soft.sm2.Util;
import java.math.BigInteger;
import java.util.Random;

public class Cryption {
    public static byte[] sm2Encrypt(byte[] bytPlainData, byte[] bytPubKeyXY, byte[] bytRandNumber) {
        if (bytPlainData == null || bytPubKeyXY == null || bytPubKeyXY.length != 64) {
            ErrCode.mCryptionLastError = ErrCode.CRY_PARAM_ERR;
            return null;
        }
        byte[] tmpX2Buff = null;
        byte[] tmpY2Buff = null;
        byte[] ptmp = null;
        byte[] pout = null;
        byte[] C1_buf = null;
        byte[] C2_buf = null;
        byte[] C3_buf = null;
        byte[] tmpBuffx = null;
        byte[] tmpBuffy = null;
        BigInteger big_rand_k = BigInteger.ONE;
        byte[] bytXB = new byte[32];
        byte[] bytYB = new byte[32];
        System.arraycopy(bytPubKeyXY, 0, bytXB, 0, 32);
        System.arraycopy(bytPubKeyXY, 32, bytYB, 0, 32);
        int iter = 0;
        BigInteger big_a = new BigInteger(Constants.SM2_A, 16);
        BigInteger big_b = new BigInteger(Constants.SM2_B, 16);
        BigInteger big_n = new BigInteger(Constants.SM2_N, 16);
        BigInteger big_p = new BigInteger(Constants.SM2_P, 16);
        BigInteger big_Xg = new BigInteger(Constants.SM2_G_X, 16);
        BigInteger big_Yg = new BigInteger(Constants.SM2_G_Y, 16);
        block0: do {
            int i;
            String strTmpBuffy;
            if (bytRandNumber == null) {
                int[] iRandom = new int[8];
                int i2 = 0;
                while (i2 < 8) {
                    Random random = new Random();
                    iRandom[i2] = random.nextInt();
                    ++i2;
                }
                byte[] bytGenRand = new byte[32];
                int i3 = 0;
                while (i3 < 8) {
                    System.arraycopy(Util.int2ByteArray(iRandom[i3], 4), 0, bytGenRand, i3 * 4, 4);
                    ++i3;
                }
                big_rand_k = new BigInteger(Util.byteArrayToString(bytGenRand, 0), 16);
                big_rand_k = big_rand_k.add(big_n.negate()).mod(big_n);
            } else {
                big_rand_k = new BigInteger(Util.byteArrayToString(bytRandNumber, 0), 16);
                big_rand_k = big_rand_k.add(big_n.negate()).mod(big_n);
            }
            BigInteger big_XB = new BigInteger(Util.byteArrayToString(bytXB, 0), 16);
            BigInteger big_YB = new BigInteger(Util.byteArrayToString(bytYB, 0), 16);
            BigInteger[] big_x1y1 = EccPoint.eccPointMul(big_Xg, big_Yg, big_rand_k, big_a, big_p);
            if (big_x1y1 == null) {
                ErrCode.mCryptionLastError = ErrCode.CRY_POINT_MUL_ERR;
                return null;
            }
            BigInteger big_x1 = big_x1y1[0];
            BigInteger big_y1 = big_x1y1[1];
            String strTmpBuffx = big_x1.toString(16);
            if (strTmpBuffx.length() < 64) {
                int i4 = 0;
                while (i4 < 64 - strTmpBuffx.length()) {
                    strTmpBuffx = "0" + strTmpBuffx;
                    ++i4;
                }
            }
            if ((strTmpBuffy = big_y1.toString(16)).length() < 64) {
                int i5 = 0;
                while (i5 < 64 - strTmpBuffy.length()) {
                    strTmpBuffy = "0" + strTmpBuffy;
                    ++i5;
                }
            }
            tmpBuffx = Util.stringToByteArray(strTmpBuffx);
            tmpBuffy = Util.stringToByteArray(strTmpBuffy);
            C1_buf = new byte[1 + tmpBuffx.length + tmpBuffy.length];
            C1_buf[0] = 4;
            System.arraycopy(tmpBuffx, 0, C1_buf, 1, tmpBuffx.length);
            System.arraycopy(tmpBuffy, 0, C1_buf, 1 + tmpBuffx.length, tmpBuffy.length);
            BigInteger[] big_x2y2 = EccPoint.eccPointMul(big_XB, big_YB, big_rand_k, big_a, big_p);
            if (big_x2y2 == null) {
                ErrCode.mCryptionLastError = ErrCode.CRY_POINT_MUL_ERR;
                return null;
            }
            BigInteger big_x2 = big_x2y2[0];
            BigInteger big_y2 = big_x2y2[1];
            String strTmpX2Buff = big_x2.toString(16);
            String strTmpY2Buff = big_y2.toString(16);
            if (strTmpX2Buff.length() < 64) {
                i = 0;
                while (i < 64 - strTmpX2Buff.length()) {
                    strTmpX2Buff = "0" + strTmpX2Buff;
                    ++i;
                }
            }
            if (strTmpY2Buff.length() < 64) {
                i = 0;
                while (i < 64 - strTmpY2Buff.length()) {
                    strTmpY2Buff = "0" + strTmpY2Buff;
                    ++i;
                }
            }
            tmpX2Buff = Util.stringToByteArray(strTmpX2Buff);
            tmpY2Buff = Util.stringToByteArray(strTmpY2Buff);
            ptmp = new byte[tmpX2Buff.length + tmpY2Buff.length];
            System.arraycopy(tmpX2Buff, 0, ptmp, 0, tmpX2Buff.length);
            System.arraycopy(tmpY2Buff, 0, ptmp, tmpX2Buff.length, tmpY2Buff.length);
            pout = Cryption.KDFwithSm3(ptmp, bytPlainData.length);
            if (pout == null) {
                return null;
            }
            iter = 0;
            while (iter < bytPlainData.length) {
                if (pout[iter] != 0) continue block0;
                ++iter;
            }
        } while (iter == bytPlainData.length);
        C2_buf = new byte[bytPlainData.length];
        iter = 0;
        while (iter < bytPlainData.length) {
            C2_buf[iter] = (byte)(bytPlainData[iter] ^ pout[iter]);
            ++iter;
        }
        ptmp = new byte[bytPlainData.length + tmpX2Buff.length + tmpY2Buff.length];
        System.arraycopy(tmpX2Buff, 0, ptmp, 0, tmpX2Buff.length);
        System.arraycopy(bytPlainData, 0, ptmp, tmpX2Buff.length, bytPlainData.length);
        System.arraycopy(tmpY2Buff, 0, ptmp, tmpX2Buff.length + bytPlainData.length, tmpY2Buff.length);
        C3_buf = SM3Hash.getHashValue(ptmp);
        if (C3_buf == null) {
            ErrCode.mCryptionLastError = ErrCode.CRY_C3_HASH_ERR;
            return null;
        }
        byte[] C_buf = new byte[C1_buf.length + C2_buf.length + C3_buf.length];
        System.arraycopy(C1_buf, 0, C_buf, 0, C1_buf.length);
        System.arraycopy(C3_buf, 0, C_buf, C1_buf.length, C3_buf.length);
        System.arraycopy(C2_buf, 0, C_buf, C1_buf.length + C3_buf.length, C2_buf.length);
        return C_buf;
    }

    public static byte[] sm2Decrypt(byte[] bytInputData, byte[] bytPridA) {
        int i;
        if (bytInputData == null || bytInputData.length < 98 || bytPridA == null || bytPridA.length != 32) {
            ErrCode.mCryptionLastError = ErrCode.CRY_PARAM_ERR;
            return null;
        }
        int C2Len = bytInputData.length - 65 - 32;
        int iter = 0;
        byte[] C3 = new byte[32];
        System.arraycopy(bytInputData, 65, C3, 0, 32);
        BigInteger big_a = new BigInteger(Constants.SM2_A, 16);
        BigInteger big_b = new BigInteger(Constants.SM2_B, 16);
        BigInteger big_n = new BigInteger(Constants.SM2_N, 16);
        BigInteger big_p = new BigInteger(Constants.SM2_P, 16);
        BigInteger big_Xg = new BigInteger(Constants.SM2_G_X, 16);
        BigInteger big_Yg = new BigInteger(Constants.SM2_G_Y, 16);
        byte[] C2 = new byte[C2Len];
        byte[] C1 = new byte[64];
        System.arraycopy(bytInputData, 1, C1, 0, 64);
        boolean IsC1OnCurve = EccPoint.isXYOnSM2Curve(C1);
        if (!IsC1OnCurve) {
            ErrCode.mCryptionLastError = ErrCode.CRY_POINT_NOT_ON_CURVE_ERR;
            return null;
        }
        BigInteger big_pri_dA = new BigInteger(Util.byteArrayToString(bytPridA, 0), 16);
        byte[] bytx1 = new byte[32];
        byte[] byty1 = new byte[32];
        System.arraycopy(C1, 0, bytx1, 0, 32);
        System.arraycopy(C1, 32, byty1, 0, 32);
        BigInteger big_x1 = new BigInteger(Util.byteArrayToString(bytx1, 0), 16);
        BigInteger big_y1 = new BigInteger(Util.byteArrayToString(byty1, 0), 16);
        BigInteger[] big_x2y2 = EccPoint.eccPointMul(big_x1, big_y1, big_pri_dA, big_a, big_p);
        if (big_x2y2 == null) {
            ErrCode.mCryptionLastError = ErrCode.CRY_POINT_MUL_ERR;
            return null;
        }
        BigInteger big_x2 = big_x2y2[0];
        BigInteger big_y2 = big_x2y2[1];
        String strTmpX2Buff = big_x2.toString(16);
        String strTmpY2Buff = big_y2.toString(16);
        if (strTmpX2Buff.length() < 64) {
            i = 0;
            while (i < 64 - strTmpX2Buff.length()) {
                strTmpX2Buff = "0" + strTmpX2Buff;
                ++i;
            }
        }
        if (strTmpY2Buff.length() < 64) {
            i = 0;
            while (i < 64 - strTmpY2Buff.length()) {
                strTmpY2Buff = "0" + strTmpY2Buff;
                ++i;
            }
        }
        byte[] tmpX2Buff = Util.stringToByteArray(strTmpX2Buff);
        byte[] tmpY2Buff = Util.stringToByteArray(strTmpY2Buff);
        byte[] ptmp = new byte[tmpX2Buff.length + tmpY2Buff.length];
        System.arraycopy(tmpX2Buff, 0, ptmp, 0, tmpX2Buff.length);
        System.arraycopy(tmpY2Buff, 0, ptmp, tmpX2Buff.length, tmpY2Buff.length);
        byte[] pout = Cryption.KDFwithSm3(ptmp, C2Len);
        if (pout == null) {
            return null;
        }
        iter = 0;
        while (iter < C2Len) {
            if (pout[iter] != 0) break;
            ++iter;
        }
        if (C2Len == iter) {
            ErrCode.mCryptionLastError = ErrCode.CRY_DECRYPT_FAILED_ERR;
            return null;
        }
        iter = 0;
        while (iter < C2Len) {
            C2[iter] = (byte)(pout[iter] ^ bytInputData[97 + iter]);
            ++iter;
        }
        ptmp = new byte[C2Len + tmpX2Buff.length + tmpY2Buff.length];
        System.arraycopy(tmpX2Buff, 0, ptmp, 0, tmpX2Buff.length);
        System.arraycopy(C2, 0, ptmp, tmpX2Buff.length, C2Len);
        System.arraycopy(tmpY2Buff, 0, ptmp, tmpX2Buff.length + C2Len, tmpY2Buff.length);
        byte[] dgstC3 = SM3Hash.getHashValue(ptmp);
        if (dgstC3 == null) {
            ErrCode.mCryptionLastError = ErrCode.CRY_C3_HASH_ERR;
            return null;
        }
        i = 0;
        while (i < 32) {
            if (dgstC3[i] != C3[i]) {
                ErrCode.mCryptionLastError = ErrCode.CRY_DECRYPT_FAILED_ERR;
                return null;
            }
            ++i;
        }
        return C2;
    }

    private static byte[] KDFwithSm3(byte[] bytZIn, int iKlen) {
        if (bytZIn == null || iKlen == 0) {
            ErrCode.mCryptionLastError = ErrCode.CRY_KDF_PARAM_ERR;
            return null;
        }
        int ct = 1;
        byte[] kdfOutBuff = new byte[iKlen];
        byte[] tmpKdfOutBuff = null;
        byte[] ZandCt = new byte[bytZIn.length + 4];
        int mod = iKlen % 32;
        int max_iter = iKlen / 32;
        byte[] ct_un_buff = null;
        byte[] tmp_buff = new byte[32];
        ct = 1;
        while (ct <= max_iter) {
            ct_un_buff = Util.int2ByteArray(ct, 4);
            if (ct_un_buff == null) {
                ErrCode.mCryptionLastError = ErrCode.CRY_KDF_CT_TRANS_ERR;
                return null;
            }
            System.arraycopy(bytZIn, 0, ZandCt, 0, bytZIn.length);
            System.arraycopy(ct_un_buff, 0, ZandCt, bytZIn.length, ct_un_buff.length);
            tmpKdfOutBuff = SM3Hash.getHashValue(ZandCt);
            if (tmpKdfOutBuff == null) {
                ErrCode.mCryptionLastError = ErrCode.CRY_KDF_ZCT_HASH_ERR;
                return null;
            }
            System.arraycopy(tmpKdfOutBuff, 0, kdfOutBuff, (ct - 1) * 32, tmpKdfOutBuff.length);
            ++ct;
        }
        ct_un_buff = Util.int2ByteArray(ct, 4);
        if (ct_un_buff == null) {
            ErrCode.mCryptionLastError = ErrCode.CRY_KDF_CT_TRANS_ERR;
            return null;
        }
        System.arraycopy(bytZIn, 0, ZandCt, 0, bytZIn.length);
        System.arraycopy(ct_un_buff, 0, ZandCt, bytZIn.length, ct_un_buff.length);
        tmp_buff = SM3Hash.getHashValue(ZandCt);
        if (tmp_buff == null) {
            ErrCode.mCryptionLastError = ErrCode.CRY_KDF_ZCT_HASH_ERR;
            return null;
        }
        System.arraycopy(tmp_buff, 0, kdfOutBuff, (ct - 1) * 32, mod);
        return kdfOutBuff;
    }
}

