/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm;

import com.custle.common.util.ResourceUtil;
import com.custle.security.algorithm.IAsymmAlgorithmsFactory;
import com.custle.security.algorithm.IHashFactory;
import com.custle.security.algorithm.ISymmAlgorithmsFactory;
import com.custle.security.algorithm.factory.AsymmAlgorithmsFactorySoft;
import com.custle.security.algorithm.factory.IHashFactorySoft;
import com.custle.security.algorithm.factory.SymmAlgorithmsFactorySoft;

public class Algorithms {
    public static final String provider = ResourceUtil.getProvider();
    public static final String SOFT_TYPE = "SOFT";

    public static IAsymmAlgorithmsFactory getAsymmAlgorithms(String provider) {
        AsymmAlgorithmsFactorySoft asymm_fac = null;
        if (provider.equals(SOFT_TYPE)) {
            asymm_fac = new AsymmAlgorithmsFactorySoft();
        }
        return asymm_fac;
    }

    public static ISymmAlgorithmsFactory getSymmAlgorithms(String provider) {
        SymmAlgorithmsFactorySoft symm_fac = null;
        if (provider.equals(SOFT_TYPE)) {
            symm_fac = new SymmAlgorithmsFactorySoft();
        }
        return symm_fac;
    }

    public static IHashFactory getDigestAlgotithms(String provider) {
        IHashFactorySoft hash_fac = null;
        if (provider.equals(SOFT_TYPE)) {
            hash_fac = new IHashFactorySoft();
        }
        return hash_fac;
    }
}

