/*
 * Decompiled with CFR 0.152.
 */
package com.custle.common.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    private static final String fileName = "key";
    private static final String provider = "key.provider";
    private static final String path = "key.path";
    private static final String license = "license.file";
    private static ResourceUtil singleton;
    private ConcurrentHashMap<String, Hashtable<String, String>> properties;

    private ResourceUtil() {
    }

    public static ResourceUtil getInstance() {
        if (singleton == null) {
            singleton = new ResourceUtil();
        }
        return singleton;
    }

    private Hashtable<String, String> initConfig(String fileName) {
        ResourceBundle rb = ResourceBundle.getBundle(fileName, Locale.SIMPLIFIED_CHINESE);
        Hashtable<String, String> confAttris = new Hashtable<String, String>();
        try {
            Enumeration<String> iter = rb.getKeys();
            while (iter.hasMoreElements()) {
                String key = iter.nextElement();
                confAttris.put(key, new String(rb.getString(key).getBytes("GBK")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return confAttris;
    }

    private String getValueFormFile(String fileName, String key) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap();
        }
        if (!this.properties.containsKey(fileName)) {
            this.properties.put(fileName, this.initConfig(fileName));
        }
        return this.properties.get(fileName).get(key);
    }

    public static String getDbPath() {
        return ResourceUtil.getInstance().getValueFormFile(fileName, path);
    }

    public static String getProvider() {
        return ResourceUtil.getInstance().getValueFormFile(fileName, provider);
    }

    public static String getLicenseFile() {
        return ResourceUtil.getInstance().getValueFormFile(fileName, license);
    }
}

