/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.helium.client.core;

import cn.gtmap.helium.client.core.ConfigProvider;
import cn.gtmap.helium.client.core.HeliumConfig;
import cn.gtmap.helium.client.core.HeliumConfigListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractHeliumConfig
implements HeliumConfig {
    private List<HeliumConfigListener> listeners = new ArrayList<HeliumConfigListener>();
    private Map<String, String> configParameters;

    protected AbstractHeliumConfig() {
    }

    protected AbstractHeliumConfig(Map<String, String> configParameters) {
        this.configParameters = configParameters;
    }

    @Override
    public final void init() {
        this.fireEvent(HeliumConfigListener.Event.BEFORE_INIT);
        this.doInit();
        this.fireEvent(HeliumConfigListener.Event.AFTER_INIT);
    }

    @Override
    public final void refresh() {
        this.fireEvent(HeliumConfigListener.Event.BEFORE_REFRESH);
        this.doRefresh();
        this.fireEvent(HeliumConfigListener.Event.AFTER_REFRESH);
    }

    @Override
    public final void destroy() {
        this.fireEvent(HeliumConfigListener.Event.BEFORE_DESTROY);
        this.doDestroy();
        this.fireEvent(HeliumConfigListener.Event.AFTER_DESTROY);
    }

    @Override
    public ConfigProvider getConfigProvider() {
        return null;
    }

    @Override
    public void addListener(HeliumConfigListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(HeliumConfigListener listener) {
        return this.listeners.remove(listener);
    }

    protected abstract void doInit();

    protected abstract void doRefresh();

    protected abstract void doDestroy();

    public String getConfigParameter(String name) throws IllegalArgumentException {
        String value = this.configParameters.get(name);
        if (value == null) {
            throw new IllegalArgumentException("\u672a\u53d1\u73b0\u914d\u7f6e\u53c2\u6570 [" + name + "]");
        }
        return value;
    }

    private void fireEvent(HeliumConfigListener.Event event) {
        for (HeliumConfigListener listener : this.listeners) {
            listener.execute(event);
        }
    }
}

