/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.helium.client.config;

import cn.gtmap.helium.client.config.AbstractWatchedHeliumConfig;
import cn.gtmap.helium.client.core.ConfigProvider;
import cn.gtmap.helium.client.core.DefaultConfigProvider;
import cn.gtmap.helium.client.core.HeliumBean;
import cn.gtmap.helium.client.exception.HeliumConfigException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.ResourceUtils;

public class PropertiesHeliumConfig
extends AbstractWatchedHeliumConfig {
    private ConfigProvider configProvider;

    public PropertiesHeliumConfig(HeliumBean heliumBean) {
        super(heliumBean);
    }

    @Override
    protected void doRefresh() {
        Properties properties = new Properties();
        for (HeliumBean.Resource resource : this.getHeliumBean().getResources()) {
            try {
                URL url = ResourceUtils.getURL((String)resource.getLocation());
                properties.putAll((Map<?, ?>)this.loadProperties(url));
            }
            catch (Exception e) {
                if (resource.isIgnoreNotFound()) {
                    this.logger.info("\u6587\u4ef6 [{}] \u4e0d\u5b58\u5728, \u5df2\u5ffd\u7565", (Object)resource.getLocation());
                    continue;
                }
                if (e instanceof FileNotFoundException) {
                    throw new HeliumConfigException("\u672a\u53d1\u73b0\u914d\u7f6e\u6587\u4ef6 [" + resource.getLocation() + "]", e);
                }
                throw new HeliumConfigException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6 [" + resource.getLocation() + "] \u9519\u8bef", e);
            }
        }
        this.configProvider = new DefaultConfigProvider(properties);
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    private Properties loadProperties(URL url) {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            Properties properties = new Properties();
            if (url.getPath().endsWith(".properties")) {
                properties.load(inputStream);
            } else if (url.getPath().endsWith(".xml")) {
                properties.loadFromXML(inputStream);
            } else {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6 [" + url + "], PropertiesHeliumConfig \u53ea\u652f\u6301\u52a0\u8f7d [*.properties, *.xml] \u7684 properties \u6587\u4ef6");
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 [" + url + "]\u9519\u8bef", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

