package cn.gtmap.helium.client.config;

import cn.gtmap.helium.client.core.ConfigProvider;
import cn.gtmap.helium.client.core.DefaultConfigProvider;
import cn.gtmap.helium.client.core.HeliumBean;
import cn.gtmap.helium.client.exception.HeliumConfigException;
import cn.gtmap.helium.client.util.EgovConfigHelper;

import java.io.*;
import java.util.Properties;

/**
 * gtmap properties config
 * Author: <a href="mailto:yingxiufeng@gtmap.cn">yingxiufeng</a>
 * Date:  2016/6/18 14:45
 */
public class GTPropertiesHeliumConfig extends AbstractWatchedHeliumConfig {

    private ConfigProvider configProvider;

    public GTPropertiesHeliumConfig(HeliumBean heliumBean) {
        super(heliumBean);
    }

    @SuppressWarnings("Duplicates")
    @Override
    protected void doRefresh() {
        Properties properties = new Properties();
        for (HeliumBean.Resource resource : getHeliumBean().getResources()) {
            try {
                properties.putAll(loadProperties(getPropertyFile(resource)));
            } catch (Exception e) {
                if (resource.isIgnoreNotFound()) {
                    logger.info("文件 [{}] 不存在, 已忽略", resource.getLocation());
                } else {
                    if (e instanceof FileNotFoundException) {
                        throw new HeliumConfigException("未发现配置文件 [" + resource.getLocation() + "]", e);
                    }
                    throw new HeliumConfigException("加载配置文件 [" + resource.getLocation() + "] 错误", e);
                }
            }
        }
        configProvider = new DefaultConfigProvider(properties);
    }

    @Override
    protected void doDestroy() {

    }

    @Override
    public ConfigProvider getConfigProvider() {
        return configProvider;
    }

    /***
     * 解析成gtmap路径的配置文件
     * @param resource
     * @return
     */
    private File getPropertyFile(HeliumBean.Resource resource) throws FileNotFoundException {
        File conf = EgovConfigHelper.getEgovConfHome();
        if (conf != null) {
            return new File(conf.getAbsolutePath() + File.separator + resource.getLocation());
        } else
            throw new FileNotFoundException(resource.getLocation());
    }

    /***
     * 加载配置
     * @param file
     * @return
     */
    private Properties loadProperties(File file){
        InputStream inputStream = null;
        try {
            inputStream =new FileInputStream(file);
            Properties properties = new Properties();
            if (file.getPath().endsWith(".properties")) {
                properties.load(inputStream);
            } else {
                throw new IllegalArgumentException("不支持的文件 [" + file.getPath()
                        + "], PropertiesHeliumConfig 只支持加载 properties 文件");
            }
            return properties;
        } catch (IOException e) {
            throw new IllegalStateException("读取配置文件 [" + file.getPath() + "]错误", e);
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    // ignore
                }
            }
        }
    }
}
