/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.x509.cert;

import com.custle.security.common.util.KeyFromDER;
import com.custle.security.common.util.SignatureAlgorithmConvert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class X509CertificateGenerator {
    private String issuer;
    private String subject;
    private PublicKey publicKey;
    private byte[] signData;
    private String signAlg;
    private String serialNumber;
    private Certificate certificate;
    private String base64CertString;
    private X509Certificate x509Certificate;
    private Extensions extensions;
    private int version;
    private Date notBefore;
    private Date notAfter;

    public void decode(String cert) throws CertificateException, IOException, NoSuchProviderException, NoSuchAlgorithmException {
        cert = cert.replaceAll("-----BEGIN NEW CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("-----END NEW CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("(\r\n|\r|\n|\n\r)", "");
        cert = cert.replaceAll("-----BEGIN CERTIFICATE-----", "");
        cert = cert.replaceAll("-----END CERTIFICATE-----", "");
        cert = cert.replaceAll("-----BEGIN CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("-----END CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("-----BEGINCERTIFICATE-----", "");
        cert = cert.replaceAll("-----ENDCERTIFICATE-----", "");
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)cert));
        ASN1InputStream is = new ASN1InputStream((InputStream)bais);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)is.readObject());
        this.certificate = Certificate.getInstance((Object)seq);
        this.issuer = this.certificate.getIssuer().toString();
        this.subject = this.certificate.getSubject().toString();
        this.publicKey = KeyFromDER.getPublicKeyFromCert(cert);
        this.signAlg = SignatureAlgorithmConvert.getAlgByIdentify(this.certificate.getSignatureAlgorithm());
        this.signData = this.certificate.getSignature().getBytes();
        this.serialNumber = Hex.toHexString((byte[])this.certificate.getSerialNumber().getValue().toByteArray()).toUpperCase();
        this.extensions = this.certificate.getTBSCertificate().getExtensions();
        this.version = this.certificate.getVersionNumber();
        this.notBefore = this.certificate.getStartDate().getDate();
        this.notAfter = this.certificate.getEndDate().getDate();
        this.x509Certificate = new X509CertificateObject(this.certificate);
        this.base64CertString = cert;
    }

    public String getX509CertificateExtension(String oid) throws IOException {
        ASN1Encodable obj;
        String value = null;
        if (this.extensions != null && (obj = this.extensions.getExtensionParsedValue(new ASN1ObjectIdentifier(oid))) != null) {
            value = obj.toString();
        }
        return value;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignData() {
        return this.signData;
    }

    public String getSignAlg() {
        return this.signAlg;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public String getBase64CertString() {
        return this.base64CertString;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public int getVersion() {
        return this.version;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public static String format(String cert) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----BEGIN CERTIFICATE-----").append("\n");
        int le = cert.length();
        int i = 0;
        while (i < le / 64) {
            sb.append(cert.substring(64 * i, 64 * (i + 1))).append("\n");
            if (le - 64 * (i + 1) < 64) {
                sb.append(cert.substring(64 * (i + 1), le)).append("\n");
            }
            ++i;
        }
        sb.append("-----END CERTIFICATE-----");
        cert = sb.toString();
        return cert;
    }
}

