/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.common.util;

import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;

public class X509NameUtil {
    private String cn;
    private String c;
    private String st;
    private String l;
    private String o;
    private String ou;
    private String email;
    private String dn;
    private X500Name x509Name;

    public X509NameUtil(String cn, String c, String st, String l, String o, String ou, String email) {
        this.cn = cn;
        this.c = c;
        this.st = st;
        this.l = l;
        this.o = o;
        this.ou = ou;
        this.email = email;
        StringBuffer sb = new StringBuffer();
        if (c != null && !"".equals(c)) {
            sb.append("C=").append(c.replaceAll(",", "\\\\,")).append(",");
        } else {
            sb.append("C=").append("CN,");
        }
        if (st != null && !"".equals(st)) {
            sb.append("ST=").append(st.replaceAll(",", "\\\\,")).append(",");
        }
        if (l != null && !"".equals(l)) {
            sb.append("L=").append(l.replaceAll(",", "\\\\,")).append(",");
        }
        if (o != null && !"".equals(o)) {
            sb.append("O=").append(o.replaceAll(",", "\\\\,")).append(",");
        }
        if (ou != null && !"".equals(ou)) {
            sb.append("OU=").append(ou.replaceAll(",", "\\\\,")).append(",");
        }
        if (cn != null && !"".equals(cn)) {
            sb.append("CN=").append(cn.replaceAll(",", "\\\\,")).append(",");
        }
        if (email != null && !"".equals(email)) {
            sb.append("E=").append(email.replaceAll(",", "\\\\,")).append(",");
        }
        this.dn = sb.toString().trim();
        if (this.dn.endsWith(",")) {
            this.dn = this.dn.substring(0, this.dn.length() - 1);
        }
        this.x509Name = new X500Name(this.dn);
    }

    public X509NameUtil(String dirName) {
        this.x509Name = new X500Name(dirName);
        this.dn = this.x509Name.toString();
        RDN[] rDNs = this.x509Name.getRDNs();
        int i = 0;
        while (i < rDNs.length) {
            AttributeTypeAndValue typeAndValue = rDNs[i].getFirst();
            String type = X500Name.getDefaultStyle().oidToDisplayName(typeAndValue.getType());
            if (type.equals("C")) {
                this.c = typeAndValue.getValue().toString();
            }
            if (type.equals("CN")) {
                this.cn = typeAndValue.getValue().toString();
            }
            if (type.equals("O")) {
                this.o = typeAndValue.getValue().toString();
            }
            if (type.equals("OU")) {
                this.ou = typeAndValue.getValue().toString();
            }
            if (type.equals("ST")) {
                this.st = typeAndValue.getValue().toString();
            }
            if (type.equals("L")) {
                this.l = typeAndValue.getValue().toString();
            }
            if (type.equals("E")) {
                this.email = typeAndValue.getValue().toString();
            }
            ++i;
        }
    }

    public String getDn() {
        return this.dn;
    }

    public X500Name getX509Name() {
        return this.x509Name;
    }

    public String getCn() {
        return this.cn;
    }

    public String getC() {
        return this.c;
    }

    public String getSt() {
        return this.st;
    }

    public String getL() {
        return this.l;
    }

    public String getO() {
        return this.o;
    }

    public String getOu() {
        return this.ou;
    }

    public String getEmail() {
        return this.email;
    }
}

