/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.common.util;

import com.custle.security.algorithm.Algorithms;
import com.custle.security.algorithm.imple.IAsymmAlgorithms;
import com.custle.security.common.util.KeyFromDER;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import org.bouncycastle.util.encoders.Base64;

public class SecurityHelper {
    public static boolean verifyWithCert(String signAlg, byte[] cert, byte[] inData, byte[] signData) throws SecurityException, CertificateException, IOException, NoSuchProviderException, NoSuchAlgorithmException {
        boolean ret = false;
        if (cert == null) {
            throw new SecurityException("Verify failed! The cert cann't be null!");
        }
        if (inData == null) {
            throw new SecurityException("Verify failed! The inData cann't be null!");
        }
        if (signData == null) {
            throw new SecurityException("Verify failed! The signData cann't be null!");
        }
        byte[] cert_temp = SecurityHelper.checkPEM(cert);
        String cert_pem = "";
        cert_pem = cert_temp != null ? new String(cert) : new String(Base64.encode((byte[])cert));
        byte[] signData_temp = SecurityHelper.checkPEM(signData);
        if (signData_temp != null) {
            signData = Base64.decode((byte[])signData_temp);
        }
        PublicKey pubkey = KeyFromDER.getPublicKeyFromCert(cert_pem);
        IAsymmAlgorithms asymm_alg = null;
        if (signAlg.toUpperCase().indexOf("RSA") != -1) {
            asymm_alg = Algorithms.getAsymmAlgorithms(Algorithms.provider).getRsaAlgorithms();
        } else if (signAlg.toUpperCase().indexOf("SM2") != -1) {
            asymm_alg = Algorithms.getAsymmAlgorithms(Algorithms.provider).getSM2Algorithms();
        } else {
            throw new NoSuchAlgorithmException("no such algorithm :" + signAlg);
        }
        ret = asymm_alg.externalVerify(signAlg, pubkey, signData, inData);
        return ret;
    }

    public static byte[] checkPEM(byte[] data) {
        String charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/+= \r\n-";
        int i = 0;
        while (i < data.length) {
            if (charset.indexOf(data[i]) == -1) {
                return null;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer(data.length);
        String xx = new String(data);
        int i2 = 0;
        while (i2 < xx.length()) {
            if (xx.charAt(i2) != ' ' && xx.charAt(i2) != '\r' && xx.charAt(i2) != '\n') {
                sb.append(xx.charAt(i2));
            }
            ++i2;
        }
        return sb.toString().getBytes();
    }
}

