/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.common.util;

import com.custle.security.algorithm.Algorithms;
import com.custle.security.algorithm.imple.soft.sm2.SM2PrivateKey;
import com.custle.security.algorithm.imple.soft.sm2.SM2PrivateKeyDer;
import com.custle.security.algorithm.imple.soft.sm2.SM2PublicKey;
import com.custle.security.algorithm.imple.soft.sm2.SM2PublicKeyDer;
import com.custle.security.common.util.SignatureAlgorithmConvert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.encoders.Base64;

public class KeyFromDER {
    public static RSAPrivateKey getRSAPrivateKey(String key) {
        RSAPrivateKey prikey = null;
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decode((String)key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            prikey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return prikey;
    }

    public static RSAPublicKey getRSAPublicKey(String key) {
        RSAPublicKey pubkey = null;
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode((String)key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            pubkey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return pubkey;
    }

    public static SM2PrivateKey getSM2PrivateKey(String pubKey, String priKey) {
        byte[] privateKey = SM2PrivateKeyDer.sm2PrivateKeyDerDecode(Base64.decode((String)priKey));
        byte[] publicKey = SM2PublicKeyDer.sm2PubkeyDerDecode(Base64.decode((String)pubKey));
        SM2PrivateKey prikey = new SM2PrivateKey(publicKey, privateKey);
        return prikey;
    }

    public static PublicKey getSM2PublicKey(String key) {
        byte[] publicKey = Base64.decode((String)key);
        if (publicKey.length != 64) {
            publicKey = SM2PublicKeyDer.sm2PubkeyDerDecode(publicKey);
        }
        SM2PublicKey pubkey = new SM2PublicKey(publicKey);
        return pubkey;
    }

    public static PublicKey getPublicKeyFromCert(String cert) throws NoSuchAlgorithmException, IOException, CertificateException, NoSuchProviderException {
        PublicKey pubkey = null;
        cert = cert.replaceAll("-----BEGIN NEW CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("-----END NEW CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("(\r\n|\r|\n|\n\r)", "");
        cert = cert.replaceAll("-----BEGIN CERTIFICATE-----", "");
        cert = cert.replaceAll("-----END CERTIFICATE-----", "");
        cert = cert.replaceAll("-----BEGIN CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("-----END CERTIFICATE REQUEST-----", "");
        cert = cert.replaceAll("-----BEGINCERTIFICATE-----", "");
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)(cert = cert.replaceAll("-----ENDCERTIFICATE-----", ""))));
        ASN1InputStream is = new ASN1InputStream((InputStream)bais);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)is.readObject());
        Certificate certificate = Certificate.getInstance((Object)seq);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
        String alg = SignatureAlgorithmConvert.getAlgByIdentify(subjectPublicKeyInfo.getAlgorithm());
        if (alg.equals("RSA")) {
            pubkey = KeyFromDER.getRSAPublicKeyFormSPK(subjectPublicKeyInfo);
        } else if (alg.equals("SM2") && Algorithms.provider.equals("SOFT")) {
            byte[] pk = subjectPublicKeyInfo.getPublicKeyData().getBytes();
            byte[] publicKey_XY = new byte[64];
            int i = 0;
            while (i < pk.length - 1) {
                publicKey_XY[i] = pk[i + 1];
                ++i;
            }
            pubkey = new SM2PublicKey(publicKey_XY);
        }
        return pubkey;
    }

    public static PublicKey getPublicKeyFromCert(byte[] cert) throws NoSuchAlgorithmException, IOException, CertificateException, NoSuchProviderException {
        PublicKey pubkey = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(cert);
        ASN1InputStream is = new ASN1InputStream((InputStream)bais);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)is.readObject());
        Certificate certificate = Certificate.getInstance((Object)seq);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
        String alg = SignatureAlgorithmConvert.getAlgByIdentify(subjectPublicKeyInfo.getAlgorithm());
        if (alg.equals("RSA")) {
            pubkey = KeyFromDER.getRSAPublicKeyFormSPK(subjectPublicKeyInfo);
        } else if (alg.equals("SM2") && Algorithms.provider.equals("SOFT")) {
            byte[] pk = subjectPublicKeyInfo.getPublicKeyData().getBytes();
            byte[] publicKey_XY = new byte[64];
            int i = 0;
            while (i < pk.length - 1) {
                publicKey_XY[i] = pk[i + 1];
                ++i;
            }
            pubkey = new SM2PublicKey(publicKey_XY);
        }
        return pubkey;
    }

    public static PublicKey getRSAPublicKeyFormSPK(SubjectPublicKeyInfo info) throws SecurityException {
        RSAPublicKey pubkey = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)info.parsePublicKey();
            ASN1Integer dermod = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
            BigInteger mod = dermod.getValue();
            ASN1Integer derexp = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
            BigInteger exp = derexp.getValue();
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            pubkey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        return pubkey;
    }
}

