/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Base64;
import com.custle.security.algorithm.imple.soft.sm2.SM2PublicKeyDer;
import com.custle.security.algorithm.imple.soft.sm2.SM2SignatureDer;
import com.custle.security.algorithm.imple.soft.sm2.Signature;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class VerifySignatureDer {
    public int verifySm2SignatureByPubKeyDer(byte[] sm2PublicKeyDer, byte[] sm2SignatureDer, byte[] src) {
        byte[] PublicKey_XY = SM2PublicKeyDer.sm2PubkeyDerDecode(sm2PublicKeyDer);
        byte[] signature = SM2SignatureDer.sm2SignatureDerDecode(sm2SignatureDer);
        Signature sign = new Signature();
        int result = sign.verifySm2SignatureByPubKey(PublicKey_XY, signature, src);
        return result;
    }

    public int verifySm2SignatureByCertDer(byte[] Sm2cert, byte[] sm2SignatureDer, byte[] src) throws Exception {
        byte[] Sm2cert1 = new byte[Sm2cert.length];
        Sm2cert1 = Sm2cert[0] == 48 && Sm2cert[1] == -126 ? Sm2cert : Base64.decode(Sm2cert);
        ByteArrayInputStream bIn = new ByteArrayInputStream(Sm2cert1);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        Certificate cert = Certificate.getInstance((Object)seq);
        SubjectPublicKeyInfo pukinfo = cert.getSubjectPublicKeyInfo();
        byte[] byPuk = pukinfo.getPublicKeyData().getBytes();
        byte[] PublicKey_XY = new byte[64];
        int i = 0;
        while (i < byPuk.length - 1) {
            PublicKey_XY[i] = byPuk[i + 1];
            ++i;
        }
        byte[] signature = SM2SignatureDer.sm2SignatureDerDecode(sm2SignatureDer);
        Signature sign = new Signature();
        int result = sign.verifySm2SignatureByPubKey(PublicKey_XY, signature, src);
        aIn.close();
        return result;
    }
}

