/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Base64;
import com.custle.security.algorithm.imple.soft.sm2.Constants;
import com.custle.security.algorithm.imple.soft.sm2.Cryption;
import com.custle.security.algorithm.imple.soft.sm2.ErrCode;
import com.custle.security.algorithm.imple.soft.sm2.KeyPairExt;
import com.custle.security.algorithm.imple.soft.sm2.Randoms;
import com.custle.security.algorithm.imple.soft.sm2.Signature;
import java.io.UnsupportedEncodingException;

public class Test {
    public static void main(String[] args) throws UnsupportedEncodingException, Exception {
        KeyPairExt keyPair = new KeyPairExt();
        int j = 0;
        while (j < 1) {
            Signature signature = new Signature();
            byte[] bytKeyPairRand = Randoms.getRandom();
            byte[] pubKey = keyPair.genSM2KeyPair(bytKeyPairRand);
            if (pubKey == null) {
                System.out.println("GenKeyPair Last Error:" + ErrCode.GetKeyPairLastError());
            } else {
                System.out.println("PubKey data:");
                int i = 0;
                while (i < pubKey.length) {
                    System.out.print("0x");
                    System.out.printf("%02X, ", pubKey[i] & 0xFF);
                    if ((i + 1) % 8 == 0) {
                        System.out.println("");
                    }
                    ++i;
                }
            }
            byte[] priKey = keyPair.getPrivateKey();
            System.out.println("PriKey data:");
            int i = 0;
            while (i < priKey.length) {
                System.out.print("0x");
                System.out.printf("%02X, ", priKey[i] & 0xFF);
                if ((i + 1) % 8 == 0) {
                    System.out.println("");
                }
                ++i;
            }
            String srcData = "\u8fd9\u662f\u4e2a\u6d4b\u8bd5\uff01thisistest!@#$%^&*()<>~????";
            byte[] bytSignRand = Randoms.getRandom();
            byte[] signedData = signature.sm2Sign(srcData.getBytes("GB2312"), Constants.UserID.getBytes("GB2312"), priKey, bytSignRand);
            if (signedData == null) {
                System.out.println("Sm2Sign Last Error:" + ErrCode.GetSignatureLastError());
            } else {
                System.out.println("Sm2SignData:" + Base64.encodeToString(signedData));
            }
            int iVerifyResult = signature.verifySm2SignatureByPubKey(pubKey, signedData, srcData.getBytes("GB2312"));
            System.out.println("End Verify Result:" + iVerifyResult);
            String strEncSrc = "ab";
            byte[] bytCryptRand = Randoms.getRandom();
            byte[] bytEncDst = Cryption.sm2Encrypt(strEncSrc.getBytes(), pubKey, bytCryptRand);
            if (bytEncDst == null) {
                System.out.println("SM2Encrypt Last Error:" + ErrCode.GetCryptionLastError());
            } else {
                System.out.println("SM2 encrypted data:" + Base64.encodeToString(bytEncDst));
            }
            byte[] errPriKey = new byte[32];
            int i2 = 0;
            while (i2 < 32) {
                errPriKey[i2] = 2;
                ++i2;
            }
            byte[] bytDecDst = Cryption.sm2Decrypt(bytEncDst, priKey);
            if (bytDecDst == null) {
                System.out.println("SM2Decrypt Last Error:" + ErrCode.GetCryptionLastError());
            } else {
                System.out.println("SM2 decrypted data:" + new String(bytDecDst));
            }
            ++j;
        }
    }
}

