/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Util;
import java.math.BigInteger;

public class SM3Hash {
    private static final byte[] iv = new BigInteger("7380166f4914b2b9172442d7da8a0600a96f30bc163138aae38dee4db0fb0e4e", 16).toByteArray();
    private static int[] Tj = new int[64];

    static {
        int i = 0;
        while (i < 16) {
            SM3Hash.Tj[i] = 2043430169;
            ++i;
        }
        i = 16;
        while (i < 64) {
            SM3Hash.Tj[i] = 2055708042;
            ++i;
        }
    }

    private static int FFj(int x, int y, int z, int j) {
        int temp = 0;
        if (j >= 0 && j <= 15) {
            temp = x ^ y ^ z;
        } else if (j >= 16 && j <= 63) {
            temp = x & y | x & z | y & z;
        } else {
            System.out.println("\u5165\u53c2j\u8d85\u51fa\u8303\u56f4[0,63]");
        }
        return temp;
    }

    private static int GGj(int x, int y, int z, int j) {
        int temp = 0;
        if (j >= 0 && j <= 15) {
            temp = x ^ y ^ z;
        } else if (j >= 16 && j <= 64) {
            temp = x & y | ~x & z;
        } else {
            System.out.println("\u5165\u53c2j\u8d85\u51fa\u8303\u56f4[0,63]");
        }
        return temp;
    }

    private static int P0(int X) {
        int t = X ^ SM3Hash.leftRotate(X, 9) ^ SM3Hash.leftRotate(X, 17);
        return t;
    }

    private static int P1(int X) {
        int t = X ^ SM3Hash.leftRotate(X, 15) ^ SM3Hash.leftRotate(X, 23);
        return t;
    }

    private static int leftRotate(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private static byte[] back(byte[] in) {
        byte[] temp = new byte[in.length];
        int i = 0;
        while (i < in.length) {
            temp[i] = in[in.length - 1 - i];
            ++i;
        }
        return temp;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        byte[] tmp = SM3Hash.bigEndianIntToByte(n);
        int byteLen = (bitLen %= 32) / 8;
        int len = bitLen % 8;
        if (byteLen > 0) {
            tmp = SM3Hash.byteCycleLeft(tmp, byteLen);
        }
        if (len > 0) {
            tmp = SM3Hash.bitSmall8CycleLeft(tmp, len);
        }
        return SM3Hash.bigEndianByteToInt(tmp);
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return Util.bytesToInt(SM3Hash.back(bytes));
    }

    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        int i = 0;
        while (i < tmp.length) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
            ++i;
        }
        return tmp;
    }

    private static byte[] bigEndianIntToByte(int n) {
        return SM3Hash.back(Util.intToByte(n));
    }

    private SM3Hash(byte[] msg) {
        msg = SM3Hash.padding(msg);
        msg = SM3Hash.iter(msg);
    }

    private static byte[] padding(byte[] msg) {
        int l = msg.length * 8;
        int k = 0;
        int i = 0;
        i = 0;
        while ((k = 448 + 512 * i - l) <= 0) {
            ++i;
        }
        int count = (l + k + 64) / 512;
        byte[] out = new byte[count * 64];
        byte[] add = new byte[k / 8];
        add[0] = -128;
        byte[] l_len = new byte[8];
        byte[] l_temp = Util.intToByte(l);
        System.arraycopy(l_temp, 0, l_len, l_len.length - 4, l_temp.length);
        System.arraycopy(msg, 0, out, 0, msg.length);
        System.arraycopy(add, 0, out, msg.length, add.length);
        System.arraycopy(l_len, 0, out, out.length - 8, l_len.length);
        return out;
    }

    private static byte[] iter(byte[] msg) {
        byte[] v = new byte[64];
        byte[] b = new byte[64];
        int n = msg.length / 64;
        System.arraycopy(msg, 0, b, 0, 64);
        v = SM3Hash.CF(iv, b);
        if (n > 1) {
            int i = 1;
            while (i < n) {
                System.arraycopy(msg, 64 * i, b, 0, 64);
                v = SM3Hash.CF(v, b);
                ++i;
            }
        }
        return v;
    }

    private static byte[] CF(byte[] vv, byte[] b) {
        int[] w = new int[68];
        int[] w1 = new int[64];
        int[] v = new int[8];
        byte[] temp = new byte[4];
        int i = 0;
        while (i < 8) {
            System.arraycopy(vv, 4 * i, temp, 0, 4);
            v[i] = Util.bigBytesToInt(temp);
            ++i;
        }
        i = 0;
        while (i < 16) {
            System.arraycopy(b, 4 * i, temp, 0, 4);
            w[i] = Util.bigBytesToInt(temp);
            ++i;
        }
        int j = 16;
        while (j < 68) {
            w[j] = SM3Hash.P1(w[j - 16] ^ w[j - 9] ^ SM3Hash.leftRotate(w[j - 3], 15)) ^ SM3Hash.leftRotate(w[j - 13], 7) ^ w[j - 6];
            ++j;
        }
        j = 0;
        while (j < 64) {
            w1[j] = w[j] ^ w[j + 4];
            ++j;
        }
        int A = v[0];
        int B = v[1];
        int C = v[2];
        int D = v[3];
        int E = v[4];
        int F = v[5];
        int G = v[6];
        int H = v[7];
        int i2 = 0;
        while (i2 < 64) {
            int SS1 = SM3Hash.leftRotate(A, 12) + E + SM3Hash.leftRotate(Tj[i2], i2);
            SS1 = SM3Hash.leftRotate(SS1, 7);
            int SS2 = SS1 ^ SM3Hash.leftRotate(A, 12);
            int TT1 = SM3Hash.FFj(A, B, C, i2) + D + SS2 + w1[i2];
            int TT2 = SM3Hash.GGj(E, F, G, i2) + H + SS1 + w[i2];
            D = C;
            C = SM3Hash.leftRotate(B, 9);
            B = A;
            A = TT1;
            H = G;
            G = SM3Hash.leftRotate(F, 19);
            F = E;
            E = SM3Hash.P0(TT2);
            ++i2;
        }
        StringBuffer ABCDEFGH = new StringBuffer();
        int[] V = new int[]{A, B, C, D, E, F, G, H};
        int j2 = 0;
        while (j2 < 8) {
            V[j2] = V[j2] ^ v[j2];
            ++j2;
        }
        String[] strResult = new String[8];
        int j3 = 0;
        while (j3 < 8) {
            strResult[j3] = Integer.toHexString(V[j3]);
            if (strResult[j3].length() == 7) {
                strResult[j3] = "0" + strResult[j3];
            }
            if (strResult[j3].length() == 6) {
                strResult[j3] = "00" + strResult[j3];
            }
            if (strResult[j3].length() == 5) {
                strResult[j3] = "000" + strResult[j3];
            }
            if (strResult[j3].length() == 4) {
                strResult[j3] = "0000" + strResult[j3];
            }
            if (strResult[j3].length() == 3) {
                strResult[j3] = "00000" + strResult[j3];
            }
            if (strResult[j3].length() == 2) {
                strResult[j3] = "000000" + strResult[j3];
            }
            if (strResult[j3].length() == 1) {
                strResult[j3] = "0000000" + strResult[j3];
            }
            if (strResult[j3].length() == 0) {
                strResult[j3] = "00000000" + strResult[j3];
            }
            ++j3;
        }
        ABCDEFGH.append(strResult[0]).append(strResult[1]).append(strResult[2]).append(strResult[3]).append(strResult[4]).append(strResult[5]).append(strResult[6]).append(strResult[7]);
        return Util.stringToByteArray(ABCDEFGH.toString());
    }

    public static byte[] getHashValue(byte[] msg) {
        msg = SM3Hash.padding(msg);
        msg = SM3Hash.iter(msg);
        return msg;
    }

    public static void main(String[] args) {
        byte[] byt = "abc".getBytes();
        System.out.println("InData:" + Util.toHexString(byt));
        byte[] hashValue = SM3Hash.getHashValue(byt);
        System.out.println("HashValue:" + Util.toHexString(hashValue));
    }
}

