/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.SM2Signature;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Integer;

public class SM2SignatureDer {
    static int intr = 0;
    static int ints = 0;
    static int inttr = 0;
    static int intts = 0;

    public static byte[] sm2SignatureDerEncode(byte[] signature_RS) {
        int i;
        byte[] byte_r = new byte[32];
        byte[] byte_s = new byte[32];
        System.arraycopy(signature_RS, 0, byte_r, 0, 32);
        System.arraycopy(signature_RS, 32, byte_s, 0, 32);
        inttr = byte_r[0] < 0 ? 35 : 34;
        intts = byte_s[0] < 0 ? 35 : 34;
        byte[] byte_Der_r = new byte[inttr];
        byte[] byte_Der_s = new byte[intts];
        byte[] byte_Der_SM2Signature = new byte[inttr + intts + 2];
        if (inttr == 35) {
            byte_Der_r[0] = 2;
            byte_Der_r[1] = 33;
            byte_Der_r[2] = 0;
            i = 0;
            while (i < byte_r.length) {
                byte_Der_r[i + 3] = byte_r[i];
                ++i;
            }
        } else {
            byte_Der_r[0] = 2;
            byte_Der_r[1] = 32;
            i = 0;
            while (i < byte_r.length) {
                byte_Der_r[i + 2] = byte_r[i];
                ++i;
            }
        }
        if (intts == 35) {
            byte_Der_s[0] = 2;
            byte_Der_s[1] = 33;
            byte_Der_s[2] = 0;
            i = 0;
            while (i < byte_s.length) {
                byte_Der_s[i + 3] = byte_s[i];
                ++i;
            }
        } else {
            byte_Der_s[0] = 2;
            byte_Der_s[1] = 32;
            i = 0;
            while (i < byte_s.length) {
                byte_Der_s[i + 2] = byte_s[i];
                ++i;
            }
        }
        byte_Der_SM2Signature[1] = inttr == 34 & intts == 34 ? 68 : (inttr == 35 & intts == 34 ? 69 : (inttr == 34 & intts == 35 ? 69 : 70));
        byte_Der_SM2Signature[0] = 48;
        System.arraycopy(byte_Der_r, 0, byte_Der_SM2Signature, 2, byte_Der_r.length);
        System.arraycopy(byte_Der_s, 0, byte_Der_SM2Signature, 2 + byte_Der_r.length, byte_Der_s.length);
        inttr = 0;
        intts = 0;
        return byte_Der_SM2Signature;
    }

    public static byte[] sm2SignatureDerEncode(BigInteger r, BigInteger s) {
        byte[] byte_r = r.toByteArray();
        byte[] byte_s = s.toByteArray();
        int i = 0;
        while (i < byte_r.length) {
            ++intr;
            ++i;
        }
        intr += 2;
        i = 0;
        while (i < byte_s.length) {
            ++ints;
            ++i;
        }
        byte[] byte_Der_r = new byte[intr];
        byte[] byte_Der_s = new byte[ints += 2];
        byte[] byte_Der_SM2Signature = new byte[intr + ints + 2];
        intr = 0;
        ints = 0;
        byte_Der_r[1] = byte_r.length == 33 ? 33 : 32;
        byte_Der_r[0] = 2;
        int i2 = 0;
        while (i2 < byte_r.length) {
            byte_Der_r[i2 + 2] = byte_r[i2];
            ++i2;
        }
        byte_Der_s[1] = byte_s.length == 33 ? 33 : 32;
        byte_Der_s[0] = 2;
        i2 = 0;
        while (i2 < byte_s.length) {
            byte_Der_s[i2 + 2] = byte_s[i2];
            ++i2;
        }
        if (byte_Der_r[1] == 32 & byte_Der_s[1] == 32) {
            byte_Der_SM2Signature[0] = 48;
            byte_Der_SM2Signature[1] = 68;
            i2 = 0;
            while (i2 < byte_Der_r.length) {
                byte_Der_SM2Signature[i2 + 2] = byte_Der_r[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < byte_Der_s.length) {
                byte_Der_SM2Signature[i2 + byte_Der_r.length + 2] = byte_Der_s[i2];
                ++i2;
            }
        }
        if (byte_Der_r[1] == 33 & byte_Der_s[1] == 33) {
            byte_Der_SM2Signature[0] = 48;
            byte_Der_SM2Signature[1] = 70;
            i2 = 0;
            while (i2 < byte_Der_r.length) {
                byte_Der_SM2Signature[i2 + 2] = byte_Der_r[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < byte_Der_s.length) {
                byte_Der_SM2Signature[i2 + byte_Der_r.length + 2] = byte_Der_s[i2];
                ++i2;
            }
        }
        if (byte_Der_r[1] == 32 & byte_Der_s[1] == 33) {
            byte_Der_SM2Signature[0] = 48;
            byte_Der_SM2Signature[1] = 69;
            i2 = 0;
            while (i2 < byte_Der_r.length) {
                byte_Der_SM2Signature[i2 + 2] = byte_Der_r[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < byte_Der_s.length) {
                byte_Der_SM2Signature[i2 + byte_Der_r.length + 2] = byte_Der_s[i2];
                ++i2;
            }
        }
        if (byte_Der_r[1] == 33 & byte_Der_s[1] == 32) {
            byte_Der_SM2Signature[0] = 48;
            byte_Der_SM2Signature[1] = 69;
            i2 = 0;
            while (i2 < byte_Der_r.length) {
                byte_Der_SM2Signature[i2 + 2] = byte_Der_r[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < byte_Der_s.length) {
                byte_Der_SM2Signature[i2 + byte_Der_r.length + 2] = byte_Der_s[i2];
                ++i2;
            }
        }
        return byte_Der_SM2Signature;
    }

    public static byte[] sm2SignatureDerDecode(byte[] derSig) {
        byte[] Signature_RS = new byte[64];
        SM2Signature sm2Signature = SM2Signature.getInstance(derSig);
        byte[] r = SM2SignatureDer.getByteFromInteger(sm2Signature.getR());
        byte[] s = SM2SignatureDer.getByteFromInteger(sm2Signature.getS());
        if (r != null && s != null) {
            System.arraycopy(r, 0, Signature_RS, 0, 32);
            System.arraycopy(s, 0, Signature_RS, 32, 32);
        } else {
            Signature_RS = null;
        }
        return Signature_RS;
    }

    private static byte[] getByteFromInteger(ASN1Integer asn1Integer) {
        byte[] result = new byte[32];
        try {
            byte[] bb = asn1Integer.getEncoded();
            if (bb.length == 33) {
                System.arraycopy(bb, 2, result, 1, 31);
            } else if (bb.length == 34) {
                System.arraycopy(bb, 2, result, 0, 32);
            } else if (bb.length == 35) {
                System.arraycopy(bb, 3, result, 0, 32);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }
}

