/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SM2Cipher
extends ASN1Object {
    private ASN1Integer x;
    private ASN1Integer y;
    private ASN1OctetString hash;
    private ASN1OctetString cipher;
    private byte[] encryptData;

    public SM2Cipher(byte[] encryptData) {
        this.encryptData = encryptData;
        this.encode();
    }

    private SM2Cipher(ASN1Sequence seq) {
        if (seq.size() != 4) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.x = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
        this.y = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
        this.hash = ASN1OctetString.getInstance((Object)seq.getObjectAt(2));
        this.cipher = ASN1OctetString.getInstance((Object)seq.getObjectAt(3));
    }

    public static SM2Cipher getInstance(Object o) {
        if (o instanceof SM2Cipher) {
            return (SM2Cipher)((Object)o);
        }
        if (o != null) {
            return new SM2Cipher(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public boolean encode() {
        if (this.encryptData.length <= 97) {
            return false;
        }
        byte[] XCoordinate = new byte[32];
        System.arraycopy(this.encryptData, 1, XCoordinate, 0, 32);
        byte[] YCoordinate = new byte[32];
        System.arraycopy(this.encryptData, 33, YCoordinate, 0, 32);
        byte[] C3_hash = new byte[32];
        System.arraycopy(this.encryptData, 65, C3_hash, 0, 32);
        byte[] C2_cipher = new byte[this.encryptData.length - 97];
        System.arraycopy(this.encryptData, 97, C2_cipher, 0, C2_cipher.length);
        this.x = new ASN1Integer(XCoordinate);
        this.y = new ASN1Integer(YCoordinate);
        this.hash = new DEROctetString(C3_hash);
        this.cipher = new DEROctetString(C2_cipher);
        return true;
    }

    public byte[] decode() {
        byte[] bx = this.x.getValue().toByteArray();
        byte[] by = this.y.getValue().toByteArray();
        byte[] bhash = this.hash.getOctets();
        byte[] bcipher = this.cipher.getOctets();
        this.encryptData = new byte[97 + bcipher.length];
        this.encryptData[0] = 4;
        System.arraycopy(bx, bx.length - 32, this.encryptData, 1, 32);
        System.arraycopy(by, 0, this.encryptData, 33, by.length);
        System.arraycopy(bhash, 0, this.encryptData, 33 + by.length, bhash.length);
        System.arraycopy(bcipher, 0, this.encryptData, 33 + by.length + bhash.length, bcipher.length);
        return this.encryptData;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.x);
        v.add((ASN1Encodable)this.y);
        v.add((ASN1Encodable)this.hash);
        v.add((ASN1Encodable)this.cipher);
        return new DERSequence(v);
    }

    public ASN1Integer getX() {
        return this.x;
    }

    public void setX(ASN1Integer x) {
        this.x = x;
    }

    public ASN1Integer getY() {
        return this.y;
    }

    public void setY(ASN1Integer y) {
        this.y = y;
    }

    public ASN1OctetString getHash() {
        return this.hash;
    }

    public void setHash(ASN1OctetString hash) {
        this.hash = hash;
    }

    public ASN1OctetString getCipher() {
        return this.cipher;
    }

    public void setCipher(ASN1OctetString cipher) {
        this.cipher = cipher;
    }
}

