/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft;

import com.custle.security.algorithm.imple.ISymmAlgorithms;
import com.custle.security.algorithm.imple.soft.sm2.SMS4;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SoftSM4
implements ISymmAlgorithms {
    private static final int ENCRYPT = 1;
    private static final int DECRYPT = 0;

    public byte[] cryptionCbcNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            outData = sm4.sms4_cbc(inData, key, parameter, 1);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionCbcPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            inData = SMS4.addPadding(inData);
            outData = sm4.sms4_cbc(inData, key, parameter, 1);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionCfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] cryptionCfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] cryptionEcbNoPadding(byte[] inData, byte[] key) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            outData = sm4.sms4_ecb(inData, key, 1);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionEcbPadding(byte[] inData, byte[] key) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            inData = SMS4.addPadding(inData);
            outData = sm4.sms4_ecb(inData, key, 1);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionOfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] cryptionOfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptCbcNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            outData = sm4.sms4_cbc(inData, key, parameter, 0);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptCbcPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            outData = sm4.sms4_cbc(inData, key, parameter, 0);
            outData = SMS4.rmvPadding(outData);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptCfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptCfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptEcbNoPadding(byte[] inData, byte[] key) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            outData = sm4.sms4_ecb(inData, key, 0);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptEcbPadding(byte[] inData, byte[] key) throws SecurityException {
        SMS4 sm4 = new SMS4();
        byte[] outData = null;
        try {
            outData = sm4.sms4_ecb(inData, key, 0);
            outData = SMS4.rmvPadding(outData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptOfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptOfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] getSecretKey(int length) throws SecurityException {
        SecretKey key = null;
        try {
            KeyGenerator skg = KeyGenerator.getInstance("AES");
            skg.init(length);
            key = skg.generateKey();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return "1234567812345678".getBytes();
    }
}

