/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft;

import com.custle.security.algorithm.imple.IAsymmAlgorithms;
import com.custle.security.algorithm.imple.soft.SoftDESede;
import com.custle.security.algorithm.imple.soft.key.Keyinfo;
import com.custle.security.algorithm.imple.soft.key.SoftKeyinfoDAO;
import com.custle.security.algorithm.imple.soft.sm2.Constants;
import com.custle.security.algorithm.imple.soft.sm2.Cryption;
import com.custle.security.algorithm.imple.soft.sm2.KeyPairExt;
import com.custle.security.algorithm.imple.soft.sm2.Randoms;
import com.custle.security.algorithm.imple.soft.sm2.SM2Cipher;
import com.custle.security.algorithm.imple.soft.sm2.SM2PrivateKey;
import com.custle.security.algorithm.imple.soft.sm2.SM2PrivateKeyDer;
import com.custle.security.algorithm.imple.soft.sm2.SM2PublicKey;
import com.custle.security.algorithm.imple.soft.sm2.SM2PublicKeyDer;
import com.custle.security.algorithm.imple.soft.sm2.SM2SignatureDer;
import com.custle.security.algorithm.imple.soft.sm2.Signature;
import com.custle.security.algorithm.imple.soft.sm2.VerifySignatureDer;
import com.custle.security.common.util.KeyFromDER;
import com.custle.security.common.util.RandomTool;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import org.bouncycastle.util.encoders.Base64;

public class SoftSM2
implements IAsymmAlgorithms {
    private static HashMap<Integer, KeyPair> sm2KeyMap = new HashMap();
    private static String key_factor = "123erfcw";

    public KeyPair generateExternalKeyPairs(int keylength) throws SecurityException {
        KeyPair kp = null;
        try {
            kp = this.genExternalKeyPairs(keylength);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return kp;
    }

    public PublicKey generateInternalKeyPairs(int keyindex, int keylength) throws SecurityException {
        KeyPair keypair;
        PublicKey pubkey;
        block3: {
            pubkey = null;
            keypair = null;
            try {
                keypair = this.genInternalKeyPairs(keyindex, keylength);
                if (keypair != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException(e.getMessage());
            }
        }
        pubkey = keypair.getPublic();
        return pubkey;
    }

    public byte[] externalPublicKeyEnc(PublicKey pubkey, byte[] data) throws SecurityException {
        byte[] r = null;
        try {
            byte[] pubKey = SM2PublicKeyDer.sm2PubkeyDerDecode(pubkey.getEncoded());
            byte[] bytCryptRand = Randoms.getRandom();
            r = Cryption.sm2Encrypt(data, pubKey, bytCryptRand);
            SM2Cipher sm2Cipher = new SM2Cipher(r);
            return sm2Cipher.getEncoded();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
    }

    public byte[] externalPrivateKeyDec(PrivateKey prikey, byte[] data) throws SecurityException {
        byte[] r = null;
        try {
            byte[] pk = SM2PrivateKeyDer.sm2PrivateKeyDerDecode(prikey.getEncoded());
            r = Cryption.sm2Decrypt(SM2Cipher.getInstance(data).decode(), pk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        return r;
    }

    public byte[] internalPublicKeyEnc(int keyindex, int keylength, byte[] data) throws SecurityException {
        byte[] r = null;
        KeyPair kp = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            byte[] pubKey = SM2PublicKeyDer.sm2PubkeyDerDecode(kp.getPublic().getEncoded());
            byte[] bytCryptRand = Randoms.getRandom();
            r = Cryption.sm2Encrypt(data, pubKey, bytCryptRand);
            SM2Cipher sm2Cipher = new SM2Cipher(r);
            return sm2Cipher.getEncoded();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
    }

    public byte[] internalPrivateKeyDec(int keyindex, int keylength, byte[] data) throws SecurityException {
        byte[] r = null;
        KeyPair kp = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            byte[] priKey = SM2PrivateKeyDer.sm2PrivateKeyDerDecode(kp.getPrivate().getEncoded());
            r = Cryption.sm2Decrypt(SM2Cipher.getInstance(data).decode(), priKey);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return r;
    }

    public byte[] internalPrivateKeyEnc(int keyindex, int keylength, byte[] data, String mode) throws SecurityException {
        return null;
    }

    public byte[] internalSign(String algtype, int keyindex, int keylength, byte[] data) throws SecurityException {
        byte[] result = null;
        KeyPair kp = null;
        Signature signature = new Signature();
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            byte[] priKey = SM2PrivateKeyDer.sm2PrivateKeyDerDecode(kp.getPrivate().getEncoded());
            byte[] bytSignRand = Randoms.getRandom();
            result = signature.sm2Sign(data, Constants.UserID.getBytes("GB2312"), priKey, bytSignRand);
            result = SM2SignatureDer.sm2SignatureDerEncode(result);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public boolean internalVerify(String algtype, int keyindex, int keylength, byte[] signdata, byte[] indata) throws SecurityException {
        boolean ret = false;
        KeyPair kp = null;
        VerifySignatureDer signature = new VerifySignatureDer();
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            int iVerifyResult = signature.verifySm2SignatureByPubKeyDer(kp.getPublic().getEncoded(), signdata, indata);
            if (iVerifyResult == 0) {
                ret = true;
            } else {
                System.out.println("Verify Result:" + iVerifyResult);
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return ret;
    }

    public boolean externalVerify(String algtype, PublicKey pubkey, byte[] signdata, byte[] indata) throws SecurityException {
        boolean ret = false;
        VerifySignatureDer signature = new VerifySignatureDer();
        try {
            int iVerifyResult = signature.verifySm2SignatureByPubKeyDer(pubkey.getEncoded(), signdata, indata);
            if (iVerifyResult == 0) {
                ret = true;
            } else {
                System.out.println("Verify Result:" + iVerifyResult);
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return ret;
    }

    public PublicKey getPublicKey(int keyindex, int keylength) throws SecurityException {
        PublicKey pubkey = null;
        KeyPair kp = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            pubkey = kp.getPublic();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return pubkey;
    }

    public byte[] externalSign(String algtype, PrivateKey prikey, byte[] data) throws SecurityException {
        byte[] result = null;
        Signature signature = new Signature();
        try {
            byte[] priKey = SM2PrivateKeyDer.sm2PrivateKeyDerDecode(prikey.getEncoded());
            byte[] bytSignRand = Randoms.getRandom();
            result = signature.sm2Sign(data, Constants.UserID.getBytes("GB2312"), priKey, bytSignRand);
            result = SM2SignatureDer.sm2SignatureDerEncode(result);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    private KeyPair genExternalKeyPairs(int length) throws SecurityException {
        SM2PublicKey publicKey;
        KeyPairExt keyPair;
        KeyPair kp;
        block3: {
            kp = null;
            try {
                keyPair = new KeyPairExt();
                byte[] bytKeyPairRand = Randoms.getRandom();
                publicKey = keyPair.genSM2KeyPairDer(bytKeyPairRand);
                if (publicKey != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        }
        SM2PrivateKey privateKey = keyPair.getPrivateKeyDer();
        kp = new KeyPair(publicKey, privateKey);
        return kp;
    }

    private KeyPair genInternalKeyPairs(int keyindex, int keylength) throws SecurityException {
        SM2PublicKey publicKey;
        KeyPairExt keyPair;
        SoftKeyinfoDAO dao;
        KeyPair kp;
        block6: {
            kp = null;
            dao = SoftKeyinfoDAO.getInstance();
            try {
                keyPair = new KeyPairExt();
                byte[] bytKeyPairRand = Randoms.getRandom();
                publicKey = keyPair.genSM2KeyPairDer(bytKeyPairRand);
                if (publicKey != null) break block6;
                return null;
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        }
        SM2PrivateKey privateKey = keyPair.getPrivateKeyDer();
        kp = new KeyPair(publicKey, privateKey);
        String publickey = new String(Base64.encode((byte[])kp.getPublic().getEncoded()));
        String key = RandomTool.generateRandomAlphanumeric(16);
        String enckey = String.valueOf(key) + key_factor;
        byte[] encdata = new SoftDESede().cryptionEcbPadding(kp.getPrivate().getEncoded(), enckey.getBytes());
        String privatekey = new String(Base64.encode((byte[])encdata));
        boolean ret = false;
        Keyinfo keyinfo = dao.getKeyinfo(keyindex, "SM2");
        if (keyinfo != null) {
            keyinfo.setKeylength(keylength);
            keyinfo.setPublickey(publickey);
            keyinfo.setPrivatekey(privatekey);
            keyinfo.setKey(key);
            ret = dao.updateKeyinfo(keyinfo);
        } else {
            keyinfo = new Keyinfo();
            keyinfo.setKeyalg("SM2");
            keyinfo.setKeyindex(keyindex);
            keyinfo.setKeylength(keylength);
            keyinfo.setPublickey(publickey);
            keyinfo.setPrivatekey(privatekey);
            keyinfo.setKey(key);
            ret = dao.addKeyinfo(keyinfo);
        }
        if (!ret) {
            throw new SecurityException("save or update keyinfo error");
        }
        sm2KeyMap.put(new Integer(keyindex), kp);
        return kp;
    }

    private KeyPair getInternalKeyPairs(int keyindex) {
        KeyPair kp = sm2KeyMap.get(new Integer(keyindex));
        if (kp != null) {
            return kp;
        }
        SoftKeyinfoDAO dao = SoftKeyinfoDAO.getInstance();
        try {
            Keyinfo keyinfo = dao.getKeyinfo(keyindex, "SM2");
            if (keyinfo != null) {
                String publickey = keyinfo.getPublickey();
                String encdata = keyinfo.getPrivatekey();
                String enckey = String.valueOf(keyinfo.getKey()) + key_factor;
                byte[] ret = new SoftDESede().decryptEcbPadding(Base64.decode((String)encdata), enckey.getBytes());
                String privatekey = new String(Base64.encode((byte[])ret));
                PublicKey pubkey = KeyFromDER.getSM2PublicKey(publickey);
                SM2PrivateKey prikey = KeyFromDER.getSM2PrivateKey(publickey, privatekey);
                kp = new KeyPair(pubkey, prikey);
                sm2KeyMap.put(new Integer(keyindex), kp);
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return kp;
    }

    public boolean importInternalKeyPairs(String p12, String pin, int keyindex, int keylength) throws SecurityException {
        return false;
    }

    public boolean verifyInternalCert(String cert, int keyindex, int keylength) throws SecurityException {
        String algtype = "SM3withSM2";
        String data = "thisistest";
        boolean ret = false;
        try {
            byte[] signdata = this.internalSign(algtype, keyindex, keylength, data.getBytes());
            PublicKey pubkey = KeyFromDER.getPublicKeyFromCert(cert);
            ret = this.externalVerify(algtype, pubkey, signdata, data.getBytes());
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return ret;
    }
}

