/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft;

import com.custle.security.algorithm.imple.IAsymmAlgorithms;
import com.custle.security.algorithm.imple.soft.SoftDESede;
import com.custle.security.algorithm.imple.soft.key.Keyinfo;
import com.custle.security.algorithm.imple.soft.key.SoftKeyinfoDAO;
import com.custle.security.common.util.KeyFromDER;
import com.custle.security.common.util.RandomTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.HashMap;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;

public class SoftRSA
implements IAsymmAlgorithms {
    private static HashMap<Integer, KeyPair> rsaKeyMap = new HashMap();
    private static String key_factor = "123erfcw";

    public KeyPair generateExternalKeyPairs(int keylength) throws SecurityException {
        KeyPair kp = null;
        try {
            kp = this.genExternalKeyPairs(keylength);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return kp;
    }

    public PublicKey generateInternalKeyPairs(int keyindex, int keylength) throws SecurityException {
        KeyPair keypair;
        PublicKey pubkey;
        block3: {
            pubkey = null;
            keypair = null;
            try {
                keypair = this.genInternalKeyPairs(keyindex, keylength);
                if (keypair != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException(e.getMessage());
            }
        }
        pubkey = keypair.getPublic();
        return pubkey;
    }

    public byte[] externalPublicKeyEnc(PublicKey pubkey, byte[] data) throws SecurityException {
        byte[] r = null;
        Cipher cp = null;
        String transformation = "RSA/ECB/PKCS1Padding";
        try {
            cp = Cipher.getInstance(transformation);
            cp.init(1, pubkey);
            int keylength = ((RSAPublicKey)pubkey).getModulus().bitLength();
            int MAX_ENCRYPT_BLOCK = keylength / 8 - 11;
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > MAX_ENCRYPT_BLOCK ? cp.doFinal(data, offSet, MAX_ENCRYPT_BLOCK) : cp.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * MAX_ENCRYPT_BLOCK;
            }
            r = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return r;
    }

    public byte[] externalPrivateKeyDec(PrivateKey prikey, byte[] data) throws SecurityException {
        byte[] r = null;
        Cipher cp = null;
        String transformation = "RSA/ECB/PKCS1Padding";
        try {
            cp = Cipher.getInstance(transformation);
            cp.init(2, prikey);
            int keylength = ((RSAPrivateKey)prikey).getModulus().bitLength();
            int MAX_DECRYPT_BLOCK = keylength / 8;
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > MAX_DECRYPT_BLOCK ? cp.doFinal(data, offSet, MAX_DECRYPT_BLOCK) : cp.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * MAX_DECRYPT_BLOCK;
            }
            r = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return r;
    }

    public byte[] internalPublicKeyEnc(int keyindex, int keylength, byte[] data) throws SecurityException {
        byte[] r = null;
        Cipher cp = null;
        String transformation = "RSA/ECB/PKCS1Padding";
        KeyPair kp = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            cp = Cipher.getInstance(transformation);
            cp.init(1, kp.getPublic());
            int MAX_ENCRYPT_BLOCK = keylength / 8 - 11;
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > MAX_ENCRYPT_BLOCK ? cp.doFinal(data, offSet, MAX_ENCRYPT_BLOCK) : cp.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * MAX_ENCRYPT_BLOCK;
            }
            r = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return r;
    }

    public byte[] internalPrivateKeyDec(int keyindex, int keylength, byte[] data) throws SecurityException {
        byte[] result = null;
        Cipher cp = null;
        String transformation = "RSA/ECB/PKCS1Padding";
        KeyPair kp = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            cp = Cipher.getInstance(transformation);
            cp.init(2, kp.getPrivate());
            int MAX_DECRYPT_BLOCK = keylength / 8;
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > MAX_DECRYPT_BLOCK ? cp.doFinal(data, offSet, MAX_DECRYPT_BLOCK) : cp.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * MAX_DECRYPT_BLOCK;
            }
            result = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public byte[] internalPrivateKeyEnc(int keyindex, int keylength, byte[] data, String mode) throws SecurityException {
        byte[] result = null;
        Cipher cp = null;
        String transformation = "RSA/ECB/PKCS1Padding";
        if (mode != null && !"".equals(mode)) {
            transformation = mode;
        }
        KeyPair kp = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            cp = Cipher.getInstance(transformation);
            cp.init(1, kp.getPrivate());
            int MAX_ENCRYPT_BLOCK = keylength / 8 - 11;
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > MAX_ENCRYPT_BLOCK ? cp.doFinal(data, offSet, MAX_ENCRYPT_BLOCK) : cp.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * MAX_ENCRYPT_BLOCK;
            }
            result = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public byte[] internalSign(String algtype, int keyindex, int keylength, byte[] data) throws SecurityException {
        byte[] result = null;
        KeyPair kp = null;
        Signature signatue = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            PrivateKey privateKey = kp.getPrivate();
            signatue = Signature.getInstance(algtype);
            signatue.initSign(privateKey);
            signatue.update(data);
            result = signatue.sign();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public boolean internalVerify(String algtype, int keyindex, int keylength, byte[] signdata, byte[] indata) throws SecurityException {
        boolean ret = false;
        KeyPair kp = null;
        Signature signatue = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            PublicKey publicKey = kp.getPublic();
            signatue = Signature.getInstance(algtype);
            signatue.initVerify(publicKey);
            signatue.update(indata);
            ret = signatue.verify(signdata);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return ret;
    }

    public boolean externalVerify(String algtype, PublicKey pubkey, byte[] signdata, byte[] indata) throws SecurityException {
        boolean ret = false;
        Signature signatue = null;
        try {
            signatue = Signature.getInstance(algtype);
            signatue.initVerify(pubkey);
            signatue.update(indata);
            ret = signatue.verify(signdata);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage());
        }
        return ret;
    }

    public PublicKey getPublicKey(int keyindex, int keylength) throws SecurityException {
        PublicKey pubkey = null;
        KeyPair kp = null;
        try {
            kp = this.getInternalKeyPairs(keyindex);
            if (kp == null) {
                throw new SecurityException("keyindex " + keyindex + " is null");
            }
            pubkey = kp.getPublic();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return pubkey;
    }

    public byte[] externalSign(String algtype, PrivateKey prikey, byte[] data) throws SecurityException {
        byte[] result = null;
        Signature signatue = null;
        try {
            signatue = Signature.getInstance(algtype);
            signatue.initSign(prikey);
            signatue.update(data);
            result = signatue.sign();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    private KeyPair genExternalKeyPairs(int length) throws SecurityException {
        KeyPair kp = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(length);
            kp = kpg.genKeyPair();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return kp;
    }

    private KeyPair genInternalKeyPairs(int keyindex, int keylength) throws SecurityException {
        KeyPair kp = null;
        SoftKeyinfoDAO dao = SoftKeyinfoDAO.getInstance();
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(keylength);
            kp = kpg.genKeyPair();
            String publickey = new String(Base64.encode((byte[])kp.getPublic().getEncoded()));
            String key = RandomTool.generateRandomAlphanumeric(16);
            String enckey = String.valueOf(key) + key_factor;
            byte[] encdata = new SoftDESede().cryptionEcbPadding(kp.getPrivate().getEncoded(), enckey.getBytes());
            String privatekey = new String(Base64.encode((byte[])encdata));
            boolean ret = false;
            Keyinfo keyinfo = dao.getKeyinfo(keyindex, "RSA");
            if (keyinfo != null) {
                keyinfo.setKeylength(keylength);
                keyinfo.setPublickey(publickey);
                keyinfo.setPrivatekey(privatekey);
                keyinfo.setKey(key);
                ret = dao.updateKeyinfo(keyinfo);
            } else {
                keyinfo = new Keyinfo();
                keyinfo.setKeyalg("RSA");
                keyinfo.setKeyindex(keyindex);
                keyinfo.setKeylength(keylength);
                keyinfo.setPublickey(publickey);
                keyinfo.setPrivatekey(privatekey);
                keyinfo.setKey(key);
                ret = dao.addKeyinfo(keyinfo);
            }
            if (!ret) {
                throw new SecurityException("save or update keyinfo error");
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        rsaKeyMap.put(new Integer(keyindex), kp);
        return kp;
    }

    private KeyPair getInternalKeyPairs(int keyindex) {
        KeyPair kp = rsaKeyMap.get(new Integer(keyindex));
        if (kp != null) {
            return kp;
        }
        SoftKeyinfoDAO dao = SoftKeyinfoDAO.getInstance();
        try {
            Keyinfo keyinfo = dao.getKeyinfo(keyindex, "RSA");
            if (keyinfo != null) {
                String publickey = keyinfo.getPublickey();
                String encdata = keyinfo.getPrivatekey();
                String enckey = String.valueOf(keyinfo.getKey()) + key_factor;
                byte[] ret = new SoftDESede().decryptEcbPadding(Base64.decode((String)encdata), enckey.getBytes());
                String privatekey = new String(Base64.encode((byte[])ret));
                RSAPublicKey pubkey = KeyFromDER.getRSAPublicKey(publickey);
                RSAPrivateKey prikey = KeyFromDER.getRSAPrivateKey(privatekey);
                kp = new KeyPair(pubkey, prikey);
                rsaKeyMap.put(new Integer(keyindex), kp);
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return kp;
    }

    public boolean importInternalKeyPairs(String p12, String pin, int keyindex, int keylength) throws SecurityException {
        SoftKeyinfoDAO dao = SoftKeyinfoDAO.getInstance();
        boolean ret = false;
        try {
            byte[] pksc12 = Base64.decode((String)p12);
            ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(pksc12);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(tInputStringStream, pin.toCharArray());
            String keyalias = "";
            Enumeration<String> enu = keyStore.aliases();
            if (enu.hasMoreElements()) {
                keyalias = enu.nextElement();
            }
            PrivateKey prikey = (PrivateKey)keyStore.getKey(keyalias, pin.toCharArray());
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyalias);
            String key = RandomTool.generateRandomAlphanumeric(16);
            String enckey = String.valueOf(key) + key_factor;
            byte[] encdata = new SoftDESede().cryptionEcbPadding(prikey.getEncoded(), enckey.getBytes());
            String privatekey = new String(Base64.encode((byte[])encdata));
            String publickey = new String(Base64.encode((byte[])cert.getPublicKey().getEncoded()));
            Keyinfo keyinfo = dao.getKeyinfo(keyindex, "RSA");
            if (keyinfo != null) {
                keyinfo.setKeylength(keylength);
                keyinfo.setPublickey(publickey);
                keyinfo.setPrivatekey(privatekey);
                keyinfo.setKey(key);
                ret = dao.updateKeyinfo(keyinfo);
            } else {
                keyinfo = new Keyinfo();
                keyinfo.setKeyalg("RSA");
                keyinfo.setKeyindex(keyindex);
                keyinfo.setKeylength(keylength);
                keyinfo.setPublickey(publickey);
                keyinfo.setPrivatekey(privatekey);
                keyinfo.setKey(key);
                ret = dao.addKeyinfo(keyinfo);
            }
            if (!ret) {
                throw new SecurityException("save or update keyinfo error");
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return ret;
    }

    public boolean verifyInternalCert(String cert, int keyindex, int keylength) throws SecurityException {
        String algtype = "SHA1withRSA";
        String data = "thisistest";
        boolean ret = false;
        try {
            byte[] signdata = this.internalSign(algtype, keyindex, keylength, data.getBytes());
            PublicKey pubkey = KeyFromDER.getPublicKeyFromCert(cert);
            ret = this.externalVerify(algtype, pubkey, signdata, data.getBytes());
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return ret;
    }
}

