/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft;

import com.custle.security.algorithm.imple.IHash;
import com.custle.security.algorithm.imple.soft.sm2.SM3Hash;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SoftHash
implements IHash {
    public byte[] md2Digest(byte[] data) throws SecurityException {
        byte[] result = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD2");
            result = digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public byte[] md5Digest(byte[] data) throws SecurityException {
        byte[] result = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            result = digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public byte[] sha1Digest(byte[] data) throws SecurityException {
        byte[] result = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            result = digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public byte[] sha256Digest(byte[] data) throws SecurityException {
        byte[] result = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            result = digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }

    public byte[] sm3Digest(byte[] data) throws SecurityException {
        byte[] result = null;
        try {
            result = SM3Hash.getHashValue(data);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return result;
    }
}

