/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft;

import com.custle.security.algorithm.imple.ISymmAlgorithms;
import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class SoftDESede
implements ISymmAlgorithms {
    public byte[] getSecretKey(int length) throws SecurityException {
        SecretKey key = null;
        try {
            KeyGenerator skg = KeyGenerator.getInstance("DESede");
            skg.init(length);
            key = skg.generateKey();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return key.getEncoded();
    }

    public byte[] cryptionCbcNoPadding(byte[] inData, byte[] keyData, byte[] parameter) throws SecurityException {
        String transformation = "DESede/CBC/NOPADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec deskey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(deskey);
            outData = this.cryption(key, transformation, inData, parameter);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptCbcNoPadding(byte[] inData, byte[] keyData, byte[] parameter) throws SecurityException {
        String transformation = "DESede/CBC/NOPADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec deskey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(deskey);
            outData = this.decrypt(key, transformation, inData, parameter);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionCbcPadding(byte[] inData, byte[] keyData, byte[] parameter) throws SecurityException {
        String transformation = "DESede/CBC/PKCS5PADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec deskey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(deskey);
            outData = this.cryption(key, transformation, inData, parameter);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptCbcPadding(byte[] inData, byte[] keyData, byte[] parameter) throws SecurityException {
        String transformation = "DESede/CBC/PKCS5PADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec deskey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(deskey);
            outData = this.decrypt(key, transformation, inData, parameter);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionEcbNoPadding(byte[] inData, byte[] keyData) throws SecurityException {
        String transformation = "DESede/ECB/NOPADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec deskey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(deskey);
            outData = this.cryption(key, transformation, inData, null);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptEcbNoPadding(byte[] inData, byte[] keyData) throws SecurityException {
        String transformation = "DESede/ECB/NOPADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec DESedekey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(DESedekey);
            outData = this.decrypt(key, transformation, inData, null);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionEcbPadding(byte[] inData, byte[] keyData) throws SecurityException {
        String transformation = "DESede/ECB/PKCS5PADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec deskey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(deskey);
            outData = this.cryption(key, transformation, inData, null);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] decryptEcbPadding(byte[] inData, byte[] keyData) throws SecurityException {
        String transformation = "DESede/ECB/PKCS5PADDING";
        byte[] outData = null;
        try {
            DESedeKeySpec deskey = new DESedeKeySpec(keyData);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            SecretKey key = skf.generateSecret(deskey);
            outData = this.decrypt(key, transformation, inData, null);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return outData;
    }

    public byte[] cryptionCfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] cryptionCfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] cryptionOfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] cryptionOfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptCfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptCfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptOfbNoPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    public byte[] decryptOfbPadding(byte[] inData, byte[] key, byte[] parameter) throws SecurityException {
        return null;
    }

    private byte[] cryption(SecretKey key, String transformation, byte[] plain, byte[] parameter) throws SecurityException {
        Cipher cipher = null;
        byte[] r = null;
        try {
            cipher = Cipher.getInstance(transformation);
            if (parameter != null) {
                AlgorithmParameters params = AlgorithmParameters.getInstance("DESede");
                params.init(new IvParameterSpec(parameter));
                cipher.init(1, (Key)key, params);
            } else {
                cipher.init(1, key);
            }
            r = cipher.doFinal(plain);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return r;
    }

    private byte[] decrypt(Key key, String transformation, byte[] plain, byte[] parameter) throws SecurityException {
        Cipher cipher = null;
        byte[] r = null;
        try {
            cipher = Cipher.getInstance(transformation);
            if (parameter != null) {
                AlgorithmParameters params = AlgorithmParameters.getInstance("DESede");
                params.init(new IvParameterSpec(parameter));
                cipher.init(2, key, params);
            } else {
                cipher.init(2, key);
            }
            r = cipher.doFinal(plain);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        return r;
    }
}

