/*
 * Decompiled with CFR 0.152.
 */
package com.custle.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class FileUtil {
    public static String readFileToString(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringBuffer sb = new StringBuffer();
        try {
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return sb.toString();
    }

    public static byte[] readFileToByte(File f) throws IOException {
        byte[] buff = new byte[(int)f.length()];
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            in.read(buff);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return buff;
    }

    public static void writeFile(String fileName, byte[] data) throws IOException {
        File f = new File(fileName);
        FileOutputStream out = null;
        try {
            if (f.exists()) {
                f.delete();
            }
            out = new FileOutputStream(f);
            out.write(data);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

