/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.util;

import cn.com.jsgxca.client.util.StringUtil;
import java.security.MessageDigest;
import java.util.UUID;

public class SignUtil {
    private static final String algorithm = "SHA-256";
    private static String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String getSignData(String once, String ts, String appKey, String signMethod, String pwd, String request) {
        if (StringUtil.isBlank(once) || StringUtil.isBlank(ts) || StringUtil.isBlank(appKey) || StringUtil.isBlank(signMethod) || StringUtil.isBlank(pwd) || StringUtil.isBlank(request)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(once);
        buffer.append("&");
        buffer.append(ts);
        buffer.append("&");
        buffer.append(appKey);
        buffer.append("&");
        buffer.append(signMethod);
        buffer.append("&");
        buffer.append(pwd);
        buffer.append("&");
        buffer.append(request);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
            md.update(buffer.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String encode = SignUtil.byteArrayToHexString(md.digest()).toUpperCase();
        return encode;
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = byteArray;
        int n = byteArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte byt = byArray[n2];
            sb.append(SignUtil.byteToHexString(byt));
            ++n2;
        }
        return sb.toString();
    }

    private static String byteToHexString(byte byt) {
        int n = byt;
        if (n < 0) {
            n += 256;
        }
        return String.valueOf(hexDigits[n / 16]) + hexDigits[n % 16];
    }

    public static String getOnce() {
        return UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }

    public static void main(String[] args) {
        System.out.println("\u6d4b\u8bd5\u7b7e\u540d\u7ed3\u679c:" + SignUtil.getSignData("94D825D052424301B2B54107A99F14F5", String.valueOf(System.currentTimeMillis()), "test", algorithm, "123456", "{\"id\":\"5678\",\"name\":\"\u5f20\u4e09\"}"));
        System.out.println("\u83b7\u53d632\u4f4d\u968f\u673aUUID:" + SignUtil.getOnce());
    }
}

