/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.util;

import cn.com.jsgxca.client.exception.JSGXCAException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GxUtils {
    private static final int SESSIONKEY_LEN = 24;
    private static final int SHA1_LEN = 20;

    public static boolean isEmpty(String paramString) {
        return "".equals(paramString) || paramString == null || paramString.trim().length() == 0;
    }

    public static String getDigestAlgo(String algo) throws JSGXCAException {
        String hashAlgo = null;
        if (algo.equalsIgnoreCase("RSA-MD5") || algo.toUpperCase().equals("MD5")) {
            hashAlgo = "MD5";
        } else if (algo.equalsIgnoreCase("RSA-SHA1") || algo.toUpperCase().equals("SHA1")) {
            hashAlgo = "SHA1";
        } else if (algo.equalsIgnoreCase("RSA-SHA256") || algo.toUpperCase().equals("SHA256")) {
            hashAlgo = "SHA256";
        } else if (algo.equalsIgnoreCase("RSA-SHA384") || algo.toUpperCase().equals("SHA384")) {
            hashAlgo = "sha384";
        } else if (algo.equalsIgnoreCase("RSA-SHA512") || algo.toUpperCase().equals("SHA512")) {
            hashAlgo = "sha512";
        } else if (algo.equalsIgnoreCase("ECDSA-SM2-WITH-SM3")) {
            hashAlgo = "SM3";
        } else if (algo.equalsIgnoreCase("SM2-SM3") || algo.toUpperCase().equals("SM3")) {
            hashAlgo = "SM3";
        } else {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5");
        }
        return hashAlgo;
    }

    public static boolean isDigestAlgoValid(String algo) {
        return algo.length() == 0 || algo.equalsIgnoreCase("md5") || algo.equalsIgnoreCase("sha1") || algo.equalsIgnoreCase("sha256") || algo.equalsIgnoreCase("sha384") || algo.equalsIgnoreCase("sha1") || algo.equalsIgnoreCase("sm3");
    }

    public static boolean isSymmAlgoValid(String algo) {
        return algo.length() == 0 || algo.equalsIgnoreCase("DESede") || algo.equalsIgnoreCase("AES") || algo.equalsIgnoreCase("SM4");
    }

    public static boolean isSymmAlgoAndModeValid(String algo) {
        return algo.length() == 0 || algo.equalsIgnoreCase("3DES_ECB") || algo.equalsIgnoreCase("3DES_CBC") || algo.equalsIgnoreCase("AES_ECB") || algo.equalsIgnoreCase("AES_CBC") || algo.equalsIgnoreCase("SM4_ECB") || algo.equalsIgnoreCase("SM4_CBC");
    }

    public static byte[] genSymmKeyBySessionKey(byte[] sessionKey) throws JSGXCAException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(sessionKey);
            byte[] keyBlobData = messageDigest.digest();
            byte[] symmKey = new byte[24];
            System.arraycopy(keyBlobData, 0, symmKey, 0, 20);
            System.arraycopy(keyBlobData, 0, symmKey, 20, 4);
            return symmKey;
        }
        catch (Exception e) {
            throw new JSGXCAException("\u8ba1\u7b97\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25!", e);
        }
    }

    public static byte[] genSymmKey(String algoID, String password) throws JSGXCAException {
        int keySize = 128;
        String algoName = "SM4";
        if (algoID == "3DES_CBC" || algoID == "3DES_ECB") {
            keySize = 168;
            algoName = "DESede";
        } else {
            algoName = algoID == "AES_CBC" || algoID == "AES_ECB" ? "AES" : "SM4";
        }
        try {
            KeyGenerator kg = KeyGenerator.getInstance(algoName, (Provider)new BouncyCastleProvider());
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(password.getBytes());
            kg.init(keySize, random);
            return kg.generateKey().getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new JSGXCAException("\u8ba1\u7b97\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25!", e);
        }
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(GxUtils.charToByte(hexChars[pos]) << 4 | GxUtils.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

