/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.process;

import cn.com.jsgxca.client.exception.JSGXCAException;
import cn.com.jsgxca.client.interfaces.IHttpService;
import cn.com.jsgxca.client.util.SignUtil;
import cn.com.jsgxca.client.util.StringUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpURLConnectionService
implements IHttpService {
    private static final String PROTO_HTTPS = "https";
    private static final String POST_METHOD = "POST";
    private static final String GET_METHOD = "GET";
    private static final String SIGN_METHOD = "SHA-256";
    private static int connectTimeout = 10000;
    private static int readTimeout = 10000;
    protected String appKey = null;
    protected String appPwd = null;

    public HttpURLConnectionService(String appKey, String appPwd) {
        this.appKey = appKey;
        this.appPwd = appPwd;
    }

    public HttpURLConnectionService() {
    }

    @Override
    public Map<String, String> post(String requestUrl, Map<String, String> requestMap) throws JSGXCAException {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String requestJson = gson.toJson(StringUtil.nullToEmpty(requestMap));
        if (requestUrl.startsWith(PROTO_HTTPS)) {
            return this.httpsRequest(requestUrl, POST_METHOD, requestJson);
        }
        return this.httpRequest(requestUrl, POST_METHOD, requestJson);
    }

    public Map<String, String> httpRequest(String requestUrl, String requestMethod, String requestValue) throws JSGXCAException {
        URL url = null;
        try {
            url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.connect();
            OutputStream os = conn.getOutputStream();
            os.write(requestValue.getBytes("UTF-8"));
            os.flush();
            StringBuilder sb = new StringBuilder();
            int httpRspCode = conn.getResponseCode();
            if (httpRspCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map mapRes = (Map)gson.fromJson(sb.toString(), type);
                return mapRes;
            }
            throw new JSGXCAException("\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u6c42\u7684URL\u4e3a" + url.toString() + " httpRspCode:" + httpRspCode);
        }
        catch (Exception e) {
            throw new JSGXCAException("\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u6c42\u7684URL\u4e3a" + url.toString(), e);
        }
    }

    private Map<String, String> httpsRequest(String requestUrl, String requestMethod, String requestValue) throws JSGXCAException {
        URL url = null;
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new NullHostNameVerifier());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            url = new URL(requestUrl);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "application/json");
            if (!StringUtil.isBlank(this.appKey) && !StringUtil.isBlank(this.appPwd)) {
                String once = SignUtil.getOnce();
                String ts = String.valueOf(System.currentTimeMillis());
                conn.setRequestProperty("once", once);
                conn.setRequestProperty("ts", ts);
                conn.setRequestProperty("appKey", this.appKey);
                conn.setRequestProperty("signMethod", SIGN_METHOD);
                conn.setRequestProperty("signData", SignUtil.getSignData(once, ts, this.appKey, SIGN_METHOD, this.appPwd, requestValue));
            }
            conn.setSSLSocketFactory(ssf);
            conn.connect();
            OutputStream os = conn.getOutputStream();
            os.write(requestValue.getBytes("UTF-8"));
            os.flush();
            StringBuilder sb = new StringBuilder();
            int httpRspCode = conn.getResponseCode();
            if (httpRspCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map mapRes = (Map)gson.fromJson(sb.toString(), type);
                return mapRes;
            }
            throw new JSGXCAException("\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u6c42\u7684URL\u4e3a" + url.toString() + " httpRspCode:" + httpRspCode);
        }
        catch (Exception e) {
            throw new JSGXCAException("\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u6c42\u7684URL\u4e3a" + url.toString(), e);
        }
    }

    @Override
    public void setConnectionTimeOut(int connectionTimeOut) {
        connectTimeout = connectionTimeOut;
    }

    @Override
    public void setSocketTimeout(int socketTimeOut) {
        readTimeout = socketTimeOut;
    }

    static class NullHostNameVerifier
    implements HostnameVerifier {
        NullHostNameVerifier() {
        }

        public boolean verify(String paramString, SSLSession paramSSLSession) {
            return true;
        }
    }
}

