/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.process;

import cn.com.jsgxca.client.exception.JSGXCAException;
import cn.com.jsgxca.client.interfaces.IHttpService;
import cn.com.jsgxca.client.util.SignUtil;
import cn.com.jsgxca.client.util.StringUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.nio.charset.CodingErrorAction;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientService
implements IHttpService {
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String CHARSET = "UTF-8";
    private static final String SIGN_METHOD = "SHA-256";
    private static final int MAX_TOTAL_CONNECTIONS = 1000;
    private static final int MAX_ROUTE_CONNECTIONS = 200;
    private static final int SOCKET_BUFFER_SIZE = 10240;
    private static int connetctTimeout = 5000;
    private static int socketTimeout = 10000;
    private static int connectionRequestTimeout = 10000;
    private static PoolingHttpClientConnectionManager connManager = null;
    private static RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connetctTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
    protected String appKey = null;
    protected String appPwd = null;
    protected String proxyIp = null;
    protected String proxyPort = null;
    protected boolean isProxy = false;

    static {
        try {
            X509TrustManager manager = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{manager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)socketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(1000);
            connManager.setDefaultMaxPerRoute(200);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(10240).setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
            connManager.setDefaultConnectionConfig(connectionConfig);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public HttpClientService(String appKey, String appPwd) {
        this.appKey = appKey;
        this.appPwd = appPwd;
    }

    public HttpClientService(String appKey, String appPwd, String proxyIp, String proxyPort) {
        this.appKey = appKey;
        this.appPwd = appPwd;
        this.proxyIp = proxyIp;
        this.proxyPort = proxyPort;
        if (!StringUtil.isBlank(this.proxyIp) && !StringUtil.isBlank(this.proxyPort)) {
            this.isProxy = true;
        }
    }

    public HttpClientService() {
    }

    @Override
    public Map<String, String> post(String url, Map<String, String> requestMap) throws JSGXCAException {
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        Map<String, String> mapRes = new HashMap<String, String>();
        String responseStr = null;
        try {
            int httpRspCode;
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String requestJson = gson.toJson(StringUtil.nullToEmpty(requestMap));
            httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", CONTENT_TYPE);
            if (!StringUtil.isBlank(this.appKey) && !StringUtil.isBlank(this.appPwd)) {
                String once = SignUtil.getOnce();
                String ts = String.valueOf(System.currentTimeMillis());
                httpPost.addHeader("once", once);
                httpPost.addHeader("ts", ts);
                httpPost.addHeader("appKey", this.appKey);
                httpPost.addHeader("signMethod", SIGN_METHOD);
                httpPost.addHeader("signData", SignUtil.getSignData(once, ts, this.appKey, SIGN_METHOD, this.appPwd, requestJson));
            }
            StringEntity entity = new StringEntity(requestJson);
            entity.setContentEncoding(CHARSET);
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            if (this.isProxy) {
                HttpHost proxyHost = new HttpHost(this.proxyIp, Integer.valueOf(this.proxyPort).intValue());
                RequestConfig reqConfig = RequestConfig.custom().setProxy(proxyHost).build();
                httpPost.setConfig(reqConfig);
            }
            if ((httpRspCode = (response = this.getHttpClient().execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) == 200) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)CHARSET);
                    Type type = new TypeToken<Map<String, String>>(){}.getType();
                    mapRes = (Map)gson.fromJson(responseStr, type);
                    mapRes.put("statusCode", String.valueOf(httpRspCode));
                }
                EntityUtils.consume((HttpEntity)resEntity);
                response.close();
                HashMap<String, String> hashMap = mapRes;
                return hashMap;
            }
            try {
                throw new JSGXCAException("\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u6c42\u7684URL\u4e3a" + url.toString() + " httpRspCode:" + httpRspCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof SocketTimeoutException) {
                    throw new JSGXCAException("\u670d\u52a1\u5668\u8bf7\u6c42\u8d85\u65f6");
                }
                if (e instanceof ConnectTimeoutException) {
                    throw new JSGXCAException("\u670d\u52a1\u5668\u54cd\u5e94\u8d85\u65f6");
                }
                throw new JSGXCAException("\u670d\u52a1\u5668\u5f02\u5e38");
            }
        }
        finally {
            httpPost.releaseConnection();
            httpPost.abort();
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private CloseableHttpClient getHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(defaultRequestConfig);
        return httpClientBuilder.build();
    }

    @Override
    public void setConnectionTimeOut(int connectionTimeOut) {
        connetctTimeout = connectionTimeOut;
        defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connetctTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
    }

    @Override
    public void setSocketTimeout(int socketTimeOut) {
        socketTimeout = socketTimeOut;
        defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connetctTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
    }

    public void setConnectRequestTimeout(int connectRequestTimeout) {
        connectionRequestTimeout = connectRequestTimeout;
        defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connetctTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
    }
}

