/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.http;

import cn.com.jsgxca.client.entity.GxTSA;
import cn.com.jsgxca.client.exception.JSGXCAException;
import cn.com.jsgxca.client.http.BaseClient;
import cn.com.jsgxca.client.interfaces.ITSAClient;
import cn.com.jsgxca.client.util.GxUtils;
import java.util.Date;
import java.util.HashMap;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;

public class TSAClient
extends BaseClient
implements ITSAClient {
    private static final String TSA_CREATE_ACTION = "tsa/createTimestamp";
    private static final String TSA_VERIFY_ACTION = "tsa/verifyTimestamp";

    public TSAClient(String host, String port, String version) {
        super(host, port, version);
    }

    public TSAClient(String host, String port, String version, int connectTimeout, int readTimeout) {
        super(host, port, version);
    }

    public TSAClient(String host, String port, String version, String appKey, String appPwd) {
        super(host, port, version, appKey, appPwd);
    }

    public TSAClient(String host, String port, String version, String appKey, String appPwd, String proxyIp, String proxyPort) {
        super(host, port, version, appKey, appPwd, proxyIp, proxyPort);
    }

    public GxTSA createTimestamp(byte[] data, String algo, String reqType) throws JSGXCAException {
        if (data == null) {
            throw new JSGXCAException("\u5f85\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String base64Data = Base64.toBase64String((byte[])data);
        return this.createTimestamp(base64Data, algo, reqType);
    }

    public GxTSA createTimestamp(byte[] data, String algo) throws JSGXCAException {
        return this.createTimestamp(data, algo, "0");
    }

    public GxTSA createTimestamp(String data) throws JSGXCAException {
        return this.createTimestamp(data, "", "0");
    }

    public GxTSA createTimestamp(String data, String algo, String reqType) throws JSGXCAException {
        if (GxUtils.isEmpty(data) || algo == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isEmpty(algo) && !GxUtils.isDigestAlgoValid(algo)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u6458\u8981\u7b97\u6cd5!");
        }
        if (reqType.trim().equals("")) {
            reqType = "0";
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("alg_digest", algo);
            params.put("req_type", reqType);
            String url = this.getServiceUrl(TSA_CREATE_ACTION);
            GxTSA gxTSA = new GxTSA(this.service.post(url, params));
            return gxTSA;
        }
        catch (Exception e) {
            throw new JSGXCAException("\u7b7e\u53d1\u65f6\u95f4\u6233\u5931\u8d25!", e);
        }
    }

    public GxTSA verifyTimestamp(String originData, String timestamp, String algo, String base64Cert) throws JSGXCAException {
        if (timestamp == null || algo == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isEmpty(algo) && !GxUtils.isDigestAlgoValid(algo)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u6458\u8981\u7b97\u6cd5!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", originData);
            params.put("timestamp", timestamp);
            params.put("alg_digest", algo);
            params.put("b64_cert", base64Cert);
            String url = this.getServiceUrl(TSA_VERIFY_ACTION);
            GxTSA gxTSA = new GxTSA(this.service.post(url, params));
            return gxTSA;
        }
        catch (Exception e) {
            throw new JSGXCAException("\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25!", e);
        }
    }

    public GxTSA verifyTimestamp(String timestamp) throws JSGXCAException {
        return this.verifyTimestamp("", timestamp, "", "");
    }

    public GxTSA verifyTimestamp(String originData, String timestamp) throws JSGXCAException {
        return this.verifyTimestamp(originData, timestamp, "", "");
    }

    public Date parseTimeStamp(String timeStamp) throws JSGXCAException {
        try {
            TimeStampResponse response = new TimeStampResponse(Base64.decode((String)timeStamp));
            return response.getTimeStampToken().getTimeStampInfo().getGenTime();
        }
        catch (Exception e) {
            throw new JSGXCAException("\u89e3\u6790\u65f6\u95f4\u6233\u5931\u8d25\uff01", e);
        }
    }
}

