/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.http;

import cn.com.jsgxca.client.entity.GxBase;
import cn.com.jsgxca.client.entity.GxCertificate;
import cn.com.jsgxca.client.entity.GxEnvelope;
import cn.com.jsgxca.client.entity.GxKeyList;
import cn.com.jsgxca.client.entity.GxPCS;
import cn.com.jsgxca.client.entity.GxSVS;
import cn.com.jsgxca.client.entity.GxSignData;
import cn.com.jsgxca.client.entity.GxSignPKCS7;
import cn.com.jsgxca.client.exception.JSGXCAException;
import cn.com.jsgxca.client.http.BaseClient;
import cn.com.jsgxca.client.interfaces.ISVSClient;
import cn.com.jsgxca.client.util.GxUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;

public class SVSClient
extends BaseClient
implements ISVSClient {
    private static final Log log = LogFactory.getLog(SVSClient.class);

    public SVSClient(String host, String port, String version) {
        super(host, port, version);
    }

    public SVSClient(String host, String port, String version, int connectTimeout, int readTimeout) {
        super(host, port, version);
    }

    public SVSClient(String host, String port, String version, String appKey, String appPwd) {
        super(host, port, version, appKey, appPwd);
    }

    public SVSClient(String host, String port, String version, String appKey, String appPwd, String proxyIp, String proxyPort) {
        super(host, port, version, appKey, appPwd, proxyIp, proxyPort);
    }

    public GxKeyList listKeyID(int maxCertCount, int keyAlg, int keyUsage) throws JSGXCAException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("max_cert_count", String.valueOf(maxCertCount));
            params.put("key_alg", String.valueOf(keyAlg));
            params.put("key_usage", String.valueOf(keyUsage));
            String url = this.getServiceUrl("svs/certList");
            GxKeyList gxKeyList = new GxKeyList(this.service.post(url, params));
            return gxKeyList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u4e0b\u8f7d\u8bc1\u4e66\u5e93\u5217\u8868\u5931\u8d25!", e);
        }
    }

    public GxCertificate exportServerCert(String keyID) throws JSGXCAException {
        if (GxUtils.isEmpty(keyID)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("key_id", keyID);
            params.put("cert_id", "");
            params.put("key_alg", "");
            params.put("key_usage", "");
            String url = this.getServiceUrl("svs/getCert");
            GxCertificate gxCertificate = new GxCertificate(this.service.post(url, params));
            return gxCertificate;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25!", e);
        }
    }

    public GxCertificate exportUserCert(String certId, int keyAlg, int keyUsage) throws JSGXCAException {
        if (GxUtils.isEmpty(certId)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("cert_id", "");
            params.put("cert_id", certId);
            params.put("key_alg", String.valueOf(keyAlg));
            params.put("key_usage", String.valueOf(keyUsage));
            String url = this.getServiceUrl("svs/getCert");
            GxCertificate gxCertificate = new GxCertificate(this.service.post(url, params));
            return gxCertificate;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25!", e);
        }
    }

    public GxSignData createPKCS1(String keyID, String keyPass, byte[] data) throws JSGXCAException {
        return this.createPKCS1(keyID, keyPass, data, "", 0);
    }

    public GxSignData createPKCS1(String keyID, String keyPass, byte[] data, String algo, int dataType) throws JSGXCAException {
        if (data == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String base64Data = Base64.toBase64String((byte[])data);
        return this.createPKCS1(keyID, keyPass, base64Data, algo, dataType);
    }

    public GxSignData createPKCS1(String keyID, String keyPass, String data) throws JSGXCAException {
        return this.createPKCS1(keyID, keyPass, data, "", 0);
    }

    public GxSignData createPKCS1(String keyID, String keyPass, String data, String algo, int dataType) throws JSGXCAException {
        if (GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isEmpty(algo) && !GxUtils.isDigestAlgoValid(algo)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u6458\u8981\u7b97\u6cd5!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("key_id", keyID);
            params.put("passwd", keyPass);
            params.put("alg_digest", algo);
            params.put("origin_data_type", String.valueOf(dataType));
            String url = this.getServiceUrl("svs/signPkcs1");
            GxSignData gxPCS = new GxSignData(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("PKCS1\u7b7e\u540d\u5931\u8d25!", e);
        }
    }

    public GxSignPKCS7 createPKCS7(String keyID, String keyPass, byte[] data) throws JSGXCAException {
        return this.createPKCS7(keyID, keyPass, data, "", 0, 1, 0);
    }

    public GxSignPKCS7 createPKCS7(String keyPass, byte[] data, String algo) throws JSGXCAException {
        return this.createPKCS7("", keyPass, data, algo, 0, 1, 0);
    }

    public GxSignPKCS7 createPKCS7(String keyID, String keyPass, byte[] data, String algo, int dataType, int attach, int fullchain) throws JSGXCAException {
        if (data == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String base64Data = Base64.toBase64String((byte[])data);
        return this.createPKCS7(keyID, keyPass, base64Data, algo, dataType, attach, fullchain);
    }

    public GxSignPKCS7 createPKCS7(String keyID, String keyPass, String data) throws JSGXCAException {
        return this.createPKCS7(keyID, keyPass, data, "", 0, 1, 0);
    }

    public GxSignPKCS7 createPKCS7(String keyID, String keyPass, String data, String algo, int dataType, int attach, int fullchain) throws JSGXCAException {
        if (GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (GxUtils.isEmpty(keyID) && GxUtils.isEmpty(algo)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isEmpty(algo) && !GxUtils.isDigestAlgoValid(algo)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u6458\u8981\u7b97\u6cd5!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("key_id", keyID);
            params.put("passwd", keyPass);
            params.put("alg_digest", algo);
            params.put("origin_data_type", String.valueOf(dataType));
            params.put("attach", String.valueOf(attach));
            params.put("full_chain", String.valueOf(fullchain));
            String url = this.getServiceUrl("svs/signPkcs7");
            GxSignPKCS7 gxSignPKCS7 = new GxSignPKCS7(this.service.post(url, params));
            return gxSignPKCS7;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("PKCS7\u7b7e\u540d\u5931\u8d25!", e);
        }
    }

    public GxSignData createXMLSignature(String keyID, String keyPass, String data) throws JSGXCAException {
        return this.createXMLSignature(keyID, keyPass, data, "");
    }

    public GxSignData createXMLSignature(String keyID, String keyPass, String data, String algo) throws JSGXCAException {
        if (GxUtils.isEmpty(keyID) || GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isEmpty(algo) && !GxUtils.isDigestAlgoValid(algo)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u6458\u8981\u7b97\u6cd5!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", Base64.toBase64String((byte[])data.getBytes("UTF-8")));
            params.put("key_id", keyID);
            params.put("passwd", keyPass);
            params.put("alg_digest", algo);
            String url = this.getServiceUrl("svs/signXml");
            GxSignData gxSignData = new GxSignData(this.service.post(url, params));
            return gxSignData;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("PKCS1\u7b7e\u540d\u5931\u8d25!", e);
        }
    }

    public GxSVS verifyCertificate(String base64Cert) throws JSGXCAException {
        return this.verifyCertificate(base64Cert, 0);
    }

    public GxSVS verifyCertificate(String base64Cert, int greenpass) throws JSGXCAException {
        if (GxUtils.isEmpty(base64Cert)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("b64_cert", base64Cert);
            params.put("greenpass", String.valueOf(greenpass));
            String url = this.getServiceUrl("svs/verifyCert");
            GxSVS gxSVS = new GxSVS(this.service.post(url, params));
            return gxSVS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25!", e);
        }
    }

    public GxSVS verifyPKCS1(byte[] data, String signedData, String base64Cert) throws JSGXCAException {
        return this.verifyPKCS1(data, signedData, base64Cert, "", 0, 0);
    }

    public GxSVS verifyPKCS1(byte[] data, String signedData, String base64Cert, String algo, int dataType, int greenpass) throws JSGXCAException {
        if (data == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String base64Data = Base64.toBase64String((byte[])data);
        return this.verifyPKCS1(base64Data, signedData, base64Cert, algo, dataType, 0);
    }

    public GxSVS verifyPKCS1(String data, String signedData, String base64Cert) throws JSGXCAException {
        return this.verifyPKCS1(data, signedData, base64Cert, "", 0, 0);
    }

    public GxSVS verifyPKCS1(String data, String signedData, String base64Cert, int greenpass) throws JSGXCAException {
        return this.verifyPKCS1(data, signedData, base64Cert, "", 0, greenpass);
    }

    public GxSVS verifyPKCS1(String data, String signedData, String base64Cert, String algo, int dataType, int greenpass) throws JSGXCAException {
        if (GxUtils.isEmpty(data) || GxUtils.isEmpty(signedData) || GxUtils.isEmpty(base64Cert)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("b64_cert", base64Cert);
            params.put("signed_data", signedData);
            params.put("alg_digest", algo);
            params.put("origin_data_type", String.valueOf(dataType));
            params.put("greenpass", String.valueOf(greenpass));
            String url = this.getServiceUrl("svs/verifyPkcs1");
            GxSVS gxSVS = new GxSVS(this.service.post(url, params));
            return gxSVS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("PKCS1\u9a8c\u7b7e\u5931\u8d25!", e);
        }
    }

    public GxSVS verifyPKCS7(String signedData) throws JSGXCAException {
        return this.verifyPKCS7("", signedData, 0, 0);
    }

    public GxSVS verifyPKCS7(byte[] data, String signedData) throws JSGXCAException {
        return this.verifyPKCS7(data, signedData, 0, 0);
    }

    public GxSVS verifyPKCS7(byte[] data, String signedData, int dataType, int greenpass) throws JSGXCAException {
        if (data == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String base64Data = Base64.toBase64String((byte[])data);
        return this.verifyPKCS7(base64Data, signedData, 0, 0);
    }

    public GxSVS verifyPKCS7(String data, String signedData) throws JSGXCAException {
        return this.verifyPKCS7(data, signedData, 0, 0);
    }

    public GxSVS verifyPKCS7(String data, String signedData, int dataType, int greenpass) throws JSGXCAException {
        if (GxUtils.isEmpty(signedData)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("signed_data", signedData);
            params.put("origin_data_type", String.valueOf(dataType));
            params.put("greenpass", String.valueOf(greenpass));
            String url = this.getServiceUrl("svs/verifyPkcs7");
            GxSVS gxSVS = new GxSVS(this.service.post(url, params));
            return gxSVS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("PKCS7\u9a8c\u7b7e\u5931\u8d25!", e);
        }
    }

    public GxSVS verifyXMLSignature(String signedData) throws JSGXCAException {
        return this.verifyXMLSignature(signedData, 0);
    }

    public GxSVS verifyXMLSignature(String signedData, int greenpass) throws JSGXCAException {
        if (GxUtils.isEmpty(signedData)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("signed_data", signedData);
            params.put("greenpass", String.valueOf(greenpass));
            String url = this.getServiceUrl("svs/verifyXml");
            GxSVS gxSVS = new GxSVS(this.service.post(url, params));
            return gxSVS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("xml\u9a8c\u7b7e\u5931\u8d25!", e);
        }
    }

    public GxEnvelope envelopeMessage(String keyID, String password, String data, String base64Cert) throws JSGXCAException {
        return this.envelopeMessage(keyID, password, data, base64Cert, "DESede", 0);
    }

    public GxEnvelope envelopeMessage(String keyID, String password, String data, String base64Cert, String encAlgo, int signFlag) throws JSGXCAException {
        if (GxUtils.isEmpty(data) || GxUtils.isEmpty(base64Cert)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isSymmAlgoValid(encAlgo)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u5bf9\u79f0\u7b97\u6cd5");
        }
        if (encAlgo.equals("DESede")) {
            encAlgo = "3DES";
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("b64_cert", base64Cert);
            params.put("is_sign", String.valueOf(signFlag));
            params.put("key_id", keyID);
            params.put("passwd", password);
            params.put("encrypt_alg", encAlgo);
            String url = this.getServiceUrl("svs/envelopeSeal");
            GxEnvelope gxEnvelope = new GxEnvelope(this.service.post(url, params));
            return gxEnvelope;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u6570\u5b57\u4fe1\u5c01\u5c01\u5305\u5931\u8d25!", e);
        }
    }

    public GxPCS envelopeOpen(String keyID, String password, String data) throws JSGXCAException {
        return this.envelopeOpen(keyID, password, data, 0);
    }

    public GxPCS envelopeOpen(String keyID, String password, String data, int signFlag) throws JSGXCAException {
        if (GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("evp_data", data);
            params.put("cert_id", keyID);
            params.put("passwd", password);
            params.put("is_sign", String.valueOf(signFlag));
            String url = this.getServiceUrl("svs/envelopeOpen");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u6570\u5b57\u89e3\u5305\u5931\u8d25!", e);
        }
    }

    public GxPCS encryptByPrikey(String keyID, String password, String data) throws JSGXCAException {
        if (GxUtils.isEmpty(keyID) || GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("cert_id", keyID);
            params.put("passwd", password);
            String url = this.getServiceUrl("svs/encPrikey");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u79c1\u94a5\u52a0\u5bc6\u5931\u8d25!", e);
        }
    }

    public GxPCS encryptByPubkey(String keyID, String data) throws JSGXCAException {
        return this.encryptByPubkey(keyID, "", data, 0);
    }

    public GxPCS encryptByCert(String base64Cert, String data) throws JSGXCAException {
        if (GxUtils.isEmpty(base64Cert) || GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        return this.encryptByPubkey("", base64Cert, data, 0);
    }

    public GxPCS encryptByPubkey(String keyID, String base64Cert, String data, int keyAlgo) throws JSGXCAException {
        if (GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("b64_cert", base64Cert);
            params.put("cert_id", keyID);
            if (keyAlgo != 1 && keyAlgo != 2) {
                params.put("key_alg", "");
            } else {
                params.put("key_alg", String.valueOf(keyAlgo));
            }
            String url = this.getServiceUrl("svs/encPubkey");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u516c\u94a5\u52a0\u5bc6\u5931\u8d25!", e);
        }
    }

    public GxPCS decryptByPrikey(String keyID, String password, String data, String sessionkey) throws JSGXCAException {
        if (GxUtils.isEmpty(keyID)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        return this.decryptByPrikey(keyID, password, data, sessionkey, 0);
    }

    public GxPCS decryptByPrikey(String keyID, String password, String data, String sessionkey, int keyAlgo) throws JSGXCAException {
        if (GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("cipher_data", data);
            params.put("sessionkey", sessionkey);
            params.put("cert_id", keyID);
            if (keyAlgo == 0) {
                params.put("key_alg", "");
            } else {
                params.put("key_alg", String.valueOf(keyAlgo));
            }
            params.put("passwd", password);
            String url = this.getServiceUrl("svs/decPrikey");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u516c\u94a5\u52a0\u5bc6\u5931\u8d25!", e);
        }
    }

    public GxPCS decryptByPubkey(String keyID, String data) throws JSGXCAException {
        if (GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        return this.decryptByPubkey(keyID, "", data);
    }

    public GxPCS decryptByPubkey(String keyID, String base64Cert, String data) throws JSGXCAException {
        if (GxUtils.isEmpty(data) || GxUtils.isEmpty(base64Cert) && GxUtils.isEmpty(keyID)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("cipher_data", data);
            params.put("cert_id", keyID);
            params.put("b64_cert", base64Cert);
            String url = this.getServiceUrl("svs/decPubkey");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u516c\u94a5\u89e3\u5bc6\u5931\u8d25!", e);
        }
    }

    public GxPCS encryptBySessionkey(byte[] data, byte[] sessionkey) throws JSGXCAException {
        if (data == null || sessionkey == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String b64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKeyBySessionKey(sessionkey));
        return this.encryptBySvs(b64SymmKey, "3DES_CBC", "", Base64.toBase64String((byte[])data), true);
    }

    public GxPCS encrypt(byte[] data, String algoID, String password) throws JSGXCAException {
        if (data == null || GxUtils.isEmpty(algoID) || GxUtils.isEmpty(password)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isSymmAlgoAndModeValid(algoID)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f!");
        }
        String base64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKey(algoID, password));
        return this.encryptBySvs(base64SymmKey, algoID, "", Base64.toBase64String((byte[])data), true);
    }

    private GxPCS encryptBySvs(String key, String algID, String IV, String data, boolean bfinal) throws JSGXCAException {
        if (GxUtils.isEmpty(key) || GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("alg_symm", algID);
            params.put("iv_value", IV);
            params.put("symm_key", key);
            params.put("bfinal", bfinal ? "1" : "0");
            String url = this.getServiceUrl("svs/symmEncStr");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u5bf9\u79f0\u52a0\u5bc6\u5931\u8d25!", e);
        }
    }

    public GxPCS decryptBySessionkey(byte[] data, byte[] sessionkey) throws JSGXCAException {
        if (data == null || sessionkey == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String b64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKeyBySessionKey(sessionkey));
        return this.decryptBySvs(b64SymmKey, "3DES_CBC", "", Base64.toBase64String((byte[])data), true);
    }

    public GxPCS decrypt(byte[] data, String algoID, String password) throws JSGXCAException {
        if (data == null || GxUtils.isEmpty(algoID) || GxUtils.isEmpty(password)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!GxUtils.isSymmAlgoAndModeValid(algoID)) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f!");
        }
        String base64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKey(algoID, password));
        return this.decryptBySvs(base64SymmKey, algoID, "", Base64.toBase64String((byte[])data), true);
    }

    private GxPCS decryptBySvs(String key, String algID, String IV, String data, boolean bfinal) throws JSGXCAException {
        if (GxUtils.isEmpty(key) || GxUtils.isEmpty(data)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("cipher_data", data);
            params.put("alg_symm", algID);
            params.put("iv_value", IV);
            params.put("symm_key", key);
            params.put("bfinal", bfinal ? "1" : "0");
            String url = this.getServiceUrl("svs/symmDecStr");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u5bf9\u79f0\u89e3\u5bc6\u5931\u8d25!", e);
        }
    }

    public GxSVS encryptFile(String password, String algoID, String inFileName, String outFileName) throws JSGXCAException {
        if (GxUtils.isEmpty(password) || GxUtils.isEmpty(algoID) || GxUtils.isEmpty(inFileName) || GxUtils.isEmpty(outFileName)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!algoID.equalsIgnoreCase("3DES_CBC") && !algoID.equalsIgnoreCase("3DES_ECB")) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f!");
        }
        String base64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKey(algoID, password));
        return this.encryptFileBySvs(base64SymmKey, algoID, "", inFileName, outFileName);
    }

    public GxSVS encryptFileBySessionKey(byte[] sessionkey, String algoID, String inFileName, String outFileName) throws JSGXCAException {
        if (sessionkey == null || GxUtils.isEmpty(algoID)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String b64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKeyBySessionKey(sessionkey));
        return this.encryptFileBySvs(b64SymmKey, algoID, "", inFileName, outFileName);
    }

    private GxSVS encryptFileBySvs(String key, String algo, String IV, String inFileName, String outFileName) throws JSGXCAException {
        if (GxUtils.isEmpty(key)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!algo.equalsIgnoreCase("3DES_CBC") && !algo.equalsIgnoreCase("3DES_ECB")) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f!");
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        GxBase gxPCS = null;
        try {
            File inFile = new File(inFileName);
            if (!inFile.exists()) {
                throw new JSGXCAException("\u660e\u6587\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            File outFile = new File(outFileName);
            File fileParent = outFile.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            outFile.createNewFile();
            bis = new BufferedInputStream(new FileInputStream(inFile), 8192);
            bos = new BufferedOutputStream(new FileOutputStream(outFile));
            long plianFileLen = inFile.length();
            byte[] plainBlock = new byte[8192];
            int len = 0;
            while ((len = bis.read(plainBlock)) != -1) {
                if (len != 8192) {
                    byte[] tmp = plainBlock;
                    plainBlock = new byte[len];
                    System.arraycopy(tmp, 0, plainBlock, 0, len);
                }
                String plainB64 = new String(Base64.encode((byte[])plainBlock));
                gxPCS = (plianFileLen -= (long)len) != 0L ? this.encryptBySvs(key, algo, IV, plainB64, false) : this.encryptBySvs(key, algo, IV, plainB64, true);
                if (gxPCS.getRespCode() != 0L) {
                    throw new JSGXCAException("\u52a0\u5bc6\u6587\u4ef6\u5931\u8d25!");
                }
                byte[] cipherByte = Base64.decode((String)((GxPCS)gxPCS).getRetBase64String());
                byte[] cipherIV = null;
                if (algo.equalsIgnoreCase("AES_CBC") || algo.equalsIgnoreCase("SM4_CBC")) {
                    cipherIV = new byte[16];
                    System.arraycopy(cipherByte, cipherByte.length - 16, cipherIV, 0, 16);
                } else if (algo.equalsIgnoreCase("3DES_CBC")) {
                    cipherIV = new byte[8];
                    System.arraycopy(cipherByte, cipherByte.length - 8, cipherIV, 0, 8);
                } else if (algo.equalsIgnoreCase("AES_ECB") || algo.equalsIgnoreCase("SM4_ECB") || algo.equalsIgnoreCase("3DES_ECB")) {
                    cipherIV = new byte[]{};
                } else {
                    throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
                }
                IV = Base64.toBase64String((byte[])cipherIV);
                bos.write(cipherByte);
            }
            ((BufferedOutputStream)bos).flush();
            GxSVS gxSVS = new GxSVS(gxPCS.getResult());
            return gxSVS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u6587\u4ef6\u5bf9\u79f0\u52a0\u5bc6\u5931\u8d25", e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public GxSVS decryptFile(String password, String algoID, String inFileName, String outFileName) throws JSGXCAException {
        if (GxUtils.isEmpty(password) || GxUtils.isEmpty(algoID) || GxUtils.isEmpty(inFileName) || GxUtils.isEmpty(outFileName)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!algoID.equalsIgnoreCase("3DES_CBC") && !algoID.equalsIgnoreCase("3DES_ECB")) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f!");
        }
        String base64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKey(algoID, password));
        return this.decryptFileBySvs(base64SymmKey, algoID, "", inFileName, outFileName);
    }

    public GxSVS decryptFileBySessionKey(byte[] sessionkey, String algoID, String inFileName, String outFileName) throws JSGXCAException {
        if (sessionkey == null) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        String b64SymmKey = Base64.toBase64String((byte[])GxUtils.genSymmKeyBySessionKey(sessionkey));
        return this.decryptFileBySvs(b64SymmKey, algoID, "", inFileName, outFileName);
    }

    private GxSVS decryptFileBySvs(String key, String algo, String IV, String inFileName, String outFileName) throws JSGXCAException {
        if (GxUtils.isEmpty(key) || GxUtils.isEmpty(inFileName) || GxUtils.isEmpty(outFileName)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (!algo.equalsIgnoreCase("3DES_CBC") && !algo.equalsIgnoreCase("3DES_ECB")) {
            throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f!");
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        GxBase gxPCS = null;
        try {
            File inFile = new File(inFileName);
            if (!inFile.exists()) {
                throw new JSGXCAException("\u5bc6\u6587\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            File outFile = new File(outFileName);
            File fileParent = outFile.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            outFile.createNewFile();
            bis = new BufferedInputStream(new FileInputStream(inFile), 8192);
            bos = new BufferedOutputStream(new FileOutputStream(outFile));
            long cipherFileLen = inFile.length();
            byte[] cipherBlock = new byte[8192];
            int len = 0;
            while ((len = bis.read(cipherBlock)) != -1) {
                if (len != 8192) {
                    byte[] tmp = cipherBlock;
                    cipherBlock = new byte[len];
                    System.arraycopy(tmp, 0, cipherBlock, 0, len);
                }
                String cipherB64 = new String(Base64.encode((byte[])cipherBlock));
                gxPCS = (cipherFileLen -= (long)len) != 0L ? this.decryptBySvs(key, algo, IV, cipherB64, false) : this.decryptBySvs(key, algo, IV, cipherB64, true);
                if (gxPCS.getRespCode() != 0L) {
                    throw new JSGXCAException("\u6587\u4ef6\u5bf9\u79f0\u89e3\u5bc6\u5931\u8d25!");
                }
                byte[] cipherIV = null;
                if (algo.equalsIgnoreCase("AES_CBC") || algo.equalsIgnoreCase("SM4_CBC")) {
                    cipherIV = new byte[16];
                    System.arraycopy(cipherBlock, cipherBlock.length - 16, cipherIV, 0, 16);
                } else if (algo.equalsIgnoreCase("3DES_CBC")) {
                    cipherIV = new byte[8];
                    System.arraycopy(cipherBlock, cipherBlock.length - 8, cipherIV, 0, 8);
                } else if (algo.equalsIgnoreCase("AES_ECB") || algo.equalsIgnoreCase("SM4_ECB") || algo.equalsIgnoreCase("3DES_ECB")) {
                    cipherIV = new byte[]{};
                } else {
                    throw new JSGXCAException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
                }
                IV = new String(Base64.encode((byte[])cipherIV));
                bos.write(Base64.decode((String)((GxPCS)gxPCS).getRetBase64String()));
            }
            GxSVS gxSVS = new GxSVS(gxPCS.getResult());
            return gxSVS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u6587\u4ef6\u5bf9\u79f0\u89e3\u5bc6\u5931\u8d25", e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public GxPCS genDigest(String data, String algDigest) throws JSGXCAException {
        return this.genDigest(data, algDigest, "");
    }

    public GxPCS genDigest(String data, String algDigest, String base64Cert) throws JSGXCAException {
        if (data == null || GxUtils.isEmpty(algDigest)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        if (algDigest.equals("sm3") && GxUtils.isEmpty(base64Cert)) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("origin_data", data);
            params.put("alg_digest", algDigest);
            params.put("b64_cert", base64Cert);
            String url = this.getServiceUrl("svs/digest");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u4ea7\u751f\u6458\u8981\u5931\u8d25!", e);
        }
    }

    public GxPCS genRandom(int length) throws JSGXCAException {
        if (length < 1) {
            throw new JSGXCAException("\u53c2\u6570\u9519\u8bef!");
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", this.version);
            params.put("length", String.valueOf(length));
            String url = this.getServiceUrl("svs/genrandom");
            GxPCS gxPCS = new GxPCS(this.service.post(url, params));
            return gxPCS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25!", e);
        }
    }
}

