/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.http;

import cn.com.jsgxca.client.interfaces.IHttpService;
import cn.com.jsgxca.client.process.HttpClientService;

public abstract class BaseClient {
    protected static final String SVS_LIST_KEYID_ACTION = "svs/certList";
    protected static final String SVS_GET_CERT_ACTION = "svs/getCert";
    protected static final String SVS_SIGN_PKCS1_ACTION = "svs/signPkcs1";
    protected static final String SVS_SIGN_PKCS7_ACTION = "svs/signPkcs7";
    protected static final String SVS_SIGN_XML_ACTION = "svs/signXml";
    protected static final String SVS_VERIFY_CERT_ACTION = "svs/verifyCert";
    protected static final String SVS_VERIFY_PKCS1_ACTION = "svs/verifyPkcs1";
    protected static final String SVS_VERIFY_PKCS7_ACTION = "svs/verifyPkcs7";
    protected static final String SVS_VERIFY_XML_ACTION = "svs/verifyXml";
    protected static final String SVS_ENVELOPE_SEAL_ACTION = "svs/envelopeSeal";
    protected static final String SVS_ENVELOPE_OPEN_ACTION = "svs/envelopeOpen";
    protected static final String SVS_ENCRYPT_PUBKEY_ACTION = "svs/encPubkey";
    protected static final String SVS_ENCRYPT_PRIKEY_ACTION = "svs/encPrikey";
    protected static final String SVS_DECRYPT_PUBKEY_ACTION = "svs/decPubkey";
    protected static final String SVS_DECRYPT_PRIKEY_ACTION = "svs/decPrikey";
    protected static final String SVS_ENCRYPT_SYMM_ACTION = "svs/symmEncStr";
    protected static final String SVS_DECRYPT_SYMM_ACTION = "svs/symmDecStr";
    protected static final String SVS_GEN_DIGEST_ACTION = "svs/digest";
    protected static final String SVS_GEN_RANDOM_ACTION = "svs/genrandom";
    private boolean isSSL = false;
    protected String host;
    protected String port;
    protected String version;
    protected final int FILE_BLOCK_SIZE = 8192;
    protected IHttpService service;

    public BaseClient(String host, String port, String version) {
        this.host = host;
        this.port = port;
        this.version = version;
        this.service = new HttpClientService();
    }

    public BaseClient(String host, String port, String version, int connectTimeout, int readTimeout) {
        this.host = host;
        this.port = port;
        this.version = version;
        this.service = new HttpClientService();
        this.service.setConnectionTimeOut(connectTimeout);
        this.service.setSocketTimeout(readTimeout);
    }

    public BaseClient(String host, String port, String version, String appKey, String appPwd) {
        this.host = host;
        this.port = port;
        this.version = version;
        this.service = new HttpClientService(appKey, appPwd);
    }

    public BaseClient(String host, String port, String version, String appKey, String appPwd, String proxyIp, String proxyPort) {
        this.host = host;
        this.port = port;
        this.version = version;
        this.service = new HttpClientService(appKey, appPwd, proxyIp, proxyPort);
    }

    public void setSSL(boolean sslParam) {
        this.isSSL = sslParam;
    }

    protected String getServiceUrl(String action) {
        StringBuffer localStringBuffer = new StringBuffer((this.isSSL ? "https" : "http") + "://" + this.host + ":" + this.port + "/" + action);
        return localStringBuffer.toString();
    }
}

