/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.entity;

import cn.com.jsgxca.client.entity.GxBase;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GxCertificate
extends GxBase {
    private String certBase64String;
    private X509CertificateHolder certificate;

    public GxCertificate(Map<String, String> responseMap) throws IOException {
        super(responseMap);
        this.certBase64String = responseMap.get("b64_cert");
        this.certificate = new X509CertificateHolder(this.getCertEncoded());
    }

    public String getSubject() {
        return this.certificate == null ? null : this.canonicalX500Name(this.certificate.getSubject()).toString();
    }

    public String getIssuer() {
        return this.certificate == null ? null : this.canonicalX500Name(this.certificate.getIssuer()).toString();
    }

    public Date getNotBefore() {
        return this.certificate == null ? null : this.certificate.getNotBefore();
    }

    public Date getNotAfter() {
        return this.certificate == null ? null : this.certificate.getNotAfter();
    }

    public String getHexSerial() {
        return this.certificate == null ? null : this.certificate.getSerialNumber().toString(16).toUpperCase();
    }

    public String getDecSerial() {
        return this.certificate == null ? null : this.certificate.getSerialNumber().toString();
    }

    public byte[] getCertEncoded() {
        return this.certBase64String == null ? null : Base64.decode((String)this.certBase64String);
    }

    public String getCertBase64String() {
        return this.certBase64String == null ? "" : this.certBase64String;
    }

    private X500Name canonicalX500Name(X500Name paramX500Name) {
        RDN[] arrayOfRDN = this.transferDERT61String2DERUTF8String(paramX500Name.getRDNs());
        return new X500Name(arrayOfRDN);
    }

    private RDN[] transferDERT61String2DERUTF8String(RDN[] paramArrayOfRDN) {
        RDN[] arrayOfRDN1 = new RDN[paramArrayOfRDN.length];
        AttributeTypeAndValue localAttributeTypeAndValue = null;
        ASN1Encodable localASN1Encodable = null;
        DERUTF8String localDERUTF8String = null;
        int i = 0;
        RDN[] rDNArray = paramArrayOfRDN;
        int n = paramArrayOfRDN.length;
        int n2 = 0;
        while (n2 < n) {
            RDN localRDN = rDNArray[n2];
            localAttributeTypeAndValue = localRDN.getFirst();
            localASN1Encodable = localAttributeTypeAndValue.getValue();
            if (localASN1Encodable instanceof DERT61String) {
                try {
                    localDERUTF8String = new DERUTF8String(new String(((DERT61String)localASN1Encodable).getOctets(), "UTF-8"));
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException) {
                    localUnsupportedEncodingException.printStackTrace();
                }
                localAttributeTypeAndValue = new AttributeTypeAndValue(localAttributeTypeAndValue.getType(), localDERUTF8String);
                arrayOfRDN1[i] = new RDN(localAttributeTypeAndValue);
            } else {
                arrayOfRDN1[i] = localRDN;
            }
            ++i;
            ++n2;
        }
        return arrayOfRDN1;
    }

    public String getPublicKeyAlgo() {
        if (this.certificate == null) {
            return null;
        }
        if ("1.2.840.113549.1.1.1".equals(this.certificate.getSubjectPublicKeyInfo().getAlgorithmId().getAlgorithm().getId())) {
            return "RSA";
        }
        return "SM2";
    }
}

