/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jsgxca.client.cert;

import cn.com.jsgxca.client.exception.JSGXCAException;
import cn.com.jsgxca.client.util.StringUtil;
import com.custle.security.common.util.KeyFromDER;
import com.custle.security.common.util.SignatureAlgorithmConvert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateInfo {
    private String issuer;
    private String subject;
    private String commonName;
    private PublicKey publicKey;
    private ECPublicKeyParameters ecPublicKeyParam;
    private byte[] signData;
    private String signAlg;
    private String keyAlg;
    private int keyLength;
    private String serialNumber;
    private Certificate certificate;
    private X509Certificate x509Certificate;
    private String base64CertString;
    private Extensions extensions;
    private int version;
    private Date notBefore;
    private Date notAfter;
    private Map<String, String> subjectDN;

    public CertificateInfo(byte[] cert) throws JSGXCAException {
        byte[] cc = StringUtil.checkPEM(cert);
        if (cc == null) {
            cert = Base64.encode((byte[])cert);
        }
        String base64CertString = new String(cert);
        this.decode(base64CertString);
    }

    public CertificateInfo(String base64CertString) throws JSGXCAException {
        this.decode(base64CertString);
    }

    private void decode(String cert) throws JSGXCAException {
        try {
            cert = cert.replaceAll("-----BEGIN NEW CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("-----END NEW CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("(\r\n|\r|\n|\n\r)", "");
            cert = cert.replaceAll("-----BEGIN CERTIFICATE-----", "");
            cert = cert.replaceAll("-----END CERTIFICATE-----", "");
            cert = cert.replaceAll("-----BEGIN CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("-----END CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("-----BEGINCERTIFICATE-----", "");
            cert = cert.replaceAll("-----ENDCERTIFICATE-----", "");
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)cert));
            ASN1InputStream ais = new ASN1InputStream((InputStream)bais);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)ais.readObject());
            ais.close();
            this.certificate = Certificate.getInstance((Object)seq);
            this.issuer = this.certificate.getIssuer().toString();
            this.subject = this.certificate.getSubject().toString();
            if (this.subject != null && !"".equals(this.subject)) {
                this.subjectDN = new HashMap<String, String>();
                String[] s1 = this.subject.split(",");
                int i = 0;
                while (i < s1.length) {
                    try {
                        String key = s1[i].split("=")[0];
                        String value = s1[i].split("=")[1];
                        this.subjectDN.put(key, value);
                    }
                    catch (Exception e) {
                        System.out.println("Parse Cert Error:" + this.subject + "[" + s1[i] + "]");
                        e.printStackTrace();
                    }
                    ++i;
                }
                this.commonName = this.subjectDN.get("CN");
            }
            this.keyAlg = this.getPublicKeyAlgoFromCert(cert);
            this.signAlg = SignatureAlgorithmConvert.getAlgByIdentify(this.certificate.getSignatureAlgorithm());
            this.signData = this.certificate.getSignature().getBytes();
            this.serialNumber = Hex.toHexString((byte[])this.certificate.getSerialNumber().getValue().toByteArray()).toUpperCase();
            this.extensions = this.certificate.getTBSCertificate().getExtensions();
            this.version = this.certificate.getVersionNumber();
            this.notBefore = this.certificate.getStartDate().getDate();
            this.notAfter = this.certificate.getEndDate().getDate();
            this.base64CertString = cert;
            this.x509Certificate = new X509CertificateObject(this.certificate);
            this.publicKey = KeyFromDER.getPublicKeyFromCert(cert);
            if (this.publicKey != null && this.publicKey.getEncoded() != null) {
                this.keyLength = this.publicKey.getEncoded().length;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JSGXCAException("\u8bc1\u4e66\u89e3\u6790\u51fa\u9519\uff01", e);
        }
    }

    public String getX509CertificateExtension(String oid) throws IOException {
        ASN1Encodable obj;
        String value = null;
        if (this.extensions != null && (obj = this.extensions.getExtensionParsedValue(new ASN1ObjectIdentifier(oid))) != null) {
            value = obj.toString();
        }
        return value;
    }

    public String[] getCrlAddress() throws Exception {
        String[] crlUrls = null;
        try {
            ASN1Encodable obj = this.extensions.getExtensionParsedValue(X509Extensions.CRLDistributionPoints);
            if (obj != null) {
                ASN1Sequence as = (ASN1Sequence)obj;
                int size = as.size();
                crlUrls = new String[size];
                int i = 0;
                while (i < size) {
                    ASN1Sequence dpas = ASN1Sequence.getInstance((Object)as.getObjectAt(i));
                    DistributionPoint point = new DistributionPoint(dpas);
                    DistributionPointName distributionPointName = point.getDistributionPoint();
                    if (distributionPointName != null && distributionPointName.getType() == 0) {
                        GeneralNames distributionPointNames = (GeneralNames)distributionPointName.getName();
                        GeneralName[] dpns = distributionPointNames.getNames();
                        crlUrls[i] = dpns[0].getName().toString();
                    }
                    ++i;
                }
            }
            return crlUrls;
        }
        catch (Exception e) {
            throw new Exception("get Ext Crl Distribution Point error!", e);
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignData() {
        return this.signData;
    }

    public String getSignAlg() {
        return this.signAlg;
    }

    public String getKeyAlg() {
        return this.keyAlg;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public int getVersion() {
        return this.version;
    }

    public String getBase64CertString() {
        return this.base64CertString;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public Map<String, String> getSubjectDN() {
        return this.subjectDN;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ECPublicKeyParameters getEcPublicKeyParam() {
        return this.ecPublicKeyParam;
    }

    private String getPublicKeyAlgoFromCert(String cert) throws NoSuchAlgorithmException, IOException {
        ASN1InputStream is = null;
        try {
            cert = cert.replaceAll("-----BEGIN NEW CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("-----END NEW CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("(\r\n|\r|\n|\n\r)", "");
            cert = cert.replaceAll("-----BEGIN CERTIFICATE-----", "");
            cert = cert.replaceAll("-----END CERTIFICATE-----", "");
            cert = cert.replaceAll("-----BEGIN CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("-----END CERTIFICATE REQUEST-----", "");
            cert = cert.replaceAll("-----BEGINCERTIFICATE-----", "");
            cert = cert.replaceAll("-----ENDCERTIFICATE-----", "");
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)cert));
            is = new ASN1InputStream((InputStream)bais);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)is.readObject());
            Certificate certificate = Certificate.getInstance((Object)seq);
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
            String string = SignatureAlgorithmConvert.getAlgByIdentify(subjectPublicKeyInfo.getAlgorithm());
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public BCECPublicKey convertPublicKey(byte[] derBytes) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec eks = new X509EncodedKeySpec(derBytes);
        KeyFactory kf = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        return (BCECPublicKey)kf.generatePublic(eks);
    }

    public SubjectPublicKeyInfo getPublicKeyInfo(byte[] certBytes) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(certBytes);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)inStream);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        Certificate cert = Certificate.getInstance((Object)seq);
        SubjectPublicKeyInfo publicKeyInfo = cert.getSubjectPublicKeyInfo();
        return publicKeyInfo;
    }

    public ECPublicKeyParameters convertPublicKey(BCECPublicKey ecPubKey) {
        ECParameterSpec parameterSpec = ecPubKey.getParameters();
        ECDomainParameters domainParameters = new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
        return new ECPublicKeyParameters(ecPubKey.getQ(), domainParameters);
    }

    public BCECPublicKey convertPublicKey(SubjectPublicKeyInfo subPubInfo) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return this.convertPublicKey(subPubInfo.toASN1Primitive().getEncoded("DER"));
    }

    public static void main(String[] args) {
        String cert = "MIIEhzCCBCqgAwIBAgIMd4gAAAAkvCniSyqvMAwGCCqBHM9VAYN1BQAwRDELMAkGA1UEBhMCQ04xDzANBgNVBAoMBkpTR1hDQTEPMA0GA1UECwwGSlNHWENBMRMwEQYDVQQDDApKU0dYQ0FfU00yMB4XDTIwMTIwOTA3MDg1N1oXDTIyMTIwOTA3MDg1NlowggFZMREwDwYDVQQtDAhlbnRDZXJ0NDFZMFcGA1UECgxQ5YyX5Lqs5pyd6Ziz5Yy66KW/5aSn5pyb6LevM+WPt+mZouiTneWgoeWbvemZheWkp+WOpjHluqcyNjAyLCDpmYjlqIEgMTc2MTA3OTAxMDExGzAZBgNVBB8MEjkxNDMxMzIyNzgwODU5OTE1SjEbMBkGA1UEAQwSOTE0MzEzMjI3ODA4NTk5MTVKMRswGQYDVQQPDBI5MTQzMTMyMjc4MDg1OTkxNUoxEjAQBgNVBBoMCeaWsOWMluWOvzESMBAGA1UEBwwJ5aiE5bqV5biCMRIwEAYDVQQIDAnmuZbljZfnnIExCzAJBgNVBAYTAkNOMQwwCgYDVQRYDAMwMDExDDAKBgNVBAsMAzA0NTEtMCsGA1UEAwwk5rmW5Y2X5L2z5ZCI5Yy755So5p2Q5paZ5pyJ6ZmQ5YWs5Y+4MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE0sdJ+Za7nWgXdkJm/b/XQZb4qcBNPylI0GjSJRJSe9ktNJuMw4VOnMnVoabO72G/Bh3BuXigXP+2KCgoXUNGsKOCAecwggHjMBEGCWCGSAGG+EIBAQQEAwIAgDALBgNVHQ8EBAMCAMAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMAwGA1UdEwQFMAMBAQAwHwYDVR0jBBgwFoAUygMIinkWfWh0E2Qd9VTv8JIirl8wgasGA1UdHwSBozCBoDCBnaCBmqCBl4aBlGxkYXA6Ly8xODAuOTYuMTMuMjAwOjM4OS9DTj1KU0dYQ0FfU00yLENOPUpTR1hDQV9TTTIsIE9VPUNSTERpc3RyaWJ1dGVQb2ludHMsIG89Z3hjYT9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwgaUGCCsGAQUFBwEBBIGYMIGVMIGSBggrBgEFBQcwAoaBhWxkYXA6Ly8xODAuOTYuMTMuMjAwOjM4OS9DTj1KU0dYQ0FfU00yLENOPUpTR1hDQV9TTTIsIE9VPWNBQ2VydGlmaWNhdGVzLCBvPWd4Y2E/Y0FDZXJ0aWZpY2F0ZT9iYXNlP29iamVjdENsYXNzPWNlcnRpZmljYXRpb25BdXRob3JpdHkwHQYDVR0OBBYEFKzTi9Pn47z7gaJBu0GD3k/jCB2LMAwGCCqBHM9VAYN1BQADSQAwRgIhAOogc+r9GcFJaPD0becA35eVoeFBLWYq0vS6SbFFyfZmAiEAgBCaRFy4VN6ILDNnFl0IDL7QRgcKSXElZoF3IM+pErA=";
        try {
            new CertificateInfo(cert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

