define([
    'echarts'
], function(
    echarts
) {
    'use strict';
    return echarts.extendComponentView({
        type: 'GLMap',
        _api:'',
        _listen:false,
        init: function(ecModel, api) {
            var glMap = echarts.glMap;
            this._api = api;
            echarts.glMap.postRender.addEventListener(this.moveHandler, this);
        },
        moveHandler:function () {
            this._api.dispatchAction({
                type: 'GLMapRoam'
            });
        },
        render: function(GLMapModel, ecModel, api) {},
        dispose: function (e) {
            echarts.glMap.postRender.removeEventListener(this.moveHandler, this)
        }
    })
});