/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(n,i){if(!e(i))throw new t(r(n))},i.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},i.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},i.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},i.typeOf.number.lessThan=function(e,r,n){if(i.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},i.typeOf.number.lessThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},i.typeOf.number.greaterThan=function(e,r,n){if(i.typeOf.number(e,r),n>=r)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},i.typeOf.number.greaterThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),n>r)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},i.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},i.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},i.typeOf.number.equals=function(e,r,n,a){if(i.typeOf.number(e,n),i.typeOf.number(r,a),n!==a)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+a)},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,i){"use strict";var a={};a.Radius=6378137,a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.EPSILON21=1e-21,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*a.clamp(e,-1,1)+.5)*t)},a.fromSNorm=function(e,t){return t=r(t,255),a.clamp(e,0,t)/t*2-1},a.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),a.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},a.equalsEpsilon=function(e,t,a,o){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(a))throw new i("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-t);return o>=u||u<=a*Math.max(Math.abs(e),Math.abs(t))},a.lessThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return-r>e-t},a.lessThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return r>e-t},a.greaterThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>r},a.greaterThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>-r};var o=[1];a.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var t=o.length;if(e>=t)for(var r=o[t-1],n=t;e>=n;n++)o.push(r*n);return o[e]},a.incrementWrap=function(e,t,a){if(a=r(a,0),!n(e))throw new i("n is required.");if(a>=t)throw new i("maximumValue must be greater than minimumValue.");return++e,e>t&&(e=a),e},a.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return t>e?t:e>r?r:e};var u=new e;return a.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},a.nextRandomNumber=function(){return u.random()},a.randomBetween=function(e,t){return a.nextRandomNumber()*(t-e)+e},a.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},a.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return 0>e?-t:t}),a.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),a.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},a.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},a.fastApproximateAtan2=function(e,r){t.typeOf.number("x",e),t.typeOf.number("y",r);var n,o,u=Math.abs(e);n=Math.abs(r),o=Math.max(u,n),n=Math.min(u,n);var s=n/o;if(isNaN(s))throw new i("either x or y must be nonzero");return u=a.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?a.PI_OVER_TWO-u:u,u=0>e?a.PI-u:u,u=0>r?-u:u},a}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;i>a;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;i>a;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f),a.acosClamped(o.dot(c,f))};var l=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;i>a;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;a>u;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f);var n=o.dot(c,f),i=o.magnitude(o.cross(c,f,c));return Math.atan2(i,n)};var l=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=o.dot(t,r)/o.dot(r,r);return o.multiplyByScalar(r,i,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,f=a*c-o*s,l=o*u-i*c,d=i*s-a*u;return n.x=f,n.y=l,n.z=d,n},o.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var d=new o,h=new o,p=new o(40680631590769,40680631590769,40408299984661.445),m=new o(40680631590769,40680631590769,40680631590769);return o.fromRadians=function(n,i,u,s,c){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),u=t(u,0);var f=r(s)?s.radiiSquared:m;a.equalsEpsilon(a.Radius,6356752.314245179,a.EPSILON10)&&(f=r(s)?s.radiiSquared:p);var l=Math.cos(i);d.x=l*Math.cos(n),d.y=l*Math.sin(n),d.z=Math.sin(i),d=o.normalize(d,d),o.multiplyComponents(f,d,h);var y=Math.sqrt(o.dot(d,h));return h=o.divideByScalar(h,y,h),d=o.multiplyByScalar(d,u,d),r(c)||(c=new o),o.add(h,d,c)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromDegrees(c,f,0,i,a[l])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromRadians(c,f,0,i,a[l])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],d=s/3;a[d]=o.fromDegrees(c,f,l,i,a[d])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],d=s/3;a[d]=o.fromRadians(c,f,l,i,a[d])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],function(e,t,r,n,i,a){"use strict";function o(e){return d[0]=e,d[0]}function u(e){return e>>1^-(1&e)}var s=1/256,c=256,f={};f.octEncodeInRange=function(e,n,o){r.defined("vector",e),r.defined("result",o);var u=t.magnitudeSquared(e);if(Math.abs(u-1)>a.EPSILON6)throw new i("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,c=o.y;o.x=(1-Math.abs(c))*a.signNotZero(s),o.y=(1-Math.abs(s))*a.signNotZero(c)}return o.x=a.toSNorm(o.x,n),o.y=a.toSNorm(o.y,n),o},f.octEncode=function(e,t){return f.octEncodeInRange(e,255,t)};var l=new e,d=new Uint8Array(1);f.octEncodeToCartesian4=function(e,t){return f.octEncodeInRange(e,65535,l),t.x=o(l.x*s),t.y=o(l.x),t.z=o(l.y*s),t.w=o(l.y),t},f.octDecodeInRange=function(e,n,o,u){if(r.defined("result",u),0>e||e>o||0>n||n>o)throw new i("x and y must be unsigned normalized integers between 0 and "+o);if(u.x=a.fromSNorm(e,o),u.y=a.fromSNorm(n,o),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*a.signNotZero(s),u.y=(1-Math.abs(s))*a.signNotZero(u.y)}return t.normalize(u,u)},f.octDecode=function(e,t,r){return f.octDecodeInRange(e,t,255,r)},f.octDecodeFromCartesian4=function(e,t){r.typeOf.object("encoded",e),r.typeOf.object("result",t);var n=e.x,a=e.y,o=e.z,u=e.w;if(0>n||n>255||0>a||a>255||0>o||o>255||0>u||u>255)throw new i("x, y, z, and w must be unsigned normalized integers between 0 and 255");var s=n*c+a,l=o*c+u;return f.octDecodeInRange(s,l,65535,t)},f.octPackFloat=function(e){return r.defined("encoded",e),256*e.x+e.y};var h=new e;return f.octEncodeFloat=function(e){return f.octEncode(e,h),f.octPackFloat(h)},f.octDecodeFloat=function(e,t){r.defined("value",e);var n=e/256,i=Math.floor(n),a=256*(n-i);return f.octDecode(i,a,t)},f.octPack=function(e,t,n,i){r.defined("v1",e),r.defined("v2",t),r.defined("v3",n),r.defined("result",i);var a=f.octEncodeFloat(e),o=f.octEncodeFloat(t),u=f.octEncode(n,h);return i.x=65536*u.x+a,i.y=65536*u.y+o,i},f.octUnpack=function(e,t,n,i){r.defined("packed",e),r.defined("v1",t),r.defined("v2",n),r.defined("v3",i);var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);f.octDecodeFloat(u,t),f.octDecodeFloat(c,n),f.octDecode(o,s,i)},f.compressTextureCoordinates=function(e){r.defined("textureCoordinates",e);var t=4095*e.x|0,n=4095*e.y|0;return 4096*t+n},f.decompressTextureCoordinates=function(e,t){r.defined("compressed",e),r.defined("result",t);var n=e/4096,i=Math.floor(n);return t.x=i/4095,t.y=(e-4096*i)/4095,t},f.zigZagDeltaDecode=function(e,t,i){r.defined("uBuffer",e),r.defined("vBuffer",t),r.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),n(i)&&r.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,i.length);for(var a=e.length,o=0,s=0,c=0,f=0;a>f;++f)o+=u(e[f]),s+=u(t[f]),e[f]=o,t[f]=s,n(i)&&(c+=u(i[f]),i[f]=c)},f.octShortToFloat=function(e){return a.clamp(3051850947599719e-20*e,-1,1)},f.octShortDecode=function(e,n,i){if(r.defined("result",i),i.x=f.octShortToFloat(e),i.y=f.octShortToFloat(n),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){var o=i.x;i.x=(1-Math.abs(i.y))*a.signNotZero(o),i.y=(1-Math.abs(o))*a.signNotZero(i.y)}return t.normalize(i,i)},f}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(i,u,s,c,f){if(!t(i))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=i.x,d=i.y,h=i.z,p=u.x,m=u.y,y=u.z,E=l*l*p*p,O=d*d*m*m,_=h*h*y*y,w=E+O+_,T=Math.sqrt(1/w),R=e.multiplyByScalar(i,T,a);if(c>w)return isFinite(T)?e.clone(R,f):void 0;var v=s.x,g=s.y,A=s.z,b=o;b.x=R.x*v*2,b.y=R.y*g*2,b.z=R.z*A*2;var S,N,I,x,M,C,P,U,q,D,L,B=(1-T)*e.magnitude(i)/(.5*e.magnitude(b)),F=0;do{B-=F,I=1/(1+B*v),x=1/(1+B*g),M=1/(1+B*A),C=I*I,P=x*x,U=M*M,q=C*I,D=P*x,L=U*M,S=E*C+O*P+_*U-1,N=E*q*v+O*D*g+_*L*A;var j=-2*N;F=S/j}while(Math.abs(S)>n.EPSILON12);return t(f)?(f.x=l*I,f.y=d*x,f.z=h*M,f):new e(l*I,d*x,h*M)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,a,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),a=r(a,0),n(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=a.toRadians(e),r=a.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/6378137,1/6378137,1/6378137),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),p=new e(1/40680631590769,1/40680631590769,1/40680631590769),m=a.EPSILON1;return u.fromCartesian=function(t,r,i){var y=n(r)?r.oneOverRadii:d,E=n(r)?r.oneOverRadiiSquared:p,O=n(r)?r._centerToleranceSquared:m;a.equalsEpsilon(a.Radius,6356752.314245179,a.EPSILON10)&&(y=n(r)?r.oneOverRadii:l,E=n(r)?r.oneOverRadiiSquared:h);var _=o(t,y,E,O,c);if(n(_)){var w=e.multiplyComponents(_,E,s);w=e.normalize(w,w);var T=e.subtract(t,_,f),R=Math.atan2(w.y,w.x),v=Math.asin(w.z),g=a.sign(e.dot(T,t))*e.magnitude(T);return n(i)?(i.longitude=R,i.latitude=v,i.height=g,i):new u(R,v,g)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.sphericalDistance=function(e,r,n,i){if(t.defined("longitudeA",e),t.defined("longitudeB",n),t.defined("latitudeA",r),t.defined("latitudeB",i),e===n&&r===i)return 0;var o=a.toRadians(r),u=a.toRadians(i),s=a.toRadians(e),c=a.toRadians(n),f=s*s+o*o,l=c*c+u*u,d=(s-c)*(s-c)+(o-u)*(o-u),h=(f+l-d)/(2*Math.sqrt(f)*Math.sqrt(l));return h=a.clamp(h,-1,1),Math.acos(h)*a.Radius},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(t,i,a,o){i=n(i,0),a=n(a,0),o=n(o,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",a,0),r.typeOf.number.greaterThanOrEquals("z",o,0),s.equalsEpsilon(o,6356752.314245179,s.EPSILON10)&&(s.Radius=o),t._radii=new e(i,a,o),t._radiiSquared=new e(i*i,a*a,o*o),t._radiiToTheFourth=new e(i*i*i*i,a*a*a*a,o*o*o*o),t._oneOverRadii=new e(0===i?0:1/i,0===a?0:1/a,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===a?0:1/(a*a),0===o?0:1/(o*o)),t._minimumRadius=Math.min(i,a,o),t._maximumRadius=Math.max(i,a,o),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return i(t)||(t=new l),i(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,s.Radius)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,i,a){return r.typeOf.object("value",t),r.defined("array",i),a=n(a,0),e.pack(t._radii,i,a),i},l.unpack=function(t,i,a){r.defined("array",t),i=n(i,0);var o=e.unpack(t,i);return l.fromCartesian3(o,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var a=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(a),c=u*Math.sin(a),f=Math.sin(o);return i(n)||(n=new e),n.x=s,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var d=new e,h=new e;l.prototype.cartographicToCartesian=function(t,r){var n=d,a=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,a);var o=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(a,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);
for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var p=new e,m=new e,y=new e;return l.prototype.cartesianToCartographic=function(r,n){var a=this.scaleToGeodeticSurface(r,m);if(i(a)){var o=this.geodeticSurfaceNormal(a,p),u=e.subtract(r,a,y),c=Math.atan2(o.y,o.x),f=Math.asin(o.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var a=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(a*a*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new o("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),a=n(a,0);var c=this._squaredXOverSquaredZ;return i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),Math.abs(u.z)>=this._radii.z-a?void 0:u},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function f(e){for(var t=0,r=0;3>r;++r){var n=e[s.getElementIndex(m[r],p[r])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;3>a;++a){var o=Math.abs(e[s.getElementIndex(m[a],p[a])]);o>n&&(i=a,n=o)}var c=1,f=0,l=p[i],d=m[i];if(Math.abs(e[s.getElementIndex(d,l)])>r){var h,y=e[s.getElementIndex(d,d)],E=e[s.getElementIndex(l,l)],O=e[s.getElementIndex(d,l)],_=(y-E)/2/O;h=0>_?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),c=1/Math.sqrt(1+h*h),f=h*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(l,l)]=t[s.getElementIndex(d,d)]=c,t[s.getElementIndex(d,l)]=f,t[s.getElementIndex(l,d)]=-f,t}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,d=e.z*e.z,h=e.z*e.w,p=e.w*e.w,m=i-c-d+p,y=2*(a-h),E=2*(o+l),O=2*(a+h),_=-i+c-d+p,w=2*(f-u),T=2*(o-l),R=2*(f+u),v=-i-c+d+p;return n(r)?(r[0]=m,r[1]=O,r[2]=T,r[3]=y,r[4]=_,r[5]=R,r[6]=E,r[7]=w,r[8]=v,r):new s(m,y,E,O,_,w,T,R,v)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=i*a,d=-o*c+f*u*a,h=f*c+o*u*a,p=i*c,m=o*a+f*u*c,y=-f*a+o*u*c,E=-u,O=f*i,_=o*i;return n(r)?(r[0]=l,r[1]=p,r[2]=E,r[3]=d,r[4]=m,r[5]=O,r[6]=h,r[7]=y,r[8]=_,r):new s(l,d,h,p,m,y,E,O,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i);var a=3*r;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i),i[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var d=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],d)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],d)),n};var h=new e;s.getMaximumScale=function(t){return s.getScale(t,h),e.maximumComponent(h)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=d,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var p=[1,0,0],m=[2,2,1],y=new s,E=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=10,o=0,d=0;n(r)||(r={});for(var h=r.unitary=s.clone(s.IDENTITY,r.unitary),p=r.diagonal=s.clone(e,r.diagonal),m=i*c(p);a>d&&f(p)>m;)l(p,y),s.transpose(y,E),s.multiply(p,y,p),s.multiply(E,p,p),s.multiply(h,y,h),++o>2&&(++d,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(o*f-c*u)+a*(c*i-n*f)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],f=e[4],l=e[5],d=e[6],h=e[7],p=e[8],m=s.determinant(e);if(Math.abs(m)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=f*p-h*l,r[1]=h*o-i*p,r[2]=i*l-f*o,r[3]=d*l-c*p,r[4]=n*p-d*o,r[5]=c*o-n*l,r[6]=c*h-d*f,r[7]=d*i-n*h,r[8]=n*f-c*i;var y=1/m;return s.multiplyByScalar(r,y,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;i>a;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;i>a;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1),l=256,d=65536,h=16777216,p=1/l,m=1/d,y=1/h,E=38;return o.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new o),f[0]=t,t=f[0],0===t)return o.clone(o.ZERO,n);var i,u=0>t?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(a.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=E);var s=t*l;return n.x=Math.floor(s),s=(s-n.x)*l,n.y=Math.floor(s),s=(s-n.y)*l,n.z=Math.floor(s),n.w=2*(i+E)+u,n},o.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(n-=E,i=2*i-1,i=-i,n>=E)return 0>i?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=i*t.x*p;return a+=i*t.y*m,a+=i*t.z*y,a*Math.pow(10,n)},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(e,t,r,i,a,o,u,s,c,f,l,d,h,p,m,y){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(f,0),this[7]=n(p,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(m,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(d,0),this[15]=n(y,0)}f.packedLength=16,f.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},f.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new f),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},f.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new f(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new f);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,d=t.x*t.z,h=t.x*t.w,p=t.y*t.y,m=t.y*t.z,y=t.y*t.w,E=t.z*t.z,O=t.z*t.w,_=t.w*t.w,w=c-p-E+_,T=2*(l-O),R=2*(d+y),v=2*(l+O),g=-c+p-E+_,A=2*(m-h),b=2*(d-y),S=2*(m+h),N=-c-p+E+_;return a[0]=w*o,a[1]=v*o,a[2]=b*o,a[3]=0,a[4]=T*u,a[5]=g*u,a[6]=S*u,a[7]=0,a[8]=R*s,a[9]=A*s,a[10]=N*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,d=new e,h=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,l),e.normalize(e.cross(l,u,d),d),e.normalize(e.cross(d,l,h),h);var s=d.x,c=d.y,p=d.z,m=l.x,y=l.y,E=l.z,O=h.x,_=h.y,w=h.z,T=a.x,R=a.y,v=a.z,g=s*-T+c*-R+p*-v,A=O*-T+_*-R+w*-v,b=m*T+y*R+E*v;return i(n)?(n[0]=s,n[1]=O,n[2]=-m,n[3]=0,n[4]=c,n[5]=_,n[6]=-y,n[7]=0,n[8]=p,n[9]=w,n[10]=-E,n[11]=0,n[12]=g,n[13]=A,n[14]=b,n[15]=1,n):new f(s,c,p,g,O,_,w,A,-m,-y,-E,b,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=Math.tan(.5*e),u=1/o,s=u/t,c=(i+n)/(n-i),f=2*i*n/(n-i);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},f.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),f=1/(o-a),l=-(t+e)*s,d=-(i+n)*c,h=-(o+a)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=d,u[14]=h,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),f=(t+e)/(t-e),l=(i+n)/(i-n),d=-(o+a)/(o-a),h=-1,p=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=d,u[11]=h,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),f=(i+n)/(i-n),l=-1,d=-1,h=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=f,o[10]=l,o[11]=d,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},f.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),i=n(i,1);var f=.5*s,l=.5*c,d=.5*(i-t),h=f,p=l,m=d,y=o+f,E=u+l,O=t+d,_=1;return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=p,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=m,a[11]=0,a[12]=y,a[13]=E,a[14]=O,a[15]=_,a},f.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},f.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i);var a=4*t;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var p=new e;f.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var a=f.getScale(t,p),o=e.divideComponents(n,a,p);return f.multiplyByScale(t,o,i)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},f.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var m=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],m)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],m)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],m)),n};var y=new e;f.getMaximumScale=function(t){return f.getScale(t,y),e.maximumComponent(y)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],d=e[8],h=e[9],p=e[10],m=e[11],y=e[12],E=e[13],O=e[14],_=e[15],w=t[0],T=t[1],R=t[2],v=t[3],g=t[4],A=t[5],b=t[6],S=t[7],N=t[8],I=t[9],x=t[10],M=t[11],C=t[12],P=t[13],U=t[14],q=t[15],D=i*w+s*T+d*R+y*v,L=a*w+c*T+h*R+E*v,B=o*w+f*T+p*R+O*v,F=u*w+l*T+m*R+_*v,j=i*g+s*A+d*b+y*S,z=a*g+c*A+h*b+E*S,G=o*g+f*A+p*b+O*S,V=u*g+l*A+m*b+_*S,W=i*N+s*I+d*x+y*M,X=a*N+c*I+h*x+E*M,H=o*N+f*I+p*x+O*M,k=u*N+l*I+m*x+_*M,Y=i*C+s*P+d*U+y*q,K=a*C+c*P+h*U+E*q,Z=o*C+f*P+p*U+O*q,J=u*C+l*P+m*U+_*q;return n[0]=D,n[1]=L,n[2]=B,n[3]=F,n[4]=j,n[5]=z,n[6]=G,n[7]=V,n[8]=W,n[9]=X,n[10]=H,n[11]=k,n[12]=Y,n[13]=K,n[14]=Z,n[15]=J,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],d=e[10],h=e[12],p=e[13],m=e[14],y=t[0],E=t[1],O=t[2],_=t[4],w=t[5],T=t[6],R=t[8],v=t[9],g=t[10],A=t[12],b=t[13],S=t[14],N=i*y+u*E+f*O,I=a*y+s*E+l*O,x=o*y+c*E+d*O,M=i*_+u*w+f*T,C=a*_+s*w+l*T,P=o*_+c*w+d*T,U=i*R+u*v+f*g,q=a*R+s*v+l*g,D=o*R+c*v+d*g,L=i*A+u*b+f*S+h,B=a*A+s*b+l*S+p,F=o*A+c*b+d*S+m;return n[0]=N,n[1]=I,n[2]=x,n[3]=0,n[4]=M,n[5]=C,n[6]=P,n[7]=0,n[8]=U,n[9]=q,n[10]=D,n[11]=0,n[12]=L,n[13]=B,n[14]=F,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],d=e[10],h=t[0],p=t[1],m=t[2],y=t[3],E=t[4],O=t[5],_=t[6],w=t[7],T=t[8],R=i*h+u*p+f*m,v=a*h+s*p+l*m,g=o*h+c*p+d*m,A=i*y+u*E+f*O,b=a*y+s*E+l*O,S=o*y+c*E+d*O,N=i*_+u*w+f*T,I=a*_+s*w+l*T,x=o*_+c*w+d*T;return n[0]=R,n[1]=v,n[2]=g,n[3]=0,n[4]=A,n[5]=b,n[6]=S,n[7]=0,n[8]=N,n[9]=I,n[10]=x,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?f.clone(e,n):(n[0]=i*e[0],
n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,f=e[2]*i+e[6]*a+e[10]*o+e[14]*u,l=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.multiplyByPlane=function(n,i,a){r.typeOf.object("matrix",n),r.typeOf.object("plane",i),r.typeOf.object("result",a);var o=new f,u=new f;f.inverse(n,o),f.transpose(o,u);var s=new t(i.normal.x,i.normal.y,i.normal.z,i.distance);f.multiplyByVector(u,s,s),a.normal.x=s.x,a.normal.y=s.y,a.normal.z=s.z;var c=e.magnitude(a.normal);return e.normalize(a.normal,a.normal),a.distance=s.w/c,a},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,_=new s,w=new t,T=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],a=e[4],o=e[8],l=e[12],d=e[1],h=e[5],p=e[9],m=e[13],y=e[2],E=e[6],R=e[10],v=e[14],g=e[3],A=e[7],b=e[11],S=e[15],N=R*S,I=v*b,x=E*S,M=v*A,C=E*b,P=R*A,U=y*S,q=v*g,D=y*b,L=R*g,B=y*A,F=E*g,j=N*h+M*p+C*m-(I*h+x*p+P*m),z=I*d+U*p+L*m-(N*d+q*p+D*m),G=x*d+q*h+B*m-(M*d+U*h+F*m),V=P*d+D*h+F*p-(C*d+L*h+B*p),W=I*a+x*o+P*l-(N*a+M*o+C*l),X=N*i+q*o+D*l-(I*i+U*o+L*l),H=M*i+U*a+F*l-(x*i+q*a+B*l),k=C*i+L*a+B*o-(P*i+D*a+F*o);N=o*m,I=l*p,x=a*m,M=l*h,C=a*p,P=o*h,U=i*m,q=l*d,D=i*p,L=o*d,B=i*h,F=a*d;var Y=N*A+M*b+C*S-(I*A+x*b+P*S),K=I*g+U*b+L*S-(N*g+q*b+D*S),Z=x*g+q*A+B*S-(M*g+U*A+F*S),J=P*g+D*A+F*b-(C*g+L*A+B*b),Q=x*R+P*v+I*E-(C*v+N*E+M*R),$=D*v+N*y+q*R-(U*R+L*v+I*y),ee=U*E+F*v+M*y-(B*v+x*y+q*E),te=B*R+C*y+L*E-(D*E+F*R+P*y),re=i*j+a*z+o*G+l*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(f.getRotation(e,O),_,u.EPSILON7)&&t.equals(f.getRow(e,3,w),T))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=j*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=W*re,n[5]=X*re,n[6]=H*re,n[7]=k*re,n[8]=Y*re,n[9]=K*re,n[10]=Z*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],d=e[12],h=e[13],p=e[14],m=-n*d-i*h-a*p,y=-o*d-u*h-s*p,E=-c*d-f*h-l*p;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=f,t[7]=0,t[8]=a,t[9]=s,t[10]=l,t[11]=0,t[12]=m,t[13]=y,t[14]=E,t[15]=1,t},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,a(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,d=0,h=e.length;h>d;d++){var p=e[d];i=Math.min(i,p.longitude),a=Math.max(a,p.longitude),f=Math.min(f,p.latitude),l=Math.max(l,p.latitude);var m=p.longitude>=0?p.longitude:p.longitude+u.TWO_PI;o=Math.min(o,m),c=Math.max(c,m)}return a-i>c-o&&(i=o,a=c,a>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=f,r.east=a,r.north=l,r):new s(i,f,a,l)},s.fromCartesianArray=function(e,i,o){t.defined("cartesians",e),i=r(i,a.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,d=-Number.MAX_VALUE,h=Number.MAX_VALUE,p=-Number.MAX_VALUE,m=0,y=e.length;y>m;m++){var E=i.cartesianToCartographic(e[m]);c=Math.min(c,E.longitude),f=Math.max(f,E.longitude),h=Math.min(h,E.latitude),p=Math.max(p,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;l=Math.min(l,O),d=Math.max(d,O)}return f-c>d-l&&(c=l,f=d,f>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(o)?(o.west=c,o.south=h,o.east=f,o.north=p,o):new s(c,h,f,p)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;o>a&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,f=r.west;o>a&&c>0?a+=u.TWO_PI:f>c&&a>0&&(c+=u.TWO_PI),o>a&&0>f?f+=u.TWO_PI:f>c&&0>o&&(o+=u.TWO_PI);var l=u.negativePiToPi(Math.max(o,f)),d=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&l>=d)){var h=Math.max(e.south,r.south),p=Math.min(e.north,r.north);if(!(h>=p))return n(i)?(i.west=l,i.south=h,i.east=d,i.north=p,i):new s(l,h,d,p)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);return o>=c||a>=u?void 0:n(i)?(i.west=a,i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,f=r.west;o>a&&c>0?a+=u.TWO_PI:f>c&&a>0&&(c+=u.TWO_PI),o>a&&0>f?f+=u.TWO_PI:f>c&&0>o&&(o+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(o,f)),d=u.convertLongitudeRange(Math.max(a,c));return i.west=l,i.south=Math.min(e.south,r.south),i.east=d,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return a>o&&(o+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(o>n||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,f){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(f)||(f=[]);var l=0,d=e.north,h=e.south,p=e.east,m=e.west,y=c;y.height=o,y.longitude=m,y.latitude=d,f[l]=i.cartographicToCartesian(y,f[l]),l++,y.longitude=p,f[l]=i.cartographicToCartesian(y,f[l]),l++,y.latitude=h,f[l]=i.cartographicToCartesian(y,f[l]),l++,y.longitude=m,f[l]=i.cartographicToCartesian(y,f[l]),l++,0>d?y.latitude=d:h>0?y.latitude=h:y.latitude=0;for(var E=1;8>E;++E)y.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,y)&&(f[l]=i.cartographicToCartesian(y,f[l]),l++);return 0===y.latitude&&(y.longitude=m,f[l]=i.cartographicToCartesian(y,f[l]),l++,y.longitude=p,f[l]=i.cartographicToCartesian(y,f[l]),l++),f.length=l,f},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,f,l,d){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var p=new e,m=new e,y=new e,E=new e,O=new e,_=new e,w=new e,T=new e,R=new e,v=new e,g=new e,A=new e,b=4/3*c.PI;h.fromPoints=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,a=e.clone(t[0],w),o=e.clone(a,p),u=e.clone(a,m),s=e.clone(a,y),c=e.clone(a,E),f=e.clone(a,O),l=e.clone(a,_),d=t.length;for(n=1;d>n;n++){e.clone(t[n],a);var b=a.x,S=a.y,N=a.z;b<o.x&&e.clone(a,o),b>c.x&&e.clone(a,c),S<u.y&&e.clone(a,u),S>f.y&&e.clone(a,f),N<s.z&&e.clone(a,s),N>l.z&&e.clone(a,l)}var I=e.magnitudeSquared(e.subtract(c,o,T)),x=e.magnitudeSquared(e.subtract(f,u,T)),M=e.magnitudeSquared(e.subtract(l,s,T)),C=o,P=c,U=I;x>U&&(U=x,C=u,P=f),M>U&&(U=M,C=s,P=l);var q=R;q.x=.5*(C.x+P.x),q.y=.5*(C.y+P.y),q.z=.5*(C.z+P.z);var D=e.magnitudeSquared(e.subtract(P,q,T)),L=Math.sqrt(D),B=v;B.x=o.x,B.y=u.y,B.z=s.z;var F=g;F.x=c.x,F.y=f.y,F.z=l.z;var j=e.midpoint(B,F,A),z=0;for(n=0;d>n;n++){e.clone(t[n],a);var G=e.magnitude(e.subtract(a,j,T));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(a,q,T));if(V>D){var W=Math.sqrt(V);L=.5*(L+W),D=L*L;var X=W-L;q.x=(L*q.x+X*a.x)/W,q.y=(L*q.y+X*a.y)/W,q.z=(L*q.z+X*a.z)/W}}return z>L?(e.clone(q,r.center),r.radius=L):(e.clone(j,r.center),r.radius=z),r};var S=new o,N=new e,I=new e,x=new t,M=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,S),d.southwest(t,x),x.height=a,d.northeast(t,M),M.height=o;var s=r.project(x,N),c=r.project(M,I),f=c.x-s.x,l=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+p*p);var m=u.center;return m.x=s.x+.5*f,m.y=s.y+.5*l,m.z=s.z+.5*p,u};var C=[];h.fromRectangle3D=function(t,r,o,u){if(r=n(r,a.WGS84),o=n(o,0),i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=d.subsample(t,r,o,C);return h.fromPoints(s,u)},h.fromVertices=function(t,a,o,u){if(i(u)||(u=new h),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=w;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;var c,f=e.clone(s,p),l=e.clone(s,m),d=e.clone(s,y),b=e.clone(s,E),S=e.clone(s,O),N=e.clone(s,_),I=t.length;for(c=0;I>c;c+=o){var x=t[c]+a.x,M=t[c+1]+a.y,C=t[c+2]+a.z;s.x=x,s.y=M,s.z=C,x<f.x&&e.clone(s,f),x>b.x&&e.clone(s,b),M<l.y&&e.clone(s,l),M>S.y&&e.clone(s,S),C<d.z&&e.clone(s,d),C>N.z&&e.clone(s,N)}var P=e.magnitudeSquared(e.subtract(b,f,T)),U=e.magnitudeSquared(e.subtract(S,l,T)),q=e.magnitudeSquared(e.subtract(N,d,T)),D=f,L=b,B=P;U>B&&(B=U,D=l,L=S),q>B&&(B=q,D=d,L=N);var F=R;F.x=.5*(D.x+L.x),F.y=.5*(D.y+L.y),F.z=.5*(D.z+L.z);var j=e.magnitudeSquared(e.subtract(L,F,T)),z=Math.sqrt(j),G=v;G.x=f.x,G.y=l.y,G.z=d.z;var V=g;V.x=b.x,V.y=S.y,V.z=N.z;var W=e.midpoint(G,V,A),X=0;for(c=0;I>c;c+=o){s.x=t[c]+a.x,s.y=t[c+1]+a.y,s.z=t[c+2]+a.z;var H=e.magnitude(e.subtract(s,W,T));H>X&&(X=H);var k=e.magnitudeSquared(e.subtract(s,F,T));if(k>j){var Y=Math.sqrt(k);z=.5*(z+Y),j=z*z;var K=Y-z;F.x=(z*F.x+K*s.x)/Y,F.y=(z*F.y+K*s.y)/Y,F.z=(z*F.z+K*s.z)/Y}}return X>z?(e.clone(F,u.center),u.radius=z):(e.clone(W,u.center),u.radius=X),u},h.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new h),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=w;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];var o,u=e.clone(a,p),s=e.clone(a,m),c=e.clone(a,y),f=e.clone(a,E),l=e.clone(a,O),d=e.clone(a,_),b=t.length;for(o=0;b>o;o+=3){var S=t[o]+r[o],N=t[o+1]+r[o+1],I=t[o+2]+r[o+2];a.x=S,a.y=N,a.z=I,S<u.x&&e.clone(a,u),S>f.x&&e.clone(a,f),N<s.y&&e.clone(a,s),N>l.y&&e.clone(a,l),I<c.z&&e.clone(a,c),I>d.z&&e.clone(a,d)}var x=e.magnitudeSquared(e.subtract(f,u,T)),M=e.magnitudeSquared(e.subtract(l,s,T)),C=e.magnitudeSquared(e.subtract(d,c,T)),P=u,U=f,q=x;M>q&&(q=M,P=s,U=l),C>q&&(q=C,P=c,U=d);var D=R;D.x=.5*(P.x+U.x),D.y=.5*(P.y+U.y),D.z=.5*(P.z+U.z);var L=e.magnitudeSquared(e.subtract(U,D,T)),B=Math.sqrt(L),F=v;F.x=u.x,F.y=s.y,F.z=c.z;var j=g;j.x=f.x,j.y=l.y,j.z=d.z;var z=e.midpoint(F,j,A),G=0;for(o=0;b>o;o+=3){a.x=t[o]+r[o],a.y=t[o+1]+r[o+1],a.z=t[o+2]+r[o+2];var V=e.magnitude(e.subtract(a,z,T));V>G&&(G=V);var W=e.magnitudeSquared(e.subtract(a,D,T));if(W>L){var X=Math.sqrt(W);B=.5*(B+X),L=B*B;var H=X-B;D.x=(B*D.x+H*a.x)/X,D.y=(B*D.y+H*a.y)/X,D.z=(B*D.z+H*a.z)/X}}return G>B?(e.clone(D,n.center),n.radius=B):(e.clone(z,n.center),n.radius=G),n},h.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new h);var o=e.midpoint(t,n,a.center);return a.radius=e.distance(o,n),a},h.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;h.fromBoundingSpheres=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var a,o=[];for(a=0;n>a;a++)o.push(t[a].center);r=h.fromPoints(o,r);var u=r.center,s=r.radius;for(a=0;n>a;a++){var c=t[a];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var U=new e,q=new e,D=new e;h.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new h);var a=t.halfAxes,o=f.getColumn(a,0,U),u=f.getColumn(a,1,q),s=f.getColumn(a,2,D);return e.add(o,u,o),e.add(o,s,o),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(o),n},h.clone=function(t,r){return i(t)?i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius):void 0},h.packedLength=4,h.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},h.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new h);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var L=new e,B=new e;h.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new h);var o=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,o,L),l=e.magnitude(f);if(u>=l+c)return t.clone(a),a;if(c>=l+u)return n.clone(a),a;var d=.5*(u+l+c),p=e.multiplyByScalar(f,(-u+d)/l,B);return e.add(p,o,p),e.clone(p,a.center),a.radius=d,a};var F=new e;h.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=h.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,F));return a>i.radius&&(i.radius=a),i},h.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return-a>s?u.OUTSIDE:a>s?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var j=new e;h.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,j);return e.magnitudeSquared(i)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;h.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,z),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var G=new e,V=new e,W=new e,X=new e,H=new e,k=new t,Y=new Array(8),K=0;8>K;++K)Y[K]=new e;var Z=new o;return h.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t),i=n(i,Z);var o=i.ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,W);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var d=e.negate(l,H),p=e.negate(f,X),m=Y,y=m[0];e.add(c,l,y),e.add(y,f,y),y=m[1],e.add(c,l,y),e.add(y,p,y),y=m[2],e.add(c,d,y),e.add(y,p,y),y=m[3],e.add(c,d,y),e.add(y,f,y),e.negate(c,c),y=m[4],e.add(c,l,y),e.add(y,f,y),y=m[5],e.add(c,l,y),e.add(y,p,y),y=m[6],e.add(c,d,y),e.add(y,p,y),y=m[7],e.add(c,d,y),e.add(y,f,y);for(var E=m.length,O=0;E>O;++O){var _=m[O];e.add(u,_,_);var w=o.cartesianToCartographic(_,k);i.project(w,_)}a=h.fromPoints(m,a),u=a.center;var T=u.x,R=u.y,v=u.z;return u.x=v,u.y=T,u.z=R,a},h.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return b*e*e*e},h}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./Rectangle"],function(e,t,r,n,i,a,o){"use strict";function u(e,n){r.typeOf.object("ellipsoid",e),this._ellipsoid=e,this._cameraPosition=new t,this._cameraPositionInScaledSpace=new t,this._distanceToLimbInScaledSpaceSquared=0,i(n)&&(this.cameraPosition=n)}function s(e,r,n){var i=e.transformPositionToScaledSpace(r,p),a=t.magnitudeSquared(i),o=Math.sqrt(a),u=t.divideByScalar(i,o,m);a=Math.max(1,a),o=Math.max(1,o);var s=t.dot(u,n),c=t.magnitude(t.cross(u,n,u)),f=1/o,l=Math.sqrt(a-1)*f;return 1/(s*f-c*l)}function c(e,r,n){return 0>=r||r===1/0||r!==r?void 0:t.multiplyByScalar(e,r,n)}function f(e,r){return t.equals(r,t.ZERO)?r:(e.transformPositionToScaledSpace(r,y),t.normalize(y,y))}a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var r=this._ellipsoid,n=r.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=t.magnitudeSquared(n)-1;t.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=n,this._distanceToLimbInScaledSpaceSquared=i}}});var l=new t;u.prototype.isPointVisible=function(e){var t=this._ellipsoid,r=t.transformPositionToScaledSpace(e,l);return this.isScaledSpacePointVisible(r)},u.prototype.isScaledSpacePointVisible=function(e){var r=this._cameraPositionInScaledSpace,n=this._distanceToLimbInScaledSpaceSquared,i=t.subtract(e,r,l),a=-t.dot(i,r),o=0>n?a>0:a>n&&a*a/t.magnitudeSquared(i)>n;return!o},u.prototype.computeHorizonCullingPoint=function(e,n,a){r.typeOf.object("directionToPoint",e),r.defined("positions",n),i(a)||(a=new t);for(var o=this._ellipsoid,u=f(o,e),l=0,d=0,h=n.length;h>d;++d){var p=n[d],m=s(o,p,u);l=Math.max(l,m)}return c(u,l,a)};var d=new t;u.prototype.computeHorizonCullingPointFromVertices=function(e,a,o,u,l){r.typeOf.object("directionToPoint",e),r.defined("vertices",a),r.typeOf.number("stride",o),i(l)||(l=new t),u=n(u,t.ZERO);for(var h=this._ellipsoid,p=f(h,e),m=0,y=0,E=a.length;E>y;y+=o){d.x=a[y]+u.x,d.y=a[y+1]+u.y,d.z=a[y+2]+u.z;var O=s(h,d,p);m=Math.max(m,O)}return c(p,m,l)};var h=[];u.prototype.computeHorizonCullingPointFromRectangle=function(n,i,a){r.typeOf.object("rectangle",n);var u=o.subsample(n,i,0,h),s=e.fromPoints(u);return t.magnitude(s.center)<.1*i.minimumRadius?void 0:this.computeHorizonCullingPoint(s.center,u,a)};var p=new t,m=new t,y=new t;return u}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,
COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.fromSizeInBytes=function(e){switch(e){case 2:return a.UNSIGNED_SHORT;case 4:return a.UNSIGNED_INT;case 1:return a.UNSIGNED_BYTE;default:throw new t("Size in bytes cannot be mapped to an IndexDatatype")}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},a.createTypedArrayFromArrayBuffer=function(r,i,a,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)},r(a)}),define("Core/Intersections2D",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError"],function(e,t,r,n,i){"use strict";var a={};return a.clipTriangleAtAxisAlignedThreshold=function(e,t,r,a,o,u){if(!n(e))throw new i("threshold is required.");if(!n(t))throw new i("keepAbove is required.");if(!n(r))throw new i("u0 is required.");if(!n(a))throw new i("u1 is required.");if(!n(o))throw new i("u2 is required.");n(u)?u.length=0:u=[];var s,c,f;t?(s=e>r,c=e>a,f=e>o):(s=r>e,c=a>e,f=o>e);var l,d,h,p,m,y,E=s+c+f;return 1===E?s?(l=(e-r)/(a-r),d=(e-r)/(o-r),u.push(1),u.push(2),1!==d&&(u.push(-1),u.push(0),u.push(2),u.push(d)),1!==l&&(u.push(-1),u.push(0),u.push(1),u.push(l))):c?(h=(e-a)/(o-a),p=(e-a)/(r-a),u.push(2),u.push(0),1!==p&&(u.push(-1),u.push(1),u.push(0),u.push(p)),1!==h&&(u.push(-1),u.push(1),u.push(2),u.push(h))):f&&(m=(e-o)/(r-o),y=(e-o)/(a-o),u.push(0),u.push(1),1!==y&&(u.push(-1),u.push(2),u.push(1),u.push(y)),1!==m&&(u.push(-1),u.push(2),u.push(0),u.push(m))):2===E?s||r===e?c||a===e?f||o===e||(d=(e-r)/(o-r),h=(e-a)/(o-a),u.push(2),u.push(-1),u.push(0),u.push(2),u.push(d),u.push(-1),u.push(1),u.push(2),u.push(h)):(y=(e-o)/(a-o),l=(e-r)/(a-r),u.push(1),u.push(-1),u.push(2),u.push(1),u.push(y),u.push(-1),u.push(0),u.push(1),u.push(l)):(p=(e-a)/(r-a),m=(e-o)/(r-o),u.push(0),u.push(-1),u.push(1),u.push(0),u.push(p),u.push(-1),u.push(2),u.push(0),u.push(m)):3!==E&&(u.push(0),u.push(1),u.push(2)),u},a.computeBarycentricCoordinates=function(e,r,a,o,u,s,c,f,l){if(!n(e))throw new i("x is required.");if(!n(r))throw new i("y is required.");if(!n(a))throw new i("x1 is required.");if(!n(o))throw new i("y1 is required.");if(!n(u))throw new i("x2 is required.");if(!n(s))throw new i("y2 is required.");if(!n(c))throw new i("x3 is required.");if(!n(f))throw new i("y3 is required.");var d=a-c,h=c-u,p=s-f,m=o-f,y=1/(p*d+h*m),E=r-f,O=e-c,_=(p*O+h*E)*y,w=(-m*O+d*E)*y,T=1-_-w;return n(l)?(l.x=_,l.y=w,l.z=T,l):new t(_,w,T)},a.computeLineSegmentLineSegmentIntersection=function(t,i,a,o,u,s,c,f,l){r.typeOf.number("x00",t),r.typeOf.number("y00",i),r.typeOf.number("x01",a),r.typeOf.number("y01",o),r.typeOf.number("x10",u),r.typeOf.number("y10",s),r.typeOf.number("x11",c),r.typeOf.number("y11",f);var d=(c-u)*(i-s)-(f-s)*(t-u),h=(a-t)*(i-s)-(o-i)*(t-u),p=(f-s)*(a-t)-(c-u)*(o-i);if(0!==p){var m=d/p,y=h/p;return m>=0&&1>=m&&y>=0&&1>=y?(n(l)||(l=new e),l.x=t+m*(a-t),l.y=i+m*(o-i),l):void 0}},a}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./Check","./defaultValue","./defined","./Intersect"],function(e,t,r,n,i){"use strict";function a(t,i,a){this.minimum=e.clone(r(t,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),a=n(a)?e.clone(a):e.midpoint(this.minimum,this.maximum,new e),this.center=a}a.fromPoints=function(t,r){if(n(r)||(r=new a),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var i=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,f=t[0].z,l=t.length,d=1;l>d;d++){var h=t[d],p=h.x,m=h.y,y=h.z;i=Math.min(p,i),s=Math.max(p,s),o=Math.min(m,o),c=Math.max(m,c),u=Math.min(y,u),f=Math.max(y,f)}var E=r.minimum;E.x=i,E.y=o,E.z=u;var O=r.maximum;return O.x=s,O.y=c,O.z=f,r.center=e.midpoint(E,O,r.center),r},a.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new a(t.minimum,t.maximum,t.center):void 0},a.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return a.intersectPlane=function(r,n){t.defined("box",r),t.defined("plane",n),o=e.subtract(r.maximum,r.minimum,o);var a=e.multiplyByScalar(o,.5,o),u=n.normal,s=a.x*Math.abs(u.x)+a.y*Math.abs(u.y)+a.z*Math.abs(u.z),c=e.dot(r.center,u)+n.distance;return c-s>0?i.INSIDE:0>c+s?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersectPlane=function(e){return a.intersectPlane(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if(o=-a/n,0>o)return[];var c=Math.sqrt(o);return[-c,c]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var f=i*i,l=4*n*a,d=r(f,-l,t.EPSILON14);if(0>d)return[];var h=-.5*r(i,t.sign(i)*Math.sqrt(d),t.EPSILON14);return i>0?[h/n,a/h]:[a/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,f=o*s,l=u*c,d=u*u,h=s*s,p=o*s-d,m=o*c-u*s,y=u*c-h,E=4*p*y-m*m;if(0>E){var O,_,w;d*l>=f*h?(O=o,_=p,w=-2*u*p+o*m):(O=c,_=y,w=-c*m+2*s*y);var T=0>w?-1:1,R=-T*Math.abs(O)*Math.sqrt(-E);a=-w+R;var v=a/2,g=0>v?-Math.pow(-v,1/3):Math.pow(v,1/3),A=a===R?-g:-_/g;return i=0>=_?g+A:-w/(g*g+A*A+_),d*l>=f*h?[(i-u)/o]:[-c/(i+s)]}var b=p,S=-2*u*p+o*m,N=y,I=-c*m+2*s*y,x=Math.sqrt(E),M=Math.sqrt(3)/2,C=Math.abs(Math.atan2(o*x,-S)/3);i=2*Math.sqrt(-b);var P=Math.cos(C);a=i*P;var U=i*(-P/2-M*Math.sin(C)),q=a+U>2*u?a-u:U-u,D=o,L=q/D;C=Math.abs(Math.atan2(c*x,-I)/3),i=2*Math.sqrt(-N),P=Math.cos(C),a=i*P,U=i*(-P/2-M*Math.sin(C));var B=-c,F=2*s>a+U?a+s:U+s,j=B/F,z=D*F,G=-q*F-D*B,V=q*B,W=(s*G-u*V)/(-u*G+s*z);return W>=L?j>=L?j>=W?[L,W,j]:[L,j,W]:[j,L,W]:j>=L?[W,L,j]:j>=W?[W,j,L]:[j,W,L]}var n={};return n.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=t*t,o=r*r,u=n*n,s=i*i,c=18*t*r*n*i+o*u-27*a*s-4*(t*u*n+o*r*i);return c},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return t.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var c=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===o?(u=t.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):r(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):r(n,i,0,o):0===o?(u=t.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):r(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,f=o-a*t/4+i*u/16-3*u*u/256,l=e.computeRealRoots(1,2*s,s*s-4*f,-c*c);if(l.length>0){var d=-t/4,h=l[l.length-1];if(Math.abs(h)<r.EPSILON14){var p=n.computeRealRoots(1,s,f);if(2===p.length){var m,y=p[0],E=p[1];if(y>=0&&E>=0){var O=Math.sqrt(y),_=Math.sqrt(E);return[d-_,d-O,d+O,d+_]}if(y>=0&&0>E)return m=Math.sqrt(y),[d-m,d+m];if(0>y&&E>=0)return m=Math.sqrt(E),[d-m,d+m]}return[]}if(h>0){var w=Math.sqrt(h),T=(s+h-c/w)/2,R=(s+h+c/w)/2,v=n.computeRealRoots(1,w,T),g=n.computeRealRoots(1,-w,R);return 0!==v.length?(v[0]+=d,v[1]+=d,0!==g.length?(g[0]+=d,g[1]+=d,v[1]<=g[0]?[v[0],v[1],g[0],g[1]]:g[1]<=v[0]?[g[0],g[1],v[0],v[1]]:v[0]>=g[0]&&v[1]<=g[1]?[g[0],v[0],v[1],g[1]]:g[0]>=v[0]&&g[1]<=v[1]?[v[0],g[0],g[1],v[1]]:v[0]>g[0]&&v[0]<g[1]?[g[0],v[0],g[1],v[1]]:[v[0],g[0],v[1],g[1]]):v):0!==g.length?(g[0]+=d,g[1]+=d,g):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,f=-2*i,l=a*t+s-4*o,d=c*o-a*i*t+u,h=e.computeRealRoots(1,f,l,d);if(h.length>0){var p,m,y=h[0],E=i-y,O=E*E,_=t/2,w=E/2,T=O-4*o,R=O+4*Math.abs(o),v=c-4*y,g=c+4*Math.abs(y);if(0>y||v*R>T*g){var A=Math.sqrt(v);p=A/2,m=0===A?0:(t*w-a)/A}else{var b=Math.sqrt(T);p=0===b?0:(t*w-a)/b,m=b/2}var S,N;0===_&&0===p?(S=0,N=0):r.sign(_)===r.sign(p)?(S=_+p,N=y/S):(N=_-p,S=y/N);var I,x;0===w&&0===m?(I=0,x=0):r.sign(w)===r.sign(m)?(I=w+m,x=o/I):(x=w-m,I=o/x);var M=n.computeRealRoots(1,S,I),C=n.computeRealRoots(1,N,x);if(0!==M.length)return 0!==C.length?M[1]<=C[0]?[M[0],M[1],C[0],C[1]]:C[1]<=M[0]?[C[0],C[1],M[0],M[1]]:M[0]>=C[0]&&M[1]<=C[1]?[C[0],M[0],M[1],C[1]]:C[0]>=M[0]&&C[1]<=M[1]?[M[0],C[0],C[1],M[1]]:M[0]>C[0]&&M[0]<C[1]?[C[0],M[0],C[1],M[1]]:[M[0],C[0],M[1],C[1]]:M;if(0!==C.length)return C}return[]}var o={};return o.computeDiscriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,u=o*e,s=r*r,c=s*r,f=n*n,l=f*n,d=i*i,h=d*i,p=a*a,m=p*a,y=s*f*d-4*c*h-4*e*l*d+18*e*r*n*h-27*o*d*d+256*u*m+a*(18*c*n*i-4*s*l+16*e*f*f-80*e*r*f*i-6*e*s*d+144*o*n*d)+p*(144*e*s*n-27*s*s-128*o*f-192*o*r*i);return y},o.computeRealRoots=function(n,o,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(o,u,s,c);var f=o/n,l=u/n,d=s/n,h=c/n,p=0>f?1:0;switch(p+=0>l?p+1:p,p+=0>d?p+1:p,p+=0>h?p+1:p){case 0:return i(f,l,d,h);case 1:return a(f,l,d,h);case 2:return a(f,l,d,h);case 3:return i(f,l,d,h);case 4:return i(f,l,d,h);case 5:return a(f,l,d,h);case 6:return i(f,l,d,h);case 7:return i(f,l,d,h);case 8:return a(f,l,d,h);case 9:return i(f,l,d,h);case 10:return i(f,l,d,h);case 11:return a(f,l,d,h);case 12:return i(f,l,d,h);case 13:return i(f,l,d,h);case 14:return i(f,l,d,h);case 15:return i(f,l,d,h);default:return}},o}),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],function(e,t,r,n){"use strict";function i(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return i.clone=function(t,r){return n(t)?n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new i(t.origin,t.direction):void 0},i.getPoint=function(r,i,a){return t.typeOf.object("ray",r),t.typeOf.number("t",i),n(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,i,a,o,u,s,c,f){"use strict";function l(e,t,r,n){var i=t*t-4*e*r;if(!(0>i)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function d(t,r,i){n(i)||(i=new a);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,f=e.subtract(o,s,O),d=e.dot(u,u),h=2*e.dot(u,f),p=e.magnitudeSquared(f)-c,m=l(d,h,p,R);return n(m)?(i.start=m.root0,i.stop=m.root1,i):void 0}function h(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function p(t,r,n,i,a){var f,l=i*i,d=a*a,p=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*d,m=a*(i*h(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),y=t[u.COLUMN0ROW0]*l+t[u.COLUMN2ROW2]*d+i*r.x+n,E=d*h(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),O=a*(i*h(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),_=[];if(0===O&&0===E){if(f=s.computeRealRoots(p,m,y),0===f.length)return _;var w=f[0],T=Math.sqrt(Math.max(1-w*w,0));if(_.push(new e(i,a*w,a*-T)),_.push(new e(i,a*w,a*T)),2===f.length){var R=f[1],v=Math.sqrt(Math.max(1-R*R,0));_.push(new e(i,a*R,a*-v)),_.push(new e(i,a*R,a*v))}return _}var g=O*O,A=E*E,b=p*p,S=O*E,N=b+A,I=2*(m*p+S),x=2*y*p+m*m-A+g,M=2*(y*m-S),C=y*y-g;if(0===N&&0===I&&0===x&&0===M)return _;f=c.computeRealRoots(N,I,x,M,C);var P=f.length;if(0===P)return _;for(var U=0;P>U;++U){var q,D=f[U],L=D*D,B=Math.max(1-L,0),F=Math.sqrt(B);q=o.sign(p)===o.sign(y)?h(p*L+y,m*D,o.EPSILON12):o.sign(y)===o.sign(m*D)?h(p*L,m*D+y,o.EPSILON12):h(p*L+m*D,y,o.EPSILON12);var j=h(E*D,O,o.EPSILON15),z=q*j;0>z?_.push(new e(i,a*D,a*F)):z>0?_.push(new e(i,a*D,a*-F)):0!==F?(_.push(new e(i,a*D,a*-F)),_.push(new e(i,a*D,a*F)),++U):_.push(new e(i,a*D,a*F))}return _}var m={};m.rayPlane=function(t,r,a){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(a)||(a=new e);var u=t.origin,s=t.direction,c=r.normal,f=e.dot(c,s);if(!(Math.abs(f)<o.EPSILON15)){var l=(-r.distance-e.dot(c,u))/f;if(!(0>l))return a=e.multiplyByScalar(s,l,a),e.add(u,a,a)}};var y=new e,E=new e,O=new e,_=new e,w=new e;m.rayTriangleParametric=function(t,a,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var f,l,d,h,p,m=t.origin,T=t.direction,R=e.subtract(u,a,y),v=e.subtract(s,a,E),g=e.cross(T,v,O),A=e.dot(R,g);if(c){if(A<o.EPSILON6)return;if(f=e.subtract(m,a,_),d=e.dot(f,g),0>d||d>A)return;if(l=e.cross(f,R,w),h=e.dot(T,l),0>h||d+h>A)return;p=e.dot(v,l)/A}else{if(Math.abs(A)<o.EPSILON6)return;var b=1/A;if(f=e.subtract(m,a,_),d=e.dot(f,g)*b,0>d||d>1)return;if(l=e.cross(f,R,w),h=e.dot(T,l)*b,0>h||d+h>1)return;p=e.dot(v,l)*b}return p},m.rayTriangle=function(t,r,i,a,o,u){var s=m.rayTriangleParametric(t,r,i,a,o);if(n(s)&&!(0>s))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var T=new f;m.lineSegmentTriangle=function(t,r,a,o,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(a))throw new i("p0 is required.");if(!n(o))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var f=T;e.clone(t,f.origin),e.subtract(r,t,f.direction),e.normalize(f.direction,f.direction);var l=m.rayTriangleParametric(f,a,o,u,s);return!n(l)||0>l||l>e.distance(t,r)?void 0:(n(c)||(c=new e),e.multiplyByScalar(f.direction,l,c),e.add(f.origin,c,c))};var R={root0:0,root1:0};m.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");return r=d(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var v=new f;m.lineSegmentSphere=function(t,r,a,o){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=v;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);return e.normalize(s,s),o=d(u,a,o),!n(o)||o.stop<0||o.start>c?void 0:(o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,c),o)};var g=new e,A=new e;m.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o,u,s,c,f,l=r.oneOverRadii,d=e.multiplyComponents(l,t.origin,g),h=e.multiplyComponents(l,t.direction,A),p=e.magnitudeSquared(d),m=e.dot(d,h);if(p>1){if(m>=0)return;var y=m*m;if(o=p-1,u=e.magnitudeSquared(h),s=u*o,s>y)return;if(y>s){c=m*m-s,f=-m+Math.sqrt(c);var E=f/u,O=o/f;return O>E?new a(E,O):{start:O,stop:E}}var _=Math.sqrt(o/u);return new a(_,_)}return 1>p?(o=p-1,u=e.magnitudeSquared(h),s=u*o,c=m*m-s,f=-m+Math.sqrt(c),new a(0,f/u)):0>m?(u=e.magnitudeSquared(h),new a(0,-m/u)):void 0};var b=new e,S=new e,N=new e,I=new e,x=new e,M=new u,C=new u,P=new u,U=new u,q=new u,D=new u,L=new u,B=new e,F=new e,j=new t;m.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a=t.origin,s=t.direction;if(!e.equals(a,e.ZERO)){var c=r.geodeticSurfaceNormal(a,b);if(e.dot(s,c)>=0)return a}var f=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(s,b),d=e.normalize(l,l),h=e.mostOrthogonalAxis(l,I),m=e.normalize(e.cross(h,d,S),S),y=e.normalize(e.cross(d,m,N),N),E=M;E[0]=d.x,E[1]=d.y,E[2]=d.z,E[3]=m.x,E[4]=m.y,E[5]=m.z,E[6]=y.x,E[7]=y.y,E[8]=y.z;var O=u.transpose(E,C),_=u.fromScale(r.radii,P),w=u.fromScale(r.oneOverRadii,U),T=q;T[0]=0,T[1]=-s.z,T[2]=s.y,T[3]=s.z,T[4]=0,T[5]=-s.x,T[6]=-s.y,T[7]=s.x,T[8]=0;var R,v,g=u.multiply(u.multiply(O,w,D),T,D),A=u.multiply(u.multiply(g,_,L),E,L),z=u.multiplyByVector(g,a,x),G=p(A,e.negate(z,b),0,0,1),V=G.length;if(V>0){for(var W=e.clone(e.ZERO,F),X=Number.NEGATIVE_INFINITY,H=0;V>H;++H){R=u.multiplyByVector(_,u.multiplyByVector(E,G[H],B),B);var k=e.normalize(e.subtract(R,a,I),I),Y=e.dot(k,s);Y>X&&(X=Y,W=e.clone(R,W))}var K=r.cartesianToCartographic(W,j);return X=o.clamp(X,0,1),v=e.magnitude(e.subtract(W,a,I))*Math.sqrt(1-X*X),v=f?-v:v,K.height=v,r.cartographicToCartesian(K,new e)}};var z=new e;return m.lineSegmentPlane=function(t,r,a,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,z),c=a.normal,f=e.dot(c,s);if(!(Math.abs(f)<o.EPSILON6)){var l=e.dot(c,t),d=-(a.distance+l)/f;if(!(0>d||d>1))return e.multiplyByScalar(s,d,u),e.add(t,u,u),u}},m.trianglePlaneIntersection=function(t,r,a,o){if(!(n(t)&&n(r)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,c=e.dot(u,t)+s<0,f=e.dot(u,r)+s<0,l=e.dot(u,a)+s<0,d=0;d+=c?1:0,d+=f?1:0,d+=l?1:0;var h,p;if((1===d||2===d)&&(h=new e,p=new e),1===d){if(c)return m.lineSegmentPlane(t,r,o,h),m.lineSegmentPlane(t,a,o,p),{positions:[t,r,a,h,p],indices:[0,3,4,1,2,4,1,4,3]};if(f)return m.lineSegmentPlane(r,a,o,h),m.lineSegmentPlane(r,t,o,p),{positions:[t,r,a,h,p],indices:[1,3,4,2,0,4,2,4,3]};if(l)return m.lineSegmentPlane(a,t,o,h),m.lineSegmentPlane(a,r,o,p),{positions:[t,r,a,h,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!c)return m.lineSegmentPlane(r,t,o,h),m.lineSegmentPlane(a,t,o,p),{positions:[t,r,a,h,p],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return m.lineSegmentPlane(a,r,o,h),m.lineSegmentPlane(t,r,o,p),{positions:[t,r,a,h,p],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return m.lineSegmentPlane(t,a,o,h),m.lineSegmentPlane(r,a,o,p),{positions:[t,r,a,h,p],indices:[0,1,4,0,4,3,2,3,4]}}},m}),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],function(e,t,r,n,i,a,o){"use strict";function u(r,i){if(t.typeOf.object("normal",r),!a.equalsEpsilon(e.magnitude(r),1,a.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",i),this.normal=e.clone(r),this.distance=i}u.fromPointNormal=function(i,o,s){if(t.typeOf.object("point",i),t.typeOf.object("normal",o),!a.equalsEpsilon(e.magnitude(o),1,a.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(o,i);return r(s)?(e.clone(o,s.normal),s.distance=c,s):new u(o,c)};var s=new e;u.fromCartesian4=function(i,o){t.typeOf.object("coefficients",i);var c=e.fromCartesian4(i,s),f=i.w;if(!a.equalsEpsilon(e.magnitude(c),1,a.EPSILON6))throw new n("normal must be normalized.");return r(o)?(e.clone(c,o.normal),o.distance=f,o):new u(c,f)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,i,a){t.typeOf.object("plane",n),t.typeOf.object("point",i),r(a)||(a=new e);var o=u.getPointDistance(n,i),s=e.multiplyByScalar(n.normal,o,c);return e.subtract(i,s,a)};var f=new e;return u.transform=function(r,n,i){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),o.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,f),o.multiplyByPoint(n,f,f),u.fromPointNormal(f,s,i)},u.clone=function(n,i){return t.typeOf.object("plane",n),r(i)?(e.clone(n.normal,i.normal),i.distance=n.distance,i):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=i(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=i(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=i(new u(e.UNIT_Y,0)),u}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,i){return t(e).then(r,n,i)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=i(e),t}function r(t){return e(t,a)}function n(e){this.then=e}function i(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return a(n)}});return r}function a(e){var r=new n(function(r,n){try{return n?t(n(e)):a(e)}catch(i){return a(i)}});return r}function o(){function e(e,t,r){return d(e,t,r)}function r(e){return p(e)}function i(e){return p(a(e))}function u(e){return h(e)}var s,c,f,l,d,h,p;return c=new n(e),s={then:e,resolve:r,reject:i,progress:u,promise:c,resolver:{resolve:r,reject:i,progress:u}},f=[],l=[],d=function(e,t,r){var n,i;return n=o(),i="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},f.push(function(r){r.then(e,t).then(n.resolve,n.reject,i)}),l.push(i),n.promise},h=function(e){return m(l,e),e},p=function(e){return e=t(e),d=e.then,p=t,h=E,m(f,e),l=f=T,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,i,a){return y(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){p(e)}var c,f,l,d,h,p,m,y,O,_;if(O=t.length>>>0,c=Math.max(0,Math.min(r,O)),l=[],f=O-c+1,d=[],h=o(),c)for(y=h.progress,m=function(e){d.push(e),--f||(p=m=E,h.reject(d))},p=function(e){l.push(e),--c||(p=m=E,h.resolve(l))},_=0;O>_;++_)_ in t&&e(t[_],s,u,y);else h.resolve(l);return h.then(n,i,a)})}function c(e,t,r,n){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,r,n)}function f(e,t,r,n){return y(1,arguments),d(e,O).then(t,r,n)}function l(){return d(arguments,O)}function d(t,r){return e(t,function(t){var n,i,a,u,s,c;if(a=i=t.length>>>0,n=[],c=o(),a)for(u=function(t,i){e(t,r).then(function(e){n[i]=e,--a||c.resolve(n)},c.reject)},s=0;i>s;s++)s in t?u(t[s],s):--a;else c.resolve(n);return c.promise})}function h(t,r){var n=w.call(arguments,1);return e(t,function(t){var i;return i=t.length,n[0]=function(t,n,a){return e(t,function(t){return e(n,function(e){return r(t,e,a,i)})})},_.apply(t,n)})}function p(t,r,n){var i=arguments.length>2;return e(t,function(e){return e=i?n:e,r.resolve(e),e},function(e){return r.reject(e),a(e)},r.progress)}function m(e,t){for(var r,n=0;r=e[n++];)r(t)}function y(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function E(){}function O(e){return e}var _,w,T;return e.defer=o,e.resolve=t,e.reject=r,e.join=l,e.all=f,e.map=d,e.reduce=h,e.any=c,e.some=s,e.chain=p,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(T,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return f(t,function(t){return e.apply(T,t)})})}},w=[].slice,_=[].reduce||function(e){var t,r,n,i,a;if(a=0,t=Object(this),i=t.length>>>0,r=arguments,r.length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;i>a;++a)a in t&&(n=e(n,t[a],a,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){
"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,a,o=0,u=t.length-1;u>=o;)if(i=~~((o+u)/2),a=n(t[i],r),0>a)o=i+1;else{if(!(a>0))return i;u=i-1}return~(u+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var u=n-e.length;return u>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+i(c.toString(t),u||0,"0",!1),a(e,r,n,o,s)},u=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},s=function(e,n,s,c,f,l,d){var h,p,m,y,E;if("%%"==e)return"%";for(var O=!1,_="",w=!1,T=!1,R=" ",v=s.length,g=0;s&&v>g;g++)switch(s.charAt(g)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":R=s.charAt(g+1);break;case"0":w=!0;break;case"#":T=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],d){case"s":return u(String(E),O,c,l,w,R);case"c":return u(String.fromCharCode(+E),O,c,l,w);case"b":return o(E,2,T,O,c,l,w);case"o":return o(E,8,T,O,c,l,w);case"x":return o(E,16,T,O,c,l,w);case"X":return o(E,16,T,O,c,l,w).toUpperCase();case"u":return o(E,10,T,O,c,l,w);case"i":case"d":return h=+E||0,h=Math.round(h-h%1),p=0>h?"-":_,E=p+i(String(Math.abs(h)),l,"0",!1),a(E,p,O,c,w);case"e":case"E":case"f":case"F":case"g":case"G":return h=+E,p=0>h?"-":_,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],E=p+Math.abs(h)[m](l),a(E,p,O,c,w)[y]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,i,a,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(e,t){return m.compare(e.julianDate,t.julianDate)}function l(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,f);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;if(n>0){var a=m.secondsDifference(r[n].julianDate,e);a>i&&(n--,i=r[n].offset)}m.addSeconds(e,i,e)}function d(e,r){_.julianDate=e;var n=m.leapSeconds,i=t(n,_,f);if(0>i&&(i=~i),0===i)return m.addSeconds(e,-n[0].offset,r);if(i>=n.length)return m.addSeconds(e,-n[i-1].offset,r);var a=m.secondsDifference(n[i].julianDate,e);return 0===a?m.addSeconds(e,-n[i].offset,r):1>=a?void 0:m.addSeconds(e,-n[--i].offset,r)}function h(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function p(e,t,r,n,i,a,o){var u=(t-14)/12|0,c=e+4800+u,f=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;n-=12,0>n&&(n+=24);var l=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}function m(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;t+=(e-i)*s.SECONDS_PER_DAY,h(i,t,this),n===c.UTC&&l(this)}var y=new a,E=[31,28,31,30,31,30,31,31,30,31,30,31],O=29,_=new u,w=/^(\d{4})$/,T=/^(\d{4})-(\d{2})$/,R=/^(\d{4})-?(\d{3})$/,v=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,g=/^(\d{4})-?(\d{2})-?(\d{2})$/,A=/([Z+\-])?(\d{2})?:?(\d{2})?$/,b=/^(\d{2})(\.\d+)?/.source+A.source,S=/^(\d{2}):?(\d{2})(\.\d+)?/.source+A.source,N=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+A.source,I="Invalid ISO 8601 date.";m.fromGregorianDate=function(e,t){if(!(e instanceof a))throw new i("date must be a valid GregorianDate.");var r=p(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(h(r[0],r[1],t),l(t),t):new m(r[0],r[1],c.UTC)},m.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(h(r[0],r[1],t),l(t),t):new m(r[0],r[1],c.UTC)},m.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(I);e=e.replace(",",".");var r,a,u,s=e.split("T"),f=1,d=1,y=0,_=0,A=0,x=0,M=s[0],C=s[1];if(!n(M))throw new i(I);var P;if(s=M.match(g),null!==s){if(P=M.split("-").length-1,P>0&&2!==P)throw new i(I);r=+s[1],f=+s[2],d=+s[3]}else if(s=M.match(T),null!==s)r=+s[1],f=+s[2];else if(s=M.match(w),null!==s)r=+s[1];else{var U;if(s=M.match(R),null!==s){if(r=+s[1],U=+s[2],u=o(r),1>U||u&&U>366||!u&&U>365)throw new i(I)}else{if(s=M.match(v),null===s)throw new i(I);r=+s[1];var q=+s[2],D=+s[3]||0;if(P=M.split("-").length-1,P>0&&(!n(s[3])&&1!==P||n(s[3])&&2!==P))throw new i(I);var L=new Date(Date.UTC(r,0,4));U=7*q+D-L.getUTCDay()-3}a=new Date(Date.UTC(r,0,1)),a.setUTCDate(U),f=a.getUTCMonth()+1,d=a.getUTCDate()}if(u=o(r),1>f||f>12||1>d||(2!==f||!u)&&d>E[f-1]||u&&2===f&&d>O)throw new i(I);var B;if(n(C)){if(s=C.match(N),null!==s){if(P=C.split(":").length-1,P>0&&2!==P&&3!==P)throw new i(I);y=+s[1],_=+s[2],A=+s[3],x=1e3*+(s[4]||0),B=5}else if(s=C.match(S),null!==s){if(P=C.split(":").length-1,P>2)throw new i(I);y=+s[1],_=+s[2],A=60*+(s[3]||0),B=4}else{if(s=C.match(b),null===s)throw new i(I);y=+s[1],_=60*+(s[2]||0),B=3}if(_>=60||A>=61||y>24||24===y&&(_>0||A>0||x>0))throw new i(I);var F=s[B],j=+s[B+1],z=+(s[B+2]||0);switch(F){case"+":y-=j,_-=z;break;case"-":y+=j,_+=z;break;case"Z":break;default:_+=new Date(Date.UTC(r,f-1,d,y,_)).getTimezoneOffset()}}var G=60===A;for(G&&A--;_>=60;)_-=60,y++;for(;y>=24;)y-=24,d++;for(a=u&&2===f?O:E[f-1];d>a;)d-=a,f++,f>12&&(f-=12,r++),a=u&&2===f?O:E[f-1];for(;0>_;)_+=60,y--;for(;0>y;)y+=24,d--;for(;1>d;)f--,1>f&&(f+=12,r--),a=u&&2===f?O:E[f-1],d+=a;var V=p(r,f,d,y,_,A,x);return n(t)?(h(V[0],V[1],t),l(t)):t=new m(V[0],V[1],c.UTC),G&&m.addSeconds(t,1,t),t},m.now=function(e){return m.fromDate(new Date,e)};var x=new m(0,0,c.TAI);return m.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,o=d(e,x);n(o)||(m.addSeconds(e,-1,x),o=d(x,x),r=!0);var u=o.dayNumber,c=o.secondsOfDay;c>=43200&&(u+=1);var f=u+68569|0,l=4*f/146097|0;f=f-((146097*l+3)/4|0)|0;var h=4e3*(f+1)/1461001|0;f=f-(1461*h/4|0)+31|0;var p=80*f/2447|0,y=f-(2447*p/80|0)|0;f=p/11|0;var E=p+2-12*f|0,O=100*(l-49)+h+f|0,_=c/s.SECONDS_PER_HOUR|0,w=c-_*s.SECONDS_PER_HOUR,T=w/s.SECONDS_PER_MINUTE|0;w-=T*s.SECONDS_PER_MINUTE;var R=0|w,v=(w-R)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(R+=1),n(t)?(t.year=O,t.month=E,t.day=y,t.hour=_,t.minute=T,t.second=R,t.millisecond=v,t.isLeapSecond=r,t):new a(O,E,y,_,T,R,v,r)},m.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=m.toGregorianDate(e,y),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},m.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var a=m.toGregorianDate(t,y),o=a.year,u=a.month,s=a.day,c=a.hour,f=a.minute,l=a.second,d=a.millisecond;1e4===o&&1===u&&1===s&&0===c&&0===f&&0===l&&0===d&&(o=9999,u=12,s=31,c=24);var h;return n(r)||0===d?n(r)&&0!==r?(h=(.01*d).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,u,s,c,f,l,h)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o,u,s,c,f,l):(h=(.01*d).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,u,s,c,f,l,h))},m.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new m(e.dayNumber,e.secondsOfDay,c.TAI):void 0},m.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},m.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},m.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(m.secondsDifference(e,t))<=r},m.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},m.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},m.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber,a=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+a},m.computeTaiMinusUtc=function(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,f);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},m.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return h(e.dayNumber,e.secondsOfDay+t,r)},m.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,a,r)},m.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,a,r)},m.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");var a=e.dayNumber+t;return h(a,e.secondsOfDay,r)},m.lessThan=function(e,t){return m.compare(e,t)<0},m.lessThanOrEquals=function(e,t){return m.compare(e,t)<=0},m.greaterThan=function(e,t){return m.compare(e,t)>0},m.greaterThanOrEquals=function(e,t){return m.compare(e,t)>=0},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return m.toIso8601(this)},m.leapSeconds=[new u(new m(2441317,43210,c.TAI),10),new u(new m(2441499,43211,c.TAI),11),new u(new m(2441683,43212,c.TAI),12),new u(new m(2442048,43213,c.TAI),13),new u(new m(2442413,43214,c.TAI),14),new u(new m(2442778,43215,c.TAI),15),new u(new m(2443144,43216,c.TAI),16),new u(new m(2443509,43217,c.TAI),17),new u(new m(2443874,43218,c.TAI),18),new u(new m(2444239,43219,c.TAI),19),new u(new m(2444786,43220,c.TAI),20),new u(new m(2445151,43221,c.TAI),21),new u(new m(2445516,43222,c.TAI),22),new u(new m(2446247,43223,c.TAI),23),new u(new m(2447161,43224,c.TAI),24),new u(new m(2447892,43225,c.TAI),25),new u(new m(2448257,43226,c.TAI),26),new u(new m(2448804,43227,c.TAI),27),new u(new m(2449169,43228,c.TAI),28),new u(new m(2449534,43229,c.TAI),29),new u(new m(2450083,43230,c.TAI),30),new u(new m(2450630,43231,c.TAI),31),new u(new m(2451179,43232,c.TAI),32),new u(new m(2453736,43233,c.TAI),33),new u(new m(2454832,43234,c.TAI),34),new u(new m(2456109,43235,c.TAI),35),new u(new m(2457204,43236,c.TAI),36),new u(new m(2457754,43237,c.TAI),37)],m}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,i,a){a=e(a,!1);var o,u,s,c={},f=t(n),l=t(i);if(f)for(o in n)n.hasOwnProperty(o)&&(u=n[o],l&&a&&"object"==typeof u&&i.hasOwnProperty(o)?(s=i[o],"object"==typeof s?c[o]=r(u,s,a):c[o]=u):c[o]=u);if(l)for(o in i)i.hasOwnProperty(o)&&!c.hasOwnProperty(o)&&(s=i[o],c[o]=s);return c}return r}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,a,o){if(!r(i))throw new n("relative uri is required.");if(!r(a)){if("undefined"==typeof o)return i;a=t(o.baseURI,o.location.href)}var u=new e(a),s=new e(i);return s.resolve(u).toString()},i}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,i){if(!t(n))throw new r("uri is required.");var a="",o=n.lastIndexOf("/");return-1!==o&&(a=n.substring(0,o+1)),i?(n=new e(n),t(n.query)&&(a+="?"+n.query),t(n.fragment)&&(a+="#"+n.fragment),a):a}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var a=i.path,o=a.lastIndexOf("/");return-1!==o&&(a=a.substr(o+1)),o=a.lastIndexOf("."),a=-1===o?"":a.substr(o+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,i=r.protocol;return r.href=t,r.href=r.href,i!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^data:/i;return t}),define("Core/loadAndExecuteScript",["../ThirdParty/when"],function(e){"use strict";function t(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}return t}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("obj is required.");var i="";for(var a in n)if(n.hasOwnProperty(a)){var o=n[a],u=encodeURIComponent(a)+"=";if(r(o))for(var s=0,c=o.length;c>s;++s)i+=u+encodeURIComponent(o[s])+"&";else i+=u+encodeURIComponent(o)+"&"}return i=i.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var a=n.replace(/\+/g,"%20").split(/[&;]/),o=0,u=a.length;u>o;++o){var s=a[o].split("="),c=decodeURIComponent(s[0]),f=s[1];f=e(f)?decodeURIComponent(f):"";var l=i[c];"string"==typeof l?i[c]=[l,f]:r(l)?l.push(f):i[c]=f}return i}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";var t={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5};return e(t)}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";var t={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3,PACK_TERRAIN:4,PACK_IMAGERY:5};return e(t)}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),a=e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=a,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,a=-1,o=0;o<n.length;o++)if(n[o]===t&&i[o]===r){a=o;break}return-1!==a?(this._insideRaiseEvent?(this._toRemove.push(a),n[a]=void 0,i[a]=void 0):(n.splice(a,1),i.splice(a,1)),!0):!1},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,a=r.length;for(e=0;a>e;e++){var o=r[e];t(o)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if(a=u.length,a>0){for(u.sort(i),e=0;a>e;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function a(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,o=-1,u=!0;u;){var s=2*(e+1),c=s-1;o=r>c&&n(i[c],i[e])<0?c:e,r>s&&n(i[s],i[o])<0&&(o=s),o!==e?(a(i,o,e),e=o):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n=this._array,i=this._comparator,o=this._maximumLength,u=this._length++;for(u<n.length?n[u]=t:n.push(t);0!==u;){var s=Math.floor((u-1)/2);if(!(i(n[u],n[s])<0))break;a(n,u,s),u=s}var c;return r(o)&&this._length>o&&(c=n[o],this._length=o),c},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return a(n,r,--this._length),this.heapify(r),i}},i}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState","./RequestType"],function(e,t,r,n,i,a,o,u,s,c,f,l){"use strict";function d(e,t){return e.priority-t.priority}function h(){}function p(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function m(e){var t=n(h.requestsByServer[e],h.maximumRequestsPerServer);return M[e]<t}function y(e){var r=e.serverKey+"_"+e.providerName;if(i(h.packRequests[r])||(h.packRequests[r]=[]),!(h.packRequests[r].length>=q)){i(h.packRequestQuadKey[r])||(h.packRequestQuadKey[r]=[],h.quadKeyIndex[r]=0,h.totalPacketCount[r]=0,h.currentDeferIndex[r]=0),i(h.currentPacketCount[r])||(h.currentPacketCount[r]=0),i(h.packRequestPromise[r])||(h.packRequestPromise[r]=[t.defer()]),h.totalPacketCount[r]>=U&&(h.totalPacketCount[r]=0,h.currentDeferIndex[r]++,h.packRequestPromise[r].push(t.defer()));var n=h.currentDeferIndex[r];return e.deferred=h.packRequestPromise[r][n],e.state=f.ISSUED,h.packRequests[r].push(e),h.totalPacketCount[r]++,e.deferred.promise}}function E(){h.packRequests={},h.packRequestPromise={},h.packRequestQuadKey={},h.quadKeyIndex={},h.currentPacketCount={},h.totalPacketCount={},h.currentDeferIndex={}}function O(e){var t=e.serverKey+"_"+e.providerName,r=h.packRequestQuadKey[t],n=h.quadKeyIndex[t];i(r[n])?r[n]+=";"+e.quadKey:r[n]=e.quadKey,e.quadKeyIndex=h.currentPacketCount[t],++h.currentPacketCount[t],h.currentPacketCount[t]>=U&&(h.currentPacketCount[t]=0,h.quadKeyIndex[t]++)}function _(e,t){for(var r=U*t,n=0,i=e.length;i>n;n++)if(n>=r){var a=e[n];a.state=f.CANCELLED}}function w(){var t,r=h.packRequests;for(var n in r)if(r.hasOwnProperty(n)){t=void 0;for(var a=r[n],o=0,u=a.length;u>o;o++){var s=a[o];i(t)||(t=s),O(s)}var c;for(i(t)&&(c=t.url),o=0,u=h.packRequestQuadKey[n].length;u>o;o++){var f=h.packRequestQuadKey[n][o];if(-1===f.indexOf(";")&&(f+=";"+f),i(t)){if(t.throttleByServer&&!m(t.serverKey)){_(a,o),h.packRequestPromise[n][o].reject();continue}var l=t.clone();l.state=t.state,l.serverKey=t.serverKey,l.deferred=h.packRequestPromise[n][o],l.deferred.id=o;var d=new e(c);d.query=i(d.query)?d.query+"&extratiles="+f:"extratiles="+f,l.url=d.toString(),g(l,l.url)}}}E()}function T(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function R(e){return function(t){e.state!==f.CANCELLED&&(--S.numberOfActiveRequests,--M[e.serverKey],P.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}function v(e){return function(t){e.state!==f.CANCELLED&&(++S.numberOfFailedRequests,--S.numberOfActiveRequests,--M[e.serverKey],P.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}function g(e,t){var r=T(e);return e.state=f.ACTIVE,x.push(e),++S.numberOfActiveRequests,++S.numberOfActiveRequestsEver,++M[e.serverKey],e.requestFunction(t).then(R(e)).otherwise(v(e)),r}function A(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++S.numberOfCancelledRequests,e.deferred.reject(),t&&(--S.numberOfActiveRequests,--M[e.serverKey],++S.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}function b(){h.debugShowStatistics&&(0===S.numberOfActiveRequests&&S.lastNumberOfActiveRequests>0&&(S.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+S.numberOfAttemptedRequests),S.numberOfAttemptedRequests=0),S.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+S.numberOfCancelledRequests),S.numberOfCancelledRequests=0),S.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+S.numberOfCancelledActiveRequests),S.numberOfCancelledActiveRequests=0),S.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+S.numberOfFailedRequests),S.numberOfFailedRequests=0)),S.lastNumberOfActiveRequests=S.numberOfActiveRequests)}var S={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},N=20,I=new u({comparator:d});I.maximumLength=N,I.reserve(N);var x=[],M={},C="undefined"!=typeof document?new e(document.location.href):new e,P=new o;h.maximumRequests=50,h.maximumRequestsPerServer=6,h.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},h.throttleRequests=!0,h.debugShowStatistics=!1,h.requestCompletedEvent=P,a(h,{statistics:{get:function(){return S}},priorityHeapLength:{get:function(){return N},set:function(e){if(N>e)for(;I.length>e;){var t=I.pop();A(t)}N=e,I.maximumLength=e,I.reserve(e)}}});var U=20,q=120;return h.packRequests={},h.packRequestPromise={},h.packRequestQuadKey={},h.quadKeyIndex={},h.currentPacketCount={},h.totalPacketCount={},h.currentDeferIndex={},h.update=function(){var e,t,r=0,n=x.length;for(e=0;n>e;++e)t=x[e],t.cancelled&&A(t),t.state===f.ACTIVE?r>0&&(x[e-r]=t):++r;x.length-=r,w();var i=I.internalArray,a=I.length;for(e=0;a>e;++e)p(i[e]);I.resort();for(var o=Math.max(h.maximumRequests-x.length,0),u=0;o>u&&I.length>0;)t=I.pop(),t.cancelled?A(t):!t.throttleByServer||m(t.serverKey)?(g(t),++u):A(t);b()},h.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(C);n.normalize();var a=n.authority;/:/.test(a)||(a=a+":"+("https"===n.scheme?"443":"80"));var o=M[a];return i(o)||(M[a]=0),a},h.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return P.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++S.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=h.getServerKey(e.url)),e.type>l.OTHER)return y(e);if(!e.throttleByServer||m(e.serverKey)){if(!h.throttleRequests||!e.throttle)return g(e);if(!(x.length>=h.maximumRequests)){p(e);var t=I.insert(e);if(i(t)){if(t===e)return;A(t)}return T(e)}}},h.clearForSpecs=function(){for(;I.length>0;){var e=I.pop();A(e)}for(var t=x.length,r=0;t>r;++r)A(x[r]);x.length=0,M={},S.numberOfAttemptedRequests=0,S.numberOfActiveRequests=0,S.numberOfCancelledRequests=0,S.numberOfCancelledActiveRequests=0,S.numberOfFailedRequests=0,S.numberOfActiveRequestsEver=0,S.lastNumberOfActiveRequests=0},h.numberOfActiveRequestsByServer=function(e){return M[e]},h.requestHeap=I,h}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var a=i.split("@");i=a[1]}if(-1===i.indexOf(":")){var o=n.getScheme();if(t(o)||(o=window.location.protocol,o=o.substring(0,o.length-1)),"http"===o)i+=":80";else{if("https"!==o)return;i+=":443"}}return i}}var i={},a={};return i.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])||(a[i]=!0)},i.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])&&delete a[i]},i.contains=function(e){if(!t(e))throw new r("url is required.");var i=n(e);return t(i)&&t(a[i])?!0:!1},i.clear=function(){a={}},i}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,i,a,o,u,s,c,f,l,d,h,p,m,y,E,O,_,w,T,R,v,g,A){"use strict";function b(e,t,r,n){var i=e.query;if(!u(i)||0===i.length)return{};var a;if(-1===i.indexOf("=")){var o={};o[i]=void 0,a=o}else a=_(i);r?t._queryParameters=x(a,t._queryParameters,n):t._queryParameters=a,e.query=void 0}function S(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=O(r):e.query=n[0]}function N(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function I(e){if(e.state===v.ISSUED||e.state===v.ACTIVE)throw new g("The Resource is already being fetched.");e.state=v.UNISSUED,e.deferred=void 0}function x(e,t,r){if(!r)return a(e,t);var n=i(e,!0);for(var o in t)if(t.hasOwnProperty(o)){var s=n[o],c=t[o];
u(s)?(Array.isArray(s)||(s=n[o]=[s]),n[o]=s.concat(c)):n[o]=Array.isArray(c)?c.slice():c}return n}function M(t){t=o(t,o.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=N(t.templateValues,{}),this._queryParameters=N(t.queryParameters,{}),this.headers=N(t.headers,{}),this.request=o(t.request,new w),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=o(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);b(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function C(e){var r=e.resource,n=e.flipY,i=e.preferImageBitmap,a=r.request;a.url=r.url,a.requestFunction=function(){var e=r.url,a=!1;r.isDataUri||r.isBlobUri||(a=r.isCrossOriginUrl);var o=t.defer();return M._Implementations.createImage(e,a,o,n,i),o.promise};var o=R.request(a);return u(o)?o.otherwise(function(e){return a.state!==v.FAILED?t.reject(e):r.retryOnError(e).then(function(o){return o?(a.state=v.UNISSUED,a.deferred=void 0,C({resource:r,flipY:n,preferImageBitmap:i})):t.reject(e)})}):void 0}function P(e,r,n){var i={};i[r]=n,e.setQueryParameters(i);var a=e.request;a.url=e.url,a.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(t){window[n]=void 0}},M._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var o=R.request(a);return u(o)?o.otherwise(function(i){return a.state!==v.FAILED?t.reject(i):e.retryOnError(i).then(function(o){return o?(a.state=v.UNISSUED,a.deferred=void 0,P(e,r,n)):t.reject(i)})}):void 0}function U(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function q(e,t){for(var r=U(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),a=0;a<r.length;a++)i[a]=r.charCodeAt(a);return n}function D(e,t){t=o(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return U(n,i);case"arraybuffer":return q(n,i);case"blob":var a=q(n,i);return new Blob([a],{type:r});case"document":var u=new DOMParser;return u.parseFromString(U(n,i),r);case"json":return JSON.parse(U(n,i));default:throw new c("Unhandled responseType: "+t)}}function L(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(A.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e}function B(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function F(e,t,r,n,i,a,o){var u=global.require,s=u("url").parse(e),c=u("https:"===s.protocol?"https":"http"),f=u("zlib"),l={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:r,headers:i};c.request(l).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void a.reject(new T(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?f.gunzip(n,function(e,r){e?a.reject(new g("Error decompressing response.")):a.resolve(B(r,t))}):a.resolve(B(n,t))})}).on("error",function(e){a.reject(new T)}).end()}var j=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();M.createIfNeeded=function(e){return e instanceof M?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new M({url:e})};var z;M.supportsImageBitmapOptions=function(){if(u(z))return z;if("function"!=typeof createImageBitmap)return z=t.resolve(!1);var e="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg==";return z=M.fetchBlob({url:e}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},s(M,{isBlobSupported:{get:function(){return j}}}),s(M.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);b(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return h(this._url)}},isDataUri:{get:function(){return y(this._url)}},isBlobUri:{get:function(){return p(this._url)}},isCrossOriginUrl:{get:function(){return m(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),M.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&S(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues;return i=i.replace(/{(.*?)}/g,function(e,t){var r=a[t];return u(r)?encodeURIComponent(r):e}),r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},M.prototype.setQueryParameters=function(e,t){t?this._queryParameters=x(this._queryParameters,e,!1):this._queryParameters=x(e,this._queryParameters,!1)},M.prototype.appendQueryParameters=function(e){this._queryParameters=x(e,this._queryParameters,!0)},M.prototype.setTemplateValues=function(e,t){t?this._templateValues=a(this._templateValues,e):this._templateValues=a(e,this._templateValues)},M.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url),i=o(t.preserveQueryParameters,!1);b(n,r,!0,i),n.fragment=void 0,r._url=n.resolve(new e(l(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=a(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=a(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=a(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},M.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},M.prototype.clone=function(e){return u(e)||(e=new M({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},M.prototype.getBaseUri=function(e){return d(this.getUrlComponent(e),e)},M.prototype.appendForwardSlash=function(){this._url=r(this._url)},M.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},M.fetchArrayBuffer=function(e){var t=new M(e);return t.fetchArrayBuffer()},M.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},M.fetchBlob=function(e){var t=new M(e);return t.fetchBlob()},M.prototype.fetchImage=function(e){e=o(e,o.EMPTY_OBJECT);var r=o(e.preferImageBitmap,!1),n=o(e.preferBlob,!1),i=o(e.flipY,!1);if(I(this.request),!j||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return C({resource:this,flipY:i,preferImageBitmap:r});var a=this.fetchBlob();if(u(a)){var s,c,f,l;return M.supportsImageBitmapOptions().then(function(e){return s=e,c=s&&r,a}).then(function(e){if(u(e)){if(l=e,c)return M.createImageBitmapFromBlob(e,{flipY:i,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return f=new M({url:t}),C({resource:f,flipY:i,preferImageBitmap:!1})}}).then(function(e){return u(e)?(e.blob=l,c?e:(window.URL.revokeObjectURL(f.url),e)):void 0}).otherwise(function(e){return u(f)&&window.URL.revokeObjectURL(f.url),e.blob=l,t.reject(e)})}},M.fetchImage=function(e){var t=new M(e);return t.fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},M.prototype.fetchText=function(){return this.fetch({responseType:"text"})},M.fetchText=function(e){var t=new M(e);return t.fetchText()},M.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then(function(e){return u(e)?JSON.parse(e):void 0})},M.fetchJson=function(e){var t=new M(e);return t.fetchJson()},M.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},M.fetchXML=function(e){var t=new M(e);return t.fetchXML()},M.prototype.fetchJsonp=function(e){e=o(e,"callback"),I(this.request);var t;do t="loadJsonp"+Math.random().toString().substring(2,8);while(u(window[t]));return P(this,e,t)},M.fetchJsonp=function(e){var t=new M(e);return t.fetchJsonp(e.callbackParameterName)},M.prototype._makeRequest=function(e){var r=this;I(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(i){var o=e.responseType,s=a(e.headers,r.headers),c=e.overrideMimeType,f=e.method,l=e.data,d=t.defer(),h=u(i)?i:r.url,p=M._Implementations.loadWithXhr(h,o,f,l,s,d,c);return u(p)&&u(p.abort)&&(n.cancelFunction=function(){p.abort()}),d.promise};var i=R.request(n);return u(i)?i.then(function(e){return e}).otherwise(function(i){return n.state!==v.FAILED?t.reject(i):r.retryOnError(i).then(function(a){return a?(n.state=v.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)})}):void 0};var G=/^data:(.*?)(;base64)?,(.*)$/;M.prototype.fetch=function(e){return e=N(e,{}),e.method="GET",this._makeRequest(e)},M.fetch=function(e){var t=new M(e);return t.fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype["delete"]=function(e){return e=N(e,{}),e.method="DELETE",this._makeRequest(e)},M["delete"]=function(e){var t=new M(e);return t["delete"]({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},M.prototype.head=function(e){return e=N(e,{}),e.method="HEAD",this._makeRequest(e)},M.head=function(e){var t=new M(e);return t.head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.options=function(e){return e=N(e,{}),e.method="OPTIONS",this._makeRequest(e)},M.options=function(e){var t=new M(e);return t.options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.post=function(e,t){return n.defined("data",e),t=N(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},M.post=function(e){var t=new M(e);return t.post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.put=function(e,t){return n.defined("data",e),t=N(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},M.put=function(e){var t=new M(e);return t.put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.patch=function(e,t){return n.defined("data",e),t=N(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},M.patch=function(e){var t=new M(e);return t.patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M._Implementations={},M._Implementations.createImage=function(e,t,r,n,i){M.supportsImageBitmapOptions().then(function(n){return n&&i?M.fetchBlob({url:e}):void L(e,t,r)}).then(function(e){return u(e)?M.createImageBitmapFromBlob(e,{flipY:n,premultiplyAlpha:!1}):void 0}).then(function(e){u(e)&&r.resolve(e)}).otherwise(r.reject)},M.createImageBitmapFromBlob=function(e,t){return n.defined("options",t),n.typeOf.bool("options.flipY",t.flipY),n.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var V="undefined"==typeof XMLHttpRequest;return M._Implementations.loadWithXhr=function(e,t,r,n,i,a,o){var s=G.exec(e);if(null!==s)return void a.resolve(D(s,t));if(V)return void F(e,t,r,n,i,a,o);var c=new XMLHttpRequest;if(A.contains(e)&&(c.withCredentials=!0),e=e.replace(/{/g,"%7B").replace(/}/g,"%7D"),c.open(r,e,!0),u(o)&&u(c.overrideMimeType)&&c.overrideMimeType(o),u(i))for(var f in i)i.hasOwnProperty(f)&&c.setRequestHeader(f,i[f]);u(t)&&(c.responseType=t);var l=!1;return"string"==typeof e&&(l=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!l||0!==c.status))return void a.reject(new T(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var i=c.getAllResponseHeaders(),o=i.trim().split(/[\r\n]+/),s={};return o.forEach(function(e){var t=e.split(": "),r=t.shift();s[r]=t.join(": ")}),void a.resolve(s)}if(204===c.status)a.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{a.resolve(JSON.parse(e))}catch(f){a.reject(f)}else(""===n||"document"===n)&&u(c.responseXML)&&c.responseXML.hasChildNodes()?a.resolve(c.responseXML):""!==n&&"text"!==n||!u(c.responseText)?a.reject(new g("Invalid XMLHttpRequest response type.")):a.resolve(c.responseText);else a.resolve(e)},c.onerror=function(e){a.reject(new T)},c.send(n),c},M._Implementations.loadAndExecuteScript=function(e,t,r){return E(e,t).otherwise(r.reject)},M._DefaultImplementations={},M._DefaultImplementations.createImage=M._Implementations.createImage,M._DefaultImplementations.loadWithXhr=M._Implementations.loadWithXhr,M._DefaultImplementations.loadAndExecuteScript=M._Implementations.loadAndExecuteScript,M.DEFAULT=f(new M({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),M}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c,f,l){"use strict";function d(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))p(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),a=this;this._downloadPromise=e(i.fetchJson(),function(e){p(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."})}else p(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return o.compare(e.julianDate,t)}function p(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>c||0>d||0>p||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var y=e._samples=r.samples,E=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var O,_=e._addNewLeapSeconds,w=0,T=y.length;T>w;w+=e._columnCount){var R=y[w+i],v=y[w+m],g=R+f.MODIFIED_JULIAN_DATE_DIFFERENCE,A=new o(g,v,l.TAI);if(E.push(A),_){if(v!==O&&n(O)){var b=o.leapSeconds,S=t(b,A,h);if(0>S){var N=new u(A,v);b.splice(~S,0,N)}}O=v}}}function m(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function y(e,t,r){return t+e*(r-t)}function E(e,t,r,n,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],f=t[a];if(c.equals(f)||n.equals(c))return m(e,r,i,s,u),u;if(n.equals(f))return m(e,r,a,s,u),u;var l=o.secondsDifference(n,c)/o.secondsDifference(f,c),d=i*s,h=a*s,p=r[d+e._ut1MinusUtcSecondsColumn],E=r[h+e._ut1MinusUtcSecondsColumn],O=E-p;if(O>.5||-.5>O){var _=r[d+e._taiMinusUtcSecondsColumn],w=r[h+e._taiMinusUtcSecondsColumn];_!==w&&(f.equals(n)?p=E:E-=w-_)}return u.xPoleWander=y(l,r[d+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=y(l,r[d+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=y(l,r[d+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=y(l,r[d+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=y(l,p,E),u}return d.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,u=this._lastIndex,s=0,f=0;if(n(u)){var l=a[u],d=a[u+1],h=o.lessThanOrEquals(l,e),p=!n(d),m=p||o.greaterThanOrEquals(d,e);if(h&&m)return s=u,!p&&d.equals(e)&&++s,f=s+1,E(this,a,this._samples,e,s,f,r),r}var y=t(a,e,o.compare,this._dateColumn);return y>=0?(y<a.length-1&&a[y+1].equals(e)&&++y,s=y,f=y):(f=~y,s=f-1,0>s&&(s=0)),this._lastIndex=s,E(this,a,this._samples,e,s,f,r),r}if(n(this._dataError))throw new c(this._dataError)},d}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var a=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,o),n.pitch=-Math.asin(a),n},i.fromDegrees=function(e,a,o,u){if(!t(e))throw new r("heading is required");if(!t(a))throw new r("pitch is required");if(!t(o))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=a*n.RADIANS_PER_DEGREE,u.roll=o*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){return t(e)?t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,a){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,a)&&n.equalsEpsilon(e.pitch,r.pitch,i,a)&&n.equalsEpsilon(e.roll,r.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],function(e,t,r,n,i){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),i=p.exec(n);if(null!==i)return i[1]}}function o(t){return"undefined"==typeof document?t:(e(l)||(l=document.createElement("a")),l.href=t,l.href=l.href,l.href)}function u(){if(e(d))return d;var u;if(u="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",f("Core/buildModuleUrl.js")):a(),!e(u))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return d=new n({url:o(u)}),d.appendForwardSlash(),d}function s(e){return o(i.toUrl("../"+e))}function c(e){var t=u().getDerivedResource({url:e});return t.url}function f(t){e(h)||(h=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?s:c);var r=h(t);return r}var l,d,h,p=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return f._cesiumScriptRegex=p,f._buildModuleUrlFromBaseUrl=c,f._clearBaseResource=function(){d=void 0},f.setBaseUrl=function(e){d=n.DEFAULT.getDerivedResource({url:e})},f.getCesiumBaseUrl=u,f}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,i,a,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=o.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;t>=c;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var f=0;t>=f;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=l;return n.dayNumber=t,n.secondsOfDay=r,a.daysDifference(n,e._sampleZeroDateTT)}function f(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var a=e.defer();r._chunkDownloadsInProgress[i]=a;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.getDerivedResource({templateValues:{0:i}}):new o({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(u.fetchJson(),function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,o=i*r._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)t[o+u]=n[u];a.resolve()}),a.promise}var l=new a(0,0,u.TAI);return s.prototype.preload=function(t,r,n,i){var a=c(this,t,r),o=c(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var l=u/this._samplesPerXysFile|0,d=s/this._samplesPerXysFile|0,h=[],p=l;d>=p;++p)h.push(f(this,p));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var a=c(this,e,t);if(!(0>a)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);0>s&&(s=0);var l=s+u;l>=this._totalSamples&&(l=this._totalSamples-1,s=l-u,0>s&&(s=0));var d=!1,h=this._samples;if(n(h[3*s])||(f(this,s/this._samplesPerXysFile|0),d=!0),n(h[3*l])||(f(this,l/this._samplesPerXysFile|0),d=!0),!d){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var p,m,y=a-s*this._stepSizeDays,E=this._work,O=this._denominators,_=this._coef,w=this._xTable;for(p=0;u>=p;++p)E[p]=y-w[p];for(p=0;u>=p;++p){for(_[p]=1,m=0;u>=m;++m)m!==p&&(_[p]*=E[m]);_[p]*=O[p];var T=3*(s+p);r.x+=_[p]*h[T++],r.y+=_[p]*h[T++],r.s+=_[p]*h[T]}return r}}}},s}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen","./RuntimeError","../ThirdParty/when"],function(e,t,r,n,i){"use strict";function a(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(S)&&(S=!1,!p())){var e=/ Chrome\/([\.0-9]+)/.exec(b.userAgent);null!==e&&(S=!0,N=a(e[1]))}return S}function u(){return o()&&N}function s(){if(!t(I)&&(I=!1,!o()&&!p()&&/ Safari\/[\.0-9]+/.test(b.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(b.userAgent);null!==e&&(I=!0,x=a(e[1]))}return I}function c(){return s()&&x}function f(){if(!t(M)){M=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(b.userAgent);null!==e&&(M=!0,C=a(e[1]),C.isNightly=!!e[2])}return M}function l(){return f()&&C}function d(){if(!t(P)){P=!1;var e;"Microsoft Internet Explorer"===b.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(b.userAgent),null!==e&&(P=!0,U=a(e[1]))):"Netscape"===b.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(b.userAgent),null!==e&&(P=!0,U=a(e[1])))}return P}function h(){return d()&&U}function p(){if(!t(q)){q=!1;var e=/ Edge\/([\.0-9]+)/.exec(b.userAgent);null!==e&&(q=!0,D=a(e[1]))}return q}function m(){return p()&&D}function y(){if(!t(L)){L=!1;var e=/Firefox\/([\.0-9]+)/.exec(b.userAgent);null!==e&&(L=!0,B=a(e[1]))}return L}function E(){return t(F)||(F=/Windows/i.test(b.appVersion)),F}function O(){return y()&&B}function _(){return t(j)||(j="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),j}function w(){return t(z)||(z=!y()&&"undefined"!=typeof PointerEvent&&(!t(b.pointerEnabled)||b.pointerEnabled)),z}function T(){if(!t(V)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;V=t(r)&&""!==r,V&&(G=r)}return V}function R(){return T()?G:void 0}function v(){if(t(X))return X.promise;X=i.defer(),p()&&(W=!1,X.resolve(W));var e=new Image;return e.onload=function(){W=e.width>0&&e.height>0,X.resolve(W)},e.onerror=function(){W=!1,X.resolve(W)},e.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",X.promise}function g(){return t(X)||v(),W}function A(){var e=window.navigator.userAgent.toLowerCase(),t="ipad"==e.match(/ipad/i),r="iphone os"==e.match(/iphone os/i),n="midp"==e.match(/midp/i),i="rv:1.2.3.4"==e.match(/rv:1.2.3.4/i),a="ucweb"==e.match(/ucweb/i),o="android"==e.match(/android/i),u="windows ce"==e.match(/windows ce/i),s="windows mobile"==e.match(/windows mobile/i);return t||r||n||i||a||o||u||s?!1:!0}var b;b="undefined"!=typeof navigator?navigator:{};var S,N,I,x,M,C,P,U,q,D,L,B,F,j,z,G,V,W,X,H=[];"undefined"!=typeof ArrayBuffer&&(H.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&H.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&H.push(CanvasPixelArray));var k={isChrome:o,chromeVersion:u,isSafari:s,safariVersion:c,isWebkit:f,webkitVersion:l,isInternetExplorer:d,internetExplorerVersion:h,isEdge:p,edgeVersion:m,isFirefox:y,firefoxVersion:O,isWindows:E,isNodeJs:_,hardwareConcurrency:e(b.hardwareConcurrency,3),supportsPointerEvents:w,supportsImageRenderingPixelated:T,supportsWebP:v,supportsWebPSync:g,imageRenderingValue:R,typedArrayTypes:H,isPCBroswer:A};return k.supportsFullscreen=function(){return r.supportsFullscreen()},k.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},k.supportsWebWorkers=function(){return"undefined"!=typeof Worker},k.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!k.isEdge()},k}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,a){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var o=i/2,u=Math.sin(o);c=e.normalize(r,c);var f=c.x*u,l=c.y*u,d=c.z*u,h=Math.cos(o);return n(a)?(a.x=f,a.y=l,a.z=d,a.w=h,a):new s(f,l,d,h)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var i,a,o,c,d,h=e[u.COLUMN0ROW0],p=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],y=h+p+m;if(y>0)i=Math.sqrt(y+1),d=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var E=f,O=0;p>h&&(O=1),m>h&&m>p&&(O=2);var _=E[O],w=E[_];i=Math.sqrt(e[u.getElementIndex(O,O)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(w,w)]+1);var T=l;T[O]=.5*i,i=.5/i,d=(e[u.getElementIndex(w,_)]-e[u.getElementIndex(_,w)])*i,T[_]=(e[u.getElementIndex(_,O)]+e[u.getElementIndex(O,_)])*i,T[w]=(e[u.getElementIndex(w,O)]+e[u.getElementIndex(O,w)])*i,a=-T[0],o=-T[1],c=-T[2]}return n(r)?(r.x=a,r.y=o,r.z=c,r.w=d,r):new s(a,o,c,d)};var d=new s,h=new s,p=new s,m=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),m=s.fromAxisAngle(e.UNIT_X,r.roll,d),p=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(p,m,p),h=s.fromAxisAngle(e.UNIT_Z,-r.heading,d),s.multiply(h,n,n)};var y=new e,E=new e,O=new s,_=new s,w=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,w),s.conjugate(w,w);for(var i=0,a=r-t+1;a>i;i++){var o=3*i;s.unpack(e,4*(t+i),O),s.multiply(O,w,O),O.w<0&&s.negate(O,O),s.computeAxis(O,y);var u=s.computeAngle(O);n[o]=y.x*u,n[o+1]=y.y*u,n[o+2]=y.z*u}},s.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*a,_),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(E,u,O),s.multiply(O,_,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w;
},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return r.x=i,r.y=a,r.z=o,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,a=e.y,o=e.z,u=e.w,s=r.x,c=r.y,f=r.z,l=r.w,d=u*s+i*l+a*f-o*c,h=u*c-i*f+a*l+o*s,p=u*f+i*c-a*s+o*l,m=u*l-i*s-a*c-o*f;return n.x=d,n.y=h,n.z=p,n.w=m,n},s.multiplyByVec=function(t,r,n){var i=new e,a=new e,o=new e(t.x,t.y,t.z);i=e.cross(o,r,i),a=e.cross(o,i,a);var u=new e;u=e.multiplyByScalar(i,2*t.w,u);var s=new e;return s=e.multiplyByScalar(i,2,s),n=e.add(r,u,n),n=e.add(n,s,n)},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var T=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),T=s.multiplyByScalar(r,n,T),i=s.multiplyByScalar(e,1-n,i),s.add(T,i,i)};var R=new s,v=new s,g=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a=s.dot(e,r),u=r;if(0>a&&(a=-a,u=R=s.negate(r,R)),1-a<o.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(a);return v=s.multiplyByScalar(e,Math.sin((1-n)*c),v),g=s.multiplyByScalar(u,Math.sin(n*c),g),i=s.add(v,g,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=o.acosClamped(r.w),a=0;return 0!==i&&(a=i/Math.sin(i)),e.multiplyByScalar(r,a,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),a=0;return 0!==i&&(a=Math.sin(i)/i),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(i),n};var A=new e,b=new e,S=new s,N=new s;s.computeInnerQuadrangle=function(r,n,i,a){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",a);var o=s.conjugate(n,S);s.multiply(o,i,N);var u=s.log(N,A);s.multiply(o,r,N);var c=s.log(N,b);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,S),s.multiply(n,S,a)},s.squad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.slerp(e,r,a,S),c=s.slerp(n,i,a,N);return s.slerp(u,c,2*a*(1-a),o)};for(var I=new s,x=1.9011074535173003,M=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],U=i.supportsTypedArrays()?new Float32Array(8):[],q=0;7>q;++q){var D=q+1,L=2*D+1;M[q]=1/(D*L),C[q]=D/L}return M[7]=x/136,C[7]=8*x/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a,o=s.dot(e,r);o>=0?a=1:(a=-1,o=-o);for(var u=o-1,c=1-n,f=n*n,l=c*c,d=7;d>=0;--d)P[d]=(M[d]*f-C[d])*u,U[d]=(M[d]*l-C[d])*u;var h=a*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),p=c*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),m=s.multiplyByScalar(e,p,I);return s.multiplyByScalar(r,h,i),s.add(m,i,i)},s.fastSquad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.fastSlerp(e,r,a,S),c=s.fastSlerp(n,i,a,N);return s.fastSlerp(u,c,2*a*(1-a),o)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,i,a,o,u,s,c,f,l,d,h,p,m,y,E,O,_,w){"use strict";var T={},R={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},v={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},g={},A={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},b=new r,S=new r,N=new r;T.localFrameToFixedFrameGenerator=function(e,t){if(!R.hasOwnProperty(e)||!R[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=R[e][t],a=e+t;return u(g[a])?n=g[a]:(n=function(n,a,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),y.equalsEpsilon(n.x,0,y.EPSILON14)&&y.equalsEpsilon(n.y,0,y.EPSILON14)){var f=y.sign(n.z);r.unpack(v[e],0,b),"east"!==e&&"west"!==e&&r.multiplyByScalar(b,f,b),r.unpack(v[t],0,S),"east"!==t&&"west"!==t&&r.multiplyByScalar(S,f,S),r.unpack(v[i],0,N),"east"!==i&&"west"!==i&&r.multiplyByScalar(N,f,N)}else{a=o(a,l.WGS84),a.geodeticSurfaceNormal(n,A.up);var d=A.up,h=A.east;h.x=-n.y,h.y=n.x,h.z=0,r.normalize(h,A.east),r.cross(d,h,A.north),r.multiplyByScalar(A.up,-1,A.down),r.multiplyByScalar(A.east,-1,A.west),r.multiplyByScalar(A.north,-1,A.south),b=A[e],S=A[t],N=A[i]}return c[0]=b.x,c[1]=b.y,c[2]=b.z,c[3]=0,c[4]=S.x,c[5]=S.y,c[6]=S.z,c[7]=0,c[8]=N.x,c[9]=N.y,c[10]=N.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},g[a]=n),n},T.eastNorthUpToFixedFrame=T.localFrameToFixedFrameGenerator("east","north"),T.northEastDownToFixedFrame=T.localFrameToFixedFrameGenerator("north","east"),T.northUpEastToFixedFrame=T.localFrameToFixedFrameGenerator("north","up"),T.northWestUpToFixedFrame=T.localFrameToFixedFrameGenerator("north","west");var I=new _,x=new r(1,1,1),M=new O;T.headingPitchRollToFixedFrame=function(e,t,n,i,u){a.typeOf.object("HeadingPitchRoll",t),i=o(i,T.eastNorthUpToFixedFrame);var s=_.fromHeadingPitchRoll(t,I),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,x,M);return u=i(e,n,u),O.multiply(u,c,u)};var C=new O,P=new E;T.headingPitchRollQuaternion=function(e,t,r,n,i){a.typeOf.object("HeadingPitchRoll",t);var o=T.headingPitchRollToFixedFrame(e,t,r,n,C),u=O.getRotation(o,P);return _.fromRotationMatrix(u,i)};var U=new r(1,1,1),q=new r,D=new O,L=new O,B=new E,F=new _;T.fixedFrameToHeadingPitchRoll=function(e,t,n,i){a.defined("transform",e),t=o(t,l.WGS84),n=o(n,T.eastNorthUpToFixedFrame),u(i)||(i=new d);var s=O.getTranslation(e,q);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=O.inverseTransformation(n(s,t,D),D),f=O.setScale(e,U,L);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var h=_.fromRotationMatrix(O.getRotation(c,B),F);return h=_.normalize(h,h),d.fromQuaternion(h,i)};var j=24110.54841,z=8640184.812866,G=.093104,V=-62e-7,W=1.1772758384668e-19,X=72921158553e-15,H=y.TWO_PI/86400,k=new m;T.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");k=m.addSeconds(e,-m.computeTaiMinusUtc(e),k);var r,n=k.dayNumber,i=k.secondsOfDay,a=n-2451545;r=i>=43200?(a+.5)/w.DAYS_PER_JULIAN_CENTURY:(a-.5)/w.DAYS_PER_JULIAN_CENTURY;var o=j+r*(z+r*(G+r*V)),c=o*H%y.TWO_PI,f=X+W*(n-2451545.5),l=(i+.5*w.SECONDS_PER_DAY)%w.SECONDS_PER_DAY,d=c+f*l,h=Math.cos(d),p=Math.sin(d);return u(t)?(t[0]=h,t[1]=-p,t[2]=0,t[3]=p,t[4]=h,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(h,p,0,-p,h,0,0,0,1)},T.iau2006XysData=new h,T.earthOrientationParameters=c.NONE;var Y=32.184,K=2451545;T.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+Y,i=t.stop.dayNumber,a=t.stop.secondsOfDay+Y,o=T.iau2006XysData.preload(r,n,i,a),u=T.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},T.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=T.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var Z=new p(0,0,0),J=new f(0,0,0,0,0,0),Q=new E,$=new E;T.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=T.earthOrientationParameters.compute(e,J);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+Y,a=T.iau2006XysData.computeXysRadians(n,i,Z);if(u(a)){var o=a.x+r.xPoleOffset,c=a.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-o*o-c*c)),l=Q;l[0]=1-f*o*o,l[3]=-f*o*c,l[6]=o,l[1]=-f*o*c,l[4]=1-f*c*c,l[7]=c,l[2]=-o,l[5]=-c,l[8]=1-f*(o*o+c*c);var d=E.fromRotationZ(-a.s,$),h=E.multiply(l,d,Q),p=e.dayNumber,O=e.secondsOfDay-m.computeTaiMinusUtc(e)+r.ut1MinusUtc,_=p-2451545,R=O/w.SECONDS_PER_DAY,v=.779057273264+R+.00273781191135448*(_+R);v=v%1*y.TWO_PI;var g=E.fromRotationZ(v,$),A=E.multiply(h,g,Q),b=Math.cos(r.xPoleWander),S=Math.cos(r.yPoleWander),N=Math.sin(r.xPoleWander),I=Math.sin(r.yPoleWander),x=n-K+i/w.SECONDS_PER_DAY;x/=36525;var M=-47e-6*x*y.RADIANS_PER_DEGREE/3600,C=Math.cos(M),P=Math.sin(M),U=$;return U[0]=b*C,U[1]=b*P,U[2]=N,U[3]=-S*P+I*N*C,U[4]=S*C+I*N*P,U[5]=-I*b,U[6]=-I*P-S*N*C,U[7]=I*C-S*N*P,U[8]=S*b,E.multiply(A,U,t)}}};var ee=new n;T.pointToWindowCoordinates=function(e,t,r,n){return n=T.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},T.pointToGLWindowCoordinates=function(e,r,i,a){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(a)||(a=new t);var o=ee;return O.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,o),o),n.multiplyByScalar(o,1/o.w,o),O.multiplyByVector(r,o,o),t.fromCartesian4(o,a)};var te=new r,re=new r,ne=new r;T.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var a=o(n,l.WGS84).geodeticSurfaceNormal(e,te),c=r.cross(t,a,re);r.equalsEpsilon(c,r.ZERO,y.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,ne);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new E),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=f.x,i[7]=f.y,i[8]=f.z,i};var ie=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),ae=new i,oe=new r,ue=new r,se=new E,ce=new O,fe=new O;return T.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=O.getTranslation(t,ue),a=e.ellipsoid,o=a.cartesianToCartographic(i,ae),c=e.project(o,oe);r.fromElements(c.z,c.x,c.y,c);var f=T.eastNorthUpToFixedFrame(i,a,ce),l=O.inverseTransformation(f,fe),d=O.getRotation(t,se),h=O.multiplyByMatrix3(l,d,n);return O.multiply(ie,h,n),O.setTranslation(n,c,n),n},T.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,a=T.eastNorthUpToFixedFrame(t,i,ce),o=O.inverseTransformation(a,fe),c=i.cartesianToCartographic(t,ae),f=e.project(c,oe);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,ce);return O.multiply(ie,o,n),O.multiply(l,n,n),n},T.buildUp=function(e,t){var n=t.clone(),i=e.clone();i=r.normalize(i,i),Math.abs(r.dot(i,n))>=1&&(i=Math.abs(r.dot(n,r.UNIT_Y))<1?r.clone(r.UNIT_Y,i):r.clone(r.UNIT_Z,i));var a=new r;return r.cross(i,n,a),a=r.normalize(a,a),r.cross(n,a,i),i=r.normalize(i,i)},T.getHeading=function(e,t){var r;return r=y.equalsEpsilon(Math.abs(e.z),1,y.EPSILON3)?Math.atan2(t.y,t.x)-y.PI_OVER_TWO:Math.atan2(e.y,e.x)-y.PI_OVER_TWO,y.TWO_PI-y.zeroToTwoPi(r)},T}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,i,a,o,u,s,c,f,l,d,h,p){"use strict";function m(e,t){if(i.defined("origin",e),t=a(t,c.WGS84),e=t.scaleToGeodeticSurface(e),!o(e))throw new s("origin must not be at the center of the ellipsoid.");var n=p.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(l.getColumn(n,0,y)),this._yAxis=r.fromCartesian4(l.getColumn(n,1,y));var u=r.fromCartesian4(l.getColumn(n,2,y));this._plane=d.fromPointNormal(e,u)}var y=new n;u(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var E=new e;m.fromPoints=function(t,r){i.defined("cartesians",t);var n=e.fromPoints(t,E);return new m(n.center,r)};var O=new h,_=new r;m.prototype.projectPointOntoPlane=function(e,n){i.defined("cartesian",e);var a=O;a.origin=e,r.normalize(e,a.direction);var u=f.rayPlane(a,this._plane,_);if(o(u)||(r.negate(a.direction,a.direction),u=f.rayPlane(a,this._plane,_)),o(u)){var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),l=r.dot(this._yAxis,s);return o(n)?(n.x=c,n.y=l,n):new t(c,l)}},m.prototype.projectPointsOntoPlane=function(e,t){i.defined("cartesians",e),o(t)||(t=[]);for(var r=0,n=e.length,a=0;n>a;a++){var u=this.projectPointOntoPlane(e[a],t[r]);o(u)&&(t[r]=u,r++)}return t.length=r,t},m.prototype.projectPointToNearestOnPlane=function(e,n){i.defined("cartesian",e),o(n)||(n=new t);var a=O;a.origin=e,r.clone(this._plane.normal,a.direction);var u=f.rayPlane(a,this._plane,_);o(u)||(r.negate(a.direction,a.direction),u=f.rayPlane(a,this._plane,_));var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),l=r.dot(this._yAxis,s);return n.x=c,n.y=l,n},m.prototype.projectPointsToNearestOnPlane=function(e,t){i.defined("cartesians",e),o(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;r>n;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var w=new r;return m.prototype.projectPointOntoEllipsoid=function(e,t){i.defined("cartesian",e),o(t)||(t=new r);var n=this._ellipsoid,a=this._origin,u=this._xAxis,s=this._yAxis,c=w;return r.multiplyByScalar(u,e.x,c),t=r.add(a,c,t),r.multiplyByScalar(s,e.y,c),r.add(t,c,t),n.scaleToGeocentricSurface(t,t),t},m.prototype.projectPointsOntoEllipsoid=function(e,t){i.defined("cartesians",e);var r=e.length;o(t)?t.length=r:t=new Array(r);for(var n=0;r>n;++n)t[n]=this.projectPointOntoEllipsoid(e[n],t[n]);return t},m}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,f,l,d,h,p,m){"use strict";function y(e,t){this.center=r.clone(a(e,r.ZERO)),this.halfAxes=h.clone(a(t,h.ZERO))}function E(e,t,n,i,a,s,c,f){if(!(o(t)&&o(n)&&o(i)&&o(a)&&o(s)&&o(c)))throw new u("all extents (minimum/maximum X/Y/Z) are required.");o(f)||(f=new y);var l=f.halfAxes;h.setColumn(l,0,e.xAxis,l),h.setColumn(l,1,e.yAxis,l),h.setColumn(l,2,e.zAxis,l);var d=b;d.x=(t+n)/2,d.y=(i+a)/2,d.z=(s+c)/2;var p=S;p.x=(n-t)/2,p.y=(a-i)/2,p.z=(c-s)/2;var m=f.center;return d=h.multiplyByVector(l,d,d),r.add(e.origin,d,m),h.multiplyByScale(l,p,l),f}y.packedLength=r.packedLength+h.packedLength,y.pack=function(e,t,n){return i.typeOf.object("value",e),i.defined("array",t),n=a(n,0),r.pack(e.center,t,n),h.pack(e.halfAxes,t,n+r.packedLength),t},y.unpack=function(e,t,n){return i.defined("array",e),t=a(t,0),o(n)||(n=new y),r.unpack(e,t,n.center),h.unpack(e,t+r.packedLength,n.halfAxes),n};var O=new r,_=new r,w=new r,T=new r,R=new r,v=new r,g=new h,A={unitary:new h,diagonal:new h};y.fromPoints=function(e,t){if(o(t)||(t=new y),!o(e)||0===e.length)return t.halfAxes=h.ZERO,t.center=r.ZERO,t;var n,i=e.length,a=r.clone(e[0],O);for(n=1;i>n;n++)r.add(a,e[n],a);var u=1/i;r.multiplyByScalar(a,u,a);var s,c=0,f=0,l=0,d=0,p=0,m=0;for(n=0;i>n;n++)s=r.subtract(e[n],a,_),c+=s.x*s.x,f+=s.x*s.y,l+=s.x*s.z,d+=s.y*s.y,p+=s.y*s.z,m+=s.z*s.z;c*=u,f*=u,l*=u,d*=u,p*=u,m*=u;var E=g;E[0]=c,E[1]=f,E[2]=l,E[3]=f,E[4]=d,E[5]=p,E[6]=l,E[7]=p,E[8]=m;var b=h.computeEigenDecomposition(E,A),S=h.clone(b.unitary,t.halfAxes),N=h.getColumn(S,0,T),I=h.getColumn(S,1,R),x=h.getColumn(S,2,v),M=-Number.MAX_VALUE,C=-Number.MAX_VALUE,P=-Number.MAX_VALUE,U=Number.MAX_VALUE,q=Number.MAX_VALUE,D=Number.MAX_VALUE;for(n=0;i>n;n++)s=e[n],M=Math.max(r.dot(N,s),M),C=Math.max(r.dot(I,s),C),P=Math.max(r.dot(x,s),P),U=Math.min(r.dot(N,s),U),q=Math.min(r.dot(I,s),q),D=Math.min(r.dot(x,s),D);N=r.multiplyByScalar(N,.5*(U+M),N),I=r.multiplyByScalar(I,.5*(q+C),I),x=r.multiplyByScalar(x,.5*(D+P),x);var L=r.add(N,I,t.center);r.add(L,x,L);var B=w;return B.x=M-U,B.y=C-q,B.z=P-D,r.multiplyByScalar(B,.5,B),h.multiplyByScale(t.halfAxes,B,t.halfAxes),t};var b=new r,S=new r,N=new n,I=new r,x=[new n,new n,new n,new n,new n,new n,new n,new n],M=[new r,new r,new r,new r,new r,new r,new r,new r],C=[new t,new t,new t,new t,new t,new t,new t,new t];y.fromRectangle=function(e,t,r,n,i){if(!o(e))throw new u("rectangle is required");if(e.width<0||e.width>d.TWO_PI)throw new u("Rectangle width must be between 0 and 2*pi");if(e.height<0||e.height>d.PI)throw new u("Rectangle height must be between 0 and pi");if(o(n)&&!d.equalsEpsilon(n.radii.x,n.radii.y,d.EPSILON15))throw new u("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");t=a(t,0),r=a(r,0),n=a(n,s.WGS84);var f=m.center(e,N),l=n.cartographicToCartesian(f,I),h=new c(l,n),y=h.plane,O=x[0],_=x[1],w=x[2],T=x[3],R=x[4],v=x[5],g=x[6],A=x[7],b=f.longitude,S=e.south<0&&e.north>0?0:f.latitude;g.latitude=v.latitude=R.latitude=e.south,A.latitude=T.latitude=S,O.latitude=_.latitude=w.latitude=e.north,g.longitude=A.longitude=O.longitude=e.west,v.longitude=_.longitude=b,R.longitude=T.longitude=w.longitude=e.east,w.height=_.height=O.height=A.height=g.height=v.height=R.height=T.height=r,n.cartographicArrayToCartesianArray(x,M),h.projectPointsToNearestOnPlane(M,C);var P=Math.min(C[6].x,C[7].x,C[0].x),U=Math.max(C[2].x,C[3].x,C[4].x),q=Math.min(C[4].y,C[5].y,C[6].y),D=Math.max(C[0].y,C[1].y,C[2].y);w.height=O.height=R.height=g.height=t,n.cartographicArrayToCartesianArray(x,M);var L=Math.min(p.getPointDistance(y,M[0]),p.getPointDistance(y,M[2]),p.getPointDistance(y,M[4]),p.getPointDistance(y,M[6])),B=r;return E(h,P,U,q,D,L,B,i)},y.clone=function(e,t){return o(e)?o(t)?(r.clone(e.center,t.center),h.clone(e.halfAxes,t.halfAxes),t):new y(e.center,e.halfAxes):void 0},y.intersectPlane=function(e,t){if(!o(e))throw new u("box is required.");if(!o(t))throw new u("plane is required.");var n=e.center,i=t.normal,a=e.halfAxes,s=i.x,c=i.y,l=i.z,d=Math.abs(s*a[h.COLUMN0ROW0]+c*a[h.COLUMN0ROW1]+l*a[h.COLUMN0ROW2])+Math.abs(s*a[h.COLUMN1ROW0]+c*a[h.COLUMN1ROW1]+l*a[h.COLUMN1ROW2])+Math.abs(s*a[h.COLUMN2ROW0]+c*a[h.COLUMN2ROW1]+l*a[h.COLUMN2ROW2]),p=r.dot(i,n)+t.distance;return-d>=p?f.OUTSIDE:p>=d?f.INSIDE:f.INTERSECTING};var P=new r,U=new r,q=new r,D=new r;y.distanceSquaredTo=function(e,t){if(!o(e))throw new u("box is required.");if(!o(t))throw new u("cartesian is required.");var n=r.subtract(t,e.center,b),i=e.halfAxes,a=h.getColumn(i,0,P),s=h.getColumn(i,1,U),c=h.getColumn(i,2,q),f=r.magnitude(a),l=r.magnitude(s),d=r.magnitude(c);r.normalize(a,a),r.normalize(s,s),r.normalize(c,c);var p=D;p.x=r.dot(n,a),p.y=r.dot(n,s),p.z=r.dot(n,c);var m,y=0;return p.x<-f?(m=p.x+f,y+=m*m):p.x>f&&(m=p.x-f,y+=m*m),p.y<-l?(m=p.y+l,y+=m*m):p.y>l&&(m=p.y-l,y+=m*m),p.z<-d?(m=p.z+d,y+=m*m):p.z>d&&(m=p.z-d,y+=m*m),y};var L=new r,B=new r;y.computePlaneDistances=function(e,t,n,i){if(!o(e))throw new u("box is required.");if(!o(t))throw new u("position is required.");if(!o(n))throw new u("direction is required.");o(i)||(i=new l);var a=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,c=e.center,f=e.halfAxes,d=h.getColumn(f,0,P),p=h.getColumn(f,1,U),m=h.getColumn(f,2,q),y=r.add(d,p,L);r.add(y,m,y),r.add(y,c,y);var E=r.subtract(y,t,B),O=r.dot(n,E);return a=Math.min(O,a),s=Math.max(O,s),r.add(c,d,y),r.add(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),a=Math.min(O,a),s=Math.max(O,s),r.add(c,d,y),r.subtract(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),a=Math.min(O,a),s=Math.max(O,s),r.add(c,d,y),r.subtract(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),a=Math.min(O,a),s=Math.max(O,s),r.subtract(c,d,y),r.add(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),a=Math.min(O,a),s=Math.max(O,s),r.subtract(c,d,y),r.add(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),a=Math.min(O,a),s=Math.max(O,s),r.subtract(c,d,y),r.subtract(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),a=Math.min(O,a),s=Math.max(O,s),r.subtract(c,d,y),r.subtract(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),a=Math.min(O,a),s=Math.max(O,s),i.start=a,i.stop=s,i};var F=new e;return y.isOccluded=function(t,r){if(!o(t))throw new u("box is required.");if(!o(r))throw new u("occluder is required.");var n=e.fromOrientedBoundingBox(t,F);return!r.isBoundingSphereVisible(n)},y.prototype.intersectPlane=function(e){return y.intersectPlane(this,e)},y.prototype.distanceSquaredTo=function(e){return y.distanceSquaredTo(this,e)},y.prototype.computePlaneDistances=function(e,t,r){return y.computePlaneDistances(this,e,t,r)},y.prototype.isOccluded=function(e){return y.isOccluded(this,e)},y.equals=function(e,t){return e===t||o(e)&&o(t)&&r.equals(e.center,t.center)&&h.equals(e.halfAxes,t.halfAxes)},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}},i(o)}),define("Core/TerrainQuantization",["./freezeObject"],function(e){"use strict";var t={NONE:0,BITS12:1};return e(t)}),define("Core/TerrainEncoding",["./AttributeCompression","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Math","./Matrix4","./TerrainQuantization"],function(e,t,r,n,i,a,o,u,s){"use strict";function c(e,t,n,o,c,d){var y,E,O,_=s.NONE;if(a(e)&&a(t)&&a(n)&&a(o)){var w=e.minimum,T=e.maximum,R=r.subtract(T,w,l),v=n-t,g=Math.max(r.maximumComponent(R),v);_=m-1>g?s.BITS12:s.NONE,_=s.NONE,y=e.center,E=u.inverseTransformation(o,new u);var A=r.negate(w,f);u.multiply(u.fromTranslation(A,h),E,E);var b=f;b.x=1/R.x,b.y=1/R.y,b.z=1/R.z,u.multiply(u.fromScale(b,h),E,E),O=u.clone(o),u.setTranslation(O,r.ZERO,O),o=u.clone(o,new u);var S=u.fromTranslation(w,h),N=u.fromScale(R,p),I=u.multiply(S,N,h);u.multiply(o,I,o),u.multiply(O,I,O)}this.quantization=_,this.minimumHeight=t,this.maximumHeight=n,this.center=y,this.toScaledENU=E,this.fromScaledENU=o,this.matrix=O,this.hasVertexNormals=c,this.hasWebMercatorT=i(d,!1)}var f=new r,l=new r,d=new t,h=new u,p=new u,m=Math.pow(2,12);c.prototype.encode=function(n,i,a,c,l,h,p){var m=c.x,y=c.y;if(this.quantization===s.BITS12){a=u.multiplyByPoint(this.toScaledENU,a,f),a.x=o.clamp(a.x,0,1),a.y=o.clamp(a.y,0,1),a.z=o.clamp(a.z,0,1);var E=this.maximumHeight-this.minimumHeight,O=o.clamp((l-this.minimumHeight)/E,0,1);t.fromElements(a.x,a.y,d);var _=e.compressTextureCoordinates(d);t.fromElements(a.z,O,d);var w=e.compressTextureCoordinates(d);t.fromElements(m,y,d);var T=e.compressTextureCoordinates(d);if(n[i++]=_,n[i++]=w,n[i++]=T,this.hasWebMercatorT){t.fromElements(p,0,d);var R=e.compressTextureCoordinates(d);n[i++]=R}}else r.subtract(a,this.center,f),n[i++]=f.x,n[i++]=f.y,n[i++]=f.z,n[i++]=l,n[i++]=m,n[i++]=y,this.hasWebMercatorT&&(n[i++]=p);return this.hasVertexNormals&&(n[i++]=e.octPackFloat(h)),i},c.prototype.decodePosition=function(t,n,i){if(a(i)||(i=new r),n*=this.getStride(),this.quantization===s.BITS12){var o=e.decompressTextureCoordinates(t[n],d);i.x=o.x,i.y=o.y;var c=e.decompressTextureCoordinates(t[n+1],d);return i.z=c.x,u.multiplyByPoint(this.fromScaledENU,i,i)}return i.x=t[n],i.y=t[n+1],i.z=t[n+2],r.add(i,this.center,i)},c.prototype.decodeTextureCoordinates=function(r,n,i){return a(i)||(i=new t),n*=this.getStride(),this.quantization===s.BITS12?e.decompressTextureCoordinates(r[n+2],i):t.fromElements(r[n+4],r[n+5],i)},c.prototype.decodeHeight=function(t,r){if(r*=this.getStride(),this.quantization===s.BITS12){var n=e.decompressTextureCoordinates(t[r+1],d);return n.y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight}return t[r+3]},c.prototype.decodeWebMercatorT=function(t,r){return r*=this.getStride(),this.quantization===s.BITS12?e.decompressTextureCoordinates(t[r+3],d).x:t[r+6]},c.prototype.getOctEncodedNormal=function(e,r,n){var i=this.getStride();r=(r+1)*i-1;var a=e[r]/256,o=Math.floor(a),u=256*(a-o);return t.fromElements(o,u,n)},c.prototype.getStride=function(){var e;switch(this.quantization){case s.BITS12:e=3;break;default:e=6}return this.hasWebMercatorT&&++e,this.hasVertexNormals&&++e,e};var y={position3DAndHeight:0,textureCoordAndEncodedNormals:1},E={compressed0:0,compressed1:1};return c.prototype.getAttributes=function(e){var t,r=n.FLOAT,i=n.getSizeInBytes(r);if(this.quantization===s.NONE){var a=4,o=2;return this.hasWebMercatorT&&++o,this.hasVertexNormals&&++o,t=(a+o)*i,[{index:y.position3DAndHeight,vertexBuffer:e,componentDatatype:r,componentsPerAttribute:a,offsetInBytes:0,strideInBytes:t},{index:y.textureCoordAndEncodedNormals,vertexBuffer:e,componentDatatype:r,componentsPerAttribute:o,offsetInBytes:a*i,strideInBytes:t}]}var u=3,c=0;return(this.hasWebMercatorT||this.hasVertexNormals)&&++u,this.hasWebMercatorT&&this.hasVertexNormals?(++c,t=(u+c)*i,[{index:E.compressed0,vertexBuffer:e,componentDatatype:r,componentsPerAttribute:u,offsetInBytes:0,strideInBytes:t},{index:E.compressed1,vertexBuffer:e,componentDatatype:r,componentsPerAttribute:c,offsetInBytes:u*i,strideInBytes:t}]):[{index:E.compressed0,vertexBuffer:e,componentDatatype:r,componentsPerAttribute:u}]},c.prototype.getAttributeLocations=function(){return this.quantization===s.NONE?y:E},c.clone=function(e,t){return a(t)||(t=new c),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=r.clone(e.center),t.toScaledENU=u.clone(e.toScaledENU),t.fromScaledENU=u.clone(e.fromScaledENU),t.matrix=u.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t},c}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,n=t.name,i=t.message;r=e(n)&&e(i)?n+": "+i:t.toString();var a=t.stack;return e(a)&&(r+="\n"+a),r}return t}),define("Workers/createTaskProcessorWorker",["../ThirdParty/when","../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r,n){"use strict";function i(t,r,n){var i;try{return i=t(r,n)}catch(a){return e.reject(a)}}function a(a){var o;return function(u){var s=u.data,c=[],f={id:s.id,result:void 0,error:void 0};return e(i(a,s.parameters,c)).then(function(e){f.result=e}).otherwise(function(e){e instanceof Error?f.error={name:e.name,message:e.message,stack:e.stack}:f.error=e}).always(function(){r(o)||(o=t(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(c.length=0);try{o(f,c)}catch(e){f.result=void 0,f.error="postMessage failed with error: "+n(e)+"\n  with responseMessage: "+JSON.stringify(f),o(f)}})}}return a}),define("Workers/upsampleQuantizedTerrainMesh",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/IndexDatatype","../Core/Intersections2D","../Core/Math","../Core/OrientedBoundingBox","../Core/TerrainEncoding","./createTaskProcessorWorker"],function(e,t,r,n,i,a,o,u,s,c,f,l,d,h){
"use strict";function p(e,r){var i=e.isEastChild,a=e.isNorthChild,h=i?_:0,p=i?O:_,y=a?_:0,q=a?O:_,D=A,L=b,B=S,F=I;D.length=0,L.length=0,B.length=0,F.length=0;var j=N;j.length=0;var z={},G=e.vertices,V=e.indices;V=V.subarray(0,e.skirtIndex);var W,X,H,k=d.clone(e.encoding),Y=k.hasVertexNormals,K=e.exaggeration,Z=0,J=e.vertexCountWithoutSkirts,Q=e.minimumHeight,$=e.maximumHeight,ee=new Array(J),te=new Array(J),re=new Array(J),ne=Y?new Array(2*J):void 0,ie=20;for(X=0,H=0;J>X;++X,H+=2){var ae=k.decodeTextureCoordinates(G,X,P);if(W=k.decodeHeight(G,X)/K,ee[X]=f.clamp(ae.x*O|0,0,O),te[X]=f.clamp(ae.y*O|0,0,O),re[X]=f.clamp((W-Q)/($-Q)*O|0,0,O),ee[X]<ie&&(ee[X]=0),te[X]<ie&&(te[X]=0),O-ee[X]<ie&&(ee[X]=O),O-te[X]<ie&&(te[X]=O),Y){var oe=k.getOctEncodedNormal(G,X,U);ne[H]=oe.x,ne[H+1]=oe.y}}var ue,se;for(X=0,H=0;J>X;++X,H+=2)ue=ee[X],se=te[X],(i&&ue>=_||!i&&_>=ue)&&(a&&se>=_||!a&&_>=se)&&(z[X]=Z,D.push(ue),L.push(se),B.push(re[X]),Y&&(F.push(ne[H]),F.push(ne[H+1])),++Z);var ce=[];ce.push(new m),ce.push(new m),ce.push(new m);var fe=[];fe.push(new m),fe.push(new m),fe.push(new m);var le,de;for(X=0;X<V.length;X+=3){var he=V[X],pe=V[X+1],me=V[X+2],ye=ee[he],Ee=ee[pe],Oe=ee[me];ce[0].initializeIndexed(ee,te,re,ne,he),ce[1].initializeIndexed(ee,te,re,ne,pe),ce[2].initializeIndexed(ee,te,re,ne,me);var _e=c.clipTriangleAtAxisAlignedThreshold(_,i,ye,Ee,Oe,w);le=0,le>=_e.length||(le=fe[0].initializeFromClipResult(_e,le,ce),le>=_e.length||(le=fe[1].initializeFromClipResult(_e,le,ce),le>=_e.length||(le=fe[2].initializeFromClipResult(_e,le,ce),de=c.clipTriangleAtAxisAlignedThreshold(_,a,fe[0].getV(),fe[1].getV(),fe[2].getV(),T),E(D,L,B,F,j,z,de,fe,Y),le<_e.length&&(fe[2].clone(fe[1]),fe[2].initializeFromClipResult(_e,le,ce),de=c.clipTriangleAtAxisAlignedThreshold(_,a,fe[0].getV(),fe[1].getV(),fe[2].getV(),T),E(D,L,B,F,j,z,de,fe,Y)))))}var we=i?-O:0,Te=a?-O:0,Re=[],ve=[],ge=[],Ae=[],be=Number.MAX_VALUE,Se=-be,Ne=R;Ne.length=0;var Ie=o.clone(e.ellipsoid),xe=e.childRectangle,Me=xe.north,Ce=xe.south,Pe=xe.east,Ue=xe.west;for(Ue>Pe&&(Pe+=f.TWO_PI),X=0;X<D.length;++X)ue=Math.round(D[X]),h>=ue?(Re.push(X),ue=0):ue>=p?(ge.push(X),ue=O):ue=2*ue+we,D[X]=ue,se=Math.round(L[X]),y>=se?(ve.push(X),se=0):se>=q?(Ae.push(X),se=O):se=2*se+Te,L[X]=se,W=f.lerp(Q,$,B[X]/O),be>W&&(be=W),W>Se&&(Se=W),B[X]=W,v.longitude=f.lerp(Ue,Pe,ue/O),v.latitude=f.lerp(Ce,Me,se/O),v.height=W,Ie.cartographicToCartesian(v,g),Ne.push(g.x),Ne.push(g.y),Ne.push(g.z);var qe=t.fromVertices(Ne,n.ZERO,3,M),De=l.fromRectangle(xe,be,Se,Ie,C),Le=new u(Ie),Be=Le.computeHorizonCullingPointFromVertices(qe.center,Ne,3,qe.center,x),Fe=Se-be,je=new Uint16Array(D.length+L.length+B.length);for(X=0;X<D.length;++X)je[X]=D[X];var ze=D.length;for(X=0;X<L.length;++X)je[ze+X]=L[X];for(ze+=L.length,X=0;X<B.length;++X)je[ze+X]=O*(B[X]-be)/Fe;var Ge,Ve=s.createTypedArray(D.length,j);if(Y){var We=new Uint8Array(F);r.push(je.buffer,Ve.buffer,We.buffer),Ge=We.buffer}else r.push(je.buffer,Ve.buffer);return{vertices:je.buffer,encodedNormals:Ge,indices:Ve.buffer,minimumHeight:be,maximumHeight:Se,westIndices:Re,southIndices:ve,eastIndices:ge,northIndices:Ae,boundingSphere:qe,orientedBoundingBox:De,horizonOcclusionPoint:Be}}function m(){this.vertexBuffer=void 0,this.index=void 0,this.first=void 0,this.second=void 0,this.ratio=void 0}function y(t,r){++D;var i=L[D],a=B[D];return i=e.octDecode(t.first.getNormalX(),t.first.getNormalY(),i),a=e.octDecode(t.second.getNormalX(),t.second.getNormalY(),a),g=n.lerp(i,a,t.ratio,g),n.normalize(g,g),e.octEncode(g,r),--D,r}function E(e,t,r,n,i,o,u,s,c){if(0!==u.length){for(var f=0,l=0;l<u.length;)l=F[f++].initializeFromClipResult(u,l,s);for(var d=0;f>d;++d){var h=F[d];if(h.isIndexed())h.newIndex=o[h.index],h.uBuffer=e,h.vBuffer=t,h.heightBuffer=r,c&&(h.normalBuffer=n);else{var p=h.getKey();if(a(o[p]))h.newIndex=o[p];else{var m=e.length;e.push(h.getU()),t.push(h.getV()),r.push(h.getH()),c&&(n.push(h.getNormalX()),n.push(h.getNormalY())),h.newIndex=m,o[p]=m}}}3===f?(i.push(F[0].newIndex),i.push(F[1].newIndex),i.push(F[2].newIndex)):4===f&&(i.push(F[0].newIndex),i.push(F[1].newIndex),i.push(F[2].newIndex),i.push(F[0].newIndex),i.push(F[2].newIndex),i.push(F[3].newIndex))}}var O=32767,_=O/2|0,w=[],T=[],R=[],v=new i,g=new n,A=[],b=[],S=[],N=[],I=[],x=new n,M=new t,C=new l,P=new r,U=new n;m.prototype.clone=function(e){return a(e)||(e=new m),e.uBuffer=this.uBuffer,e.vBuffer=this.vBuffer,e.heightBuffer=this.heightBuffer,e.normalBuffer=this.normalBuffer,e.index=this.index,e.first=this.first,e.second=this.second,e.ratio=this.ratio,e},m.prototype.initializeIndexed=function(e,t,r,n,i){this.uBuffer=e,this.vBuffer=t,this.heightBuffer=r,this.normalBuffer=n,this.index=i,this.first=void 0,this.second=void 0,this.ratio=void 0},m.prototype.initializeFromClipResult=function(e,t,r){var n=t+1;return-1!==e[t]?r[e[t]].clone(this):(this.vertexBuffer=void 0,this.index=void 0,this.first=r[e[n]],++n,this.second=r[e[n]],++n,this.ratio=e[n],++n),n},m.prototype.getKey=function(){return this.isIndexed()?this.index:JSON.stringify({first:this.first.getKey(),second:this.second.getKey(),ratio:this.ratio})},m.prototype.isIndexed=function(){return a(this.index)},m.prototype.getH=function(){return a(this.index)?this.heightBuffer[this.index]:f.lerp(this.first.getH(),this.second.getH(),this.ratio)},m.prototype.getU=function(){return a(this.index)?this.uBuffer[this.index]:f.lerp(this.first.getU(),this.second.getU(),this.ratio)},m.prototype.getV=function(){return a(this.index)?this.vBuffer[this.index]:f.lerp(this.first.getV(),this.second.getV(),this.ratio)};var q=new r,D=-1,L=[new n,new n],B=[new n,new n];m.prototype.getNormalX=function(){return a(this.index)?this.normalBuffer[2*this.index]:(q=y(this,q),q.x)},m.prototype.getNormalY=function(){return a(this.index)?this.normalBuffer[2*this.index+1]:(q=y(this,q),q.y)};var F=[];return F.push(new m),F.push(new m),F.push(new m),F.push(new m),h(p)})}();