/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var o={};return o.typeOf={},o.defined=function(n,o){if(!e(o))throw new t(r(n))},o.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},o.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},o.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},o.typeOf.number.lessThan=function(e,r,n){if(o.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},o.typeOf.number.lessThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},o.typeOf.number.greaterThan=function(e,r,n){if(o.typeOf.number(e,r),n>=r)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},o.typeOf.number.greaterThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),n>r)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},o.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},o.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},o.typeOf.number.equals=function(e,r,n,i){if(o.typeOf.number(e,n),o.typeOf.number(r,i),n!==i)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+i)},o}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,o){"use strict";var i={};i.Radius=6378137,i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.EPSILON21=1e-21,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*i.clamp(e,-1,1)+.5)*t)},i.fromSNorm=function(e,t){return t=r(t,255),i.clamp(e,0,t)/t*2-1},i.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),i.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=Math.PI/2,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI/2,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!n(e))throw new o("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!n(e))throw new o("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!n(e))throw new o("angle is required.");var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.clampToLatitudeRange=function(e){if(!n(e))throw new o("angle is required.");return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){if(!n(e))throw new o("angle is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!n(e))throw new o("angle is required.");var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){if(!n(e))throw new o("m is required.");if(!n(t))throw new o("n is required.");return(e%t+t)%t},i.equalsEpsilon=function(e,t,i,a){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");if(!n(i))throw new o("relativeEpsilon is required.");a=r(a,i);var u=Math.abs(e-t);return a>=u||u<=i*Math.max(Math.abs(e),Math.abs(t))},i.lessThan=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return-r>e-t},i.lessThanOrEquals=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return r>e-t},i.greaterThan=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return e-t>r},i.greaterThanOrEquals=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return e-t>-r};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new o("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],n=t;e>=n;n++)a.push(r*n);return a[e]},i.incrementWrap=function(e,t,i){if(i=r(i,0),!n(e))throw new o("n is required.");if(i>=t)throw new o("maximumValue must be greater than minimumValue.");return++e,e>t&&(e=i),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new o("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new o("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,r){if(!n(e))throw new o("value is required");if(!n(t))throw new o("min is required.");if(!n(r))throw new o("max is required.");return t>e?t:e>r?r:e};var u=new e;return i.setRandomNumberSeed=function(t){if(!n(t))throw new o("seed is required.");u=new e(t)},i.nextRandomNumber=function(){return u.random()},i.randomBetween=function(e,t){return i.nextRandomNumber()*(t-e)+e},i.acosClamped=function(e){if(!n(e))throw new o("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!n(e))throw new o("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){if(!n(e))throw new o("angle is required.");if(!n(t))throw new o("radius is required.");return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){if(!n(e))throw new o("number is required.");if(!n(t))throw new o("base is required.");return Math.log(e)/Math.log(t)},i.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return 0>e?-t:t}),i.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),i.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},i.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},i.fastApproximateAtan2=function(e,r){t.typeOf.number("x",e),t.typeOf.number("y",r);var n,a,u=Math.abs(e);n=Math.abs(r),a=Math.max(u,n),n=Math.min(u,n);var s=n/a;if(isNaN(s))throw new o("either x or y must be nonzero");return u=i.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?i.PI_OVER_TWO-u:u,u=0>e?i.PI-u:u,u=0>r?-u:u},i}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,r){this.x=t(e,0),this.y=t(r,0)}a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o]=r.y,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=2*o:n=new Array(2*o);for(var i=0;o>i;++i)a.pack(t[i],n,2*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/2:n=new Array(o/2);for(var i=0;o>i;i+=2){var u=i/2;n[u]=a.unpack(t,i,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,s),o=a.multiplyByScalar(t,1-n,o),a.add(s,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f),i.acosClamped(a.dot(c,f))};var l=new a;return a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Y,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},a.ZERO=o(new a(0,0)),a.UNIT_X=o(new a(1,0)),a.UNIT_Y=o(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}a.fromSpherical=function(n,o){e.typeOf.object("spherical",n),r(o)||(o=new a);var i=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return o.x=c*Math.cos(i),o.y=c*Math.sin(i),o.z=s*Math.cos(u),o},a.fromElements=function(e,t,n,o){return r(o)?(o.x=e,o.y=t,o.z=n,o):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o]=r.z,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=3*o:n=new Array(3*o);for(var i=0;o>i;++i)a.pack(t[i],n,3*i);return n},a.unpackArray=function(t,o){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var i=t.length;r(o)?o.length=i/3:o=new Array(i/3);for(var u=0;i>u;u+=3){var s=u/3;o[s]=a.unpack(t,u,o[s])}return o},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,s),o=a.multiplyByScalar(t,1-n,o),a.add(s,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f);var n=a.dot(c,f),o=a.magnitude(a.cross(c,f,c));return Math.atan2(o,n)};var l=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Z,r):n.y<=n.z?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_Z,r)},a.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var o=a.dot(t,r)/a.dot(r,r);return a.multiplyByScalar(r,o,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},a.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=r.x,s=r.y,c=r.z,f=i*c-a*s,l=a*u-o*c,d=o*s-i*u;return n.x=f,n.y=l,n.z=d,n},a.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},a.fromDegrees=function(t,r,n,o,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=i.toRadians(t),r=i.toRadians(r),a.fromRadians(t,r,n,o,u)};var d=new a,h=new a,p=new a(40680631590769,40680631590769,40408299984661.445),m=new a(40680631590769,40680631590769,40680631590769);return a.fromRadians=function(n,o,u,s,c){e.typeOf.number("longitude",n),e.typeOf.number("latitude",o),u=t(u,0);var f=r(s)?s.radiiSquared:m;i.equalsEpsilon(i.Radius,6356752.314245179,i.EPSILON10)&&(f=r(s)?s.radiiSquared:p);var l=Math.cos(o);d.x=l*Math.cos(n),d.y=l*Math.sin(n),d.z=Math.sin(o),d=a.normalize(d,d),a.multiplyComponents(f,d,h);var y=Math.sqrt(a.dot(d,h));return h=a.divideByScalar(h,y,h),d=a.multiplyByScalar(d,u,d),r(c)||(c=new a),a.add(h,d,c)},a.fromDegreesArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(i)?i.length=u/2:i=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;i[l]=a.fromDegrees(c,f,0,o,i[l])}return i},a.fromRadiansArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(i)?i.length=u/2:i=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;i[l]=a.fromRadians(c,f,0,o,i[l])}return i},a.fromDegreesArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(i)?i.length=u/3:i=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],d=s/3;i[d]=a.fromDegrees(c,f,l,o,i[d])}return i},a.fromRadiansArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(i)?i.length=u/3:i=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],d=s/3;i[d]=a.fromRadians(c,f,l,o,i[d])}return i},a.ZERO=o(new a(0,0,0)),a.UNIT_X=o(new a(1,0,0)),a.UNIT_Y=o(new a(0,1,0)),a.UNIT_Z=o(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],function(e,t,r,n,o,i){"use strict";function a(e){return d[0]=e,d[0]}function u(e){return e>>1^-(1&e)}var s=1/256,c=256,f={};f.octEncodeInRange=function(e,n,a){r.defined("vector",e),r.defined("result",a);var u=t.magnitudeSquared(e);if(Math.abs(u-1)>i.EPSILON6)throw new o("vector must be normalized.");if(a.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),a.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=a.x,c=a.y;a.x=(1-Math.abs(c))*i.signNotZero(s),a.y=(1-Math.abs(s))*i.signNotZero(c)}return a.x=i.toSNorm(a.x,n),a.y=i.toSNorm(a.y,n),a},f.octEncode=function(e,t){return f.octEncodeInRange(e,255,t)};var l=new e,d=new Uint8Array(1);f.octEncodeToCartesian4=function(e,t){return f.octEncodeInRange(e,65535,l),t.x=a(l.x*s),t.y=a(l.x),t.z=a(l.y*s),t.w=a(l.y),t},f.octDecodeInRange=function(e,n,a,u){if(r.defined("result",u),0>e||e>a||0>n||n>a)throw new o("x and y must be unsigned normalized integers between 0 and "+a);if(u.x=i.fromSNorm(e,a),u.y=i.fromSNorm(n,a),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*i.signNotZero(s),u.y=(1-Math.abs(s))*i.signNotZero(u.y)}return t.normalize(u,u)},f.octDecode=function(e,t,r){return f.octDecodeInRange(e,t,255,r)},f.octDecodeFromCartesian4=function(e,t){r.typeOf.object("encoded",e),r.typeOf.object("result",t);var n=e.x,i=e.y,a=e.z,u=e.w;if(0>n||n>255||0>i||i>255||0>a||a>255||0>u||u>255)throw new o("x, y, z, and w must be unsigned normalized integers between 0 and 255");var s=n*c+i,l=a*c+u;return f.octDecodeInRange(s,l,65535,t)},f.octPackFloat=function(e){return r.defined("encoded",e),256*e.x+e.y};var h=new e;return f.octEncodeFloat=function(e){return f.octEncode(e,h),f.octPackFloat(h)},f.octDecodeFloat=function(e,t){r.defined("value",e);var n=e/256,o=Math.floor(n),i=256*(n-o);return f.octDecode(o,i,t)},f.octPack=function(e,t,n,o){r.defined("v1",e),r.defined("v2",t),r.defined("v3",n),r.defined("result",o);var i=f.octEncodeFloat(e),a=f.octEncodeFloat(t),u=f.octEncode(n,h);return o.x=65536*u.x+i,o.y=65536*u.y+a,o},f.octUnpack=function(e,t,n,o){r.defined("packed",e),r.defined("v1",t),r.defined("v2",n),r.defined("v3",o);var i=e.x/65536,a=Math.floor(i),u=65536*(i-a);i=e.y/65536;var s=Math.floor(i),c=65536*(i-s);f.octDecodeFloat(u,t),f.octDecodeFloat(c,n),f.octDecode(a,s,o)},f.compressTextureCoordinates=function(e){r.defined("textureCoordinates",e);var t=4095*e.x|0,n=4095*e.y|0;return 4096*t+n},f.decompressTextureCoordinates=function(e,t){r.defined("compressed",e),r.defined("result",t);var n=e/4096,o=Math.floor(n);return t.x=o/4095,t.y=(e-4096*o)/4095,t},f.zigZagDeltaDecode=function(e,t,o){r.defined("uBuffer",e),r.defined("vBuffer",t),r.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),n(o)&&r.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,o.length);for(var i=e.length,a=0,s=0,c=0,f=0;i>f;++f)a+=u(e[f]),s+=u(t[f]),e[f]=a,t[f]=s,n(o)&&(c+=u(o[f]),o[f]=c)},f.octShortToFloat=function(e){return i.clamp(3051850947599719e-20*e,-1,1)},f.octShortDecode=function(e,n,o){if(r.defined("result",o),o.x=f.octShortToFloat(e),o.y=f.octShortToFloat(n),o.z=1-(Math.abs(o.x)+Math.abs(o.y)),o.z<0){var a=o.x;o.x=(1-Math.abs(o.y))*i.signNotZero(a),o.y=(1-Math.abs(a))*i.signNotZero(o.y)}return t.normalize(o,o)},f}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function o(o,u,s,c,f){if(!t(o))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=o.x,d=o.y,h=o.z,p=u.x,m=u.y,y=u.z,E=l*l*p*p,O=d*d*m*m,_=h*h*y*y,R=E+O+_,w=Math.sqrt(1/R),g=e.multiplyByScalar(o,w,i);if(c>R)return isFinite(w)?e.clone(g,f):void 0;var T=s.x,A=s.y,b=s.z,C=a;C.x=g.x*T*2,C.y=g.y*A*2,C.z=g.z*b*2;var v,S,I,N,M,x,P,D,F,U,q,L=(1-w)*e.magnitude(o)/(.5*e.magnitude(C)),B=0;do{L-=B,I=1/(1+L*T),N=1/(1+L*A),M=1/(1+L*b),x=I*I,P=N*N,D=M*M,F=x*I,U=P*N,q=D*M,v=E*x+O*P+_*D-1,S=E*F*T+O*U*A+_*q*b;var j=-2*S;B=v/j}while(Math.abs(v)>n.EPSILON12);return t(f)?(f.x=l*I,f.y=d*N,f.z=h*M,f):new e(l*I,d*N,h*M)}var i=new e,a=new e;return o}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,i,a){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,o,i,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",o),i=r(i,0),n(a)?(a.longitude=e,a.latitude=o,a.height=i,a):new u(e,o,i)},u.fromDegrees=function(e,r,n,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=i.toRadians(e),r=i.toRadians(r),u.fromRadians(e,r,n,o)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/6378137,1/6378137,1/6378137),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),p=new e(1/40680631590769,1/40680631590769,1/40680631590769),m=i.EPSILON1;return u.fromCartesian=function(t,r,o){var y=n(r)?r.oneOverRadii:d,E=n(r)?r.oneOverRadiiSquared:p,O=n(r)?r._centerToleranceSquared:m;i.equalsEpsilon(i.Radius,6356752.314245179,i.EPSILON10)&&(y=n(r)?r.oneOverRadii:l,E=n(r)?r.oneOverRadiiSquared:h);var _=a(t,y,E,O,c);if(n(_)){var R=e.multiplyComponents(_,E,s);R=e.normalize(R,R);var w=e.subtract(t,_,f),g=Math.atan2(R.y,R.x),T=Math.asin(R.z),A=i.sign(e.dot(w,t))*e.magnitude(w);return n(o)?(o.longitude=g,o.latitude=T,o.height=A,o):new u(g,T,A)}},u.toCartesian=function(r,n,o){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,o)},u.sphericalDistance=function(e,r,n,o){if(t.defined("longitudeA",e),t.defined("longitudeB",n),t.defined("latitudeA",r),t.defined("latitudeB",o),e===n&&r===o)return 0;var a=i.toRadians(r),u=i.toRadians(o),s=i.toRadians(e),c=i.toRadians(n),f=s*s+a*a,l=c*c+u*u,d=(s-c)*(s-c)+(a-u)*(a-u),h=(f+l-d)/(2*Math.sqrt(f)*Math.sqrt(l));return h=i.clamp(h,-1,1),Math.acos(h)*i.Radius},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=o&&Math.abs(e.latitude-r.latitude)<=o&&Math.abs(e.height-r.height)<=o},u.ZERO=o(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,u=i.length;u>a;++a){var s=i[a];o=s+"RequestFullscreen","function"==typeof t[o]?(n.requestFullscreen=o,r=!0):(o=s+"RequestFullScreen","function"==typeof t[o]&&(n.requestFullscreen=o,r=!0)),o=s+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=s+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=s+"FullscreenEnabled",void 0!==document[o]?n.fullscreenEnabled=o:(o=s+"FullScreenEnabled",void 0!==document[o]&&(n.fullscreenEnabled=o)),o=s+"FullscreenElement",void 0!==document[o]?n.fullscreenElement=o:(o=s+"FullScreenElement",void 0!==document[o]&&(n.fullscreenElement=o)),o=s+"fullscreenchange",void 0!==document["on"+o]&&("ms"===s&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=s+"fullscreenerror",void 0!==document["on"+o]&&("ms"===s&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e,t){o.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,o){return t(e).then(r,n,o)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=o(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function o(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return i(n)}});return r}function i(e){var r=new n(function(r,n){try{return n?t(n(e)):i(e)}catch(o){return i(o)}});return r}function a(){function e(e,t,r){return d(e,t,r)}function r(e){return p(e)}function o(e){return p(i(e))}function u(e){return h(e)}var s,c,f,l,d,h,p;return c=new n(e),s={then:e,resolve:r,reject:o,progress:u,promise:c,resolver:{resolve:r,reject:o,progress:u}},f=[],l=[],d=function(e,t,r){var n,o;return n=a(),o="function"==typeof r?function(e){try{
n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},f.push(function(r){r.then(e,t).then(n.resolve,n.reject,o)}),l.push(o),n.promise},h=function(e){return m(l,e),e},p=function(e){return e=t(e),d=e.then,p=t,h=E,m(f,e),l=f=w,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,o,i){return y(2,arguments),e(t,function(t){function u(e){m(e)}function s(e){p(e)}var c,f,l,d,h,p,m,y,O,_;if(O=t.length>>>0,c=Math.max(0,Math.min(r,O)),l=[],f=O-c+1,d=[],h=a(),c)for(y=h.progress,m=function(e){d.push(e),--f||(p=m=E,h.reject(d))},p=function(e){l.push(e),--c||(p=m=E,h.resolve(l))},_=0;O>_;++_)_ in t&&e(t[_],s,u,y);else h.resolve(l);return h.then(n,o,i)})}function c(e,t,r,n){function o(e){return t?t(e[0]):e[0]}return s(e,1,o,r,n)}function f(e,t,r,n){return y(1,arguments),d(e,O).then(t,r,n)}function l(){return d(arguments,O)}function d(t,r){return e(t,function(t){var n,o,i,u,s,c;if(i=o=t.length>>>0,n=[],c=a(),i)for(u=function(t,o){e(t,r).then(function(e){n[o]=e,--i||c.resolve(n)},c.reject)},s=0;o>s;s++)s in t?u(t[s],s):--i;else c.resolve(n);return c.promise})}function h(t,r){var n=R.call(arguments,1);return e(t,function(t){var o;return o=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,o)})})},_.apply(t,n)})}function p(t,r,n){var o=arguments.length>2;return e(t,function(e){return e=o?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function m(e,t){for(var r,n=0;r=e[n++];)r(t)}function y(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function E(){}function O(e){return e}var _,R,w;return e.defer=a,e.resolve=t,e.reject=r,e.join=l,e.all=f,e.map=d,e.reduce=h,e.any=c,e.some=s,e.chain=p,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(w,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return f(t,function(t){return e.apply(w,t)})})}},R=[].slice,_=[].reduce||function(e){var t,r,n,o,i;if(i=0,t=Object(this),o=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=o)throw new TypeError}else n=r[1];for(;o>i;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen","./RuntimeError","../ThirdParty/when"],function(e,t,r,n,o){"use strict";function i(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(v)&&(v=!1,!p())){var e=/ Chrome\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(v=!0,S=i(e[1]))}return v}function u(){return a()&&S}function s(){if(!t(I)&&(I=!1,!a()&&!p()&&/ Safari\/[\.0-9]+/.test(C.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(I=!0,N=i(e[1]))}return I}function c(){return s()&&N}function f(){if(!t(M)){M=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(C.userAgent);null!==e&&(M=!0,x=i(e[1]),x.isNightly=!!e[2])}return M}function l(){return f()&&x}function d(){if(!t(P)){P=!1;var e;"Microsoft Internet Explorer"===C.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(C.userAgent),null!==e&&(P=!0,D=i(e[1]))):"Netscape"===C.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(C.userAgent),null!==e&&(P=!0,D=i(e[1])))}return P}function h(){return d()&&D}function p(){if(!t(F)){F=!1;var e=/ Edge\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(F=!0,U=i(e[1]))}return F}function m(){return p()&&U}function y(){if(!t(q)){q=!1;var e=/Firefox\/([\.0-9]+)/.exec(C.userAgent);null!==e&&(q=!0,L=i(e[1]))}return q}function E(){return t(B)||(B=/Windows/i.test(C.appVersion)),B}function O(){return y()&&L}function _(){return t(j)||(j="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),j}function R(){return t(z)||(z=!y()&&"undefined"!=typeof PointerEvent&&(!t(C.pointerEnabled)||C.pointerEnabled)),z}function w(){if(!t(V)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;V=t(r)&&""!==r,V&&(G=r)}return V}function g(){return w()?G:void 0}function T(){if(t(X))return X.promise;X=o.defer(),p()&&(W=!1,X.resolve(W));var e=new Image;return e.onload=function(){W=e.width>0&&e.height>0,X.resolve(W)},e.onerror=function(){W=!1,X.resolve(W)},e.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",X.promise}function A(){return t(X)||T(),W}function b(){var e=window.navigator.userAgent.toLowerCase(),t="ipad"==e.match(/ipad/i),r="iphone os"==e.match(/iphone os/i),n="midp"==e.match(/midp/i),o="rv:1.2.3.4"==e.match(/rv:1.2.3.4/i),i="ucweb"==e.match(/ucweb/i),a="android"==e.match(/android/i),u="windows ce"==e.match(/windows ce/i),s="windows mobile"==e.match(/windows mobile/i);return t||r||n||o||i||a||u||s?!1:!0}var C;C="undefined"!=typeof navigator?navigator:{};var v,S,I,N,M,x,P,D,F,U,q,L,B,j,z,G,V,W,X,k=[];"undefined"!=typeof ArrayBuffer&&(k.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&k.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&k.push(CanvasPixelArray));var H={isChrome:a,chromeVersion:u,isSafari:s,safariVersion:c,isWebkit:f,webkitVersion:l,isInternetExplorer:d,internetExplorerVersion:h,isEdge:p,edgeVersion:m,isFirefox:y,firefoxVersion:O,isWindows:E,isNodeJs:_,hardwareConcurrency:e(C.hardwareConcurrency,3),supportsPointerEvents:R,supportsImageRenderingPixelated:w,supportsWebP:T,supportsWebPSync:A,imageRenderingValue:g,typedArrayTypes:k,isPCBroswer:b};return H.supportsFullscreen=function(){return r.supportsFullscreen()},H.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},H.supportsWebWorkers=function(){return"undefined"!=typeof Worker},H.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!H.isEdge()},H}),define("Core/Color",["./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+(t-e)*(2/3-r)*6:e}function u(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)}u.fromCartesian4=function(t,n){return e.typeOf.object("cartesian",t),r(n)?(n.red=t.x,n.green=t.y,n.blue=t.z,n.alpha=t.w,n):new u(t.x,t.y,t.z,t.w)},u.fromBytes=function(e,n,o,i,a){return e=u.byteToFloat(t(e,255)),n=u.byteToFloat(t(n,255)),o=u.byteToFloat(t(o,255)),i=u.byteToFloat(t(i,255)),r(a)?(a.red=e,a.green=n,a.blue=o,a.alpha=i,a):new u(e,n,o,i)},u.fromAlpha=function(t,n,o){return e.typeOf.object("color",t),e.typeOf.number("alpha",n),r(o)?(o.red=t.red,o.green=t.green,o.blue=t.blue,o.alpha=n,o):new u(t.red,t.green,t.blue,n)};var s,c,f;n.supportsTypedArrays()&&(s=new ArrayBuffer(4),c=new Uint32Array(s),f=new Uint8Array(s)),u.fromRgba=function(e,t){return c[0]=e,u.fromBytes(f[0],f[1],f[2],f[3],t)},u.fromHsl=function(e,n,o,i,s){e=t(e,0)%1,n=t(n,0),o=t(o,0),i=t(i,1);var c=o,f=o,l=o;if(0!==n){var d;d=.5>o?o*(1+n):o+n-o*n;var h=2*o-d;c=a(h,d,e+1/3),f=a(h,d,e),l=a(h,d,e-1/3)}return r(s)?(s.red=c,s.green=f,s.blue=l,s.alpha=i,s):new u(c,f,l,i)},u.fromRandom=function(n,o){n=t(n,t.EMPTY_OBJECT);var a=n.red;if(!r(a)){var s=t(n.minimumRed,0),c=t(n.maximumRed,1);e.typeOf.number.lessThanOrEquals("minimumRed",s,c),a=s+i.nextRandomNumber()*(c-s)}var f=n.green;if(!r(f)){var l=t(n.minimumGreen,0),d=t(n.maximumGreen,1);e.typeOf.number.lessThanOrEquals("minimumGreen",l,d),f=l+i.nextRandomNumber()*(d-l)}var h=n.blue;if(!r(h)){var p=t(n.minimumBlue,0),m=t(n.maximumBlue,1);e.typeOf.number.lessThanOrEquals("minimumBlue",p,m),h=p+i.nextRandomNumber()*(m-p)}var y=n.alpha;if(!r(y)){var E=t(n.minimumAlpha,0),O=t(n.maximumAlpha,1);e.typeOf.number.lessThanOrEquals("minumumAlpha",E,O),y=E+i.nextRandomNumber()*(O-E)}return r(o)?(o.red=a,o.green=f,o.blue=h,o.alpha=y,o):new u(a,f,h,y)};var l=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,d=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,h=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,p=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return u.fromCssColorString=function(n,o){e.typeOf.string("color",n),r(o)||(o=new u);var i=u[n.toUpperCase()];if(r(i))return u.clone(i,o),o;var a=l.exec(n);return null!==a?(o.red=parseInt(a[1],16)/15,o.green=parseInt(a[2],16)/15,o.blue=parseInt(a[3],16)/15,o.alpha=1,o):(a=d.exec(n),null!==a?(o.red=parseInt(a[1],16)/255,o.green=parseInt(a[2],16)/255,o.blue=parseInt(a[3],16)/255,o.alpha=1,o):(a=h.exec(n),null!==a?(o.red=parseFloat(a[1])/("%"===a[1].substr(-1)?100:255),o.green=parseFloat(a[2])/("%"===a[2].substr(-1)?100:255),o.blue=parseFloat(a[3])/("%"===a[3].substr(-1)?100:255),o.alpha=parseFloat(t(a[4],"1.0")),o):(a=p.exec(n),null!==a?u.fromHsl(parseFloat(a[1])/360,parseFloat(a[2])/100,parseFloat(a[3])/100,parseFloat(t(a[4],"1.0")),o):o=void 0)))},u.packedLength=4,u.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.red,n[o++]=r.green,n[o++]=r.blue,n[o]=r.alpha,n},u.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new u),i.red=n[o++],i.green=n[o++],i.blue=n[o++],i.alpha=n[o],i},u.byteToFloat=function(e){return e/255},u.floatToByte=function(e){return 1===e?255:256*e|0},u.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new u(e.red,e.green,e.blue,e.alpha):void 0},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},u.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},u.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},u.prototype.toCssColorString=function(){var e=u.floatToByte(this.red),t=u.floatToByte(this.green),r=u.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},u.prototype.toBytes=function(e){var t=u.floatToByte(this.red),n=u.floatToByte(this.green),o=u.floatToByte(this.blue),i=u.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=o,e[3]=i,e):[t,n,o,i]},u.prototype.toRgba=function(){return f[0]=u.floatToByte(this.red),f[1]=u.floatToByte(this.green),f[2]=u.floatToByte(this.blue),f[3]=u.floatToByte(this.alpha),c[0]},u.prototype.brighten=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=1-(1-this.red)*t,r.green=1-(1-this.green)*t,r.blue=1-(1-this.blue)*t,r.alpha=this.alpha,r},u.prototype.darken=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=this.red*t,r.green=this.green*t,r.blue=this.blue*t,r.alpha=this.alpha,r},u.prototype.withAlpha=function(e,t){return u.fromAlpha(this,e,t)},u.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red+r.red,n.green=t.green+r.green,n.blue=t.blue+r.blue,n.alpha=t.alpha+r.alpha,n},u.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red-r.red,n.green=t.green-r.green,n.blue=t.blue-r.blue,n.alpha=t.alpha-r.alpha,n},u.multiply=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red*r.red,n.green=t.green*r.green,n.blue=t.blue*r.blue,n.alpha=t.alpha*r.alpha,n},u.divide=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red/r.red,n.green=t.green/r.green,n.blue=t.blue/r.blue,n.alpha=t.alpha/r.alpha,n},u.mod=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red%r.red,n.green=t.green%r.green,n.blue=t.blue%r.blue,n.alpha=t.alpha%r.alpha,n},u.multiplyByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red*r,n.green=t.green*r,n.blue=t.blue*r,n.alpha=t.alpha*r,n},u.divideByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red/r,n.green=t.green/r,n.blue=t.blue/r,n.alpha=t.alpha/r,n},u.ALICEBLUE=o(u.fromCssColorString("#F0F8FF")),u.ANTIQUEWHITE=o(u.fromCssColorString("#FAEBD7")),u.AQUA=o(u.fromCssColorString("#00FFFF")),u.AQUAMARINE=o(u.fromCssColorString("#7FFFD4")),u.AZURE=o(u.fromCssColorString("#F0FFFF")),u.BEIGE=o(u.fromCssColorString("#F5F5DC")),u.BISQUE=o(u.fromCssColorString("#FFE4C4")),u.BLACK=o(u.fromCssColorString("#000000")),u.BLANCHEDALMOND=o(u.fromCssColorString("#FFEBCD")),u.BLUE=o(u.fromCssColorString("#0000FF")),u.BLUEVIOLET=o(u.fromCssColorString("#8A2BE2")),u.BROWN=o(u.fromCssColorString("#A52A2A")),u.BURLYWOOD=o(u.fromCssColorString("#DEB887")),u.CADETBLUE=o(u.fromCssColorString("#5F9EA0")),u.CHARTREUSE=o(u.fromCssColorString("#7FFF00")),u.CHOCOLATE=o(u.fromCssColorString("#D2691E")),u.CORAL=o(u.fromCssColorString("#FF7F50")),u.CORNFLOWERBLUE=o(u.fromCssColorString("#6495ED")),u.CORNSILK=o(u.fromCssColorString("#FFF8DC")),u.CRIMSON=o(u.fromCssColorString("#DC143C")),u.CYAN=o(u.fromCssColorString("#00FFFF")),u.DARKBLUE=o(u.fromCssColorString("#00008B")),u.DARKCYAN=o(u.fromCssColorString("#008B8B")),u.DARKGOLDENROD=o(u.fromCssColorString("#B8860B")),u.DARKGRAY=o(u.fromCssColorString("#A9A9A9")),u.DARKGREEN=o(u.fromCssColorString("#006400")),u.DARKGREY=u.DARKGRAY,u.DARKKHAKI=o(u.fromCssColorString("#BDB76B")),u.DARKMAGENTA=o(u.fromCssColorString("#8B008B")),u.DARKOLIVEGREEN=o(u.fromCssColorString("#556B2F")),u.DARKORANGE=o(u.fromCssColorString("#FF8C00")),u.DARKORCHID=o(u.fromCssColorString("#9932CC")),u.DARKRED=o(u.fromCssColorString("#8B0000")),u.DARKSALMON=o(u.fromCssColorString("#E9967A")),u.DARKSEAGREEN=o(u.fromCssColorString("#8FBC8F")),u.DARKSLATEBLUE=o(u.fromCssColorString("#483D8B")),u.DARKSLATEGRAY=o(u.fromCssColorString("#2F4F4F")),u.DARKSLATEGREY=u.DARKSLATEGRAY,u.DARKTURQUOISE=o(u.fromCssColorString("#00CED1")),u.DARKVIOLET=o(u.fromCssColorString("#9400D3")),u.DEEPPINK=o(u.fromCssColorString("#FF1493")),u.DEEPSKYBLUE=o(u.fromCssColorString("#00BFFF")),u.DIMGRAY=o(u.fromCssColorString("#696969")),u.DIMGREY=u.DIMGRAY,u.DODGERBLUE=o(u.fromCssColorString("#1E90FF")),u.FIREBRICK=o(u.fromCssColorString("#B22222")),u.FLORALWHITE=o(u.fromCssColorString("#FFFAF0")),u.FORESTGREEN=o(u.fromCssColorString("#228B22")),u.FUCHSIA=o(u.fromCssColorString("#FF00FF")),u.GAINSBORO=o(u.fromCssColorString("#DCDCDC")),u.GHOSTWHITE=o(u.fromCssColorString("#F8F8FF")),u.GOLD=o(u.fromCssColorString("#FFD700")),u.GOLDENROD=o(u.fromCssColorString("#DAA520")),u.GRAY=o(u.fromCssColorString("#808080")),u.GREEN=o(u.fromCssColorString("#008000")),u.GREENYELLOW=o(u.fromCssColorString("#ADFF2F")),u.GREY=u.GRAY,u.HONEYDEW=o(u.fromCssColorString("#F0FFF0")),u.HOTPINK=o(u.fromCssColorString("#FF69B4")),u.INDIANRED=o(u.fromCssColorString("#CD5C5C")),u.INDIGO=o(u.fromCssColorString("#4B0082")),u.IVORY=o(u.fromCssColorString("#FFFFF0")),u.KHAKI=o(u.fromCssColorString("#F0E68C")),u.LAVENDER=o(u.fromCssColorString("#E6E6FA")),u.LAVENDAR_BLUSH=o(u.fromCssColorString("#FFF0F5")),u.LAWNGREEN=o(u.fromCssColorString("#7CFC00")),u.LEMONCHIFFON=o(u.fromCssColorString("#FFFACD")),u.LIGHTBLUE=o(u.fromCssColorString("#ADD8E6")),u.LIGHTCORAL=o(u.fromCssColorString("#F08080")),u.LIGHTCYAN=o(u.fromCssColorString("#E0FFFF")),u.LIGHTGOLDENRODYELLOW=o(u.fromCssColorString("#FAFAD2")),u.LIGHTGRAY=o(u.fromCssColorString("#D3D3D3")),u.LIGHTGREEN=o(u.fromCssColorString("#90EE90")),u.LIGHTGREY=u.LIGHTGRAY,u.LIGHTPINK=o(u.fromCssColorString("#FFB6C1")),u.LIGHTSEAGREEN=o(u.fromCssColorString("#20B2AA")),u.LIGHTSKYBLUE=o(u.fromCssColorString("#87CEFA")),u.LIGHTSLATEGRAY=o(u.fromCssColorString("#778899")),u.LIGHTSLATEGREY=u.LIGHTSLATEGRAY,u.LIGHTSTEELBLUE=o(u.fromCssColorString("#B0C4DE")),u.LIGHTYELLOW=o(u.fromCssColorString("#FFFFE0")),u.LIME=o(u.fromCssColorString("#00FF00")),u.LIMEGREEN=o(u.fromCssColorString("#32CD32")),u.LINEN=o(u.fromCssColorString("#FAF0E6")),u.MAGENTA=o(u.fromCssColorString("#FF00FF")),u.MAROON=o(u.fromCssColorString("#800000")),u.MEDIUMAQUAMARINE=o(u.fromCssColorString("#66CDAA")),u.MEDIUMBLUE=o(u.fromCssColorString("#0000CD")),u.MEDIUMORCHID=o(u.fromCssColorString("#BA55D3")),u.MEDIUMPURPLE=o(u.fromCssColorString("#9370DB")),u.MEDIUMSEAGREEN=o(u.fromCssColorString("#3CB371")),u.MEDIUMSLATEBLUE=o(u.fromCssColorString("#7B68EE")),u.MEDIUMSPRINGGREEN=o(u.fromCssColorString("#00FA9A")),u.MEDIUMTURQUOISE=o(u.fromCssColorString("#48D1CC")),u.MEDIUMVIOLETRED=o(u.fromCssColorString("#C71585")),u.MIDNIGHTBLUE=o(u.fromCssColorString("#191970")),u.MINTCREAM=o(u.fromCssColorString("#F5FFFA")),u.MISTYROSE=o(u.fromCssColorString("#FFE4E1")),u.MOCCASIN=o(u.fromCssColorString("#FFE4B5")),u.NAVAJOWHITE=o(u.fromCssColorString("#FFDEAD")),u.NAVY=o(u.fromCssColorString("#000080")),u.OLDLACE=o(u.fromCssColorString("#FDF5E6")),u.OLIVE=o(u.fromCssColorString("#808000")),u.OLIVEDRAB=o(u.fromCssColorString("#6B8E23")),u.ORANGE=o(u.fromCssColorString("#FFA500")),u.ORANGERED=o(u.fromCssColorString("#FF4500")),u.ORCHID=o(u.fromCssColorString("#DA70D6")),u.PALEGOLDENROD=o(u.fromCssColorString("#EEE8AA")),u.PALEGREEN=o(u.fromCssColorString("#98FB98")),u.PALETURQUOISE=o(u.fromCssColorString("#AFEEEE")),u.PALEVIOLETRED=o(u.fromCssColorString("#DB7093")),u.PAPAYAWHIP=o(u.fromCssColorString("#FFEFD5")),u.PEACHPUFF=o(u.fromCssColorString("#FFDAB9")),u.PERU=o(u.fromCssColorString("#CD853F")),u.PINK=o(u.fromCssColorString("#FFC0CB")),u.PLUM=o(u.fromCssColorString("#DDA0DD")),u.POWDERBLUE=o(u.fromCssColorString("#B0E0E6")),u.PURPLE=o(u.fromCssColorString("#800080")),u.RED=o(u.fromCssColorString("#FF0000")),u.ROSYBROWN=o(u.fromCssColorString("#BC8F8F")),u.ROYALBLUE=o(u.fromCssColorString("#4169E1")),u.SADDLEBROWN=o(u.fromCssColorString("#8B4513")),u.SALMON=o(u.fromCssColorString("#FA8072")),u.SANDYBROWN=o(u.fromCssColorString("#F4A460")),u.SEAGREEN=o(u.fromCssColorString("#2E8B57")),u.SEASHELL=o(u.fromCssColorString("#FFF5EE")),u.SIENNA=o(u.fromCssColorString("#A0522D")),u.SILVER=o(u.fromCssColorString("#C0C0C0")),u.SKYBLUE=o(u.fromCssColorString("#87CEEB")),u.SLATEBLUE=o(u.fromCssColorString("#6A5ACD")),u.SLATEGRAY=o(u.fromCssColorString("#708090")),u.SLATEGREY=u.SLATEGRAY,u.SNOW=o(u.fromCssColorString("#FFFAFA")),u.SPRINGGREEN=o(u.fromCssColorString("#00FF7F")),u.STEELBLUE=o(u.fromCssColorString("#4682B4")),u.TAN=o(u.fromCssColorString("#D2B48C")),u.TEAL=o(u.fromCssColorString("#008080")),u.THISTLE=o(u.fromCssColorString("#D8BFD8")),u.TOMATO=o(u.fromCssColorString("#FF6347")),u.TURQUOISE=o(u.fromCssColorString("#40E0D0")),u.VIOLET=o(u.fromCssColorString("#EE82EE")),u.WHEAT=o(u.fromCssColorString("#F5DEB3")),u.WHITE=o(u.fromCssColorString("#FFFFFF")),u.WHITESMOKE=o(u.fromCssColorString("#F5F5F5")),u.YELLOW=o(u.fromCssColorString("#FFFF00")),u.YELLOWGREEN=o(u.fromCssColorString("#9ACD32")),u.TRANSPARENT=o(new u(0,0,0,0)),u}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,i,a,u,s,c){"use strict";function f(t,o,i,a){o=n(o,0),i=n(i,0),a=n(a,0),r.typeOf.number.greaterThanOrEquals("x",o,0),r.typeOf.number.greaterThanOrEquals("y",i,0),r.typeOf.number.greaterThanOrEquals("z",a,0),s.equalsEpsilon(a,6356752.314245179,s.EPSILON10)&&(s.Radius=a),t._radii=new e(o,i,a),t._radiiSquared=new e(o*o,i*i,a*a),t._radiiToTheFourth=new e(o*o*o*o,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===o?0:1/o,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===o?0:1/(o*o),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(o,i,a),t._maximumRadius=Math.max(o,i,a),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(o(t)){var n=t._radii;return o(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return o(t)||(t=new l),o(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,s.Radius)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,o,i){return r.typeOf.object("value",t),r.defined("array",o),i=n(i,0),e.pack(t._radii,o,i),o},l.unpack=function(t,o,i){r.defined("array",t),o=n(o,0);var a=e.unpack(t,o);return l.fromCartesian3(a,i)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var i=t.longitude,a=t.latitude,u=Math.cos(a),s=u*Math.cos(i),c=u*Math.sin(i),f=Math.sin(a);return o(n)||(n=new e),n.x=s,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return o(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var d=new e,h=new e;l.prototype.cartographicToCartesian=function(t,r){var n=d,i=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,i);var a=Math.sqrt(e.dot(n,i));return e.divideByScalar(i,a,i),e.multiplyByScalar(n,t.height,n),o(r)||(r=new e),e.add(i,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;n>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var p=new e,m=new e,y=new e;return l.prototype.cartesianToCartographic=function(r,n){var i=this.scaleToGeodeticSurface(r,m);if(o(i)){var a=this.geodeticSurfaceNormal(i,p),u=e.subtract(r,i,y),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return o(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;n>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),o(n)||(n=new e);var i=t.x,a=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||o(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),i=n(i,0);var c=this._squaredXOverSquaredZ;return o(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),Math.abs(u.z)>=this._radii.z-i?void 0:u},l}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,
MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,o){"use strict";var i={UNSIGNED_BYTE:o.UNSIGNED_BYTE,UNSIGNED_SHORT:o.UNSIGNED_SHORT,UNSIGNED_INT:o.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},i.fromSizeInBytes=function(e){switch(e){case 2:return i.UNSIGNED_SHORT;case 4:return i.UNSIGNED_INT;case 1:return i.UNSIGNED_BYTE;default:throw new t("Size in bytes cannot be mapped to an IndexDatatype")}},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(r,o){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o):new Uint16Array(o)},i.createTypedArrayFromArrayBuffer=function(r,o,i,a){if(!e(r))throw new t("numberOfVertices is required.");if(!e(o))throw new t("sourceArray is required.");if(!e(i))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o,i,a):new Uint16Array(o,i,a)},r(i)}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,o,i,a){"use strict";function u(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return o(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=t.latitude*o,u=t.height;return n(r)?(r.x=i,r.y=a,r.z=u,r):new e(i,a,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new i("cartesian is required");var o=this._oneOverSemimajorAxis,a=e.x*o,u=e.y*o,s=e.z;return n(r)?(r.longitude=a,r.latitude=u,r.height=s,r):new t(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i,a,u){"use strict";function s(e,t,n,o,i,a,u,s,c){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(i,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function f(e){for(var t=0,r=0;3>r;++r){var n=e[s.getElementIndex(m[r],p[r])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var r=u.EPSILON15,n=0,o=1,i=0;3>i;++i){var a=Math.abs(e[s.getElementIndex(m[i],p[i])]);a>n&&(o=i,n=a)}var c=1,f=0,l=p[o],d=m[o];if(Math.abs(e[s.getElementIndex(d,l)])>r){var h,y=e[s.getElementIndex(d,d)],E=e[s.getElementIndex(l,l)],O=e[s.getElementIndex(d,l)],_=(y-E)/2/O;h=0>_?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),c=1/Math.sqrt(1+h*h),f=h*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(l,l)]=t[s.getElementIndex(d,d)]=c,t[s.getElementIndex(d,l)]=f,t[s.getElementIndex(l,d)]=-f,t}s.packedLength=9,s.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8],n},s.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i[0]=e[o++],i[1]=e[o++],i[2]=e[o++],i[3]=e[o++],i[4]=e[o++],i[5]=e[o++],i[6]=e[o++],i[7]=e[o++],i[8]=e[o++],i},s.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},s.fromArray=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i[0]=e[o],i[1]=e[o+1],i[2]=e[o+2],i[3]=e[o+3],i[4]=e[o+4],i[5]=e[o+5],i[6]=e[o+6],i[7]=e[o+7],i[8]=e[o+8],i},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var o=e.x*e.x,i=e.x*e.y,a=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,d=e.z*e.z,h=e.z*e.w,p=e.w*e.w,m=o-c-d+p,y=2*(i-h),E=2*(a+l),O=2*(i+h),_=-o+c-d+p,R=2*(f-u),w=2*(a-l),g=2*(f+u),T=-o-c+d+p;return n(r)?(r[0]=m,r[1]=O,r[2]=w,r[3]=y,r[4]=_,r[5]=g,r[6]=E,r[7]=R,r[8]=T,r):new s(m,y,E,O,_,R,w,g,T)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var o=Math.cos(-e.pitch),i=Math.cos(-e.heading),a=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=o*i,d=-a*c+f*u*i,h=f*c+a*u*i,p=o*c,m=a*i+f*u*c,y=-f*i+a*u*c,E=-u,O=f*o,_=a*o;return n(r)?(r[0]=l,r[1]=p,r[2]=E,r[3]=d,r[4]=m,r[5]=O,r[6]=h,r[7]=y,r[8]=_,r):new s(l,d,h,p,m,y,E,O,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=o,r[5]=i,r[6]=0,r[7]=-i,r[8]=o,r):new s(1,0,0,0,o,-i,0,i,o)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=0,r[2]=-i,r[3]=0,r[4]=1,r[5]=0,r[6]=i,r[7]=0,r[8]=o,r):new s(o,0,i,0,1,0,-i,0,o)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=i,r[2]=0,r[3]=-i,r[4]=o,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(o,-i,0,i,o,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=3*r,i=e[o],a=e[o+1],u=e[o+2];return n.x=i,n.y=a,n.z=u,n},s.setColumn=function(e,r,n,o){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),o=s.clone(e,o);var i=3*r;return o[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=e[r],i=e[r+3],a=e[r+6];return n.x=o,n.y=i,n.z=a,n},s.setRow=function(e,r,n,o){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),o=s.clone(e,o),o[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var d=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],d)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],d)),n};var h=new e;s.getMaximumScale=function(t){return s.getScale(t,h),e.maximumComponent(h)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],i=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=i,n[2]=a,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=d,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=r.x,i=r.y,a=r.z,u=e[0]*o+e[3]*i+e[6]*a,s=e[1]*o+e[4]*i+e[7]*a,c=e[2]*o+e[5]*i+e[8]*a;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[3],i=e[6],a=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var p=[1,0,0],m=[2,2,1],y=new s,E=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var o=u.EPSILON20,i=10,a=0,d=0;n(r)||(r={});for(var h=r.unitary=s.clone(s.IDENTITY,r.unitary),p=r.diagonal=s.clone(e,r.diagonal),m=o*c(p);i>d&&f(p)>m;)l(p,y),s.transpose(y,E),s.multiply(p,y,p),s.multiply(E,p,p),s.multiply(h,y,h),++a>2&&(++d,a=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],o=e[6],i=e[1],a=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(a*f-c*u)+i*(c*o-n*f)+s*(n*u-a*o)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[1],a=e[2],c=e[3],f=e[4],l=e[5],d=e[6],h=e[7],p=e[8],m=s.determinant(e);if(Math.abs(m)<=u.EPSILON15)throw new i("matrix is not invertible");r[0]=f*p-h*l,r[1]=h*a-o*p,r[2]=o*l-f*a,r[3]=d*l-c*p,r[4]=n*p-d*a,r[5]=c*a-n*l,r[6]=c*h-d*f,r[7]=d*o-n*h,r[8]=n*f-c*o;var y=1/m;return s.multiplyByScalar(r,y,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=o&&Math.abs(e[1]-r[1])<=o&&Math.abs(e[2]-r[2])<=o&&Math.abs(e[3]-r[3])<=o&&Math.abs(e[4]-r[4])<=o&&Math.abs(e[5]-r[5])<=o&&Math.abs(e[6]-r[6])<=o&&Math.abs(e[7]-r[7])<=o&&Math.abs(e[8]-r[8])<=o},s.IDENTITY=a(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,o(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)}a.fromElements=function(e,t,n,o,i){return r(i)?(i.x=e,i.y=t,i.z=n,i.w=o,i):new a(e,t,n,o)},a.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o++]=r.z,n[o]=r.w,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o++],i.w=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=4*o:n=new Array(4*o);for(var i=0;o>i;++i)a.pack(t[i],n,4*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/4:n=new Array(o/4);for(var i=0;o>i;i+=4){var u=i/4;n[u]=a.unpack(t,i,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,r.w=t.w/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,s),o=a.multiplyByScalar(t,1-n,o),a.add(s,o,o)};var c=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,c);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},a.ZERO=o(new a(0,0,0,0)),a.UNIT_X=o(new a(1,0,0,0)),a.UNIT_Y=o(new a(0,1,0,0)),a.UNIT_Z=o(new a(0,0,1,0)),a.UNIT_W=o(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1),l=256,d=65536,h=16777216,p=1/l,m=1/d,y=1/h,E=38;return a.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new a),f[0]=t,t=f[0],0===t)return a.clone(a.ZERO,n);var o,u=0>t?1:0;isFinite(t)?(t=Math.abs(t),o=Math.floor(i.logBase(t,10))+1,t/=Math.pow(10,o)):(t=.1,o=E);var s=t*l;return n.x=Math.floor(s),s=(s-n.x)*l,n.y=Math.floor(s),s=(s-n.y)*l,n.z=Math.floor(s),n.w=2*(o+E)+u,n},a.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),o=2*(r-n);if(n-=E,o=2*o-1,o=-o,n>=E)return 0>o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var i=o*t.x*p;return i+=o*t.y*m,i+=o*t.z*y,i*Math.pow(10,n)},a}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,o,i,a,u,s,c){"use strict";function f(e,t,r,o,i,a,u,s,c,f,l,d,h,p,m,y){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(a,0),this[6]=n(f,0),this[7]=n(p,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(m,0),this[12]=n(o,0),this[13]=n(s,0),this[14]=n(d,0),this[15]=n(y,0)}f.packedLength=16,f.pack=function(e,t,o){return r.typeOf.object("value",e),r.defined("array",t),o=n(o,0),t[o++]=e[0],t[o++]=e[1],t[o++]=e[2],t[o++]=e[3],t[o++]=e[4],t[o++]=e[5],t[o++]=e[6],t[o++]=e[7],t[o++]=e[8],t[o++]=e[9],t[o++]=e[10],t[o++]=e[11],t[o++]=e[12],t[o++]=e[13],t[o++]=e[14],t[o]=e[15],t},f.unpack=function(e,t,i){return r.defined("array",e),t=n(t,0),o(i)||(i=new f),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},f.clone=function(e,t){return o(e)?o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),o(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,i,a){return r.typeOf.object("rotation",t),i=n(i,e.ZERO),o(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new f(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,i){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),o(i)||(i=new f);var a=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,d=t.x*t.z,h=t.x*t.w,p=t.y*t.y,m=t.y*t.z,y=t.y*t.w,E=t.z*t.z,O=t.z*t.w,_=t.w*t.w,R=c-p-E+_,w=2*(l-O),g=2*(d+y),T=2*(l+O),A=-c+p-E+_,b=2*(m-h),C=2*(d-y),v=2*(m+h),S=-c-p+E+_;return i[0]=R*a,i[1]=T*a,i[2]=C*a,i[3]=0,i[4]=w*u,i[5]=A*u,i[6]=v*u,i[7]=0,i[8]=g*s,i[9]=b*s,i[10]=S*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),o(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),o(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,d=new e,h=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var i=t.position,a=t.direction,u=t.up;r.typeOf.object("camera.position",i),r.typeOf.object("camera.direction",a),r.typeOf.object("camera.up",u),e.normalize(a,l),e.normalize(e.cross(l,u,d),d),e.normalize(e.cross(d,l,h),h);var s=d.x,c=d.y,p=d.z,m=l.x,y=l.y,E=l.z,O=h.x,_=h.y,R=h.z,w=i.x,g=i.y,T=i.z,A=s*-w+c*-g+p*-T,b=O*-w+_*-g+R*-T,C=m*w+y*g+E*T;return o(n)?(n[0]=s,n[1]=O,n[2]=-m,n[3]=0,n[4]=c,n[5]=_,n[6]=-y,n[7]=0,n[8]=p,n[9]=R,n[10]=-E,n[11]=0,n[12]=A,n[13]=b,n[14]=C,n[15]=1,n):new f(s,c,p,A,O,_,R,b,-m,-y,-E,C,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,o,i){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",o,0),r.typeOf.object("result",i);var a=Math.tan(.5*e),u=1/a,s=u/t,c=(o+n)/(n-o),f=2*o*n/(n-o);return i[0]=s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=c,i[11]=-1,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},f.computeOrthographicOffCenter=function(e,t,n,o,i,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=1/(t-e),c=1/(o-n),f=1/(a-i),l=-(t+e)*s,d=-(o+n)*c,h=-(a+i)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=d,u[14]=h,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,o,i,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=2*i/(t-e),c=2*i/(o-n),f=(t+e)/(t-e),l=(o+n)/(o-n),d=-(a+i)/(a-i),h=-1,p=-2*a*i/(a-i);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=d,u[11]=h,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,o,i,a){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.object("result",a);var u=2*i/(t-e),s=2*i/(o-n),c=(t+e)/(t-e),f=(o+n)/(o-n),l=-1,d=-1,h=-2*i;return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=l,a[11]=d,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},f.computeViewportTransformation=function(e,t,o,i){r.typeOf.object("result",i),e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),o=n(o,1);var f=.5*s,l=.5*c,d=.5*(o-t),h=f,p=l,m=d,y=a+f,E=u+l,O=t+d,_=1;return i[0]=h,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=p,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=m,i[11]=0,i[12]=y,i[13]=E,i[14]=O,i[15]=_,i},f.computeView=function(t,n,o,i,a){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",o),r.typeOf.object("right",i),r.typeOf.object("result",a),a[0]=i.x,a[1]=o.x,a[2]=-n.x,a[3]=0,a[4]=i.y,a[5]=o.y,a[6]=-n.y,a[7]=0,a[8]=i.z,a[9]=o.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(i,t),a[13]=-e.dot(o,t),a[14]=e.dot(n,t),a[15]=1,a},f.toArray=function(e,t){return r.typeOf.object("matrix",e),o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);
var o=4*t,i=e[o],a=e[o+1],u=e[o+2],s=e[o+3];return n.x=i,n.y=a,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,o){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o),o=f.clone(e,o);var i=4*t;return o[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o[i+3]=n.w,o},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var p=new e;f.setScale=function(t,n,o){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",o);var i=f.getScale(t,p),a=e.divideComponents(n,i,p);return f.multiplyByScale(t,a,o)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var o=e[t],i=e[t+4],a=e[t+8],u=e[t+12];return n.x=o,n.y=i,n.z=a,n.w=u,n},f.setRow=function(e,t,n,o){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o),o=f.clone(e,o),o[t]=n.x,o[t+4]=n.y,o[t+8]=n.z,o[t+12]=n.w,o};var m=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],m)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],m)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],m)),n};var y=new e;f.getMaximumScale=function(t){return f.getScale(t,y),e.maximumComponent(y)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],d=e[8],h=e[9],p=e[10],m=e[11],y=e[12],E=e[13],O=e[14],_=e[15],R=t[0],w=t[1],g=t[2],T=t[3],A=t[4],b=t[5],C=t[6],v=t[7],S=t[8],I=t[9],N=t[10],M=t[11],x=t[12],P=t[13],D=t[14],F=t[15],U=o*R+s*w+d*g+y*T,q=i*R+c*w+h*g+E*T,L=a*R+f*w+p*g+O*T,B=u*R+l*w+m*g+_*T,j=o*A+s*b+d*C+y*v,z=i*A+c*b+h*C+E*v,G=a*A+f*b+p*C+O*v,V=u*A+l*b+m*C+_*v,W=o*S+s*I+d*N+y*M,X=i*S+c*I+h*N+E*M,k=a*S+f*I+p*N+O*M,H=u*S+l*I+m*N+_*M,Y=o*x+s*P+d*D+y*F,K=i*x+c*P+h*D+E*F,Z=a*x+f*P+p*D+O*F,Q=u*x+l*P+m*D+_*F;return n[0]=U,n[1]=q,n[2]=L,n[3]=B,n[4]=j,n[5]=z,n[6]=G,n[7]=V,n[8]=W,n[9]=X,n[10]=k,n[11]=H,n[12]=Y,n[13]=K,n[14]=Z,n[15]=Q,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],d=e[10],h=e[12],p=e[13],m=e[14],y=t[0],E=t[1],O=t[2],_=t[4],R=t[5],w=t[6],g=t[8],T=t[9],A=t[10],b=t[12],C=t[13],v=t[14],S=o*y+u*E+f*O,I=i*y+s*E+l*O,N=a*y+c*E+d*O,M=o*_+u*R+f*w,x=i*_+s*R+l*w,P=a*_+c*R+d*w,D=o*g+u*T+f*A,F=i*g+s*T+l*A,U=a*g+c*T+d*A,q=o*b+u*C+f*v+h,L=i*b+s*C+l*v+p,B=a*b+c*C+d*v+m;return n[0]=S,n[1]=I,n[2]=N,n[3]=0,n[4]=M,n[5]=x,n[6]=P,n[7]=0,n[8]=D,n[9]=F,n[10]=U,n[11]=0,n[12]=q,n[13]=L,n[14]=B,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],d=e[10],h=t[0],p=t[1],m=t[2],y=t[3],E=t[4],O=t[5],_=t[6],R=t[7],w=t[8],g=o*h+u*p+f*m,T=i*h+s*p+l*m,A=a*h+c*p+d*m,b=o*y+u*E+f*O,C=i*y+s*E+l*O,v=a*y+c*E+d*O,S=o*_+u*R+f*w,I=i*_+s*R+l*w,N=a*_+c*R+d*w;return n[0]=g,n[1]=T,n[2]=A,n[3]=0,n[4]=b,n[5]=C,n[6]=v,n[7]=0,n[8]=S,n[9]=I,n[10]=N,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=o*e[0]+i*e[4]+a*e[8]+e[12],s=o*e[1]+i*e[5]+a*e[9]+e[13],c=o*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z;return 1===o&&1===i&&1===a?f.clone(e,n):(n[0]=o*e[0],n[1]=o*e[1],n[2]=o*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=t.w,s=e[0]*o+e[4]*i+e[8]*a+e[12]*u,c=e[1]*o+e[5]*i+e[9]*a+e[13]*u,f=e[2]*o+e[6]*i+e[10]*a+e[14]*u,l=e[3]*o+e[7]*i+e[11]*a+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=e[0]*o+e[4]*i+e[8]*a,s=e[1]*o+e[5]*i+e[9]*a,c=e[2]*o+e[6]*i+e[10]*a;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,u=e[0]*o+e[4]*i+e[8]*a+e[12],s=e[1]*o+e[5]*i+e[9]*a+e[13],c=e[2]*o+e[6]*i+e[10]*a+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.multiplyByPlane=function(n,o,i){r.typeOf.object("matrix",n),r.typeOf.object("plane",o),r.typeOf.object("result",i);var a=new f,u=new f;f.inverse(n,a),f.transpose(a,u);var s=new t(o.normal.x,o.normal.y,o.normal.z,o.distance);f.multiplyByVector(u,s,s),i.normal.x=s.x,i.normal.y=s.y,i.normal.z=s.z;var c=e.magnitude(i.normal);return e.normalize(i.normal,i.normal),i.distance=s.w/c,i},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],o=e[2],i=e[3],a=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=o,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||o(e)&&o(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||o(e)&&o(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,_=new s,R=new t,w=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var o=e[0],i=e[4],a=e[8],l=e[12],d=e[1],h=e[5],p=e[9],m=e[13],y=e[2],E=e[6],g=e[10],T=e[14],A=e[3],b=e[7],C=e[11],v=e[15],S=g*v,I=T*C,N=E*v,M=T*b,x=E*C,P=g*b,D=y*v,F=T*A,U=y*C,q=g*A,L=y*b,B=E*A,j=S*h+M*p+x*m-(I*h+N*p+P*m),z=I*d+D*p+q*m-(S*d+F*p+U*m),G=N*d+F*h+L*m-(M*d+D*h+B*m),V=P*d+U*h+B*p-(x*d+q*h+L*p),W=I*i+N*a+P*l-(S*i+M*a+x*l),X=S*o+F*a+U*l-(I*o+D*a+q*l),k=M*o+D*i+B*l-(N*o+F*i+L*l),H=x*o+q*i+L*a-(P*o+U*i+B*a);S=a*m,I=l*p,N=i*m,M=l*h,x=i*p,P=a*h,D=o*m,F=l*d,U=o*p,q=a*d,L=o*h,B=i*d;var Y=S*b+M*C+x*v-(I*b+N*C+P*v),K=I*A+D*C+q*v-(S*A+F*C+U*v),Z=N*A+F*b+L*v-(M*A+D*b+B*v),Q=P*A+U*b+B*C-(x*A+q*b+L*C),J=N*g+P*T+I*E-(x*T+S*E+M*g),$=U*T+S*y+F*g-(D*g+q*T+I*y),ee=D*E+B*T+M*y-(L*T+N*y+F*E),te=L*g+x*y+q*E-(U*E+B*g+P*y),re=o*j+i*z+a*G+l*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(f.getRotation(e,O),_,u.EPSILON7)&&t.equals(f.getRow(e,3,R),w))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=j*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=W*re,n[5]=X*re,n[6]=k*re,n[7]=H*re,n[8]=Y*re,n[9]=K*re,n[10]=Z*re,n[11]=Q*re,n[12]=J*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],o=e[1],i=e[2],a=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],d=e[12],h=e[13],p=e[14],m=-n*d-o*h-i*p,y=-a*d-u*h-s*p,E=-c*d-f*h-l*p;return t[0]=n,t[1]=a,t[2]=c,t[3]=0,t[4]=o,t[5]=u,t[6]=f,t[7]=0,t[8]=i,t[9]=s,t[10]=l,t[11]=0,t[12]=m,t[13]=y,t[14]=E,t[15]=1,t},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,i(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,o,i,a,u){"use strict";function s(e,t,n,o){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(o,0)}o(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north,n},s.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i.west=e[o++],i.south=e[o++],i.east=e[o++],i.north=e[o],i},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,o,i,a){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),o=u.toRadians(r(o,0)),i=u.toRadians(r(i,0)),n(a)?(a.west=e,a.south=t,a.east=o,a.north=i,a):new s(e,t,o,i)},s.fromRadians=function(e,t,o,i,a){return n(a)?(a.west=r(e,0),a.south=r(t,0),a.east=r(o,0),a.north=r(i,0),a):new s(e,t,o,i)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var o=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,d=0,h=e.length;h>d;d++){var p=e[d];o=Math.min(o,p.longitude),i=Math.max(i,p.longitude),f=Math.min(f,p.latitude),l=Math.max(l,p.latitude);var m=p.longitude>=0?p.longitude:p.longitude+u.TWO_PI;a=Math.min(a,m),c=Math.max(c,m)}return i-o>c-a&&(o=a,i=c,i>u.PI&&(i-=u.TWO_PI),o>u.PI&&(o-=u.TWO_PI)),n(r)?(r.west=o,r.south=f,r.east=i,r.north=l,r):new s(o,f,i,l)},s.fromCartesianArray=function(e,o,a){t.defined("cartesians",e),o=r(o,i.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,d=-Number.MAX_VALUE,h=Number.MAX_VALUE,p=-Number.MAX_VALUE,m=0,y=e.length;y>m;m++){var E=o.cartesianToCartographic(e[m]);c=Math.min(c,E.longitude),f=Math.max(f,E.longitude),h=Math.min(h,E.latitude),p=Math.max(p,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;l=Math.min(l,O),d=Math.max(d,O)}return f-c>d-l&&(c=l,f=d,f>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(a)?(a.west=c,a.south=h,a.east=f,a.north=p,a):new s(c,h,f,p)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("absoluteEpsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=o&&Math.abs(e.south-r.south)<=o&&Math.abs(e.east-r.east)<=o&&Math.abs(e.north-r.north)<=o},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var o=e.west;t.typeOf.number.greaterThanOrEquals("west",o,-Math.PI),t.typeOf.number.lessThanOrEquals("west",o,Math.PI);var i=e.east;t.typeOf.number.greaterThanOrEquals("east",i,-Math.PI),t.typeOf.number.lessThanOrEquals("east",i,Math.PI)},s.southwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.south,o.height=0,o):new e(r.west,r.south)},s.northwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.north,o.height=0,o):new e(r.west,r.north)},s.northeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.north,o.height=0,o):new e(r.east,r.north)},s.southeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.south,o.height=0,o):new e(r.east,r.south)},s.center=function(r,o){t.typeOf.object("rectangle",r);var i=r.east,a=r.west;a>i&&(i+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+i)),c=.5*(r.south+r.north);return n(o)?(o.longitude=s,o.latitude=c,o.height=0,o):new e(s,c)},s.intersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=e.east,a=e.west,c=r.east,f=r.west;a>i&&c>0?i+=u.TWO_PI:f>c&&i>0&&(c+=u.TWO_PI),a>i&&0>f?f+=u.TWO_PI:f>c&&0>a&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,f)),d=u.negativePiToPi(Math.min(i,c));if(!((e.west<e.east||r.west<r.east)&&l>=d)){var h=Math.max(e.south,r.south),p=Math.min(e.north,r.north);if(!(h>=p))return n(o)?(o.west=l,o.south=h,o.east=d,o.north=p,o):new s(l,h,d,p)}},s.simpleIntersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);return a>=c||i>=u?void 0:n(o)?(o.west=i,o.south=a,o.east=u,o.north=c,o):new s(i,a,u,c)},s.union=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(o)||(o=new s);var i=e.east,a=e.west,c=r.east,f=r.west;a>i&&c>0?i+=u.TWO_PI:f>c&&i>0&&(c+=u.TWO_PI),a>i&&0>f?f+=u.TWO_PI:f>c&&0>a&&(a+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(a,f)),d=u.convertLongitudeRange(Math.max(i,c));return o.west=l,o.south=Math.min(e.south,r.south),o.east=d,o.north=Math.max(e.north,r.north),o},s.expand=function(e,r,o){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(o)||(o=new s),o.west=Math.min(e.west,r.longitude),o.south=Math.min(e.south,r.latitude),o.east=Math.max(e.east,r.longitude),o.north=Math.max(e.north,r.latitude),o},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,o=r.latitude,i=e.west,a=e.east;return i>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&o>=e.south&&o<=e.north};var c=new e;return s.subsample=function(e,o,a,f){t.typeOf.object("rectangle",e),o=r(o,i.WGS84),a=r(a,0),n(f)||(f=[]);var l=0,d=e.north,h=e.south,p=e.east,m=e.west,y=c;y.height=a,y.longitude=m,y.latitude=d,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.longitude=p,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.latitude=h,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.longitude=m,f[l]=o.cartographicToCartesian(y,f[l]),l++,0>d?y.latitude=d:h>0?y.latitude=h:y.latitude=0;for(var E=1;8>E;++E)y.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,y)&&(f[l]=o.cartographicToCartesian(y,f[l]),l++);return 0===y.latitude&&(y.longitude=m,f[l]=o.cartographicToCartesian(y,f[l]),l++,y.longitude=p,f[l]=o.cartographicToCartesian(y,f[l]),l++),f.length=l,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,o,i,a,u,s,c,f,l,d){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var p=new e,m=new e,y=new e,E=new e,O=new e,_=new e,R=new e,w=new e,g=new e,T=new e,A=new e,b=new e,C=4/3*c.PI;h.fromPoints=function(t,r){if(o(r)||(r=new h),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,i=e.clone(t[0],R),a=e.clone(i,p),u=e.clone(i,m),s=e.clone(i,y),c=e.clone(i,E),f=e.clone(i,O),l=e.clone(i,_),d=t.length;for(n=1;d>n;n++){e.clone(t[n],i);var C=i.x,v=i.y,S=i.z;C<a.x&&e.clone(i,a),C>c.x&&e.clone(i,c),v<u.y&&e.clone(i,u),v>f.y&&e.clone(i,f),S<s.z&&e.clone(i,s),S>l.z&&e.clone(i,l)}var I=e.magnitudeSquared(e.subtract(c,a,w)),N=e.magnitudeSquared(e.subtract(f,u,w)),M=e.magnitudeSquared(e.subtract(l,s,w)),x=a,P=c,D=I;N>D&&(D=N,x=u,P=f),M>D&&(D=M,x=s,P=l);var F=g;F.x=.5*(x.x+P.x),F.y=.5*(x.y+P.y),F.z=.5*(x.z+P.z);var U=e.magnitudeSquared(e.subtract(P,F,w)),q=Math.sqrt(U),L=T;L.x=a.x,L.y=u.y,L.z=s.z;var B=A;B.x=c.x,B.y=f.y,B.z=l.z;var j=e.midpoint(L,B,b),z=0;for(n=0;d>n;n++){e.clone(t[n],i);var G=e.magnitude(e.subtract(i,j,w));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(i,F,w));if(V>U){var W=Math.sqrt(V);q=.5*(q+W),U=q*q;var X=W-q;F.x=(q*F.x+X*i.x)/W,F.y=(q*F.y+X*i.y)/W,F.z=(q*F.z+X*i.z)/W}}return z>q?(e.clone(F,r.center),r.radius=q):(e.clone(j,r.center),r.radius=z),r};var v=new a,S=new e,I=new e,N=new t,M=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,i,a,u){if(o(u)||(u=new h),!o(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,v),d.southwest(t,N),N.height=i,d.northeast(t,M),M.height=a;var s=r.project(N,S),c=r.project(M,I),f=c.x-s.x,l=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+p*p);var m=u.center;return m.x=s.x+.5*f,m.y=s.y+.5*l,m.z=s.z+.5*p,u};var x=[];h.fromRectangle3D=function(t,r,a,u){if(r=n(r,i.WGS84),a=n(a,0),o(u)||(u=new h),!o(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=d.subsample(t,r,a,x);return h.fromPoints(s,u)},h.fromVertices=function(t,i,a,u){if(o(u)||(u=new h),!o(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=n(i,e.ZERO),a=n(a,3),r.typeOf.number.greaterThanOrEquals("stride",a,3);var s=R;s.x=t[0]+i.x,s.y=t[1]+i.y,s.z=t[2]+i.z;var c,f=e.clone(s,p),l=e.clone(s,m),d=e.clone(s,y),C=e.clone(s,E),v=e.clone(s,O),S=e.clone(s,_),I=t.length;for(c=0;I>c;c+=a){var N=t[c]+i.x,M=t[c+1]+i.y,x=t[c+2]+i.z;s.x=N,s.y=M,s.z=x,N<f.x&&e.clone(s,f),N>C.x&&e.clone(s,C),M<l.y&&e.clone(s,l),M>v.y&&e.clone(s,v),x<d.z&&e.clone(s,d),x>S.z&&e.clone(s,S)}var P=e.magnitudeSquared(e.subtract(C,f,w)),D=e.magnitudeSquared(e.subtract(v,l,w)),F=e.magnitudeSquared(e.subtract(S,d,w)),U=f,q=C,L=P;D>L&&(L=D,U=l,q=v),F>L&&(L=F,U=d,q=S);var B=g;B.x=.5*(U.x+q.x),B.y=.5*(U.y+q.y),B.z=.5*(U.z+q.z);var j=e.magnitudeSquared(e.subtract(q,B,w)),z=Math.sqrt(j),G=T;G.x=f.x,G.y=l.y,G.z=d.z;var V=A;V.x=C.x,V.y=v.y,V.z=S.z;var W=e.midpoint(G,V,b),X=0;for(c=0;I>c;c+=a){s.x=t[c]+i.x,s.y=t[c+1]+i.y,s.z=t[c+2]+i.z;var k=e.magnitude(e.subtract(s,W,w));k>X&&(X=k);var H=e.magnitudeSquared(e.subtract(s,B,w));if(H>j){var Y=Math.sqrt(H);z=.5*(z+Y),j=z*z;var K=Y-z;B.x=(z*B.x+K*s.x)/Y,B.y=(z*B.y+K*s.y)/Y,B.z=(z*B.z+K*s.z)/Y}}return X>z?(e.clone(B,u.center),u.radius=z):(e.clone(W,u.center),u.radius=X),u},h.fromEncodedCartesianVertices=function(t,r,n){if(o(n)||(n=new h),!o(t)||!o(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=R;i.x=t[0]+r[0],i.y=t[1]+r[1],i.z=t[2]+r[2];var a,u=e.clone(i,p),s=e.clone(i,m),c=e.clone(i,y),f=e.clone(i,E),l=e.clone(i,O),d=e.clone(i,_),C=t.length;for(a=0;C>a;a+=3){var v=t[a]+r[a],S=t[a+1]+r[a+1],I=t[a+2]+r[a+2];i.x=v,i.y=S,i.z=I,v<u.x&&e.clone(i,u),v>f.x&&e.clone(i,f),S<s.y&&e.clone(i,s),S>l.y&&e.clone(i,l),I<c.z&&e.clone(i,c),I>d.z&&e.clone(i,d)}var N=e.magnitudeSquared(e.subtract(f,u,w)),M=e.magnitudeSquared(e.subtract(l,s,w)),x=e.magnitudeSquared(e.subtract(d,c,w)),P=u,D=f,F=N;M>F&&(F=M,P=s,D=l),x>F&&(F=x,P=c,D=d);var U=g;U.x=.5*(P.x+D.x),U.y=.5*(P.y+D.y),U.z=.5*(P.z+D.z);var q=e.magnitudeSquared(e.subtract(D,U,w)),L=Math.sqrt(q),B=T;B.x=u.x,B.y=s.y,B.z=c.z;var j=A;j.x=f.x,j.y=l.y,j.z=d.z;var z=e.midpoint(B,j,b),G=0;for(a=0;C>a;a+=3){i.x=t[a]+r[a],i.y=t[a+1]+r[a+1],i.z=t[a+2]+r[a+2];var V=e.magnitude(e.subtract(i,z,w));V>G&&(G=V);var W=e.magnitudeSquared(e.subtract(i,U,w));if(W>q){var X=Math.sqrt(W);L=.5*(L+X),q=L*L;var k=X-L;U.x=(L*U.x+k*i.x)/X,U.y=(L*U.y+k*i.y)/X,U.z=(L*U.z+k*i.z)/X}}return G>L?(e.clone(U,n.center),n.radius=L):(e.clone(z,n.center),n.radius=G),n},h.fromCornerPoints=function(t,n,i){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),o(i)||(i=new h);var a=e.midpoint(t,n,i.center);return i.radius=e.distance(a,n),i},h.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),o(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;h.fromBoundingSpheres=function(t,r){if(o(r)||(r=new h),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var i,a=[];for(i=0;n>i;i++)a.push(t[i].center);r=h.fromPoints(a,r);var u=r.center,s=r.radius;for(i=0;n>i;i++){var c=t[i];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var D=new e,F=new e,U=new e;h.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),o(n)||(n=new h);var i=t.halfAxes,a=f.getColumn(i,0,D),u=f.getColumn(i,1,F),s=f.getColumn(i,2,U);return e.add(a,u,a),e.add(a,s,a),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(a),n},h.clone=function(t,r){return o(t)?o(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius):void 0},h.packedLength=4,h.pack=function(e,t,o){r.typeOf.object("value",e),r.defined("array",t),o=n(o,0);var i=e.center;return t[o++]=i.x,t[o++]=i.y,t[o++]=i.z,t[o]=e.radius,t},h.unpack=function(e,t,i){r.defined("array",e),t=n(t,0),o(i)||(i=new h);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var q=new e,L=new e;h.union=function(t,n,i){r.typeOf.object("left",t),r.typeOf.object("right",n),o(i)||(i=new h);var a=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,a,q),l=e.magnitude(f);if(u>=l+c)return t.clone(i),i;if(c>=l+u)return n.clone(i),i;var d=.5*(u+l+c),p=e.multiplyByScalar(f,(-u+d)/l,L);return e.add(p,a,p),e.clone(p,i.center),i.radius=d,i};var B=new e;h.expand=function(t,n,o){r.typeOf.object("sphere",t),r.typeOf.object("point",n),o=h.clone(t,o);var i=e.magnitude(e.subtract(n,o.center,B));return i>o.radius&&(o.radius=i),o},h.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var o=t.center,i=t.radius,a=n.normal,s=e.dot(a,o)+n.distance;return-i>s?u.OUTSIDE:i>s?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var j=new e;h.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var o=e.subtract(t.center,n,j);return e.magnitudeSquared(o)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;h.computePlaneDistances=function(t,n,i,a){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",i),o(a)||(a=new s);var u=e.subtract(t.center,n,z),c=e.dot(i,u);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var G=new e,V=new e,W=new e,X=new e,k=new e,H=new t,Y=new Array(8),K=0;8>K;++K)Y[K]=new e;var Z=new a;return h.projectTo2D=function(t,o,i){r.typeOf.object("sphere",t),o=n(o,Z);var a=o.ellipsoid,u=t.center,s=t.radius,c=a.geodeticSurfaceNormal(u,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,W);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var d=e.negate(l,k),p=e.negate(f,X),m=Y,y=m[0];e.add(c,l,y),e.add(y,f,y),y=m[1],e.add(c,l,y),e.add(y,p,y),y=m[2],e.add(c,d,y),e.add(y,p,y),y=m[3],e.add(c,d,y),e.add(y,f,y),e.negate(c,c),y=m[4],e.add(c,l,y),e.add(y,f,y),y=m[5],e.add(c,l,y),e.add(y,p,y),y=m[6],e.add(c,d,y),e.add(y,p,y),y=m[7],e.add(c,d,y),e.add(y,f,y);for(var E=m.length,O=0;E>O;++O){var _=m[O];e.add(u,_,_);var R=a.cartesianToCartographic(_,H);o.project(R,_)}i=h.fromPoints(m,i),u=i.center;var w=u.x,g=u.y,T=u.z;return u.x=T,u.y=w,u.z=g,i},h.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||o(t)&&o(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return C*e*e*e},h}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./Check","./defaultValue","./defined","./Intersect"],function(e,t,r,n,o){"use strict";function i(t,o,i){this.minimum=e.clone(r(t,e.ZERO)),this.maximum=e.clone(r(o,e.ZERO)),i=n(i)?e.clone(i):e.midpoint(this.minimum,this.maximum,new e),this.center=i}i.fromPoints=function(t,r){if(n(r)||(r=new i),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var o=t[0].x,a=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,f=t[0].z,l=t.length,d=1;l>d;d++){var h=t[d],p=h.x,m=h.y,y=h.z;o=Math.min(p,o),s=Math.max(p,s),a=Math.min(m,a),c=Math.max(m,c),u=Math.min(y,u),f=Math.max(y,f)}var E=r.minimum;E.x=o,E.y=a,E.z=u;var O=r.maximum;return O.x=s,O.y=c,O.z=f,r.center=e.midpoint(E,O,r.center),r},i.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new i(t.minimum,t.maximum,t.center):void 0},i.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var a=new e;return i.intersectPlane=function(r,n){t.defined("box",r),t.defined("plane",n),a=e.subtract(r.maximum,r.minimum,a);var i=e.multiplyByScalar(a,.5,a),u=n.normal,s=i.x*Math.abs(u.x)+i.y*Math.abs(u.y)+i.z*Math.abs(u.z),c=e.dot(r.center,u)+n.distance;return c-s>0?o.INSIDE:0>c+s?o.OUTSIDE:o.INTERSECTING},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.intersectPlane=function(e){return i.intersectPlane(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var o=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}var n={};return n.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var o=r*r-4*t*n;return o},n.computeRealRoots=function(n,o,i){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof o)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");var a;if(0===n)return 0===o?[]:[-i/o];if(0===o){if(0===i)return[0,0];var u=Math.abs(i),s=Math.abs(n);if(s>u&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if(a=-i/n,0>a)return[];var c=Math.sqrt(a);return[-c,c]}if(0===i)return a=-o/n,0>a?[a,0]:[0,a];var f=o*o,l=4*n*i,d=r(f,-l,t.EPSILON14);if(0>d)return[];var h=-.5*r(o,t.sign(o)*Math.sqrt(d),t.EPSILON14);return o>0?[h/n,i/h]:[i/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var o,i,a=e,u=t/3,s=r/3,c=n,f=a*s,l=u*c,d=u*u,h=s*s,p=a*s-d,m=a*c-u*s,y=u*c-h,E=4*p*y-m*m;if(0>E){var O,_,R;d*l>=f*h?(O=a,_=p,R=-2*u*p+a*m):(O=c,_=y,R=-c*m+2*s*y);var w=0>R?-1:1,g=-w*Math.abs(O)*Math.sqrt(-E);i=-R+g;var T=i/2,A=0>T?-Math.pow(-T,1/3):Math.pow(T,1/3),b=i===g?-A:-_/A;return o=0>=_?A+b:-R/(A*A+b*b+_),d*l>=f*h?[(o-u)/a]:[-c/(o+s)]}var C=p,v=-2*u*p+a*m,S=y,I=-c*m+2*s*y,N=Math.sqrt(E),M=Math.sqrt(3)/2,x=Math.abs(Math.atan2(a*N,-v)/3);o=2*Math.sqrt(-C);var P=Math.cos(x);i=o*P;var D=o*(-P/2-M*Math.sin(x)),F=i+D>2*u?i-u:D-u,U=a,q=F/U;x=Math.abs(Math.atan2(c*N,-I)/3),o=2*Math.sqrt(-S),P=Math.cos(x),i=o*P,D=o*(-P/2-M*Math.sin(x));var L=-c,B=2*s>i+D?i+s:D+s,j=L/B,z=U*B,G=-F*B-U*L,V=F*L,W=(s*G-u*V)/(-u*G+s*z);return W>=q?j>=q?j>=W?[q,W,j]:[q,j,W]:[j,q,W]:j>=q?[W,q,j]:j>=W?[W,j,q]:[j,W,q]}var n={};return n.computeDiscriminant=function(t,r,n,o){if("number"!=typeof t)throw new e("a is a required number.");
if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var i=t*t,a=r*r,u=n*n,s=o*o,c=18*t*r*n*o+a*u-27*i*s-4*(t*u*n+a*r*o);return c},n.computeRealRoots=function(n,o,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof o)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===n)return t.computeRealRoots(o,i,a);if(0===o){if(0===i){if(0===a)return[0,0,0];s=-a/n;var c=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===a?(u=t.computeRealRoots(n,0,i),0===u.Length?[0]:[u[0],0,u[1]]):r(n,0,i,a)}return 0===i?0===a?(s=-o/n,0>s?[s,0,0]:[0,0,s]):r(n,o,0,a):0===a?(u=t.computeRealRoots(n,o,i),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):r(n,o,i,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function o(t,o,i,a){var u=t*t,s=o-3*u/8,c=i-o*t/2+u*t/8,f=a-i*t/4+o*u/16-3*u*u/256,l=e.computeRealRoots(1,2*s,s*s-4*f,-c*c);if(l.length>0){var d=-t/4,h=l[l.length-1];if(Math.abs(h)<r.EPSILON14){var p=n.computeRealRoots(1,s,f);if(2===p.length){var m,y=p[0],E=p[1];if(y>=0&&E>=0){var O=Math.sqrt(y),_=Math.sqrt(E);return[d-_,d-O,d+O,d+_]}if(y>=0&&0>E)return m=Math.sqrt(y),[d-m,d+m];if(0>y&&E>=0)return m=Math.sqrt(E),[d-m,d+m]}return[]}if(h>0){var R=Math.sqrt(h),w=(s+h-c/R)/2,g=(s+h+c/R)/2,T=n.computeRealRoots(1,R,w),A=n.computeRealRoots(1,-R,g);return 0!==T.length?(T[0]+=d,T[1]+=d,0!==A.length?(A[0]+=d,A[1]+=d,T[1]<=A[0]?[T[0],T[1],A[0],A[1]]:A[1]<=T[0]?[A[0],A[1],T[0],T[1]]:T[0]>=A[0]&&T[1]<=A[1]?[A[0],T[0],T[1],A[1]]:A[0]>=T[0]&&A[1]<=T[1]?[T[0],A[0],A[1],T[1]]:T[0]>A[0]&&T[0]<A[1]?[A[0],T[0],A[1],T[1]]:[T[0],A[0],T[1],A[1]]):T):0!==A.length?(A[0]+=d,A[1]+=d,A):[]}}return[]}function i(t,o,i,a){var u=i*i,s=o*o,c=t*t,f=-2*o,l=i*t+s-4*a,d=c*a-i*o*t+u,h=e.computeRealRoots(1,f,l,d);if(h.length>0){var p,m,y=h[0],E=o-y,O=E*E,_=t/2,R=E/2,w=O-4*a,g=O+4*Math.abs(a),T=c-4*y,A=c+4*Math.abs(y);if(0>y||T*g>w*A){var b=Math.sqrt(T);p=b/2,m=0===b?0:(t*R-i)/b}else{var C=Math.sqrt(w);p=0===C?0:(t*R-i)/C,m=C/2}var v,S;0===_&&0===p?(v=0,S=0):r.sign(_)===r.sign(p)?(v=_+p,S=y/v):(S=_-p,v=y/S);var I,N;0===R&&0===m?(I=0,N=0):r.sign(R)===r.sign(m)?(I=R+m,N=a/I):(N=R-m,I=a/N);var M=n.computeRealRoots(1,v,I),x=n.computeRealRoots(1,S,N);if(0!==M.length)return 0!==x.length?M[1]<=x[0]?[M[0],M[1],x[0],x[1]]:x[1]<=M[0]?[x[0],x[1],M[0],M[1]]:M[0]>=x[0]&&M[1]<=x[1]?[x[0],M[0],M[1],x[1]]:x[0]>=M[0]&&x[1]<=M[1]?[M[0],x[0],x[1],M[1]]:M[0]>x[0]&&M[0]<x[1]?[x[0],M[0],x[1],M[1]]:[M[0],x[0],M[1],x[1]]:M;if(0!==x.length)return x}return[]}var a={};return a.computeDiscriminant=function(e,r,n,o,i){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof o)throw new t("d is a required number.");if("number"!=typeof i)throw new t("e is a required number.");var a=e*e,u=a*e,s=r*r,c=s*r,f=n*n,l=f*n,d=o*o,h=d*o,p=i*i,m=p*i,y=s*f*d-4*c*h-4*e*l*d+18*e*r*n*h-27*a*d*d+256*u*m+i*(18*c*n*o-4*s*l+16*e*f*f-80*e*r*f*o-6*e*s*d+144*a*n*d)+p*(144*e*s*n-27*s*s-128*a*f-192*a*r*o);return y},a.computeRealRoots=function(n,a,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof a)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(a,u,s,c);var f=a/n,l=u/n,d=s/n,h=c/n,p=0>f?1:0;switch(p+=0>l?p+1:p,p+=0>d?p+1:p,p+=0>h?p+1:p){case 0:return o(f,l,d,h);case 1:return i(f,l,d,h);case 2:return i(f,l,d,h);case 3:return o(f,l,d,h);case 4:return o(f,l,d,h);case 5:return i(f,l,d,h);case 6:return o(f,l,d,h);case 7:return o(f,l,d,h);case 8:return i(f,l,d,h);case 9:return o(f,l,d,h);case 10:return o(f,l,d,h);case 11:return i(f,l,d,h);case 12:return o(f,l,d,h);case 13:return o(f,l,d,h);case 14:return o(f,l,d,h);case 15:return o(f,l,d,h);default:return}},a}),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],function(e,t,r,n){"use strict";function o(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return o.clone=function(t,r){return n(t)?n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new o(t.origin,t.direction):void 0},o.getPoint=function(r,o,i){return t.typeOf.object("ray",r),t.typeOf.number("t",o),n(i)||(i=new e),i=e.multiplyByScalar(r.direction,o,i),e.add(r.origin,i,i)},o}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,o,i,a,u,s,c,f){"use strict";function l(e,t,r,n){var o=t*t-4*e*r;if(!(0>o)){if(o>0){var i=1/(2*e),a=Math.sqrt(o),u=(-t+a)*i,s=(-t-a)*i;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function d(t,r,o){n(o)||(o=new i);var a=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,f=e.subtract(a,s,O),d=e.dot(u,u),h=2*e.dot(u,f),p=e.magnitudeSquared(f)-c,m=l(d,h,p,g);return n(m)?(o.start=m.root0,o.stop=m.root1,o):void 0}function h(e,t,r){var n=e+t;return a.sign(e)!==a.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function p(t,r,n,o,i){var f,l=o*o,d=i*i,p=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*d,m=i*(o*h(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],a.EPSILON15)+r.y),y=t[u.COLUMN0ROW0]*l+t[u.COLUMN2ROW2]*d+o*r.x+n,E=d*h(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],a.EPSILON15),O=i*(o*h(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),_=[];if(0===O&&0===E){if(f=s.computeRealRoots(p,m,y),0===f.length)return _;var R=f[0],w=Math.sqrt(Math.max(1-R*R,0));if(_.push(new e(o,i*R,i*-w)),_.push(new e(o,i*R,i*w)),2===f.length){var g=f[1],T=Math.sqrt(Math.max(1-g*g,0));_.push(new e(o,i*g,i*-T)),_.push(new e(o,i*g,i*T))}return _}var A=O*O,b=E*E,C=p*p,v=O*E,S=C+b,I=2*(m*p+v),N=2*y*p+m*m-b+A,M=2*(y*m-v),x=y*y-A;if(0===S&&0===I&&0===N&&0===M)return _;f=c.computeRealRoots(S,I,N,M,x);var P=f.length;if(0===P)return _;for(var D=0;P>D;++D){var F,U=f[D],q=U*U,L=Math.max(1-q,0),B=Math.sqrt(L);F=a.sign(p)===a.sign(y)?h(p*q+y,m*U,a.EPSILON12):a.sign(y)===a.sign(m*U)?h(p*q,m*U+y,a.EPSILON12):h(p*q+m*U,y,a.EPSILON12);var j=h(E*U,O,a.EPSILON15),z=F*j;0>z?_.push(new e(o,i*U,i*B)):z>0?_.push(new e(o,i*U,i*-B)):0!==B?(_.push(new e(o,i*U,i*-B)),_.push(new e(o,i*U,i*B)),++D):_.push(new e(o,i*U,i*B))}return _}var m={};m.rayPlane=function(t,r,i){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("plane is required.");n(i)||(i=new e);var u=t.origin,s=t.direction,c=r.normal,f=e.dot(c,s);if(!(Math.abs(f)<a.EPSILON15)){var l=(-r.distance-e.dot(c,u))/f;if(!(0>l))return i=e.multiplyByScalar(s,l,i),e.add(u,i,i)}};var y=new e,E=new e,O=new e,_=new e,R=new e;m.rayTriangleParametric=function(t,i,u,s,c){if(!n(t))throw new o("ray is required.");if(!n(i))throw new o("p0 is required.");if(!n(u))throw new o("p1 is required.");if(!n(s))throw new o("p2 is required.");c=r(c,!1);var f,l,d,h,p,m=t.origin,w=t.direction,g=e.subtract(u,i,y),T=e.subtract(s,i,E),A=e.cross(w,T,O),b=e.dot(g,A);if(c){if(b<a.EPSILON6)return;if(f=e.subtract(m,i,_),d=e.dot(f,A),0>d||d>b)return;if(l=e.cross(f,g,R),h=e.dot(w,l),0>h||d+h>b)return;p=e.dot(T,l)/b}else{if(Math.abs(b)<a.EPSILON6)return;var C=1/b;if(f=e.subtract(m,i,_),d=e.dot(f,A)*C,0>d||d>1)return;if(l=e.cross(f,g,R),h=e.dot(w,l)*C,0>h||d+h>1)return;p=e.dot(T,l)*C}return p},m.rayTriangle=function(t,r,o,i,a,u){var s=m.rayTriangleParametric(t,r,o,i,a);if(n(s)&&!(0>s))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var w=new f;m.lineSegmentTriangle=function(t,r,i,a,u,s,c){if(!n(t))throw new o("v0 is required.");if(!n(r))throw new o("v1 is required.");if(!n(i))throw new o("p0 is required.");if(!n(a))throw new o("p1 is required.");if(!n(u))throw new o("p2 is required.");var f=w;e.clone(t,f.origin),e.subtract(r,t,f.direction),e.normalize(f.direction,f.direction);var l=m.rayTriangleParametric(f,i,a,u,s);return!n(l)||0>l||l>e.distance(t,r)?void 0:(n(c)||(c=new e),e.multiplyByScalar(f.direction,l,c),e.add(f.origin,c,c))};var g={root0:0,root1:0};m.raySphere=function(e,t,r){if(!n(e))throw new o("ray is required.");if(!n(t))throw new o("sphere is required.");return r=d(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var T=new f;m.lineSegmentSphere=function(t,r,i,a){if(!n(t))throw new o("p0 is required.");if(!n(r))throw new o("p1 is required.");if(!n(i))throw new o("sphere is required.");var u=T;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);return e.normalize(s,s),a=d(u,i,a),!n(a)||a.stop<0||a.start>c?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,c),a)};var A=new e,b=new e;m.rayEllipsoid=function(t,r){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("ellipsoid is required.");var a,u,s,c,f,l=r.oneOverRadii,d=e.multiplyComponents(l,t.origin,A),h=e.multiplyComponents(l,t.direction,b),p=e.magnitudeSquared(d),m=e.dot(d,h);if(p>1){if(m>=0)return;var y=m*m;if(a=p-1,u=e.magnitudeSquared(h),s=u*a,s>y)return;if(y>s){c=m*m-s,f=-m+Math.sqrt(c);var E=f/u,O=a/f;return O>E?new i(E,O):{start:O,stop:E}}var _=Math.sqrt(a/u);return new i(_,_)}return 1>p?(a=p-1,u=e.magnitudeSquared(h),s=u*a,c=m*m-s,f=-m+Math.sqrt(c),new i(0,f/u)):0>m?(u=e.magnitudeSquared(h),new i(0,-m/u)):void 0};var C=new e,v=new e,S=new e,I=new e,N=new e,M=new u,x=new u,P=new u,D=new u,F=new u,U=new u,q=new u,L=new e,B=new e,j=new t;m.grazingAltitudeLocation=function(t,r){if(!n(t))throw new o("ray is required.");if(!n(r))throw new o("ellipsoid is required.");var i=t.origin,s=t.direction;if(!e.equals(i,e.ZERO)){var c=r.geodeticSurfaceNormal(i,C);if(e.dot(s,c)>=0)return i}var f=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(s,C),d=e.normalize(l,l),h=e.mostOrthogonalAxis(l,I),m=e.normalize(e.cross(h,d,v),v),y=e.normalize(e.cross(d,m,S),S),E=M;E[0]=d.x,E[1]=d.y,E[2]=d.z,E[3]=m.x,E[4]=m.y,E[5]=m.z,E[6]=y.x,E[7]=y.y,E[8]=y.z;var O=u.transpose(E,x),_=u.fromScale(r.radii,P),R=u.fromScale(r.oneOverRadii,D),w=F;w[0]=0,w[1]=-s.z,w[2]=s.y,w[3]=s.z,w[4]=0,w[5]=-s.x,w[6]=-s.y,w[7]=s.x,w[8]=0;var g,T,A=u.multiply(u.multiply(O,R,U),w,U),b=u.multiply(u.multiply(A,_,q),E,q),z=u.multiplyByVector(A,i,N),G=p(b,e.negate(z,C),0,0,1),V=G.length;if(V>0){for(var W=e.clone(e.ZERO,B),X=Number.NEGATIVE_INFINITY,k=0;V>k;++k){g=u.multiplyByVector(_,u.multiplyByVector(E,G[k],L),L);var H=e.normalize(e.subtract(g,i,I),I),Y=e.dot(H,s);Y>X&&(X=Y,W=e.clone(g,W))}var K=r.cartesianToCartographic(W,j);return X=a.clamp(X,0,1),T=e.magnitude(e.subtract(W,i,I))*Math.sqrt(1-X*X),T=f?-T:T,K.height=T,r.cartographicToCartesian(K,new e)}};var z=new e;return m.lineSegmentPlane=function(t,r,i,u){if(!n(t))throw new o("endPoint0 is required.");if(!n(r))throw new o("endPoint1 is required.");if(!n(i))throw new o("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,z),c=i.normal,f=e.dot(c,s);if(!(Math.abs(f)<a.EPSILON6)){var l=e.dot(c,t),d=-(i.distance+l)/f;if(!(0>d||d>1))return e.multiplyByScalar(s,d,u),e.add(t,u,u),u}},m.trianglePlaneIntersection=function(t,r,i,a){if(!(n(t)&&n(r)&&n(i)&&n(a)))throw new o("p0, p1, p2, and plane are required.");var u=a.normal,s=a.distance,c=e.dot(u,t)+s<0,f=e.dot(u,r)+s<0,l=e.dot(u,i)+s<0,d=0;d+=c?1:0,d+=f?1:0,d+=l?1:0;var h,p;if((1===d||2===d)&&(h=new e,p=new e),1===d){if(c)return m.lineSegmentPlane(t,r,a,h),m.lineSegmentPlane(t,i,a,p),{positions:[t,r,i,h,p],indices:[0,3,4,1,2,4,1,4,3]};if(f)return m.lineSegmentPlane(r,i,a,h),m.lineSegmentPlane(r,t,a,p),{positions:[t,r,i,h,p],indices:[1,3,4,2,0,4,2,4,3]};if(l)return m.lineSegmentPlane(i,t,a,h),m.lineSegmentPlane(i,r,a,p),{positions:[t,r,i,h,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!c)return m.lineSegmentPlane(r,t,a,h),m.lineSegmentPlane(i,t,a,p),{positions:[t,r,i,h,p],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return m.lineSegmentPlane(i,r,a,h),m.lineSegmentPlane(t,r,a,p),{positions:[t,r,i,h,p],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return m.lineSegmentPlane(t,i,a,h),m.lineSegmentPlane(r,i,a,p),{positions:[t,r,i,h,p],indices:[0,1,4,0,4,3,2,3,4]}}},m}),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],function(e,t,r,n,o,i,a){"use strict";function u(r,o){if(t.typeOf.object("normal",r),!i.equalsEpsilon(e.magnitude(r),1,i.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",o),this.normal=e.clone(r),this.distance=o}u.fromPointNormal=function(o,a,s){if(t.typeOf.object("point",o),t.typeOf.object("normal",a),!i.equalsEpsilon(e.magnitude(a),1,i.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(a,o);return r(s)?(e.clone(a,s.normal),s.distance=c,s):new u(a,c)};var s=new e;u.fromCartesian4=function(o,a){t.typeOf.object("coefficients",o);var c=e.fromCartesian4(o,s),f=o.w;if(!i.equalsEpsilon(e.magnitude(c),1,i.EPSILON6))throw new n("normal must be normalized.");return r(a)?(e.clone(c,a.normal),a.distance=f,a):new u(c,f)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,o,i){t.typeOf.object("plane",n),t.typeOf.object("point",o),r(i)||(i=new e);var a=u.getPointDistance(n,o),s=e.multiplyByScalar(n.normal,a,c);return e.subtract(o,s,i)};var f=new e;return u.transform=function(r,n,o){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),a.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,f),a.multiplyByPoint(n,f,f),u.fromPointNormal(f,s,o)},u.clone=function(n,o){return t.typeOf.object("plane",n),r(o)?(e.clone(n.normal,o.normal),o.distance=n.distance,o):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=o(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=o(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=o(new u(e.UNIT_Y,0)),u}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var o,i,a=0,u=t.length-1;u>=a;)if(o=~~((a+u)/2),i=n(t[o],r),0>i)a=o+1;else{if(!(i>0))return o;u=o-1}return~(u+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,o){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=o}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],o=function(e,t,r,n){r||(r=" ");var o=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+o:o+e},i=function(e,t,r,n,i,a){var u=n-e.length;return u>0&&(e=r||!i?o(e,n,a,r):e.slice(0,t.length)+o("",u,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,n,a,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+o(c.toString(t),u||0,"0",!1),i(e,r,n,a,s)},u=function(e,t,r,n,o,a){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,o,a)},s=function(e,n,s,c,f,l,d){var h,p,m,y,E;if("%%"==e)return"%";for(var O=!1,_="",R=!1,w=!1,g=" ",T=s.length,A=0;s&&T>A;A++)switch(s.charAt(A)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":g=s.charAt(A+1);break;case"0":R=!0;break;case"#":w=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],d){case"s":return u(String(E),O,c,l,R,g);case"c":return u(String.fromCharCode(+E),O,c,l,R);case"b":return a(E,2,w,O,c,l,R);case"o":return a(E,8,w,O,c,l,R);case"x":return a(E,16,w,O,c,l,R);case"X":return a(E,16,w,O,c,l,R).toUpperCase();case"u":return a(E,10,w,O,c,l,R);case"i":case"d":return h=+E||0,h=Math.round(h-h%1),p=0>h?"-":_,E=p+o(String(Math.abs(h)),l,"0",!1),i(E,p,O,c,R);case"e":case"E":case"f":case"F":case"g":case"G":return h=+E,p=0>h?"-":_,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],y=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],E=p+Math.abs(h)[m](l),i(E,p,O,c,R)[y]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,o,i,a,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=o,this.second=i,this.millisecond=a,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,o,i,a,u,s,c){"use strict";function f(e,t){return m.compare(e.julianDate,t.julianDate)}function l(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,f);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var o=r[n].offset;if(n>0){var i=m.secondsDifference(r[n].julianDate,e);i>o&&(n--,o=r[n].offset)}m.addSeconds(e,o,e)}function d(e,r){_.julianDate=e;var n=m.leapSeconds,o=t(n,_,f);if(0>o&&(o=~o),0===o)return m.addSeconds(e,-n[0].offset,r);if(o>=n.length)return m.addSeconds(e,-n[o-1].offset,r);var i=m.secondsDifference(n[o].julianDate,e);return 0===i?m.addSeconds(e,-n[o].offset,r):1>=i?void 0:m.addSeconds(e,-n[--o].offset,r)}function h(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function p(e,t,r,n,o,i,a){var u=(t-14)/12|0,c=e+4800+u,f=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;n-=12,0>n&&(n+=24);var l=i+(n*s.SECONDS_PER_HOUR+o*s.SECONDS_PER_MINUTE+a*s.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}function m(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var o=0|e;t+=(e-o)*s.SECONDS_PER_DAY,h(o,t,this),n===c.UTC&&l(this)}var y=new i,E=[31,28,31,30,31,30,31,31,30,31,30,31],O=29,_=new u,R=/^(\d{4})$/,w=/^(\d{4})-(\d{2})$/,g=/^(\d{4})-?(\d{3})$/,T=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,A=/^(\d{4})-?(\d{2})-?(\d{2})$/,b=/([Z+\-])?(\d{2})?:?(\d{2})?$/,C=/^(\d{2})(\.\d+)?/.source+b.source,v=/^(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,S=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,I="Invalid ISO 8601 date.";m.fromGregorianDate=function(e,t){if(!(e instanceof i))throw new o("date must be a valid GregorianDate.");var r=p(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(h(r[0],r[1],t),l(t),t):new m(r[0],r[1],c.UTC)},m.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new o("date must be a valid JavaScript Date.");var r=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(h(r[0],r[1],t),l(t),t):new m(r[0],r[1],c.UTC)},m.fromIso8601=function(e,t){if("string"!=typeof e)throw new o(I);e=e.replace(",",".");var r,i,u,s=e.split("T"),f=1,d=1,y=0,_=0,b=0,N=0,M=s[0],x=s[1];if(!n(M))throw new o(I);var P;if(s=M.match(A),null!==s){if(P=M.split("-").length-1,P>0&&2!==P)throw new o(I);r=+s[1],f=+s[2],d=+s[3]}else if(s=M.match(w),null!==s)r=+s[1],f=+s[2];else if(s=M.match(R),null!==s)r=+s[1];else{var D;if(s=M.match(g),null!==s){if(r=+s[1],D=+s[2],u=a(r),1>D||u&&D>366||!u&&D>365)throw new o(I)}else{if(s=M.match(T),null===s)throw new o(I);r=+s[1];var F=+s[2],U=+s[3]||0;if(P=M.split("-").length-1,P>0&&(!n(s[3])&&1!==P||n(s[3])&&2!==P))throw new o(I);var q=new Date(Date.UTC(r,0,4));D=7*F+U-q.getUTCDay()-3}i=new Date(Date.UTC(r,0,1)),i.setUTCDate(D),f=i.getUTCMonth()+1,d=i.getUTCDate()}if(u=a(r),1>f||f>12||1>d||(2!==f||!u)&&d>E[f-1]||u&&2===f&&d>O)throw new o(I);var L;if(n(x)){if(s=x.match(S),null!==s){if(P=x.split(":").length-1,P>0&&2!==P&&3!==P)throw new o(I);y=+s[1],_=+s[2],b=+s[3],N=1e3*+(s[4]||0),L=5}else if(s=x.match(v),null!==s){if(P=x.split(":").length-1,P>2)throw new o(I);y=+s[1],_=+s[2],b=60*+(s[3]||0),L=4}else{if(s=x.match(C),null===s)throw new o(I);y=+s[1],_=60*+(s[2]||0),L=3}if(_>=60||b>=61||y>24||24===y&&(_>0||b>0||N>0))throw new o(I);var B=s[L],j=+s[L+1],z=+(s[L+2]||0);switch(B){case"+":y-=j,_-=z;break;case"-":y+=j,_+=z;break;case"Z":break;default:_+=new Date(Date.UTC(r,f-1,d,y,_)).getTimezoneOffset()}}var G=60===b;for(G&&b--;_>=60;)_-=60,y++;for(;y>=24;)y-=24,d++;for(i=u&&2===f?O:E[f-1];d>i;)d-=i,f++,f>12&&(f-=12,r++),i=u&&2===f?O:E[f-1];for(;0>_;)_+=60,y--;for(;0>y;)y+=24,d--;for(;1>d;)f--,1>f&&(f+=12,r--),i=u&&2===f?O:E[f-1],d+=i;var V=p(r,f,d,y,_,b,N);return n(t)?(h(V[0],V[1],t),l(t)):t=new m(V[0],V[1],c.UTC),G&&m.addSeconds(t,1,t),t},m.now=function(e){return m.fromDate(new Date,e)};var N=new m(0,0,c.TAI);return m.toGregorianDate=function(e,t){if(!n(e))throw new o("julianDate is required.");var r=!1,a=d(e,N);n(a)||(m.addSeconds(e,-1,N),a=d(N,N),r=!0);var u=a.dayNumber,c=a.secondsOfDay;c>=43200&&(u+=1);var f=u+68569|0,l=4*f/146097|0;f=f-((146097*l+3)/4|0)|0;var h=4e3*(f+1)/1461001|0;f=f-(1461*h/4|0)+31|0;var p=80*f/2447|0,y=f-(2447*p/80|0)|0;f=p/11|0;var E=p+2-12*f|0,O=100*(l-49)+h+f|0,_=c/s.SECONDS_PER_HOUR|0,R=c-_*s.SECONDS_PER_HOUR,w=R/s.SECONDS_PER_MINUTE|0;R-=w*s.SECONDS_PER_MINUTE;var g=0|R,T=(R-g)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(g+=1),n(t)?(t.year=O,t.month=E,t.day=y,t.hour=_,t.minute=w,t.second=g,t.millisecond=T,t.isLeapSecond=r,t):new i(O,E,y,_,w,g,T,r)},m.toDate=function(e){if(!n(e))throw new o("julianDate is required.");var t=m.toGregorianDate(e,y),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},m.toIso8601=function(t,r){if(!n(t))throw new o("julianDate is required.");var i=m.toGregorianDate(t,y),a=i.year,u=i.month,s=i.day,c=i.hour,f=i.minute,l=i.second,d=i.millisecond;1e4===a&&1===u&&1===s&&0===c&&0===f&&0===l&&0===d&&(a=9999,u=12,s=31,c=24);var h;return n(r)||0===d?n(r)&&0!==r?(h=(.01*d).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a,u,s,c,f,l,h)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a,u,s,c,f,l):(h=(.01*d).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a,u,s,c,f,l,h))},m.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new m(e.dayNumber,e.secondsOfDay,c.TAI):void 0},m.compare=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},m.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},m.equalsEpsilon=function(e,t,r){if(!n(r))throw new o("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(m.secondsDifference(e,t))<=r},m.totalDays=function(e){if(!n(e))throw new o("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},m.secondsDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},m.daysDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=e.dayNumber-t.dayNumber,i=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+i},m.computeTaiMinusUtc=function(e){_.julianDate=e;var r=m.leapSeconds,n=t(r,_,f);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},m.addSeconds=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("seconds is required.");if(!n(r))throw new o("result is required.");return h(e.dayNumber,e.secondsOfDay+t,r)},m.addMinutes=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("minutes is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,i,r)},m.addHours=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("hours is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,i,r)},m.addDays=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("days is required.");if(!n(r))throw new o("result is required.");var i=e.dayNumber+t;return h(i,e.secondsOfDay,r)},m.lessThan=function(e,t){return m.compare(e,t)<0},m.lessThanOrEquals=function(e,t){return m.compare(e,t)<=0},m.greaterThan=function(e,t){return m.compare(e,t)>0},m.greaterThanOrEquals=function(e,t){return m.compare(e,t)>=0},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.equalsEpsilon=function(e,t){return m.equalsEpsilon(this,e,t)},m.prototype.toString=function(){return m.toIso8601(this)},m.leapSeconds=[new u(new m(2441317,43210,c.TAI),10),new u(new m(2441499,43211,c.TAI),11),new u(new m(2441683,43212,c.TAI),12),new u(new m(2442048,43213,c.TAI),13),new u(new m(2442413,43214,c.TAI),14),new u(new m(2442778,43215,c.TAI),15),new u(new m(2443144,43216,c.TAI),16),new u(new m(2443509,43217,c.TAI),17),new u(new m(2443874,43218,c.TAI),18),new u(new m(2444239,43219,c.TAI),19),new u(new m(2444786,43220,c.TAI),20),new u(new m(2445151,43221,c.TAI),21),new u(new m(2445516,43222,c.TAI),22),new u(new m(2446247,43223,c.TAI),23),new u(new m(2447161,43224,c.TAI),24),new u(new m(2447892,43225,c.TAI),25),new u(new m(2448257,43226,c.TAI),26),new u(new m(2448804,43227,c.TAI),27),new u(new m(2449169,43228,c.TAI),28),new u(new m(2449534,43229,c.TAI),29),new u(new m(2450083,43230,c.TAI),30),new u(new m(2450630,43231,c.TAI),31),new u(new m(2451179,43232,c.TAI),32),new u(new m(2453736,43233,c.TAI),33),new u(new m(2454832,43234,c.TAI),34),new u(new m(2456109,43235,c.TAI),35),new u(new m(2457204,43236,c.TAI),36),new u(new m(2457754,43237,c.TAI),37)],m}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,r).replace(o,t)),this.path&&(this.path=this.path.replace(o,t)),this.query&&(this.query=this.query.replace(o,t)),this.fragment&&(this.fragment=this.fragment.replace(o,t))};var o=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var o=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var a=r[i];n&&(a=t(a,n)),o[i]=a}return o}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,o,i){i=e(i,!1);var a,u,s,c={},f=t(n),l=t(o);if(f)for(a in n)n.hasOwnProperty(a)&&(u=n[a],l&&i&&"object"==typeof u&&o.hasOwnProperty(a)?(s=o[a],"object"==typeof s?c[a]=r(u,s,i):c[a]=u):c[a]=u);if(l)for(a in o)o.hasOwnProperty(a)&&!c.hasOwnProperty(a)&&(s=o[a],c[a]=s);return c}return r}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function o(e,t){var r;return"undefined"!=typeof document&&(r=document),o._implementation(e,t,r)}return o._implementation=function(o,i,a){if(!r(o))throw new n("relative uri is required.");if(!r(i)){if("undefined"==typeof a)return o;i=t(a.baseURI,a.location.href)}var u=new e(i),s=new e(o);return s.resolve(u).toString()},o}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,o){if(!t(n))throw new r("uri is required.");var i="",a=n.lastIndexOf("/");return-1!==a&&(i=n.substring(0,a+1)),o?(n=new e(n),t(n.query)&&(i+="?"+n.query),t(n.fragment)&&(i+="#"+n.fragment),i):i}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(!t(n))throw new r("uri is required.");var o=new e(n);o.normalize();var i=o.path,a=i.lastIndexOf("/");return-1!==a&&(i=i.substr(a+1)),a=i.lastIndexOf("."),i=-1===a?"":i.substr(a+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,o=r.protocol;return r.href=t,r.href=r.href,o!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^data:/i;return t}),define("Core/loadAndExecuteScript",["../ThirdParty/when"],function(e){
"use strict";function t(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var o=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,o.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},o.appendChild(n),r.promise}return t}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("obj is required.");var o="";for(var i in n)if(n.hasOwnProperty(i)){var a=n[i],u=encodeURIComponent(i)+"=";if(r(a))for(var s=0,c=a.length;c>s;++s)o+=u+encodeURIComponent(a[s])+"&";else o+=u+encodeURIComponent(a)+"&"}return o=o.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("queryString is required.");var o={};if(""===n)return o;for(var i=n.replace(/\+/g,"%20").split(/[&;]/),a=0,u=i.length;u>a;++a){var s=i[a].split("="),c=decodeURIComponent(s[0]),f=s[1];f=e(f)?decodeURIComponent(f):"";var l=o[c];"string"==typeof l?o[c]=[l,f]:r(l)?l.push(f):o[c]=f}return o}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";var t={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5};return e(t)}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";var t={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3,PACK_TERRAIN:4,PACK_IMAGERY:5};return e(t)}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT);var o=e(t.throttleByServer,!1),i=e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=i,this.throttleByServer=o,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return o.prototype.cancel=function(){this.cancelled=!0},o.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new o(this)},o}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var o=r[n],i=o.indexOf(": ");if(i>0){var a=o.substring(0,i),u=o.substring(i+2);t[a]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function o(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,o=this._scopes,i=-1,a=0;a<n.length;a++)if(n[a]===t&&o[a]===r){i=a;break}return-1!==i?(this._insideRaiseEvent?(this._toRemove.push(i),n[i]=void 0,o[i]=void 0):(n.splice(i,1),o.splice(i,1)),!0):!1},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,i=r.length;for(e=0;i>e;e++){var a=r[e];t(a)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if(i=u.length,i>0){for(u.sort(o),e=0;i>e;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function o(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function i(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(o.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),o.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},o.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,o=this._array,a=-1,u=!0;u;){var s=2*(e+1),c=s-1;a=r>c&&n(o[c],o[e])<0?c:e,r>s&&n(o[s],o[a])<0&&(a=s),a!==e?(i(o,a,e),e=a):u=!1}},o.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},o.prototype.insert=function(t){e.defined("element",t);var n=this._array,o=this._comparator,a=this._maximumLength,u=this._length++;for(u<n.length?n[u]=t:n.push(t);0!==u;){var s=Math.floor((u-1)/2);if(!(o(n[u],n[s])<0))break;i(n,u,s),u=s}var c;return r(a)&&this._length>a&&(c=n[a],this._length=a),c},o.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,o=n[r];return i(n,r,--this._length),this.heapify(r),o}},o}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState","./RequestType"],function(e,t,r,n,o,i,a,u,s,c,f,l){"use strict";function d(e,t){return e.priority-t.priority}function h(){}function p(e){o(e.priorityFunction)&&(e.priority=e.priorityFunction())}function m(e){var t=n(h.requestsByServer[e],h.maximumRequestsPerServer);return M[e]<t}function y(e){var r=e.serverKey+"_"+e.providerName;if(o(h.packRequests[r])||(h.packRequests[r]=[]),!(h.packRequests[r].length>=F)){o(h.packRequestQuadKey[r])||(h.packRequestQuadKey[r]=[],h.quadKeyIndex[r]=0,h.totalPacketCount[r]=0,h.currentDeferIndex[r]=0),o(h.currentPacketCount[r])||(h.currentPacketCount[r]=0),o(h.packRequestPromise[r])||(h.packRequestPromise[r]=[t.defer()]),h.totalPacketCount[r]>=D&&(h.totalPacketCount[r]=0,h.currentDeferIndex[r]++,h.packRequestPromise[r].push(t.defer()));var n=h.currentDeferIndex[r];return e.deferred=h.packRequestPromise[r][n],e.state=f.ISSUED,h.packRequests[r].push(e),h.totalPacketCount[r]++,e.deferred.promise}}function E(){h.packRequests={},h.packRequestPromise={},h.packRequestQuadKey={},h.quadKeyIndex={},h.currentPacketCount={},h.totalPacketCount={},h.currentDeferIndex={}}function O(e){var t=e.serverKey+"_"+e.providerName,r=h.packRequestQuadKey[t],n=h.quadKeyIndex[t];o(r[n])?r[n]+=";"+e.quadKey:r[n]=e.quadKey,e.quadKeyIndex=h.currentPacketCount[t],++h.currentPacketCount[t],h.currentPacketCount[t]>=D&&(h.currentPacketCount[t]=0,h.quadKeyIndex[t]++)}function _(e,t){for(var r=D*t,n=0,o=e.length;o>n;n++)if(n>=r){var i=e[n];i.state=f.CANCELLED}}function R(){var t,r=h.packRequests;for(var n in r)if(r.hasOwnProperty(n)){t=void 0;for(var i=r[n],a=0,u=i.length;u>a;a++){var s=i[a];o(t)||(t=s),O(s)}var c;for(o(t)&&(c=t.url),a=0,u=h.packRequestQuadKey[n].length;u>a;a++){var f=h.packRequestQuadKey[n][a];if(-1===f.indexOf(";")&&(f+=";"+f),o(t)){if(t.throttleByServer&&!m(t.serverKey)){_(i,a),h.packRequestPromise[n][a].reject();continue}var l=t.clone();l.state=t.state,l.serverKey=t.serverKey,l.deferred=h.packRequestPromise[n][a],l.deferred.id=a;var d=new e(c);d.query=o(d.query)?d.query+"&extratiles="+f:"extratiles="+f,l.url=d.toString(),A(l,l.url)}}}E()}function w(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function g(e){return function(t){e.state!==f.CANCELLED&&(--v.numberOfActiveRequests,--M[e.serverKey],P.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}function T(e){return function(t){e.state!==f.CANCELLED&&(++v.numberOfFailedRequests,--v.numberOfActiveRequests,--M[e.serverKey],P.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}function A(e,t){var r=w(e);return e.state=f.ACTIVE,N.push(e),++v.numberOfActiveRequests,++v.numberOfActiveRequestsEver,++M[e.serverKey],e.requestFunction(t).then(g(e)).otherwise(T(e)),r}function b(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++v.numberOfCancelledRequests,e.deferred.reject(),t&&(--v.numberOfActiveRequests,--M[e.serverKey],++v.numberOfCancelledActiveRequests),o(e.cancelFunction)&&e.cancelFunction()}function C(){h.debugShowStatistics&&(0===v.numberOfActiveRequests&&v.lastNumberOfActiveRequests>0&&(v.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+v.numberOfAttemptedRequests),v.numberOfAttemptedRequests=0),v.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+v.numberOfCancelledRequests),v.numberOfCancelledRequests=0),v.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+v.numberOfCancelledActiveRequests),v.numberOfCancelledActiveRequests=0),v.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+v.numberOfFailedRequests),v.numberOfFailedRequests=0)),v.lastNumberOfActiveRequests=v.numberOfActiveRequests)}var v={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},S=20,I=new u({comparator:d});I.maximumLength=S,I.reserve(S);var N=[],M={},x="undefined"!=typeof document?new e(document.location.href):new e,P=new a;h.maximumRequests=50,h.maximumRequestsPerServer=6,h.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},h.throttleRequests=!0,h.debugShowStatistics=!1,h.requestCompletedEvent=P,i(h,{statistics:{get:function(){return v}},priorityHeapLength:{get:function(){return S},set:function(e){if(S>e)for(;I.length>e;){var t=I.pop();b(t)}S=e,I.maximumLength=e,I.reserve(e)}}});var D=20,F=120;return h.packRequests={},h.packRequestPromise={},h.packRequestQuadKey={},h.quadKeyIndex={},h.currentPacketCount={},h.totalPacketCount={},h.currentDeferIndex={},h.update=function(){var e,t,r=0,n=N.length;for(e=0;n>e;++e)t=N[e],t.cancelled&&b(t),t.state===f.ACTIVE?r>0&&(N[e-r]=t):++r;N.length-=r,R();var o=I.internalArray,i=I.length;for(e=0;i>e;++e)p(o[e]);I.resort();for(var a=Math.max(h.maximumRequests-N.length,0),u=0;a>u&&I.length>0;)t=I.pop(),t.cancelled?b(t):!t.throttleByServer||m(t.serverKey)?(A(t),++u):b(t);C()},h.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(x);n.normalize();var i=n.authority;/:/.test(i)||(i=i+":"+("https"===n.scheme?"443":"80"));var a=M[i];return o(a)||(M[i]=0),i},h.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return P.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++v.numberOfAttemptedRequests,o(e.serverKey)||(e.serverKey=h.getServerKey(e.url)),e.type>l.OTHER)return y(e);if(!e.throttleByServer||m(e.serverKey)){if(!h.throttleRequests||!e.throttle)return A(e);if(!(N.length>=h.maximumRequests)){p(e);var t=I.insert(e);if(o(t)){if(t===e)return;b(t)}return w(e)}}},h.clearForSpecs=function(){for(;I.length>0;){var e=I.pop();b(e)}for(var t=N.length,r=0;t>r;++r)b(N[r]);N.length=0,M={},v.numberOfAttemptedRequests=0,v.numberOfActiveRequests=0,v.numberOfCancelledRequests=0,v.numberOfCancelledActiveRequests=0,v.numberOfFailedRequests=0,v.numberOfActiveRequestsEver=0,v.lastNumberOfActiveRequests=0},h.numberOfActiveRequestsByServer=function(e){return M[e]},h.requestHeap=I,h}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var o=n.getAuthority();if(t(o)){if(-1!==o.indexOf("@")){var i=o.split("@");o=i[1]}if(-1===o.indexOf(":")){var a=n.getScheme();if(t(a)||(a=window.location.protocol,a=a.substring(0,a.length-1)),"http"===a)o+=":80";else{if("https"!==a)return;o+=":443"}}return o}}var o={},i={};return o.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])||(i[o]=!0)},o.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])&&delete i[o]},o.contains=function(e){if(!t(e))throw new r("url is required.");var o=n(e);return t(o)&&t(i[o])?!0:!1},o.clear=function(){i={}},o}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p,m,y,E,O,_,R,w,g,T,A,b){"use strict";function C(e,t,r,n){var o=e.query;if(!u(o)||0===o.length)return{};var i;if(-1===o.indexOf("=")){var a={};a[o]=void 0,i=a}else i=_(o);r?t._queryParameters=N(i,t._queryParameters,n):t._queryParameters=i,e.query=void 0}function v(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=O(r):e.query=n[0]}function S(e,t){return u(e)?u(e.clone)?e.clone():o(e):t}function I(e){if(e.state===T.ISSUED||e.state===T.ACTIVE)throw new A("The Resource is already being fetched.");e.state=T.UNISSUED,e.deferred=void 0}function N(e,t,r){if(!r)return i(e,t);var n=o(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var s=n[a],c=t[a];u(s)?(Array.isArray(s)||(s=n[a]=[s]),n[a]=s.concat(c)):n[a]=Array.isArray(c)?c.slice():c}return n}function M(t){t=a(t,a.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=S(t.templateValues,{}),this._queryParameters=S(t.queryParameters,{}),this.headers=S(t.headers,{}),this.request=a(t.request,new R),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=a(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);C(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function x(e){var r=e.resource,n=e.flipY,o=e.preferImageBitmap,i=r.request;i.url=r.url,i.requestFunction=function(){var e=r.url,i=!1;r.isDataUri||r.isBlobUri||(i=r.isCrossOriginUrl);var a=t.defer();return M._Implementations.createImage(e,i,a,n,o),a.promise};var a=g.request(i);return u(a)?a.otherwise(function(e){return i.state!==T.FAILED?t.reject(e):r.retryOnError(e).then(function(a){return a?(i.state=T.UNISSUED,i.deferred=void 0,x({resource:r,flipY:n,preferImageBitmap:o})):t.reject(e)})}):void 0}function P(e,r,n){var o={};o[r]=n,e.setQueryParameters(o);var i=e.request;i.url=e.url,i.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(t){window[n]=void 0}},M._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var a=g.request(i);return u(a)?a.otherwise(function(o){return i.state!==T.FAILED?t.reject(o):e.retryOnError(o).then(function(a){return a?(i.state=T.UNISSUED,i.deferred=void 0,P(e,r,n)):t.reject(o)})}):void 0}function D(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function F(e,t){for(var r=D(e,t),n=new ArrayBuffer(r.length),o=new Uint8Array(n),i=0;i<r.length;i++)o[i]=r.charCodeAt(i);return n}function U(e,t){t=a(t,"");var r=e[1],n=!!e[2],o=e[3];switch(t){case"":case"text":return D(n,o);case"arraybuffer":return F(n,o);case"blob":var i=F(n,o);return new Blob([i],{type:r});case"document":var u=new DOMParser;return u.parseFromString(D(n,o),r);case"json":return JSON.parse(D(n,o));default:throw new c("Unhandled responseType: "+t)}}function q(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(b.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e}function L(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function B(e,t,r,n,o,i,a){var u=global.require,s=u("url").parse(e),c=u("https:"===s.protocol?"https":"http"),f=u("zlib"),l={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:r,headers:o};c.request(l).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void i.reject(new w(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?f.gunzip(n,function(e,r){e?i.reject(new A("Error decompressing response.")):i.resolve(L(r,t))}):i.resolve(L(n,t))})}).on("error",function(e){i.reject(new w)}).end()}var j=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();M.createIfNeeded=function(e){return e instanceof M?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new M({url:e})};var z;M.supportsImageBitmapOptions=function(){if(u(z))return z;if("function"!=typeof createImageBitmap)return z=t.resolve(!1);var e="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg==";return z=M.fetchBlob({url:e}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},s(M,{isBlobSupported:{get:function(){return j}}}),s(M.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);C(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return h(this._url)}},isDataUri:{get:function(){return y(this._url)}},isBlobUri:{get:function(){return p(this._url)}},isCrossOriginUrl:{get:function(){return m(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),M.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&v(n,this);var o=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),i=this._templateValues;return o=o.replace(/{(.*?)}/g,function(e,t){var r=i[t];return u(r)?encodeURIComponent(r):e}),r&&u(this.proxy)&&(o=this.proxy.getURL(o)),o},M.prototype.setQueryParameters=function(e,t){t?this._queryParameters=N(this._queryParameters,e,!1):this._queryParameters=N(e,this._queryParameters,!1)},M.prototype.appendQueryParameters=function(e){this._queryParameters=N(e,this._queryParameters,!0)},M.prototype.setTemplateValues=function(e,t){t?this._templateValues=i(this._templateValues,e):this._templateValues=i(e,this._templateValues)},M.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url),o=a(t.preserveQueryParameters,!1);C(n,r,!0,o),n.fragment=void 0,r._url=n.resolve(new e(l(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=i(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=i(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=i(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},M.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},M.prototype.clone=function(e){return u(e)||(e=new M({url:this._url})),e._url=this._url,e._queryParameters=o(this._queryParameters),e._templateValues=o(this._templateValues),e.headers=o(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},M.prototype.getBaseUri=function(e){return d(this.getUrlComponent(e),e)},M.prototype.appendForwardSlash=function(){this._url=r(this._url)},M.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},M.fetchArrayBuffer=function(e){var t=new M(e);return t.fetchArrayBuffer()},M.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},M.fetchBlob=function(e){var t=new M(e);return t.fetchBlob()},M.prototype.fetchImage=function(e){e=a(e,a.EMPTY_OBJECT);var r=a(e.preferImageBitmap,!1),n=a(e.preferBlob,!1),o=a(e.flipY,!1);if(I(this.request),!j||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return x({resource:this,flipY:o,preferImageBitmap:r});var i=this.fetchBlob();if(u(i)){var s,c,f,l;return M.supportsImageBitmapOptions().then(function(e){return s=e,c=s&&r,i}).then(function(e){if(u(e)){if(l=e,c)return M.createImageBitmapFromBlob(e,{flipY:o,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return f=new M({url:t}),x({resource:f,flipY:o,preferImageBitmap:!1})}}).then(function(e){return u(e)?(e.blob=l,c?e:(window.URL.revokeObjectURL(f.url),e)):void 0}).otherwise(function(e){return u(f)&&window.URL.revokeObjectURL(f.url),e.blob=l,t.reject(e)})}},M.fetchImage=function(e){var t=new M(e);return t.fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},M.prototype.fetchText=function(){return this.fetch({responseType:"text"})},M.fetchText=function(e){var t=new M(e);return t.fetchText()},M.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then(function(e){return u(e)?JSON.parse(e):void 0})},M.fetchJson=function(e){var t=new M(e);return t.fetchJson()},M.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},M.fetchXML=function(e){var t=new M(e);return t.fetchXML()},M.prototype.fetchJsonp=function(e){e=a(e,"callback"),I(this.request);var t;do t="loadJsonp"+Math.random().toString().substring(2,8);while(u(window[t]));return P(this,e,t)},M.fetchJsonp=function(e){var t=new M(e);return t.fetchJsonp(e.callbackParameterName)},M.prototype._makeRequest=function(e){var r=this;I(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(o){var a=e.responseType,s=i(e.headers,r.headers),c=e.overrideMimeType,f=e.method,l=e.data,d=t.defer(),h=u(o)?o:r.url,p=M._Implementations.loadWithXhr(h,a,f,l,s,d,c);return u(p)&&u(p.abort)&&(n.cancelFunction=function(){p.abort()}),d.promise};var o=g.request(n);return u(o)?o.then(function(e){return e}).otherwise(function(o){return n.state!==T.FAILED?t.reject(o):r.retryOnError(o).then(function(i){return i?(n.state=T.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(o)})}):void 0};var G=/^data:(.*?)(;base64)?,(.*)$/;M.prototype.fetch=function(e){return e=S(e,{}),e.method="GET",this._makeRequest(e)},M.fetch=function(e){var t=new M(e);return t.fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype["delete"]=function(e){return e=S(e,{}),e.method="DELETE",this._makeRequest(e)},M["delete"]=function(e){var t=new M(e);return t["delete"]({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},M.prototype.head=function(e){return e=S(e,{}),e.method="HEAD",this._makeRequest(e)},M.head=function(e){var t=new M(e);return t.head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.options=function(e){return e=S(e,{}),e.method="OPTIONS",this._makeRequest(e)},M.options=function(e){var t=new M(e);return t.options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.post=function(e,t){return n.defined("data",e),t=S(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},M.post=function(e){var t=new M(e);return t.post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.put=function(e,t){return n.defined("data",e),t=S(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},M.put=function(e){var t=new M(e);return t.put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.patch=function(e,t){return n.defined("data",e),t=S(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},M.patch=function(e){var t=new M(e);return t.patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M._Implementations={},M._Implementations.createImage=function(e,t,r,n,o){M.supportsImageBitmapOptions().then(function(n){return n&&o?M.fetchBlob({url:e}):void q(e,t,r)}).then(function(e){return u(e)?M.createImageBitmapFromBlob(e,{flipY:n,premultiplyAlpha:!1}):void 0}).then(function(e){u(e)&&r.resolve(e)}).otherwise(r.reject)},M.createImageBitmapFromBlob=function(e,t){return n.defined("options",t),n.typeOf.bool("options.flipY",t.flipY),n.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var V="undefined"==typeof XMLHttpRequest;return M._Implementations.loadWithXhr=function(e,t,r,n,o,i,a){var s=G.exec(e);if(null!==s)return void i.resolve(U(s,t));if(V)return void B(e,t,r,n,o,i,a);var c=new XMLHttpRequest;if(b.contains(e)&&(c.withCredentials=!0),e=e.replace(/{/g,"%7B").replace(/}/g,"%7D"),c.open(r,e,!0),u(a)&&u(c.overrideMimeType)&&c.overrideMimeType(a),u(o))for(var f in o)o.hasOwnProperty(f)&&c.setRequestHeader(f,o[f]);u(t)&&(c.responseType=t);var l=!1;return"string"==typeof e&&(l=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!l||0!==c.status))return void i.reject(new w(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var o=c.getAllResponseHeaders(),a=o.trim().split(/[\r\n]+/),s={};return a.forEach(function(e){var t=e.split(": "),r=t.shift();s[r]=t.join(": ")}),void i.resolve(s)}if(204===c.status)i.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{i.resolve(JSON.parse(e))}catch(f){i.reject(f)}else(""===n||"document"===n)&&u(c.responseXML)&&c.responseXML.hasChildNodes()?i.resolve(c.responseXML):""!==n&&"text"!==n||!u(c.responseText)?i.reject(new A("Invalid XMLHttpRequest response type.")):i.resolve(c.responseText);else i.resolve(e)},c.onerror=function(e){i.reject(new w)},c.send(n),c},M._Implementations.loadAndExecuteScript=function(e,t,r){return E(e,t).otherwise(r.reject)},M._DefaultImplementations={},M._DefaultImplementations.createImage=M._Implementations.createImage,M._DefaultImplementations.loadWithXhr=M._Implementations.loadWithXhr,M._DefaultImplementations.loadAndExecuteScript=M._Implementations.loadAndExecuteScript,M.DEFAULT=f(new M({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),M}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,o,i,a,u,s,c,f,l){"use strict";function d(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))p(this,t.data);else if(n(t.url)){var o=s.createIfNeeded(t.url),i=this;this._downloadPromise=e(o.fetchJson(),function(e){p(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+o.url+"."})}else p(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return a.compare(e.julianDate,t)}function p(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var o=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>o||0>i||0>s||0>c||0>d||0>p||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var y=e._samples=r.samples,E=e._dates=[];e._dateColumn=o,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=m,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var O,_=e._addNewLeapSeconds,R=0,w=y.length;w>R;R+=e._columnCount){var g=y[R+o],T=y[R+m],A=g+f.MODIFIED_JULIAN_DATE_DIFFERENCE,b=new a(A,T,l.TAI);if(E.push(b),_){if(T!==O&&n(O)){var C=a.leapSeconds,v=t(C,b,h);if(0>v){var S=new u(b,T);C.splice(~v,0,S)}}O=T}}}function m(e,t,r,n,o){var i=r*n;o.xPoleWander=t[i+e._xPoleWanderRadiansColumn],o.yPoleWander=t[i+e._yPoleWanderRadiansColumn],o.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],o.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],o.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function y(e,t,r){return t+e*(r-t)}function E(e,t,r,n,o,i,u){var s=e._columnCount;if(i>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[o],f=t[i];if(c.equals(f)||n.equals(c))return m(e,r,o,s,u),u;if(n.equals(f))return m(e,r,i,s,u),u;var l=a.secondsDifference(n,c)/a.secondsDifference(f,c),d=o*s,h=i*s,p=r[d+e._ut1MinusUtcSecondsColumn],E=r[h+e._ut1MinusUtcSecondsColumn],O=E-p;if(O>.5||-.5>O){var _=r[d+e._taiMinusUtcSecondsColumn],R=r[h+e._taiMinusUtcSecondsColumn];_!==R&&(f.equals(n)?p=E:E-=R-_)}return u.xPoleWander=y(l,r[d+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=y(l,r[d+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=y(l,r[d+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=y(l,r[d+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=y(l,p,E),u}return d.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new o(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new o(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,u=this._lastIndex,s=0,f=0;if(n(u)){var l=i[u],d=i[u+1],h=a.lessThanOrEquals(l,e),p=!n(d),m=p||a.greaterThanOrEquals(d,e);
if(h&&m)return s=u,!p&&d.equals(e)&&++s,f=s+1,E(this,i,this._samples,e,s,f,r),r}var y=t(i,e,a.compare,this._dateColumn);return y>=0?(y<i.length-1&&i[y+1].equals(e)&&++y,s=y,f=y):(f=~y,s=f-1,0>s&&(s=0)),this._lastIndex=s,E(this,i,this._samples,e,s,f,r),r}if(n(this._dataError))throw new c(this._dataError)},d}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function o(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return o.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new o);var i=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,a),n.pitch=-Math.asin(i),n},o.fromDegrees=function(e,i,a,u){if(!t(e))throw new r("heading is required");if(!t(i))throw new r("pitch is required");if(!t(a))throw new r("roll is required");return t(u)||(u=new o),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=i*n.RADIANS_PER_DEGREE,u.roll=a*n.RADIANS_PER_DEGREE,u},o.clone=function(e,r){return t(e)?t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new o(e.heading,e.pitch,e.roll):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},o.equalsEpsilon=function(e,r,o,i){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,o,i)&&n.equalsEpsilon(e.pitch,r.pitch,o,i)&&n.equalsEpsilon(e.roll,r.roll,o,i)},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},o}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],function(e,t,r,n,o){"use strict";function i(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),o=p.exec(n);if(null!==o)return o[1]}}function a(t){return"undefined"==typeof document?t:(e(l)||(l=document.createElement("a")),l.href=t,l.href=l.href,l.href)}function u(){if(e(d))return d;var u;if(u="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?r("..",f("Core/buildModuleUrl.js")):i(),!e(u))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return d=new n({url:a(u)}),d.appendForwardSlash(),d}function s(e){return a(o.toUrl("../"+e))}function c(e){var t=u().getDerivedResource({url:e});return t.url}function f(t){e(h)||(h=e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?s:c);var r=h(t);return r}var l,d,h,p=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return f._cesiumScriptRegex=p,f._buildModuleUrlFromBaseUrl=c,f._clearBaseResource=function(){d=void 0},f.setBaseUrl=function(e){d=n.DEFAULT.getDerivedResource({url:e})},f.getCesiumBaseUrl=u,f}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,o,i,a,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=a.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),o=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;t>=c;++c){n[c]=s,o[c]=c*this._stepSizeDays;for(var f=0;t>=f;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=l;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function f(r,o){if(r._chunkDownloadsInProgress[o])return r._chunkDownloadsInProgress[o];var i=e.defer();r._chunkDownloadsInProgress[o]=i;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.getDerivedResource({templateValues:{0:o}}):new a({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+o+".json")}),e(u.fetchJson(),function(e){r._chunkDownloadsInProgress[o]=!1;for(var t=r._samples,n=e.samples,a=o*r._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)t[a+u]=n[u];i.resolve()}),i.promise}var l=new i(0,0,u.TAI);return s.prototype.preload=function(t,r,n,o){var i=c(this,t,r),a=c(this,n,o),u=i/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var l=u/this._samplesPerXysFile|0,d=s/this._samplesPerXysFile|0,h=[],p=l;d>=p;++p)h.push(f(this,p));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var i=c(this,e,t);if(!(0>i)){var a=i/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var u=this._interpolationOrder,s=a-(u/2|0);0>s&&(s=0);var l=s+u;l>=this._totalSamples&&(l=this._totalSamples-1,s=l-u,0>s&&(s=0));var d=!1,h=this._samples;if(n(h[3*s])||(f(this,s/this._samplesPerXysFile|0),d=!0),n(h[3*l])||(f(this,l/this._samplesPerXysFile|0),d=!0),!d){n(r)?(r.x=0,r.y=0,r.s=0):r=new o(0,0,0);var p,m,y=i-s*this._stepSizeDays,E=this._work,O=this._denominators,_=this._coef,R=this._xTable;for(p=0;u>=p;++p)E[p]=y-R[p];for(p=0;u>=p;++p){for(_[p]=1,m=0;u>=m;++m)m!==p&&(_[p]*=E[m]);_[p]*=O[p];var w=3*(s+p);r.x+=_[p]*h[w++],r.y+=_[p]*h[w++],r.s+=_[p]*h[w]}return r}}}},s}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,o,i,a,u){"use strict";function s(e,t,n,o){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(o,0)}var c=new e;s.fromAxisAngle=function(r,o,i){t.typeOf.object("axis",r),t.typeOf.number("angle",o);var a=o/2,u=Math.sin(a);c=e.normalize(r,c);var f=c.x*u,l=c.y*u,d=c.z*u,h=Math.cos(a);return n(i)?(i.x=f,i.y=l,i.z=d,i.w=h,i):new s(f,l,d,h)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var o,i,a,c,d,h=e[u.COLUMN0ROW0],p=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],y=h+p+m;if(y>0)o=Math.sqrt(y+1),d=.5*o,o=.5/o,i=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*o,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*o,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*o;else{var E=f,O=0;p>h&&(O=1),m>h&&m>p&&(O=2);var _=E[O],R=E[_];o=Math.sqrt(e[u.getElementIndex(O,O)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(R,R)]+1);var w=l;w[O]=.5*o,o=.5/o,d=(e[u.getElementIndex(R,_)]-e[u.getElementIndex(_,R)])*o,w[_]=(e[u.getElementIndex(_,O)]+e[u.getElementIndex(O,_)])*o,w[R]=(e[u.getElementIndex(R,O)]+e[u.getElementIndex(O,R)])*o,i=-w[0],a=-w[1],c=-w[2]}return n(r)?(r.x=i,r.y=a,r.z=c,r.w=d,r):new s(i,a,c,d)};var d=new s,h=new s,p=new s,m=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),m=s.fromAxisAngle(e.UNIT_X,r.roll,d),p=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(p,m,p),h=s.fromAxisAngle(e.UNIT_Z,-r.heading,d),s.multiply(h,n,n)};var y=new e,E=new e,O=new s,_=new s,R=new s;s.packedLength=4,s.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.x,n[o++]=e.y,n[o++]=e.z,n[o]=e.w,n},s.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new s),i.x=e[o],i.y=e[o+1],i.z=e[o+2],i.w=e[o+3],i},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,R),s.conjugate(R,R);for(var o=0,i=r-t+1;i>o;o++){var a=3*o;s.unpack(e,4*(t+o),O),s.multiply(O,R,O),O.w<0&&s.negate(O,O),s.computeAxis(O,y);var u=s.computeAngle(O);n[a]=y.x*u,n[a+1]=y.y*u,n[a+2]=y.z*u}},s.unpackInterpolationResult=function(t,r,o,i,a){n(a)||(a=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*i,_),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(E,u,O),s.multiply(O,_,a)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),o=e.x*n,i=e.y*n,a=e.z*n,u=e.w*n;return r.x=o,r.y=i,r.z=a,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e.x,i=e.y,a=e.z,u=e.w,s=r.x,c=r.y,f=r.z,l=r.w,d=u*s+o*l+i*f-a*c,h=u*c-o*f+i*l+a*s,p=u*f+o*c-i*s+a*l,m=u*l-o*s-i*c-a*f;return n.x=d,n.y=h,n.z=p,n.w=m,n},s.multiplyByVec=function(t,r,n){var o=new e,i=new e,a=new e(t.x,t.y,t.z);o=e.cross(a,r,o),i=e.cross(a,o,i);var u=new e;u=e.multiplyByScalar(o,2*t.w,u);var s=new e;return s=e.multiplyByScalar(o,2,s),n=e.add(r,u,n),n=e.add(n,s,n)},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-n*n);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var w=new s;s.lerp=function(e,r,n,o){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o),w=s.multiplyByScalar(r,n,w),o=s.multiplyByScalar(e,1-n,o),s.add(w,o,o)};var g=new s,T=new s,A=new s;s.slerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i=s.dot(e,r),u=r;if(0>i&&(i=-i,u=g=s.negate(r,g)),1-i<a.EPSILON6)return s.lerp(e,u,n,o);var c=Math.acos(i);return T=s.multiplyByScalar(e,Math.sin((1-n)*c),T),A=s.multiplyByScalar(u,Math.sin(n*c),A),o=s.add(T,A,o),s.multiplyByScalar(o,1/Math.sin(c),o)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var o=a.acosClamped(r.w),i=0;return 0!==o&&(i=o/Math.sin(o)),e.multiplyByScalar(r,i,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=e.magnitude(r),i=0;return 0!==o&&(i=Math.sin(o)/o),n.x=r.x*i,n.y=r.y*i,n.z=r.z*i,n.w=Math.cos(o),n};var b=new e,C=new e,v=new s,S=new s;s.computeInnerQuadrangle=function(r,n,o,i){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",o),t.typeOf.object("result",i);var a=s.conjugate(n,v);s.multiply(a,o,S);var u=s.log(S,b);s.multiply(a,r,S);var c=s.log(S,C);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,v),s.multiply(n,v,i)},s.squad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var u=s.slerp(e,r,i,v),c=s.slerp(n,o,i,S);return s.slerp(u,c,2*i*(1-i),a)};for(var I=new s,N=1.9011074535173003,M=o.supportsTypedArrays()?new Float32Array(8):[],x=o.supportsTypedArrays()?new Float32Array(8):[],P=o.supportsTypedArrays()?new Float32Array(8):[],D=o.supportsTypedArrays()?new Float32Array(8):[],F=0;7>F;++F){var U=F+1,q=2*U+1;M[F]=1/(U*q),x[F]=U/q}return M[7]=N/136,x[7]=8*N/17,s.fastSlerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i,a=s.dot(e,r);a>=0?i=1:(i=-1,a=-a);for(var u=a-1,c=1-n,f=n*n,l=c*c,d=7;d>=0;--d)P[d]=(M[d]*f-x[d])*u,D[d]=(M[d]*l-x[d])*u;var h=i*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),p=c*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),m=s.multiplyByScalar(e,p,I);return s.multiplyByScalar(r,h,o),s.add(m,o,o)},s.fastSquad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var u=s.fastSlerp(e,r,i,v),c=s.fastSlerp(n,o,i,S);return s.fastSlerp(u,c,2*i*(1-i),a)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=o&&Math.abs(e.y-r.y)<=o&&Math.abs(e.z-r.z)<=o&&Math.abs(e.w-r.w)<=o},s.ZERO=i(new s(0,0,0,0)),s.IDENTITY=i(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p,m,y,E,O,_,R){"use strict";var w={},g={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},T={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},A={},b={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},C=new r,v=new r,S=new r;w.localFrameToFixedFrameGenerator=function(e,t){if(!g.hasOwnProperty(e)||!g[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,o=g[e][t],i=e+t;return u(A[i])?n=A[i]:(n=function(n,i,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),y.equalsEpsilon(n.x,0,y.EPSILON14)&&y.equalsEpsilon(n.y,0,y.EPSILON14)){var f=y.sign(n.z);r.unpack(T[e],0,C),"east"!==e&&"west"!==e&&r.multiplyByScalar(C,f,C),r.unpack(T[t],0,v),"east"!==t&&"west"!==t&&r.multiplyByScalar(v,f,v),r.unpack(T[o],0,S),"east"!==o&&"west"!==o&&r.multiplyByScalar(S,f,S)}else{i=a(i,l.WGS84),i.geodeticSurfaceNormal(n,b.up);var d=b.up,h=b.east;h.x=-n.y,h.y=n.x,h.z=0,r.normalize(h,b.east),r.cross(d,h,b.north),r.multiplyByScalar(b.up,-1,b.down),r.multiplyByScalar(b.east,-1,b.west),r.multiplyByScalar(b.north,-1,b.south),C=b[e],v=b[t],S=b[o]}return c[0]=C.x,c[1]=C.y,c[2]=C.z,c[3]=0,c[4]=v.x,c[5]=v.y,c[6]=v.z,c[7]=0,c[8]=S.x,c[9]=S.y,c[10]=S.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},A[i]=n),n},w.eastNorthUpToFixedFrame=w.localFrameToFixedFrameGenerator("east","north"),w.northEastDownToFixedFrame=w.localFrameToFixedFrameGenerator("north","east"),w.northUpEastToFixedFrame=w.localFrameToFixedFrameGenerator("north","up"),w.northWestUpToFixedFrame=w.localFrameToFixedFrameGenerator("north","west");var I=new _,N=new r(1,1,1),M=new O;w.headingPitchRollToFixedFrame=function(e,t,n,o,u){i.typeOf.object("HeadingPitchRoll",t),o=a(o,w.eastNorthUpToFixedFrame);var s=_.fromHeadingPitchRoll(t,I),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,N,M);return u=o(e,n,u),O.multiply(u,c,u)};var x=new O,P=new E;w.headingPitchRollQuaternion=function(e,t,r,n,o){i.typeOf.object("HeadingPitchRoll",t);var a=w.headingPitchRollToFixedFrame(e,t,r,n,x),u=O.getRotation(a,P);return _.fromRotationMatrix(u,o)};var D=new r(1,1,1),F=new r,U=new O,q=new O,L=new E,B=new _;w.fixedFrameToHeadingPitchRoll=function(e,t,n,o){i.defined("transform",e),t=a(t,l.WGS84),n=a(n,w.eastNorthUpToFixedFrame),u(o)||(o=new d);var s=O.getTranslation(e,F);if(r.equals(s,r.ZERO))return o.heading=0,o.pitch=0,o.roll=0,o;var c=O.inverseTransformation(n(s,t,U),U),f=O.setScale(e,D,q);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var h=_.fromRotationMatrix(O.getRotation(c,L),B);return h=_.normalize(h,h),d.fromQuaternion(h,o)};var j=24110.54841,z=8640184.812866,G=.093104,V=-62e-7,W=1.1772758384668e-19,X=72921158553e-15,k=y.TWO_PI/86400,H=new m;w.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");H=m.addSeconds(e,-m.computeTaiMinusUtc(e),H);var r,n=H.dayNumber,o=H.secondsOfDay,i=n-2451545;r=o>=43200?(i+.5)/R.DAYS_PER_JULIAN_CENTURY:(i-.5)/R.DAYS_PER_JULIAN_CENTURY;var a=j+r*(z+r*(G+r*V)),c=a*k%y.TWO_PI,f=X+W*(n-2451545.5),l=(o+.5*R.SECONDS_PER_DAY)%R.SECONDS_PER_DAY,d=c+f*l,h=Math.cos(d),p=Math.sin(d);return u(t)?(t[0]=h,t[1]=-p,t[2]=0,t[3]=p,t[4]=h,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(h,p,0,-p,h,0,0,0,1)},w.iau2006XysData=new h,w.earthOrientationParameters=c.NONE;var Y=32.184,K=2451545;w.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+Y,o=t.stop.dayNumber,i=t.stop.secondsOfDay+Y,a=w.iau2006XysData.preload(r,n,o,i),u=w.earthOrientationParameters.getPromiseToLoad();return e.all([a,u])},w.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=w.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var Z=new p(0,0,0),Q=new f(0,0,0,0,0,0),J=new E,$=new E;w.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=w.earthOrientationParameters.compute(e,Q);if(u(r)){var n=e.dayNumber,o=e.secondsOfDay+Y,i=w.iau2006XysData.computeXysRadians(n,o,Z);if(u(i)){var a=i.x+r.xPoleOffset,c=i.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-a*a-c*c)),l=J;l[0]=1-f*a*a,l[3]=-f*a*c,l[6]=a,l[1]=-f*a*c,l[4]=1-f*c*c,l[7]=c,l[2]=-a,l[5]=-c,l[8]=1-f*(a*a+c*c);var d=E.fromRotationZ(-i.s,$),h=E.multiply(l,d,J),p=e.dayNumber,O=e.secondsOfDay-m.computeTaiMinusUtc(e)+r.ut1MinusUtc,_=p-2451545,g=O/R.SECONDS_PER_DAY,T=.779057273264+g+.00273781191135448*(_+g);T=T%1*y.TWO_PI;var A=E.fromRotationZ(T,$),b=E.multiply(h,A,J),C=Math.cos(r.xPoleWander),v=Math.cos(r.yPoleWander),S=Math.sin(r.xPoleWander),I=Math.sin(r.yPoleWander),N=n-K+o/R.SECONDS_PER_DAY;N/=36525;var M=-47e-6*N*y.RADIANS_PER_DEGREE/3600,x=Math.cos(M),P=Math.sin(M),D=$;return D[0]=C*x,D[1]=C*P,D[2]=S,D[3]=-v*P+I*S*x,D[4]=v*x+I*S*P,D[5]=-I*C,D[6]=-I*P-v*S*x,D[7]=I*x-v*S*P,D[8]=v*C,E.multiply(b,D,t)}}};var ee=new n;w.pointToWindowCoordinates=function(e,t,r,n){return n=w.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},w.pointToGLWindowCoordinates=function(e,r,o,i){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(o))throw new s("point is required.");u(i)||(i=new t);var a=ee;return O.multiplyByVector(e,n.fromElements(o.x,o.y,o.z,1,a),a),n.multiplyByScalar(a,1/a.w,a),O.multiplyByVector(r,a,a),t.fromCartesian4(a,i)};var te=new r,re=new r,ne=new r;w.rotationMatrixFromPositionVelocity=function(e,t,n,o){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var i=a(n,l.WGS84).geodeticSurfaceNormal(e,te),c=r.cross(t,i,re);r.equalsEpsilon(c,r.ZERO,y.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,ne);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),u(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=c.x,o[4]=c.y,o[5]=c.z,o[6]=f.x,o[7]=f.y,o[8]=f.z,o};var oe=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),ie=new o,ae=new r,ue=new r,se=new E,ce=new O,fe=new O;return w.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var o=O.getTranslation(t,ue),i=e.ellipsoid,a=i.cartesianToCartographic(o,ie),c=e.project(a,ae);r.fromElements(c.z,c.x,c.y,c);var f=w.eastNorthUpToFixedFrame(o,i,ce),l=O.inverseTransformation(f,fe),d=O.getRotation(t,se),h=O.multiplyByMatrix3(l,d,n);return O.multiply(oe,h,n),O.setTranslation(n,c,n),n},w.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var o=e.ellipsoid,i=w.eastNorthUpToFixedFrame(t,o,ce),a=O.inverseTransformation(i,fe),c=o.cartesianToCartographic(t,ie),f=e.project(c,ae);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,ce);return O.multiply(oe,a,n),O.multiply(l,n,n),n},w.buildUp=function(e,t){var n=t.clone(),o=e.clone();o=r.normalize(o,o),Math.abs(r.dot(o,n))>=1&&(o=Math.abs(r.dot(n,r.UNIT_Y))<1?r.clone(r.UNIT_Y,o):r.clone(r.UNIT_Z,o));var i=new r;return r.cross(o,n,i),i=r.normalize(i,i),r.cross(n,i,o),o=r.normalize(o,o)},w.getHeading=function(e,t){var r;return r=y.equalsEpsilon(Math.abs(e.z),1,y.EPSILON3)?Math.atan2(t.y,t.x)-y.PI_OVER_TWO:Math.atan2(e.y,e.x)-y.PI_OVER_TWO,y.TWO_PI-y.zeroToTwoPi(r)},w}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p){"use strict";function m(e,t){if(o.defined("origin",e),t=i(t,c.WGS84),e=t.scaleToGeodeticSurface(e),!a(e))throw new s("origin must not be at the center of the ellipsoid.");var n=p.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(l.getColumn(n,0,y)),this._yAxis=r.fromCartesian4(l.getColumn(n,1,y));var u=r.fromCartesian4(l.getColumn(n,2,y));this._plane=d.fromPointNormal(e,u)}var y=new n;u(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var E=new e;m.fromPoints=function(t,r){o.defined("cartesians",t);var n=e.fromPoints(t,E);return new m(n.center,r)};var O=new h,_=new r;m.prototype.projectPointOntoPlane=function(e,n){o.defined("cartesian",e);var i=O;i.origin=e,r.normalize(e,i.direction);var u=f.rayPlane(i,this._plane,_);if(a(u)||(r.negate(i.direction,i.direction),u=f.rayPlane(i,this._plane,_)),a(u)){var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),l=r.dot(this._yAxis,s);return a(n)?(n.x=c,n.y=l,n):new t(c,l)}},m.prototype.projectPointsOntoPlane=function(e,t){o.defined("cartesians",e),a(t)||(t=[]);for(var r=0,n=e.length,i=0;n>i;i++){var u=this.projectPointOntoPlane(e[i],t[r]);a(u)&&(t[r]=u,r++)}return t.length=r,t},m.prototype.projectPointToNearestOnPlane=function(e,n){o.defined("cartesian",e),a(n)||(n=new t);var i=O;i.origin=e,r.clone(this._plane.normal,i.direction);var u=f.rayPlane(i,this._plane,_);a(u)||(r.negate(i.direction,i.direction),u=f.rayPlane(i,this._plane,_));var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),l=r.dot(this._yAxis,s);return n.x=c,n.y=l,n},m.prototype.projectPointsToNearestOnPlane=function(e,t){o.defined("cartesians",e),a(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;r>n;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var R=new r;return m.prototype.projectPointOntoEllipsoid=function(e,t){o.defined("cartesian",e),a(t)||(t=new r);var n=this._ellipsoid,i=this._origin,u=this._xAxis,s=this._yAxis,c=R;return r.multiplyByScalar(u,e.x,c),t=r.add(i,c,t),r.multiplyByScalar(s,e.y,c),r.add(t,c,t),n.scaleToGeocentricSurface(t,t),t},m.prototype.projectPointsOntoEllipsoid=function(e,t){o.defined("cartesians",e);var r=e.length;a(t)?t.length=r:t=new Array(r);for(var n=0;r>n;++n)t[n]=this.projectPointOntoEllipsoid(e[n],t[n]);return t},m}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,r,n,o,i,a,u,s,c,f,l,d,h,p,m){"use strict";function y(e,t){this.center=r.clone(i(e,r.ZERO)),this.halfAxes=h.clone(i(t,h.ZERO))}function E(e,t,n,o,i,s,c,f){if(!(a(t)&&a(n)&&a(o)&&a(i)&&a(s)&&a(c)))throw new u("all extents (minimum/maximum X/Y/Z) are required.");a(f)||(f=new y);var l=f.halfAxes;h.setColumn(l,0,e.xAxis,l),h.setColumn(l,1,e.yAxis,l),h.setColumn(l,2,e.zAxis,l);var d=C;d.x=(t+n)/2,d.y=(o+i)/2,d.z=(s+c)/2;var p=v;p.x=(n-t)/2,p.y=(i-o)/2,p.z=(c-s)/2;var m=f.center;return d=h.multiplyByVector(l,d,d),r.add(e.origin,d,m),h.multiplyByScale(l,p,l),f}y.packedLength=r.packedLength+h.packedLength,y.pack=function(e,t,n){return o.typeOf.object("value",e),o.defined("array",t),n=i(n,0),r.pack(e.center,t,n),h.pack(e.halfAxes,t,n+r.packedLength),t},y.unpack=function(e,t,n){return o.defined("array",e),t=i(t,0),a(n)||(n=new y),r.unpack(e,t,n.center),h.unpack(e,t+r.packedLength,n.halfAxes),n};var O=new r,_=new r,R=new r,w=new r,g=new r,T=new r,A=new h,b={unitary:new h,diagonal:new h};y.fromPoints=function(e,t){if(a(t)||(t=new y),!a(e)||0===e.length)return t.halfAxes=h.ZERO,t.center=r.ZERO,t;var n,o=e.length,i=r.clone(e[0],O);for(n=1;o>n;n++)r.add(i,e[n],i);var u=1/o;r.multiplyByScalar(i,u,i);var s,c=0,f=0,l=0,d=0,p=0,m=0;for(n=0;o>n;n++)s=r.subtract(e[n],i,_),c+=s.x*s.x,f+=s.x*s.y,l+=s.x*s.z,d+=s.y*s.y,p+=s.y*s.z,m+=s.z*s.z;c*=u,f*=u,l*=u,d*=u,p*=u,m*=u;var E=A;E[0]=c,E[1]=f,E[2]=l,E[3]=f,E[4]=d,E[5]=p,E[6]=l,E[7]=p,E[8]=m;var C=h.computeEigenDecomposition(E,b),v=h.clone(C.unitary,t.halfAxes),S=h.getColumn(v,0,w),I=h.getColumn(v,1,g),N=h.getColumn(v,2,T),M=-Number.MAX_VALUE,x=-Number.MAX_VALUE,P=-Number.MAX_VALUE,D=Number.MAX_VALUE,F=Number.MAX_VALUE,U=Number.MAX_VALUE;for(n=0;o>n;n++)s=e[n],M=Math.max(r.dot(S,s),M),x=Math.max(r.dot(I,s),x),P=Math.max(r.dot(N,s),P),D=Math.min(r.dot(S,s),D),F=Math.min(r.dot(I,s),F),U=Math.min(r.dot(N,s),U);S=r.multiplyByScalar(S,.5*(D+M),S),I=r.multiplyByScalar(I,.5*(F+x),I),N=r.multiplyByScalar(N,.5*(U+P),N);var q=r.add(S,I,t.center);r.add(q,N,q);var L=R;return L.x=M-D,L.y=x-F,L.z=P-U,r.multiplyByScalar(L,.5,L),h.multiplyByScale(t.halfAxes,L,t.halfAxes),t};var C=new r,v=new r,S=new n,I=new r,N=[new n,new n,new n,new n,new n,new n,new n,new n],M=[new r,new r,new r,new r,new r,new r,new r,new r],x=[new t,new t,new t,new t,new t,new t,new t,new t];y.fromRectangle=function(e,t,r,n,o){if(!a(e))throw new u("rectangle is required");if(e.width<0||e.width>d.TWO_PI)throw new u("Rectangle width must be between 0 and 2*pi");if(e.height<0||e.height>d.PI)throw new u("Rectangle height must be between 0 and pi");if(a(n)&&!d.equalsEpsilon(n.radii.x,n.radii.y,d.EPSILON15))throw new u("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");t=i(t,0),r=i(r,0),n=i(n,s.WGS84);var f=m.center(e,S),l=n.cartographicToCartesian(f,I),h=new c(l,n),y=h.plane,O=N[0],_=N[1],R=N[2],w=N[3],g=N[4],T=N[5],A=N[6],b=N[7],C=f.longitude,v=e.south<0&&e.north>0?0:f.latitude;A.latitude=T.latitude=g.latitude=e.south,b.latitude=w.latitude=v,O.latitude=_.latitude=R.latitude=e.north,A.longitude=b.longitude=O.longitude=e.west,T.longitude=_.longitude=C,g.longitude=w.longitude=R.longitude=e.east,R.height=_.height=O.height=b.height=A.height=T.height=g.height=w.height=r,n.cartographicArrayToCartesianArray(N,M),h.projectPointsToNearestOnPlane(M,x);var P=Math.min(x[6].x,x[7].x,x[0].x),D=Math.max(x[2].x,x[3].x,x[4].x),F=Math.min(x[4].y,x[5].y,x[6].y),U=Math.max(x[0].y,x[1].y,x[2].y);R.height=O.height=g.height=A.height=t,n.cartographicArrayToCartesianArray(N,M);var q=Math.min(p.getPointDistance(y,M[0]),p.getPointDistance(y,M[2]),p.getPointDistance(y,M[4]),p.getPointDistance(y,M[6])),L=r;return E(h,P,D,F,U,q,L,o)},y.clone=function(e,t){return a(e)?a(t)?(r.clone(e.center,t.center),h.clone(e.halfAxes,t.halfAxes),t):new y(e.center,e.halfAxes):void 0},y.intersectPlane=function(e,t){if(!a(e))throw new u("box is required.");if(!a(t))throw new u("plane is required.");var n=e.center,o=t.normal,i=e.halfAxes,s=o.x,c=o.y,l=o.z,d=Math.abs(s*i[h.COLUMN0ROW0]+c*i[h.COLUMN0ROW1]+l*i[h.COLUMN0ROW2])+Math.abs(s*i[h.COLUMN1ROW0]+c*i[h.COLUMN1ROW1]+l*i[h.COLUMN1ROW2])+Math.abs(s*i[h.COLUMN2ROW0]+c*i[h.COLUMN2ROW1]+l*i[h.COLUMN2ROW2]),p=r.dot(o,n)+t.distance;return-d>=p?f.OUTSIDE:p>=d?f.INSIDE:f.INTERSECTING};var P=new r,D=new r,F=new r,U=new r;y.distanceSquaredTo=function(e,t){if(!a(e))throw new u("box is required.");if(!a(t))throw new u("cartesian is required.");var n=r.subtract(t,e.center,C),o=e.halfAxes,i=h.getColumn(o,0,P),s=h.getColumn(o,1,D),c=h.getColumn(o,2,F),f=r.magnitude(i),l=r.magnitude(s),d=r.magnitude(c);r.normalize(i,i),r.normalize(s,s),r.normalize(c,c);var p=U;p.x=r.dot(n,i),p.y=r.dot(n,s),p.z=r.dot(n,c);var m,y=0;return p.x<-f?(m=p.x+f,y+=m*m):p.x>f&&(m=p.x-f,y+=m*m),p.y<-l?(m=p.y+l,y+=m*m):p.y>l&&(m=p.y-l,y+=m*m),p.z<-d?(m=p.z+d,y+=m*m):p.z>d&&(m=p.z-d,y+=m*m),y};var q=new r,L=new r;y.computePlaneDistances=function(e,t,n,o){if(!a(e))throw new u("box is required.");if(!a(t))throw new u("position is required.");if(!a(n))throw new u("direction is required.");a(o)||(o=new l);var i=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,c=e.center,f=e.halfAxes,d=h.getColumn(f,0,P),p=h.getColumn(f,1,D),m=h.getColumn(f,2,F),y=r.add(d,p,q);r.add(y,m,y),r.add(y,c,y);var E=r.subtract(y,t,L),O=r.dot(n,E);return i=Math.min(O,i),s=Math.max(O,s),r.add(c,d,y),r.add(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.add(c,d,y),r.subtract(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.add(c,d,y),r.subtract(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.add(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.add(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.subtract(y,p,y),r.add(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),r.subtract(c,d,y),r.subtract(y,p,y),r.subtract(y,m,y),r.subtract(y,t,E),O=r.dot(n,E),i=Math.min(O,i),s=Math.max(O,s),o.start=i,o.stop=s,o};var B=new e;return y.isOccluded=function(t,r){if(!a(t))throw new u("box is required.");if(!a(r))throw new u("occluder is required.");var n=e.fromOrientedBoundingBox(t,B);return!r.isBoundingSphereVisible(n)},y.prototype.intersectPlane=function(e){return y.intersectPlane(this,e)},y.prototype.distanceSquaredTo=function(e){return y.distanceSquaredTo(this,e)},y.prototype.computePlaneDistances=function(e,t,r){return y.computePlaneDistances(this,e,t,r)},y.prototype.isOccluded=function(e){return y.isOccluded(this,e)},y.equals=function(e,t){return e===t||a(e)&&a(t)&&r.equals(e.center,t.center)&&h.equals(e.halfAxes,t.halfAxes)},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var i=t.stack;return e(i)&&(r+="\n"+i),r}return t}),define("Workers/createTaskProcessorWorker",["../ThirdParty/when","../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r,n){
"use strict";function o(t,r,n){var o;try{return o=t(r,n)}catch(i){return e.reject(i)}}function i(i){var a;return function(u){var s=u.data,c=[],f={id:s.id,result:void 0,error:void 0};return e(o(i,s.parameters,c)).then(function(e){f.result=e}).otherwise(function(e){e instanceof Error?f.error={name:e.name,message:e.message,stack:e.stack}:f.error=e}).always(function(){r(a)||(a=t(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(c.length=0);try{a(f,c)}catch(e){f.result=void 0,f.error="postMessage failed with error: "+n(e)+"\n  with responseMessage: "+JSON.stringify(f),a(f)}})}}return i}),define("Workers/createVectorTilePolygons",["../Core/AttributeCompression","../Core/Cartesian3","../Core/Cartographic","../Core/Color","../Core/defined","../Core/Ellipsoid","../Core/IndexDatatype","../Core/Math","../Core/OrientedBoundingBox","../Core/Rectangle","./createTaskProcessorWorker"],function(e,t,r,n,o,i,a,u,s,c,f){"use strict";function l(e){var r=new Float64Array(e),n=0;O.indexBytesPerElement=r[n++],O.min=r[n++],O.max=r[n++],t.unpack(r,n,m),n+=t.packedLength,i.unpack(r,n,y),n+=i.packedLength,c.unpack(r,n,E)}function d(e){for(var t=e.length,r=0,o=0;t>o;++o)r+=n.packedLength+3+e[o].batchIds.length;return r}function h(e,t,r){var o=t.length,i=2+o*s.packedLength+1+d(r),a=new Float64Array(i),u=0;a[u++]=e,a[u++]=o;for(var c=0;o>c;++c)s.pack(t[c],a,u),u+=s.packedLength;var f=r.length;a[u++]=f;for(var l=0;f>l;++l){var h=r[l];n.pack(h.color,a,u),u+=n.packedLength,a[u++]=h.offset,a[u++]=h.count;var p=h.batchIds,m=p.length;a[u++]=m;for(var y=0;m>y;++y)a[u++]=p[y]}return a}function p(i,c){l(i.packedBuffer);var f,d=O.indexBytesPerElement;f=2===d?new Uint16Array(i.indices):new Uint32Array(i.indices);var p=new Uint16Array(i.positions),v=new Uint32Array(i.counts),S=new Uint32Array(i.indexCounts),I=new Uint32Array(i.batchIds),N=new Uint32Array(i.batchTableColors),M=new Array(v.length),x=m,P=y,D=E,F=O.min,U=O.max,q=i.minimumHeights,L=i.maximumHeights;o(q)&&o(L)&&(q=new Float32Array(q),L=new Float32Array(L));var B,j,z,G=p.length/2,V=p.subarray(0,G),W=p.subarray(G,2*G);e.zigZagDeltaDecode(V,W);var X=new Float32Array(3*G);for(B=0;G>B;++B){var k=V[B],H=W[B],Y=u.lerp(D.west,D.east,k/_),K=u.lerp(D.south,D.north,H/_),Z=r.fromRadians(Y,K,0,b),Q=P.cartographicToCartesian(Z,R);t.pack(Q,X,3*B)}var J=v.length,$=new Array(J),ee=new Array(J),te=0,re=0;for(B=0;J>B;++B)$[B]=te,ee[B]=re,te+=v[B],re+=S[B];var ne=new Float32Array(3*G*2),oe=new Uint16Array(2*G),ie=new Uint32Array(ee.length),ae=new Uint32Array(S.length),ue=[],se={};for(B=0;J>B;++B)z=N[B],o(se[z])?(se[z].positionLength+=v[B],se[z].indexLength+=S[B],se[z].batchIds.push(B)):se[z]={positionLength:v[B],indexLength:S[B],offset:0,indexOffset:0,batchIds:[B]};var ce,fe=0,le=0;for(z in se)if(se.hasOwnProperty(z)){ce=se[z],ce.offset=fe,ce.indexOffset=le;var de=2*ce.positionLength,he=2*ce.indexLength+6*ce.positionLength;fe+=de,le+=he,ce.indexLength=he}var pe=[];for(z in se)se.hasOwnProperty(z)&&(ce=se[z],pe.push({color:n.fromRgba(parseInt(z)),offset:ce.indexOffset,count:ce.indexLength,batchIds:ce.batchIds}));for(B=0;J>B;++B){z=N[B],ce=se[z];var me=ce.offset,ye=3*me,Ee=me,Oe=$[B],_e=v[B],Re=I[B],we=F,ge=U;o(q)&&o(L)&&(we=q[B],ge=L[B]);var Te=Number.POSITIVE_INFINITY,Ae=Number.NEGATIVE_INFINITY,be=Number.POSITIVE_INFINITY,Ce=Number.NEGATIVE_INFINITY;for(j=0;_e>j;++j){var ve=t.unpack(X,3*Oe+3*j,R);P.scaleToGeodeticSurface(ve,ve);var Se=P.cartesianToCartographic(ve,b),Ie=Se.latitude,Ne=Se.longitude;Te=Math.min(Ie,Te),Ae=Math.max(Ie,Ae),be=Math.min(Ne,be),Ce=Math.max(Ne,Ce);var Me=P.geodeticSurfaceNormal(ve,w),xe=t.multiplyByScalar(Me,we,g),Pe=t.add(ve,xe,T);xe=t.multiplyByScalar(Me,ge,xe);var De=t.add(ve,xe,A);t.subtract(De,x,De),t.subtract(Pe,x,Pe),t.pack(De,ne,ye),t.pack(Pe,ne,ye+3),oe[Ee]=Re,oe[Ee+1]=Re,ye+=6,Ee+=2}D=C,D.west=be,D.east=Ce,D.south=Te,D.north=Ae,M[B]=s.fromRectangle(D,F,U,P);var Fe=ce.indexOffset,Ue=ee[B],qe=S[B];for(ie[B]=Fe,j=0;qe>j;j+=3){var Le=f[Ue+j]-Oe,Be=f[Ue+j+1]-Oe,je=f[Ue+j+2]-Oe;ue[Fe++]=2*Le+me,ue[Fe++]=2*Be+me,ue[Fe++]=2*je+me,ue[Fe++]=2*je+1+me,ue[Fe++]=2*Be+1+me,ue[Fe++]=2*Le+1+me}for(j=0;_e>j;++j){var ze=j,Ge=(j+1)%_e;ue[Fe++]=2*ze+1+me,ue[Fe++]=2*Ge+me,ue[Fe++]=2*ze+me,ue[Fe++]=2*ze+1+me,ue[Fe++]=2*Ge+1+me,ue[Fe++]=2*Ge+me}ce.offset+=2*_e,ce.indexOffset=Fe,ae[B]=Fe-ie[B]}ue=a.createTypedArray(ne.length/3,ue);for(var Ve=pe.length,We=0;Ve>We;++We){for(var Xe=pe[We].batchIds,ke=0,He=Xe.length,Ye=0;He>Ye;++Ye)ke+=ae[Xe[Ye]];pe[We].count=ke}var Ke=2===ue.BYTES_PER_ELEMENT?a.UNSIGNED_SHORT:a.UNSIGNED_INT,Ze=h(Ke,M,pe);return c.push(ne.buffer,ue.buffer,ie.buffer,ae.buffer,oe.buffer,Ze.buffer),{positions:ne.buffer,indices:ue.buffer,indexOffsets:ie.buffer,indexCounts:ae.buffer,batchIds:oe.buffer,packedBuffer:Ze.buffer}}var m=new t,y=new i,E=new c,O={min:void 0,max:void 0,indexBytesPerElement:void 0},_=32767,R=new t,w=new t,g=new t,T=new t,A=new t,b=new r,C=new c;return f(p)})}();