/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(n){t=n.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e){return e+" is required, actual value was undefined"}function r(e,t,n){return"Expected "+n+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(r,i){if(!e(i))throw new t(n(r))},i.typeOf.func=function(e,n){if("function"!=typeof n)throw new t(r(typeof n,"function",e))},i.typeOf.string=function(e,n){if("string"!=typeof n)throw new t(r(typeof n,"string",e))},i.typeOf.number=function(e,n){if("number"!=typeof n)throw new t(r(typeof n,"number",e))},i.typeOf.number.lessThan=function(e,n,r){if(i.typeOf.number(e,n),n>=r)throw new t("Expected "+e+" to be less than "+r+", actual value was "+n)},i.typeOf.number.lessThanOrEquals=function(e,n,r){if(i.typeOf.number(e,n),n>r)throw new t("Expected "+e+" to be less than or equal to "+r+", actual value was "+n)},i.typeOf.number.greaterThan=function(e,n,r){if(i.typeOf.number(e,n),r>=n)throw new t("Expected "+e+" to be greater than "+r+", actual value was "+n)},i.typeOf.number.greaterThanOrEquals=function(e,n,r){if(i.typeOf.number(e,n),r>n)throw new t("Expected "+e+" to be greater than or equal to"+r+", actual value was "+n)},i.typeOf.object=function(e,n){if("object"!=typeof n)throw new t(r(typeof n,"object",e))},i.typeOf.bool=function(e,n){if("boolean"!=typeof n)throw new t(r(typeof n,"boolean",e))},i.typeOf.number.equals=function(e,n,r,o){if(i.typeOf.number(e,r),i.typeOf.number(n,o),r!==o)throw new t(e+" must be equal to "+n+", the actual values are "+r+" and "+o)},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r,i){"use strict";var o={};o.Radius=6378137,o.EPSILON1=.1,o.EPSILON2=.01,o.EPSILON3=.001,o.EPSILON4=1e-4,o.EPSILON5=1e-5,o.EPSILON6=1e-6,o.EPSILON7=1e-7,o.EPSILON8=1e-8,o.EPSILON9=1e-9,o.EPSILON10=1e-10,o.EPSILON11=1e-11,o.EPSILON12=1e-12,o.EPSILON13=1e-13,o.EPSILON14=1e-14,o.EPSILON15=1e-15,o.EPSILON16=1e-16,o.EPSILON17=1e-17,o.EPSILON18=1e-18,o.EPSILON19=1e-19,o.EPSILON20=1e-20,o.EPSILON21=1e-21,o.GRAVITATIONALPARAMETER=3986004418e5,o.SOLAR_RADIUS=6955e5,o.LUNAR_RADIUS=1737400,o.SIXTY_FOUR_KILOBYTES=65536,o.sign=n(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),o.signNotZero=function(e){return 0>e?-1:1},o.toSNorm=function(e,t){return t=n(t,255),Math.round((.5*o.clamp(e,-1,1)+.5)*t)},o.fromSNorm=function(e,t){return t=n(t,255),o.clamp(e,0,t)/t*2-1},o.sinh=n(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),o.cosh=n(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),o.lerp=function(e,t,n){return(1-n)*e+n*t},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=Math.PI/2,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI/2,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(e){if(!r(e))throw new i("degrees is required.");return e*o.RADIANS_PER_DEGREE},o.toDegrees=function(e){if(!r(e))throw new i("radians is required.");return e*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(e){if(!r(e))throw new i("angle is required.");var t=o.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},o.clampToLatitudeRange=function(e){if(!r(e))throw new i("angle is required.");return o.clamp(e,-1*o.PI_OVER_TWO,o.PI_OVER_TWO)},o.negativePiToPi=function(e){if(!r(e))throw new i("angle is required.");return o.zeroToTwoPi(e+o.PI)-o.PI},o.zeroToTwoPi=function(e){if(!r(e))throw new i("angle is required.");var t=o.mod(e,o.TWO_PI);return Math.abs(t)<o.EPSILON14&&Math.abs(e)>o.EPSILON14?o.TWO_PI:t},o.mod=function(e,t){if(!r(e))throw new i("m is required.");if(!r(t))throw new i("n is required.");return(e%t+t)%t},o.equalsEpsilon=function(e,t,o,a){if(!r(e))throw new i("left is required.");if(!r(t))throw new i("right is required.");if(!r(o))throw new i("relativeEpsilon is required.");a=n(a,o);var u=Math.abs(e-t);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(t))},o.lessThan=function(e,t,n){if(!r(e))throw new i("first is required.");if(!r(t))throw new i("second is required.");if(!r(n))throw new i("relativeEpsilon is required.");return-n>e-t},o.lessThanOrEquals=function(e,t,n){if(!r(e))throw new i("first is required.");if(!r(t))throw new i("second is required.");if(!r(n))throw new i("relativeEpsilon is required.");return n>e-t},o.greaterThan=function(e,t,n){if(!r(e))throw new i("first is required.");if(!r(t))throw new i("second is required.");if(!r(n))throw new i("relativeEpsilon is required.");return e-t>n},o.greaterThanOrEquals=function(e,t,n){if(!r(e))throw new i("first is required.");if(!r(t))throw new i("second is required.");if(!r(n))throw new i("relativeEpsilon is required.");return e-t>-n};var a=[1];o.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var n=a[t-1],r=t;e>=r;r++)a.push(n*r);return a[e]},o.incrementWrap=function(e,t,o){if(o=n(o,0),!r(e))throw new i("n is required.");if(o>=t)throw new i("maximumValue must be greater than minimumValue.");return++e,e>t&&(e=o),e},o.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},o.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},o.clamp=function(e,t,n){if(!r(e))throw new i("value is required");if(!r(t))throw new i("min is required.");if(!r(n))throw new i("max is required.");return t>e?t:e>n?n:e};var u=new e;return o.setRandomNumberSeed=function(t){if(!r(t))throw new i("seed is required.");u=new e(t)},o.nextRandomNumber=function(){return u.random()},o.randomBetween=function(e,t){return o.nextRandomNumber()*(t-e)+e},o.acosClamped=function(e){if(!r(e))throw new i("value is required.");return Math.acos(o.clamp(e,-1,1))},o.asinClamped=function(e){if(!r(e))throw new i("value is required.");return Math.asin(o.clamp(e,-1,1))},o.chordLength=function(e,t){if(!r(e))throw new i("angle is required.");if(!r(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},o.logBase=function(e,t){if(!r(e))throw new i("number is required.");if(!r(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},o.cbrt=n(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return 0>e?-t:t}),o.log2=n(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),o.fog=function(e,t){var n=e*t;return 1-Math.exp(-(n*n))},o.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},o.fastApproximateAtan2=function(e,n){t.typeOf.number("x",e),t.typeOf.number("y",n);var r,a,u=Math.abs(e);r=Math.abs(n),a=Math.max(u,r),r=Math.min(u,r);var s=r/a;if(isNaN(s))throw new i("either x or y must be nonzero");return u=o.fastApproximateAtan(s),u=Math.abs(n)>Math.abs(e)?o.PI_OVER_TWO-u:u,u=0>e?o.PI-u:u,u=0>n?-u:u},o}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,o){"use strict";function a(e,n){this.x=t(e,0),this.y=t(n,0)}a.fromElements=function(e,t,r){return n(r)?(r.x=e,r.y=t,r):new a(e,t)},a.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,r,i){return e.typeOf.object("value",n),e.defined("array",r),i=t(i,0),r[i++]=n.x,r[i]=n.y,r},a.unpack=function(r,i,o){return e.defined("array",r),i=t(i,0),n(o)||(o=new a),o.x=r[i++],o.y=r[i],o},a.packArray=function(t,r){e.defined("array",t);var i=t.length;n(r)?r.length=2*i:r=new Array(2*i);for(var o=0;i>o;++o)a.pack(t[o],r,2*o);return r},a.unpackArray=function(t,r){e.defined("array",t);var i=t.length;n(r)?r.length=i/2:r=new Array(i/2);for(var o=0;i>o;o+=2){var u=o/2;r[u]=a.unpack(t,o,r[u])}return r},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.min(t.x,n.x),r.y=Math.min(t.y,n.y),r},a.maximumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.max(t.x,n.x),r.y=Math.max(t.y,n.y),r},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),a.subtract(t,n,u),a.magnitude(u)},a.distanceSquared=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),a.subtract(t,n,u),a.magnitudeSquared(u)},a.normalize=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var i=a.magnitude(t);if(n.x=t.x/i,n.y=t.y/i,isNaN(n.x)||isNaN(n.y))throw new r("normalized result is not a number");return n},a.dot=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),t.x*n.x+t.y*n.y},a.multiplyComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x*n.x,r.y=t.y*n.y,r},a.divideComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x/n.x,r.y=t.y/n.y,r},a.add=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x+n.x,r.y=t.y+n.y,r},a.subtract=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x-n.x,r.y=t.y-n.y,r},a.multiplyByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x*n,r.y=t.y*n,r},a.divideByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x/n,r.y=t.y/n,r},a.negate=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=-t.x,n.y=-t.y,n},a.abs=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=Math.abs(t.x),n.y=Math.abs(t.y),n};var s=new a;a.lerp=function(t,n,r,i){return e.typeOf.object("start",t),e.typeOf.object("end",n),e.typeOf.number("t",r),e.typeOf.object("result",i),a.multiplyByScalar(n,r,s),i=a.multiplyByScalar(t,1-r,i),a.add(s,i,i)};var c=new a,f=new a;a.angleBetween=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),a.normalize(t,c),a.normalize(n,f),o.acosClamped(a.dot(c,f))};var h=new a;return a.mostOrthogonalAxis=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var r=a.normalize(t,h);return a.abs(r,r),n=r.x<=r.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},a.equalsEpsilon=function(e,t,r,i){return e===t||n(e)&&n(t)&&o.equalsEpsilon(e.x,t.x,r,i)&&o.equalsEpsilon(e.y,t.y,r,i)},a.ZERO=i(new a(0,0)),a.UNIT_X=i(new a(1,0)),a.UNIT_Y=i(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,o){"use strict";function a(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)}a.fromSpherical=function(r,i){e.typeOf.object("spherical",r),n(i)||(i=new a);var o=r.clock,u=r.cone,s=t(r.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(o),i.y=c*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,r,i){return n(i)?(i.x=e,i.y=t,i.z=r,i):new a(e,t,r)},a.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,r,i){return e.typeOf.object("value",n),e.defined("array",r),i=t(i,0),r[i++]=n.x,r[i++]=n.y,r[i]=n.z,r},a.unpack=function(r,i,o){return e.defined("array",r),i=t(i,0),n(o)||(o=new a),o.x=r[i++],o.y=r[i++],o.z=r[i],o},a.packArray=function(t,r){e.defined("array",t);var i=t.length;n(r)?r.length=3*i:r=new Array(3*i);for(var o=0;i>o;++o)a.pack(t[o],r,3*o);return r},a.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new r("array length must be a multiple of 3.");var o=t.length;n(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=u/3;i[s]=a.unpack(t,u,i[s])}return i},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.min(t.x,n.x),r.y=Math.min(t.y,n.y),r.z=Math.min(t.z,n.z),r},a.maximumByComponent=function(t,n,r){return e.typeOf.object("first",t),e.typeOf.object("second",n),e.typeOf.object("result",r),r.x=Math.max(t.x,n.x),r.y=Math.max(t.y,n.y),r.z=Math.max(t.z,n.z),r},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),a.subtract(t,n,u),a.magnitude(u)},a.distanceSquared=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),a.subtract(t,n,u),a.magnitudeSquared(u)},a.normalize=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var i=a.magnitude(t);if(n.x=t.x/i,n.y=t.y/i,n.z=t.z/i,isNaN(n.x)||isNaN(n.y)||isNaN(n.z))throw new r("normalized result is not a number");return n},a.dot=function(t,n){return e.typeOf.object("left",t),e.typeOf.object("right",n),t.x*n.x+t.y*n.y+t.z*n.z},a.multiplyComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x*n.x,r.y=t.y*n.y,r.z=t.z*n.z,r},a.divideComponents=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x/n.x,r.y=t.y/n.y,r.z=t.z/n.z,r},a.add=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x+n.x,r.y=t.y+n.y,r.z=t.z+n.z,r},a.subtract=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=t.x-n.x,r.y=t.y-n.y,r.z=t.z-n.z,r},a.multiplyByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x*n,r.y=t.y*n,r.z=t.z*n,r},a.divideByScalar=function(t,n,r){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",n),e.typeOf.object("result",r),r.x=t.x/n,r.y=t.y/n,r.z=t.z/n,r},a.negate=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=-t.x,n.y=-t.y,n.z=-t.z,n},a.abs=function(t,n){return e.typeOf.object("cartesian",t),e.typeOf.object("result",n),n.x=Math.abs(t.x),n.y=Math.abs(t.y),n.z=Math.abs(t.z),n};var s=new a;a.lerp=function(t,n,r,i){return e.typeOf.object("start",t),e.typeOf.object("end",n),e.typeOf.number("t",r),e.typeOf.object("result",i),a.multiplyByScalar(n,r,s),i=a.multiplyByScalar(t,1-r,i),a.add(s,i,i)};var c=new a,f=new a;a.angleBetween=function(t,n){e.typeOf.object("left",t),e.typeOf.object("right",n),a.normalize(t,c),a.normalize(n,f);var r=a.dot(c,f),i=a.magnitude(a.cross(c,f,c));return Math.atan2(i,r)};var h=new a;a.mostOrthogonalAxis=function(t,n){e.typeOf.object("cartesian",t),e.typeOf.object("result",n);var r=a.normalize(t,h);return a.abs(r,r),n=r.x<=r.y?r.x<=r.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):r.y<=r.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.projectVector=function(t,n,r){e.defined("a",t),e.defined("b",n),e.defined("result",r);var i=a.dot(t,n)/a.dot(n,n);return a.multiplyByScalar(n,i,r)},a.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},a.equalsEpsilon=function(e,t,r,i){return e===t||n(e)&&n(t)&&o.equalsEpsilon(e.x,t.x,r,i)&&o.equalsEpsilon(e.y,t.y,r,i)&&o.equalsEpsilon(e.z,t.z,r,i)},a.cross=function(t,n,r){e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r);var i=t.x,o=t.y,a=t.z,u=n.x,s=n.y,c=n.z,f=o*c-a*s,h=a*u-i*c,d=i*s-o*u;return r.x=f,r.y=h,r.z=d,r},a.midpoint=function(t,n,r){return e.typeOf.object("left",t),e.typeOf.object("right",n),e.typeOf.object("result",r),r.x=.5*(t.x+n.x),r.y=.5*(t.y+n.y),r.z=.5*(t.z+n.z),r},a.fromDegrees=function(t,n,r,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",n),t=o.toRadians(t),n=o.toRadians(n),a.fromRadians(t,n,r,i,u)};var d=new a,l=new a,p=new a(40680631590769,40680631590769,40408299984661.445),y=new a(40680631590769,40680631590769,40680631590769);return a.fromRadians=function(r,i,u,s,c){e.typeOf.number("longitude",r),e.typeOf.number("latitude",i),u=t(u,0);var f=n(s)?s.radiiSquared:y;o.equalsEpsilon(o.Radius,6356752.314245179,o.EPSILON10)&&(f=n(s)?s.radiiSquared:p);var h=Math.cos(i);d.x=h*Math.cos(r),d.y=h*Math.sin(r),d.z=Math.sin(i),d=a.normalize(d,d),a.multiplyComponents(f,d,l);var m=Math.sqrt(a.dot(d,l));return l=a.divideByScalar(l,m,l),d=a.multiplyByScalar(d,u,d),n(c)||(c=new a),a.add(l,d,c)},a.fromDegreesArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new r("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;n(o)?o.length=u/2:o=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],h=s/2;o[h]=a.fromDegrees(c,f,0,i,o[h])}return o},a.fromRadiansArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new r("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;n(o)?o.length=u/2:o=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],h=s/2;o[h]=a.fromRadians(c,f,0,i,o[h])}return o},a.fromDegreesArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new r("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;n(o)?o.length=u/3:o=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],h=t[s+2],d=s/3;o[d]=a.fromDegrees(c,f,h,i,o[d])}return o},a.fromRadiansArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new r("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;n(o)?o.length=u/3:o=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],h=t[s+2],d=s/3;o[d]=a.fromRadians(c,f,h,i,o[d])}return o},a.ZERO=i(new a(0,0,0)),a.UNIT_X=i(new a(1,0,0)),a.UNIT_Y=i(new a(0,1,0)),a.UNIT_Z=i(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],function(e,t,n,r,i,o){"use strict";function a(e){return d[0]=e,d[0]}function u(e){return e>>1^-(1&e)}var s=1/256,c=256,f={};f.octEncodeInRange=function(e,r,a){n.defined("vector",e),n.defined("result",a);var u=t.magnitudeSquared(e);if(Math.abs(u-1)>o.EPSILON6)throw new i("vector must be normalized.");if(a.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),a.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=a.x,c=a.y;a.x=(1-Math.abs(c))*o.signNotZero(s),a.y=(1-Math.abs(s))*o.signNotZero(c)}return a.x=o.toSNorm(a.x,r),a.y=o.toSNorm(a.y,r),a},f.octEncode=function(e,t){return f.octEncodeInRange(e,255,t)};var h=new e,d=new Uint8Array(1);f.octEncodeToCartesian4=function(e,t){return f.octEncodeInRange(e,65535,h),t.x=a(h.x*s),t.y=a(h.x),t.z=a(h.y*s),t.w=a(h.y),t},f.octDecodeInRange=function(e,r,a,u){if(n.defined("result",u),0>e||e>a||0>r||r>a)throw new i("x and y must be unsigned normalized integers between 0 and "+a);if(u.x=o.fromSNorm(e,a),u.y=o.fromSNorm(r,a),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*o.signNotZero(s),u.y=(1-Math.abs(s))*o.signNotZero(u.y)}return t.normalize(u,u)},f.octDecode=function(e,t,n){return f.octDecodeInRange(e,t,255,n)},f.octDecodeFromCartesian4=function(e,t){n.typeOf.object("encoded",e),n.typeOf.object("result",t);var r=e.x,o=e.y,a=e.z,u=e.w;if(0>r||r>255||0>o||o>255||0>a||a>255||0>u||u>255)throw new i("x, y, z, and w must be unsigned normalized integers between 0 and 255");var s=r*c+o,h=a*c+u;return f.octDecodeInRange(s,h,65535,t)},f.octPackFloat=function(e){return n.defined("encoded",e),256*e.x+e.y};var l=new e;return f.octEncodeFloat=function(e){return f.octEncode(e,l),f.octPackFloat(l)},f.octDecodeFloat=function(e,t){n.defined("value",e);var r=e/256,i=Math.floor(r),o=256*(r-i);return f.octDecode(i,o,t)},f.octPack=function(e,t,r,i){n.defined("v1",e),n.defined("v2",t),n.defined("v3",r),n.defined("result",i);var o=f.octEncodeFloat(e),a=f.octEncodeFloat(t),u=f.octEncode(r,l);return i.x=65536*u.x+o,i.y=65536*u.y+a,i},f.octUnpack=function(e,t,r,i){n.defined("packed",e),n.defined("v1",t),n.defined("v2",r),n.defined("v3",i);var o=e.x/65536,a=Math.floor(o),u=65536*(o-a);o=e.y/65536;var s=Math.floor(o),c=65536*(o-s);f.octDecodeFloat(u,t),f.octDecodeFloat(c,r),f.octDecode(a,s,i)},f.compressTextureCoordinates=function(e){n.defined("textureCoordinates",e);var t=4095*e.x|0,r=4095*e.y|0;return 4096*t+r},f.decompressTextureCoordinates=function(e,t){n.defined("compressed",e),n.defined("result",t);var r=e/4096,i=Math.floor(r);return t.x=i/4095,t.y=(e-4096*i)/4095,t},f.zigZagDeltaDecode=function(e,t,i){n.defined("uBuffer",e),n.defined("vBuffer",t),n.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),r(i)&&n.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,i.length);for(var o=e.length,a=0,s=0,c=0,f=0;o>f;++f)a+=u(e[f]),s+=u(t[f]),e[f]=a,t[f]=s,r(i)&&(c+=u(i[f]),i[f]=c)},f.octShortToFloat=function(e){return o.clamp(3051850947599719e-20*e,-1,1)},f.octShortDecode=function(e,r,i){if(n.defined("result",i),i.x=f.octShortToFloat(e),i.y=f.octShortToFloat(r),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){var a=i.x;i.x=(1-Math.abs(i.y))*o.signNotZero(a),i.y=(1-Math.abs(a))*o.signNotZero(i.y)}return t.normalize(i,i)},f}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function i(i,u,s,c,f){if(!t(i))throw new n("cartesian is required.");if(!t(u))throw new n("oneOverRadii is required.");if(!t(s))throw new n("oneOverRadiiSquared is required.");if(!t(c))throw new n("centerToleranceSquared is required.");var h=i.x,d=i.y,l=i.z,p=u.x,y=u.y,m=u.z,g=h*h*p*p,O=d*d*y*y,w=l*l*m*m,b=g+O+w,v=Math.sqrt(1/b),x=e.multiplyByScalar(i,v,o);if(c>b)return isFinite(v)?e.clone(x,f):void 0;var M=s.x,E=s.y,_=s.z,q=a;q.x=x.x*M*2,q.y=x.y*E*2,q.z=x.z*_*2;var S,j,R,P,T,I,z,N,A,C,L,k=(1-v)*e.magnitude(i)/(.5*e.magnitude(q)),D=0;do{k-=D,R=1/(1+k*M),P=1/(1+k*E),T=1/(1+k*_),I=R*R,z=P*P,N=T*T,A=I*R,C=z*P,L=N*T,S=g*I+O*z+w*N-1,j=g*A*M+O*C*E+w*L*_;var W=-2*j;D=S/W}while(Math.abs(S)>r.EPSILON12);return t(f)?(f.x=h*R,f.y=d*P,f.z=l*T,f):new e(h*R,d*P,l*T)}var o=new e,a=new e;return i}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,o,a){"use strict";function u(e,t,r){this.longitude=n(e,0),this.latitude=n(t,0),this.height=n(r,0)}u.fromRadians=function(e,i,o,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),o=n(o,0),r(a)?(a.longitude=e,a.latitude=i,a.height=o,a):new u(e,i,o)},u.fromDegrees=function(e,n,r,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",n),e=o.toRadians(e),n=o.toRadians(n),u.fromRadians(e,n,r,i)};var s=new e,c=new e,f=new e,h=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/6378137,1/6378137,1/6378137),l=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),p=new e(1/40680631590769,1/40680631590769,1/40680631590769),y=o.EPSILON1;return u.fromCartesian=function(t,n,i){var m=r(n)?n.oneOverRadii:d,g=r(n)?n.oneOverRadiiSquared:p,O=r(n)?n._centerToleranceSquared:y;o.equalsEpsilon(o.Radius,6356752.314245179,o.EPSILON10)&&(m=r(n)?n.oneOverRadii:h,g=r(n)?n.oneOverRadiiSquared:l);var w=a(t,m,g,O,c);if(r(w)){var b=e.multiplyComponents(w,g,s);b=e.normalize(b,b);var v=e.subtract(t,w,f),x=Math.atan2(b.y,b.x),M=Math.asin(b.z),E=o.sign(e.dot(v,t))*e.magnitude(v);return r(i)?(i.longitude=x,i.latitude=M,i.height=E,i):new u(x,M,E)}},u.toCartesian=function(n,r,i){return t.defined("cartographic",n),e.fromRadians(n.longitude,n.latitude,n.height,r,i)},u.sphericalDistance=function(e,n,r,i){if(t.defined("longitudeA",e),t.defined("longitudeB",r),t.defined("latitudeA",n),t.defined("latitudeB",i),e===r&&n===i)return 0;var a=o.toRadians(n),u=o.toRadians(i),s=o.toRadians(e),c=o.toRadians(r),f=s*s+a*a,h=c*c+u*u,d=(s-c)*(s-c)+(a-u)*(a-u),l=(f+h-d)/(2*Math.sqrt(f)*Math.sqrt(h));return l=o.clamp(l,-1,1),Math.acos(l)*o.Radius},u.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,n,i){return t.typeOf.number("epsilon",i),e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,o,a,u,s,c){"use strict";function f(t,i,o,a){i=r(i,0),o=r(o,0),a=r(a,0),n.typeOf.number.greaterThanOrEquals("x",i,0),n.typeOf.number.greaterThanOrEquals("y",o,0),n.typeOf.number.greaterThanOrEquals("z",a,0),s.equalsEpsilon(a,6356752.314245179,s.EPSILON10)&&(s.Radius=a),t._radii=new e(i,o,a),t._radiiSquared=new e(i*i,o*o,a*a),t._radiiToTheFourth=new e(i*i*i*i,o*o*o*o,a*a*a*a),t._oneOverRadii=new e(0===i?0:1/i,0===o?0:1/o,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===o?0:1/(o*o),0===a?0:1/(a*a)),t._minimumRadius=Math.min(i,o,a),t._maximumRadius=Math.max(i,o,a),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function h(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,n)}o(h.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),h.clone=function(t,n){if(i(t)){var r=t._radii;return i(n)?(e.clone(r,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new h(r.x,r.y,r.z)}},h.fromCartesian3=function(e,t){return i(t)||(t=new h),i(e)?(f(t,e.x,e.y,e.z),t):t},h.WGS84=u(new h(6378137,6378137,s.Radius)),h.UNIT_SPHERE=u(new h(1,1,1)),h.MOON=u(new h(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),h.prototype.clone=function(e){return h.clone(this,e)},h.packedLength=e.packedLength,h.pack=function(t,i,o){return n.typeOf.object("value",t),n.defined("array",i),o=r(o,0),e.pack(t._radii,i,o),i},h.unpack=function(t,i,o){n.defined("array",t),i=r(i,0);var a=e.unpack(t,i);return h.fromCartesian3(a,o)},h.prototype.geocentricSurfaceNormal=e.normalize,h.prototype.geodeticSurfaceNormalCartographic=function(t,r){n.typeOf.object("cartographic",t);var o=t.longitude,a=t.latitude,u=Math.cos(a),s=u*Math.cos(o),c=u*Math.sin(o),f=Math.sin(a);return i(r)||(r=new e),r.x=s,r.y=c,r.z=f,e.normalize(r,r)},h.prototype.geodeticSurfaceNormal=function(t,n){return i(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var d=new e,l=new e;h.prototype.cartographicToCartesian=function(t,n){var r=d,o=l;this.geodeticSurfaceNormalCartographic(t,r),e.multiplyComponents(this._radiiSquared,r,o);var a=Math.sqrt(e.dot(r,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(r,t.height,r),i(n)||(n=new e),e.add(o,r,n)},h.prototype.cartographicArrayToCartesianArray=function(e,t){n.defined("cartographics",e);var r=e.length;i(t)?t.length=r:t=new Array(r);
for(var o=0;r>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var p=new e,y=new e,m=new e;return h.prototype.cartesianToCartographic=function(n,r){var o=this.scaleToGeodeticSurface(n,y);if(i(o)){var a=this.geodeticSurfaceNormal(o,p),u=e.subtract(n,o,m),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),h=s.sign(e.dot(u,n))*e.magnitude(u);return i(r)?(r.longitude=c,r.latitude=f,r.height=h,r):new t(c,f,h)}},h.prototype.cartesianArrayToCartographicArray=function(e,t){n.defined("cartesians",e);var r=e.length;i(t)?t.length=r:t=new Array(r);for(var o=0;r>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t},h.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},h.prototype.scaleToGeocentricSurface=function(t,r){n.typeOf.object("cartesian",t),i(r)||(r=new e);var o=t.x,a=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(o*o*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(t,c,r)},h.prototype.transformPositionToScaledSpace=function(t,n){return i(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},h.prototype.transformPositionFromScaledSpace=function(t,n){return i(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},h.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},h.prototype.toString=function(){return this._radii.toString()},h.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,o,u){if(n.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");n.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),o=r(o,0);var c=this._squaredXOverSquaredZ;return i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),Math.abs(u.z)>=this._radii.z-o?void 0:u},h}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,i,o,a,u){"use strict";function s(e,t,r,i){this.west=n(e,0),this.south=n(t,0),this.east=n(r,0),this.north=n(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,r,i){return t.typeOf.object("value",e),t.defined("array",r),i=n(i,0),r[i++]=e.west,r[i++]=e.south,r[i++]=e.east,r[i]=e.north,r},s.unpack=function(e,i,o){return t.defined("array",e),i=n(i,0),r(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var n=e.east,r=e.west;return r>n&&(n+=u.TWO_PI),n-r},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,o,a){return e=u.toRadians(n(e,0)),t=u.toRadians(n(t,0)),i=u.toRadians(n(i,0)),o=u.toRadians(n(o,0)),r(a)?(a.west=e,a.south=t,a.east=i,a.north=o,a):new s(e,t,i,o)},s.fromRadians=function(e,t,i,o,a){return r(a)?(a.west=n(e,0),a.south=n(t,0),a.east=n(i,0),a.north=n(o,0),a):new s(e,t,i,o)},s.fromCartographicArray=function(e,n){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,h=-Number.MAX_VALUE,d=0,l=e.length;l>d;d++){var p=e[d];i=Math.min(i,p.longitude),o=Math.max(o,p.longitude),f=Math.min(f,p.latitude),h=Math.max(h,p.latitude);var y=p.longitude>=0?p.longitude:p.longitude+u.TWO_PI;a=Math.min(a,y),c=Math.max(c,y)}return o-i>c-a&&(i=a,o=c,o>u.PI&&(o-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),r(n)?(n.west=i,n.south=f,n.east=o,n.north=h,n):new s(i,f,o,h)},s.fromCartesianArray=function(e,i,a){t.defined("cartesians",e),i=n(i,o.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,h=Number.MAX_VALUE,d=-Number.MAX_VALUE,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,y=0,m=e.length;m>y;y++){var g=i.cartesianToCartographic(e[y]);c=Math.min(c,g.longitude),f=Math.max(f,g.longitude),l=Math.min(l,g.latitude),p=Math.max(p,g.latitude);var O=g.longitude>=0?g.longitude:g.longitude+u.TWO_PI;h=Math.min(h,O),d=Math.max(d,O)}return f-c>d-h&&(c=h,f=d,f>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),r(a)?(a.west=c,a.south=l,a.east=f,a.north=p,a):new s(c,l,f,p)},s.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.equalsEpsilon=function(e,n,i){return t.typeOf.number("absoluteEpsilon",i),e===n||r(e)&&r(n)&&Math.abs(e.west-n.west)<=i&&Math.abs(e.south-n.south)<=i&&Math.abs(e.east-n.east)<=i&&Math.abs(e.north-n.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,n){return t.typeOf.number("epsilon",n),s.equalsEpsilon(this,e,n)},s.validate=function(e){t.typeOf.object("rectangle",e);var n=e.north;t.typeOf.number.greaterThanOrEquals("north",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",n,u.PI_OVER_TWO);var r=e.south;t.typeOf.number.greaterThanOrEquals("south",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",r,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var o=e.east;t.typeOf.number.greaterThanOrEquals("east",o,-Math.PI),t.typeOf.number.lessThanOrEquals("east",o,Math.PI)},s.southwest=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.west,i.latitude=n.south,i.height=0,i):new e(n.west,n.south)},s.northwest=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.west,i.latitude=n.north,i.height=0,i):new e(n.west,n.north)},s.northeast=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.east,i.latitude=n.north,i.height=0,i):new e(n.east,n.north)},s.southeast=function(n,i){return t.typeOf.object("rectangle",n),r(i)?(i.longitude=n.east,i.latitude=n.south,i.height=0,i):new e(n.east,n.south)},s.center=function(n,i){t.typeOf.object("rectangle",n);var o=n.east,a=n.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),c=.5*(n.south+n.north);return r(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,n,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",n);var o=e.east,a=e.west,c=n.east,f=n.west;a>o&&c>0?o+=u.TWO_PI:f>c&&o>0&&(c+=u.TWO_PI),a>o&&0>f?f+=u.TWO_PI:f>c&&0>a&&(a+=u.TWO_PI);var h=u.negativePiToPi(Math.max(a,f)),d=u.negativePiToPi(Math.min(o,c));if(!((e.west<e.east||n.west<n.east)&&h>=d)){var l=Math.max(e.south,n.south),p=Math.min(e.north,n.north);if(!(l>=p))return r(i)?(i.west=h,i.south=l,i.east=d,i.north=p,i):new s(h,l,d,p)}},s.simpleIntersection=function(e,n,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",n);var o=Math.max(e.west,n.west),a=Math.max(e.south,n.south),u=Math.min(e.east,n.east),c=Math.min(e.north,n.north);return a>=c||o>=u?void 0:r(i)?(i.west=o,i.south=a,i.east=u,i.north=c,i):new s(o,a,u,c)},s.union=function(e,n,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",n),r(i)||(i=new s);var o=e.east,a=e.west,c=n.east,f=n.west;a>o&&c>0?o+=u.TWO_PI:f>c&&o>0&&(c+=u.TWO_PI),a>o&&0>f?f+=u.TWO_PI:f>c&&0>a&&(a+=u.TWO_PI);var h=u.convertLongitudeRange(Math.min(a,f)),d=u.convertLongitudeRange(Math.max(o,c));return i.west=h,i.south=Math.min(e.south,n.south),i.east=d,i.north=Math.max(e.north,n.north),i},s.expand=function(e,n,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",n),r(i)||(i=new s),i.west=Math.min(e.west,n.longitude),i.south=Math.min(e.south,n.latitude),i.east=Math.max(e.east,n.longitude),i.north=Math.max(e.north,n.latitude),i},s.contains=function(e,n){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",n);var r=n.longitude,i=n.latitude,o=e.west,a=e.east;return o>a&&(a+=u.TWO_PI,0>r&&(r+=u.TWO_PI)),(r>o||u.equalsEpsilon(r,o,u.EPSILON14))&&(a>r||u.equalsEpsilon(r,a,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,a,f){t.typeOf.object("rectangle",e),i=n(i,o.WGS84),a=n(a,0),r(f)||(f=[]);var h=0,d=e.north,l=e.south,p=e.east,y=e.west,m=c;m.height=a,m.longitude=y,m.latitude=d,f[h]=i.cartographicToCartesian(m,f[h]),h++,m.longitude=p,f[h]=i.cartographicToCartesian(m,f[h]),h++,m.latitude=l,f[h]=i.cartographicToCartesian(m,f[h]),h++,m.longitude=y,f[h]=i.cartographicToCartesian(m,f[h]),h++,0>d?m.latitude=d:l>0?m.latitude=l:m.latitude=0;for(var g=1;8>g;++g)m.longitude=-Math.PI+g*u.PI_OVER_TWO,s.contains(e,m)&&(f[h]=i.cartographicToCartesian(m,f[h]),h++);return 0===m.latitude&&(m.longitude=y,f[h]=i.cartographicToCartesian(m,f[h]),h++,m.longitude=p,f[h]=i.cartographicToCartesian(m,f[h]),h++),f.length=h,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,i){return t(e).then(n,r,i)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=a(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=i(e),t}function n(t){return e(t,o)}function r(e){this.then=e}function i(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(r){return o(r)}});return n}function o(e){var n=new r(function(n,r){try{return r?t(r(e)):o(e)}catch(i){return o(i)}});return n}function a(){function e(e,t,n){return d(e,t,n)}function n(e){return p(e)}function i(e){return p(o(e))}function u(e){return l(e)}var s,c,f,h,d,l,p;return c=new r(e),s={then:e,resolve:n,reject:i,progress:u,promise:c,resolver:{resolve:n,reject:i,progress:u}},f=[],h=[],d=function(e,t,n){var r,i;return r=a(),i="function"==typeof n?function(e){try{r.progress(n(e))}catch(t){r.progress(t)}}:function(e){r.progress(e)},f.push(function(n){n.then(e,t).then(r.resolve,r.reject,i)}),h.push(i),r.promise},l=function(e){return y(h,e),e},p=function(e){return e=t(e),d=e.then,p=t,l=g,y(f,e),h=f=v,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,i,o){return m(2,arguments),e(t,function(t){function u(e){y(e)}function s(e){p(e)}var c,f,h,d,l,p,y,m,O,w;if(O=t.length>>>0,c=Math.max(0,Math.min(n,O)),h=[],f=O-c+1,d=[],l=a(),c)for(m=l.progress,y=function(e){d.push(e),--f||(p=y=g,l.reject(d))},p=function(e){h.push(e),--c||(p=y=g,l.resolve(h))},w=0;O>w;++w)w in t&&e(t[w],s,u,m);else l.resolve(h);return l.then(r,i,o)})}function c(e,t,n,r){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,n,r)}function f(e,t,n,r){return m(1,arguments),d(e,O).then(t,n,r)}function h(){return d(arguments,O)}function d(t,n){return e(t,function(t){var r,i,o,u,s,c;if(o=i=t.length>>>0,r=[],c=a(),o)for(u=function(t,i){e(t,n).then(function(e){r[i]=e,--o||c.resolve(r)},c.reject)},s=0;i>s;s++)s in t?u(t[s],s):--o;else c.resolve(r);return c.promise})}function l(t,n){var r=b.call(arguments,1);return e(t,function(t){var i;return i=t.length,r[0]=function(t,r,o){return e(t,function(t){return e(r,function(e){return n(t,e,o,i)})})},w.apply(t,r)})}function p(t,n,r){var i=arguments.length>2;return e(t,function(e){return e=i?r:e,n.resolve(e),e},function(e){return n.reject(e),o(e)},n.progress)}function y(e,t){for(var n,r=0;n=e[r++];)n(t)}function m(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function g(){}function O(e){return e}var w,b,v;return e.defer=a,e.resolve=t,e.reject=n,e.join=h,e.all=f,e.map=d,e.reduce=l,e.any=c,e.some=s,e.chain=p,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(v,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return f(t,function(t){return e.apply(v,t)})})}},b=[].slice,w=[].reduce||function(e){var t,n,r,i,o;if(o=0,t=Object(this),i=t.length>>>0,n=arguments,n.length<=1)for(;;){if(o in t){r=t[o++];break}if(++o>=i)throw new TypeError}else r=n[1];for(;i>o;++o)o in t&&(r=e(r,t[o],o,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var n,r=t.name,i=t.message;n=e(r)&&e(i)?r+": "+i:t.toString();var o=t.stack;return e(o)&&(n+="\n"+o),n}return t}),define("Workers/createTaskProcessorWorker",["../ThirdParty/when","../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,n,r){"use strict";function i(t,n,r){var i;try{return i=t(n,r)}catch(o){return e.reject(o)}}function o(o){var a;return function(u){var s=u.data,c=[],f={id:s.id,result:void 0,error:void 0};return e(i(o,s.parameters,c)).then(function(e){f.result=e}).otherwise(function(e){e instanceof Error?f.error={name:e.name,message:e.message,stack:e.stack}:f.error=e}).always(function(){n(a)||(a=t(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(c.length=0);try{a(f,c)}catch(e){f.result=void 0,f.error="postMessage failed with error: "+r(e)+"\n  with responseMessage: "+JSON.stringify(f),a(f)}})}}return o}),define("Workers/createVectorTilePoints",["../Core/AttributeCompression","../Core/Cartesian3","../Core/Cartographic","../Core/Ellipsoid","../Core/Math","../Core/Rectangle","./createTaskProcessorWorker"],function(e,t,n,r,i,o,a){"use strict";function u(e){e=new Float64Array(e);var t=0;p.min=e[t++],p.max=e[t++],o.unpack(e,t,d),t+=o.packedLength,r.unpack(e,t,l)}function s(r,o){var a=new Uint16Array(r.positions);u(r.packedBuffer);var s=d,y=l,m=p.min,g=p.max,O=a.length/3,w=a.subarray(0,O),b=a.subarray(O,2*O),v=a.subarray(2*O,3*O);e.zigZagDeltaDecode(w,b,v);for(var x=new Float64Array(a.length),M=0;O>M;++M){var E=w[M],_=b[M],q=v[M],S=i.lerp(s.west,s.east,E/c),j=i.lerp(s.south,s.north,_/c),R=i.lerp(m,g,q/c),P=n.fromRadians(S,j,R,f),T=y.cartographicToCartesian(P,h);t.pack(T,x,3*M)}return o.push(x.buffer),{positions:x.buffer}}var c=32767,f=new n,h=new t,d=new o,l=new r,p={min:void 0,max:void 0};return a(s)})}();