/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var o={};return o.typeOf={},o.defined=function(n,o){if(!e(o))throw new t(r(n))},o.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},o.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},o.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},o.typeOf.number.lessThan=function(e,r,n){if(o.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},o.typeOf.number.lessThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},o.typeOf.number.greaterThan=function(e,r,n){if(o.typeOf.number(e,r),n>=r)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},o.typeOf.number.greaterThanOrEquals=function(e,r,n){if(o.typeOf.number(e,r),n>r)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},o.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},o.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},o.typeOf.number.equals=function(e,r,n,i){if(o.typeOf.number(e,n),o.typeOf.number(r,i),n!==i)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+i)},o}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,o){"use strict";var i={};i.Radius=6378137,i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.EPSILON21=1e-21,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*i.clamp(e,-1,1)+.5)*t)},i.fromSNorm=function(e,t){return t=r(t,255),i.clamp(e,0,t)/t*2-1},i.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),i.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=Math.PI/2,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI/2,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!n(e))throw new o("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!n(e))throw new o("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!n(e))throw new o("angle is required.");var t=i.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},i.clampToLatitudeRange=function(e){if(!n(e))throw new o("angle is required.");return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){if(!n(e))throw new o("angle is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!n(e))throw new o("angle is required.");var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){if(!n(e))throw new o("m is required.");if(!n(t))throw new o("n is required.");return(e%t+t)%t},i.equalsEpsilon=function(e,t,i,a){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");if(!n(i))throw new o("relativeEpsilon is required.");a=r(a,i);var s=Math.abs(e-t);return a>=s||s<=i*Math.max(Math.abs(e),Math.abs(t))},i.lessThan=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return-r>e-t},i.lessThanOrEquals=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return r>e-t},i.greaterThan=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return e-t>r},i.greaterThanOrEquals=function(e,t,r){if(!n(e))throw new o("first is required.");if(!n(t))throw new o("second is required.");if(!n(r))throw new o("relativeEpsilon is required.");return e-t>-r};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new o("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],n=t;e>=n;n++)a.push(r*n);return a[e]},i.incrementWrap=function(e,t,i){if(i=r(i,0),!n(e))throw new o("n is required.");if(i>=t)throw new o("maximumValue must be greater than minimumValue.");return++e,e>t&&(e=i),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new o("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new o("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,r){if(!n(e))throw new o("value is required");if(!n(t))throw new o("min is required.");if(!n(r))throw new o("max is required.");return t>e?t:e>r?r:e};var s=new e;return i.setRandomNumberSeed=function(t){if(!n(t))throw new o("seed is required.");s=new e(t)},i.nextRandomNumber=function(){return s.random()},i.randomBetween=function(e,t){return i.nextRandomNumber()*(t-e)+e},i.acosClamped=function(e){if(!n(e))throw new o("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!n(e))throw new o("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){if(!n(e))throw new o("angle is required.");if(!n(t))throw new o("radius is required.");return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){if(!n(e))throw new o("number is required.");if(!n(t))throw new o("base is required.");return Math.log(e)/Math.log(t)},i.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return 0>e?-t:t}),i.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),i.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},i.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},i.fastApproximateAtan2=function(e,r){t.typeOf.number("x",e),t.typeOf.number("y",r);var n,a,s=Math.abs(e);n=Math.abs(r),a=Math.max(s,n),n=Math.min(s,n);var u=n/a;if(isNaN(u))throw new o("either x or y must be nonzero");return s=i.fastApproximateAtan(u),s=Math.abs(r)>Math.abs(e)?i.PI_OVER_TWO-s:s,s=0>e?i.PI-s:s,s=0>r?-s:s},i}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}a.fromSpherical=function(n,o){e.typeOf.object("spherical",n),r(o)||(o=new a);var i=n.clock,s=n.cone,u=t(n.magnitude,1),c=u*Math.sin(s);return o.x=c*Math.cos(i),o.y=c*Math.sin(i),o.z=u*Math.cos(s),o},a.fromElements=function(e,t,n,o){return r(o)?(o.x=e,o.y=t,o.z=n,o):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o]=r.z,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=3*o:n=new Array(3*o);for(var i=0;o>i;++i)a.pack(t[i],n,3*i);return n},a.unpackArray=function(t,o){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var i=t.length;r(o)?o.length=i/3:o=new Array(i/3);for(var s=0;i>s;s+=3){var u=s/3;o[u]=a.unpack(t,s,o[u])}return o},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var s=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitude(s)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitudeSquared(s)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var u=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,u),o=a.multiplyByScalar(t,1-n,o),a.add(u,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f);var n=a.dot(c,f),o=a.magnitude(a.cross(c,f,c));return Math.atan2(o,n)};var l=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Z,r):n.y<=n.z?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_Z,r)},a.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var o=a.dot(t,r)/a.dot(r,r);return a.multiplyByScalar(r,o,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},a.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=r.x,u=r.y,c=r.z,f=i*c-a*u,l=a*s-o*c,p=o*u-i*s;return n.x=f,n.y=l,n.z=p,n},a.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},a.fromDegrees=function(t,r,n,o,s){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=i.toRadians(t),r=i.toRadians(r),a.fromRadians(t,r,n,o,s)};var p=new a,d=new a,h=new a(40680631590769,40680631590769,40408299984661.445),y=new a(40680631590769,40680631590769,40680631590769);return a.fromRadians=function(n,o,s,u,c){e.typeOf.number("longitude",n),e.typeOf.number("latitude",o),s=t(s,0);var f=r(u)?u.radiiSquared:y;i.equalsEpsilon(i.Radius,6356752.314245179,i.EPSILON10)&&(f=r(u)?u.radiiSquared:h);var l=Math.cos(o);p.x=l*Math.cos(n),p.y=l*Math.sin(n),p.z=Math.sin(o),p=a.normalize(p,p),a.multiplyComponents(f,p,d);var m=Math.sqrt(a.dot(p,d));return d=a.divideByScalar(d,m,d),p=a.multiplyByScalar(p,s,p),r(c)||(c=new a),a.add(d,p,c)},a.fromDegreesArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var s=t.length;r(i)?i.length=s/2:i=new Array(s/2);for(var u=0;s>u;u+=2){var c=t[u],f=t[u+1],l=u/2;i[l]=a.fromDegrees(c,f,0,o,i[l])}return i},a.fromRadiansArray=function(t,o,i){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var s=t.length;r(i)?i.length=s/2:i=new Array(s/2);for(var u=0;s>u;u+=2){var c=t[u],f=t[u+1],l=u/2;i[l]=a.fromRadians(c,f,0,o,i[l])}return i},a.fromDegreesArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var s=t.length;r(i)?i.length=s/3:i=new Array(s/3);for(var u=0;s>u;u+=3){var c=t[u],f=t[u+1],l=t[u+2],p=u/3;i[p]=a.fromDegrees(c,f,l,o,i[p])}return i},a.fromRadiansArrayHeights=function(t,o,i){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var s=t.length;r(i)?i.length=s/3:i=new Array(s/3);for(var u=0;s>u;u+=3){var c=t[u],f=t[u+1],l=t[u+2],p=u/3;i[p]=a.fromRadians(c,f,l,o,i[p])}return i},a.ZERO=o(new a(0,0,0)),a.UNIT_X=o(new a(1,0,0)),a.UNIT_Y=o(new a(0,1,0)),a.UNIT_Z=o(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function o(o,s,u,c,f){if(!t(o))throw new r("cartesian is required.");if(!t(s))throw new r("oneOverRadii is required.");if(!t(u))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=o.x,p=o.y,d=o.z,h=s.x,y=s.y,m=s.z,E=l*l*h*h,O=p*p*y*y,_=d*d*m*m,T=E+O+_,A=Math.sqrt(1/T),R=e.multiplyByScalar(o,A,i);if(c>T)return isFinite(A)?e.clone(R,f):void 0;var b=u.x,g=u.y,w=u.z,S=a;S.x=R.x*b*2,S.y=R.y*g*2,S.z=R.z*w*2;var v,C,I,N,M,x,F,D,P,U,L,B=(1-A)*e.magnitude(o)/(.5*e.magnitude(S)),q=0;do{B-=q,I=1/(1+B*b),N=1/(1+B*g),M=1/(1+B*w),x=I*I,F=N*N,D=M*M,P=x*I,U=F*N,L=D*M,v=E*x+O*F+_*D-1,C=E*P*b+O*U*g+_*L*w;var j=-2*C;q=v/j}while(Math.abs(v)>n.EPSILON12);return t(f)?(f.x=l*I,f.y=p*N,f.z=d*M,f):new e(l*I,p*N,d*M)}var i=new e,a=new e;return o}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,i,a){"use strict";function s(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}s.fromRadians=function(e,o,i,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",o),i=r(i,0),n(a)?(a.longitude=e,a.latitude=o,a.height=i,a):new s(e,o,i)},s.fromDegrees=function(e,r,n,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=i.toRadians(e),r=i.toRadians(r),s.fromRadians(e,r,n,o)};var u=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/6378137,1/6378137,1/6378137),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=new e(1/40680631590769,1/40680631590769,1/40680631590769),y=i.EPSILON1;return s.fromCartesian=function(t,r,o){var m=n(r)?r.oneOverRadii:p,E=n(r)?r.oneOverRadiiSquared:h,O=n(r)?r._centerToleranceSquared:y;i.equalsEpsilon(i.Radius,6356752.314245179,i.EPSILON10)&&(m=n(r)?r.oneOverRadii:l,E=n(r)?r.oneOverRadiiSquared:d);var _=a(t,m,E,O,c);if(n(_)){var T=e.multiplyComponents(_,E,u);T=e.normalize(T,T);var A=e.subtract(t,_,f),R=Math.atan2(T.y,T.x),b=Math.asin(T.z),g=i.sign(e.dot(A,t))*e.magnitude(A);return n(o)?(o.longitude=R,o.latitude=b,o.height=g,o):new s(R,b,g)}},s.toCartesian=function(r,n,o){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,o)},s.sphericalDistance=function(e,r,n,o){if(t.defined("longitudeA",e),t.defined("longitudeB",n),t.defined("latitudeA",r),t.defined("latitudeB",o),e===n&&r===o)return 0;var a=i.toRadians(r),s=i.toRadians(o),u=i.toRadians(e),c=i.toRadians(n),f=u*u+a*a,l=c*c+s*s,p=(u-c)*(u-c)+(a-s)*(a-s),d=(f+l-p)/(2*Math.sqrt(f)*Math.sqrt(l));return d=i.clamp(d,-1,1),Math.acos(d)*i.Radius},s.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new s(e.longitude,e.latitude,e.height):void 0},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},s.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=o&&Math.abs(e.latitude-r.latitude)<=o&&Math.abs(e.height-r.height)<=o},s.ZERO=o(new s(0,0,0)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},s}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,o,i,a,s,u,c){"use strict";function f(t,o,i,a){o=n(o,0),i=n(i,0),a=n(a,0),r.typeOf.number.greaterThanOrEquals("x",o,0),r.typeOf.number.greaterThanOrEquals("y",i,0),r.typeOf.number.greaterThanOrEquals("z",a,0),u.equalsEpsilon(a,6356752.314245179,u.EPSILON10)&&(u.Radius=a),t._radii=new e(o,i,a),t._radiiSquared=new e(o*o,i*i,a*a),t._radiiToTheFourth=new e(o*o*o*o,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===o?0:1/o,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===o?0:1/(o*o),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(o,i,a),t._maximumRadius=Math.max(o,i,a),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(o(t)){var n=t._radii;return o(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return o(t)||(t=new l),o(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=s(new l(6378137,6378137,u.Radius)),l.UNIT_SPHERE=s(new l(1,1,1)),l.MOON=s(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,o,i){return r.typeOf.object("value",t),r.defined("array",o),i=n(i,0),e.pack(t._radii,o,i),o},l.unpack=function(t,o,i){r.defined("array",t),o=n(o,0);var a=e.unpack(t,o);return l.fromCartesian3(a,i)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var i=t.longitude,a=t.latitude,s=Math.cos(a),u=s*Math.cos(i),c=s*Math.sin(i),f=Math.sin(a);return o(n)||(n=new e),n.x=u,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return o(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var p=new e,d=new e;l.prototype.cartographicToCartesian=function(t,r){var n=p,i=d;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,i);var a=Math.sqrt(e.dot(n,i));return e.divideByScalar(i,a,i),e.multiplyByScalar(n,t.height,n),o(r)||(r=new e),e.add(i,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;n>i;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var h=new e,y=new e,m=new e;return l.prototype.cartesianToCartographic=function(r,n){var i=this.scaleToGeodeticSurface(r,y);if(o(i)){var a=this.geodeticSurfaceNormal(i,h),s=e.subtract(r,i,m),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=u.sign(e.dot(s,r))*e.magnitude(s);return o(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;o(t)?t.length=n:t=new Array(n);for(var i=0;n>i;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),o(n)||(n=new e);var i=t.x,a=t.y,s=t.z,u=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return o(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||o(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,s){if(r.typeOf.object("position",t),!u.equalsEpsilon(this._radii.x,this._radii.y,u.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),i=n(i,0);var c=this._squaredXOverSquaredZ;return o(s)||(s=new e),s.x=0,s.y=0,s.z=t.z*(1-c),Math.abs(s.z)>=this._radii.z-i?void 0:s},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,o,i,a){"use strict";function s(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return o(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,r){var o=this._semimajorAxis,i=t.longitude*o,a=t.latitude*o,s=t.height;return n(r)?(r.x=i,r.y=a,r.z=s,r):new e(i,a,s)},s.prototype.unproject=function(e,r){if(!n(e))throw new i("cartesian is required");var o=this._oneOverSemimajorAxis,a=e.x*o,s=e.y*o,u=e.z;return n(r)?(r.longitude=a,r.latitude=s,r.height=u,r):new t(a,s,u)},s}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i,a,s){"use strict";function u(e,t,n,o,i,a,s,u,c){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(i,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function f(e){for(var t=0,r=0;3>r;++r){var n=e[u.getElementIndex(y[r],h[r])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var r=s.EPSILON15,n=0,o=1,i=0;3>i;++i){var a=Math.abs(e[u.getElementIndex(y[i],h[i])]);a>n&&(o=i,n=a)}var c=1,f=0,l=h[o],p=y[o];if(Math.abs(e[u.getElementIndex(p,l)])>r){var d,m=e[u.getElementIndex(p,p)],E=e[u.getElementIndex(l,l)],O=e[u.getElementIndex(p,l)],_=(m-E)/2/O;d=0>_?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),c=1/Math.sqrt(1+d*d),f=d*c}return t=u.clone(u.IDENTITY,t),t[u.getElementIndex(l,l)]=t[u.getElementIndex(p,p)]=c,t[u.getElementIndex(p,l)]=f,t[u.getElementIndex(l,p)]=-f,t}u.packedLength=9,u.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8],n},u.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i[0]=e[o++],i[1]=e[o++],i[2]=e[o++],i[3]=e[o++],i[4]=e[o++],i[5]=e[o++],i[6]=e[o++],i[7]=e[o++],i[8]=e[o++],i},u.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new u(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},u.fromArray=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i[0]=e[o],i[1]=e[o+1],i[2]=e[o+2],i[3]=e[o+3],i[4]=e[o+4],i[5]=e[o+5],i[6]=e[o+6],i[7]=e[o+7],i[8]=e[o+8],i},u.fromColumnMajorArray=function(e,r){return t.defined("values",e),u.clone(e,r)},u.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new u(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},u.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var o=e.x*e.x,i=e.x*e.y,a=e.x*e.z,s=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,p=e.z*e.z,d=e.z*e.w,h=e.w*e.w,y=o-c-p+h,m=2*(i-d),E=2*(a+l),O=2*(i+d),_=-o+c-p+h,T=2*(f-s),A=2*(a-l),R=2*(f+s),b=-o-c+p+h;return n(r)?(r[0]=y,r[1]=O,r[2]=A,r[3]=m,r[4]=_,r[5]=R,r[6]=E,r[7]=T,r[8]=b,r):new u(y,m,E,O,_,T,A,R,b)},u.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var o=Math.cos(-e.pitch),i=Math.cos(-e.heading),a=Math.cos(e.roll),s=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=o*i,p=-a*c+f*s*i,d=f*c+a*s*i,h=o*c,y=a*i+f*s*c,m=-f*i+a*s*c,E=-s,O=f*o,_=a*o;return n(r)?(r[0]=l,r[1]=h,r[2]=E,r[3]=p,r[4]=y,r[5]=O,r[6]=d,r[7]=m,r[8]=_,r):new u(l,p,d,h,y,m,E,O,_)},u.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new u(e.x,0,0,0,e.y,0,0,0,e.z)},u.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new u(e,0,0,0,e,0,0,0,e)},u.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new u(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},u.fromRotationX=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=o,r[5]=i,r[6]=0,r[7]=-i,r[8]=o,r):new u(1,0,0,0,o,-i,0,i,o)},u.fromRotationY=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=0,r[2]=-i,r[3]=0,r[4]=1,r[5]=0,r[6]=i,r[7]=0,r[8]=o,r):new u(o,0,i,0,1,0,-i,0,o)},u.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=i,r[2]=0,r[3]=-i,r[4]=o,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new u(o,-i,0,i,o,0,0,0,1)},u.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},u.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},u.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=3*r,i=e[o],a=e[o+1],s=e[o+2];return n.x=i,n.y=a,n.z=s,n},u.setColumn=function(e,r,n,o){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),o=u.clone(e,o);var i=3*r;return o[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o},u.getRow=function(e,r,n){t.typeOf.object("matrix",e),
t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var o=e[r],i=e[r+3],a=e[r+6];return n.x=o,n.y=i,n.z=a,n},u.setRow=function(e,r,n,o){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),o=u.clone(e,o),o[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var p=new e;u.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],p)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],p)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],p)),n};var d=new e;u.getMaximumScale=function(t){return u.getScale(t,d),e.maximumComponent(d)},u.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],i=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],u=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=i,n[2]=a,n[3]=s,n[4]=u,n[5]=c,n[6]=f,n[7]=l,n[8]=p,n},u.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},u.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},u.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=r.x,i=r.y,a=r.z,s=e[0]*o+e[3]*i+e[6]*a,u=e[1]*o+e[4]*i+e[7]*a,c=e[2]*o+e[5]*i+e[8]*a;return n.x=s,n.y=u,n.z=c,n},u.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},u.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},u.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},u.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[3],i=e[6],a=e[1],s=e[4],u=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r[4]=s,r[5]=u,r[6]=c,r[7]=f,r[8]=l,r};var h=[1,0,0],y=[2,2,1],m=new u,E=new u;return u.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var o=s.EPSILON20,i=10,a=0,p=0;n(r)||(r={});for(var d=r.unitary=u.clone(u.IDENTITY,r.unitary),h=r.diagonal=u.clone(e,r.diagonal),y=o*c(h);i>p&&f(h)>y;)l(h,m),u.transpose(m,E),u.multiply(h,m,h),u.multiply(E,h,h),u.multiply(d,m,d),++a>2&&(++p,a=0);return r},u.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},u.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],o=e[6],i=e[1],a=e[4],s=e[7],u=e[2],c=e[5],f=e[8];return r*(a*f-c*s)+i*(c*o-n*f)+u*(n*s-a*o)},u.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[1],a=e[2],c=e[3],f=e[4],l=e[5],p=e[6],d=e[7],h=e[8],y=u.determinant(e);if(Math.abs(y)<=s.EPSILON15)throw new i("matrix is not invertible");r[0]=f*h-d*l,r[1]=d*a-o*h,r[2]=o*l-f*a,r[3]=p*l-c*h,r[4]=n*h-p*a,r[5]=c*a-n*l,r[6]=c*d-p*f,r[7]=p*o-n*d,r[8]=n*f-c*o;var m=1/y;return u.multiplyByScalar(r,m,r)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=o&&Math.abs(e[1]-r[1])<=o&&Math.abs(e[2]-r[2])<=o&&Math.abs(e[3]-r[3])<=o&&Math.abs(e[4]-r[4])<=o&&Math.abs(e[5]-r[5])<=o&&Math.abs(e[6]-r[6])<=o&&Math.abs(e[7]-r[7])<=o&&Math.abs(e[8]-r[8])<=o},u.IDENTITY=a(new u(1,0,0,0,1,0,0,0,1)),u.ZERO=a(new u(0,0,0,0,0,0,0,0,0)),u.COLUMN0ROW0=0,u.COLUMN0ROW1=1,u.COLUMN0ROW2=2,u.COLUMN1ROW0=3,u.COLUMN1ROW1=4,u.COLUMN1ROW2=5,u.COLUMN2ROW0=6,u.COLUMN2ROW1=7,u.COLUMN2ROW2=8,o(u.prototype,{length:{get:function(){return u.packedLength}}}),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},u}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,r,n,o){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(o,0)}a.fromElements=function(e,t,n,o,i){return r(i)?(i.x=e,i.y=t,i.z=n,i.w=o,i):new a(e,t,n,o)},a.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o++]=r.y,n[o++]=r.z,n[o]=r.w,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o++],i.z=n[o++],i.w=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=4*o:n=new Array(4*o);for(var i=0;o>i;++i)a.pack(t[i],n,4*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/4:n=new Array(o/4);for(var i=0;o>i;i+=4){var s=i/4;n[s]=a.unpack(t,i,n[s])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var s=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitude(s)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitudeSquared(s)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,r.z=t.z/o,r.w=t.w/o,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var u=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,u),o=a.multiplyByScalar(t,1-n,o),a.add(u,o,o)};var c=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,c);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},a.ZERO=o(new a(0,0,0,0)),a.UNIT_X=o(new a(1,0,0,0)),a.UNIT_Y=o(new a(0,1,0,0)),a.UNIT_Z=o(new a(0,0,1,0)),a.UNIT_W=o(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1),l=256,p=65536,d=16777216,h=1/l,y=1/p,m=1/d,E=38;return a.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new a),f[0]=t,t=f[0],0===t)return a.clone(a.ZERO,n);var o,s=0>t?1:0;isFinite(t)?(t=Math.abs(t),o=Math.floor(i.logBase(t,10))+1,t/=Math.pow(10,o)):(t=.1,o=E);var u=t*l;return n.x=Math.floor(u),u=(u-n.x)*l,n.y=Math.floor(u),u=(u-n.y)*l,n.z=Math.floor(u),n.w=2*(o+E)+s,n},a.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),o=2*(r-n);if(n-=E,o=2*o-1,o=-o,n>=E)return 0>o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var i=o*t.x*h;return i+=o*t.y*y,i+=o*t.z*m,i*Math.pow(10,n)},a}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,o,i,a,s,u,c){"use strict";function f(e,t,r,o,i,a,s,u,c,f,l,p,d,h,y,m){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(a,0),this[6]=n(f,0),this[7]=n(h,0),this[8]=n(r,0),this[9]=n(s,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(o,0),this[13]=n(u,0),this[14]=n(p,0),this[15]=n(m,0)}f.packedLength=16,f.pack=function(e,t,o){return r.typeOf.object("value",e),r.defined("array",t),o=n(o,0),t[o++]=e[0],t[o++]=e[1],t[o++]=e[2],t[o++]=e[3],t[o++]=e[4],t[o++]=e[5],t[o++]=e[6],t[o++]=e[7],t[o++]=e[8],t[o++]=e[9],t[o++]=e[10],t[o++]=e[11],t[o++]=e[12],t[o++]=e[13],t[o++]=e[14],t[o]=e[15],t},f.unpack=function(e,t,i){return r.defined("array",e),t=n(t,0),o(i)||(i=new f),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},f.clone=function(e,t){return o(e)?o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),o(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,i,a){return r.typeOf.object("rotation",t),i=n(i,e.ZERO),o(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=i.x,a[13]=i.y,a[14]=i.z,a[15]=1,a):new f(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,i){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),o(i)||(i=new f);var a=n.x,s=n.y,u=n.z,c=t.x*t.x,l=t.x*t.y,p=t.x*t.z,d=t.x*t.w,h=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,O=t.z*t.w,_=t.w*t.w,T=c-h-E+_,A=2*(l-O),R=2*(p+m),b=2*(l+O),g=-c+h-E+_,w=2*(y-d),S=2*(p-m),v=2*(y+d),C=-c-h+E+_;return i[0]=T*a,i[1]=b*a,i[2]=S*a,i[3]=0,i[4]=A*s,i[5]=g*s,i[6]=v*s,i[7]=0,i[8]=R*u,i[9]=w*u,i[10]=C*u,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(u.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),o(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),o(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,p=new e,d=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var i=t.position,a=t.direction,s=t.up;r.typeOf.object("camera.position",i),r.typeOf.object("camera.direction",a),r.typeOf.object("camera.up",s),e.normalize(a,l),e.normalize(e.cross(l,s,p),p),e.normalize(e.cross(p,l,d),d);var u=p.x,c=p.y,h=p.z,y=l.x,m=l.y,E=l.z,O=d.x,_=d.y,T=d.z,A=i.x,R=i.y,b=i.z,g=u*-A+c*-R+h*-b,w=O*-A+_*-R+T*-b,S=y*A+m*R+E*b;return o(n)?(n[0]=u,n[1]=O,n[2]=-y,n[3]=0,n[4]=c,n[5]=_,n[6]=-m,n[7]=0,n[8]=h,n[9]=T,n[10]=-E,n[11]=0,n[12]=g,n[13]=w,n[14]=S,n[15]=1,n):new f(u,c,h,g,O,_,T,w,-y,-m,-E,S,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,o,i){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",o,0),r.typeOf.object("result",i);var a=Math.tan(.5*e),s=1/a,u=s/t,c=(o+n)/(n-o),f=2*o*n/(n-o);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=s,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=c,i[11]=-1,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},f.computeOrthographicOffCenter=function(e,t,n,o,i,a,s){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",s);var u=1/(t-e),c=1/(o-n),f=1/(a-i),l=-(t+e)*u,p=-(o+n)*c,d=-(a+i)*f;return u*=2,c*=2,f*=-2,s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=l,s[13]=p,s[14]=d,s[15]=1,s},f.computePerspectiveOffCenter=function(e,t,n,o,i,a,s){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.number("far",a),r.typeOf.object("result",s);var u=2*i/(t-e),c=2*i/(o-n),f=(t+e)/(t-e),l=(o+n)/(o-n),p=-(a+i)/(a-i),d=-1,h=-2*a*i/(a-i);return s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=l,s[10]=p,s[11]=d,s[12]=0,s[13]=0,s[14]=h,s[15]=0,s},f.computeInfinitePerspectiveOffCenter=function(e,t,n,o,i,a){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",o),r.typeOf.number("near",i),r.typeOf.object("result",a);var s=2*i/(t-e),u=2*i/(o-n),c=(t+e)/(t-e),f=(o+n)/(o-n),l=-1,p=-1,d=-2*i;return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=l,a[11]=p,a[12]=0,a[13]=0,a[14]=d,a[15]=0,a},f.computeViewportTransformation=function(e,t,o,i){r.typeOf.object("result",i),e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),s=n(e.y,0),u=n(e.width,0),c=n(e.height,0);t=n(t,0),o=n(o,1);var f=.5*u,l=.5*c,p=.5*(o-t),d=f,h=l,y=p,m=a+f,E=s+l,O=t+p,_=1;return i[0]=d,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=h,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=y,i[11]=0,i[12]=m,i[13]=E,i[14]=O,i[15]=_,i},f.computeView=function(t,n,o,i,a){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",o),r.typeOf.object("right",i),r.typeOf.object("result",a),a[0]=i.x,a[1]=o.x,a[2]=-n.x,a[3]=0,a[4]=i.y,a[5]=o.y,a[6]=-n.y,a[7]=0,a[8]=i.z,a[9]=o.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(i,t),a[13]=-e.dot(o,t),a[14]=e.dot(n,t),a[15]=1,a},f.toArray=function(e,t){return r.typeOf.object("matrix",e),o(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var o=4*t,i=e[o],a=e[o+1],s=e[o+2],u=e[o+3];return n.x=i,n.y=a,n.z=s,n.w=u,n},f.setColumn=function(e,t,n,o){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o),o=f.clone(e,o);var i=4*t;return o[i]=n.x,o[i+1]=n.y,o[i+2]=n.z,o[i+3]=n.w,o},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var h=new e;f.setScale=function(t,n,o){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",o);var i=f.getScale(t,h),a=e.divideComponents(n,i,h);return f.multiplyByScale(t,a,o)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var o=e[t],i=e[t+4],a=e[t+8],s=e[t+12];return n.x=o,n.y=i,n.z=a,n.w=s,n},f.setRow=function(e,t,n,o){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",o),o=f.clone(e,o),o[t]=n.x,o[t+4]=n.y,o[t+8]=n.z,o[t+12]=n.w,o};var y=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var m=new e;f.getMaximumScale=function(t){return f.getScale(t,m),e.maximumComponent(m)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],s=e[3],u=e[4],c=e[5],f=e[6],l=e[7],p=e[8],d=e[9],h=e[10],y=e[11],m=e[12],E=e[13],O=e[14],_=e[15],T=t[0],A=t[1],R=t[2],b=t[3],g=t[4],w=t[5],S=t[6],v=t[7],C=t[8],I=t[9],N=t[10],M=t[11],x=t[12],F=t[13],D=t[14],P=t[15],U=o*T+u*A+p*R+m*b,L=i*T+c*A+d*R+E*b,B=a*T+f*A+h*R+O*b,q=s*T+l*A+y*R+_*b,j=o*g+u*w+p*S+m*v,z=i*g+c*w+d*S+E*v,G=a*g+f*w+h*S+O*v,k=s*g+l*w+y*S+_*v,V=o*C+u*I+p*N+m*M,W=i*C+c*I+d*N+E*M,Y=a*C+f*I+h*N+O*M,H=s*C+l*I+y*N+_*M,X=o*x+u*F+p*D+m*P,K=i*x+c*F+d*D+E*P,Z=a*x+f*F+h*D+O*P,J=s*x+l*F+y*D+_*P;return n[0]=U,n[1]=L,n[2]=B,n[3]=q,n[4]=j,n[5]=z,n[6]=G,n[7]=k,n[8]=V,n[9]=W,n[10]=Y,n[11]=H,n[12]=X,n[13]=K,n[14]=Z,n[15]=J,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],s=e[4],u=e[5],c=e[6],f=e[8],l=e[9],p=e[10],d=e[12],h=e[13],y=e[14],m=t[0],E=t[1],O=t[2],_=t[4],T=t[5],A=t[6],R=t[8],b=t[9],g=t[10],w=t[12],S=t[13],v=t[14],C=o*m+s*E+f*O,I=i*m+u*E+l*O,N=a*m+c*E+p*O,M=o*_+s*T+f*A,x=i*_+u*T+l*A,F=a*_+c*T+p*A,D=o*R+s*b+f*g,P=i*R+u*b+l*g,U=a*R+c*b+p*g,L=o*w+s*S+f*v+d,B=i*w+u*S+l*v+h,q=a*w+c*S+p*v+y;return n[0]=C,n[1]=I,n[2]=N,n[3]=0,n[4]=M,n[5]=x,n[6]=F,n[7]=0,n[8]=D,n[9]=P,n[10]=U,n[11]=0,n[12]=L,n[13]=B,n[14]=q,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var o=e[0],i=e[1],a=e[2],s=e[4],u=e[5],c=e[6],f=e[8],l=e[9],p=e[10],d=t[0],h=t[1],y=t[2],m=t[3],E=t[4],O=t[5],_=t[6],T=t[7],A=t[8],R=o*d+s*h+f*y,b=i*d+u*h+l*y,g=a*d+c*h+p*y,w=o*m+s*E+f*O,S=i*m+u*E+l*O,v=a*m+c*E+p*O,C=o*_+s*T+f*A,I=i*_+u*T+l*A,N=a*_+c*T+p*A;return n[0]=R,n[1]=b,n[2]=g,n[3]=0,n[4]=w,n[5]=S,n[6]=v,n[7]=0,n[8]=C,n[9]=I,n[10]=N,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=o*e[0]+i*e[4]+a*e[8]+e[12],u=o*e[1]+i*e[5]+a*e[9]+e[13],c=o*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=s,n[13]=u,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z;return 1===o&&1===i&&1===a?f.clone(e,n):(n[0]=o*e[0],n[1]=o*e[1],n[2]=o*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=t.w,u=e[0]*o+e[4]*i+e[8]*a+e[12]*s,c=e[1]*o+e[5]*i+e[9]*a+e[13]*s,f=e[2]*o+e[6]*i+e[10]*a+e[14]*s,l=e[3]*o+e[7]*i+e[11]*a+e[15]*s;return n.x=u,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=e[0]*o+e[4]*i+e[8]*a,u=e[1]*o+e[5]*i+e[9]*a,c=e[2]*o+e[6]*i+e[10]*a;return n.x=s,n.y=u,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var o=t.x,i=t.y,a=t.z,s=e[0]*o+e[4]*i+e[8]*a+e[12],u=e[1]*o+e[5]*i+e[9]*a+e[13],c=e[2]*o+e[6]*i+e[10]*a+e[14];return n.x=s,n.y=u,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.multiplyByPlane=function(n,o,i){r.typeOf.object("matrix",n),r.typeOf.object("plane",o),r.typeOf.object("result",i);var a=new f,s=new f;f.inverse(n,a),f.transpose(a,s);var u=new t(o.normal.x,o.normal.y,o.normal.z,o.distance);f.multiplyByVector(s,u,u),i.normal.x=u.x,i.normal.y=u.y,i.normal.z=u.z;var c=e.magnitude(i.normal);return e.normalize(i.normal,i.normal),i.distance=u.w/c,i},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],o=e[2],i=e[3],a=e[6],s=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=o,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=s,t[14]=u,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||o(e)&&o(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||o(e)&&o(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new u,_=new u,T=new t,A=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var o=e[0],i=e[4],a=e[8],l=e[12],p=e[1],d=e[5],h=e[9],y=e[13],m=e[2],E=e[6],R=e[10],b=e[14],g=e[3],w=e[7],S=e[11],v=e[15],C=R*v,I=b*S,N=E*v,M=b*w,x=E*S,F=R*w,D=m*v,P=b*g,U=m*S,L=R*g,B=m*w,q=E*g,j=C*d+M*h+x*y-(I*d+N*h+F*y),z=I*p+D*h+L*y-(C*p+P*h+U*y),G=N*p+P*d+B*y-(M*p+D*d+q*y),k=F*p+U*d+q*h-(x*p+L*d+B*h),V=I*i+N*a+F*l-(C*i+M*a+x*l),W=C*o+P*a+U*l-(I*o+D*a+L*l),Y=M*o+D*i+q*l-(N*o+P*i+B*l),H=x*o+L*i+B*a-(F*o+U*i+q*a);C=a*y,I=l*h,N=i*y,M=l*d,x=i*h,F=a*d,D=o*y,P=l*p,U=o*h,L=a*p,B=o*d,q=i*p;var X=C*w+M*S+x*v-(I*w+N*S+F*v),K=I*g+D*S+L*v-(C*g+P*S+U*v),Z=N*g+P*w+B*v-(M*g+D*w+q*v),J=F*g+U*w+q*S-(x*g+L*w+B*S),Q=N*R+F*b+I*E-(x*b+C*E+M*R),$=U*b+C*m+P*R-(D*R+L*b+I*m),ee=D*E+q*b+M*m-(B*b+N*m+P*E),te=B*R+x*m+L*E-(U*E+q*R+F*m),re=o*j+i*z+a*G+l*k;if(Math.abs(re)<s.EPSILON21){if(u.equalsEpsilon(f.getRotation(e,O),_,s.EPSILON7)&&t.equals(f.getRow(e,3,T),A))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=j*re,n[1]=z*re,n[2]=G*re,n[3]=k*re,n[4]=V*re,n[5]=W*re,n[6]=Y*re,n[7]=H*re,n[8]=X*re,n[9]=K*re,n[10]=Z*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],o=e[1],i=e[2],a=e[4],s=e[5],u=e[6],c=e[8],f=e[9],l=e[10],p=e[12],d=e[13],h=e[14],y=-n*p-o*d-i*h,m=-a*p-s*d-u*h,E=-c*p-f*d-l*h;return t[0]=n,t[1]=a,t[2]=c,t[3]=0,t[4]=o,t[5]=s,t[6]=f,t[7]=0,t[8]=i,t[9]=u,t[10]=l,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,i(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,o,i,a,s){"use strict";function u(e,t,n,o){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(o,0)}o(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north,n},u.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i.west=e[o++],i.south=e[o++],i.east=e[o++],i.north=e[o],i},u.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return n>r&&(r+=s.TWO_PI),r-n},u.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},u.fromDegrees=function(e,t,o,i,a){return e=s.toRadians(r(e,0)),t=s.toRadians(r(t,0)),o=s.toRadians(r(o,0)),i=s.toRadians(r(i,0)),n(a)?(a.west=e,a.south=t,a.east=o,a.north=i,a):new u(e,t,o,i)},u.fromRadians=function(e,t,o,i,a){return n(a)?(a.west=r(e,0),a.south=r(t,0),a.east=r(o,0),a.north=r(i,0),
a):new u(e,t,o,i)},u.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var o=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,p=0,d=e.length;d>p;p++){var h=e[p];o=Math.min(o,h.longitude),i=Math.max(i,h.longitude),f=Math.min(f,h.latitude),l=Math.max(l,h.latitude);var y=h.longitude>=0?h.longitude:h.longitude+s.TWO_PI;a=Math.min(a,y),c=Math.max(c,y)}return i-o>c-a&&(o=a,i=c,i>s.PI&&(i-=s.TWO_PI),o>s.PI&&(o-=s.TWO_PI)),n(r)?(r.west=o,r.south=f,r.east=i,r.north=l,r):new u(o,f,i,l)},u.fromCartesianArray=function(e,o,a){t.defined("cartesians",e),o=r(o,i.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,d=Number.MAX_VALUE,h=-Number.MAX_VALUE,y=0,m=e.length;m>y;y++){var E=o.cartesianToCartographic(e[y]);c=Math.min(c,E.longitude),f=Math.max(f,E.longitude),d=Math.min(d,E.latitude),h=Math.max(h,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+s.TWO_PI;l=Math.min(l,O),p=Math.max(p,O)}return f-c>p-l&&(c=l,f=p,f>s.PI&&(f-=s.TWO_PI),c>s.PI&&(c-=s.TWO_PI)),n(a)?(a.west=c,a.south=d,a.east=f,a.north=h,a):new u(c,d,f,h)},u.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new u(e.west,e.south,e.east,e.north):void 0},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("absoluteEpsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=o&&Math.abs(e.south-r.south)<=o&&Math.abs(e.east-r.east)<=o&&Math.abs(e.north-r.north)<=o},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},u.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),u.equalsEpsilon(this,e,r)},u.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-s.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,s.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-s.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,s.PI_OVER_TWO);var o=e.west;t.typeOf.number.greaterThanOrEquals("west",o,-Math.PI),t.typeOf.number.lessThanOrEquals("west",o,Math.PI);var i=e.east;t.typeOf.number.greaterThanOrEquals("east",i,-Math.PI),t.typeOf.number.lessThanOrEquals("east",i,Math.PI)},u.southwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.south,o.height=0,o):new e(r.west,r.south)},u.northwest=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.west,o.latitude=r.north,o.height=0,o):new e(r.west,r.north)},u.northeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.north,o.height=0,o):new e(r.east,r.north)},u.southeast=function(r,o){return t.typeOf.object("rectangle",r),n(o)?(o.longitude=r.east,o.latitude=r.south,o.height=0,o):new e(r.east,r.south)},u.center=function(r,o){t.typeOf.object("rectangle",r);var i=r.east,a=r.west;a>i&&(i+=s.TWO_PI);var u=s.negativePiToPi(.5*(a+i)),c=.5*(r.south+r.north);return n(o)?(o.longitude=u,o.latitude=c,o.height=0,o):new e(u,c)},u.intersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=e.east,a=e.west,c=r.east,f=r.west;a>i&&c>0?i+=s.TWO_PI:f>c&&i>0&&(c+=s.TWO_PI),a>i&&0>f?f+=s.TWO_PI:f>c&&0>a&&(a+=s.TWO_PI);var l=s.negativePiToPi(Math.max(a,f)),p=s.negativePiToPi(Math.min(i,c));if(!((e.west<e.east||r.west<r.east)&&l>=p)){var d=Math.max(e.south,r.south),h=Math.min(e.north,r.north);if(!(d>=h))return n(o)?(o.west=l,o.south=d,o.east=p,o.north=h,o):new u(l,d,p,h)}},u.simpleIntersection=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=Math.max(e.west,r.west),a=Math.max(e.south,r.south),s=Math.min(e.east,r.east),c=Math.min(e.north,r.north);return a>=c||i>=s?void 0:n(o)?(o.west=i,o.south=a,o.east=s,o.north=c,o):new u(i,a,s,c)},u.union=function(e,r,o){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(o)||(o=new u);var i=e.east,a=e.west,c=r.east,f=r.west;a>i&&c>0?i+=s.TWO_PI:f>c&&i>0&&(c+=s.TWO_PI),a>i&&0>f?f+=s.TWO_PI:f>c&&0>a&&(a+=s.TWO_PI);var l=s.convertLongitudeRange(Math.min(a,f)),p=s.convertLongitudeRange(Math.max(i,c));return o.west=l,o.south=Math.min(e.south,r.south),o.east=p,o.north=Math.max(e.north,r.north),o},u.expand=function(e,r,o){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(o)||(o=new u),o.west=Math.min(e.west,r.longitude),o.south=Math.min(e.south,r.latitude),o.east=Math.max(e.east,r.longitude),o.north=Math.max(e.north,r.latitude),o},u.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,o=r.latitude,i=e.west,a=e.east;return i>a&&(a+=s.TWO_PI,0>n&&(n+=s.TWO_PI)),(n>i||s.equalsEpsilon(n,i,s.EPSILON14))&&(a>n||s.equalsEpsilon(n,a,s.EPSILON14))&&o>=e.south&&o<=e.north};var c=new e;return u.subsample=function(e,o,a,f){t.typeOf.object("rectangle",e),o=r(o,i.WGS84),a=r(a,0),n(f)||(f=[]);var l=0,p=e.north,d=e.south,h=e.east,y=e.west,m=c;m.height=a,m.longitude=y,m.latitude=p,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=h,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.latitude=d,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=y,f[l]=o.cartographicToCartesian(m,f[l]),l++,0>p?m.latitude=p:d>0?m.latitude=d:m.latitude=0;for(var E=1;8>E;++E)m.longitude=-Math.PI+E*s.PI_OVER_TWO,u.contains(e,m)&&(f[l]=o.cartographicToCartesian(m,f[l]),l++);return 0===m.latitude&&(m.longitude=y,f[l]=o.cartographicToCartesian(m,f[l]),l++,m.longitude=h,f[l]=o.cartographicToCartesian(m,f[l]),l++),f.length=l,f},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,o,i,a,s,u,c,f,l,p){"use strict";function d(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var h=new e,y=new e,m=new e,E=new e,O=new e,_=new e,T=new e,A=new e,R=new e,b=new e,g=new e,w=new e,S=4/3*c.PI;d.fromPoints=function(t,r){if(o(r)||(r=new d),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,i=e.clone(t[0],T),a=e.clone(i,h),s=e.clone(i,y),u=e.clone(i,m),c=e.clone(i,E),f=e.clone(i,O),l=e.clone(i,_),p=t.length;for(n=1;p>n;n++){e.clone(t[n],i);var S=i.x,v=i.y,C=i.z;S<a.x&&e.clone(i,a),S>c.x&&e.clone(i,c),v<s.y&&e.clone(i,s),v>f.y&&e.clone(i,f),C<u.z&&e.clone(i,u),C>l.z&&e.clone(i,l)}var I=e.magnitudeSquared(e.subtract(c,a,A)),N=e.magnitudeSquared(e.subtract(f,s,A)),M=e.magnitudeSquared(e.subtract(l,u,A)),x=a,F=c,D=I;N>D&&(D=N,x=s,F=f),M>D&&(D=M,x=u,F=l);var P=R;P.x=.5*(x.x+F.x),P.y=.5*(x.y+F.y),P.z=.5*(x.z+F.z);var U=e.magnitudeSquared(e.subtract(F,P,A)),L=Math.sqrt(U),B=b;B.x=a.x,B.y=s.y,B.z=u.z;var q=g;q.x=c.x,q.y=f.y,q.z=l.z;var j=e.midpoint(B,q,w),z=0;for(n=0;p>n;n++){e.clone(t[n],i);var G=e.magnitude(e.subtract(i,j,A));G>z&&(z=G);var k=e.magnitudeSquared(e.subtract(i,P,A));if(k>U){var V=Math.sqrt(k);L=.5*(L+V),U=L*L;var W=V-L;P.x=(L*P.x+W*i.x)/V,P.y=(L*P.y+W*i.y)/V,P.z=(L*P.z+W*i.z)/V}}return z>L?(e.clone(P,r.center),r.radius=L):(e.clone(j,r.center),r.radius=z),r};var v=new a,C=new e,I=new e,N=new t,M=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,r,i,a,s){if(o(s)||(s=new d),!o(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;r=n(r,v),p.southwest(t,N),N.height=i,p.northeast(t,M),M.height=a;var u=r.project(N,C),c=r.project(M,I),f=c.x-u.x,l=c.y-u.y,h=c.z-u.z;s.radius=.5*Math.sqrt(f*f+l*l+h*h);var y=s.center;return y.x=u.x+.5*f,y.y=u.y+.5*l,y.z=u.z+.5*h,s};var x=[];d.fromRectangle3D=function(t,r,a,s){if(r=n(r,i.WGS84),a=n(a,0),o(s)||(s=new d),!o(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;var u=p.subsample(t,r,a,x);return d.fromPoints(u,s)},d.fromVertices=function(t,i,a,s){if(o(s)||(s=new d),!o(t)||0===t.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=n(i,e.ZERO),a=n(a,3),r.typeOf.number.greaterThanOrEquals("stride",a,3);var u=T;u.x=t[0]+i.x,u.y=t[1]+i.y,u.z=t[2]+i.z;var c,f=e.clone(u,h),l=e.clone(u,y),p=e.clone(u,m),S=e.clone(u,E),v=e.clone(u,O),C=e.clone(u,_),I=t.length;for(c=0;I>c;c+=a){var N=t[c]+i.x,M=t[c+1]+i.y,x=t[c+2]+i.z;u.x=N,u.y=M,u.z=x,N<f.x&&e.clone(u,f),N>S.x&&e.clone(u,S),M<l.y&&e.clone(u,l),M>v.y&&e.clone(u,v),x<p.z&&e.clone(u,p),x>C.z&&e.clone(u,C)}var F=e.magnitudeSquared(e.subtract(S,f,A)),D=e.magnitudeSquared(e.subtract(v,l,A)),P=e.magnitudeSquared(e.subtract(C,p,A)),U=f,L=S,B=F;D>B&&(B=D,U=l,L=v),P>B&&(B=P,U=p,L=C);var q=R;q.x=.5*(U.x+L.x),q.y=.5*(U.y+L.y),q.z=.5*(U.z+L.z);var j=e.magnitudeSquared(e.subtract(L,q,A)),z=Math.sqrt(j),G=b;G.x=f.x,G.y=l.y,G.z=p.z;var k=g;k.x=S.x,k.y=v.y,k.z=C.z;var V=e.midpoint(G,k,w),W=0;for(c=0;I>c;c+=a){u.x=t[c]+i.x,u.y=t[c+1]+i.y,u.z=t[c+2]+i.z;var Y=e.magnitude(e.subtract(u,V,A));Y>W&&(W=Y);var H=e.magnitudeSquared(e.subtract(u,q,A));if(H>j){var X=Math.sqrt(H);z=.5*(z+X),j=z*z;var K=X-z;q.x=(z*q.x+K*u.x)/X,q.y=(z*q.y+K*u.y)/X,q.z=(z*q.z+K*u.z)/X}}return W>z?(e.clone(q,s.center),s.radius=z):(e.clone(V,s.center),s.radius=W),s},d.fromEncodedCartesianVertices=function(t,r,n){if(o(n)||(n=new d),!o(t)||!o(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=T;i.x=t[0]+r[0],i.y=t[1]+r[1],i.z=t[2]+r[2];var a,s=e.clone(i,h),u=e.clone(i,y),c=e.clone(i,m),f=e.clone(i,E),l=e.clone(i,O),p=e.clone(i,_),S=t.length;for(a=0;S>a;a+=3){var v=t[a]+r[a],C=t[a+1]+r[a+1],I=t[a+2]+r[a+2];i.x=v,i.y=C,i.z=I,v<s.x&&e.clone(i,s),v>f.x&&e.clone(i,f),C<u.y&&e.clone(i,u),C>l.y&&e.clone(i,l),I<c.z&&e.clone(i,c),I>p.z&&e.clone(i,p)}var N=e.magnitudeSquared(e.subtract(f,s,A)),M=e.magnitudeSquared(e.subtract(l,u,A)),x=e.magnitudeSquared(e.subtract(p,c,A)),F=s,D=f,P=N;M>P&&(P=M,F=u,D=l),x>P&&(P=x,F=c,D=p);var U=R;U.x=.5*(F.x+D.x),U.y=.5*(F.y+D.y),U.z=.5*(F.z+D.z);var L=e.magnitudeSquared(e.subtract(D,U,A)),B=Math.sqrt(L),q=b;q.x=s.x,q.y=u.y,q.z=c.z;var j=g;j.x=f.x,j.y=l.y,j.z=p.z;var z=e.midpoint(q,j,w),G=0;for(a=0;S>a;a+=3){i.x=t[a]+r[a],i.y=t[a+1]+r[a+1],i.z=t[a+2]+r[a+2];var k=e.magnitude(e.subtract(i,z,A));k>G&&(G=k);var V=e.magnitudeSquared(e.subtract(i,U,A));if(V>L){var W=Math.sqrt(V);B=.5*(B+W),L=B*B;var Y=W-B;U.x=(B*U.x+Y*i.x)/W,U.y=(B*U.y+Y*i.y)/W,U.z=(B*U.z+Y*i.z)/W}}return G>B?(e.clone(U,n.center),n.radius=B):(e.clone(z,n.center),n.radius=G),n},d.fromCornerPoints=function(t,n,i){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),o(i)||(i=new d);var a=e.midpoint(t,n,i.center);return i.radius=e.distance(a,n),i},d.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),o(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var F=new e;d.fromBoundingSpheres=function(t,r){if(o(r)||(r=new d),!o(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return d.clone(t[0],r);if(2===n)return d.union(t[0],t[1],r);var i,a=[];for(i=0;n>i;i++)a.push(t[i].center);r=d.fromPoints(a,r);var s=r.center,u=r.radius;for(i=0;n>i;i++){var c=t[i];u=Math.max(u,e.distance(s,c.center,F)+c.radius)}return r.radius=u,r};var D=new e,P=new e,U=new e;d.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),o(n)||(n=new d);var i=t.halfAxes,a=f.getColumn(i,0,D),s=f.getColumn(i,1,P),u=f.getColumn(i,2,U);return e.add(a,s,a),e.add(a,u,a),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(a),n},d.clone=function(t,r){return o(t)?o(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,o){r.typeOf.object("value",e),r.defined("array",t),o=n(o,0);var i=e.center;return t[o++]=i.x,t[o++]=i.y,t[o++]=i.z,t[o]=e.radius,t},d.unpack=function(e,t,i){r.defined("array",e),t=n(t,0),o(i)||(i=new d);var a=i.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],i.radius=e[t],i};var L=new e,B=new e;d.union=function(t,n,i){r.typeOf.object("left",t),r.typeOf.object("right",n),o(i)||(i=new d);var a=t.center,s=t.radius,u=n.center,c=n.radius,f=e.subtract(u,a,L),l=e.magnitude(f);if(s>=l+c)return t.clone(i),i;if(c>=l+s)return n.clone(i),i;var p=.5*(s+l+c),h=e.multiplyByScalar(f,(-s+p)/l,B);return e.add(h,a,h),e.clone(h,i.center),i.radius=p,i};var q=new e;d.expand=function(t,n,o){r.typeOf.object("sphere",t),r.typeOf.object("point",n),o=d.clone(t,o);var i=e.magnitude(e.subtract(n,o.center,q));return i>o.radius&&(o.radius=i),o},d.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var o=t.center,i=t.radius,a=n.normal,u=e.dot(a,o)+n.distance;return-i>u?s.OUTSIDE:i>u?s.INTERSECTING:s.INSIDE},d.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var j=new e;d.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var o=e.subtract(t.center,n,j);return e.magnitudeSquared(o)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),o(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;d.computePlaneDistances=function(t,n,i,a){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",i),o(a)||(a=new u);var s=e.subtract(t.center,n,z),c=e.dot(i,s);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var G=new e,k=new e,V=new e,W=new e,Y=new e,H=new t,X=new Array(8),K=0;8>K;++K)X[K]=new e;var Z=new a;return d.projectTo2D=function(t,o,i){r.typeOf.object("sphere",t),o=n(o,Z);var a=o.ellipsoid,s=t.center,u=t.radius,c=a.geodeticSurfaceNormal(s,G),f=e.cross(e.UNIT_Z,c,k);e.normalize(f,f);var l=e.cross(c,f,V);e.normalize(l,l),e.multiplyByScalar(c,u,c),e.multiplyByScalar(l,u,l),e.multiplyByScalar(f,u,f);var p=e.negate(l,Y),h=e.negate(f,W),y=X,m=y[0];e.add(c,l,m),e.add(m,f,m),m=y[1],e.add(c,l,m),e.add(m,h,m),m=y[2],e.add(c,p,m),e.add(m,h,m),m=y[3],e.add(c,p,m),e.add(m,f,m),e.negate(c,c),m=y[4],e.add(c,l,m),e.add(m,f,m),m=y[5],e.add(c,l,m),e.add(m,h,m),m=y[6],e.add(c,p,m),e.add(m,h,m),m=y[7],e.add(c,p,m),e.add(m,f,m);for(var E=y.length,O=0;E>O;++O){var _=y[O];e.add(s,_,_);var T=a.cartesianToCartographic(_,H);o.project(T,_)}i=d.fromPoints(y,i),s=i.center;var A=s.x,R=s.y,b=s.z;return s.x=b,s.y=A,s.z=R,i},d.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||o(t)&&o(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d.prototype.volume=function(){var e=this.radius;return S*e*e*e},d}),define("Core/arrayFill",["./Check","./defaultValue","./defined"],function(e,t,r){"use strict";function n(n,o,i,a){if(e.defined("array",n),e.defined("value",o),r(i)&&e.typeOf.number("start",i),r(a)&&e.typeOf.number("end",a),"function"==typeof n.fill)return n.fill(o,i,a);for(var s=n.length>>>0,u=t(i,0),c=0>u?Math.max(s+u,0):Math.min(u,s),f=t(a,s),l=0>f?Math.max(s+f,0):Math.min(f,s);l>c;)n[c]=o,c++;return n}return n}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},o={};return t(o,{element:{get:function(){return o.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return o.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return o.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return o.supportsFullscreen()?null!==o.element:void 0}}}),o.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var o,i=["webkit","moz","o","ms","khtml"],a=0,s=i.length;s>a;++a){var u=i[a];o=u+"RequestFullscreen","function"==typeof t[o]?(n.requestFullscreen=o,r=!0):(o=u+"RequestFullScreen","function"==typeof t[o]&&(n.requestFullscreen=o,r=!0)),o=u+"ExitFullscreen","function"==typeof document[o]?n.exitFullscreen=o:(o=u+"CancelFullScreen","function"==typeof document[o]&&(n.exitFullscreen=o)),o=u+"FullscreenEnabled",void 0!==document[o]?n.fullscreenEnabled=o:(o=u+"FullScreenEnabled",void 0!==document[o]&&(n.fullscreenEnabled=o)),o=u+"FullscreenElement",void 0!==document[o]?n.fullscreenElement=o:(o=u+"FullScreenElement",void 0!==document[o]&&(n.fullscreenElement=o)),o=u+"fullscreenchange",void 0!==document["on"+o]&&("ms"===u&&(o="MSFullscreenChange"),n.fullscreenchange=o),o=u+"fullscreenerror",void 0!==document["on"+o]&&("ms"===u&&(o="MSFullscreenError"),n.fullscreenerror=o)}return r},o.requestFullscreen=function(e,t){o.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},o.exitFullscreen=function(){o.supportsFullscreen()&&document[n.exitFullscreen]()},o}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,o){return t(e).then(r,n,o)}function t(e){var t,r;return e instanceof n?t=e:s(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=o(e),t}function r(t){return e(t,i)}function n(e){this.then=e}function o(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return i(n)}});return r}function i(e){var r=new n(function(r,n){try{return n?t(n(e)):i(e)}catch(o){return i(o)}});return r}function a(){function e(e,t,r){return p(e,t,r)}function r(e){return h(e)}function o(e){return h(i(e))}function s(e){return d(e)}var u,c,f,l,p,d,h;return c=new n(e),u={then:e,resolve:r,reject:o,progress:s,promise:c,resolver:{resolve:r,reject:o,progress:s}},f=[],l=[],p=function(e,t,r){var n,o;return n=a(),o="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},f.push(function(r){r.then(e,t).then(n.resolve,n.reject,o)}),l.push(o),n.promise},d=function(e){return y(l,e),e},h=function(e){return e=t(e),p=e.then,h=t,d=E,y(f,e),l=f=A,e},u}function s(e){return e&&"function"==typeof e.then}function u(t,r,n,o,i){return m(2,arguments),e(t,function(t){function s(e){y(e)}function u(e){h(e)}var c,f,l,p,d,h,y,m,O,_;if(O=t.length>>>0,c=Math.max(0,Math.min(r,O)),l=[],f=O-c+1,p=[],d=a(),c)for(m=d.progress,y=function(e){p.push(e),--f||(h=y=E,d.reject(p))},h=function(e){l.push(e),--c||(h=y=E,d.resolve(l))},_=0;O>_;++_)_ in t&&e(t[_],u,s,m);else d.resolve(l);return d.then(n,o,i)})}function c(e,t,r,n){function o(e){return t?t(e[0]):e[0]}return u(e,1,o,r,n)}function f(e,t,r,n){return m(1,arguments),p(e,O).then(t,r,n)}function l(){return p(arguments,O)}function p(t,r){return e(t,function(t){var n,o,i,s,u,c;if(i=o=t.length>>>0,n=[],c=a(),i)for(s=function(t,o){e(t,r).then(function(e){n[o]=e,--i||c.resolve(n)},c.reject)},u=0;o>u;u++)u in t?s(t[u],u):--i;else c.resolve(n);return c.promise})}function d(t,r){var n=T.call(arguments,1);return e(t,function(t){var o;return o=t.length,n[0]=function(t,n,i){return e(t,function(t){return e(n,function(e){return r(t,e,i,o)})})},_.apply(t,n)})}function h(t,r,n){var o=arguments.length>2;return e(t,function(e){return e=o?n:e,r.resolve(e),e},function(e){return r.reject(e),i(e)},r.progress)}function y(e,t){for(var r,n=0;r=e[n++];)r(t)}function m(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function E(){}function O(e){return e}var _,T,A;return e.defer=a,e.resolve=t,e.reject=r,e.join=l,e.all=f,e.map=p,e.reduce=d,e.any=c,e.some=u,e.chain=h,e.isPromise=s,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(A,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return f(t,function(t){return e.apply(A,t)})})}},T=[].slice,_=[].reduce||function(e){var t,r,n,o,i;if(i=0,t=Object(this),o=t.length>>>0,r=arguments,r.length<=1)for(;;){if(i in t){n=t[i++];break}if(++i>=o)throw new TypeError}else n=r[1];for(;o>i;++i)i in t&&(n=e(n,t[i],i,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen","./RuntimeError","../ThirdParty/when"],function(e,t,r,n,o){"use strict";function i(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(v)&&(v=!1,!h())){var e=/ Chrome\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(v=!0,C=i(e[1]))}return v}function s(){return a()&&C}function u(){if(!t(I)&&(I=!1,!a()&&!h()&&/ Safari\/[\.0-9]+/.test(S.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(I=!0,N=i(e[1]))}return I}function c(){return u()&&N}function f(){if(!t(M)){M=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(S.userAgent);null!==e&&(M=!0,x=i(e[1]),x.isNightly=!!e[2])}return M}function l(){return f()&&x}function p(){if(!t(F)){F=!1;var e;"Microsoft Internet Explorer"===S.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(S.userAgent),null!==e&&(F=!0,D=i(e[1]))):"Netscape"===S.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(S.userAgent),null!==e&&(F=!0,D=i(e[1])))}return F}function d(){return p()&&D}function h(){if(!t(P)){P=!1;var e=/ Edge\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(P=!0,U=i(e[1]))}return P}function y(){return h()&&U}function m(){if(!t(L)){L=!1;var e=/Firefox\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(L=!0,B=i(e[1]))}return L}function E(){return t(q)||(q=/Windows/i.test(S.appVersion)),q}function O(){return m()&&B}function _(){return t(j)||(j="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),j}function T(){return t(z)||(z=!m()&&"undefined"!=typeof PointerEvent&&(!t(S.pointerEnabled)||S.pointerEnabled)),z}function A(){if(!t(k)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;k=t(r)&&""!==r,k&&(G=r)}return k}function R(){return A()?G:void 0}function b(){if(t(W))return W.promise;W=o.defer(),h()&&(V=!1,W.resolve(V));var e=new Image;return e.onload=function(){V=e.width>0&&e.height>0,W.resolve(V)},e.onerror=function(){V=!1,W.resolve(V)},e.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",W.promise}function g(){return t(W)||b(),V}function w(){var e=window.navigator.userAgent.toLowerCase(),t="ipad"==e.match(/ipad/i),r="iphone os"==e.match(/iphone os/i),n="midp"==e.match(/midp/i),o="rv:1.2.3.4"==e.match(/rv:1.2.3.4/i),i="ucweb"==e.match(/ucweb/i),a="android"==e.match(/android/i),s="windows ce"==e.match(/windows ce/i),u="windows mobile"==e.match(/windows mobile/i);return t||r||n||o||i||a||s||u?!1:!0}var S;S="undefined"!=typeof navigator?navigator:{};var v,C,I,N,M,x,F,D,P,U,L,B,q,j,z,G,k,V,W,Y=[];"undefined"!=typeof ArrayBuffer&&(Y.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&Y.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&Y.push(CanvasPixelArray));var H={isChrome:a,chromeVersion:s,isSafari:u,safariVersion:c,isWebkit:f,webkitVersion:l,isInternetExplorer:p,internetExplorerVersion:d,isEdge:h,edgeVersion:y,isFirefox:m,firefoxVersion:O,isWindows:E,isNodeJs:_,hardwareConcurrency:e(S.hardwareConcurrency,3),supportsPointerEvents:T,supportsImageRenderingPixelated:A,supportsWebP:b,supportsWebPSync:g,imageRenderingValue:R,typedArrayTypes:Y,isPCBroswer:w};return H.supportsFullscreen=function(){return r.supportsFullscreen()},H.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},H.supportsWebWorkers=function(){return"undefined"!=typeof Worker},H.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!H.isEdge()},H}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,
TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,o,i){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:i.BYTE,UNSIGNED_BYTE:i.UNSIGNED_BYTE,SHORT:i.SHORT,UNSIGNED_SHORT:i.UNSIGNED_SHORT,INT:i.INT,UNSIGNED_INT:i.UNSIGNED_INT,FLOAT:i.FLOAT,DOUBLE:i.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.INT:return Int32Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Int32Array?a.INT:e instanceof Uint32Array?a.UNSIGNED_INT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.INT||e===a.UNSIGNED_INT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(n);case a.UNSIGNED_BYTE:return new Uint8Array(n);case a.SHORT:return new Int16Array(n);case a.UNSIGNED_SHORT:return new Uint16Array(n);case a.INT:return new Int32Array(n);case a.UNSIGNED_INT:return new Uint32Array(n);case a.FLOAT:return new Float32Array(n);case a.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(n,o,i,s){if(!t(n))throw new r("componentDatatype is required.");if(!t(o))throw new r("buffer is required.");switch(i=e(i,0),s=e(s,(o.byteLength-i)/a.getSizeInBytes(n)),n){case a.BYTE:return new Int8Array(o,i,s);case a.UNSIGNED_BYTE:return new Uint8Array(o,i,s);case a.SHORT:return new Int16Array(o,i,s);case a.UNSIGNED_SHORT:return new Uint16Array(o,i,s);case a.INT:return new Int32Array(o,i,s);case a.UNSIGNED_INT:return new Uint32Array(o,i,s);case a.FLOAT:return new Float32Array(o,i,s);case a.DOUBLE:return new Float64Array(o,i,s);default:throw new r("componentDatatype is not a valid value.")}},a.fromName=function(e){switch(e){case"BYTE":return a.BYTE;case"UNSIGNED_BYTE":return a.UNSIGNED_BYTE;case"SHORT":return a.SHORT;case"UNSIGNED_SHORT":return a.UNSIGNED_SHORT;case"INT":return a.INT;case"UNSIGNED_INT":return a.UNSIGNED_INT;case"FLOAT":return a.FLOAT;case"DOUBLE":return a.DOUBLE;default:throw new r("name is not a valid value.")}},o(a)}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,r){this.x=t(e,0),this.y=t(r,0)}a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.x,n[o]=r.y,n},a.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new a),i.x=n[o++],i.y=n[o],i},a.packArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=2*o:n=new Array(2*o);for(var i=0;o>i;++i)a.pack(t[i],n,2*i);return n},a.unpackArray=function(t,n){e.defined("array",t);var o=t.length;r(n)?n.length=o/2:n=new Array(o/2);for(var i=0;o>i;i+=2){var s=i/2;n[s]=a.unpack(t,i,n[s])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var s=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitude(s)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,s),a.magnitudeSquared(s)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var o=a.magnitude(t);if(r.x=t.x/o,r.y=t.y/o,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var u=new a;a.lerp=function(t,r,n,o){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",o),a.multiplyByScalar(r,n,u),o=a.multiplyByScalar(t,1-n,o),a.add(u,o,o)};var c=new a,f=new a;a.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f),i.acosClamped(a.dot(c,f))};var l=new a;return a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Y,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},a.ZERO=o(new a(0,0)),a.UNIT_X=o(new a(1,0)),a.UNIT_Y=o(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,TOP:1,ALL:2};return e(t)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],function(e,t,r,n,o,i){"use strict";function a(e,t,n,o){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(o,0)}a.packedLength=4,a.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n},a.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new a),i[0]=e[o++],i[1]=e[o++],i[2]=e[o++],i[3]=e[o++],i},a.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new a(e[0],e[2],e[1],e[3]):void 0},a.fromArray=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new a),i[0]=e[o],i[1]=e[o+1],i[2]=e[o+2],i[3]=e[o+3],i},a.fromColumnMajorArray=function(e,r){return t.defined("values",e),a.clone(e,r)},a.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new a(e[0],e[1],e[2],e[3])},a.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new a(e.x,0,0,e.y)},a.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new a(e,0,0,e)},a.fromRotation=function(e,r){t.typeOf.number("angle",e);var o=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=o,r[1]=i,r[2]=-i,r[3]=o,r):new a(o,-i,i,o)},a.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},a.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},a.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var o=2*r,i=e[o],a=e[o+1];return n.x=i,n.y=a,n},a.setColumn=function(e,r,n,o){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),o=a.clone(e,o);var i=2*r;return o[i]=n.x,o[i+1]=n.y,o},a.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var o=e[r],i=e[r+2];return n.x=o,n.y=i,n},a.setRow=function(e,r,n,o){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",o),o=a.clone(e,o),o[r]=n.x,o[r+2]=n.y,o};var s=new e;a.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],s)),n.y=e.magnitude(e.fromElements(r[2],r[3],s)),n};var u=new e;return a.getMaximumScale=function(t){return a.getScale(t,u),e.maximumComponent(u)},a.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e[0]*r[0]+e[2]*r[1],i=e[0]*r[2]+e[2]*r[3],a=e[1]*r[0]+e[3]*r[1],s=e[1]*r[2]+e[3]*r[3];return n[0]=o,n[1]=a,n[2]=i,n[3]=s,n},a.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},a.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},a.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=e[0]*r.x+e[2]*r.y,i=e[1]*r.x+e[3]*r.y;return n.x=o,n.y=i,n},a.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},a.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},a.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},a.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],o=e[2],i=e[1],a=e[3];return r[0]=n,r[1]=o,r[2]=i,r[3]=a,r},a.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},a.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},a.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},a.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=o&&Math.abs(e[1]-r[1])<=o&&Math.abs(e[2]-r[2])<=o&&Math.abs(e[3]-r[3])<=o},a.IDENTITY=i(new a(1,0,0,1)),a.ZERO=i(new a(0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,o(a.prototype,{length:{get:function(){return a.packedLength}}}),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},a}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,o,i,a,s){"use strict";function u(e,t,n,o){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(o,0)}var c=new e;u.fromAxisAngle=function(r,o,i){t.typeOf.object("axis",r),t.typeOf.number("angle",o);var a=o/2,s=Math.sin(a);c=e.normalize(r,c);var f=c.x*s,l=c.y*s,p=c.z*s,d=Math.cos(a);return n(i)?(i.x=f,i.y=l,i.z=p,i.w=d,i):new u(f,l,p,d)};var f=[1,2,0],l=new Array(3);u.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var o,i,a,c,p,d=e[s.COLUMN0ROW0],h=e[s.COLUMN1ROW1],y=e[s.COLUMN2ROW2],m=d+h+y;if(m>0)o=Math.sqrt(m+1),p=.5*o,o=.5/o,i=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*o,a=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*o,c=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*o;else{var E=f,O=0;h>d&&(O=1),y>d&&y>h&&(O=2);var _=E[O],T=E[_];o=Math.sqrt(e[s.getElementIndex(O,O)]-e[s.getElementIndex(_,_)]-e[s.getElementIndex(T,T)]+1);var A=l;A[O]=.5*o,o=.5/o,p=(e[s.getElementIndex(T,_)]-e[s.getElementIndex(_,T)])*o,A[_]=(e[s.getElementIndex(_,O)]+e[s.getElementIndex(O,_)])*o,A[T]=(e[s.getElementIndex(T,O)]+e[s.getElementIndex(O,T)])*o,i=-A[0],a=-A[1],c=-A[2]}return n(r)?(r.x=i,r.y=a,r.z=c,r.w=p,r):new u(i,a,c,p)};var p=new u,d=new u,h=new u,y=new u;u.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=u.fromAxisAngle(e.UNIT_X,r.roll,p),h=u.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=u.multiply(h,y,h),d=u.fromAxisAngle(e.UNIT_Z,-r.heading,p),u.multiply(d,n,n)};var m=new e,E=new e,O=new u,_=new u,T=new u;u.packedLength=4,u.pack=function(e,n,o){return t.typeOf.object("value",e),t.defined("array",n),o=r(o,0),n[o++]=e.x,n[o++]=e.y,n[o++]=e.z,n[o]=e.w,n},u.unpack=function(e,o,i){return t.defined("array",e),o=r(o,0),n(i)||(i=new u),i.x=e[o],i.y=e[o+1],i.z=e[o+2],i.w=e[o+3],i},u.packedInterpolationLength=3,u.convertPackedArrayForInterpolation=function(e,t,r,n){u.unpack(e,4*r,T),u.conjugate(T,T);for(var o=0,i=r-t+1;i>o;o++){var a=3*o;u.unpack(e,4*(t+o),O),u.multiply(O,T,O),O.w<0&&u.negate(O,O),u.computeAxis(O,m);var s=u.computeAngle(O);n[a]=m.x*s,n[a+1]=m.y*s,n[a+2]=m.z*s}},u.unpackInterpolationResult=function(t,r,o,i,a){n(a)||(a=new u),e.fromArray(t,0,E);var s=e.magnitude(E);return u.unpack(r,4*i,_),0===s?u.clone(u.IDENTITY,O):u.fromAxisAngle(E,s,O),u.multiply(O,_,a)},u.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new u(e.x,e.y,e.z,e.w):void 0},u.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},u.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},u.magnitude=function(e){return Math.sqrt(u.magnitudeSquared(e))},u.normalize=function(e,r){t.typeOf.object("result",r);var n=1/u.magnitude(e),o=e.x*n,i=e.y*n,a=e.z*n,s=e.w*n;return r.x=o,r.y=i,r.z=a,r.w=s,r},u.inverse=function(e,r){t.typeOf.object("result",r);var n=u.magnitudeSquared(e);return r=u.conjugate(e,r),u.multiplyByScalar(r,1/n,r)},u.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},u.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},u.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},u.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},u.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var o=e.x,i=e.y,a=e.z,s=e.w,u=r.x,c=r.y,f=r.z,l=r.w,p=s*u+o*l+i*f-a*c,d=s*c-o*f+i*l+a*u,h=s*f+o*c-i*u+a*l,y=s*l-o*u-i*c-a*f;return n.x=p,n.y=d,n.z=h,n.w=y,n},u.multiplyByVec=function(t,r,n){var o=new e,i=new e,a=new e(t.x,t.y,t.z);o=e.cross(a,r,o),i=e.cross(a,o,i);var s=new e;s=e.multiplyByScalar(o,2*t.w,s);var u=new e;return u=e.multiplyByScalar(o,2,u),n=e.add(r,s,n),n=e.add(n,u,n)},u.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},u.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},u.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-n*n);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},u.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var A=new u;u.lerp=function(e,r,n,o){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o),A=u.multiplyByScalar(r,n,A),o=u.multiplyByScalar(e,1-n,o),u.add(A,o,o)};var R=new u,b=new u,g=new u;u.slerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i=u.dot(e,r),s=r;if(0>i&&(i=-i,s=R=u.negate(r,R)),1-i<a.EPSILON6)return u.lerp(e,s,n,o);var c=Math.acos(i);return b=u.multiplyByScalar(e,Math.sin((1-n)*c),b),g=u.multiplyByScalar(s,Math.sin(n*c),g),o=u.add(b,g,o),u.multiplyByScalar(o,1/Math.sin(c),o)},u.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var o=a.acosClamped(r.w),i=0;return 0!==o&&(i=o/Math.sin(o)),e.multiplyByScalar(r,i,n)},u.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var o=e.magnitude(r),i=0;return 0!==o&&(i=Math.sin(o)/o),n.x=r.x*i,n.y=r.y*i,n.z=r.z*i,n.w=Math.cos(o),n};var w=new e,S=new e,v=new u,C=new u;u.computeInnerQuadrangle=function(r,n,o,i){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",o),t.typeOf.object("result",i);var a=u.conjugate(n,v);u.multiply(a,o,C);var s=u.log(C,w);u.multiply(a,r,C);var c=u.log(C,S);return e.add(s,c,s),e.multiplyByScalar(s,.25,s),e.negate(s,s),u.exp(s,v),u.multiply(n,v,i)},u.squad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var s=u.slerp(e,r,i,v),c=u.slerp(n,o,i,C);return u.slerp(s,c,2*i*(1-i),a)};for(var I=new u,N=1.9011074535173003,M=o.supportsTypedArrays()?new Float32Array(8):[],x=o.supportsTypedArrays()?new Float32Array(8):[],F=o.supportsTypedArrays()?new Float32Array(8):[],D=o.supportsTypedArrays()?new Float32Array(8):[],P=0;7>P;++P){var U=P+1,L=2*U+1;M[P]=1/(U*L),x[P]=U/L}return M[7]=N/136,x[7]=8*N/17,u.fastSlerp=function(e,r,n,o){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",o);var i,a=u.dot(e,r);a>=0?i=1:(i=-1,a=-a);for(var s=a-1,c=1-n,f=n*n,l=c*c,p=7;p>=0;--p)F[p]=(M[p]*f-x[p])*s,D[p]=(M[p]*l-x[p])*s;var d=i*n*(1+F[0]*(1+F[1]*(1+F[2]*(1+F[3]*(1+F[4]*(1+F[5]*(1+F[6]*(1+F[7])))))))),h=c*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),y=u.multiplyByScalar(e,h,I);return u.multiplyByScalar(r,d,o),u.add(y,o,o)},u.fastSquad=function(e,r,n,o,i,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",o),t.typeOf.number("t",i),t.typeOf.object("result",a);var s=u.fastSlerp(e,r,i,v),c=u.fastSlerp(n,o,i,C);return u.fastSlerp(s,c,2*i*(1-i),a)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},u.equalsEpsilon=function(e,r,o){return t.typeOf.number("epsilon",o),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=o&&Math.abs(e.y-r.y)<=o&&Math.abs(e.z-r.z)<=o&&Math.abs(e.w-r.w)<=o},u.ZERO=i(new u(0,0,0,0)),u.IDENTITY=i(new u(0,0,0,1)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},u}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var o,i,a=0,s=t.length-1;s>=a;)if(o=~~((a+s)/2),i=n(t[o],r),0>i)a=o+1;else{if(!(i>0))return o;s=o-1}return~(s+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,o){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=o}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],o=function(e,t,r,n){r||(r=" ");var o=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+o:o+e},i=function(e,t,r,n,i,a){var s=n-e.length;return s>0&&(e=r||!i?o(e,n,a,r):e.slice(0,t.length)+o("",s,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,n,a,s,u){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+o(c.toString(t),s||0,"0",!1),i(e,r,n,a,u)},s=function(e,t,r,n,o,a){return null!=n&&(e=e.slice(0,n)),i(e,"",t,r,o,a)},u=function(e,n,u,c,f,l,p){var d,h,y,m,E;if("%%"==e)return"%";for(var O=!1,_="",T=!1,A=!1,R=" ",b=u.length,g=0;u&&b>g;g++)switch(u.charAt(g)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":R=u.charAt(g+1);break;case"0":T=!0;break;case"#":A=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(p)>-1?6:"d"==p?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],p){case"s":return s(String(E),O,c,l,T,R);case"c":return s(String.fromCharCode(+E),O,c,l,T);case"b":return a(E,2,A,O,c,l,T);case"o":return a(E,8,A,O,c,l,T);case"x":return a(E,16,A,O,c,l,T);case"X":return a(E,16,A,O,c,l,T).toUpperCase();case"u":return a(E,10,A,O,c,l,T);case"i":case"d":return d=+E||0,d=Math.round(d-d%1),h=0>d?"-":_,E=h+o(String(Math.abs(d)),l,"0",!1),i(E,h,O,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=+E,h=0>d?"-":_,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(p.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(p)%2],E=h+Math.abs(d)[y](l),i(E,h,O,c,T)[m]();default:return e}};return n.replace(e,u)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,o,i,a,s){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=o,this.second=i,this.millisecond=a,this.isLeapSecond=s}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,o,i,a,s,u,c){"use strict";function f(e,t){return y.compare(e.julianDate,t.julianDate)}function l(e){_.julianDate=e;var r=y.leapSeconds,n=t(r,_,f);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var o=r[n].offset;if(n>0){var i=y.secondsDifference(r[n].julianDate,e);i>o&&(n--,o=r[n].offset)}y.addSeconds(e,o,e)}function p(e,r){_.julianDate=e;var n=y.leapSeconds,o=t(n,_,f);if(0>o&&(o=~o),0===o)return y.addSeconds(e,-n[0].offset,r);if(o>=n.length)return y.addSeconds(e,-n[o-1].offset,r);var i=y.secondsDifference(n[o].julianDate,e);return 0===i?y.addSeconds(e,-n[o].offset,r):1>=i?void 0:y.addSeconds(e,-n[--o].offset,r)}function d(e,t,r){var n=t/u.SECONDS_PER_DAY|0;return e+=n,t-=u.SECONDS_PER_DAY*n,0>t&&(e--,t+=u.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function h(e,t,r,n,o,i,a){var s=(t-14)/12|0,c=e+4800+s,f=(1461*c/4|0)+(367*(t-2-12*s)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;
n-=12,0>n&&(n+=24);var l=i+(n*u.SECONDS_PER_HOUR+o*u.SECONDS_PER_MINUTE+a*u.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}function y(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var o=0|e;t+=(e-o)*u.SECONDS_PER_DAY,d(o,t,this),n===c.UTC&&l(this)}var m=new i,E=[31,28,31,30,31,30,31,31,30,31,30,31],O=29,_=new s,T=/^(\d{4})$/,A=/^(\d{4})-(\d{2})$/,R=/^(\d{4})-?(\d{3})$/,b=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,g=/^(\d{4})-?(\d{2})-?(\d{2})$/,w=/([Z+\-])?(\d{2})?:?(\d{2})?$/,S=/^(\d{2})(\.\d+)?/.source+w.source,v=/^(\d{2}):?(\d{2})(\.\d+)?/.source+w.source,C=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+w.source,I="Invalid ISO 8601 date.";y.fromGregorianDate=function(e,t){if(!(e instanceof i))throw new o("date must be a valid GregorianDate.");var r=h(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(d(r[0],r[1],t),l(t),t):new y(r[0],r[1],c.UTC)},y.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new o("date must be a valid JavaScript Date.");var r=h(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(d(r[0],r[1],t),l(t),t):new y(r[0],r[1],c.UTC)},y.fromIso8601=function(e,t){if("string"!=typeof e)throw new o(I);e=e.replace(",",".");var r,i,s,u=e.split("T"),f=1,p=1,m=0,_=0,w=0,N=0,M=u[0],x=u[1];if(!n(M))throw new o(I);var F;if(u=M.match(g),null!==u){if(F=M.split("-").length-1,F>0&&2!==F)throw new o(I);r=+u[1],f=+u[2],p=+u[3]}else if(u=M.match(A),null!==u)r=+u[1],f=+u[2];else if(u=M.match(T),null!==u)r=+u[1];else{var D;if(u=M.match(R),null!==u){if(r=+u[1],D=+u[2],s=a(r),1>D||s&&D>366||!s&&D>365)throw new o(I)}else{if(u=M.match(b),null===u)throw new o(I);r=+u[1];var P=+u[2],U=+u[3]||0;if(F=M.split("-").length-1,F>0&&(!n(u[3])&&1!==F||n(u[3])&&2!==F))throw new o(I);var L=new Date(Date.UTC(r,0,4));D=7*P+U-L.getUTCDay()-3}i=new Date(Date.UTC(r,0,1)),i.setUTCDate(D),f=i.getUTCMonth()+1,p=i.getUTCDate()}if(s=a(r),1>f||f>12||1>p||(2!==f||!s)&&p>E[f-1]||s&&2===f&&p>O)throw new o(I);var B;if(n(x)){if(u=x.match(C),null!==u){if(F=x.split(":").length-1,F>0&&2!==F&&3!==F)throw new o(I);m=+u[1],_=+u[2],w=+u[3],N=1e3*+(u[4]||0),B=5}else if(u=x.match(v),null!==u){if(F=x.split(":").length-1,F>2)throw new o(I);m=+u[1],_=+u[2],w=60*+(u[3]||0),B=4}else{if(u=x.match(S),null===u)throw new o(I);m=+u[1],_=60*+(u[2]||0),B=3}if(_>=60||w>=61||m>24||24===m&&(_>0||w>0||N>0))throw new o(I);var q=u[B],j=+u[B+1],z=+(u[B+2]||0);switch(q){case"+":m-=j,_-=z;break;case"-":m+=j,_+=z;break;case"Z":break;default:_+=new Date(Date.UTC(r,f-1,p,m,_)).getTimezoneOffset()}}var G=60===w;for(G&&w--;_>=60;)_-=60,m++;for(;m>=24;)m-=24,p++;for(i=s&&2===f?O:E[f-1];p>i;)p-=i,f++,f>12&&(f-=12,r++),i=s&&2===f?O:E[f-1];for(;0>_;)_+=60,m--;for(;0>m;)m+=24,p--;for(;1>p;)f--,1>f&&(f+=12,r--),i=s&&2===f?O:E[f-1],p+=i;var k=h(r,f,p,m,_,w,N);return n(t)?(d(k[0],k[1],t),l(t)):t=new y(k[0],k[1],c.UTC),G&&y.addSeconds(t,1,t),t},y.now=function(e){return y.fromDate(new Date,e)};var N=new y(0,0,c.TAI);return y.toGregorianDate=function(e,t){if(!n(e))throw new o("julianDate is required.");var r=!1,a=p(e,N);n(a)||(y.addSeconds(e,-1,N),a=p(N,N),r=!0);var s=a.dayNumber,c=a.secondsOfDay;c>=43200&&(s+=1);var f=s+68569|0,l=4*f/146097|0;f=f-((146097*l+3)/4|0)|0;var d=4e3*(f+1)/1461001|0;f=f-(1461*d/4|0)+31|0;var h=80*f/2447|0,m=f-(2447*h/80|0)|0;f=h/11|0;var E=h+2-12*f|0,O=100*(l-49)+d+f|0,_=c/u.SECONDS_PER_HOUR|0,T=c-_*u.SECONDS_PER_HOUR,A=T/u.SECONDS_PER_MINUTE|0;T-=A*u.SECONDS_PER_MINUTE;var R=0|T,b=(T-R)/u.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(R+=1),n(t)?(t.year=O,t.month=E,t.day=m,t.hour=_,t.minute=A,t.second=R,t.millisecond=b,t.isLeapSecond=r,t):new i(O,E,m,_,A,R,b,r)},y.toDate=function(e){if(!n(e))throw new o("julianDate is required.");var t=y.toGregorianDate(e,m),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},y.toIso8601=function(t,r){if(!n(t))throw new o("julianDate is required.");var i=y.toGregorianDate(t,m),a=i.year,s=i.month,u=i.day,c=i.hour,f=i.minute,l=i.second,p=i.millisecond;1e4===a&&1===s&&1===u&&0===c&&0===f&&0===l&&0===p&&(a=9999,s=12,u=31,c=24);var d;return n(r)||0===p?n(r)&&0!==r?(d=(.01*p).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a,s,u,c,f,l,d)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a,s,u,c,f,l):(d=(.01*p).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a,s,u,c,f,l,d))},y.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new y(e.dayNumber,e.secondsOfDay,c.TAI):void 0},y.compare=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},y.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},y.equalsEpsilon=function(e,t,r){if(!n(r))throw new o("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(y.secondsDifference(e,t))<=r},y.totalDays=function(e){if(!n(e))throw new o("julianDate is required.");return e.dayNumber+e.secondsOfDay/u.SECONDS_PER_DAY},y.secondsDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=(e.dayNumber-t.dayNumber)*u.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},y.daysDifference=function(e,t){if(!n(e))throw new o("left is required.");if(!n(t))throw new o("right is required.");var r=e.dayNumber-t.dayNumber,i=(e.secondsOfDay-t.secondsOfDay)/u.SECONDS_PER_DAY;return r+i},y.computeTaiMinusUtc=function(e){_.julianDate=e;var r=y.leapSeconds,n=t(r,_,f);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},y.addSeconds=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("seconds is required.");if(!n(r))throw new o("result is required.");return d(e.dayNumber,e.secondsOfDay+t,r)},y.addMinutes=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("minutes is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*u.SECONDS_PER_MINUTE;return d(e.dayNumber,i,r)},y.addHours=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("hours is required.");if(!n(r))throw new o("result is required.");var i=e.secondsOfDay+t*u.SECONDS_PER_HOUR;return d(e.dayNumber,i,r)},y.addDays=function(e,t,r){if(!n(e))throw new o("julianDate is required.");if(!n(t))throw new o("days is required.");if(!n(r))throw new o("result is required.");var i=e.dayNumber+t;return d(i,e.secondsOfDay,r)},y.lessThan=function(e,t){return y.compare(e,t)<0},y.lessThanOrEquals=function(e,t){return y.compare(e,t)<=0},y.greaterThan=function(e,t){return y.compare(e,t)>0},y.greaterThanOrEquals=function(e,t){return y.compare(e,t)>=0},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y.prototype.equalsEpsilon=function(e,t){return y.equalsEpsilon(this,e,t)},y.prototype.toString=function(){return y.toIso8601(this)},y.leapSeconds=[new s(new y(2441317,43210,c.TAI),10),new s(new y(2441499,43211,c.TAI),11),new s(new y(2441683,43212,c.TAI),12),new s(new y(2442048,43213,c.TAI),13),new s(new y(2442413,43214,c.TAI),14),new s(new y(2442778,43215,c.TAI),15),new s(new y(2443144,43216,c.TAI),16),new s(new y(2443509,43217,c.TAI),17),new s(new y(2443874,43218,c.TAI),18),new s(new y(2444239,43219,c.TAI),19),new s(new y(2444786,43220,c.TAI),20),new s(new y(2445151,43221,c.TAI),21),new s(new y(2445516,43222,c.TAI),22),new s(new y(2446247,43223,c.TAI),23),new s(new y(2447161,43224,c.TAI),24),new s(new y(2447892,43225,c.TAI),25),new s(new y(2448257,43226,c.TAI),26),new s(new y(2448804,43227,c.TAI),27),new s(new y(2449169,43228,c.TAI),28),new s(new y(2449534,43229,c.TAI),29),new s(new y(2450083,43230,c.TAI),30),new s(new y(2450630,43231,c.TAI),31),new s(new y(2451179,43232,c.TAI),32),new s(new y(2453736,43233,c.TAI),33),new s(new y(2454832,43234,c.TAI),34),new s(new y(2456109,43235,c.TAI),35),new s(new y(2457204,43236,c.TAI),36),new s(new y(2457754,43237,c.TAI),37)],y}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return i.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,r).replace(o,t)),this.path&&(this.path=this.path.replace(o,t)),this.query&&(this.query=this.query.replace(o,t)),this.fragment&&(this.fragment=this.fragment.replace(o,t))};var o=/%[0-9a-z]{2}/gi,i=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var o=new r.constructor;for(var i in r)if(r.hasOwnProperty(i)){var a=r[i];n&&(a=t(a,n)),o[i]=a}return o}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,o,i){i=e(i,!1);var a,s,u,c={},f=t(n),l=t(o);if(f)for(a in n)n.hasOwnProperty(a)&&(s=n[a],l&&i&&"object"==typeof s&&o.hasOwnProperty(a)?(u=o[a],"object"==typeof u?c[a]=r(s,u,i):c[a]=s):c[a]=s);if(l)for(a in o)o.hasOwnProperty(a)&&!c.hasOwnProperty(a)&&(u=o[a],c[a]=u);return c}return r}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function o(e,t){var r;return"undefined"!=typeof document&&(r=document),o._implementation(e,t,r)}return o._implementation=function(o,i,a){if(!r(o))throw new n("relative uri is required.");if(!r(i)){if("undefined"==typeof a)return o;i=t(a.baseURI,a.location.href)}var s=new e(i),u=new e(o);return u.resolve(s).toString()},o}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,o){if(!t(n))throw new r("uri is required.");var i="",a=n.lastIndexOf("/");return-1!==a&&(i=n.substring(0,a+1)),o?(n=new e(n),t(n.query)&&(i+="?"+n.query),t(n.fragment)&&(i+="#"+n.fragment),i):i}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(!t(n))throw new r("uri is required.");var o=new e(n);o.normalize();var i=o.path,a=i.lastIndexOf("/");return-1!==a&&(i=i.substr(a+1)),a=i.lastIndexOf("."),i=-1===a?"":i.substr(a+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,o=r.protocol;return r.href=t,r.href=r.href,o!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^data:/i;return t}),define("Core/loadAndExecuteScript",["../ThirdParty/when"],function(e){"use strict";function t(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var o=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,o.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},o.appendChild(n),r.promise}return t}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("obj is required.");var o="";for(var i in n)if(n.hasOwnProperty(i)){var a=n[i],s=encodeURIComponent(i)+"=";if(r(a))for(var u=0,c=a.length;c>u;++u)o+=s+encodeURIComponent(a[u])+"&";else o+=s+encodeURIComponent(a)+"&"}return o=o.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("queryString is required.");var o={};if(""===n)return o;for(var i=n.replace(/\+/g,"%20").split(/[&;]/),a=0,s=i.length;s>a;++a){var u=i[a].split("="),c=decodeURIComponent(u[0]),f=u[1];f=e(f)?decodeURIComponent(f):"";var l=o[c];"string"==typeof l?o[c]=[l,f]:r(l)?l.push(f):o[c]=f}return o}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";var t={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5};return e(t)}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";var t={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3,PACK_TERRAIN:4,PACK_IMAGERY:5};return e(t)}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT);var o=e(t.throttleByServer,!1),i=e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=i,this.throttleByServer=o,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return o.prototype.cancel=function(){this.cancelled=!0},o.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new o(this)},o}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var o=r[n],i=o.indexOf(": ");if(i>0){var a=o.substring(0,i),s=o.substring(i+2);t[a]=s}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function o(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,o=this._scopes,i=-1,a=0;a<n.length;a++)if(n[a]===t&&o[a]===r){i=a;break}return-1!==i?(this._insideRaiseEvent?(this._toRemove.push(i),n[i]=void 0,o[i]=void 0):(n.splice(i,1),o.splice(i,1)),!0):!1},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,i=r.length;for(e=0;i>e;e++){var a=r[e];t(a)&&r[e].apply(n[e],arguments)}var s=this._toRemove;if(i=s.length,i>0){for(s.sort(o),e=0;i>e;e++){var u=s[e];r.splice(u,1),n.splice(u,1)}s.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function o(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function i(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(o.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),o.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},o.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,o=this._array,a=-1,s=!0;s;){var u=2*(e+1),c=u-1;a=r>c&&n(o[c],o[e])<0?c:e,r>u&&n(o[u],o[a])<0&&(a=u),a!==e?(i(o,a,e),e=a):s=!1}},o.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},o.prototype.insert=function(t){e.defined("element",t);var n=this._array,o=this._comparator,a=this._maximumLength,s=this._length++;for(s<n.length?n[s]=t:n.push(t);0!==s;){var u=Math.floor((s-1)/2);if(!(o(n[s],n[u])<0))break;i(n,s,u),s=u}var c;return r(a)&&this._length>a&&(c=n[a],this._length=a),c},o.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,o=n[r];return i(n,r,--this._length),this.heapify(r),o}},o}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState","./RequestType"],function(e,t,r,n,o,i,a,s,u,c,f,l){"use strict";function p(e,t){return e.priority-t.priority}function d(){}function h(e){o(e.priorityFunction)&&(e.priority=e.priorityFunction())}function y(e){var t=n(d.requestsByServer[e],d.maximumRequestsPerServer);return M[e]<t}function m(e){var r=e.serverKey+"_"+e.providerName;if(o(d.packRequests[r])||(d.packRequests[r]=[]),!(d.packRequests[r].length>=P)){o(d.packRequestQuadKey[r])||(d.packRequestQuadKey[r]=[],d.quadKeyIndex[r]=0,d.totalPacketCount[r]=0,d.currentDeferIndex[r]=0),o(d.currentPacketCount[r])||(d.currentPacketCount[r]=0),o(d.packRequestPromise[r])||(d.packRequestPromise[r]=[t.defer()]),d.totalPacketCount[r]>=D&&(d.totalPacketCount[r]=0,d.currentDeferIndex[r]++,d.packRequestPromise[r].push(t.defer()));var n=d.currentDeferIndex[r];return e.deferred=d.packRequestPromise[r][n],e.state=f.ISSUED,d.packRequests[r].push(e),d.totalPacketCount[r]++,e.deferred.promise}}function E(){d.packRequests={},d.packRequestPromise={},d.packRequestQuadKey={},d.quadKeyIndex={},d.currentPacketCount={},d.totalPacketCount={},d.currentDeferIndex={}}function O(e){var t=e.serverKey+"_"+e.providerName,r=d.packRequestQuadKey[t],n=d.quadKeyIndex[t];o(r[n])?r[n]+=";"+e.quadKey:r[n]=e.quadKey,e.quadKeyIndex=d.currentPacketCount[t],++d.currentPacketCount[t],d.currentPacketCount[t]>=D&&(d.currentPacketCount[t]=0,d.quadKeyIndex[t]++)}function _(e,t){for(var r=D*t,n=0,o=e.length;o>n;n++)if(n>=r){var i=e[n];i.state=f.CANCELLED}}function T(){var t,r=d.packRequests;for(var n in r)if(r.hasOwnProperty(n)){t=void 0;for(var i=r[n],a=0,s=i.length;s>a;a++){var u=i[a];o(t)||(t=u),O(u)}var c;for(o(t)&&(c=t.url),a=0,s=d.packRequestQuadKey[n].length;s>a;a++){var f=d.packRequestQuadKey[n][a];if(-1===f.indexOf(";")&&(f+=";"+f),o(t)){if(t.throttleByServer&&!y(t.serverKey)){_(i,a),d.packRequestPromise[n][a].reject();continue}var l=t.clone();l.state=t.state,l.serverKey=t.serverKey,l.deferred=d.packRequestPromise[n][a],l.deferred.id=a;var p=new e(c);p.query=o(p.query)?p.query+"&extratiles="+f:"extratiles="+f,l.url=p.toString(),g(l,l.url)}}}E()}function A(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function R(e){return function(t){e.state!==f.CANCELLED&&(--v.numberOfActiveRequests,--M[e.serverKey],F.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}function b(e){return function(t){e.state!==f.CANCELLED&&(++v.numberOfFailedRequests,--v.numberOfActiveRequests,--M[e.serverKey],F.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}function g(e,t){var r=A(e);return e.state=f.ACTIVE,N.push(e),++v.numberOfActiveRequests,++v.numberOfActiveRequestsEver,++M[e.serverKey],e.requestFunction(t).then(R(e)).otherwise(b(e)),r}function w(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++v.numberOfCancelledRequests,e.deferred.reject(),t&&(--v.numberOfActiveRequests,--M[e.serverKey],++v.numberOfCancelledActiveRequests),o(e.cancelFunction)&&e.cancelFunction()}function S(){d.debugShowStatistics&&(0===v.numberOfActiveRequests&&v.lastNumberOfActiveRequests>0&&(v.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+v.numberOfAttemptedRequests),v.numberOfAttemptedRequests=0),v.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+v.numberOfCancelledRequests),v.numberOfCancelledRequests=0),v.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+v.numberOfCancelledActiveRequests),v.numberOfCancelledActiveRequests=0),v.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+v.numberOfFailedRequests),v.numberOfFailedRequests=0)),v.lastNumberOfActiveRequests=v.numberOfActiveRequests)}var v={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},C=20,I=new s({comparator:p});I.maximumLength=C,I.reserve(C);var N=[],M={},x="undefined"!=typeof document?new e(document.location.href):new e,F=new a;d.maximumRequests=50,d.maximumRequestsPerServer=6,d.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},d.throttleRequests=!0,d.debugShowStatistics=!1,d.requestCompletedEvent=F,i(d,{statistics:{get:function(){return v}},priorityHeapLength:{get:function(){return C},set:function(e){if(C>e)for(;I.length>e;){var t=I.pop();w(t)}C=e,I.maximumLength=e,I.reserve(e)}}});var D=20,P=120;return d.packRequests={},d.packRequestPromise={},d.packRequestQuadKey={},d.quadKeyIndex={},d.currentPacketCount={},d.totalPacketCount={},d.currentDeferIndex={},d.update=function(){var e,t,r=0,n=N.length;for(e=0;n>e;++e)t=N[e],t.cancelled&&w(t),t.state===f.ACTIVE?r>0&&(N[e-r]=t):++r;N.length-=r,T();var o=I.internalArray,i=I.length;for(e=0;i>e;++e)h(o[e]);I.resort();for(var a=Math.max(d.maximumRequests-N.length,0),s=0;a>s&&I.length>0;)t=I.pop(),t.cancelled?w(t):!t.throttleByServer||y(t.serverKey)?(g(t),++s):w(t);S()},d.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(x);n.normalize();var i=n.authority;/:/.test(i)||(i=i+":"+("https"===n.scheme?"443":"80"));var a=M[i];return o(a)||(M[i]=0),i},d.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||u(e.url))return F.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++v.numberOfAttemptedRequests,o(e.serverKey)||(e.serverKey=d.getServerKey(e.url)),e.type>l.OTHER)return m(e);if(!e.throttleByServer||y(e.serverKey)){if(!d.throttleRequests||!e.throttle)return g(e);if(!(N.length>=d.maximumRequests)){h(e);var t=I.insert(e);if(o(t)){if(t===e)return;w(t)}return A(e)}}},d.clearForSpecs=function(){for(;I.length>0;){var e=I.pop();w(e)}for(var t=N.length,r=0;t>r;++r)w(N[r]);N.length=0,M={},v.numberOfAttemptedRequests=0,v.numberOfActiveRequests=0,v.numberOfCancelledRequests=0,v.numberOfCancelledActiveRequests=0,v.numberOfFailedRequests=0,v.numberOfActiveRequestsEver=0,v.lastNumberOfActiveRequests=0},d.numberOfActiveRequestsByServer=function(e){return M[e]},d.requestHeap=I,d}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var o=n.getAuthority();if(t(o)){if(-1!==o.indexOf("@")){var i=o.split("@");o=i[1]}if(-1===o.indexOf(":")){var a=n.getScheme();if(t(a)||(a=window.location.protocol,a=a.substring(0,a.length-1)),"http"===a)o+=":80";else{if("https"!==a)return;o+=":443"}}return o}}var o={},i={};return o.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])||(i[o]=!0)},o.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])&&delete i[o]},o.contains=function(e){if(!t(e))throw new r("url is required.");var o=n(e);return t(o)&&t(i[o])?!0:!1},o.clear=function(){i={}},o}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,o,i,a,s,u,c,f,l,p,d,h,y,m,E,O,_,T,A,R,b,g,w){"use strict";function S(e,t,r,n){var o=e.query;if(!s(o)||0===o.length)return{};var i;if(-1===o.indexOf("=")){var a={};a[o]=void 0,i=a}else i=_(o);r?t._queryParameters=N(i,t._queryParameters,n):t._queryParameters=i,e.query=void 0}function v(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||s(r[n[0]])?e.query=O(r):e.query=n[0]}function C(e,t){return s(e)?s(e.clone)?e.clone():o(e):t}function I(e){if(e.state===b.ISSUED||e.state===b.ACTIVE)throw new g("The Resource is already being fetched.");e.state=b.UNISSUED,e.deferred=void 0}function N(e,t,r){if(!r)return i(e,t);var n=o(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var u=n[a],c=t[a];s(u)?(Array.isArray(u)||(u=n[a]=[u]),n[a]=u.concat(c)):n[a]=Array.isArray(c)?c.slice():c}return n}function M(t){t=a(t,a.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=C(t.templateValues,{}),this._queryParameters=C(t.queryParameters,{}),this.headers=C(t.headers,{}),this.request=a(t.request,new T),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=a(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);S(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function x(e){var r=e.resource,n=e.flipY,o=e.preferImageBitmap,i=r.request;i.url=r.url,i.requestFunction=function(){var e=r.url,i=!1;r.isDataUri||r.isBlobUri||(i=r.isCrossOriginUrl);var a=t.defer();return M._Implementations.createImage(e,i,a,n,o),a.promise};var a=R.request(i);return s(a)?a.otherwise(function(e){return i.state!==b.FAILED?t.reject(e):r.retryOnError(e).then(function(a){return a?(i.state=b.UNISSUED,i.deferred=void 0,x({resource:r,flipY:n,preferImageBitmap:o})):t.reject(e)})}):void 0}function F(e,r,n){var o={};o[r]=n,e.setQueryParameters(o);var i=e.request;i.url=e.url,i.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(t){window[n]=void 0}},M._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var a=R.request(i);return s(a)?a.otherwise(function(o){return i.state!==b.FAILED?t.reject(o):e.retryOnError(o).then(function(a){return a?(i.state=b.UNISSUED,i.deferred=void 0,F(e,r,n)):t.reject(o)})}):void 0}function D(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function P(e,t){for(var r=D(e,t),n=new ArrayBuffer(r.length),o=new Uint8Array(n),i=0;i<r.length;i++)o[i]=r.charCodeAt(i);return n}function U(e,t){t=a(t,"");var r=e[1],n=!!e[2],o=e[3];switch(t){case"":case"text":return D(n,o);case"arraybuffer":return P(n,o);case"blob":var i=P(n,o);return new Blob([i],{type:r});case"document":var s=new DOMParser;return s.parseFromString(D(n,o),r);case"json":return JSON.parse(D(n,o));default:throw new c("Unhandled responseType: "+t)}}function L(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(w.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e}function B(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function q(e,t,r,n,o,i,a){var s=global.require,u=s("url").parse(e),c=s("https:"===u.protocol?"https":"http"),f=s("zlib"),l={protocol:u.protocol,hostname:u.hostname,port:u.port,path:u.path,query:u.query,method:r,headers:o};c.request(l).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void i.reject(new A(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?f.gunzip(n,function(e,r){e?i.reject(new g("Error decompressing response.")):i.resolve(B(r,t))}):i.resolve(B(n,t))})}).on("error",function(e){i.reject(new A)}).end()}var j=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();M.createIfNeeded=function(e){return e instanceof M?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new M({url:e})};var z;M.supportsImageBitmapOptions=function(){if(s(z))return z;if("function"!=typeof createImageBitmap)return z=t.resolve(!1);var e="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg==";return z=M.fetchBlob({url:e}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},u(M,{isBlobSupported:{get:function(){return j}}}),u(M.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);S(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return d(this._url)}},isDataUri:{get:function(){return m(this._url)}},isBlobUri:{get:function(){return h(this._url)}},isCrossOriginUrl:{get:function(){return y(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),M.prototype.getUrlComponent=function(t,r){
if(this.isDataUri)return this._url;var n=new e(this._url);t&&v(n,this);var o=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),i=this._templateValues;return o=o.replace(/{(.*?)}/g,function(e,t){var r=i[t];return s(r)?encodeURIComponent(r):e}),r&&s(this.proxy)&&(o=this.proxy.getURL(o)),o},M.prototype.setQueryParameters=function(e,t){t?this._queryParameters=N(this._queryParameters,e,!1):this._queryParameters=N(e,this._queryParameters,!1)},M.prototype.appendQueryParameters=function(e){this._queryParameters=N(e,this._queryParameters,!0)},M.prototype.setTemplateValues=function(e,t){t?this._templateValues=i(this._templateValues,e):this._templateValues=i(e,this._templateValues)},M.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,s(t.url)){var n=new e(t.url),o=a(t.preserveQueryParameters,!1);S(n,r,!0,o),n.fragment=void 0,r._url=n.resolve(new e(l(this._url))).toString()}return s(t.queryParameters)&&(r._queryParameters=i(t.queryParameters,r._queryParameters)),s(t.templateValues)&&(r._templateValues=i(t.templateValues,r.templateValues)),s(t.headers)&&(r.headers=i(t.headers,r.headers)),s(t.proxy)&&(r.proxy=t.proxy),s(t.request)&&(r.request=t.request),s(t.retryCallback)&&(r.retryCallback=t.retryCallback),s(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},M.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},M.prototype.clone=function(e){return s(e)||(e=new M({url:this._url})),e._url=this._url,e._queryParameters=o(this._queryParameters),e._templateValues=o(this._templateValues),e.headers=o(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},M.prototype.getBaseUri=function(e){return p(this.getUrlComponent(e),e)},M.prototype.appendForwardSlash=function(){this._url=r(this._url)},M.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},M.fetchArrayBuffer=function(e){var t=new M(e);return t.fetchArrayBuffer()},M.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},M.fetchBlob=function(e){var t=new M(e);return t.fetchBlob()},M.prototype.fetchImage=function(e){e=a(e,a.EMPTY_OBJECT);var r=a(e.preferImageBitmap,!1),n=a(e.preferBlob,!1),o=a(e.flipY,!1);if(I(this.request),!j||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return x({resource:this,flipY:o,preferImageBitmap:r});var i=this.fetchBlob();if(s(i)){var u,c,f,l;return M.supportsImageBitmapOptions().then(function(e){return u=e,c=u&&r,i}).then(function(e){if(s(e)){if(l=e,c)return M.createImageBitmapFromBlob(e,{flipY:o,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return f=new M({url:t}),x({resource:f,flipY:o,preferImageBitmap:!1})}}).then(function(e){return s(e)?(e.blob=l,c?e:(window.URL.revokeObjectURL(f.url),e)):void 0}).otherwise(function(e){return s(f)&&window.URL.revokeObjectURL(f.url),e.blob=l,t.reject(e)})}},M.fetchImage=function(e){var t=new M(e);return t.fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},M.prototype.fetchText=function(){return this.fetch({responseType:"text"})},M.fetchText=function(e){var t=new M(e);return t.fetchText()},M.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(s(e))return e.then(function(e){return s(e)?JSON.parse(e):void 0})},M.fetchJson=function(e){var t=new M(e);return t.fetchJson()},M.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},M.fetchXML=function(e){var t=new M(e);return t.fetchXML()},M.prototype.fetchJsonp=function(e){e=a(e,"callback"),I(this.request);var t;do t="loadJsonp"+Math.random().toString().substring(2,8);while(s(window[t]));return F(this,e,t)},M.fetchJsonp=function(e){var t=new M(e);return t.fetchJsonp(e.callbackParameterName)},M.prototype._makeRequest=function(e){var r=this;I(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(o){var a=e.responseType,u=i(e.headers,r.headers),c=e.overrideMimeType,f=e.method,l=e.data,p=t.defer(),d=s(o)?o:r.url,h=M._Implementations.loadWithXhr(d,a,f,l,u,p,c);return s(h)&&s(h.abort)&&(n.cancelFunction=function(){h.abort()}),p.promise};var o=R.request(n);return s(o)?o.then(function(e){return e}).otherwise(function(o){return n.state!==b.FAILED?t.reject(o):r.retryOnError(o).then(function(i){return i?(n.state=b.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(o)})}):void 0};var G=/^data:(.*?)(;base64)?,(.*)$/;M.prototype.fetch=function(e){return e=C(e,{}),e.method="GET",this._makeRequest(e)},M.fetch=function(e){var t=new M(e);return t.fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype["delete"]=function(e){return e=C(e,{}),e.method="DELETE",this._makeRequest(e)},M["delete"]=function(e){var t=new M(e);return t["delete"]({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},M.prototype.head=function(e){return e=C(e,{}),e.method="HEAD",this._makeRequest(e)},M.head=function(e){var t=new M(e);return t.head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.options=function(e){return e=C(e,{}),e.method="OPTIONS",this._makeRequest(e)},M.options=function(e){var t=new M(e);return t.options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.post=function(e,t){return n.defined("data",e),t=C(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},M.post=function(e){var t=new M(e);return t.post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.put=function(e,t){return n.defined("data",e),t=C(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},M.put=function(e){var t=new M(e);return t.put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.patch=function(e,t){return n.defined("data",e),t=C(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},M.patch=function(e){var t=new M(e);return t.patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M._Implementations={},M._Implementations.createImage=function(e,t,r,n,o){M.supportsImageBitmapOptions().then(function(n){return n&&o?M.fetchBlob({url:e}):void L(e,t,r)}).then(function(e){return s(e)?M.createImageBitmapFromBlob(e,{flipY:n,premultiplyAlpha:!1}):void 0}).then(function(e){s(e)&&r.resolve(e)}).otherwise(r.reject)},M.createImageBitmapFromBlob=function(e,t){return n.defined("options",t),n.typeOf.bool("options.flipY",t.flipY),n.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var k="undefined"==typeof XMLHttpRequest;return M._Implementations.loadWithXhr=function(e,t,r,n,o,i,a){var u=G.exec(e);if(null!==u)return void i.resolve(U(u,t));if(k)return void q(e,t,r,n,o,i,a);var c=new XMLHttpRequest;if(w.contains(e)&&(c.withCredentials=!0),e=e.replace(/{/g,"%7B").replace(/}/g,"%7D"),c.open(r,e,!0),s(a)&&s(c.overrideMimeType)&&c.overrideMimeType(a),s(o))for(var f in o)o.hasOwnProperty(f)&&c.setRequestHeader(f,o[f]);s(t)&&(c.responseType=t);var l=!1;return"string"==typeof e&&(l=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!l||0!==c.status))return void i.reject(new A(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var o=c.getAllResponseHeaders(),a=o.trim().split(/[\r\n]+/),u={};return a.forEach(function(e){var t=e.split(": "),r=t.shift();u[r]=t.join(": ")}),void i.resolve(u)}if(204===c.status)i.resolve();else if(!s(e)||s(t)&&n!==t)if("json"===t&&"string"==typeof e)try{i.resolve(JSON.parse(e))}catch(f){i.reject(f)}else(""===n||"document"===n)&&s(c.responseXML)&&c.responseXML.hasChildNodes()?i.resolve(c.responseXML):""!==n&&"text"!==n||!s(c.responseText)?i.reject(new g("Invalid XMLHttpRequest response type.")):i.resolve(c.responseText);else i.resolve(e)},c.onerror=function(e){i.reject(new A)},c.send(n),c},M._Implementations.loadAndExecuteScript=function(e,t,r){return E(e,t).otherwise(r.reject)},M._DefaultImplementations={},M._DefaultImplementations.createImage=M._Implementations.createImage,M._DefaultImplementations.loadWithXhr=M._Implementations.loadWithXhr,M._DefaultImplementations.loadAndExecuteScript=M._Implementations.loadAndExecuteScript,M.DEFAULT=f(new M({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),M}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,o,i,a,s,u,c,f,l){"use strict";function p(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))h(this,t.data);else if(n(t.url)){var o=u.createIfNeeded(t.url),i=this;this._downloadPromise=e(o.fetchJson(),function(e){h(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+o.url+"."})}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return a.compare(e.julianDate,t)}function h(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var o=r.columnNames.indexOf("modifiedJulianDateUtc"),i=r.columnNames.indexOf("xPoleWanderRadians"),u=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),p=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),h=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>o||0>i||0>u||0>c||0>p||0>h||0>y)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=r.samples,E=e._dates=[];e._dateColumn=o,e._xPoleWanderRadiansColumn=i,e._yPoleWanderRadiansColumn=u,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=p,e._yCelestialPoleOffsetRadiansColumn=h,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var O,_=e._addNewLeapSeconds,T=0,A=m.length;A>T;T+=e._columnCount){var R=m[T+o],b=m[T+y],g=R+f.MODIFIED_JULIAN_DATE_DIFFERENCE,w=new a(g,b,l.TAI);if(E.push(w),_){if(b!==O&&n(O)){var S=a.leapSeconds,v=t(S,w,d);if(0>v){var C=new s(w,b);S.splice(~v,0,C)}}O=b}}}function y(e,t,r,n,o){var i=r*n;o.xPoleWander=t[i+e._xPoleWanderRadiansColumn],o.yPoleWander=t[i+e._yPoleWanderRadiansColumn],o.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],o.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],o.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,o,i,s){var u=e._columnCount;if(i>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var c=t[o],f=t[i];if(c.equals(f)||n.equals(c))return y(e,r,o,u,s),s;if(n.equals(f))return y(e,r,i,u,s),s;var l=a.secondsDifference(n,c)/a.secondsDifference(f,c),p=o*u,d=i*u,h=r[p+e._ut1MinusUtcSecondsColumn],E=r[d+e._ut1MinusUtcSecondsColumn],O=E-h;if(O>.5||-.5>O){var _=r[p+e._taiMinusUtcSecondsColumn],T=r[d+e._taiMinusUtcSecondsColumn];_!==T&&(f.equals(n)?h=E:E-=T-_)}return s.xPoleWander=m(l,r[p+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),s.yPoleWander=m(l,r[p+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),s.xPoleOffset=m(l,r[p+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=m(l,r[p+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=m(l,h,E),s}return p.NONE=i({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new o(0,0,0,0,0),t}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new o(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var i=this._dates,s=this._lastIndex,u=0,f=0;if(n(s)){var l=i[s],p=i[s+1],d=a.lessThanOrEquals(l,e),h=!n(p),y=h||a.greaterThanOrEquals(p,e);if(d&&y)return u=s,!h&&p.equals(e)&&++u,f=u+1,E(this,i,this._samples,e,u,f,r),r}var m=t(i,e,a.compare,this._dateColumn);return m>=0?(m<i.length-1&&i[m+1].equals(e)&&++m,u=m,f=m):(f=~m,u=f-1,0>u&&(u=0)),this._lastIndex=u,E(this,i,this._samples,e,u,f,r),r}if(n(this._dataError))throw new c(this._dataError)},p}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function o(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return o.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new o);var i=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),s=2*(e.w*e.x+e.y*e.z),u=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,u),n.roll=Math.atan2(s,a),n.pitch=-Math.asin(i),n},o.fromDegrees=function(e,i,a,s){if(!t(e))throw new r("heading is required");if(!t(i))throw new r("pitch is required");if(!t(a))throw new r("roll is required");return t(s)||(s=new o),s.heading=e*n.RADIANS_PER_DEGREE,s.pitch=i*n.RADIANS_PER_DEGREE,s.roll=a*n.RADIANS_PER_DEGREE,s},o.clone=function(e,r){return t(e)?t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new o(e.heading,e.pitch,e.roll):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},o.equalsEpsilon=function(e,r,o,i){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,o,i)&&n.equalsEpsilon(e.pitch,r.pitch,o,i)&&n.equalsEpsilon(e.roll,r.roll,o,i)},o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},o}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],function(e,t,r,n,o){"use strict";function i(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),o=h.exec(n);if(null!==o)return o[1]}}function a(t){return"undefined"==typeof document?t:(e(l)||(l=document.createElement("a")),l.href=t,l.href=l.href,l.href)}function s(){if(e(p))return p;var s;if(s="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?r("..",f("Core/buildModuleUrl.js")):i(),!e(s))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return p=new n({url:a(s)}),p.appendForwardSlash(),p}function u(e){return a(o.toUrl("../"+e))}function c(e){var t=s().getDerivedResource({url:e});return t.url}function f(t){e(d)||(d=e(define.amd)&&!define.amd.toUrlUndefined&&e(o.toUrl)?u:c);var r=d(t);return r}var l,p,d,h=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return f._cesiumScriptRegex=h,f._buildModuleUrlFromBaseUrl=c,f._clearBaseResource=function(){p=void 0},f.setBaseUrl=function(e){p=n.DEFAULT.getDerivedResource({url:e})},f.getCesiumBaseUrl=s,f}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,o,i,a,s){"use strict";function u(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=a.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new i(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),o=this._xTable=new Array(t+1),u=Math.pow(this._stepSizeDays,t),c=0;t>=c;++c){n[c]=u,o[c]=c*this._stepSizeDays;for(var f=0;t>=f;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=l;return n.dayNumber=t,n.secondsOfDay=r,i.daysDifference(n,e._sampleZeroDateTT)}function f(r,o){if(r._chunkDownloadsInProgress[o])return r._chunkDownloadsInProgress[o];var i=e.defer();r._chunkDownloadsInProgress[o]=i;var s,u=r._xysFileUrlTemplate;return s=n(u)?u.getDerivedResource({templateValues:{0:o}}):new a({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+o+".json")}),e(s.fetchJson(),function(e){r._chunkDownloadsInProgress[o]=!1;for(var t=r._samples,n=e.samples,a=o*r._samplesPerXysFile*3,s=0,u=n.length;u>s;++s)t[a+s]=n[s];i.resolve()}),i.promise}var l=new i(0,0,s.TAI);return u.prototype.preload=function(t,r,n,o){var i=c(this,t,r),a=c(this,n,o),s=i/this._stepSizeDays-this._interpolationOrder/2|0;0>s&&(s=0);var u=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;u>=this._totalSamples&&(u=this._totalSamples-1);for(var l=s/this._samplesPerXysFile|0,p=u/this._samplesPerXysFile|0,d=[],h=l;p>=h;++h)d.push(f(this,h));return e.all(d)},u.prototype.computeXysRadians=function(e,t,r){var i=c(this,e,t);if(!(0>i)){var a=i/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var s=this._interpolationOrder,u=a-(s/2|0);0>u&&(u=0);var l=u+s;l>=this._totalSamples&&(l=this._totalSamples-1,u=l-s,0>u&&(u=0));var p=!1,d=this._samples;if(n(d[3*u])||(f(this,u/this._samplesPerXysFile|0),p=!0),n(d[3*l])||(f(this,l/this._samplesPerXysFile|0),p=!0),!p){n(r)?(r.x=0,r.y=0,r.s=0):r=new o(0,0,0);var h,y,m=i-u*this._stepSizeDays,E=this._work,O=this._denominators,_=this._coef,T=this._xTable;for(h=0;s>=h;++h)E[h]=m-T[h];for(h=0;s>=h;++h){for(_[h]=1,y=0;s>=y;++y)y!==h&&(_[h]*=E[y]);_[h]*=O[h];var A=3*(u+h);r.x+=_[h]*d[A++],r.y+=_[h]*d[A++],r.s+=_[h]*d[A]}return r}}}},u}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,o,i,a,s,u,c,f,l,p,d,h,y,m,E,O,_,T){"use strict";var A={},R={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},b={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},g={},w={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},S=new r,v=new r,C=new r;A.localFrameToFixedFrameGenerator=function(e,t){if(!R.hasOwnProperty(e)||!R[e].hasOwnProperty(t))throw new u("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,o=R[e][t],i=e+t;return s(g[i])?n=g[i]:(n=function(n,i,c){if(!s(n))throw new u("origin is required.");if(s(c)||(c=new O),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var f=m.sign(n.z);r.unpack(b[e],0,S),"east"!==e&&"west"!==e&&r.multiplyByScalar(S,f,S),r.unpack(b[t],0,v),"east"!==t&&"west"!==t&&r.multiplyByScalar(v,f,v),r.unpack(b[o],0,C),"east"!==o&&"west"!==o&&r.multiplyByScalar(C,f,C)}else{i=a(i,l.WGS84),i.geodeticSurfaceNormal(n,w.up);var p=w.up,d=w.east;d.x=-n.y,d.y=n.x,d.z=0,r.normalize(d,w.east),r.cross(p,d,w.north),r.multiplyByScalar(w.up,-1,w.down),r.multiplyByScalar(w.east,-1,w.west),r.multiplyByScalar(w.north,-1,w.south),S=w[e],v=w[t],C=w[o]}return c[0]=S.x,c[1]=S.y,c[2]=S.z,c[3]=0,c[4]=v.x,c[5]=v.y,c[6]=v.z,c[7]=0,c[8]=C.x,c[9]=C.y,c[10]=C.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},g[i]=n),n},A.eastNorthUpToFixedFrame=A.localFrameToFixedFrameGenerator("east","north"),A.northEastDownToFixedFrame=A.localFrameToFixedFrameGenerator("north","east"),A.northUpEastToFixedFrame=A.localFrameToFixedFrameGenerator("north","up"),A.northWestUpToFixedFrame=A.localFrameToFixedFrameGenerator("north","west");var I=new _,N=new r(1,1,1),M=new O;A.headingPitchRollToFixedFrame=function(e,t,n,o,s){i.typeOf.object("HeadingPitchRoll",t),o=a(o,A.eastNorthUpToFixedFrame);var u=_.fromHeadingPitchRoll(t,I),c=O.fromTranslationQuaternionRotationScale(r.ZERO,u,N,M);return s=o(e,n,s),O.multiply(s,c,s)};var x=new O,F=new E;A.headingPitchRollQuaternion=function(e,t,r,n,o){i.typeOf.object("HeadingPitchRoll",t);var a=A.headingPitchRollToFixedFrame(e,t,r,n,x),s=O.getRotation(a,F);return _.fromRotationMatrix(s,o)};var D=new r(1,1,1),P=new r,U=new O,L=new O,B=new E,q=new _;A.fixedFrameToHeadingPitchRoll=function(e,t,n,o){i.defined("transform",e),t=a(t,l.WGS84),n=a(n,A.eastNorthUpToFixedFrame),s(o)||(o=new p);var u=O.getTranslation(e,P);if(r.equals(u,r.ZERO))return o.heading=0,o.pitch=0,o.roll=0,o;var c=O.inverseTransformation(n(u,t,U),U),f=O.setScale(e,D,L);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var d=_.fromRotationMatrix(O.getRotation(c,B),q);return d=_.normalize(d,d),p.fromQuaternion(d,o)};var j=24110.54841,z=8640184.812866,G=.093104,k=-62e-7,V=1.1772758384668e-19,W=72921158553e-15,Y=m.TWO_PI/86400,H=new y;A.computeTemeToPseudoFixedMatrix=function(e,t){if(!s(e))throw new u("date is required.");H=y.addSeconds(e,-y.computeTaiMinusUtc(e),H);var r,n=H.dayNumber,o=H.secondsOfDay,i=n-2451545;r=o>=43200?(i+.5)/T.DAYS_PER_JULIAN_CENTURY:(i-.5)/T.DAYS_PER_JULIAN_CENTURY;var a=j+r*(z+r*(G+r*k)),c=a*Y%m.TWO_PI,f=W+V*(n-2451545.5),l=(o+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY,p=c+f*l,d=Math.cos(p),h=Math.sin(p);return s(t)?(t[0]=d,t[1]=-h,t[2]=0,t[3]=h,t[4]=d,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(d,h,0,-h,d,0,0,0,1)},A.iau2006XysData=new d,A.earthOrientationParameters=c.NONE;var X=32.184,K=2451545;A.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+X,o=t.stop.dayNumber,i=t.stop.secondsOfDay+X,a=A.iau2006XysData.preload(r,n,o,i),s=A.earthOrientationParameters.getPromiseToLoad();return e.all([a,s])},A.computeIcrfToFixedMatrix=function(e,t){if(!s(e))throw new u("date is required.");s(t)||(t=new E);var r=A.computeFixedToIcrfMatrix(e,t);if(s(r))return E.transpose(r,t)};var Z=new h(0,0,0),J=new f(0,0,0,0,0,0),Q=new E,$=new E;A.computeFixedToIcrfMatrix=function(e,t){if(!s(e))throw new u("date is required.");s(t)||(t=new E);var r=A.earthOrientationParameters.compute(e,J);if(s(r)){var n=e.dayNumber,o=e.secondsOfDay+X,i=A.iau2006XysData.computeXysRadians(n,o,Z);if(s(i)){var a=i.x+r.xPoleOffset,c=i.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-a*a-c*c)),l=Q;l[0]=1-f*a*a,l[3]=-f*a*c,l[6]=a,l[1]=-f*a*c,l[4]=1-f*c*c,l[7]=c,l[2]=-a,l[5]=-c,l[8]=1-f*(a*a+c*c);var p=E.fromRotationZ(-i.s,$),d=E.multiply(l,p,Q),h=e.dayNumber,O=e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc,_=h-2451545,R=O/T.SECONDS_PER_DAY,b=.779057273264+R+.00273781191135448*(_+R);b=b%1*m.TWO_PI;var g=E.fromRotationZ(b,$),w=E.multiply(d,g,Q),S=Math.cos(r.xPoleWander),v=Math.cos(r.yPoleWander),C=Math.sin(r.xPoleWander),I=Math.sin(r.yPoleWander),N=n-K+o/T.SECONDS_PER_DAY;N/=36525;var M=-47e-6*N*m.RADIANS_PER_DEGREE/3600,x=Math.cos(M),F=Math.sin(M),D=$;return D[0]=S*x,D[1]=S*F,D[2]=C,D[3]=-v*F+I*C*x,D[4]=v*x+I*C*F,D[5]=-I*S,D[6]=-I*F-v*C*x,D[7]=I*x-v*C*F,D[8]=v*S,E.multiply(w,D,t)}}};var ee=new n;A.pointToWindowCoordinates=function(e,t,r,n){return n=A.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},A.pointToGLWindowCoordinates=function(e,r,o,i){if(!s(e))throw new u("modelViewProjectionMatrix is required.");if(!s(r))throw new u("viewportTransformation is required.");if(!s(o))throw new u("point is required.");s(i)||(i=new t);var a=ee;return O.multiplyByVector(e,n.fromElements(o.x,o.y,o.z,1,a),a),n.multiplyByScalar(a,1/a.w,a),O.multiplyByVector(r,a,a),t.fromCartesian4(a,i)};var te=new r,re=new r,ne=new r;A.rotationMatrixFromPositionVelocity=function(e,t,n,o){if(!s(e))throw new u("position is required.");if(!s(t))throw new u("velocity is required.");var i=a(n,l.WGS84).geodeticSurfaceNormal(e,te),c=r.cross(t,i,re);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,ne);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),s(o)||(o=new E),o[0]=t.x,o[1]=t.y,o[2]=t.z,o[3]=c.x,o[4]=c.y,o[5]=c.z,o[6]=f.x,o[7]=f.y,o[8]=f.z,o};var oe=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),ie=new o,ae=new r,se=new r,ue=new E,ce=new O,fe=new O;return A.basisTo2D=function(e,t,n){if(!s(e))throw new u("projection is required.");if(!s(t))throw new u("matrix is required.");if(!s(n))throw new u("result is required.");var o=O.getTranslation(t,se),i=e.ellipsoid,a=i.cartesianToCartographic(o,ie),c=e.project(a,ae);r.fromElements(c.z,c.x,c.y,c);var f=A.eastNorthUpToFixedFrame(o,i,ce),l=O.inverseTransformation(f,fe),p=O.getRotation(t,ue),d=O.multiplyByMatrix3(l,p,n);return O.multiply(oe,d,n),O.setTranslation(n,c,n),n},A.wgs84To2DModelMatrix=function(e,t,n){if(!s(e))throw new u("projection is required.");if(!s(t))throw new u("center is required.");if(!s(n))throw new u("result is required.");var o=e.ellipsoid,i=A.eastNorthUpToFixedFrame(t,o,ce),a=O.inverseTransformation(i,fe),c=o.cartesianToCartographic(t,ie),f=e.project(c,ae);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,ce);return O.multiply(oe,a,n),O.multiply(l,n,n),n},A.buildUp=function(e,t){var n=t.clone(),o=e.clone();o=r.normalize(o,o),Math.abs(r.dot(o,n))>=1&&(o=Math.abs(r.dot(n,r.UNIT_Y))<1?r.clone(r.UNIT_Y,o):r.clone(r.UNIT_Z,o));var i=new r;return r.cross(o,n,i),i=r.normalize(i,i),r.cross(n,i,o),o=r.normalize(o,o)},A.getHeading=function(e,t){var r;return r=m.equalsEpsilon(Math.abs(e.z),1,m.EPSILON3)?Math.atan2(t.y,t.x)-m.PI_OVER_TWO:Math.atan2(e.y,e.x)-m.PI_OVER_TWO,m.TWO_PI-m.zeroToTwoPi(r)},A}),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],function(e,t,r,n,o,i,a,s,u,c,f,l,p,d,h,y){"use strict";function m(e){e=o(e,o.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=o(e.primitiveType,p.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=o(e.geometryType,u.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}m.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&i(e.attributes[r])&&i(e.attributes[r].values)){var o=e.attributes[r],s=o.values.length/o.componentsPerAttribute;if(t!==s&&-1!==t)throw new a("All attribute lists must have the same number of attributes.");t=s}return t};var E=new r,O=new t,_=new l,T=[new r,new r,new r],A=[new e,new e,new e],R=[new e,new e,new e],b=new t,g=new d,w=new l,S=new c;return m._textureCoordinateRotationPoints=function(n,o,i,a){var s,u=h.center(a,E),p=r.toCartesian(u,i,O),m=y.eastNorthUpToFixedFrame(p,i,_),v=l.inverse(m,_),C=A,I=T;I[0].longitude=a.west,I[0].latitude=a.south,I[1].longitude=a.west,I[1].latitude=a.north,I[2].longitude=a.east,I[2].latitude=a.south;var N=b;for(s=0;3>s;s++)r.toCartesian(I[s],i,N),N=l.multiplyByPointAsVector(v,N,N),C[s].x=N.x,C[s].y=N.y;var M=d.fromAxisAngle(t.UNIT_Z,-o,g),x=f.fromQuaternion(M,w),F=n.length,D=Number.POSITIVE_INFINITY,P=Number.POSITIVE_INFINITY,U=Number.NEGATIVE_INFINITY,L=Number.NEGATIVE_INFINITY;for(s=0;F>s;s++)N=l.multiplyByPointAsVector(v,n[s],N),N=f.multiplyByVector(x,N,N),D=Math.min(D,N.x),P=Math.min(P,N.y),U=Math.max(U,N.x),L=Math.max(L,N.y);var B=c.fromRotation(o,S),q=R;q[0].x=D,q[0].y=P,q[1].x=D,q[1].y=L,q[2].x=U,q[2].y=P;var j=C[0],z=C[2].x-j.x,G=C[1].y-j.y;for(s=0;3>s;s++){var k=q[s];c.multiplyByVector(B,k,k),k.x=(k.x-j.x)/z,k.y=(k.y-j.y)/G}var V=q[0],W=q[1],Y=q[2],H=new Array(6);return e.pack(V,H),e.pack(W,H,2),e.pack(Y,H,4),H},m}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function o(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return o.POSITION_ONLY=n(new o({position:!0})),o.POSITION_AND_NORMAL=n(new o({position:!0,normal:!0})),o.POSITION_NORMAL_AND_ST=n(new o({position:!0,normal:!0,st:!0})),o.POSITION_AND_ST=n(new o({position:!0,st:!0})),o.POSITION_AND_COLOR=n(new o({position:!0,color:!0})),o.ALL=n(new o({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),o.DEFAULT=o.POSITION_NORMAL_AND_ST,o.packedLength=6,o.pack=function(n,o,i){if(!t(n))throw new r("value is required");if(!t(o))throw new r("array is required");return i=e(i,0),o[i++]=n.position?1:0,o[i++]=n.normal?1:0,o[i++]=n.st?1:0,o[i++]=n.tangent?1:0,o[i++]=n.bitangent?1:0,o[i]=n.color?1:0,o},o.unpack=function(n,i,a){if(!t(n))throw new r("array is required");return i=e(i,0),t(a)||(a=new o),a.position=1===n[i++],a.normal=1===n[i++],a.st=1===n[i++],a.tangent=1===n[i++],a.bitangent=1===n[i++],a.color=1===n[i],a},o.clone=function(e,r){return t(e)?(t(r)||(r=new o),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r):void 0},o}),define("Core/BoxGeometry",["./arrayFill","./BoundingSphere","./Cartesian3","./Check","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryOffsetAttribute","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,i,a,s,u,c,f,l,p,d){"use strict";function h(e){e=i(e,i.EMPTY_OBJECT);var t=e.minimum,o=e.maximum;if(n.typeOf.object("min",t),n.typeOf.object("max",o),
a(e.offsetAttribute)&&e.offsetAttribute===l.TOP)throw new s("GeometryOffsetAttribute.TOP is not a supported options.offsetAttribute for this geometry.");var u=i(e.vertexFormat,d.DEFAULT);this._minimum=r.clone(t),this._maximum=r.clone(o),this._vertexFormat=u,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}var y=new r;h.fromDimensions=function(e){e=i(e,i.EMPTY_OBJECT);var t=e.dimensions;n.typeOf.object("dimensions",t),n.typeOf.number.greaterThanOrEquals("dimensions.x",t.x,0),n.typeOf.number.greaterThanOrEquals("dimensions.y",t.y,0),n.typeOf.number.greaterThanOrEquals("dimensions.z",t.z,0);var o=r.multiplyByScalar(t,.5,new r);return new h({minimum:r.negate(o,new r),maximum:o,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})},h.fromAxisAlignedBoundingBox=function(e){return n.typeOf.object("boundingBox",e),new h({minimum:e.minimum,maximum:e.maximum})},h.packedLength=2*r.packedLength+d.packedLength+1,h.pack=function(e,t,o){return n.typeOf.object("value",e),n.defined("array",t),o=i(o,0),r.pack(e._minimum,t,o),r.pack(e._maximum,t,o+r.packedLength),d.pack(e._vertexFormat,t,o+2*r.packedLength),t[o+2*r.packedLength+d.packedLength]=i(e._offsetAttribute,-1),t};var m=new r,E=new r,O=new d,_={minimum:m,maximum:E,vertexFormat:O,offsetAttribute:void 0};h.unpack=function(e,t,o){n.defined("array",e),t=i(t,0);var s=r.unpack(e,t,m),u=r.unpack(e,t+r.packedLength,E),c=d.unpack(e,t+2*r.packedLength,O),f=e[t+2*r.packedLength+d.packedLength];return a(o)?(o._minimum=r.clone(s,o._minimum),o._maximum=r.clone(u,o._maximum),o._vertexFormat=d.clone(c,o._vertexFormat),o._offsetAttribute=-1===f?void 0:f,o):(_.offsetAttribute=-1===f?void 0:f,new h(_))},h.createGeometry=function(n){var i=n._minimum,s=n._maximum,d=n._vertexFormat;if(!r.equals(i,s)){var h,m,E=new f;if(d.position&&(d.st||d.normal||d.tangent||d.bitangent)){if(d.position&&(m=new Float64Array(72),m[0]=i.x,m[1]=i.y,m[2]=s.z,m[3]=s.x,m[4]=i.y,m[5]=s.z,m[6]=s.x,m[7]=s.y,m[8]=s.z,m[9]=i.x,m[10]=s.y,m[11]=s.z,m[12]=i.x,m[13]=i.y,m[14]=i.z,m[15]=s.x,m[16]=i.y,m[17]=i.z,m[18]=s.x,m[19]=s.y,m[20]=i.z,m[21]=i.x,m[22]=s.y,m[23]=i.z,m[24]=s.x,m[25]=i.y,m[26]=i.z,m[27]=s.x,m[28]=s.y,m[29]=i.z,m[30]=s.x,m[31]=s.y,m[32]=s.z,m[33]=s.x,m[34]=i.y,m[35]=s.z,m[36]=i.x,m[37]=i.y,m[38]=i.z,m[39]=i.x,m[40]=s.y,m[41]=i.z,m[42]=i.x,m[43]=s.y,m[44]=s.z,m[45]=i.x,m[46]=i.y,m[47]=s.z,m[48]=i.x,m[49]=s.y,m[50]=i.z,m[51]=s.x,m[52]=s.y,m[53]=i.z,m[54]=s.x,m[55]=s.y,m[56]=s.z,m[57]=i.x,m[58]=s.y,m[59]=s.z,m[60]=i.x,m[61]=i.y,m[62]=i.z,m[63]=s.x,m[64]=i.y,m[65]=i.z,m[66]=s.x,m[67]=i.y,m[68]=s.z,m[69]=i.x,m[70]=i.y,m[71]=s.z,E.position=new c({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:m})),d.normal){var O=new Float32Array(72);O[0]=0,O[1]=0,O[2]=1,O[3]=0,O[4]=0,O[5]=1,O[6]=0,O[7]=0,O[8]=1,O[9]=0,O[10]=0,O[11]=1,O[12]=0,O[13]=0,O[14]=-1,O[15]=0,O[16]=0,O[17]=-1,O[18]=0,O[19]=0,O[20]=-1,O[21]=0,O[22]=0,O[23]=-1,O[24]=1,O[25]=0,O[26]=0,O[27]=1,O[28]=0,O[29]=0,O[30]=1,O[31]=0,O[32]=0,O[33]=1,O[34]=0,O[35]=0,O[36]=-1,O[37]=0,O[38]=0,O[39]=-1,O[40]=0,O[41]=0,O[42]=-1,O[43]=0,O[44]=0,O[45]=-1,O[46]=0,O[47]=0,O[48]=0,O[49]=1,O[50]=0,O[51]=0,O[52]=1,O[53]=0,O[54]=0,O[55]=1,O[56]=0,O[57]=0,O[58]=1,O[59]=0,O[60]=0,O[61]=-1,O[62]=0,O[63]=0,O[64]=-1,O[65]=0,O[66]=0,O[67]=-1,O[68]=0,O[69]=0,O[70]=-1,O[71]=0,E.normal=new c({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:O})}if(d.st){var _=new Float32Array(48);_[0]=0,_[1]=0,_[2]=1,_[3]=0,_[4]=1,_[5]=1,_[6]=0,_[7]=1,_[8]=1,_[9]=0,_[10]=0,_[11]=0,_[12]=0,_[13]=1,_[14]=1,_[15]=1,_[16]=0,_[17]=0,_[18]=1,_[19]=0,_[20]=1,_[21]=1,_[22]=0,_[23]=1,_[24]=1,_[25]=0,_[26]=0,_[27]=0,_[28]=0,_[29]=1,_[30]=1,_[31]=1,_[32]=1,_[33]=0,_[34]=0,_[35]=0,_[36]=0,_[37]=1,_[38]=1,_[39]=1,_[40]=0,_[41]=0,_[42]=1,_[43]=0,_[44]=1,_[45]=1,_[46]=0,_[47]=1,E.st=new c({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:_})}if(d.tangent){var T=new Float32Array(72);T[0]=1,T[1]=0,T[2]=0,T[3]=1,T[4]=0,T[5]=0,T[6]=1,T[7]=0,T[8]=0,T[9]=1,T[10]=0,T[11]=0,T[12]=-1,T[13]=0,T[14]=0,T[15]=-1,T[16]=0,T[17]=0,T[18]=-1,T[19]=0,T[20]=0,T[21]=-1,T[22]=0,T[23]=0,T[24]=0,T[25]=1,T[26]=0,T[27]=0,T[28]=1,T[29]=0,T[30]=0,T[31]=1,T[32]=0,T[33]=0,T[34]=1,T[35]=0,T[36]=0,T[37]=-1,T[38]=0,T[39]=0,T[40]=-1,T[41]=0,T[42]=0,T[43]=-1,T[44]=0,T[45]=0,T[46]=-1,T[47]=0,T[48]=-1,T[49]=0,T[50]=0,T[51]=-1,T[52]=0,T[53]=0,T[54]=-1,T[55]=0,T[56]=0,T[57]=-1,T[58]=0,T[59]=0,T[60]=1,T[61]=0,T[62]=0,T[63]=1,T[64]=0,T[65]=0,T[66]=1,T[67]=0,T[68]=0,T[69]=1,T[70]=0,T[71]=0,E.tangent=new c({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:T})}if(d.bitangent){var A=new Float32Array(72);A[0]=0,A[1]=1,A[2]=0,A[3]=0,A[4]=1,A[5]=0,A[6]=0,A[7]=1,A[8]=0,A[9]=0,A[10]=1,A[11]=0,A[12]=0,A[13]=1,A[14]=0,A[15]=0,A[16]=1,A[17]=0,A[18]=0,A[19]=1,A[20]=0,A[21]=0,A[22]=1,A[23]=0,A[24]=0,A[25]=0,A[26]=1,A[27]=0,A[28]=0,A[29]=1,A[30]=0,A[31]=0,A[32]=1,A[33]=0,A[34]=0,A[35]=1,A[36]=0,A[37]=0,A[38]=1,A[39]=0,A[40]=0,A[41]=1,A[42]=0,A[43]=0,A[44]=1,A[45]=0,A[46]=0,A[47]=1,A[48]=0,A[49]=0,A[50]=1,A[51]=0,A[52]=0,A[53]=1,A[54]=0,A[55]=0,A[56]=1,A[57]=0,A[58]=0,A[59]=1,A[60]=0,A[61]=0,A[62]=1,A[63]=0,A[64]=0,A[65]=1,A[66]=0,A[67]=0,A[68]=1,A[69]=0,A[70]=0,A[71]=1,E.bitangent=new c({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:A})}h=new Uint16Array(36),h[0]=0,h[1]=1,h[2]=2,h[3]=0,h[4]=2,h[5]=3,h[6]=6,h[7]=5,h[8]=4,h[9]=7,h[10]=6,h[11]=4,h[12]=8,h[13]=9,h[14]=10,h[15]=8,h[16]=10,h[17]=11,h[18]=14,h[19]=13,h[20]=12,h[21]=15,h[22]=14,h[23]=12,h[24]=18,h[25]=17,h[26]=16,h[27]=19,h[28]=18,h[29]=16,h[30]=20,h[31]=21,h[32]=22,h[33]=20,h[34]=22,h[35]=23}else m=new Float64Array(24),m[0]=i.x,m[1]=i.y,m[2]=i.z,m[3]=s.x,m[4]=i.y,m[5]=i.z,m[6]=s.x,m[7]=s.y,m[8]=i.z,m[9]=i.x,m[10]=s.y,m[11]=i.z,m[12]=i.x,m[13]=i.y,m[14]=s.z,m[15]=s.x,m[16]=i.y,m[17]=s.z,m[18]=s.x,m[19]=s.y,m[20]=s.z,m[21]=i.x,m[22]=s.y,m[23]=s.z,E.position=new c({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:m}),h=new Uint16Array(36),h[0]=4,h[1]=5,h[2]=6,h[3]=4,h[4]=6,h[5]=7,h[6]=1,h[7]=0,h[8]=3,h[9]=1,h[10]=3,h[11]=2,h[12]=1,h[13]=6,h[14]=5,h[15]=1,h[16]=2,h[17]=6,h[18]=2,h[19]=3,h[20]=7,h[21]=2,h[22]=7,h[23]=6,h[24]=3,h[25]=0,h[26]=4,h[27]=3,h[28]=4,h[29]=7,h[30]=0,h[31]=1,h[32]=5,h[33]=0,h[34]=5,h[35]=4;var R=r.subtract(s,i,y),b=.5*r.magnitude(R);if(a(n._offsetAttribute)){var g=m.length,w=new Uint8Array(g/3),S=n._offsetAttribute===l.NONE?0:1;e(w,S),E.applyOffset=new c({componentDatatype:o.UNSIGNED_BYTE,componentsPerAttribute:1,values:w})}return new u({attributes:E,indices:h,primitiveType:p.TRIANGLES,boundingSphere:new t(r.ZERO,b),offsetAttribute:n._offsetAttribute})}};var T;return h.getUnitBox=function(){return a(T)||(T=h.createGeometry(h.fromDimensions({dimensions:new r(1,1,1),vertexFormat:d.POSITION_ONLY}))),T},h}),define("Core/Color",["./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,n,o,i){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+(t-e)*(2/3-r)*6:e}function s(e,r,n,o){this.red=t(e,1),this.green=t(r,1),this.blue=t(n,1),this.alpha=t(o,1)}s.fromCartesian4=function(t,n){return e.typeOf.object("cartesian",t),r(n)?(n.red=t.x,n.green=t.y,n.blue=t.z,n.alpha=t.w,n):new s(t.x,t.y,t.z,t.w)},s.fromBytes=function(e,n,o,i,a){return e=s.byteToFloat(t(e,255)),n=s.byteToFloat(t(n,255)),o=s.byteToFloat(t(o,255)),i=s.byteToFloat(t(i,255)),r(a)?(a.red=e,a.green=n,a.blue=o,a.alpha=i,a):new s(e,n,o,i)},s.fromAlpha=function(t,n,o){return e.typeOf.object("color",t),e.typeOf.number("alpha",n),r(o)?(o.red=t.red,o.green=t.green,o.blue=t.blue,o.alpha=n,o):new s(t.red,t.green,t.blue,n)};var u,c,f;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),c=new Uint32Array(u),f=new Uint8Array(u)),s.fromRgba=function(e,t){return c[0]=e,s.fromBytes(f[0],f[1],f[2],f[3],t)},s.fromHsl=function(e,n,o,i,u){e=t(e,0)%1,n=t(n,0),o=t(o,0),i=t(i,1);var c=o,f=o,l=o;if(0!==n){var p;p=.5>o?o*(1+n):o+n-o*n;var d=2*o-p;c=a(d,p,e+1/3),f=a(d,p,e),l=a(d,p,e-1/3)}return r(u)?(u.red=c,u.green=f,u.blue=l,u.alpha=i,u):new s(c,f,l,i)},s.fromRandom=function(n,o){n=t(n,t.EMPTY_OBJECT);var a=n.red;if(!r(a)){var u=t(n.minimumRed,0),c=t(n.maximumRed,1);e.typeOf.number.lessThanOrEquals("minimumRed",u,c),a=u+i.nextRandomNumber()*(c-u)}var f=n.green;if(!r(f)){var l=t(n.minimumGreen,0),p=t(n.maximumGreen,1);e.typeOf.number.lessThanOrEquals("minimumGreen",l,p),f=l+i.nextRandomNumber()*(p-l)}var d=n.blue;if(!r(d)){var h=t(n.minimumBlue,0),y=t(n.maximumBlue,1);e.typeOf.number.lessThanOrEquals("minimumBlue",h,y),d=h+i.nextRandomNumber()*(y-h)}var m=n.alpha;if(!r(m)){var E=t(n.minimumAlpha,0),O=t(n.maximumAlpha,1);e.typeOf.number.lessThanOrEquals("minumumAlpha",E,O),m=E+i.nextRandomNumber()*(O-E)}return r(o)?(o.red=a,o.green=f,o.blue=d,o.alpha=m,o):new s(a,f,d,m)};var l=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,p=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,d=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,h=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(n,o){e.typeOf.string("color",n),r(o)||(o=new s);var i=s[n.toUpperCase()];if(r(i))return s.clone(i,o),o;var a=l.exec(n);return null!==a?(o.red=parseInt(a[1],16)/15,o.green=parseInt(a[2],16)/15,o.blue=parseInt(a[3],16)/15,o.alpha=1,o):(a=p.exec(n),null!==a?(o.red=parseInt(a[1],16)/255,o.green=parseInt(a[2],16)/255,o.blue=parseInt(a[3],16)/255,o.alpha=1,o):(a=d.exec(n),null!==a?(o.red=parseFloat(a[1])/("%"===a[1].substr(-1)?100:255),o.green=parseFloat(a[2])/("%"===a[2].substr(-1)?100:255),o.blue=parseFloat(a[3])/("%"===a[3].substr(-1)?100:255),o.alpha=parseFloat(t(a[4],"1.0")),o):(a=h.exec(n),null!==a?s.fromHsl(parseFloat(a[1])/360,parseFloat(a[2])/100,parseFloat(a[3])/100,parseFloat(t(a[4],"1.0")),o):o=void 0)))},s.packedLength=4,s.pack=function(r,n,o){return e.typeOf.object("value",r),e.defined("array",n),o=t(o,0),n[o++]=r.red,n[o++]=r.green,n[o++]=r.blue,n[o]=r.alpha,n},s.unpack=function(n,o,i){return e.defined("array",n),o=t(o,0),r(i)||(i=new s),i.red=n[o++],i.green=n[o++],i.blue=n[o++],i.alpha=n[o],i},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:256*e|0},s.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),o=s.floatToByte(this.blue),i=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=o,e[3]=i,e):[t,n,o,i]},s.prototype.toRgba=function(){return f[0]=s.floatToByte(this.red),f[1]=s.floatToByte(this.green),f[2]=s.floatToByte(this.blue),f[3]=s.floatToByte(this.alpha),c[0]},s.prototype.brighten=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=1-(1-this.red)*t,r.green=1-(1-this.green)*t,r.blue=1-(1-this.blue)*t,r.alpha=this.alpha,r},s.prototype.darken=function(t,r){return e.typeOf.number("magnitude",t),e.typeOf.number.greaterThanOrEquals("magnitude",t,0),e.typeOf.object("result",r),t=1-t,r.red=this.red*t,r.green=this.green*t,r.blue=this.blue*t,r.alpha=this.alpha,r},s.prototype.withAlpha=function(e,t){return s.fromAlpha(this,e,t)},s.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red+r.red,n.green=t.green+r.green,n.blue=t.blue+r.blue,n.alpha=t.alpha+r.alpha,n},s.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red-r.red,n.green=t.green-r.green,n.blue=t.blue-r.blue,n.alpha=t.alpha-r.alpha,n},s.multiply=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red*r.red,n.green=t.green*r.green,n.blue=t.blue*r.blue,n.alpha=t.alpha*r.alpha,n},s.divide=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red/r.red,n.green=t.green/r.green,n.blue=t.blue/r.blue,n.alpha=t.alpha/r.alpha,n},s.mod=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.red=t.red%r.red,n.green=t.green%r.green,n.blue=t.blue%r.blue,n.alpha=t.alpha%r.alpha,n},s.multiplyByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red*r,n.green=t.green*r,n.blue=t.blue*r,n.alpha=t.alpha*r,n},s.divideByScalar=function(t,r,n){return e.typeOf.object("color",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.red=t.red/r,n.green=t.green/r,n.blue=t.blue/r,n.alpha=t.alpha/r,n},s.ALICEBLUE=o(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=o(s.fromCssColorString("#FAEBD7")),s.AQUA=o(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=o(s.fromCssColorString("#7FFFD4")),s.AZURE=o(s.fromCssColorString("#F0FFFF")),s.BEIGE=o(s.fromCssColorString("#F5F5DC")),s.BISQUE=o(s.fromCssColorString("#FFE4C4")),s.BLACK=o(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=o(s.fromCssColorString("#FFEBCD")),s.BLUE=o(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=o(s.fromCssColorString("#8A2BE2")),s.BROWN=o(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=o(s.fromCssColorString("#DEB887")),s.CADETBLUE=o(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=o(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=o(s.fromCssColorString("#D2691E")),s.CORAL=o(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=o(s.fromCssColorString("#6495ED")),s.CORNSILK=o(s.fromCssColorString("#FFF8DC")),s.CRIMSON=o(s.fromCssColorString("#DC143C")),s.CYAN=o(s.fromCssColorString("#00FFFF")),s.DARKBLUE=o(s.fromCssColorString("#00008B")),s.DARKCYAN=o(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=o(s.fromCssColorString("#B8860B")),s.DARKGRAY=o(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=o(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=o(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=o(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=o(s.fromCssColorString("#556B2F")),s.DARKORANGE=o(s.fromCssColorString("#FF8C00")),s.DARKORCHID=o(s.fromCssColorString("#9932CC")),s.DARKRED=o(s.fromCssColorString("#8B0000")),s.DARKSALMON=o(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=o(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=o(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=o(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=o(s.fromCssColorString("#00CED1")),s.DARKVIOLET=o(s.fromCssColorString("#9400D3")),s.DEEPPINK=o(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=o(s.fromCssColorString("#00BFFF")),s.DIMGRAY=o(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=o(s.fromCssColorString("#1E90FF")),s.FIREBRICK=o(s.fromCssColorString("#B22222")),s.FLORALWHITE=o(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=o(s.fromCssColorString("#228B22")),s.FUCHSIA=o(s.fromCssColorString("#FF00FF")),s.GAINSBORO=o(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=o(s.fromCssColorString("#F8F8FF")),s.GOLD=o(s.fromCssColorString("#FFD700")),s.GOLDENROD=o(s.fromCssColorString("#DAA520")),s.GRAY=o(s.fromCssColorString("#808080")),s.GREEN=o(s.fromCssColorString("#008000")),s.GREENYELLOW=o(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=o(s.fromCssColorString("#F0FFF0")),s.HOTPINK=o(s.fromCssColorString("#FF69B4")),s.INDIANRED=o(s.fromCssColorString("#CD5C5C")),s.INDIGO=o(s.fromCssColorString("#4B0082")),s.IVORY=o(s.fromCssColorString("#FFFFF0")),s.KHAKI=o(s.fromCssColorString("#F0E68C")),s.LAVENDER=o(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=o(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=o(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=o(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=o(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=o(s.fromCssColorString("#F08080")),s.LIGHTCYAN=o(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=o(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=o(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=o(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=o(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=o(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=o(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=o(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=o(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=o(s.fromCssColorString("#FFFFE0")),s.LIME=o(s.fromCssColorString("#00FF00")),s.LIMEGREEN=o(s.fromCssColorString("#32CD32")),s.LINEN=o(s.fromCssColorString("#FAF0E6")),s.MAGENTA=o(s.fromCssColorString("#FF00FF")),s.MAROON=o(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=o(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=o(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=o(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=o(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=o(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=o(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=o(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=o(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=o(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=o(s.fromCssColorString("#191970")),s.MINTCREAM=o(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=o(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=o(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=o(s.fromCssColorString("#FFDEAD")),s.NAVY=o(s.fromCssColorString("#000080")),s.OLDLACE=o(s.fromCssColorString("#FDF5E6")),s.OLIVE=o(s.fromCssColorString("#808000")),s.OLIVEDRAB=o(s.fromCssColorString("#6B8E23")),s.ORANGE=o(s.fromCssColorString("#FFA500")),s.ORANGERED=o(s.fromCssColorString("#FF4500")),s.ORCHID=o(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=o(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=o(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=o(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=o(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=o(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=o(s.fromCssColorString("#FFDAB9")),s.PERU=o(s.fromCssColorString("#CD853F")),s.PINK=o(s.fromCssColorString("#FFC0CB")),s.PLUM=o(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=o(s.fromCssColorString("#B0E0E6")),s.PURPLE=o(s.fromCssColorString("#800080")),s.RED=o(s.fromCssColorString("#FF0000")),s.ROSYBROWN=o(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=o(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=o(s.fromCssColorString("#8B4513")),s.SALMON=o(s.fromCssColorString("#FA8072")),s.SANDYBROWN=o(s.fromCssColorString("#F4A460")),s.SEAGREEN=o(s.fromCssColorString("#2E8B57")),s.SEASHELL=o(s.fromCssColorString("#FFF5EE")),s.SIENNA=o(s.fromCssColorString("#A0522D")),s.SILVER=o(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=o(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=o(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=o(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=o(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=o(s.fromCssColorString("#00FF7F")),s.STEELBLUE=o(s.fromCssColorString("#4682B4")),s.TAN=o(s.fromCssColorString("#D2B48C")),s.TEAL=o(s.fromCssColorString("#008080")),s.THISTLE=o(s.fromCssColorString("#D8BFD8")),s.TOMATO=o(s.fromCssColorString("#FF6347")),s.TURQUOISE=o(s.fromCssColorString("#40E0D0")),s.VIOLET=o(s.fromCssColorString("#EE82EE")),s.WHEAT=o(s.fromCssColorString("#F5DEB3")),s.WHITE=o(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=o(s.fromCssColorString("#F5F5F5")),s.YELLOW=o(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=o(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=o(new s(0,0,0,0)),s}),define("Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,r,n,o,i){var a,s=.5*t,u=-s,c=o+o,f=i?2*c:c,l=new Float64Array(3*f),p=0,d=0,h=i?3*c:0,y=i?3*(c+o):3*o;for(a=0;o>a;a++){var m=a/o*e.TWO_PI,E=Math.cos(m),O=Math.sin(m),_=E*n,T=O*n,A=E*r,R=O*r;l[d+h]=_,l[d+h+1]=T,l[d+h+2]=u,l[d+y]=A,l[d+y+1]=R,l[d+y+2]=s,d+=3,i&&(l[p++]=_,l[p++]=T,l[p++]=u,l[p++]=A,l[p++]=R,l[p++]=s)}return l},t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,o){"use strict";var i={UNSIGNED_BYTE:o.UNSIGNED_BYTE,UNSIGNED_SHORT:o.UNSIGNED_SHORT,UNSIGNED_INT:o.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},i.fromSizeInBytes=function(e){switch(e){case 2:return i.UNSIGNED_SHORT;case 4:return i.UNSIGNED_INT;case 1:return i.UNSIGNED_BYTE;default:throw new t("Size in bytes cannot be mapped to an IndexDatatype")}},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(r,o){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o):new Uint16Array(o)},i.createTypedArrayFromArrayBuffer=function(r,o,i,a){if(!e(r))throw new t("numberOfVertices is required.");if(!e(o))throw new t("sourceArray is required.");if(!e(i))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(o,i,a):new Uint16Array(o,i,a)},r(i)}),define("Core/CylinderGeometry",["./arrayFill","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryOffsetAttribute","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,i,a,s,u,c,f,l,p,d,h,y,m){"use strict";function E(e){e=a(e,a.EMPTY_OBJECT);var t=e.length,r=e.topRadius,n=e.bottomRadius,o=a(e.vertexFormat,m.DEFAULT),i=a(e.slices,128);if(!s(t))throw new u("options.length must be defined.");if(!s(r))throw new u("options.topRadius must be defined.");if(!s(n))throw new u("options.bottomRadius must be defined.");if(3>i)throw new u("options.slices must be greater than or equal to 3.");if(s(e.offsetAttribute)&&e.offsetAttribute===p.TOP)throw new u("GeometryOffsetAttribute.TOP is not a supported options.offsetAttribute for this geometry.");this._length=t,this._topRadius=r,this._bottomRadius=n,this._vertexFormat=m.clone(o),this._slices=i,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderGeometry"}var O=new r,_=new n,T=new n,A=new n,R=new n;E.packedLength=m.packedLength+5,E.pack=function(e,t,r){if(!s(e))throw new u("value is required");if(!s(t))throw new u("array is required");return r=a(r,0),m.pack(e._vertexFormat,t,r),r+=m.packedLength,t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r++]=e._slices,t[r]=a(e._offsetAttribute,-1),t};var b=new m,g={vertexFormat:b,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,offsetAttribute:void 0};E.unpack=function(e,t,r){if(!s(e))throw new u("array is required");t=a(t,0);var n=m.unpack(e,t,b);t+=m.packedLength;var o=e[t++],i=e[t++],c=e[t++],f=e[t++],l=e[t];return s(r)?(r._vertexFormat=m.clone(n,r._vertexFormat),r._length=o,r._topRadius=i,r._bottomRadius=c,r._slices=f,r._offsetAttribute=-1===l?void 0:l,r):(g.length=o,g.topRadius=i,g.bottomRadius=c,g.slices=f,g.offsetAttribute=-1===l?void 0:l,new E(g))},E.createGeometry=function(a){var u=a._length,m=a._topRadius,E=a._bottomRadius,b=a._vertexFormat,g=a._slices;if(!(0>=u||0>m||0>E||0===m&&0===E)){var w,S=g+g,v=g+S,C=S+S,I=i.computePositions(u,m,E,g,!0),N=b.st?new Float32Array(2*C):void 0,M=b.normal?new Float32Array(3*C):void 0,x=b.tangent?new Float32Array(3*C):void 0,F=b.bitangent?new Float32Array(3*C):void 0,D=b.normal||b.tangent||b.bitangent;if(D){var P=b.tangent||b.bitangent,U=0,L=0,B=0,q=Math.atan2(E-m,u),j=_;j.z=Math.sin(q);var z=Math.cos(q),G=A,k=T;for(w=0;g>w;w++){var V=w/g*h.TWO_PI,W=z*Math.cos(V),Y=z*Math.sin(V);D&&(j.x=W,j.y=Y,P&&(G=n.normalize(n.cross(n.UNIT_Z,j,G),G)),b.normal&&(M[U++]=j.x,M[U++]=j.y,M[U++]=j.z,M[U++]=j.x,M[U++]=j.y,M[U++]=j.z),b.tangent&&(x[L++]=G.x,x[L++]=G.y,x[L++]=G.z,x[L++]=G.x,x[L++]=G.y,x[L++]=G.z),b.bitangent&&(k=n.normalize(n.cross(j,G,k),k),F[B++]=k.x,F[B++]=k.y,F[B++]=k.z,F[B++]=k.x,F[B++]=k.y,F[B++]=k.z))}for(w=0;g>w;w++)b.normal&&(M[U++]=0,M[U++]=0,M[U++]=-1),b.tangent&&(x[L++]=1,x[L++]=0,x[L++]=0),b.bitangent&&(F[B++]=0,F[B++]=-1,F[B++]=0);for(w=0;g>w;w++)b.normal&&(M[U++]=0,M[U++]=0,M[U++]=1),b.tangent&&(x[L++]=1,x[L++]=0,x[L++]=0),b.bitangent&&(F[B++]=0,F[B++]=1,F[B++]=0)}var H=12*g-12,X=d.createTypedArray(C,H),K=0,Z=0;for(w=0;g-1>w;w++)X[K++]=Z,X[K++]=Z+2,X[K++]=Z+3,X[K++]=Z,X[K++]=Z+3,X[K++]=Z+1,Z+=2;for(X[K++]=S-2,X[K++]=0,X[K++]=1,X[K++]=S-2,X[K++]=1,X[K++]=S-1,w=1;g-1>w;w++)X[K++]=S+w+1,X[K++]=S+w,X[K++]=S;for(w=1;g-1>w;w++)X[K++]=v,X[K++]=v+w,X[K++]=v+w+1;var J=0;if(b.st){var Q=Math.max(m,E);for(w=0;C>w;w++){var $=n.fromArray(I,3*w,R);N[J++]=($.x+Q)/(2*Q),N[J++]=($.y+Q)/(2*Q)}}var ee=new l;b.position&&(ee.position=new f({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:I})),b.normal&&(ee.normal=new f({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:M})),b.tangent&&(ee.tangent=new f({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:x})),b.bitangent&&(ee.bitangent=new f({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:F})),b.st&&(ee.st=new f({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:N})),O.x=.5*u,O.y=Math.max(E,m);var te=new t(n.ZERO,r.magnitude(O));if(s(a._offsetAttribute)){u=I.length;var re=new Uint8Array(u/3),ne=a._offsetAttribute===p.NONE?0:1;e(re,ne),ee.applyOffset=new f({componentDatatype:o.UNSIGNED_BYTE,componentsPerAttribute:1,values:re})}return new c({attributes:ee,indices:X,primitiveType:y.TRIANGLES,boundingSphere:te,offsetAttribute:a._offsetAttribute})}};var w;return E.getUnitCylinder=function(){return s(w)||(w=E.createGeometry(new E({topRadius:1,bottomRadius:1,length:1,vertexFormat:m.POSITION_ONLY}))),w},E}),define("Core/EllipsoidGeometry",["./arrayFill","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryOffsetAttribute","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,o,i,a,s,u,c,f,l,p,d,h,y,m){"use strict";function E(e){e=i(e,i.EMPTY_OBJECT);var t=i(e.radii,b),r=Math.round(i(e.stackPartitions,64)),o=Math.round(i(e.slicePartitions,64)),u=i(e.vertexFormat,m.DEFAULT);if(3>o)throw new s("options.slicePartitions cannot be less than three.");if(3>r)throw new s("options.stackPartitions cannot be less than three.");if(a(e.offsetAttribute)&&e.offsetAttribute===p.TOP)throw new s("GeometryOffsetAttribute.TOP is not a supported options.offsetAttribute for this geometry.");this._radii=n.clone(t),this._stackPartitions=r,this._slicePartitions=o,this._vertexFormat=m.clone(u),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidGeometry"}var O=new n,_=new n,T=new n,A=new n,R=new n,b=new n(1,1,1),g=Math.cos,w=Math.sin;E.packedLength=n.packedLength+m.packedLength+3,E.pack=function(e,t,r){if(!a(e))throw new s("value is required");if(!a(t))throw new s("array is required");return r=i(r,0),n.pack(e._radii,t,r),r+=n.packedLength,m.pack(e._vertexFormat,t,r),r+=m.packedLength,t[r++]=e._stackPartitions,t[r++]=e._slicePartitions,t[r]=i(e._offsetAttribute,-1),t};var S=new n,v=new m,C={radii:S,vertexFormat:v,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0};E.unpack=function(e,t,r){if(!a(e))throw new s("array is required");t=i(t,0);var o=n.unpack(e,t,S);t+=n.packedLength;var u=m.unpack(e,t,v);t+=m.packedLength;var c=e[t++],f=e[t++],l=e[t];return a(r)?(r._radii=n.clone(o,r._radii),r._vertexFormat=m.clone(u,r._vertexFormat),r._stackPartitions=c,r._slicePartitions=f,r._offsetAttribute=-1===l?void 0:l,r):(C.stackPartitions=c,C.slicePartitions=f,C.offsetAttribute=-1===l?void 0:l,new E(C))},E.createGeometry=function(i){var s=i._radii;if(!(s.x<=0||s.y<=0||s.z<=0)){var m,E,b=u.fromCartesian3(s),S=i._vertexFormat,v=i._slicePartitions+1,C=i._stackPartitions+1,I=C*v,N=new Float64Array(3*I),M=6*(v-1)*(C-2),x=d.createTypedArray(I,M),F=S.normal?new Float32Array(3*I):void 0,D=S.tangent?new Float32Array(3*I):void 0,P=S.bitangent?new Float32Array(3*I):void 0,U=S.st?new Float32Array(2*I):void 0,L=new Array(v),B=new Array(v),q=0;for(m=0;v>m;m++){var j=h.TWO_PI*m/(v-1);L[m]=g(j),B[m]=w(j),N[q++]=0,N[q++]=0,N[q++]=s.z}for(m=1;C-1>m;m++){var z=Math.PI*m/(C-1),G=w(z),k=s.x*G,V=s.y*G,W=s.z*g(z);for(E=0;v>E;E++)N[q++]=L[E]*k,N[q++]=B[E]*V,N[q++]=W}for(m=0;v>m;m++)N[q++]=0,N[q++]=0,N[q++]=-s.z;var Y=new l;S.position&&(Y.position=new f({componentDatatype:o.DOUBLE,componentsPerAttribute:3,values:N}));var H=0,X=0,K=0,Z=0;if(S.st||S.normal||S.tangent||S.bitangent){for(m=0;I>m;m++){var J=n.fromArray(N,3*m,O),Q=b.geodeticSurfaceNormal(J,_);if(S.st){var $=r.negate(Q,R);r.magnitude($)<h.EPSILON6&&(q=3*(m+v*Math.floor(.5*C)),q>N.length&&(q=3*(m-v*Math.floor(.5*C))),n.fromArray(N,q,$),b.geodeticSurfaceNormal($,$),r.negate($,$)),U[H++]=Math.atan2($.y,$.x)/h.TWO_PI+.5,U[H++]=Math.asin(Q.z)/Math.PI+.5}if(S.normal&&(F[X++]=Q.x,F[X++]=Q.y,F[X++]=Q.z),S.tangent||S.bitangent){var ee=T;if(v>m||m>I-v-1?(n.cross(n.UNIT_X,Q,ee),n.normalize(ee,ee)):(n.cross(n.UNIT_Z,Q,ee),n.normalize(ee,ee)),S.tangent&&(D[K++]=ee.x,D[K++]=ee.y,D[K++]=ee.z),S.bitangent){var te=n.cross(Q,ee,A);n.normalize(te,te),P[Z++]=te.x,P[Z++]=te.y,P[Z++]=te.z}}}S.st&&(Y.st=new f({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:U})),S.normal&&(Y.normal=new f({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:F})),S.tangent&&(Y.tangent=new f({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:D})),S.bitangent&&(Y.bitangent=new f({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:P}))}if(a(i._offsetAttribute)){var re=N.length,ne=new Uint8Array(re/3),oe=i._offsetAttribute===p.NONE?0:1;e(ne,oe),Y.applyOffset=new f({componentDatatype:o.UNSIGNED_BYTE,componentsPerAttribute:1,values:ne})}for(q=0,E=0;v-1>E;E++)x[q++]=v+E,x[q++]=v+E+1,x[q++]=E+1;var ie,ae;for(m=1;C-2>m;m++)for(ie=m*v,ae=(m+1)*v,E=0;v-1>E;E++)x[q++]=ae+E,x[q++]=ae+E+1,x[q++]=ie+E+1,x[q++]=ae+E,x[q++]=ie+E+1,x[q++]=ie+E;for(m=C-2,ie=m*v,ae=(m+1)*v,E=0;v-1>E;E++)x[q++]=ae+E,x[q++]=ie+E+1,x[q++]=ie+E;return new c({attributes:Y,indices:x,primitiveType:y.TRIANGLES,boundingSphere:t.fromEllipsoid(b),offsetAttribute:i._offsetAttribute})}};var I;return E.getUnitEllipsoid=function(){return a(I)||(I=E.createGeometry(new E({radii:new n(1,1,1),vertexFormat:m.POSITION_ONLY}))),I},E}),define("Scene/Vector3DTileBatch",[],function(){"use strict";function e(e){this.offset=e.offset,this.count=e.count,this.color=e.color,this.batchIds=e.batchIds}return e}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,n=t.name,o=t.message;r=e(n)&&e(o)?n+": "+o:t.toString();var i=t.stack;return e(i)&&(r+="\n"+i),r}return t}),define("Workers/createTaskProcessorWorker",["../ThirdParty/when","../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r,n){"use strict";function o(t,r,n){var o;try{return o=t(r,n)}catch(i){return e.reject(i)}}function i(i){var a;return function(s){var u=s.data,c=[],f={id:u.id,result:void 0,error:void 0};return e(o(i,u.parameters,c)).then(function(e){f.result=e}).otherwise(function(e){e instanceof Error?f.error={
name:e.name,message:e.message,stack:e.stack}:f.error=e}).always(function(){r(a)||(a=t(self.webkitPostMessage,self.postMessage)),u.canTransferArrayBuffer||(c.length=0);try{a(f,c)}catch(e){f.result=void 0,f.error="postMessage failed with error: "+n(e)+"\n  with responseMessage: "+JSON.stringify(f),a(f)}})}}return i}),define("Workers/createVectorTileGeometries",["../Core/BoundingSphere","../Core/BoxGeometry","../Core/Cartesian3","../Core/Color","../Core/CylinderGeometry","../Core/defined","../Core/EllipsoidGeometry","../Core/IndexDatatype","../Core/Matrix4","../Scene/Vector3DTileBatch","./createTaskProcessorWorker"],function(e,t,r,n,o,i,a,s,u,c,f){"use strict";function l(e,t){var n=t*A,o=r.unpack(e,n,T);n+=r.packedLength;var i=u.unpack(e,n,w.modelMatrix);u.multiplyByScale(i,o,i);var a=w.boundingVolume;return r.clone(r.ZERO,a.center),a.radius=Math.sqrt(3),w}function p(e,t){var n=t*R,o=e[n++],i=e[n++],a=r.fromElements(o,o,i,T),s=u.unpack(e,n,w.modelMatrix);u.multiplyByScale(s,a,s);var c=w.boundingVolume;return r.clone(r.ZERO,c.center),c.radius=Math.sqrt(2),w}function d(e,t){var n=t*b,o=r.unpack(e,n,T);n+=r.packedLength;var i=u.unpack(e,n,w.modelMatrix);u.multiplyByScale(i,o,i);var a=w.boundingVolume;return r.clone(r.ZERO,a.center),a.radius=1,w}function h(e,t){var n=t*g,o=e[n++],i=r.unpack(e,n,T),a=u.fromTranslation(i,w.modelMatrix);u.multiplyByUniformScale(a,o,a);var s=w.boundingVolume;return r.clone(r.ZERO,s.center),s.radius=1,w}function y(t,o,a,s,f){if(i(o)){for(var l=a.length,p=s.attributes.position.values,d=s.indices,h=t.positions,y=t.vertexBatchIds,m=t.indices,E=t.batchIds,O=t.batchTableColors,_=t.batchedIndices,T=t.indexOffsets,A=t.indexCounts,R=t.boundingVolumes,b=t.modelMatrix,g=t.center,w=t.positionOffset,v=t.batchIdIndex,C=t.indexOffset,I=t.batchedIndicesOffset,N=0;l>N;++N){var M=f(o,N),x=M.modelMatrix;u.multiply(b,x,x);for(var F=a[N],D=p.length,P=0;D>P;P+=3){var U=r.unpack(p,P,S);u.multiplyByPoint(x,U,U),r.subtract(U,g,U),r.pack(U,h,3*w+P),y[v++]=F}for(var L=d.length,B=0;L>B;++B)m[C+B]=d[B]+w;var q=N+I;_[q]=new c({offset:C,count:L,color:n.fromRgba(O[F]),batchIds:[F]}),E[q]=F,T[q]=C,A[q]=L,R[q]=e.transform(M.boundingVolume,x),w+=D/3,C+=L}t.positionOffset=w,t.batchIdIndex=v,t.indexOffset=C,t.batchedIndicesOffset+=l}}function m(e){var t=new Float64Array(e),n=0;r.unpack(t,n,v),n+=r.packedLength,u.unpack(t,n,C)}function E(e){for(var t=e.length,r=0,o=0;t>o;++o)r+=n.packedLength+3+e[o].batchIds.length;return r}function O(t,r,o){var i=o.length,a=2+i*e.packedLength+1+E(r),s=new Float64Array(a),u=0;s[u++]=t,s[u++]=i;for(var c=0;i>c;++c)e.pack(o[c],s,u),u+=e.packedLength;var f=r.length;s[u++]=f;for(var l=0;f>l;++l){var p=r[l];n.pack(p.color,s,u),u+=n.packedLength,s[u++]=p.offset,s[u++]=p.count;var d=p.batchIds,h=d.length;s[u++]=h;for(var y=0;h>y;++y)s[u++]=d[y]}return s}function _(e,r){var n=i(e.boxes)?new Float32Array(e.boxes):void 0,u=i(e.boxBatchIds)?new Uint16Array(e.boxBatchIds):void 0,c=i(e.cylinders)?new Float32Array(e.cylinders):void 0,f=i(e.cylinderBatchIds)?new Uint16Array(e.cylinderBatchIds):void 0,E=i(e.ellipsoids)?new Float32Array(e.ellipsoids):void 0,_=i(e.ellipsoidBatchIds)?new Uint16Array(e.ellipsoidBatchIds):void 0,T=i(e.spheres)?new Float32Array(e.spheres):void 0,A=i(e.sphereBatchIds)?new Uint16Array(e.sphereBatchIds):void 0,R=i(n)?u.length:0,b=i(c)?f.length:0,g=i(E)?_.length:0,w=i(T)?A.length:0,S=t.getUnitBox(),I=o.getUnitCylinder(),N=a.getUnitEllipsoid(),M=S.attributes.position.values,x=I.attributes.position.values,F=N.attributes.position.values,D=M.length*R;D+=x.length*b,D+=F.length*(g+w);var P=S.indices,U=I.indices,L=N.indices,B=P.length*R;B+=U.length*b,B+=L.length*(g+w);var q=new Float32Array(D),j=new Uint16Array(D/3),z=s.createTypedArray(D/3,B),G=R+b+g+w,k=new Uint16Array(G),V=new Array(G),W=new Uint32Array(G),Y=new Uint32Array(G),H=new Array(G);m(e.packedBuffer);var X={batchTableColors:new Uint32Array(e.batchTableColors),positions:q,vertexBatchIds:j,indices:z,batchIds:k,batchedIndices:V,indexOffsets:W,indexCounts:Y,boundingVolumes:H,positionOffset:0,batchIdIndex:0,indexOffset:0,batchedIndicesOffset:0,modelMatrix:C,center:v};y(X,n,u,S,l),y(X,c,f,I,p),y(X,E,_,N,d),y(X,T,A,N,h);var K=O(z.BYTES_PER_ELEMENT,V,H);return r.push(q.buffer,j.buffer,z.buffer),r.push(k.buffer,W.buffer,Y.buffer),r.push(K.buffer),{positions:q.buffer,vertexBatchIds:j.buffer,indices:z.buffer,indexOffsets:W.buffer,indexCounts:Y.buffer,batchIds:k.buffer,packedBuffer:K.buffer}}var T=new r,A=u.packedLength+r.packedLength,R=u.packedLength+2,b=u.packedLength+r.packedLength,g=r.packedLength+1,w={modelMatrix:new u,boundingVolume:new e},S=new r,v=new r,C=new u;return f(_)})}();