/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(n,i){if(!e(i))throw new t(r(n))},i.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},i.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},i.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},i.typeOf.number.lessThan=function(e,r,n){if(i.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},i.typeOf.number.lessThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},i.typeOf.number.greaterThan=function(e,r,n){if(i.typeOf.number(e,r),n>=r)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},i.typeOf.number.greaterThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),n>r)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},i.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},i.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},i.typeOf.number.equals=function(e,r,n,a){if(i.typeOf.number(e,n),i.typeOf.number(r,a),n!==a)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+a)},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,i){"use strict";var a={};a.Radius=6378137,a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.EPSILON21=1e-21,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*a.clamp(e,-1,1)+.5)*t)},a.fromSNorm=function(e,t){return t=r(t,255),a.clamp(e,0,t)/t*2-1},a.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),a.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},a.equalsEpsilon=function(e,t,a,o){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(a))throw new i("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-t);return o>=u||u<=a*Math.max(Math.abs(e),Math.abs(t))},a.lessThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return-r>e-t},a.lessThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return r>e-t},a.greaterThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>r},a.greaterThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>-r};var o=[1];a.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var t=o.length;if(e>=t)for(var r=o[t-1],n=t;e>=n;n++)o.push(r*n);return o[e]},a.incrementWrap=function(e,t,a){if(a=r(a,0),!n(e))throw new i("n is required.");if(a>=t)throw new i("maximumValue must be greater than minimumValue.");return++e,e>t&&(e=a),e},a.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return t>e?t:e>r?r:e};var u=new e;return a.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},a.nextRandomNumber=function(){return u.random()},a.randomBetween=function(e,t){return a.nextRandomNumber()*(t-e)+e},a.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},a.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return 0>e?-t:t}),a.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),a.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},a.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},a.fastApproximateAtan2=function(e,r){t.typeOf.number("x",e),t.typeOf.number("y",r);var n,o,u=Math.abs(e);n=Math.abs(r),o=Math.max(u,n),n=Math.min(u,n);var s=n/o;if(isNaN(s))throw new i("either x or y must be nonzero");return u=a.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?a.PI_OVER_TWO-u:u,u=0>e?a.PI-u:u,u=0>r?-u:u},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;i>a;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;a>u;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f);var n=o.dot(c,f),i=o.magnitude(o.cross(c,f,c));return Math.atan2(i,n)};var l=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=o.dot(t,r)/o.dot(r,r);return o.multiplyByScalar(r,i,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,f=a*c-o*s,l=o*u-i*c,p=i*s-a*u;return n.x=f,n.y=l,n.z=p,n},o.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var p=new o,d=new o,h=new o(40680631590769,40680631590769,40408299984661.445),y=new o(40680631590769,40680631590769,40680631590769);return o.fromRadians=function(n,i,u,s,c){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),u=t(u,0);var f=r(s)?s.radiiSquared:y;a.equalsEpsilon(a.Radius,6356752.314245179,a.EPSILON10)&&(f=r(s)?s.radiiSquared:h);var l=Math.cos(i);p.x=l*Math.cos(n),p.y=l*Math.sin(n),p.z=Math.sin(i),p=o.normalize(p,p),o.multiplyComponents(f,p,d);var E=Math.sqrt(o.dot(p,d));return d=o.divideByScalar(d,E,d),p=o.multiplyByScalar(p,u,p),r(c)||(c=new o),o.add(d,p,c)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromDegrees(c,f,0,i,a[l])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromRadians(c,f,0,i,a[l])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;a[p]=o.fromDegrees(c,f,l,i,a[p])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;a[p]=o.fromRadians(c,f,l,i,a[p])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/arrayFill",["./Check","./defaultValue","./defined"],function(e,t,r){"use strict";function n(n,i,a,o){if(e.defined("array",n),e.defined("value",i),r(a)&&e.typeOf.number("start",a),r(o)&&e.typeOf.number("end",o),"function"==typeof n.fill)return n.fill(i,a,o);for(var u=n.length>>>0,s=t(a,0),c=0>s?Math.max(u+s,0):Math.min(s,u),f=t(o,u),l=0>f?Math.max(u+f,0):Math.min(f,u);l>c;)n[c]=i,c++;return n}return n}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(i,u,s,c,f){if(!t(i))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=i.x,p=i.y,d=i.z,h=u.x,y=u.y,E=u.z,m=l*l*h*h,O=p*p*y*y,_=d*d*E*E,T=m+O+_,R=Math.sqrt(1/T),w=e.multiplyByScalar(i,R,a);if(c>T)return isFinite(R)?e.clone(w,f):void 0;var A=s.x,b=s.y,v=s.z,S=o;S.x=w.x*A*2,S.y=w.y*b*2,S.z=w.z*v*2;var I,N,g,M,C,x,P,U,D,q,F,L=(1-R)*e.magnitude(i)/(.5*e.magnitude(S)),j=0;do{L-=j,g=1/(1+L*A),M=1/(1+L*b),C=1/(1+L*v),x=g*g,P=M*M,U=C*C,D=x*g,q=P*M,F=U*C,I=m*x+O*P+_*U-1,N=m*D*A+O*q*b+_*F*v;var B=-2*N;j=I/B}while(Math.abs(I)>n.EPSILON12);return t(f)?(f.x=l*g,f.y=p*M,f.z=d*C,f):new e(l*g,p*M,d*C)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,a,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),a=r(a,0),n(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=a.toRadians(e),r=a.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/6378137,1/6378137,1/6378137),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=new e(1/40680631590769,1/40680631590769,1/40680631590769),y=a.EPSILON1;return u.fromCartesian=function(t,r,i){var E=n(r)?r.oneOverRadii:p,m=n(r)?r.oneOverRadiiSquared:h,O=n(r)?r._centerToleranceSquared:y;a.equalsEpsilon(a.Radius,6356752.314245179,a.EPSILON10)&&(E=n(r)?r.oneOverRadii:l,m=n(r)?r.oneOverRadiiSquared:d);var _=o(t,E,m,O,c);if(n(_)){var T=e.multiplyComponents(_,m,s);T=e.normalize(T,T);var R=e.subtract(t,_,f),w=Math.atan2(T.y,T.x),A=Math.asin(T.z),b=a.sign(e.dot(R,t))*e.magnitude(R);return n(i)?(i.longitude=w,i.latitude=A,i.height=b,i):new u(w,A,b)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.sphericalDistance=function(e,r,n,i){if(t.defined("longitudeA",e),t.defined("longitudeB",n),t.defined("latitudeA",r),t.defined("latitudeB",i),e===n&&r===i)return 0;var o=a.toRadians(r),u=a.toRadians(i),s=a.toRadians(e),c=a.toRadians(n),f=s*s+o*o,l=c*c+u*u,p=(s-c)*(s-c)+(o-u)*(o-u),d=(f+l-p)/(2*Math.sqrt(f)*Math.sqrt(l));return d=a.clamp(d,-1,1),Math.acos(d)*a.Radius},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(t,i,a,o){i=n(i,0),a=n(a,0),o=n(o,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",a,0),r.typeOf.number.greaterThanOrEquals("z",o,0),s.equalsEpsilon(o,6356752.314245179,s.EPSILON10)&&(s.Radius=o),t._radii=new e(i,a,o),t._radiiSquared=new e(i*i,a*a,o*o),t._radiiToTheFourth=new e(i*i*i*i,a*a*a*a,o*o*o*o),t._oneOverRadii=new e(0===i?0:1/i,0===a?0:1/a,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===a?0:1/(a*a),0===o?0:1/(o*o)),t._minimumRadius=Math.min(i,a,o),t._maximumRadius=Math.max(i,a,o),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return i(t)||(t=new l),i(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,s.Radius)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,i,a){return r.typeOf.object("value",t),r.defined("array",i),a=n(a,0),e.pack(t._radii,i,a),i},l.unpack=function(t,i,a){r.defined("array",t),i=n(i,0);var o=e.unpack(t,i);return l.fromCartesian3(o,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var a=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(a),c=u*Math.sin(a),f=Math.sin(o);return i(n)||(n=new e),n.x=s,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var p=new e,d=new e;l.prototype.cartographicToCartesian=function(t,r){var n=p,a=d;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,a);var o=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(a,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var h=new e,y=new e,E=new e;return l.prototype.cartesianToCartographic=function(r,n){var a=this.scaleToGeodeticSurface(r,y);if(i(a)){var o=this.geodeticSurfaceNormal(a,h),u=e.subtract(r,a,E),c=Math.atan2(o.y,o.x),f=Math.asin(o.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var a=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(a*a*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new o("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),a=n(a,0);var c=this._squaredXOverSquaredZ;return i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),Math.abs(u.z)>=this._radii.z-a?void 0:u},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function f(e){for(var t=0,r=0;3>r;++r){var n=e[s.getElementIndex(y[r],h[r])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;3>a;++a){var o=Math.abs(e[s.getElementIndex(y[a],h[a])]);o>n&&(i=a,n=o)}var c=1,f=0,l=h[i],p=y[i];if(Math.abs(e[s.getElementIndex(p,l)])>r){var d,E=e[s.getElementIndex(p,p)],m=e[s.getElementIndex(l,l)],O=e[s.getElementIndex(p,l)],_=(E-m)/2/O;d=0>_?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),c=1/Math.sqrt(1+d*d),f=d*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(l,l)]=t[s.getElementIndex(p,p)]=c,t[s.getElementIndex(p,l)]=f,t[s.getElementIndex(l,p)]=-f,t}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,p=e.z*e.z,d=e.z*e.w,h=e.w*e.w,y=i-c-p+h,E=2*(a-d),m=2*(o+l),O=2*(a+d),_=-i+c-p+h,T=2*(f-u),R=2*(o-l),w=2*(f+u),A=-i-c+p+h;return n(r)?(r[0]=y,r[1]=O,r[2]=R,r[3]=E,r[4]=_,r[5]=w,r[6]=m,r[7]=T,r[8]=A,r):new s(y,E,m,O,_,T,R,w,A)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=i*a,p=-o*c+f*u*a,d=f*c+o*u*a,h=i*c,y=o*a+f*u*c,E=-f*a+o*u*c,m=-u,O=f*i,_=o*i;return n(r)?(r[0]=l,r[1]=h,r[2]=m,r[3]=p,r[4]=y,r[5]=O,r[6]=d,r[7]=E,r[8]=_,r):new s(l,p,d,h,y,E,m,O,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),
t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i);var a=3*r;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i),i[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var p=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],p)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],p)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],p)),n};var d=new e;s.getMaximumScale=function(t){return s.getScale(t,d),e.maximumComponent(d)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=p,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var h=[1,0,0],y=[2,2,1],E=new s,m=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=10,o=0,p=0;n(r)||(r={});for(var d=r.unitary=s.clone(s.IDENTITY,r.unitary),h=r.diagonal=s.clone(e,r.diagonal),y=i*c(h);a>p&&f(h)>y;)l(h,E),s.transpose(E,m),s.multiply(h,E,h),s.multiply(m,h,h),s.multiply(d,E,d),++o>2&&(++p,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(o*f-c*u)+a*(c*i-n*f)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],f=e[4],l=e[5],p=e[6],d=e[7],h=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=f*h-d*l,r[1]=d*o-i*h,r[2]=i*l-f*o,r[3]=p*l-c*h,r[4]=n*h-p*o,r[5]=c*o-n*l,r[6]=c*d-p*f,r[7]=p*i-n*d,r[8]=n*f-c*i;var E=1/y;return s.multiplyByScalar(r,E,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;i>a;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;i>a;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1),l=256,p=65536,d=16777216,h=1/l,y=1/p,E=1/d,m=38;return o.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new o),f[0]=t,t=f[0],0===t)return o.clone(o.ZERO,n);var i,u=0>t?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(a.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=m);var s=t*l;return n.x=Math.floor(s),s=(s-n.x)*l,n.y=Math.floor(s),s=(s-n.y)*l,n.z=Math.floor(s),n.w=2*(i+m)+u,n},o.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(n-=m,i=2*i-1,i=-i,n>=m)return 0>i?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=i*t.x*h;return a+=i*t.y*y,a+=i*t.z*E,a*Math.pow(10,n)},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(e,t,r,i,a,o,u,s,c,f,l,p,d,h,y,E){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(f,0),this[7]=n(h,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(p,0),this[15]=n(E,0)}f.packedLength=16,f.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},f.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new f),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},f.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new f(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new f);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,p=t.x*t.z,d=t.x*t.w,h=t.y*t.y,y=t.y*t.z,E=t.y*t.w,m=t.z*t.z,O=t.z*t.w,_=t.w*t.w,T=c-h-m+_,R=2*(l-O),w=2*(p+E),A=2*(l+O),b=-c+h-m+_,v=2*(y-d),S=2*(p-E),I=2*(y+d),N=-c-h+m+_;return a[0]=T*o,a[1]=A*o,a[2]=S*o,a[3]=0,a[4]=R*u,a[5]=b*u,a[6]=I*u,a[7]=0,a[8]=w*s,a[9]=v*s,a[10]=N*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,p=new e,d=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,l),e.normalize(e.cross(l,u,p),p),e.normalize(e.cross(p,l,d),d);var s=p.x,c=p.y,h=p.z,y=l.x,E=l.y,m=l.z,O=d.x,_=d.y,T=d.z,R=a.x,w=a.y,A=a.z,b=s*-R+c*-w+h*-A,v=O*-R+_*-w+T*-A,S=y*R+E*w+m*A;return i(n)?(n[0]=s,n[1]=O,n[2]=-y,n[3]=0,n[4]=c,n[5]=_,n[6]=-E,n[7]=0,n[8]=h,n[9]=T,n[10]=-m,n[11]=0,n[12]=b,n[13]=v,n[14]=S,n[15]=1,n):new f(s,c,h,b,O,_,T,v,-y,-E,-m,S,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=Math.tan(.5*e),u=1/o,s=u/t,c=(i+n)/(n-i),f=2*i*n/(n-i);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},f.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),f=1/(o-a),l=-(t+e)*s,p=-(i+n)*c,d=-(o+a)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=p,u[14]=d,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),f=(t+e)/(t-e),l=(i+n)/(i-n),p=-(o+a)/(o-a),d=-1,h=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=p,u[11]=d,u[12]=0,u[13]=0,u[14]=h,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),f=(i+n)/(i-n),l=-1,p=-1,d=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=f,o[10]=l,o[11]=p,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},f.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),i=n(i,1);var f=.5*s,l=.5*c,p=.5*(i-t),d=f,h=l,y=p,E=o+f,m=u+l,O=t+p,_=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=E,a[13]=m,a[14]=O,a[15]=_,a},f.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},f.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i);var a=4*t;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var h=new e;f.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var a=f.getScale(t,h),o=e.divideComponents(n,a,h);return f.multiplyByScale(t,o,i)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},f.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var y=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var E=new e;f.getMaximumScale=function(t){return f.getScale(t,E),e.maximumComponent(E)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],p=e[8],d=e[9],h=e[10],y=e[11],E=e[12],m=e[13],O=e[14],_=e[15],T=t[0],R=t[1],w=t[2],A=t[3],b=t[4],v=t[5],S=t[6],I=t[7],N=t[8],g=t[9],M=t[10],C=t[11],x=t[12],P=t[13],U=t[14],D=t[15],q=i*T+s*R+p*w+E*A,F=a*T+c*R+d*w+m*A,L=o*T+f*R+h*w+O*A,j=u*T+l*R+y*w+_*A,B=i*b+s*v+p*S+E*I,z=a*b+c*v+d*S+m*I,G=o*b+f*v+h*S+O*I,V=u*b+l*v+y*S+_*I,X=i*N+s*g+p*M+E*C,W=a*N+c*g+d*M+m*C,k=o*N+f*g+h*M+O*C,H=u*N+l*g+y*M+_*C,Y=i*x+s*P+p*U+E*D,K=a*x+c*P+d*U+m*D,Z=o*x+f*P+h*U+O*D,J=u*x+l*P+y*U+_*D;return n[0]=q,n[1]=F,n[2]=L,n[3]=j,n[4]=B,n[5]=z,n[6]=G,n[7]=V,n[8]=X,n[9]=W,n[10]=k,n[11]=H,n[12]=Y,n[13]=K,n[14]=Z,n[15]=J,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],d=e[12],h=e[13],y=e[14],E=t[0],m=t[1],O=t[2],_=t[4],T=t[5],R=t[6],w=t[8],A=t[9],b=t[10],v=t[12],S=t[13],I=t[14],N=i*E+u*m+f*O,g=a*E+s*m+l*O,M=o*E+c*m+p*O,C=i*_+u*T+f*R,x=a*_+s*T+l*R,P=o*_+c*T+p*R,U=i*w+u*A+f*b,D=a*w+s*A+l*b,q=o*w+c*A+p*b,F=i*v+u*S+f*I+d,L=a*v+s*S+l*I+h,j=o*v+c*S+p*I+y;return n[0]=N,n[1]=g,n[2]=M,n[3]=0,n[4]=C,n[5]=x,n[6]=P,n[7]=0,n[8]=U,n[9]=D,n[10]=q,n[11]=0,n[12]=F,n[13]=L,n[14]=j,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],d=t[0],h=t[1],y=t[2],E=t[3],m=t[4],O=t[5],_=t[6],T=t[7],R=t[8],w=i*d+u*h+f*y,A=a*d+s*h+l*y,b=o*d+c*h+p*y,v=i*E+u*m+f*O,S=a*E+s*m+l*O,I=o*E+c*m+p*O,N=i*_+u*T+f*R,g=a*_+s*T+l*R,M=o*_+c*T+p*R;return n[0]=w,n[1]=A,n[2]=b,n[3]=0,n[4]=v,n[5]=S,n[6]=I,n[7]=0,n[8]=N,n[9]=g,n[10]=M,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var m=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),m.x=t,m.y=t,m.z=t,f.multiplyByScale(e,m,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?f.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,f=e[2]*i+e[6]*a+e[10]*o+e[14]*u,l=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.multiplyByPlane=function(n,i,a){r.typeOf.object("matrix",n),r.typeOf.object("plane",i),r.typeOf.object("result",a);var o=new f,u=new f;f.inverse(n,o),f.transpose(o,u);var s=new t(i.normal.x,i.normal.y,i.normal.z,i.distance);f.multiplyByVector(u,s,s),a.normal.x=s.x,a.normal.y=s.y,a.normal.z=s.z;var c=e.magnitude(a.normal);return e.normalize(a.normal,a.normal),a.distance=s.w/c,a},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,_=new s,T=new t,R=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],a=e[4],o=e[8],l=e[12],p=e[1],d=e[5],h=e[9],y=e[13],E=e[2],m=e[6],w=e[10],A=e[14],b=e[3],v=e[7],S=e[11],I=e[15],N=w*I,g=A*S,M=m*I,C=A*v,x=m*S,P=w*v,U=E*I,D=A*b,q=E*S,F=w*b,L=E*v,j=m*b,B=N*d+C*h+x*y-(g*d+M*h+P*y),z=g*p+U*h+F*y-(N*p+D*h+q*y),G=M*p+D*d+L*y-(C*p+U*d+j*y),V=P*p+q*d+j*h-(x*p+F*d+L*h),X=g*a+M*o+P*l-(N*a+C*o+x*l),W=N*i+D*o+q*l-(g*i+U*o+F*l),k=C*i+U*a+j*l-(M*i+D*a+L*l),H=x*i+F*a+L*o-(P*i+q*a+j*o);N=o*y,g=l*h,M=a*y,C=l*d,x=a*h,P=o*d,U=i*y,D=l*p,q=i*h,F=o*p,L=i*d,j=a*p;var Y=N*v+C*S+x*I-(g*v+M*S+P*I),K=g*b+U*S+F*I-(N*b+D*S+q*I),Z=M*b+D*v+L*I-(C*b+U*v+j*I),J=P*b+q*v+j*S-(x*b+F*v+L*S),Q=M*w+P*A+g*m-(x*A+N*m+C*w),$=q*A+N*E+D*w-(U*w+F*A+g*E),ee=U*m+j*A+C*E-(L*A+M*E+D*m),te=L*w+x*E+F*m-(q*m+j*w+P*E),re=i*B+a*z+o*G+l*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(f.getRotation(e,O),_,u.EPSILON7)&&t.equals(f.getRow(e,3,T),R))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=B*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=X*re,n[5]=W*re,n[6]=k*re,n[7]=H*re,n[8]=Y*re,n[9]=K*re,n[10]=Z*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],p=e[12],d=e[13],h=e[14],y=-n*p-i*d-a*h,E=-o*p-u*d-s*h,m=-c*p-f*d-l*h;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=f,t[7]=0,t[8]=a,t[9]=s,t[10]=l,t[11]=0,t[12]=y,t[13]=E,t[14]=m,t[15]=1,t},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,a(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;
return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,p=0,d=e.length;d>p;p++){var h=e[p];i=Math.min(i,h.longitude),a=Math.max(a,h.longitude),f=Math.min(f,h.latitude),l=Math.max(l,h.latitude);var y=h.longitude>=0?h.longitude:h.longitude+u.TWO_PI;o=Math.min(o,y),c=Math.max(c,y)}return a-i>c-o&&(i=o,a=c,a>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=f,r.east=a,r.north=l,r):new s(i,f,a,l)},s.fromCartesianArray=function(e,i,o){t.defined("cartesians",e),i=r(i,a.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,d=Number.MAX_VALUE,h=-Number.MAX_VALUE,y=0,E=e.length;E>y;y++){var m=i.cartesianToCartographic(e[y]);c=Math.min(c,m.longitude),f=Math.max(f,m.longitude),d=Math.min(d,m.latitude),h=Math.max(h,m.latitude);var O=m.longitude>=0?m.longitude:m.longitude+u.TWO_PI;l=Math.min(l,O),p=Math.max(p,O)}return f-c>p-l&&(c=l,f=p,f>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(o)?(o.west=c,o.south=d,o.east=f,o.north=h,o):new s(c,d,f,h)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;o>a&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,f=r.west;o>a&&c>0?a+=u.TWO_PI:f>c&&a>0&&(c+=u.TWO_PI),o>a&&0>f?f+=u.TWO_PI:f>c&&0>o&&(o+=u.TWO_PI);var l=u.negativePiToPi(Math.max(o,f)),p=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&l>=p)){var d=Math.max(e.south,r.south),h=Math.min(e.north,r.north);if(!(d>=h))return n(i)?(i.west=l,i.south=d,i.east=p,i.north=h,i):new s(l,d,p,h)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);return o>=c||a>=u?void 0:n(i)?(i.west=a,i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,f=r.west;o>a&&c>0?a+=u.TWO_PI:f>c&&a>0&&(c+=u.TWO_PI),o>a&&0>f?f+=u.TWO_PI:f>c&&0>o&&(o+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(o,f)),p=u.convertLongitudeRange(Math.max(a,c));return i.west=l,i.south=Math.min(e.south,r.south),i.east=p,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return a>o&&(o+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(o>n||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,f){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(f)||(f=[]);var l=0,p=e.north,d=e.south,h=e.east,y=e.west,E=c;E.height=o,E.longitude=y,E.latitude=p,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=h,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.latitude=d,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=y,f[l]=i.cartographicToCartesian(E,f[l]),l++,0>p?E.latitude=p:d>0?E.latitude=d:E.latitude=0;for(var m=1;8>m;++m)E.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,E)&&(f[l]=i.cartographicToCartesian(E,f[l]),l++);return 0===E.latitude&&(E.longitude=y,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=h,f[l]=i.cartographicToCartesian(E,f[l]),l++),f.length=l,f},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,f,l,p){"use strict";function d(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var h=new e,y=new e,E=new e,m=new e,O=new e,_=new e,T=new e,R=new e,w=new e,A=new e,b=new e,v=new e,S=4/3*c.PI;d.fromPoints=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,a=e.clone(t[0],T),o=e.clone(a,h),u=e.clone(a,y),s=e.clone(a,E),c=e.clone(a,m),f=e.clone(a,O),l=e.clone(a,_),p=t.length;for(n=1;p>n;n++){e.clone(t[n],a);var S=a.x,I=a.y,N=a.z;S<o.x&&e.clone(a,o),S>c.x&&e.clone(a,c),I<u.y&&e.clone(a,u),I>f.y&&e.clone(a,f),N<s.z&&e.clone(a,s),N>l.z&&e.clone(a,l)}var g=e.magnitudeSquared(e.subtract(c,o,R)),M=e.magnitudeSquared(e.subtract(f,u,R)),C=e.magnitudeSquared(e.subtract(l,s,R)),x=o,P=c,U=g;M>U&&(U=M,x=u,P=f),C>U&&(U=C,x=s,P=l);var D=w;D.x=.5*(x.x+P.x),D.y=.5*(x.y+P.y),D.z=.5*(x.z+P.z);var q=e.magnitudeSquared(e.subtract(P,D,R)),F=Math.sqrt(q),L=A;L.x=o.x,L.y=u.y,L.z=s.z;var j=b;j.x=c.x,j.y=f.y,j.z=l.z;var B=e.midpoint(L,j,v),z=0;for(n=0;p>n;n++){e.clone(t[n],a);var G=e.magnitude(e.subtract(a,B,R));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(a,D,R));if(V>q){var X=Math.sqrt(V);F=.5*(F+X),q=F*F;var W=X-F;D.x=(F*D.x+W*a.x)/X,D.y=(F*D.y+W*a.y)/X,D.z=(F*D.z+W*a.z)/X}}return z>F?(e.clone(D,r.center),r.radius=F):(e.clone(B,r.center),r.radius=z),r};var I=new o,N=new e,g=new e,M=new t,C=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new d),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,I),p.southwest(t,M),M.height=a,p.northeast(t,C),C.height=o;var s=r.project(M,N),c=r.project(C,g),f=c.x-s.x,l=c.y-s.y,h=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+h*h);var y=u.center;return y.x=s.x+.5*f,y.y=s.y+.5*l,y.z=s.z+.5*h,u};var x=[];d.fromRectangle3D=function(t,r,o,u){if(r=n(r,a.WGS84),o=n(o,0),i(u)||(u=new d),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=p.subsample(t,r,o,x);return d.fromPoints(s,u)},d.fromVertices=function(t,a,o,u){if(i(u)||(u=new d),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=T;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;var c,f=e.clone(s,h),l=e.clone(s,y),p=e.clone(s,E),S=e.clone(s,m),I=e.clone(s,O),N=e.clone(s,_),g=t.length;for(c=0;g>c;c+=o){var M=t[c]+a.x,C=t[c+1]+a.y,x=t[c+2]+a.z;s.x=M,s.y=C,s.z=x,M<f.x&&e.clone(s,f),M>S.x&&e.clone(s,S),C<l.y&&e.clone(s,l),C>I.y&&e.clone(s,I),x<p.z&&e.clone(s,p),x>N.z&&e.clone(s,N)}var P=e.magnitudeSquared(e.subtract(S,f,R)),U=e.magnitudeSquared(e.subtract(I,l,R)),D=e.magnitudeSquared(e.subtract(N,p,R)),q=f,F=S,L=P;U>L&&(L=U,q=l,F=I),D>L&&(L=D,q=p,F=N);var j=w;j.x=.5*(q.x+F.x),j.y=.5*(q.y+F.y),j.z=.5*(q.z+F.z);var B=e.magnitudeSquared(e.subtract(F,j,R)),z=Math.sqrt(B),G=A;G.x=f.x,G.y=l.y,G.z=p.z;var V=b;V.x=S.x,V.y=I.y,V.z=N.z;var X=e.midpoint(G,V,v),W=0;for(c=0;g>c;c+=o){s.x=t[c]+a.x,s.y=t[c+1]+a.y,s.z=t[c+2]+a.z;var k=e.magnitude(e.subtract(s,X,R));k>W&&(W=k);var H=e.magnitudeSquared(e.subtract(s,j,R));if(H>B){var Y=Math.sqrt(H);z=.5*(z+Y),B=z*z;var K=Y-z;j.x=(z*j.x+K*s.x)/Y,j.y=(z*j.y+K*s.y)/Y,j.z=(z*j.z+K*s.z)/Y}}return W>z?(e.clone(j,u.center),u.radius=z):(e.clone(X,u.center),u.radius=W),u},d.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new d),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=T;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];var o,u=e.clone(a,h),s=e.clone(a,y),c=e.clone(a,E),f=e.clone(a,m),l=e.clone(a,O),p=e.clone(a,_),S=t.length;for(o=0;S>o;o+=3){var I=t[o]+r[o],N=t[o+1]+r[o+1],g=t[o+2]+r[o+2];a.x=I,a.y=N,a.z=g,I<u.x&&e.clone(a,u),I>f.x&&e.clone(a,f),N<s.y&&e.clone(a,s),N>l.y&&e.clone(a,l),g<c.z&&e.clone(a,c),g>p.z&&e.clone(a,p)}var M=e.magnitudeSquared(e.subtract(f,u,R)),C=e.magnitudeSquared(e.subtract(l,s,R)),x=e.magnitudeSquared(e.subtract(p,c,R)),P=u,U=f,D=M;C>D&&(D=C,P=s,U=l),x>D&&(D=x,P=c,U=p);var q=w;q.x=.5*(P.x+U.x),q.y=.5*(P.y+U.y),q.z=.5*(P.z+U.z);var F=e.magnitudeSquared(e.subtract(U,q,R)),L=Math.sqrt(F),j=A;j.x=u.x,j.y=s.y,j.z=c.z;var B=b;B.x=f.x,B.y=l.y,B.z=p.z;var z=e.midpoint(j,B,v),G=0;for(o=0;S>o;o+=3){a.x=t[o]+r[o],a.y=t[o+1]+r[o+1],a.z=t[o+2]+r[o+2];var V=e.magnitude(e.subtract(a,z,R));V>G&&(G=V);var X=e.magnitudeSquared(e.subtract(a,q,R));if(X>F){var W=Math.sqrt(X);L=.5*(L+W),F=L*L;var k=W-L;q.x=(L*q.x+k*a.x)/W,q.y=(L*q.y+k*a.y)/W,q.z=(L*q.z+k*a.z)/W}}return G>L?(e.clone(q,n.center),n.radius=L):(e.clone(z,n.center),n.radius=G),n},d.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new d);var o=e.midpoint(t,n,a.center);return a.radius=e.distance(o,n),a},d.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;d.fromBoundingSpheres=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return d.clone(t[0],r);if(2===n)return d.union(t[0],t[1],r);var a,o=[];for(a=0;n>a;a++)o.push(t[a].center);r=d.fromPoints(o,r);var u=r.center,s=r.radius;for(a=0;n>a;a++){var c=t[a];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var U=new e,D=new e,q=new e;d.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new d);var a=t.halfAxes,o=f.getColumn(a,0,U),u=f.getColumn(a,1,D),s=f.getColumn(a,2,q);return e.add(o,u,o),e.add(o,s,o),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(o),n},d.clone=function(t,r){return i(t)?i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius):void 0},d.packedLength=4,d.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},d.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new d);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var F=new e,L=new e;d.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new d);var o=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,o,F),l=e.magnitude(f);if(u>=l+c)return t.clone(a),a;if(c>=l+u)return n.clone(a),a;var p=.5*(u+l+c),h=e.multiplyByScalar(f,(-u+p)/l,L);return e.add(h,o,h),e.clone(h,a.center),a.radius=p,a};var j=new e;d.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=d.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,j));return a>i.radius&&(i.radius=a),i},d.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return-a>s?u.OUTSIDE:a>s?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var B=new e;d.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,B);return e.magnitudeSquared(i)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;d.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,z),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var G=new e,V=new e,X=new e,W=new e,k=new e,H=new t,Y=new Array(8),K=0;8>K;++K)Y[K]=new e;var Z=new o;return d.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t),i=n(i,Z);var o=i.ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,X);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var p=e.negate(l,k),h=e.negate(f,W),y=Y,E=y[0];e.add(c,l,E),e.add(E,f,E),E=y[1],e.add(c,l,E),e.add(E,h,E),E=y[2],e.add(c,p,E),e.add(E,h,E),E=y[3],e.add(c,p,E),e.add(E,f,E),e.negate(c,c),E=y[4],e.add(c,l,E),e.add(E,f,E),E=y[5],e.add(c,l,E),e.add(E,h,E),E=y[6],e.add(c,p,E),e.add(E,h,E),E=y[7],e.add(c,p,E),e.add(E,f,E);for(var m=y.length,O=0;m>O;++O){var _=y[O];e.add(u,_,_);var T=o.cartesianToCartographic(_,H);i.project(T,_)}a=d.fromPoints(y,a),u=a.center;var R=u.x,w=u.y,A=u.z;return u.x=A,u.y=R,u.z=w,a},d.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d.prototype.volume=function(){var e=this.radius;return S*e*e*e},d}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;i>a;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;i>a;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f),a.acosClamped(o.dot(c,f))};var l=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,i){return t(e).then(r,n,i)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=i(e),t}function r(t){return e(t,a)}function n(e){this.then=e}function i(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return a(n)}});return r}function a(e){var r=new n(function(r,n){try{return n?t(n(e)):a(e)}catch(i){return a(i)}});return r}function o(){function e(e,t,r){return p(e,t,r)}function r(e){return h(e)}function i(e){return h(a(e))}function u(e){return d(e)}var s,c,f,l,p,d,h;return c=new n(e),s={then:e,resolve:r,reject:i,progress:u,promise:c,resolver:{resolve:r,reject:i,progress:u}},f=[],l=[],p=function(e,t,r){var n,i;return n=o(),i="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},f.push(function(r){r.then(e,t).then(n.resolve,n.reject,i)}),l.push(i),n.promise},d=function(e){return y(l,e),e},h=function(e){return e=t(e),p=e.then,h=t,d=m,y(f,e),l=f=R,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,i,a){return E(2,arguments),e(t,function(t){function u(e){y(e)}function s(e){h(e)}var c,f,l,p,d,h,y,E,O,_;if(O=t.length>>>0,c=Math.max(0,Math.min(r,O)),l=[],f=O-c+1,p=[],d=o(),c)for(E=d.progress,y=function(e){p.push(e),--f||(h=y=m,d.reject(p))},h=function(e){l.push(e),--c||(h=y=m,d.resolve(l))},_=0;O>_;++_)_ in t&&e(t[_],s,u,E);else d.resolve(l);return d.then(n,i,a)})}function c(e,t,r,n){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,r,n)}function f(e,t,r,n){return E(1,arguments),p(e,O).then(t,r,n)}function l(){return p(arguments,O)}function p(t,r){return e(t,function(t){var n,i,a,u,s,c;if(a=i=t.length>>>0,n=[],c=o(),a)for(u=function(t,i){e(t,r).then(function(e){n[i]=e,--a||c.resolve(n)},c.reject)},s=0;i>s;s++)s in t?u(t[s],s):--a;else c.resolve(n);return c.promise})}function d(t,r){var n=T.call(arguments,1);return e(t,function(t){var i;return i=t.length,n[0]=function(t,n,a){return e(t,function(t){return e(n,function(e){return r(t,e,a,i)})})},_.apply(t,n)})}function h(t,r,n){var i=arguments.length>2;return e(t,function(e){return e=i?n:e,r.resolve(e),e},function(e){return r.reject(e),a(e)},r.progress)}function y(e,t){for(var r,n=0;r=e[n++];)r(t)}function E(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function m(){}function O(e){return e}var _,T,R;return e.defer=o,e.resolve=t,e.reject=r,e.join=l,e.all=f,e.map=p,e.reduce=d,e.any=c,e.some=s,e.chain=h,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(R,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return f(t,function(t){return e.apply(R,t)})})}},T=[].slice,_=[].reduce||function(e){var t,r,n,i,a;if(a=0,t=Object(this),i=t.length>>>0,r=arguments,r.length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;i>a;++a)a in t&&(n=e(n,t[a],a,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen","./RuntimeError","../ThirdParty/when"],function(e,t,r,n,i){"use strict";function a(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(I)&&(I=!1,!h())){var e=/ Chrome\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(I=!0,N=a(e[1]))}return I}function u(){return o()&&N}function s(){if(!t(g)&&(g=!1,!o()&&!h()&&/ Safari\/[\.0-9]+/.test(S.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(g=!0,M=a(e[1]))}return g}function c(){return s()&&M}function f(){if(!t(C)){C=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(S.userAgent);null!==e&&(C=!0,x=a(e[1]),x.isNightly=!!e[2])}return C}function l(){return f()&&x}function p(){if(!t(P)){P=!1;var e;"Microsoft Internet Explorer"===S.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(S.userAgent),null!==e&&(P=!0,U=a(e[1]))):"Netscape"===S.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(S.userAgent),null!==e&&(P=!0,U=a(e[1])))}return P}function d(){return p()&&U}function h(){if(!t(D)){D=!1;var e=/ Edge\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(D=!0,q=a(e[1]))}return D}function y(){return h()&&q}function E(){if(!t(F)){F=!1;var e=/Firefox\/([\.0-9]+)/.exec(S.userAgent);null!==e&&(F=!0,L=a(e[1]))}return F}function m(){return t(j)||(j=/Windows/i.test(S.appVersion)),j}function O(){return E()&&L}function _(){return t(B)||(B="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),B}function T(){return t(z)||(z=!E()&&"undefined"!=typeof PointerEvent&&(!t(S.pointerEnabled)||S.pointerEnabled)),z}function R(){if(!t(V)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;V=t(r)&&""!==r,V&&(G=r)}return V}function w(){return R()?G:void 0}function A(){if(t(W))return W.promise;W=i.defer(),h()&&(X=!1,W.resolve(X));var e=new Image;return e.onload=function(){X=e.width>0&&e.height>0,W.resolve(X)},e.onerror=function(){X=!1,W.resolve(X)},e.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",W.promise}function b(){return t(W)||A(),X}function v(){var e=window.navigator.userAgent.toLowerCase(),t="ipad"==e.match(/ipad/i),r="iphone os"==e.match(/iphone os/i),n="midp"==e.match(/midp/i),i="rv:1.2.3.4"==e.match(/rv:1.2.3.4/i),a="ucweb"==e.match(/ucweb/i),o="android"==e.match(/android/i),u="windows ce"==e.match(/windows ce/i),s="windows mobile"==e.match(/windows mobile/i);return t||r||n||i||a||o||u||s?!1:!0}var S;S="undefined"!=typeof navigator?navigator:{};var I,N,g,M,C,x,P,U,D,q,F,L,j,B,z,G,V,X,W,k=[];"undefined"!=typeof ArrayBuffer&&(k.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&k.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&k.push(CanvasPixelArray));var H={isChrome:o,chromeVersion:u,isSafari:s,safariVersion:c,isWebkit:f,webkitVersion:l,isInternetExplorer:p,internetExplorerVersion:d,isEdge:h,edgeVersion:y,isFirefox:E,firefoxVersion:O,isWindows:m,isNodeJs:_,hardwareConcurrency:e(S.hardwareConcurrency,3),supportsPointerEvents:T,supportsImageRenderingPixelated:R,supportsWebP:A,supportsWebPSync:b,imageRenderingValue:w,typedArrayTypes:k,isPCBroswer:v};return H.supportsFullscreen=function(){return r.supportsFullscreen()},H.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},H.supportsWebWorkers=function(){return"undefined"!=typeof Worker},H.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!H.isEdge()},H}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,
MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}},i(o)}),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,TOP:1,ALL:2};return e(t)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],function(e,t,r,n,i,a){"use strict";function o(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}o.packedLength=4,o.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},o.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a},o.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a},o.fromColumnMajorArray=function(e,r){return t.defined("values",e),o.clone(e,r)},o.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new o(e,0,0,e)},o.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=-a,r[3]=i,r):new o(i,-a,a,i)},o.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},o.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,a=e[i],o=e[i+1];return n.x=a,n.y=o,n},o.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=o.clone(e,i);var a=2*r;return i[a]=n.x,i[a+1]=n.y,i},o.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],a=e[r+2];return n.x=i,n.y=a,n},o.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=o.clone(e,i),i[r]=n.x,i[r+2]=n.y,i};var u=new e;o.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],a=e[0]*r[2]+e[2]*r[3],o=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n},o.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},o.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},o.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,a=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=a,n},o.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},o.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},o.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},o.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],a=e[1],o=e[3];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r},o.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},o.IDENTITY=a(new o(1,0,0,1)),o.ZERO=a(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,i(o.prototype,{length:{get:function(){return o.packedLength}}}),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,a){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var o=i/2,u=Math.sin(o);c=e.normalize(r,c);var f=c.x*u,l=c.y*u,p=c.z*u,d=Math.cos(o);return n(a)?(a.x=f,a.y=l,a.z=p,a.w=d,a):new s(f,l,p,d)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var i,a,o,c,p,d=e[u.COLUMN0ROW0],h=e[u.COLUMN1ROW1],y=e[u.COLUMN2ROW2],E=d+h+y;if(E>0)i=Math.sqrt(E+1),p=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var m=f,O=0;h>d&&(O=1),y>d&&y>h&&(O=2);var _=m[O],T=m[_];i=Math.sqrt(e[u.getElementIndex(O,O)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(T,T)]+1);var R=l;R[O]=.5*i,i=.5/i,p=(e[u.getElementIndex(T,_)]-e[u.getElementIndex(_,T)])*i,R[_]=(e[u.getElementIndex(_,O)]+e[u.getElementIndex(O,_)])*i,R[T]=(e[u.getElementIndex(T,O)]+e[u.getElementIndex(O,T)])*i,a=-R[0],o=-R[1],c=-R[2]}return n(r)?(r.x=a,r.y=o,r.z=c,r.w=p,r):new s(a,o,c,p)};var p=new s,d=new s,h=new s,y=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=s.fromAxisAngle(e.UNIT_X,r.roll,p),h=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(h,y,h),d=s.fromAxisAngle(e.UNIT_Z,-r.heading,p),s.multiply(d,n,n)};var E=new e,m=new e,O=new s,_=new s,T=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,T),s.conjugate(T,T);for(var i=0,a=r-t+1;a>i;i++){var o=3*i;s.unpack(e,4*(t+i),O),s.multiply(O,T,O),O.w<0&&s.negate(O,O),s.computeAxis(O,E);var u=s.computeAngle(O);n[o]=E.x*u,n[o+1]=E.y*u,n[o+2]=E.z*u}},s.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new s),e.fromArray(t,0,m);var u=e.magnitude(m);return s.unpack(r,4*a,_),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(m,u,O),s.multiply(O,_,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return r.x=i,r.y=a,r.z=o,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,a=e.y,o=e.z,u=e.w,s=r.x,c=r.y,f=r.z,l=r.w,p=u*s+i*l+a*f-o*c,d=u*c-i*f+a*l+o*s,h=u*f+i*c-a*s+o*l,y=u*l-i*s-a*c-o*f;return n.x=p,n.y=d,n.z=h,n.w=y,n},s.multiplyByVec=function(t,r,n){var i=new e,a=new e,o=new e(t.x,t.y,t.z);i=e.cross(o,r,i),a=e.cross(o,i,a);var u=new e;u=e.multiplyByScalar(i,2*t.w,u);var s=new e;return s=e.multiplyByScalar(i,2,s),n=e.add(r,u,n),n=e.add(n,s,n)},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var R=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),R=s.multiplyByScalar(r,n,R),i=s.multiplyByScalar(e,1-n,i),s.add(R,i,i)};var w=new s,A=new s,b=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a=s.dot(e,r),u=r;if(0>a&&(a=-a,u=w=s.negate(r,w)),1-a<o.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(a);return A=s.multiplyByScalar(e,Math.sin((1-n)*c),A),b=s.multiplyByScalar(u,Math.sin(n*c),b),i=s.add(A,b,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=o.acosClamped(r.w),a=0;return 0!==i&&(a=i/Math.sin(i)),e.multiplyByScalar(r,a,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),a=0;return 0!==i&&(a=Math.sin(i)/i),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(i),n};var v=new e,S=new e,I=new s,N=new s;s.computeInnerQuadrangle=function(r,n,i,a){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",a);var o=s.conjugate(n,I);s.multiply(o,i,N);var u=s.log(N,v);s.multiply(o,r,N);var c=s.log(N,S);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,I),s.multiply(n,I,a)},s.squad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.slerp(e,r,a,I),c=s.slerp(n,i,a,N);return s.slerp(u,c,2*a*(1-a),o)};for(var g=new s,M=1.9011074535173003,C=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],U=i.supportsTypedArrays()?new Float32Array(8):[],D=0;7>D;++D){var q=D+1,F=2*q+1;C[D]=1/(q*F),x[D]=q/F}return C[7]=M/136,x[7]=8*M/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a,o=s.dot(e,r);o>=0?a=1:(a=-1,o=-o);for(var u=o-1,c=1-n,f=n*n,l=c*c,p=7;p>=0;--p)P[p]=(C[p]*f-x[p])*u,U[p]=(C[p]*l-x[p])*u;var d=a*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),h=c*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),y=s.multiplyByScalar(e,h,g);return s.multiplyByScalar(r,d,i),s.add(y,i,i)},s.fastSquad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.fastSlerp(e,r,a,I),c=s.fastSlerp(n,i,a,N);return s.fastSlerp(u,c,2*a*(1-a),o)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,a,o=0,u=t.length-1;u>=o;)if(i=~~((o+u)/2),a=n(t[i],r),0>a)o=i+1;else{if(!(a>0))return i;u=i-1}return~(u+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var u=n-e.length;return u>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+i(c.toString(t),u||0,"0",!1),a(e,r,n,o,s)},u=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},s=function(e,n,s,c,f,l,p){var d,h,y,E,m;if("%%"==e)return"%";for(var O=!1,_="",T=!1,R=!1,w=" ",A=s.length,b=0;s&&A>b;b++)switch(s.charAt(b)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":w=s.charAt(b+1);break;case"0":T=!0;break;case"#":R=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(p)>-1?6:"d"==p?0:void 0,m=n?t[n.slice(0,-1)]:t[r++],p){case"s":return u(String(m),O,c,l,T,w);case"c":return u(String.fromCharCode(+m),O,c,l,T);case"b":return o(m,2,R,O,c,l,T);case"o":return o(m,8,R,O,c,l,T);case"x":return o(m,16,R,O,c,l,T);case"X":return o(m,16,R,O,c,l,T).toUpperCase();case"u":return o(m,10,R,O,c,l,T);case"i":case"d":return d=+m||0,d=Math.round(d-d%1),h=0>d?"-":_,m=h+i(String(Math.abs(d)),l,"0",!1),a(m,h,O,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=+m,h=0>d?"-":_,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(p.toLowerCase())],E=["toString","toUpperCase"]["eEfFgG".indexOf(p)%2],m=h+Math.abs(d)[y](l),a(m,h,O,c,T)[E]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,i,a,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(e,t){return y.compare(e.julianDate,t.julianDate)}function l(e){_.julianDate=e;var r=y.leapSeconds,n=t(r,_,f);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;if(n>0){var a=y.secondsDifference(r[n].julianDate,e);a>i&&(n--,i=r[n].offset)}y.addSeconds(e,i,e)}function p(e,r){_.julianDate=e;var n=y.leapSeconds,i=t(n,_,f);if(0>i&&(i=~i),0===i)return y.addSeconds(e,-n[0].offset,r);if(i>=n.length)return y.addSeconds(e,-n[i-1].offset,r);var a=y.secondsDifference(n[i].julianDate,e);return 0===a?y.addSeconds(e,-n[i].offset,r):1>=a?void 0:y.addSeconds(e,-n[--i].offset,r)}function d(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function h(e,t,r,n,i,a,o){var u=(t-14)/12|0,c=e+4800+u,f=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;
n-=12,0>n&&(n+=24);var l=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}function y(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;t+=(e-i)*s.SECONDS_PER_DAY,d(i,t,this),n===c.UTC&&l(this)}var E=new a,m=[31,28,31,30,31,30,31,31,30,31,30,31],O=29,_=new u,T=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,w=/^(\d{4})-?(\d{3})$/,A=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,b=/^(\d{4})-?(\d{2})-?(\d{2})$/,v=/([Z+\-])?(\d{2})?:?(\d{2})?$/,S=/^(\d{2})(\.\d+)?/.source+v.source,I=/^(\d{2}):?(\d{2})(\.\d+)?/.source+v.source,N=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+v.source,g="Invalid ISO 8601 date.";y.fromGregorianDate=function(e,t){if(!(e instanceof a))throw new i("date must be a valid GregorianDate.");var r=h(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(d(r[0],r[1],t),l(t),t):new y(r[0],r[1],c.UTC)},y.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=h(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(d(r[0],r[1],t),l(t),t):new y(r[0],r[1],c.UTC)},y.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(g);e=e.replace(",",".");var r,a,u,s=e.split("T"),f=1,p=1,E=0,_=0,v=0,M=0,C=s[0],x=s[1];if(!n(C))throw new i(g);var P;if(s=C.match(b),null!==s){if(P=C.split("-").length-1,P>0&&2!==P)throw new i(g);r=+s[1],f=+s[2],p=+s[3]}else if(s=C.match(R),null!==s)r=+s[1],f=+s[2];else if(s=C.match(T),null!==s)r=+s[1];else{var U;if(s=C.match(w),null!==s){if(r=+s[1],U=+s[2],u=o(r),1>U||u&&U>366||!u&&U>365)throw new i(g)}else{if(s=C.match(A),null===s)throw new i(g);r=+s[1];var D=+s[2],q=+s[3]||0;if(P=C.split("-").length-1,P>0&&(!n(s[3])&&1!==P||n(s[3])&&2!==P))throw new i(g);var F=new Date(Date.UTC(r,0,4));U=7*D+q-F.getUTCDay()-3}a=new Date(Date.UTC(r,0,1)),a.setUTCDate(U),f=a.getUTCMonth()+1,p=a.getUTCDate()}if(u=o(r),1>f||f>12||1>p||(2!==f||!u)&&p>m[f-1]||u&&2===f&&p>O)throw new i(g);var L;if(n(x)){if(s=x.match(N),null!==s){if(P=x.split(":").length-1,P>0&&2!==P&&3!==P)throw new i(g);E=+s[1],_=+s[2],v=+s[3],M=1e3*+(s[4]||0),L=5}else if(s=x.match(I),null!==s){if(P=x.split(":").length-1,P>2)throw new i(g);E=+s[1],_=+s[2],v=60*+(s[3]||0),L=4}else{if(s=x.match(S),null===s)throw new i(g);E=+s[1],_=60*+(s[2]||0),L=3}if(_>=60||v>=61||E>24||24===E&&(_>0||v>0||M>0))throw new i(g);var j=s[L],B=+s[L+1],z=+(s[L+2]||0);switch(j){case"+":E-=B,_-=z;break;case"-":E+=B,_+=z;break;case"Z":break;default:_+=new Date(Date.UTC(r,f-1,p,E,_)).getTimezoneOffset()}}var G=60===v;for(G&&v--;_>=60;)_-=60,E++;for(;E>=24;)E-=24,p++;for(a=u&&2===f?O:m[f-1];p>a;)p-=a,f++,f>12&&(f-=12,r++),a=u&&2===f?O:m[f-1];for(;0>_;)_+=60,E--;for(;0>E;)E+=24,p--;for(;1>p;)f--,1>f&&(f+=12,r--),a=u&&2===f?O:m[f-1],p+=a;var V=h(r,f,p,E,_,v,M);return n(t)?(d(V[0],V[1],t),l(t)):t=new y(V[0],V[1],c.UTC),G&&y.addSeconds(t,1,t),t},y.now=function(e){return y.fromDate(new Date,e)};var M=new y(0,0,c.TAI);return y.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,o=p(e,M);n(o)||(y.addSeconds(e,-1,M),o=p(M,M),r=!0);var u=o.dayNumber,c=o.secondsOfDay;c>=43200&&(u+=1);var f=u+68569|0,l=4*f/146097|0;f=f-((146097*l+3)/4|0)|0;var d=4e3*(f+1)/1461001|0;f=f-(1461*d/4|0)+31|0;var h=80*f/2447|0,E=f-(2447*h/80|0)|0;f=h/11|0;var m=h+2-12*f|0,O=100*(l-49)+d+f|0,_=c/s.SECONDS_PER_HOUR|0,T=c-_*s.SECONDS_PER_HOUR,R=T/s.SECONDS_PER_MINUTE|0;T-=R*s.SECONDS_PER_MINUTE;var w=0|T,A=(T-w)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(w+=1),n(t)?(t.year=O,t.month=m,t.day=E,t.hour=_,t.minute=R,t.second=w,t.millisecond=A,t.isLeapSecond=r,t):new a(O,m,E,_,R,w,A,r)},y.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=y.toGregorianDate(e,E),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},y.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var a=y.toGregorianDate(t,E),o=a.year,u=a.month,s=a.day,c=a.hour,f=a.minute,l=a.second,p=a.millisecond;1e4===o&&1===u&&1===s&&0===c&&0===f&&0===l&&0===p&&(o=9999,u=12,s=31,c=24);var d;return n(r)||0===p?n(r)&&0!==r?(d=(.01*p).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,u,s,c,f,l,d)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o,u,s,c,f,l):(d=(.01*p).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,u,s,c,f,l,d))},y.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new y(e.dayNumber,e.secondsOfDay,c.TAI):void 0},y.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},y.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},y.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(y.secondsDifference(e,t))<=r},y.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},y.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},y.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber,a=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+a},y.computeTaiMinusUtc=function(e){_.julianDate=e;var r=y.leapSeconds,n=t(r,_,f);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},y.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return d(e.dayNumber,e.secondsOfDay+t,r)},y.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,a,r)},y.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,a,r)},y.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");var a=e.dayNumber+t;return d(a,e.secondsOfDay,r)},y.lessThan=function(e,t){return y.compare(e,t)<0},y.lessThanOrEquals=function(e,t){return y.compare(e,t)<=0},y.greaterThan=function(e,t){return y.compare(e,t)>0},y.greaterThanOrEquals=function(e,t){return y.compare(e,t)>=0},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y.prototype.equalsEpsilon=function(e,t){return y.equalsEpsilon(this,e,t)},y.prototype.toString=function(){return y.toIso8601(this)},y.leapSeconds=[new u(new y(2441317,43210,c.TAI),10),new u(new y(2441499,43211,c.TAI),11),new u(new y(2441683,43212,c.TAI),12),new u(new y(2442048,43213,c.TAI),13),new u(new y(2442413,43214,c.TAI),14),new u(new y(2442778,43215,c.TAI),15),new u(new y(2443144,43216,c.TAI),16),new u(new y(2443509,43217,c.TAI),17),new u(new y(2443874,43218,c.TAI),18),new u(new y(2444239,43219,c.TAI),19),new u(new y(2444786,43220,c.TAI),20),new u(new y(2445151,43221,c.TAI),21),new u(new y(2445516,43222,c.TAI),22),new u(new y(2446247,43223,c.TAI),23),new u(new y(2447161,43224,c.TAI),24),new u(new y(2447892,43225,c.TAI),25),new u(new y(2448257,43226,c.TAI),26),new u(new y(2448804,43227,c.TAI),27),new u(new y(2449169,43228,c.TAI),28),new u(new y(2449534,43229,c.TAI),29),new u(new y(2450083,43230,c.TAI),30),new u(new y(2450630,43231,c.TAI),31),new u(new y(2451179,43232,c.TAI),32),new u(new y(2453736,43233,c.TAI),33),new u(new y(2454832,43234,c.TAI),34),new u(new y(2456109,43235,c.TAI),35),new u(new y(2457204,43236,c.TAI),36),new u(new y(2457754,43237,c.TAI),37)],y}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,i,a){a=e(a,!1);var o,u,s,c={},f=t(n),l=t(i);if(f)for(o in n)n.hasOwnProperty(o)&&(u=n[o],l&&a&&"object"==typeof u&&i.hasOwnProperty(o)?(s=i[o],"object"==typeof s?c[o]=r(u,s,a):c[o]=u):c[o]=u);if(l)for(o in i)i.hasOwnProperty(o)&&!c.hasOwnProperty(o)&&(s=i[o],c[o]=s);return c}return r}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,a,o){if(!r(i))throw new n("relative uri is required.");if(!r(a)){if("undefined"==typeof o)return i;a=t(o.baseURI,o.location.href)}var u=new e(a),s=new e(i);return s.resolve(u).toString()},i}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,i){if(!t(n))throw new r("uri is required.");var a="",o=n.lastIndexOf("/");return-1!==o&&(a=n.substring(0,o+1)),i?(n=new e(n),t(n.query)&&(a+="?"+n.query),t(n.fragment)&&(a+="#"+n.fragment),a):a}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var a=i.path,o=a.lastIndexOf("/");return-1!==o&&(a=a.substr(o+1)),o=a.lastIndexOf("."),a=-1===o?"":a.substr(o+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,i=r.protocol;return r.href=t,r.href=r.href,i!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^data:/i;return t}),define("Core/loadAndExecuteScript",["../ThirdParty/when"],function(e){"use strict";function t(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}return t}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("obj is required.");var i="";for(var a in n)if(n.hasOwnProperty(a)){var o=n[a],u=encodeURIComponent(a)+"=";if(r(o))for(var s=0,c=o.length;c>s;++s)i+=u+encodeURIComponent(o[s])+"&";else i+=u+encodeURIComponent(o)+"&"}return i=i.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var a=n.replace(/\+/g,"%20").split(/[&;]/),o=0,u=a.length;u>o;++o){var s=a[o].split("="),c=decodeURIComponent(s[0]),f=s[1];f=e(f)?decodeURIComponent(f):"";var l=i[c];"string"==typeof l?i[c]=[l,f]:r(l)?l.push(f):i[c]=f}return i}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";var t={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5};return e(t)}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";var t={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3,PACK_TERRAIN:4,PACK_IMAGERY:5};return e(t)}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),a=e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=a,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,a=-1,o=0;o<n.length;o++)if(n[o]===t&&i[o]===r){a=o;break}return-1!==a?(this._insideRaiseEvent?(this._toRemove.push(a),n[a]=void 0,i[a]=void 0):(n.splice(a,1),i.splice(a,1)),!0):!1},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,a=r.length;for(e=0;a>e;e++){var o=r[e];t(o)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if(a=u.length,a>0){for(u.sort(i),e=0;a>e;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function a(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,o=-1,u=!0;u;){var s=2*(e+1),c=s-1;o=r>c&&n(i[c],i[e])<0?c:e,r>s&&n(i[s],i[o])<0&&(o=s),o!==e?(a(i,o,e),e=o):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n=this._array,i=this._comparator,o=this._maximumLength,u=this._length++;for(u<n.length?n[u]=t:n.push(t);0!==u;){var s=Math.floor((u-1)/2);if(!(i(n[u],n[s])<0))break;a(n,u,s),u=s}var c;return r(o)&&this._length>o&&(c=n[o],this._length=o),c},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return a(n,r,--this._length),this.heapify(r),i}},i}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState","./RequestType"],function(e,t,r,n,i,a,o,u,s,c,f,l){"use strict";function p(e,t){return e.priority-t.priority}function d(){}function h(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function y(e){var t=n(d.requestsByServer[e],d.maximumRequestsPerServer);return C[e]<t}function E(e){var r=e.serverKey+"_"+e.providerName;if(i(d.packRequests[r])||(d.packRequests[r]=[]),!(d.packRequests[r].length>=D)){i(d.packRequestQuadKey[r])||(d.packRequestQuadKey[r]=[],d.quadKeyIndex[r]=0,d.totalPacketCount[r]=0,d.currentDeferIndex[r]=0),i(d.currentPacketCount[r])||(d.currentPacketCount[r]=0),i(d.packRequestPromise[r])||(d.packRequestPromise[r]=[t.defer()]),d.totalPacketCount[r]>=U&&(d.totalPacketCount[r]=0,d.currentDeferIndex[r]++,d.packRequestPromise[r].push(t.defer()));var n=d.currentDeferIndex[r];return e.deferred=d.packRequestPromise[r][n],e.state=f.ISSUED,d.packRequests[r].push(e),d.totalPacketCount[r]++,e.deferred.promise}}function m(){d.packRequests={},d.packRequestPromise={},d.packRequestQuadKey={},d.quadKeyIndex={},d.currentPacketCount={},d.totalPacketCount={},d.currentDeferIndex={}}function O(e){var t=e.serverKey+"_"+e.providerName,r=d.packRequestQuadKey[t],n=d.quadKeyIndex[t];i(r[n])?r[n]+=";"+e.quadKey:r[n]=e.quadKey,e.quadKeyIndex=d.currentPacketCount[t],++d.currentPacketCount[t],d.currentPacketCount[t]>=U&&(d.currentPacketCount[t]=0,d.quadKeyIndex[t]++)}function _(e,t){for(var r=U*t,n=0,i=e.length;i>n;n++)if(n>=r){var a=e[n];a.state=f.CANCELLED}}function T(){var t,r=d.packRequests;for(var n in r)if(r.hasOwnProperty(n)){t=void 0;for(var a=r[n],o=0,u=a.length;u>o;o++){var s=a[o];i(t)||(t=s),O(s)}var c;for(i(t)&&(c=t.url),o=0,u=d.packRequestQuadKey[n].length;u>o;o++){var f=d.packRequestQuadKey[n][o];if(-1===f.indexOf(";")&&(f+=";"+f),i(t)){if(t.throttleByServer&&!y(t.serverKey)){_(a,o),d.packRequestPromise[n][o].reject();continue}var l=t.clone();l.state=t.state,l.serverKey=t.serverKey,l.deferred=d.packRequestPromise[n][o],l.deferred.id=o;var p=new e(c);p.query=i(p.query)?p.query+"&extratiles="+f:"extratiles="+f,l.url=p.toString(),b(l,l.url)}}}m()}function R(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function w(e){return function(t){e.state!==f.CANCELLED&&(--I.numberOfActiveRequests,--C[e.serverKey],P.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}function A(e){return function(t){e.state!==f.CANCELLED&&(++I.numberOfFailedRequests,--I.numberOfActiveRequests,--C[e.serverKey],P.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}function b(e,t){var r=R(e);return e.state=f.ACTIVE,M.push(e),++I.numberOfActiveRequests,++I.numberOfActiveRequestsEver,++C[e.serverKey],e.requestFunction(t).then(w(e)).otherwise(A(e)),r}function v(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++I.numberOfCancelledRequests,e.deferred.reject(),t&&(--I.numberOfActiveRequests,--C[e.serverKey],++I.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}function S(){d.debugShowStatistics&&(0===I.numberOfActiveRequests&&I.lastNumberOfActiveRequests>0&&(I.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+I.numberOfAttemptedRequests),I.numberOfAttemptedRequests=0),I.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+I.numberOfCancelledRequests),I.numberOfCancelledRequests=0),I.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+I.numberOfCancelledActiveRequests),I.numberOfCancelledActiveRequests=0),I.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+I.numberOfFailedRequests),I.numberOfFailedRequests=0)),I.lastNumberOfActiveRequests=I.numberOfActiveRequests)}var I={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},N=20,g=new u({comparator:p});g.maximumLength=N,g.reserve(N);var M=[],C={},x="undefined"!=typeof document?new e(document.location.href):new e,P=new o;d.maximumRequests=50,d.maximumRequestsPerServer=6,d.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},d.throttleRequests=!0,d.debugShowStatistics=!1,d.requestCompletedEvent=P,a(d,{statistics:{get:function(){return I}},priorityHeapLength:{get:function(){return N},set:function(e){if(N>e)for(;g.length>e;){var t=g.pop();v(t)}N=e,g.maximumLength=e,g.reserve(e)}}});var U=20,D=120;return d.packRequests={},d.packRequestPromise={},d.packRequestQuadKey={},d.quadKeyIndex={},d.currentPacketCount={},d.totalPacketCount={},d.currentDeferIndex={},d.update=function(){var e,t,r=0,n=M.length;for(e=0;n>e;++e)t=M[e],t.cancelled&&v(t),t.state===f.ACTIVE?r>0&&(M[e-r]=t):++r;M.length-=r,T();var i=g.internalArray,a=g.length;for(e=0;a>e;++e)h(i[e]);g.resort();for(var o=Math.max(d.maximumRequests-M.length,0),u=0;o>u&&g.length>0;)t=g.pop(),t.cancelled?v(t):!t.throttleByServer||y(t.serverKey)?(b(t),++u):v(t);S()},d.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(x);n.normalize();var a=n.authority;/:/.test(a)||(a=a+":"+("https"===n.scheme?"443":"80"));var o=C[a];return i(o)||(C[a]=0),a},d.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return P.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++I.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=d.getServerKey(e.url)),e.type>l.OTHER)return E(e);if(!e.throttleByServer||y(e.serverKey)){if(!d.throttleRequests||!e.throttle)return b(e);if(!(M.length>=d.maximumRequests)){h(e);var t=g.insert(e);if(i(t)){if(t===e)return;v(t)}return R(e)}}},d.clearForSpecs=function(){for(;g.length>0;){var e=g.pop();v(e)}for(var t=M.length,r=0;t>r;++r)v(M[r]);M.length=0,C={},I.numberOfAttemptedRequests=0,I.numberOfActiveRequests=0,I.numberOfCancelledRequests=0,I.numberOfCancelledActiveRequests=0,I.numberOfFailedRequests=0,I.numberOfActiveRequestsEver=0,I.lastNumberOfActiveRequests=0},d.numberOfActiveRequestsByServer=function(e){return C[e]},d.requestHeap=g,d}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var a=i.split("@");i=a[1]}if(-1===i.indexOf(":")){var o=n.getScheme();if(t(o)||(o=window.location.protocol,o=o.substring(0,o.length-1)),"http"===o)i+=":80";else{if("https"!==o)return;i+=":443"}}return i}}var i={},a={};return i.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])||(a[i]=!0)},i.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])&&delete a[i]},i.contains=function(e){if(!t(e))throw new r("url is required.");var i=n(e);return t(i)&&t(a[i])?!0:!1},i.clear=function(){a={}},i}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y,E,m,O,_,T,R,w,A,b,v){"use strict";function S(e,t,r,n){var i=e.query;if(!u(i)||0===i.length)return{};var a;if(-1===i.indexOf("=")){var o={};o[i]=void 0,a=o}else a=_(i);r?t._queryParameters=M(a,t._queryParameters,n):t._queryParameters=a,e.query=void 0}function I(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=O(r):e.query=n[0]}function N(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function g(e){if(e.state===A.ISSUED||e.state===A.ACTIVE)throw new b("The Resource is already being fetched.");e.state=A.UNISSUED,e.deferred=void 0}function M(e,t,r){if(!r)return a(e,t);var n=i(e,!0);for(var o in t)if(t.hasOwnProperty(o)){var s=n[o],c=t[o];u(s)?(Array.isArray(s)||(s=n[o]=[s]),n[o]=s.concat(c)):n[o]=Array.isArray(c)?c.slice():c}return n}function C(t){t=o(t,o.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=N(t.templateValues,{}),this._queryParameters=N(t.queryParameters,{}),this.headers=N(t.headers,{}),this.request=o(t.request,new T),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=o(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);S(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function x(e){var r=e.resource,n=e.flipY,i=e.preferImageBitmap,a=r.request;a.url=r.url,a.requestFunction=function(){var e=r.url,a=!1;r.isDataUri||r.isBlobUri||(a=r.isCrossOriginUrl);var o=t.defer();return C._Implementations.createImage(e,a,o,n,i),o.promise};var o=w.request(a);return u(o)?o.otherwise(function(e){return a.state!==A.FAILED?t.reject(e):r.retryOnError(e).then(function(o){return o?(a.state=A.UNISSUED,a.deferred=void 0,x({resource:r,flipY:n,preferImageBitmap:i})):t.reject(e)})}):void 0}function P(e,r,n){var i={};i[r]=n,e.setQueryParameters(i);var a=e.request;a.url=e.url,a.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(t){window[n]=void 0}},C._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var o=w.request(a);return u(o)?o.otherwise(function(i){return a.state!==A.FAILED?t.reject(i):e.retryOnError(i).then(function(o){return o?(a.state=A.UNISSUED,a.deferred=void 0,P(e,r,n)):t.reject(i)})}):void 0}function U(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function D(e,t){for(var r=U(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),a=0;a<r.length;a++)i[a]=r.charCodeAt(a);return n}function q(e,t){t=o(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return U(n,i);case"arraybuffer":return D(n,i);case"blob":var a=D(n,i);return new Blob([a],{type:r});case"document":var u=new DOMParser;return u.parseFromString(U(n,i),r);case"json":return JSON.parse(U(n,i));default:throw new c("Unhandled responseType: "+t)}}function F(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(v.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e}function L(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function j(e,t,r,n,i,a,o){var u=global.require,s=u("url").parse(e),c=u("https:"===s.protocol?"https":"http"),f=u("zlib"),l={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:r,headers:i};c.request(l).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void a.reject(new R(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?f.gunzip(n,function(e,r){e?a.reject(new b("Error decompressing response.")):a.resolve(L(r,t))}):a.resolve(L(n,t))})}).on("error",function(e){a.reject(new R)}).end()}var B=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();C.createIfNeeded=function(e){return e instanceof C?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new C({url:e})};var z;C.supportsImageBitmapOptions=function(){if(u(z))return z;if("function"!=typeof createImageBitmap)return z=t.resolve(!1);var e="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg==";return z=C.fetchBlob({url:e}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},s(C,{isBlobSupported:{get:function(){return B}}}),s(C.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);S(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return d(this._url)}},isDataUri:{get:function(){return E(this._url)}},isBlobUri:{get:function(){return h(this._url)}},isCrossOriginUrl:{get:function(){return y(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),C.prototype.getUrlComponent=function(t,r){
if(this.isDataUri)return this._url;var n=new e(this._url);t&&I(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues;return i=i.replace(/{(.*?)}/g,function(e,t){var r=a[t];return u(r)?encodeURIComponent(r):e}),r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},C.prototype.setQueryParameters=function(e,t){t?this._queryParameters=M(this._queryParameters,e,!1):this._queryParameters=M(e,this._queryParameters,!1)},C.prototype.appendQueryParameters=function(e){this._queryParameters=M(e,this._queryParameters,!0)},C.prototype.setTemplateValues=function(e,t){t?this._templateValues=a(this._templateValues,e):this._templateValues=a(e,this._templateValues)},C.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url),i=o(t.preserveQueryParameters,!1);S(n,r,!0,i),n.fragment=void 0,r._url=n.resolve(new e(l(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=a(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=a(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=a(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},C.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},C.prototype.clone=function(e){return u(e)||(e=new C({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},C.prototype.getBaseUri=function(e){return p(this.getUrlComponent(e),e)},C.prototype.appendForwardSlash=function(){this._url=r(this._url)},C.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},C.fetchArrayBuffer=function(e){var t=new C(e);return t.fetchArrayBuffer()},C.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},C.fetchBlob=function(e){var t=new C(e);return t.fetchBlob()},C.prototype.fetchImage=function(e){e=o(e,o.EMPTY_OBJECT);var r=o(e.preferImageBitmap,!1),n=o(e.preferBlob,!1),i=o(e.flipY,!1);if(g(this.request),!B||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return x({resource:this,flipY:i,preferImageBitmap:r});var a=this.fetchBlob();if(u(a)){var s,c,f,l;return C.supportsImageBitmapOptions().then(function(e){return s=e,c=s&&r,a}).then(function(e){if(u(e)){if(l=e,c)return C.createImageBitmapFromBlob(e,{flipY:i,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return f=new C({url:t}),x({resource:f,flipY:i,preferImageBitmap:!1})}}).then(function(e){return u(e)?(e.blob=l,c?e:(window.URL.revokeObjectURL(f.url),e)):void 0}).otherwise(function(e){return u(f)&&window.URL.revokeObjectURL(f.url),e.blob=l,t.reject(e)})}},C.fetchImage=function(e){var t=new C(e);return t.fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},C.prototype.fetchText=function(){return this.fetch({responseType:"text"})},C.fetchText=function(e){var t=new C(e);return t.fetchText()},C.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then(function(e){return u(e)?JSON.parse(e):void 0})},C.fetchJson=function(e){var t=new C(e);return t.fetchJson()},C.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},C.fetchXML=function(e){var t=new C(e);return t.fetchXML()},C.prototype.fetchJsonp=function(e){e=o(e,"callback"),g(this.request);var t;do t="loadJsonp"+Math.random().toString().substring(2,8);while(u(window[t]));return P(this,e,t)},C.fetchJsonp=function(e){var t=new C(e);return t.fetchJsonp(e.callbackParameterName)},C.prototype._makeRequest=function(e){var r=this;g(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(i){var o=e.responseType,s=a(e.headers,r.headers),c=e.overrideMimeType,f=e.method,l=e.data,p=t.defer(),d=u(i)?i:r.url,h=C._Implementations.loadWithXhr(d,o,f,l,s,p,c);return u(h)&&u(h.abort)&&(n.cancelFunction=function(){h.abort()}),p.promise};var i=w.request(n);return u(i)?i.then(function(e){return e}).otherwise(function(i){return n.state!==A.FAILED?t.reject(i):r.retryOnError(i).then(function(a){return a?(n.state=A.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)})}):void 0};var G=/^data:(.*?)(;base64)?,(.*)$/;C.prototype.fetch=function(e){return e=N(e,{}),e.method="GET",this._makeRequest(e)},C.fetch=function(e){var t=new C(e);return t.fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype["delete"]=function(e){return e=N(e,{}),e.method="DELETE",this._makeRequest(e)},C["delete"]=function(e){var t=new C(e);return t["delete"]({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},C.prototype.head=function(e){return e=N(e,{}),e.method="HEAD",this._makeRequest(e)},C.head=function(e){var t=new C(e);return t.head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.options=function(e){return e=N(e,{}),e.method="OPTIONS",this._makeRequest(e)},C.options=function(e){var t=new C(e);return t.options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.post=function(e,t){return n.defined("data",e),t=N(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},C.post=function(e){var t=new C(e);return t.post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.put=function(e,t){return n.defined("data",e),t=N(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},C.put=function(e){var t=new C(e);return t.put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.patch=function(e,t){return n.defined("data",e),t=N(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},C.patch=function(e){var t=new C(e);return t.patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C._Implementations={},C._Implementations.createImage=function(e,t,r,n,i){C.supportsImageBitmapOptions().then(function(n){return n&&i?C.fetchBlob({url:e}):void F(e,t,r)}).then(function(e){return u(e)?C.createImageBitmapFromBlob(e,{flipY:n,premultiplyAlpha:!1}):void 0}).then(function(e){u(e)&&r.resolve(e)}).otherwise(r.reject)},C.createImageBitmapFromBlob=function(e,t){return n.defined("options",t),n.typeOf.bool("options.flipY",t.flipY),n.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var V="undefined"==typeof XMLHttpRequest;return C._Implementations.loadWithXhr=function(e,t,r,n,i,a,o){var s=G.exec(e);if(null!==s)return void a.resolve(q(s,t));if(V)return void j(e,t,r,n,i,a,o);var c=new XMLHttpRequest;if(v.contains(e)&&(c.withCredentials=!0),e=e.replace(/{/g,"%7B").replace(/}/g,"%7D"),c.open(r,e,!0),u(o)&&u(c.overrideMimeType)&&c.overrideMimeType(o),u(i))for(var f in i)i.hasOwnProperty(f)&&c.setRequestHeader(f,i[f]);u(t)&&(c.responseType=t);var l=!1;return"string"==typeof e&&(l=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!l||0!==c.status))return void a.reject(new R(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var i=c.getAllResponseHeaders(),o=i.trim().split(/[\r\n]+/),s={};return o.forEach(function(e){var t=e.split(": "),r=t.shift();s[r]=t.join(": ")}),void a.resolve(s)}if(204===c.status)a.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{a.resolve(JSON.parse(e))}catch(f){a.reject(f)}else(""===n||"document"===n)&&u(c.responseXML)&&c.responseXML.hasChildNodes()?a.resolve(c.responseXML):""!==n&&"text"!==n||!u(c.responseText)?a.reject(new b("Invalid XMLHttpRequest response type.")):a.resolve(c.responseText);else a.resolve(e)},c.onerror=function(e){a.reject(new R)},c.send(n),c},C._Implementations.loadAndExecuteScript=function(e,t,r){return m(e,t).otherwise(r.reject)},C._DefaultImplementations={},C._DefaultImplementations.createImage=C._Implementations.createImage,C._DefaultImplementations.loadWithXhr=C._Implementations.loadWithXhr,C._DefaultImplementations.loadAndExecuteScript=C._Implementations.loadAndExecuteScript,C.DEFAULT=f(new C({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),C}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c,f,l){"use strict";function p(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))h(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),a=this;this._downloadPromise=e(i.fetchJson(),function(e){h(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."})}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function h(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),p=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),h=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>c||0>p||0>h||0>y)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var E=e._samples=r.samples,m=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=p,e._yCelestialPoleOffsetRadiansColumn=h,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var O,_=e._addNewLeapSeconds,T=0,R=E.length;R>T;T+=e._columnCount){var w=E[T+i],A=E[T+y],b=w+f.MODIFIED_JULIAN_DATE_DIFFERENCE,v=new o(b,A,l.TAI);if(m.push(v),_){if(A!==O&&n(O)){var S=o.leapSeconds,I=t(S,v,d);if(0>I){var N=new u(v,A);S.splice(~I,0,N)}}O=A}}}function y(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function E(e,t,r){return t+e*(r-t)}function m(e,t,r,n,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],f=t[a];if(c.equals(f)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(f))return y(e,r,a,s,u),u;var l=o.secondsDifference(n,c)/o.secondsDifference(f,c),p=i*s,d=a*s,h=r[p+e._ut1MinusUtcSecondsColumn],m=r[d+e._ut1MinusUtcSecondsColumn],O=m-h;if(O>.5||-.5>O){var _=r[p+e._taiMinusUtcSecondsColumn],T=r[d+e._taiMinusUtcSecondsColumn];_!==T&&(f.equals(n)?h=m:m-=T-_)}return u.xPoleWander=E(l,r[p+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=E(l,r[p+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=E(l,r[p+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=E(l,r[p+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=E(l,h,m),u}return p.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,u=this._lastIndex,s=0,f=0;if(n(u)){var l=a[u],p=a[u+1],d=o.lessThanOrEquals(l,e),h=!n(p),y=h||o.greaterThanOrEquals(p,e);if(d&&y)return s=u,!h&&p.equals(e)&&++s,f=s+1,m(this,a,this._samples,e,s,f,r),r}var E=t(a,e,o.compare,this._dateColumn);return E>=0?(E<a.length-1&&a[E+1].equals(e)&&++E,s=E,f=E):(f=~E,s=f-1,0>s&&(s=0)),this._lastIndex=s,m(this,a,this._samples,e,s,f,r),r}if(n(this._dataError))throw new c(this._dataError)},p}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var a=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,o),n.pitch=-Math.asin(a),n},i.fromDegrees=function(e,a,o,u){if(!t(e))throw new r("heading is required");if(!t(a))throw new r("pitch is required");if(!t(o))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=a*n.RADIANS_PER_DEGREE,u.roll=o*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){return t(e)?t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,a){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,a)&&n.equalsEpsilon(e.pitch,r.pitch,i,a)&&n.equalsEpsilon(e.roll,r.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],function(e,t,r,n,i){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),i=h.exec(n);if(null!==i)return i[1]}}function o(t){return"undefined"==typeof document?t:(e(l)||(l=document.createElement("a")),l.href=t,l.href=l.href,l.href)}function u(){if(e(p))return p;var u;if(u="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",f("Core/buildModuleUrl.js")):a(),!e(u))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return p=new n({url:o(u)}),p.appendForwardSlash(),p}function s(e){return o(i.toUrl("../"+e))}function c(e){var t=u().getDerivedResource({url:e});return t.url}function f(t){e(d)||(d=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?s:c);var r=d(t);return r}var l,p,d,h=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return f._cesiumScriptRegex=h,f._buildModuleUrlFromBaseUrl=c,f._clearBaseResource=function(){p=void 0},f.setBaseUrl=function(e){p=n.DEFAULT.getDerivedResource({url:e})},f.getCesiumBaseUrl=u,f}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,i,a,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=o.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;t>=c;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var f=0;t>=f;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=l;return n.dayNumber=t,n.secondsOfDay=r,a.daysDifference(n,e._sampleZeroDateTT)}function f(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var a=e.defer();r._chunkDownloadsInProgress[i]=a;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.getDerivedResource({templateValues:{0:i}}):new o({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(u.fetchJson(),function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,o=i*r._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)t[o+u]=n[u];a.resolve()}),a.promise}var l=new a(0,0,u.TAI);return s.prototype.preload=function(t,r,n,i){var a=c(this,t,r),o=c(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var l=u/this._samplesPerXysFile|0,p=s/this._samplesPerXysFile|0,d=[],h=l;p>=h;++h)d.push(f(this,h));return e.all(d)},s.prototype.computeXysRadians=function(e,t,r){var a=c(this,e,t);if(!(0>a)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);0>s&&(s=0);var l=s+u;l>=this._totalSamples&&(l=this._totalSamples-1,s=l-u,0>s&&(s=0));var p=!1,d=this._samples;if(n(d[3*s])||(f(this,s/this._samplesPerXysFile|0),p=!0),n(d[3*l])||(f(this,l/this._samplesPerXysFile|0),p=!0),!p){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var h,y,E=a-s*this._stepSizeDays,m=this._work,O=this._denominators,_=this._coef,T=this._xTable;for(h=0;u>=h;++h)m[h]=E-T[h];for(h=0;u>=h;++h){for(_[h]=1,y=0;u>=y;++y)y!==h&&(_[h]*=m[y]);_[h]*=O[h];var R=3*(s+h);r.x+=_[h]*d[R++],r.y+=_[h]*d[R++],r.s+=_[h]*d[R]}return r}}}},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y,E,m,O,_,T){"use strict";var R={},w={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},A={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},b={},v={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},S=new r,I=new r,N=new r;R.localFrameToFixedFrameGenerator=function(e,t){if(!w.hasOwnProperty(e)||!w[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=w[e][t],a=e+t;return u(b[a])?n=b[a]:(n=function(n,a,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),E.equalsEpsilon(n.x,0,E.EPSILON14)&&E.equalsEpsilon(n.y,0,E.EPSILON14)){var f=E.sign(n.z);r.unpack(A[e],0,S),"east"!==e&&"west"!==e&&r.multiplyByScalar(S,f,S),r.unpack(A[t],0,I),"east"!==t&&"west"!==t&&r.multiplyByScalar(I,f,I),r.unpack(A[i],0,N),"east"!==i&&"west"!==i&&r.multiplyByScalar(N,f,N)}else{a=o(a,l.WGS84),a.geodeticSurfaceNormal(n,v.up);var p=v.up,d=v.east;d.x=-n.y,d.y=n.x,d.z=0,r.normalize(d,v.east),r.cross(p,d,v.north),r.multiplyByScalar(v.up,-1,v.down),r.multiplyByScalar(v.east,-1,v.west),r.multiplyByScalar(v.north,-1,v.south),S=v[e],I=v[t],N=v[i]}return c[0]=S.x,c[1]=S.y,c[2]=S.z,c[3]=0,c[4]=I.x,c[5]=I.y,c[6]=I.z,c[7]=0,c[8]=N.x,c[9]=N.y,c[10]=N.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},b[a]=n),n},R.eastNorthUpToFixedFrame=R.localFrameToFixedFrameGenerator("east","north"),R.northEastDownToFixedFrame=R.localFrameToFixedFrameGenerator("north","east"),R.northUpEastToFixedFrame=R.localFrameToFixedFrameGenerator("north","up"),R.northWestUpToFixedFrame=R.localFrameToFixedFrameGenerator("north","west");var g=new _,M=new r(1,1,1),C=new O;R.headingPitchRollToFixedFrame=function(e,t,n,i,u){a.typeOf.object("HeadingPitchRoll",t),i=o(i,R.eastNorthUpToFixedFrame);var s=_.fromHeadingPitchRoll(t,g),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,M,C);return u=i(e,n,u),O.multiply(u,c,u)};var x=new O,P=new m;R.headingPitchRollQuaternion=function(e,t,r,n,i){a.typeOf.object("HeadingPitchRoll",t);var o=R.headingPitchRollToFixedFrame(e,t,r,n,x),u=O.getRotation(o,P);return _.fromRotationMatrix(u,i)};var U=new r(1,1,1),D=new r,q=new O,F=new O,L=new m,j=new _;R.fixedFrameToHeadingPitchRoll=function(e,t,n,i){a.defined("transform",e),t=o(t,l.WGS84),n=o(n,R.eastNorthUpToFixedFrame),u(i)||(i=new p);var s=O.getTranslation(e,D);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=O.inverseTransformation(n(s,t,q),q),f=O.setScale(e,U,F);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var d=_.fromRotationMatrix(O.getRotation(c,L),j);return d=_.normalize(d,d),p.fromQuaternion(d,i)};var B=24110.54841,z=8640184.812866,G=.093104,V=-62e-7,X=1.1772758384668e-19,W=72921158553e-15,k=E.TWO_PI/86400,H=new y;R.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");H=y.addSeconds(e,-y.computeTaiMinusUtc(e),H);var r,n=H.dayNumber,i=H.secondsOfDay,a=n-2451545;r=i>=43200?(a+.5)/T.DAYS_PER_JULIAN_CENTURY:(a-.5)/T.DAYS_PER_JULIAN_CENTURY;var o=B+r*(z+r*(G+r*V)),c=o*k%E.TWO_PI,f=W+X*(n-2451545.5),l=(i+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY,p=c+f*l,d=Math.cos(p),h=Math.sin(p);return u(t)?(t[0]=d,t[1]=-h,t[2]=0,t[3]=h,t[4]=d,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new m(d,h,0,-h,d,0,0,0,1)},R.iau2006XysData=new d,R.earthOrientationParameters=c.NONE;var Y=32.184,K=2451545;R.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+Y,i=t.stop.dayNumber,a=t.stop.secondsOfDay+Y,o=R.iau2006XysData.preload(r,n,i,a),u=R.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},R.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new m);var r=R.computeFixedToIcrfMatrix(e,t);if(u(r))return m.transpose(r,t)};var Z=new h(0,0,0),J=new f(0,0,0,0,0,0),Q=new m,$=new m;R.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new m);var r=R.earthOrientationParameters.compute(e,J);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+Y,a=R.iau2006XysData.computeXysRadians(n,i,Z);if(u(a)){var o=a.x+r.xPoleOffset,c=a.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-o*o-c*c)),l=Q;l[0]=1-f*o*o,l[3]=-f*o*c,l[6]=o,l[1]=-f*o*c,l[4]=1-f*c*c,l[7]=c,l[2]=-o,l[5]=-c,l[8]=1-f*(o*o+c*c);var p=m.fromRotationZ(-a.s,$),d=m.multiply(l,p,Q),h=e.dayNumber,O=e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc,_=h-2451545,w=O/T.SECONDS_PER_DAY,A=.779057273264+w+.00273781191135448*(_+w);A=A%1*E.TWO_PI;var b=m.fromRotationZ(A,$),v=m.multiply(d,b,Q),S=Math.cos(r.xPoleWander),I=Math.cos(r.yPoleWander),N=Math.sin(r.xPoleWander),g=Math.sin(r.yPoleWander),M=n-K+i/T.SECONDS_PER_DAY;M/=36525;var C=-47e-6*M*E.RADIANS_PER_DEGREE/3600,x=Math.cos(C),P=Math.sin(C),U=$;return U[0]=S*x,U[1]=S*P,U[2]=N,U[3]=-I*P+g*N*x,U[4]=I*x+g*N*P,U[5]=-g*S,U[6]=-g*P-I*N*x,U[7]=g*x-I*N*P,U[8]=I*S,m.multiply(v,U,t)}}};var ee=new n;R.pointToWindowCoordinates=function(e,t,r,n){return n=R.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},R.pointToGLWindowCoordinates=function(e,r,i,a){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(a)||(a=new t);var o=ee;return O.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,o),o),n.multiplyByScalar(o,1/o.w,o),O.multiplyByVector(r,o,o),t.fromCartesian4(o,a)};var te=new r,re=new r,ne=new r;R.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var a=o(n,l.WGS84).geodeticSurfaceNormal(e,te),c=r.cross(t,a,re);r.equalsEpsilon(c,r.ZERO,E.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,ne);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new m),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=f.x,i[7]=f.y,i[8]=f.z,i};var ie=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),ae=new i,oe=new r,ue=new r,se=new m,ce=new O,fe=new O;return R.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=O.getTranslation(t,ue),a=e.ellipsoid,o=a.cartesianToCartographic(i,ae),c=e.project(o,oe);r.fromElements(c.z,c.x,c.y,c);var f=R.eastNorthUpToFixedFrame(i,a,ce),l=O.inverseTransformation(f,fe),p=O.getRotation(t,se),d=O.multiplyByMatrix3(l,p,n);return O.multiply(ie,d,n),O.setTranslation(n,c,n),n},R.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,a=R.eastNorthUpToFixedFrame(t,i,ce),o=O.inverseTransformation(a,fe),c=i.cartesianToCartographic(t,ae),f=e.project(c,oe);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,ce);return O.multiply(ie,o,n),O.multiply(l,n,n),n},R.buildUp=function(e,t){var n=t.clone(),i=e.clone();i=r.normalize(i,i),Math.abs(r.dot(i,n))>=1&&(i=Math.abs(r.dot(n,r.UNIT_Y))<1?r.clone(r.UNIT_Y,i):r.clone(r.UNIT_Z,i));var a=new r;return r.cross(i,n,a),a=r.normalize(a,a),r.cross(n,a,i),i=r.normalize(i,i)},R.getHeading=function(e,t){var r;return r=E.equalsEpsilon(Math.abs(e.z),1,E.EPSILON3)?Math.atan2(t.y,t.x)-E.PI_OVER_TWO:Math.atan2(e.y,e.x)-E.PI_OVER_TWO,E.TWO_PI-E.zeroToTwoPi(r)},R}),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y){"use strict";function E(e){e=i(e,i.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=i(e.primitiveType,p.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=i(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}E.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&a(e.attributes[r])&&a(e.attributes[r].values)){var i=e.attributes[r],u=i.values.length/i.componentsPerAttribute;if(t!==u&&-1!==t)throw new o("All attribute lists must have the same number of attributes.");t=u}return t};var m=new r,O=new t,_=new l,T=[new r,new r,new r],R=[new e,new e,new e],w=[new e,new e,new e],A=new t,b=new d,v=new l,S=new c;return E._textureCoordinateRotationPoints=function(n,i,a,o){var u,s=h.center(o,m),p=r.toCartesian(s,a,O),E=y.eastNorthUpToFixedFrame(p,a,_),I=l.inverse(E,_),N=R,g=T;g[0].longitude=o.west,g[0].latitude=o.south,g[1].longitude=o.west,g[1].latitude=o.north,g[2].longitude=o.east,g[2].latitude=o.south;var M=A;for(u=0;3>u;u++)r.toCartesian(g[u],a,M),M=l.multiplyByPointAsVector(I,M,M),N[u].x=M.x,N[u].y=M.y;var C=d.fromAxisAngle(t.UNIT_Z,-i,b),x=f.fromQuaternion(C,v),P=n.length,U=Number.POSITIVE_INFINITY,D=Number.POSITIVE_INFINITY,q=Number.NEGATIVE_INFINITY,F=Number.NEGATIVE_INFINITY;for(u=0;P>u;u++)M=l.multiplyByPointAsVector(I,n[u],M),M=f.multiplyByVector(x,M,M),U=Math.min(U,M.x),D=Math.min(D,M.y),q=Math.max(q,M.x),F=Math.max(F,M.y);var L=c.fromRotation(i,S),j=w;j[0].x=U,j[0].y=D,j[1].x=U,j[1].y=F,j[2].x=q,j[2].y=D;var B=N[0],z=N[2].x-B.x,G=N[1].y-B.y;for(u=0;3>u;u++){var V=j[u];c.multiplyByVector(L,V,V),V.x=(V.x-B.x)/z,V.y=(V.y-B.y)/G}var X=j[0],W=j[1],k=j[2],H=new Array(6);return e.pack(X,H),e.pack(W,H,2),e.pack(k,H,4),H},E}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.fromSizeInBytes=function(e){switch(e){case 2:return a.UNSIGNED_SHORT;case 4:return a.UNSIGNED_INT;case 1:return a.UNSIGNED_BYTE;default:throw new t("Size in bytes cannot be mapped to an IndexDatatype")}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},a.createTypedArrayFromArrayBuffer=function(r,i,a,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)},r(a)}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({
position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,a){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");return a=e(a,0),i[a++]=n.position?1:0,i[a++]=n.normal?1:0,i[a++]=n.st?1:0,i[a++]=n.tangent?1:0,i[a++]=n.bitangent?1:0,i[a]=n.color?1:0,i},i.unpack=function(n,a,o){if(!t(n))throw new r("array is required");return a=e(a,0),t(o)||(o=new i),o.position=1===n[a++],o.normal=1===n[a++],o.st=1===n[a++],o.tangent=1===n[a++],o.bitangent=1===n[a++],o.color=1===n[a],o},i.clone=function(e,r){return t(e)?(t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r):void 0},i}),define("Core/EllipsoidGeometry",["./arrayFill","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryOffsetAttribute","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y,E){"use strict";function m(e){e=a(e,a.EMPTY_OBJECT);var t=a(e.radii,A),r=Math.round(a(e.stackPartitions,64)),i=Math.round(a(e.slicePartitions,64)),s=a(e.vertexFormat,E.DEFAULT);if(3>i)throw new u("options.slicePartitions cannot be less than three.");if(3>r)throw new u("options.stackPartitions cannot be less than three.");if(o(e.offsetAttribute)&&e.offsetAttribute===p.TOP)throw new u("GeometryOffsetAttribute.TOP is not a supported options.offsetAttribute for this geometry.");this._radii=n.clone(t),this._stackPartitions=r,this._slicePartitions=i,this._vertexFormat=E.clone(s),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidGeometry"}var O=new n,_=new n,T=new n,R=new n,w=new n,A=new n(1,1,1),b=Math.cos,v=Math.sin;m.packedLength=n.packedLength+E.packedLength+3,m.pack=function(e,t,r){if(!o(e))throw new u("value is required");if(!o(t))throw new u("array is required");return r=a(r,0),n.pack(e._radii,t,r),r+=n.packedLength,E.pack(e._vertexFormat,t,r),r+=E.packedLength,t[r++]=e._stackPartitions,t[r++]=e._slicePartitions,t[r]=a(e._offsetAttribute,-1),t};var S=new n,I=new E,N={radii:S,vertexFormat:I,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0};m.unpack=function(e,t,r){if(!o(e))throw new u("array is required");t=a(t,0);var i=n.unpack(e,t,S);t+=n.packedLength;var s=E.unpack(e,t,I);t+=E.packedLength;var c=e[t++],f=e[t++],l=e[t];return o(r)?(r._radii=n.clone(i,r._radii),r._vertexFormat=E.clone(s,r._vertexFormat),r._stackPartitions=c,r._slicePartitions=f,r._offsetAttribute=-1===l?void 0:l,r):(N.stackPartitions=c,N.slicePartitions=f,N.offsetAttribute=-1===l?void 0:l,new m(N))},m.createGeometry=function(a){var u=a._radii;if(!(u.x<=0||u.y<=0||u.z<=0)){var E,m,A=s.fromCartesian3(u),S=a._vertexFormat,I=a._slicePartitions+1,N=a._stackPartitions+1,g=N*I,M=new Float64Array(3*g),C=6*(I-1)*(N-2),x=d.createTypedArray(g,C),P=S.normal?new Float32Array(3*g):void 0,U=S.tangent?new Float32Array(3*g):void 0,D=S.bitangent?new Float32Array(3*g):void 0,q=S.st?new Float32Array(2*g):void 0,F=new Array(I),L=new Array(I),j=0;for(E=0;I>E;E++){var B=h.TWO_PI*E/(I-1);F[E]=b(B),L[E]=v(B),M[j++]=0,M[j++]=0,M[j++]=u.z}for(E=1;N-1>E;E++){var z=Math.PI*E/(N-1),G=v(z),V=u.x*G,X=u.y*G,W=u.z*b(z);for(m=0;I>m;m++)M[j++]=F[m]*V,M[j++]=L[m]*X,M[j++]=W}for(E=0;I>E;E++)M[j++]=0,M[j++]=0,M[j++]=-u.z;var k=new l;S.position&&(k.position=new f({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:M}));var H=0,Y=0,K=0,Z=0;if(S.st||S.normal||S.tangent||S.bitangent){for(E=0;g>E;E++){var J=n.fromArray(M,3*E,O),Q=A.geodeticSurfaceNormal(J,_);if(S.st){var $=r.negate(Q,w);r.magnitude($)<h.EPSILON6&&(j=3*(E+I*Math.floor(.5*N)),j>M.length&&(j=3*(E-I*Math.floor(.5*N))),n.fromArray(M,j,$),A.geodeticSurfaceNormal($,$),r.negate($,$)),q[H++]=Math.atan2($.y,$.x)/h.TWO_PI+.5,q[H++]=Math.asin(Q.z)/Math.PI+.5}if(S.normal&&(P[Y++]=Q.x,P[Y++]=Q.y,P[Y++]=Q.z),S.tangent||S.bitangent){var ee=T;if(I>E||E>g-I-1?(n.cross(n.UNIT_X,Q,ee),n.normalize(ee,ee)):(n.cross(n.UNIT_Z,Q,ee),n.normalize(ee,ee)),S.tangent&&(U[K++]=ee.x,U[K++]=ee.y,U[K++]=ee.z),S.bitangent){var te=n.cross(Q,ee,R);n.normalize(te,te),D[Z++]=te.x,D[Z++]=te.y,D[Z++]=te.z}}}S.st&&(k.st=new f({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:q})),S.normal&&(k.normal=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:P})),S.tangent&&(k.tangent=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:U})),S.bitangent&&(k.bitangent=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:D}))}if(o(a._offsetAttribute)){var re=M.length,ne=new Uint8Array(re/3),ie=a._offsetAttribute===p.NONE?0:1;e(ne,ie),k.applyOffset=new f({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:1,values:ne})}for(j=0,m=0;I-1>m;m++)x[j++]=I+m,x[j++]=I+m+1,x[j++]=m+1;var ae,oe;for(E=1;N-2>E;E++)for(ae=E*I,oe=(E+1)*I,m=0;I-1>m;m++)x[j++]=oe+m,x[j++]=oe+m+1,x[j++]=ae+m+1,x[j++]=oe+m,x[j++]=ae+m+1,x[j++]=ae+m;for(E=N-2,ae=E*I,oe=(E+1)*I,m=0;I-1>m;m++)x[j++]=oe+m,x[j++]=ae+m+1,x[j++]=ae+m;return new c({attributes:k,indices:x,primitiveType:y.TRIANGLES,boundingSphere:t.fromEllipsoid(A),offsetAttribute:a._offsetAttribute})}};var g;return m.getUnitEllipsoid=function(){return o(g)||(g=m.createGeometry(new m({radii:new n(1,1,1),vertexFormat:E.POSITION_ONLY}))),g},m}),define("Core/SphereGeometry",["./Cartesian3","./Check","./defaultValue","./defined","./EllipsoidGeometry","./VertexFormat"],function(e,t,r,n,i,a){"use strict";function o(t){var n=r(t.radius,1),a=new e(n,n,n),o={radii:a,stackPartitions:t.stackPartitions,slicePartitions:t.slicePartitions,vertexFormat:t.vertexFormat};this._ellipsoidGeometry=new i(o),this._workerName="createSphereGeometry"}o.packedLength=i.packedLength,o.pack=function(e,r,n){return t.typeOf.object("value",e),i.pack(e._ellipsoidGeometry,r,n)};var u=new i,s={radius:void 0,radii:new e,vertexFormat:new a,stackPartitions:void 0,slicePartitions:void 0};return o.unpack=function(t,r,c){var f=i.unpack(t,r,u);return s.vertexFormat=a.clone(f._vertexFormat,s.vertexFormat),s.stackPartitions=f._stackPartitions,s.slicePartitions=f._slicePartitions,n(c)?(e.clone(f._radii,s.radii),c._ellipsoidGeometry=new i(s),c):(s.radius=f._radii.x,new o(s))},o.createGeometry=function(e){return i.createGeometry(e._ellipsoidGeometry)},o}),define("Workers/createSphereGeometry",["../Core/defined","../Core/SphereGeometry"],function(e,t){"use strict";return function(r,n){return e(n)&&(r=t.unpack(r,n)),t.createGeometry(r)}})}();