/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(n,i){if(!e(i))throw new t(r(n))},i.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},i.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},i.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},i.typeOf.number.lessThan=function(e,r,n){if(i.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},i.typeOf.number.lessThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},i.typeOf.number.greaterThan=function(e,r,n){if(i.typeOf.number(e,r),n>=r)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},i.typeOf.number.greaterThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),n>r)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},i.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},i.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},i.typeOf.number.equals=function(e,r,n,a){if(i.typeOf.number(e,n),i.typeOf.number(r,a),n!==a)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+a)},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,i){"use strict";var a={};a.Radius=6378137,a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.EPSILON21=1e-21,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),a.signNotZero=function(e){return 0>e?-1:1},a.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*a.clamp(e,-1,1)+.5)*t)},a.fromSNorm=function(e,t){return t=r(t,255),a.clamp(e,0,t)/t*2-1},a.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),a.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},a.equalsEpsilon=function(e,t,a,o){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(a))throw new i("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-t);return o>=u||u<=a*Math.max(Math.abs(e),Math.abs(t))},a.lessThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return-r>e-t},a.lessThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return r>e-t},a.greaterThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>r},a.greaterThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>-r};var o=[1];a.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var t=o.length;if(e>=t)for(var r=o[t-1],n=t;e>=n;n++)o.push(r*n);return o[e]},a.incrementWrap=function(e,t,a){if(a=r(a,0),!n(e))throw new i("n is required.");if(a>=t)throw new i("maximumValue must be greater than minimumValue.");return++e,e>t&&(e=a),e},a.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return t>e?t:e>r?r:e};var u=new e;return a.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},a.nextRandomNumber=function(){return u.random()},a.randomBetween=function(e,t){return a.nextRandomNumber()*(t-e)+e},a.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},a.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return 0>e?-t:t}),a.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),a.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},a.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},a.fastApproximateAtan2=function(e,r){t.typeOf.number("x",e),t.typeOf.number("y",r);var n,o,u=Math.abs(e);n=Math.abs(r),o=Math.max(u,n),n=Math.min(u,n);var s=n/o;if(isNaN(s))throw new i("either x or y must be nonzero");return u=a.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?a.PI_OVER_TWO-u:u,u=0>e?a.PI-u:u,u=0>r?-u:u},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;i>a;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;a>u;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l);var n=o.dot(c,l),i=o.magnitude(o.cross(c,l,c));return Math.atan2(i,n)};var f=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=o.dot(t,r)/o.dot(r,r);return o.multiplyByScalar(r,i,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,l=a*c-o*s,f=o*u-i*c,h=i*s-a*u;return n.x=l,n.y=f,n.z=h,n},o.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var h=new o,p=new o,d=new o(40680631590769,40680631590769,40408299984661.445),y=new o(40680631590769,40680631590769,40680631590769);return o.fromRadians=function(n,i,u,s,c){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),u=t(u,0);var l=r(s)?s.radiiSquared:y;a.equalsEpsilon(a.Radius,6356752.314245179,a.EPSILON10)&&(l=r(s)?s.radiiSquared:d);var f=Math.cos(i);h.x=f*Math.cos(n),h.y=f*Math.sin(n),h.z=Math.sin(i),h=o.normalize(h,h),o.multiplyComponents(l,h,p);var m=Math.sqrt(o.dot(h,p));return p=o.divideByScalar(p,m,p),h=o.multiplyByScalar(h,u,h),r(c)||(c=new o),o.add(p,h,c)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromDegrees(c,l,0,i,a[f])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromRadians(c,l,0,i,a[f])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],l=t[s+1],f=t[s+2],h=s/3;a[h]=o.fromDegrees(c,l,f,i,a[h])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],l=t[s+1],f=t[s+2],h=s/3;a[h]=o.fromRadians(c,l,f,i,a[h])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(i,u,s,c,l){if(!t(i))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var f=i.x,h=i.y,p=i.z,d=u.x,y=u.y,m=u.z,E=f*f*d*d,v=h*h*y*y,O=p*p*m*m,w=E+v+O,g=Math.sqrt(1/w),_=e.multiplyByScalar(i,g,a);if(c>w)return isFinite(g)?e.clone(_,l):void 0;var T=s.x,b=s.y,R=s.z,A=o;A.x=_.x*T*2,A.y=_.y*b*2,A.z=_.z*R*2;var S,x,N,I,M,P,C,D,q,U,L,F=(1-g)*e.magnitude(i)/(.5*e.magnitude(A)),B=0;do{F-=B,N=1/(1+F*T),I=1/(1+F*b),M=1/(1+F*R),P=N*N,C=I*I,D=M*M,q=P*N,U=C*I,L=D*M,S=E*P+v*C+O*D-1,x=E*q*T+v*U*b+O*L*R;var j=-2*x;B=S/j}while(Math.abs(S)>n.EPSILON12);return t(l)?(l.x=f*N,l.y=h*I,l.z=p*M,l):new e(f*N,h*I,p*M)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,a,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),a=r(a,0),n(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=a.toRadians(e),r=a.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),h=new e(1/6378137,1/6378137,1/6378137),p=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=new e(1/40680631590769,1/40680631590769,1/40680631590769),y=a.EPSILON1;return u.fromCartesian=function(t,r,i){var m=n(r)?r.oneOverRadii:h,E=n(r)?r.oneOverRadiiSquared:d,v=n(r)?r._centerToleranceSquared:y;a.equalsEpsilon(a.Radius,6356752.314245179,a.EPSILON10)&&(m=n(r)?r.oneOverRadii:f,E=n(r)?r.oneOverRadiiSquared:p);var O=o(t,m,E,v,c);if(n(O)){var w=e.multiplyComponents(O,E,s);w=e.normalize(w,w);var g=e.subtract(t,O,l),_=Math.atan2(w.y,w.x),T=Math.asin(w.z),b=a.sign(e.dot(g,t))*e.magnitude(g);return n(i)?(i.longitude=_,i.latitude=T,i.height=b,i):new u(_,T,b)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.sphericalDistance=function(e,r,n,i){if(t.defined("longitudeA",e),t.defined("longitudeB",n),t.defined("latitudeA",r),t.defined("latitudeB",i),e===n&&r===i)return 0;var o=a.toRadians(r),u=a.toRadians(i),s=a.toRadians(e),c=a.toRadians(n),l=s*s+o*o,f=c*c+u*u,h=(s-c)*(s-c)+(o-u)*(o-u),p=(l+f-h)/(2*Math.sqrt(l)*Math.sqrt(f));return p=a.clamp(p,-1,1),Math.acos(p)*a.Radius},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(t,i,a,o){i=n(i,0),a=n(a,0),o=n(o,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",a,0),r.typeOf.number.greaterThanOrEquals("z",o,0),s.equalsEpsilon(o,6356752.314245179,s.EPSILON10)&&(s.Radius=o),t._radii=new e(i,a,o),t._radiiSquared=new e(i*i,a*a,o*o),t._radiiToTheFourth=new e(i*i*i*i,a*a*a*a,o*o*o*o),t._oneOverRadii=new e(0===i?0:1/i,0===a?0:1/a,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===a?0:1/(a*a),0===o?0:1/(o*o)),t._minimumRadius=Math.min(i,a,o),t._maximumRadius=Math.max(i,a,o),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function f(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,l(this,e,t,r)}a(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new f(n.x,n.y,n.z)}},f.fromCartesian3=function(e,t){return i(t)||(t=new f),i(e)?(l(t,e.x,e.y,e.z),t):t},f.WGS84=u(new f(6378137,6378137,s.Radius)),f.UNIT_SPHERE=u(new f(1,1,1)),f.MOON=u(new f(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(t,i,a){return r.typeOf.object("value",t),r.defined("array",i),a=n(a,0),e.pack(t._radii,i,a),i},f.unpack=function(t,i,a){r.defined("array",t),i=n(i,0);var o=e.unpack(t,i);return f.fromCartesian3(o,a)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var a=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(a),c=u*Math.sin(a),l=Math.sin(o);return i(n)||(n=new e),n.x=s,n.y=c,n.z=l,e.normalize(n,n)},f.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var h=new e,p=new e;f.prototype.cartographicToCartesian=function(t,r){var n=h,a=p;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,a);var o=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(a,n,r)},f.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;n>a;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var d=new e,y=new e,m=new e;return f.prototype.cartesianToCartographic=function(r,n){var a=this.scaleToGeodeticSurface(r,y);if(i(a)){var o=this.geodeticSurfaceNormal(a,d),u=e.subtract(r,a,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=l,n.height=f,n):new t(c,l,f)}},f.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;n>a;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},f.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},f.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var a=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(a*a*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},f.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},f.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},f.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},f.prototype.toString=function(){return this._radii.toString()},f.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new o("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),a=n(a,0);var c=this._squaredXOverSquaredZ;return i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),Math.abs(u.z)>=this._radii.z-a?void 0:u},f}),define("Core/arrayRemoveDuplicates",["./Check","./defaultValue","./defined","./Math"],function(e,t,r,n){"use strict";function i(n,i,o){if(e.defined("equalsEpsilon",i),r(n)){o=t(o,!1);var u=n.length;if(2>u)return n;var s,c,l;for(s=1;u>s&&(c=n[s-1],l=n[s],!i(c,l,a));++s);if(s===u)return o&&i(n[0],n[n.length-1],a)?n.slice(1):n;for(var f=n.slice(0,s);u>s;++s)l=n[s],i(c,l,a)||(f.push(l),c=l);return o&&f.length>1&&i(f[0],f[f.length-1],a)&&f.shift(),f}}var a=n.EPSILON10;return i}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;i>a;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;i>a;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l),a.acosClamped(o.dot(c,l))};var f=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";
function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,h=0,p=e.length;p>h;h++){var d=e[h];i=Math.min(i,d.longitude),a=Math.max(a,d.longitude),l=Math.min(l,d.latitude),f=Math.max(f,d.latitude);var y=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;o=Math.min(o,y),c=Math.max(c,y)}return a-i>c-o&&(i=o,a=c,a>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=l,r.east=a,r.north=f,r):new s(i,l,a,f)},s.fromCartesianArray=function(e,i,o){t.defined("cartesians",e),i=r(i,a.WGS84);for(var c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=Number.MAX_VALUE,h=-Number.MAX_VALUE,p=Number.MAX_VALUE,d=-Number.MAX_VALUE,y=0,m=e.length;m>y;y++){var E=i.cartesianToCartographic(e[y]);c=Math.min(c,E.longitude),l=Math.max(l,E.longitude),p=Math.min(p,E.latitude),d=Math.max(d,E.latitude);var v=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;f=Math.min(f,v),h=Math.max(h,v)}return l-c>h-f&&(c=f,l=h,l>u.PI&&(l-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(o)?(o.west=c,o.south=p,o.east=l,o.north=d,o):new s(c,p,l,d)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;o>a&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,l=r.west;o>a&&c>0?a+=u.TWO_PI:l>c&&a>0&&(c+=u.TWO_PI),o>a&&0>l?l+=u.TWO_PI:l>c&&0>o&&(o+=u.TWO_PI);var f=u.negativePiToPi(Math.max(o,l)),h=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&f>=h)){var p=Math.max(e.south,r.south),d=Math.min(e.north,r.north);if(!(p>=d))return n(i)?(i.west=f,i.south=p,i.east=h,i.north=d,i):new s(f,p,h,d)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);return o>=c||a>=u?void 0:n(i)?(i.west=a,i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,l=r.west;o>a&&c>0?a+=u.TWO_PI:l>c&&a>0&&(c+=u.TWO_PI),o>a&&0>l?l+=u.TWO_PI:l>c&&0>o&&(o+=u.TWO_PI);var f=u.convertLongitudeRange(Math.min(o,l)),h=u.convertLongitudeRange(Math.max(a,c));return i.west=f,i.south=Math.min(e.south,r.south),i.east=h,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return a>o&&(o+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(o>n||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,l){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(l)||(l=[]);var f=0,h=e.north,p=e.south,d=e.east,y=e.west,m=c;m.height=o,m.longitude=y,m.latitude=h,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=d,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.latitude=p,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,0>h?m.latitude=h:p>0?m.latitude=p:m.latitude=0;for(var E=1;8>E;++E)m.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,m)&&(l[f]=i.cartographicToCartesian(m,l[f]),f++);return 0===m.latitude&&(m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=d,l[f]=i.cartographicToCartesian(m,l[f]),f++),l.length=f,l},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./Check","./defaultValue","./defined","./GeographicProjection","./Intersect","./Rectangle"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,r,i){this.x=n(e,0),this.y=n(t,0),this.width=n(r,0),this.height=n(i,0)}s.packedLength=4,s.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.width,t[i]=e.height,t},s.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new s),a.x=e[t++],a.y=e[t++],a.width=e[t++],a.height=e[t],a},s.fromPoints=function(e,t){if(i(t)||(t=new s),!i(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var r=e.length,n=e[0].x,a=e[0].y,o=e[0].x,u=e[0].y,c=1;r>c;c++){var l=e[c],f=l.x,h=l.y;n=Math.min(f,n),o=Math.max(f,o),a=Math.min(h,a),u=Math.max(h,u)}return t.x=n,t.y=a,t.width=o-n,t.height=u-a,t};var c=new a,l=new t,f=new t;return s.fromRectangle=function(t,r,a){if(i(a)||(a=new s),!i(t))return a.x=0,a.y=0,a.width=0,a.height=0,a;r=n(r,c);var o=r.project(u.southwest(t,l)),h=r.project(u.northeast(t,f));return e.subtract(h,o,h),a.x=o.x,a.y=o.y,a.width=h.x,a.height=h.y,a},s.clone=function(e,t){return i(e)?i(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new s(e.x,e.y,e.width,e.height):void 0},s.union=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),i(n)||(n=new s);var a=Math.min(e.x,t.x),o=Math.min(e.y,t.y),u=Math.max(e.x+e.width,t.x+t.width),c=Math.max(e.y+e.height,t.y+t.height);return n.x=a,n.y=o,n.width=u-a,n.height=c-o,n},s.expand=function(e,t,n){r.typeOf.object("rectangle",e),r.typeOf.object("point",t),n=s.clone(e,n);var i=t.x-n.x,a=t.y-n.y;return i>n.width?n.width=i:0>i&&(n.width-=i,n.x=t.x),a>n.height?n.height=a:0>a&&(n.height-=a,n.y=t.y),n},s.intersect=function(e,t){r.typeOf.object("left",e),r.typeOf.object("right",t);var n=e.x,i=e.y,a=t.x,u=t.y;return n>a+t.width||n+e.width<a||i+e.height<u||i>u+t.height?o.OUTSIDE:o.INTERSECTING},s.equals=function(e,t){return e===t||i(e)&&i(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function l(e){for(var t=0,r=0;3>r;++r){var n=e[s.getElementIndex(y[r],d[r])];t+=2*n*n}return Math.sqrt(t)}function f(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;3>a;++a){var o=Math.abs(e[s.getElementIndex(y[a],d[a])]);o>n&&(i=a,n=o)}var c=1,l=0,f=d[i],h=y[i];if(Math.abs(e[s.getElementIndex(h,f)])>r){var p,m=e[s.getElementIndex(h,h)],E=e[s.getElementIndex(f,f)],v=e[s.getElementIndex(h,f)],O=(m-E)/2/v;p=0>O?-1/(-O+Math.sqrt(1+O*O)):1/(O+Math.sqrt(1+O*O)),c=1/Math.sqrt(1+p*p),l=p*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(f,f)]=t[s.getElementIndex(h,h)]=c,t[s.getElementIndex(h,f)]=l,t[s.getElementIndex(f,h)]=-l,t}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,l=e.y*e.z,f=e.y*e.w,h=e.z*e.z,p=e.z*e.w,d=e.w*e.w,y=i-c-h+d,m=2*(a-p),E=2*(o+f),v=2*(a+p),O=-i+c-h+d,w=2*(l-u),g=2*(o-f),_=2*(l+u),T=-i-c+h+d;return n(r)?(r[0]=y,r[1]=v,r[2]=g,r[3]=m,r[4]=O,r[5]=_,r[6]=E,r[7]=w,r[8]=T,r):new s(y,m,E,v,O,w,g,_,T)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),l=Math.sin(e.roll),f=i*a,h=-o*c+l*u*a,p=l*c+o*u*a,d=i*c,y=o*a+l*u*c,m=-l*a+o*u*c,E=-u,v=l*i,O=o*i;return n(r)?(r[0]=f,r[1]=d,r[2]=E,r[3]=h,r[4]=y,r[5]=v,r[6]=p,r[7]=m,r[8]=O,r):new s(f,h,p,d,y,m,E,v,O)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i);var a=3*r;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i),i[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var h=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],h)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],h)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],h)),n};var p=new e;s.getMaximumScale=function(t){return s.getScale(t,p),e.maximumComponent(p)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],f=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],h=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=l,n[7]=f,n[8]=h,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],l=e[5],f=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r};var d=[1,0,0],y=[2,2,1],m=new s,E=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=10,o=0,h=0;n(r)||(r={});for(var p=r.unitary=s.clone(s.IDENTITY,r.unitary),d=r.diagonal=s.clone(e,r.diagonal),y=i*c(d);a>h&&l(d)>y;)f(d,m),s.transpose(m,E),s.multiply(d,m,d),s.multiply(E,d,d),s.multiply(p,m,p),++o>2&&(++h,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return r*(o*l-c*u)+a*(c*i-n*l)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],l=e[4],f=e[5],h=e[6],p=e[7],d=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=l*d-p*f,r[1]=p*o-i*d,r[2]=i*f-l*o,r[3]=h*f-c*d,r[4]=n*d-h*o,r[5]=c*o-n*f,r[6]=c*p-h*l,r[7]=h*i-n*p,r[8]=n*l-c*i;var m=1/y;return s.multiplyByScalar(r,m,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;i>a;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;i>a;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var l=new Float32Array(1),f=256,h=65536,p=16777216,d=1/f,y=1/h,m=1/p,E=38;return o.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new o),l[0]=t,t=l[0],0===t)return o.clone(o.ZERO,n);var i,u=0>t?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(a.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=E);var s=t*f;return n.x=Math.floor(s),s=(s-n.x)*f,n.y=Math.floor(s),s=(s-n.y)*f,n.z=Math.floor(s),n.w=2*(i+E)+u,n},o.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(n-=E,i=2*i-1,i=-i,n>=E)return 0>i?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=i*t.x*d;return a+=i*t.y*y,a+=i*t.z*m,a*Math.pow(10,n)},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t,r,i,a,o,u,s,c,l,f,h,p,d,y,m){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(p,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(d,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(h,0),this[15]=n(m,0)}l.packedLength=16,l.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},l.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new l),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},l.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return r.defined("values",e),l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new l(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new l);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,f=t.x*t.y,h=t.x*t.z,p=t.x*t.w,d=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,v=t.z*t.w,O=t.w*t.w,w=c-d-E+O,g=2*(f-v),_=2*(h+m),T=2*(f+v),b=-c+d-E+O,R=2*(y-p),A=2*(h-m),S=2*(y+p),x=-c-d+E+O;return a[0]=w*o,a[1]=T*o,a[2]=A*o,a[3]=0,a[4]=g*u,a[5]=b*u,a[6]=S*u,a[7]=0,a[8]=_*s,a[9]=R*s,a[10]=x*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},l.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return r.typeOf.object("translation",e),l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,h=new e,p=new e;l.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,f),e.normalize(e.cross(f,u,h),h),e.normalize(e.cross(h,f,p),p);var s=h.x,c=h.y,d=h.z,y=f.x,m=f.y,E=f.z,v=p.x,O=p.y,w=p.z,g=a.x,_=a.y,T=a.z,b=s*-g+c*-_+d*-T,R=v*-g+O*-_+w*-T,A=y*g+m*_+E*T;return i(n)?(n[0]=s,n[1]=v,n[2]=-y,n[3]=0,n[4]=c,n[5]=O,n[6]=-m,n[7]=0,n[8]=d,n[9]=w,n[10]=-E,n[11]=0,n[12]=b,n[13]=R,n[14]=A,n[15]=1,n):new l(s,c,d,b,v,O,w,R,-y,-m,-E,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=Math.tan(.5*e),u=1/o,s=u/t,c=(i+n)/(n-i),l=2*i*n/(n-i);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},l.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),l=1/(o-a),f=-(t+e)*s,h=-(i+n)*c,p=-(o+a)*l;return s*=2,c*=2,l*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=f,u[13]=h,u[14]=p,u[15]=1,u},l.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),l=(t+e)/(t-e),f=(i+n)/(i-n),h=-(o+a)/(o-a),p=-1,d=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=f,u[10]=h,u[11]=p,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},l.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),l=(i+n)/(i-n),f=-1,h=-1,p=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=p,o[15]=0,o},l.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),i=n(i,1);var l=.5*s,f=.5*c,h=.5*(i-t),p=l,d=f,y=h,m=o+l,E=u+f,v=t+h,O=1;return a[0]=p,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,
a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=m,a[13]=E,a[14]=v,a[15]=O,a},l.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},l.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},l.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},l.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=l.clone(e,i);var a=4*t;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},l.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var d=new e;l.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var a=l.getScale(t,d),o=e.divideComponents(n,a,d);return l.multiplyByScale(t,o,i)},l.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},l.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=l.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var y=new e;l.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var m=new e;l.getMaximumScale=function(t){return l.getScale(t,m),e.maximumComponent(m)},l.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],l=e[6],f=e[7],h=e[8],p=e[9],d=e[10],y=e[11],m=e[12],E=e[13],v=e[14],O=e[15],w=t[0],g=t[1],_=t[2],T=t[3],b=t[4],R=t[5],A=t[6],S=t[7],x=t[8],N=t[9],I=t[10],M=t[11],P=t[12],C=t[13],D=t[14],q=t[15],U=i*w+s*g+h*_+m*T,L=a*w+c*g+p*_+E*T,F=o*w+l*g+d*_+v*T,B=u*w+f*g+y*_+O*T,j=i*b+s*R+h*A+m*S,z=a*b+c*R+p*A+E*S,G=o*b+l*R+d*A+v*S,V=u*b+f*R+y*A+O*S,W=i*x+s*N+h*I+m*M,k=a*x+c*N+p*I+E*M,X=o*x+l*N+d*I+v*M,H=u*x+f*N+y*I+O*M,Y=i*P+s*C+h*D+m*q,Z=a*P+c*C+p*D+E*q,K=o*P+l*C+d*D+v*q,J=u*P+f*C+y*D+O*q;return n[0]=U,n[1]=L,n[2]=F,n[3]=B,n[4]=j,n[5]=z,n[6]=G,n[7]=V,n[8]=W,n[9]=k,n[10]=X,n[11]=H,n[12]=Y,n[13]=Z,n[14]=K,n[15]=J,n},l.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},l.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},l.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],h=e[10],p=e[12],d=e[13],y=e[14],m=t[0],E=t[1],v=t[2],O=t[4],w=t[5],g=t[6],_=t[8],T=t[9],b=t[10],R=t[12],A=t[13],S=t[14],x=i*m+u*E+l*v,N=a*m+s*E+f*v,I=o*m+c*E+h*v,M=i*O+u*w+l*g,P=a*O+s*w+f*g,C=o*O+c*w+h*g,D=i*_+u*T+l*b,q=a*_+s*T+f*b,U=o*_+c*T+h*b,L=i*R+u*A+l*S+p,F=a*R+s*A+f*S+d,B=o*R+c*A+h*S+y;return n[0]=x,n[1]=N,n[2]=I,n[3]=0,n[4]=M,n[5]=P,n[6]=C,n[7]=0,n[8]=D,n[9]=q,n[10]=U,n[11]=0,n[12]=L,n[13]=F,n[14]=B,n[15]=1,n},l.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],h=e[10],p=t[0],d=t[1],y=t[2],m=t[3],E=t[4],v=t[5],O=t[6],w=t[7],g=t[8],_=i*p+u*d+l*y,T=a*p+s*d+f*y,b=o*p+c*d+h*y,R=i*m+u*E+l*v,A=a*m+s*E+f*v,S=o*m+c*E+h*v,x=i*O+u*w+l*g,N=a*O+s*w+f*g,I=o*O+c*w+h*g;return n[0]=_,n[1]=T,n[2]=b,n[3]=0,n[4]=R,n[5]=A,n[6]=S,n[7]=0,n[8]=x,n[9]=N,n[10]=I,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},l.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;l.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,l.multiplyByScale(e,E,n)},l.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?l.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},l.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,l=e[2]*i+e[6]*a+e[10]*o+e[14]*u,f=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=l,n.w=f,n},l.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},l.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},l.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},l.multiplyByPlane=function(n,i,a){r.typeOf.object("matrix",n),r.typeOf.object("plane",i),r.typeOf.object("result",a);var o=new l,u=new l;l.inverse(n,o),l.transpose(o,u);var s=new t(i.normal.x,i.normal.y,i.normal.z,i.distance);l.multiplyByVector(u,s,s),a.normal.x=s.x,a.normal.y=s.y,a.normal.z=s.z;var c=e.magnitude(a.normal);return e.normalize(a.normal,a.normal),a.distance=s.w/c,a},l.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},l.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},l.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var v=new s,O=new s,w=new t,g=new t(0,0,0,1);return l.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],a=e[4],o=e[8],f=e[12],h=e[1],p=e[5],d=e[9],y=e[13],m=e[2],E=e[6],_=e[10],T=e[14],b=e[3],R=e[7],A=e[11],S=e[15],x=_*S,N=T*A,I=E*S,M=T*R,P=E*A,C=_*R,D=m*S,q=T*b,U=m*A,L=_*b,F=m*R,B=E*b,j=x*p+M*d+P*y-(N*p+I*d+C*y),z=N*h+D*d+L*y-(x*h+q*d+U*y),G=I*h+q*p+F*y-(M*h+D*p+B*y),V=C*h+U*p+B*d-(P*h+L*p+F*d),W=N*a+I*o+C*f-(x*a+M*o+P*f),k=x*i+q*o+U*f-(N*i+D*o+L*f),X=M*i+D*a+B*f-(I*i+q*a+F*f),H=P*i+L*a+F*o-(C*i+U*a+B*o);x=o*y,N=f*d,I=a*y,M=f*p,P=a*d,C=o*p,D=i*y,q=f*h,U=i*d,L=o*h,F=i*p,B=a*h;var Y=x*R+M*A+P*S-(N*R+I*A+C*S),Z=N*b+D*A+L*S-(x*b+q*A+U*S),K=I*b+q*R+F*S-(M*b+D*R+B*S),J=C*b+U*R+B*A-(P*b+L*R+F*A),Q=I*_+C*T+N*E-(P*T+x*E+M*_),$=U*T+x*m+q*_-(D*_+L*T+N*m),ee=D*E+B*T+M*m-(F*T+I*m+q*E),te=F*_+P*m+L*E-(U*E+B*_+C*m),re=i*j+a*z+o*G+f*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(l.getRotation(e,v),O,u.EPSILON7)&&t.equals(l.getRow(e,3,w),g))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=j*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=W*re,n[5]=k*re,n[6]=X*re,n[7]=H*re,n[8]=Y*re,n[9]=Z*re,n[10]=K*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},l.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],p=e[13],d=e[14],y=-n*h-i*p-a*d,m=-o*h-u*p-s*d,E=-c*h-l*p-f*d;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=l,t[7]=0,t[8]=a,t[9]=s,t[10]=f,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,a(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,l,f,h){"use strict";function p(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var d=new e,y=new e,m=new e,E=new e,v=new e,O=new e,w=new e,g=new e,_=new e,T=new e,b=new e,R=new e,A=4/3*c.PI;p.fromPoints=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,a=e.clone(t[0],w),o=e.clone(a,d),u=e.clone(a,y),s=e.clone(a,m),c=e.clone(a,E),l=e.clone(a,v),f=e.clone(a,O),h=t.length;for(n=1;h>n;n++){e.clone(t[n],a);var A=a.x,S=a.y,x=a.z;A<o.x&&e.clone(a,o),A>c.x&&e.clone(a,c),S<u.y&&e.clone(a,u),S>l.y&&e.clone(a,l),x<s.z&&e.clone(a,s),x>f.z&&e.clone(a,f)}var N=e.magnitudeSquared(e.subtract(c,o,g)),I=e.magnitudeSquared(e.subtract(l,u,g)),M=e.magnitudeSquared(e.subtract(f,s,g)),P=o,C=c,D=N;I>D&&(D=I,P=u,C=l),M>D&&(D=M,P=s,C=f);var q=_;q.x=.5*(P.x+C.x),q.y=.5*(P.y+C.y),q.z=.5*(P.z+C.z);var U=e.magnitudeSquared(e.subtract(C,q,g)),L=Math.sqrt(U),F=T;F.x=o.x,F.y=u.y,F.z=s.z;var B=b;B.x=c.x,B.y=l.y,B.z=f.z;var j=e.midpoint(F,B,R),z=0;for(n=0;h>n;n++){e.clone(t[n],a);var G=e.magnitude(e.subtract(a,j,g));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(a,q,g));if(V>U){var W=Math.sqrt(V);L=.5*(L+W),U=L*L;var k=W-L;q.x=(L*q.x+k*a.x)/W,q.y=(L*q.y+k*a.y)/W,q.z=(L*q.z+k*a.z)/W}}return z>L?(e.clone(q,r.center),r.radius=L):(e.clone(j,r.center),r.radius=z),r};var S=new o,x=new e,N=new e,I=new t,M=new t;p.fromRectangle2D=function(e,t,r){return p.fromRectangleWithHeights2D(e,t,0,0,r)},p.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new p),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,S),h.southwest(t,I),I.height=a,h.northeast(t,M),M.height=o;var s=r.project(I,x),c=r.project(M,N),l=c.x-s.x,f=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+d*d);var y=u.center;return y.x=s.x+.5*l,y.y=s.y+.5*f,y.z=s.z+.5*d,u};var P=[];p.fromRectangle3D=function(t,r,o,u){if(r=n(r,a.WGS84),o=n(o,0),i(u)||(u=new p),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=h.subsample(t,r,o,P);return p.fromPoints(s,u)},p.fromVertices=function(t,a,o,u){if(i(u)||(u=new p),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=w;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;var c,l=e.clone(s,d),f=e.clone(s,y),h=e.clone(s,m),A=e.clone(s,E),S=e.clone(s,v),x=e.clone(s,O),N=t.length;for(c=0;N>c;c+=o){var I=t[c]+a.x,M=t[c+1]+a.y,P=t[c+2]+a.z;s.x=I,s.y=M,s.z=P,I<l.x&&e.clone(s,l),I>A.x&&e.clone(s,A),M<f.y&&e.clone(s,f),M>S.y&&e.clone(s,S),P<h.z&&e.clone(s,h),P>x.z&&e.clone(s,x)}var C=e.magnitudeSquared(e.subtract(A,l,g)),D=e.magnitudeSquared(e.subtract(S,f,g)),q=e.magnitudeSquared(e.subtract(x,h,g)),U=l,L=A,F=C;D>F&&(F=D,U=f,L=S),q>F&&(F=q,U=h,L=x);var B=_;B.x=.5*(U.x+L.x),B.y=.5*(U.y+L.y),B.z=.5*(U.z+L.z);var j=e.magnitudeSquared(e.subtract(L,B,g)),z=Math.sqrt(j),G=T;G.x=l.x,G.y=f.y,G.z=h.z;var V=b;V.x=A.x,V.y=S.y,V.z=x.z;var W=e.midpoint(G,V,R),k=0;for(c=0;N>c;c+=o){s.x=t[c]+a.x,s.y=t[c+1]+a.y,s.z=t[c+2]+a.z;var X=e.magnitude(e.subtract(s,W,g));X>k&&(k=X);var H=e.magnitudeSquared(e.subtract(s,B,g));if(H>j){var Y=Math.sqrt(H);z=.5*(z+Y),j=z*z;var Z=Y-z;B.x=(z*B.x+Z*s.x)/Y,B.y=(z*B.y+Z*s.y)/Y,B.z=(z*B.z+Z*s.z)/Y}}return k>z?(e.clone(B,u.center),u.radius=z):(e.clone(W,u.center),u.radius=k),u},p.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new p),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=w;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];var o,u=e.clone(a,d),s=e.clone(a,y),c=e.clone(a,m),l=e.clone(a,E),f=e.clone(a,v),h=e.clone(a,O),A=t.length;for(o=0;A>o;o+=3){var S=t[o]+r[o],x=t[o+1]+r[o+1],N=t[o+2]+r[o+2];a.x=S,a.y=x,a.z=N,S<u.x&&e.clone(a,u),S>l.x&&e.clone(a,l),x<s.y&&e.clone(a,s),x>f.y&&e.clone(a,f),N<c.z&&e.clone(a,c),N>h.z&&e.clone(a,h)}var I=e.magnitudeSquared(e.subtract(l,u,g)),M=e.magnitudeSquared(e.subtract(f,s,g)),P=e.magnitudeSquared(e.subtract(h,c,g)),C=u,D=l,q=I;M>q&&(q=M,C=s,D=f),P>q&&(q=P,C=c,D=h);var U=_;U.x=.5*(C.x+D.x),U.y=.5*(C.y+D.y),U.z=.5*(C.z+D.z);var L=e.magnitudeSquared(e.subtract(D,U,g)),F=Math.sqrt(L),B=T;B.x=u.x,B.y=s.y,B.z=c.z;var j=b;j.x=l.x,j.y=f.y,j.z=h.z;var z=e.midpoint(B,j,R),G=0;for(o=0;A>o;o+=3){a.x=t[o]+r[o],a.y=t[o+1]+r[o+1],a.z=t[o+2]+r[o+2];var V=e.magnitude(e.subtract(a,z,g));V>G&&(G=V);var W=e.magnitudeSquared(e.subtract(a,U,g));if(W>L){var k=Math.sqrt(W);F=.5*(F+k),L=F*F;var X=k-F;U.x=(F*U.x+X*a.x)/k,U.y=(F*U.y+X*a.y)/k,U.z=(F*U.z+X*a.z)/k}}return G>F?(e.clone(U,n.center),n.radius=F):(e.clone(z,n.center),n.radius=G),n},p.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new p);var o=e.midpoint(t,n,a.center);return a.radius=e.distance(o,n),a},p.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new p),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var C=new e;p.fromBoundingSpheres=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return p.clone(t[0],r);if(2===n)return p.union(t[0],t[1],r);var a,o=[];for(a=0;n>a;a++)o.push(t[a].center);r=p.fromPoints(o,r);var u=r.center,s=r.radius;for(a=0;n>a;a++){var c=t[a];s=Math.max(s,e.distance(u,c.center,C)+c.radius)}return r.radius=s,r};var D=new e,q=new e,U=new e;p.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new p);var a=t.halfAxes,o=l.getColumn(a,0,D),u=l.getColumn(a,1,q),s=l.getColumn(a,2,U);return e.add(o,u,o),e.add(o,s,o),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(o),n},p.clone=function(t,r){return i(t)?i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new p(t.center,t.radius):void 0},p.packedLength=4,p.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},p.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new p);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var L=new e,F=new e;p.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new p);var o=t.center,u=t.radius,s=n.center,c=n.radius,l=e.subtract(s,o,L),f=e.magnitude(l);if(u>=f+c)return t.clone(a),a;if(c>=f+u)return n.clone(a),a;var h=.5*(u+f+c),d=e.multiplyByScalar(l,(-u+h)/f,F);return e.add(d,o,d),e.clone(d,a.center),a.radius=h,a};var B=new e;p.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=p.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,B));return a>i.radius&&(i.radius=a),i},p.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return-a>s?u.OUTSIDE:a>s?u.INTERSECTING:u.INSIDE},p.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new p),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=f.getMaximumScale(t)*e.radius,n};var j=new e;p.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,j);return e.magnitudeSquared(i)-t.radius*t.radius},p.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new p),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;p.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,z),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var G=new e,V=new e,W=new e,k=new e,X=new e,H=new t,Y=new Array(8),Z=0;8>Z;++Z)Y[Z]=new e;var K=new o;return p.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t),i=n(i,K);var o=i.ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,G),l=e.cross(e.UNIT_Z,c,V);e.normalize(l,l);var f=e.cross(c,l,W);e.normalize(f,f),e.multiplyByScalar(c,s,c),e.multiplyByScalar(f,s,f),e.multiplyByScalar(l,s,l);var h=e.negate(f,X),d=e.negate(l,k),y=Y,m=y[0];e.add(c,f,m),e.add(m,l,m),m=y[1],e.add(c,f,m),e.add(m,d,m),m=y[2],e.add(c,h,m),e.add(m,d,m),m=y[3],e.add(c,h,m),e.add(m,l,m),e.negate(c,c),m=y[4],e.add(c,f,m),e.add(m,l,m),m=y[5],e.add(c,f,m),e.add(m,d,m),m=y[6],e.add(c,h,m),e.add(m,d,m),m=y[7],e.add(c,h,m),e.add(m,l,m);for(var E=y.length,v=0;E>v;++v){var O=y[v];e.add(u,O,O);var w=o.cartesianToCartographic(O,H);i.project(w,O)}a=p.fromPoints(y,a),u=a.center;var g=u.x,_=u.y,T=u.z;return u.x=T,u.y=g,u.z=_,a},p.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},p.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},p.prototype.intersectPlane=function(e){return p.intersectPlane(this,e)},p.prototype.distanceSquaredTo=function(e){return p.distanceSquaredTo(this,e)},p.prototype.computePlaneDistances=function(e,t,r){return p.computePlaneDistances(this,e,t,r)},p.prototype.isOccluded=function(e){return p.isOccluded(this,e)},p.prototype.equals=function(e){return p.equals(this,e)},p.prototype.clone=function(e){return p.clone(this,e)},p.prototype.volume=function(){var e=this.radius;return A*e*e*e},p}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,i){return t(e).then(r,n,i)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=i(e),t}function r(t){return e(t,a)}function n(e){this.then=e}function i(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return a(n)}});return r}function a(e){var r=new n(function(r,n){try{return n?t(n(e)):a(e)}catch(i){return a(i)}});return r}function o(){function e(e,t,r){return h(e,t,r)}function r(e){return d(e)}function i(e){return d(a(e))}function u(e){return p(e)}var s,c,l,f,h,p,d;return c=new n(e),s={then:e,resolve:r,reject:i,progress:u,promise:c,resolver:{resolve:r,reject:i,progress:u}},l=[],f=[],h=function(e,t,r){var n,i;return n=o(),i="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,i)}),f.push(i),n.promise},p=function(e){return y(f,e),e},d=function(e){return e=t(e),h=e.then,d=t,p=E,y(l,e),f=l=g,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,i,a){return m(2,arguments),e(t,function(t){function u(e){y(e)}function s(e){d(e)}var c,l,f,h,p,d,y,m,v,O;if(v=t.length>>>0,c=Math.max(0,Math.min(r,v)),f=[],l=v-c+1,h=[],p=o(),c)for(m=p.progress,y=function(e){h.push(e),--l||(d=y=E,p.reject(h))},d=function(e){f.push(e),--c||(d=y=E,p.resolve(f))},O=0;v>O;++O)O in t&&e(t[O],s,u,m);else p.resolve(f);return p.then(n,i,a)})}function c(e,t,r,n){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,r,n)}function l(e,t,r,n){return m(1,arguments),h(e,v).then(t,r,n)}function f(){return h(arguments,v)}function h(t,r){return e(t,function(t){var n,i,a,u,s,c;if(a=i=t.length>>>0,n=[],c=o(),a)for(u=function(t,i){e(t,r).then(function(e){n[i]=e,--a||c.resolve(n)},c.reject)},s=0;i>s;s++)s in t?u(t[s],s):--a;else c.resolve(n);return c.promise})}function p(t,r){var n=w.call(arguments,1);return e(t,function(t){var i;return i=t.length,n[0]=function(t,n,a){return e(t,function(t){return e(n,function(e){return r(t,e,a,i)})})},O.apply(t,n)})}function d(t,r,n){var i=arguments.length>2;return e(t,function(e){return e=i?n:e,r.resolve(e),e},function(e){return r.reject(e),a(e)},r.progress)}function y(e,t){for(var r,n=0;r=e[n++];)r(t)}function m(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function E(){}function v(e){return e}var O,w,g;return e.defer=o,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=h,e.reduce=p,e.any=c,e.some=s,e.chain=d,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(g,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(g,t)})})}},w=[].slice,O=[].reduce||function(e){var t,r,n,i,a;if(a=0,t=Object(this),i=t.length>>>0,r=arguments,r.length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;i>a;++a)a in t&&(n=e(n,t[a],a,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen","./RuntimeError","../ThirdParty/when"],function(e,t,r,n,i){"use strict";function a(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function o(){if(!t(S)&&(S=!1,!d())){var e=/ Chrome\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(S=!0,x=a(e[1]))}return S}function u(){return o()&&x}function s(){if(!t(N)&&(N=!1,!o()&&!d()&&/ Safari\/[\.0-9]+/.test(A.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(N=!0,I=a(e[1]))}return N}function c(){return s()&&I}function l(){if(!t(M)){M=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(A.userAgent);null!==e&&(M=!0,P=a(e[1]),P.isNightly=!!e[2])}return M}function f(){return l()&&P}function h(){if(!t(C)){C=!1;var e;"Microsoft Internet Explorer"===A.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(A.userAgent),null!==e&&(C=!0,D=a(e[1]))):"Netscape"===A.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(A.userAgent),null!==e&&(C=!0,D=a(e[1])))}return C}function p(){return h()&&D}function d(){if(!t(q)){q=!1;var e=/ Edge\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(q=!0,U=a(e[1]))}return q}function y(){return d()&&U}function m(){if(!t(L)){L=!1;var e=/Firefox\/([\.0-9]+)/.exec(A.userAgent);null!==e&&(L=!0,F=a(e[1]))}return L}function E(){return t(B)||(B=/Windows/i.test(A.appVersion)),B}function v(){return m()&&F}function O(){return t(j)||(j="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),j}function w(){return t(z)||(z=!m()&&"undefined"!=typeof PointerEvent&&(!t(A.pointerEnabled)||A.pointerEnabled)),z}function g(){if(!t(V)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;V=t(r)&&""!==r,V&&(G=r)}return V}function _(){return g()?G:void 0}function T(){if(t(k))return k.promise;k=i.defer(),d()&&(W=!1,k.resolve(W));var e=new Image;return e.onload=function(){W=e.width>0&&e.height>0,k.resolve(W)},e.onerror=function(){W=!1,k.resolve(W)},e.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",k.promise}function b(){return t(k)||T(),W}function R(){var e=window.navigator.userAgent.toLowerCase(),t="ipad"==e.match(/ipad/i),r="iphone os"==e.match(/iphone os/i),n="midp"==e.match(/midp/i),i="rv:1.2.3.4"==e.match(/rv:1.2.3.4/i),a="ucweb"==e.match(/ucweb/i),o="android"==e.match(/android/i),u="windows ce"==e.match(/windows ce/i),s="windows mobile"==e.match(/windows mobile/i);return t||r||n||i||a||o||u||s?!1:!0}var A;A="undefined"!=typeof navigator?navigator:{};var S,x,N,I,M,P,C,D,q,U,L,F,B,j,z,G,V,W,k,X=[];"undefined"!=typeof ArrayBuffer&&(X.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&X.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&X.push(CanvasPixelArray));var H={isChrome:o,chromeVersion:u,isSafari:s,safariVersion:c,isWebkit:l,webkitVersion:f,isInternetExplorer:h,internetExplorerVersion:p,isEdge:d,edgeVersion:y,isFirefox:m,firefoxVersion:v,isWindows:E,isNodeJs:O,hardwareConcurrency:e(A.hardwareConcurrency,3),supportsPointerEvents:w,supportsImageRenderingPixelated:g,supportsWebP:T,supportsWebPSync:b,imageRenderingValue:_,typedArrayTypes:X,isPCBroswer:R};return H.supportsFullscreen=function(){return r.supportsFullscreen()},H.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},H.supportsWebWorkers=function(){return"undefined"!=typeof Worker},H.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!H.isEdge()},H}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,
BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}},i(o)}),define("Core/CornerType",["./freezeObject"],function(e){"use strict";var t={ROUNDED:0,MITERED:1,BEVELED:2};return e(t)}),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,TOP:1,ALL:2};return e(t)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],function(e,t,r,n,i,a){"use strict";function o(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}o.packedLength=4,o.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},o.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a},o.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a},o.fromColumnMajorArray=function(e,r){return t.defined("values",e),o.clone(e,r)},o.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new o(e,0,0,e)},o.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=-a,r[3]=i,r):new o(i,-a,a,i)},o.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},o.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,a=e[i],o=e[i+1];return n.x=a,n.y=o,n},o.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=o.clone(e,i);var a=2*r;return i[a]=n.x,i[a+1]=n.y,i},o.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],a=e[r+2];return n.x=i,n.y=a,n},o.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=o.clone(e,i),i[r]=n.x,i[r+2]=n.y,i};var u=new e;o.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],a=e[0]*r[2]+e[2]*r[3],o=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n},o.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},o.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},o.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,a=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=a,n},o.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},o.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},o.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},o.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],a=e[1],o=e[3];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r},o.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},o.IDENTITY=a(new o(1,0,0,1)),o.ZERO=a(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,i(o.prototype,{length:{get:function(){return o.packedLength}}}),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,a){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var o=i/2,u=Math.sin(o);c=e.normalize(r,c);var l=c.x*u,f=c.y*u,h=c.z*u,p=Math.cos(o);return n(a)?(a.x=l,a.y=f,a.z=h,a.w=p,a):new s(l,f,h,p)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var i,a,o,c,h,p=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],y=e[u.COLUMN2ROW2],m=p+d+y;if(m>0)i=Math.sqrt(m+1),h=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var E=l,v=0;d>p&&(v=1),y>p&&y>d&&(v=2);var O=E[v],w=E[O];i=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(O,O)]-e[u.getElementIndex(w,w)]+1);var g=f;g[v]=.5*i,i=.5/i,h=(e[u.getElementIndex(w,O)]-e[u.getElementIndex(O,w)])*i,g[O]=(e[u.getElementIndex(O,v)]+e[u.getElementIndex(v,O)])*i,g[w]=(e[u.getElementIndex(w,v)]+e[u.getElementIndex(v,w)])*i,a=-g[0],o=-g[1],c=-g[2]}return n(r)?(r.x=a,r.y=o,r.z=c,r.w=h,r):new s(a,o,c,h)};var h=new s,p=new s,d=new s,y=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=s.fromAxisAngle(e.UNIT_X,r.roll,h),d=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(d,y,d),p=s.fromAxisAngle(e.UNIT_Z,-r.heading,h),s.multiply(p,n,n)};var m=new e,E=new e,v=new s,O=new s,w=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,w),s.conjugate(w,w);for(var i=0,a=r-t+1;a>i;i++){var o=3*i;s.unpack(e,4*(t+i),v),s.multiply(v,w,v),v.w<0&&s.negate(v,v),s.computeAxis(v,m);var u=s.computeAngle(v);n[o]=m.x*u,n[o+1]=m.y*u,n[o+2]=m.z*u}},s.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*a,O),0===u?s.clone(s.IDENTITY,v):s.fromAxisAngle(E,u,v),s.multiply(v,O,o)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return r.x=i,r.y=a,r.z=o,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,a=e.y,o=e.z,u=e.w,s=r.x,c=r.y,l=r.z,f=r.w,h=u*s+i*f+a*l-o*c,p=u*c-i*l+a*f+o*s,d=u*l+i*c-a*s+o*f,y=u*f-i*s-a*c-o*l;return n.x=h,n.y=p,n.z=d,n.w=y,n},s.multiplyByVec=function(t,r,n){var i=new e,a=new e,o=new e(t.x,t.y,t.z);i=e.cross(o,r,i),a=e.cross(o,i,a);var u=new e;u=e.multiplyByScalar(i,2*t.w,u);var s=new e;return s=e.multiplyByScalar(i,2,s),n=e.add(r,u,n),n=e.add(n,s,n)},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var g=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),g=s.multiplyByScalar(r,n,g),i=s.multiplyByScalar(e,1-n,i),s.add(g,i,i)};var _=new s,T=new s,b=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a=s.dot(e,r),u=r;if(0>a&&(a=-a,u=_=s.negate(r,_)),1-a<o.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(a);return T=s.multiplyByScalar(e,Math.sin((1-n)*c),T),b=s.multiplyByScalar(u,Math.sin(n*c),b),i=s.add(T,b,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=o.acosClamped(r.w),a=0;return 0!==i&&(a=i/Math.sin(i)),e.multiplyByScalar(r,a,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),a=0;return 0!==i&&(a=Math.sin(i)/i),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(i),n};var R=new e,A=new e,S=new s,x=new s;s.computeInnerQuadrangle=function(r,n,i,a){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",a);var o=s.conjugate(n,S);s.multiply(o,i,x);var u=s.log(x,R);s.multiply(o,r,x);var c=s.log(x,A);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,S),s.multiply(n,S,a)},s.squad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.slerp(e,r,a,S),c=s.slerp(n,i,a,x);return s.slerp(u,c,2*a*(1-a),o)};for(var N=new s,I=1.9011074535173003,M=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],D=i.supportsTypedArrays()?new Float32Array(8):[],q=0;7>q;++q){var U=q+1,L=2*U+1;M[q]=1/(U*L),P[q]=U/L}return M[7]=I/136,P[7]=8*I/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a,o=s.dot(e,r);o>=0?a=1:(a=-1,o=-o);for(var u=o-1,c=1-n,l=n*n,f=c*c,h=7;h>=0;--h)C[h]=(M[h]*l-P[h])*u,D[h]=(M[h]*f-P[h])*u;var p=a*n*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),d=c*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),y=s.multiplyByScalar(e,d,N);return s.multiplyByScalar(r,p,i),s.add(y,i,i)},s.fastSquad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.fastSlerp(e,r,a,S),c=s.fastSlerp(n,i,a,x);return s.fastSlerp(u,c,2*a*(1-a),o)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,a,o=0,u=t.length-1;u>=o;)if(i=~~((o+u)/2),a=n(t[i],r),0>a)o=i+1;else{if(!(a>0))return i;u=i-1}return~(u+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var u=n-e.length;return u>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+i(c.toString(t),u||0,"0",!1),a(e,r,n,o,s)},u=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},s=function(e,n,s,c,l,f,h){var p,d,y,m,E;if("%%"==e)return"%";for(var v=!1,O="",w=!1,g=!1,_=" ",T=s.length,b=0;s&&T>b;b++)switch(s.charAt(b)){case" ":O=" ";break;case"+":O="+";break;case"-":v=!0;break;case"'":_=s.charAt(b+1);break;case"0":w=!0;break;case"#":g=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,v=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],h){case"s":return u(String(E),v,c,f,w,_);case"c":return u(String.fromCharCode(+E),v,c,f,w);case"b":return o(E,2,g,v,c,f,w);case"o":return o(E,8,g,v,c,f,w);case"x":return o(E,16,g,v,c,f,w);case"X":return o(E,16,g,v,c,f,w).toUpperCase();case"u":return o(E,10,g,v,c,f,w);case"i":case"d":return p=+E||0,
p=Math.round(p-p%1),d=0>p?"-":O,E=d+i(String(Math.abs(p)),f,"0",!1),a(E,d,v,c,w);case"e":case"E":case"f":case"F":case"g":case"G":return p=+E,d=0>p?"-":O,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],E=d+Math.abs(p)[y](f),a(E,d,v,c,w)[m]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,i,a,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t){return y.compare(e.julianDate,t.julianDate)}function f(e){O.julianDate=e;var r=y.leapSeconds,n=t(r,O,l);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;if(n>0){var a=y.secondsDifference(r[n].julianDate,e);a>i&&(n--,i=r[n].offset)}y.addSeconds(e,i,e)}function h(e,r){O.julianDate=e;var n=y.leapSeconds,i=t(n,O,l);if(0>i&&(i=~i),0===i)return y.addSeconds(e,-n[0].offset,r);if(i>=n.length)return y.addSeconds(e,-n[i-1].offset,r);var a=y.secondsDifference(n[i].julianDate,e);return 0===a?y.addSeconds(e,-n[i].offset,r):1>=a?void 0:y.addSeconds(e,-n[--i].offset,r)}function p(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function d(e,t,r,n,i,a,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;n-=12,0>n&&(n+=24);var f=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function y(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;t+=(e-i)*s.SECONDS_PER_DAY,p(i,t,this),n===c.UTC&&f(this)}var m=new a,E=[31,28,31,30,31,30,31,31,30,31,30,31],v=29,O=new u,w=/^(\d{4})$/,g=/^(\d{4})-(\d{2})$/,_=/^(\d{4})-?(\d{3})$/,T=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,b=/^(\d{4})-?(\d{2})-?(\d{2})$/,R=/([Z+\-])?(\d{2})?:?(\d{2})?$/,A=/^(\d{2})(\.\d+)?/.source+R.source,S=/^(\d{2}):?(\d{2})(\.\d+)?/.source+R.source,x=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+R.source,N="Invalid ISO 8601 date.";y.fromGregorianDate=function(e,t){if(!(e instanceof a))throw new i("date must be a valid GregorianDate.");var r=d(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(p(r[0],r[1],t),f(t),t):new y(r[0],r[1],c.UTC)},y.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=d(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(p(r[0],r[1],t),f(t),t):new y(r[0],r[1],c.UTC)},y.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(N);e=e.replace(",",".");var r,a,u,s=e.split("T"),l=1,h=1,m=0,O=0,R=0,I=0,M=s[0],P=s[1];if(!n(M))throw new i(N);var C;if(s=M.match(b),null!==s){if(C=M.split("-").length-1,C>0&&2!==C)throw new i(N);r=+s[1],l=+s[2],h=+s[3]}else if(s=M.match(g),null!==s)r=+s[1],l=+s[2];else if(s=M.match(w),null!==s)r=+s[1];else{var D;if(s=M.match(_),null!==s){if(r=+s[1],D=+s[2],u=o(r),1>D||u&&D>366||!u&&D>365)throw new i(N)}else{if(s=M.match(T),null===s)throw new i(N);r=+s[1];var q=+s[2],U=+s[3]||0;if(C=M.split("-").length-1,C>0&&(!n(s[3])&&1!==C||n(s[3])&&2!==C))throw new i(N);var L=new Date(Date.UTC(r,0,4));D=7*q+U-L.getUTCDay()-3}a=new Date(Date.UTC(r,0,1)),a.setUTCDate(D),l=a.getUTCMonth()+1,h=a.getUTCDate()}if(u=o(r),1>l||l>12||1>h||(2!==l||!u)&&h>E[l-1]||u&&2===l&&h>v)throw new i(N);var F;if(n(P)){if(s=P.match(x),null!==s){if(C=P.split(":").length-1,C>0&&2!==C&&3!==C)throw new i(N);m=+s[1],O=+s[2],R=+s[3],I=1e3*+(s[4]||0),F=5}else if(s=P.match(S),null!==s){if(C=P.split(":").length-1,C>2)throw new i(N);m=+s[1],O=+s[2],R=60*+(s[3]||0),F=4}else{if(s=P.match(A),null===s)throw new i(N);m=+s[1],O=60*+(s[2]||0),F=3}if(O>=60||R>=61||m>24||24===m&&(O>0||R>0||I>0))throw new i(N);var B=s[F],j=+s[F+1],z=+(s[F+2]||0);switch(B){case"+":m-=j,O-=z;break;case"-":m+=j,O+=z;break;case"Z":break;default:O+=new Date(Date.UTC(r,l-1,h,m,O)).getTimezoneOffset()}}var G=60===R;for(G&&R--;O>=60;)O-=60,m++;for(;m>=24;)m-=24,h++;for(a=u&&2===l?v:E[l-1];h>a;)h-=a,l++,l>12&&(l-=12,r++),a=u&&2===l?v:E[l-1];for(;0>O;)O+=60,m--;for(;0>m;)m+=24,h--;for(;1>h;)l--,1>l&&(l+=12,r--),a=u&&2===l?v:E[l-1],h+=a;var V=d(r,l,h,m,O,R,I);return n(t)?(p(V[0],V[1],t),f(t)):t=new y(V[0],V[1],c.UTC),G&&y.addSeconds(t,1,t),t},y.now=function(e){return y.fromDate(new Date,e)};var I=new y(0,0,c.TAI);return y.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,o=h(e,I);n(o)||(y.addSeconds(e,-1,I),o=h(I,I),r=!0);var u=o.dayNumber,c=o.secondsOfDay;c>=43200&&(u+=1);var l=u+68569|0,f=4*l/146097|0;l=l-((146097*f+3)/4|0)|0;var p=4e3*(l+1)/1461001|0;l=l-(1461*p/4|0)+31|0;var d=80*l/2447|0,m=l-(2447*d/80|0)|0;l=d/11|0;var E=d+2-12*l|0,v=100*(f-49)+p+l|0,O=c/s.SECONDS_PER_HOUR|0,w=c-O*s.SECONDS_PER_HOUR,g=w/s.SECONDS_PER_MINUTE|0;w-=g*s.SECONDS_PER_MINUTE;var _=0|w,T=(w-_)/s.SECONDS_PER_MILLISECOND;return O+=12,O>23&&(O-=24),r&&(_+=1),n(t)?(t.year=v,t.month=E,t.day=m,t.hour=O,t.minute=g,t.second=_,t.millisecond=T,t.isLeapSecond=r,t):new a(v,E,m,O,g,_,T,r)},y.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=y.toGregorianDate(e,m),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},y.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var a=y.toGregorianDate(t,m),o=a.year,u=a.month,s=a.day,c=a.hour,l=a.minute,f=a.second,h=a.millisecond;1e4===o&&1===u&&1===s&&0===c&&0===l&&0===f&&0===h&&(o=9999,u=12,s=31,c=24);var p;return n(r)||0===h?n(r)&&0!==r?(p=(.01*h).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,u,s,c,l,f,p)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o,u,s,c,l,f):(p=(.01*h).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,u,s,c,l,f,p))},y.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new y(e.dayNumber,e.secondsOfDay,c.TAI):void 0},y.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},y.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},y.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(y.secondsDifference(e,t))<=r},y.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},y.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},y.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber,a=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+a},y.computeTaiMinusUtc=function(e){O.julianDate=e;var r=y.leapSeconds,n=t(r,O,l);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},y.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return p(e.dayNumber,e.secondsOfDay+t,r)},y.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return p(e.dayNumber,a,r)},y.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return p(e.dayNumber,a,r)},y.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");var a=e.dayNumber+t;return p(a,e.secondsOfDay,r)},y.lessThan=function(e,t){return y.compare(e,t)<0},y.lessThanOrEquals=function(e,t){return y.compare(e,t)<=0},y.greaterThan=function(e,t){return y.compare(e,t)>0},y.greaterThanOrEquals=function(e,t){return y.compare(e,t)>=0},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y.prototype.equalsEpsilon=function(e,t){return y.equalsEpsilon(this,e,t)},y.prototype.toString=function(){return y.toIso8601(this)},y.leapSeconds=[new u(new y(2441317,43210,c.TAI),10),new u(new y(2441499,43211,c.TAI),11),new u(new y(2441683,43212,c.TAI),12),new u(new y(2442048,43213,c.TAI),13),new u(new y(2442413,43214,c.TAI),14),new u(new y(2442778,43215,c.TAI),15),new u(new y(2443144,43216,c.TAI),16),new u(new y(2443509,43217,c.TAI),17),new u(new y(2443874,43218,c.TAI),18),new u(new y(2444239,43219,c.TAI),19),new u(new y(2444786,43220,c.TAI),20),new u(new y(2445151,43221,c.TAI),21),new u(new y(2445516,43222,c.TAI),22),new u(new y(2446247,43223,c.TAI),23),new u(new y(2447161,43224,c.TAI),24),new u(new y(2447892,43225,c.TAI),25),new u(new y(2448257,43226,c.TAI),26),new u(new y(2448804,43227,c.TAI),27),new u(new y(2449169,43228,c.TAI),28),new u(new y(2449534,43229,c.TAI),29),new u(new y(2450083,43230,c.TAI),30),new u(new y(2450630,43231,c.TAI),31),new u(new y(2451179,43232,c.TAI),32),new u(new y(2453736,43233,c.TAI),33),new u(new y(2454832,43234,c.TAI),34),new u(new y(2456109,43235,c.TAI),35),new u(new y(2457204,43236,c.TAI),36),new u(new y(2457754,43237,c.TAI),37)],y}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,i,a){a=e(a,!1);var o,u,s,c={},l=t(n),f=t(i);if(l)for(o in n)n.hasOwnProperty(o)&&(u=n[o],f&&a&&"object"==typeof u&&i.hasOwnProperty(o)?(s=i[o],"object"==typeof s?c[o]=r(u,s,a):c[o]=u):c[o]=u);if(f)for(o in i)i.hasOwnProperty(o)&&!c.hasOwnProperty(o)&&(s=i[o],c[o]=s);return c}return r}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,a,o){if(!r(i))throw new n("relative uri is required.");if(!r(a)){if("undefined"==typeof o)return i;a=t(o.baseURI,o.location.href)}var u=new e(a),s=new e(i);return s.resolve(u).toString()},i}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,i){if(!t(n))throw new r("uri is required.");var a="",o=n.lastIndexOf("/");return-1!==o&&(a=n.substring(0,o+1)),i?(n=new e(n),t(n.query)&&(a+="?"+n.query),t(n.fragment)&&(a+="#"+n.fragment),a):a}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var a=i.path,o=a.lastIndexOf("/");return-1!==o&&(a=a.substr(o+1)),o=a.lastIndexOf("."),a=-1===o?"":a.substr(o+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,i=r.protocol;return r.href=t,r.href=r.href,i!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^data:/i;return t}),define("Core/loadAndExecuteScript",["../ThirdParty/when"],function(e){"use strict";function t(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}return t}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("obj is required.");var i="";for(var a in n)if(n.hasOwnProperty(a)){var o=n[a],u=encodeURIComponent(a)+"=";if(r(o))for(var s=0,c=o.length;c>s;++s)i+=u+encodeURIComponent(o[s])+"&";else i+=u+encodeURIComponent(o)+"&"}return i=i.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var a=n.replace(/\+/g,"%20").split(/[&;]/),o=0,u=a.length;u>o;++o){var s=a[o].split("="),c=decodeURIComponent(s[0]),l=s[1];l=e(l)?decodeURIComponent(l):"";var f=i[c];"string"==typeof f?i[c]=[f,l]:r(f)?f.push(l):i[c]=l}return i}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";var t={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5};return e(t)}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";var t={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3,PACK_TERRAIN:4,PACK_IMAGERY:5};return e(t)}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),a=e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=a,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,a=-1,o=0;o<n.length;o++)if(n[o]===t&&i[o]===r){a=o;break}return-1!==a?(this._insideRaiseEvent?(this._toRemove.push(a),n[a]=void 0,i[a]=void 0):(n.splice(a,1),i.splice(a,1)),!0):!1},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,a=r.length;for(e=0;a>e;e++){var o=r[e];t(o)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if(a=u.length,a>0){for(u.sort(i),e=0;a>e;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function a(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,o=-1,u=!0;u;){var s=2*(e+1),c=s-1;o=r>c&&n(i[c],i[e])<0?c:e,r>s&&n(i[s],i[o])<0&&(o=s),o!==e?(a(i,o,e),e=o):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n=this._array,i=this._comparator,o=this._maximumLength,u=this._length++;for(u<n.length?n[u]=t:n.push(t);0!==u;){var s=Math.floor((u-1)/2);if(!(i(n[u],n[s])<0))break;a(n,u,s),u=s}var c;return r(o)&&this._length>o&&(c=n[o],this._length=o),c},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return a(n,r,--this._length),this.heapify(r),i}},i}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState","./RequestType"],function(e,t,r,n,i,a,o,u,s,c,l,f){"use strict";function h(e,t){return e.priority-t.priority}function p(){}function d(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function y(e){var t=n(p.requestsByServer[e],p.maximumRequestsPerServer);return M[e]<t}function m(e){var r=e.serverKey+"_"+e.providerName;if(i(p.packRequests[r])||(p.packRequests[r]=[]),!(p.packRequests[r].length>=q)){i(p.packRequestQuadKey[r])||(p.packRequestQuadKey[r]=[],p.quadKeyIndex[r]=0,p.totalPacketCount[r]=0,p.currentDeferIndex[r]=0),i(p.currentPacketCount[r])||(p.currentPacketCount[r]=0),i(p.packRequestPromise[r])||(p.packRequestPromise[r]=[t.defer()]),p.totalPacketCount[r]>=D&&(p.totalPacketCount[r]=0,p.currentDeferIndex[r]++,p.packRequestPromise[r].push(t.defer()));var n=p.currentDeferIndex[r];return e.deferred=p.packRequestPromise[r][n],e.state=l.ISSUED,p.packRequests[r].push(e),p.totalPacketCount[r]++,e.deferred.promise}}function E(){p.packRequests={},p.packRequestPromise={},p.packRequestQuadKey={},p.quadKeyIndex={},p.currentPacketCount={},p.totalPacketCount={},p.currentDeferIndex={}}function v(e){var t=e.serverKey+"_"+e.providerName,r=p.packRequestQuadKey[t],n=p.quadKeyIndex[t];i(r[n])?r[n]+=";"+e.quadKey:r[n]=e.quadKey,e.quadKeyIndex=p.currentPacketCount[t],++p.currentPacketCount[t],p.currentPacketCount[t]>=D&&(p.currentPacketCount[t]=0,p.quadKeyIndex[t]++)}function O(e,t){for(var r=D*t,n=0,i=e.length;i>n;n++)if(n>=r){var a=e[n];a.state=l.CANCELLED}}function w(){var t,r=p.packRequests;for(var n in r)if(r.hasOwnProperty(n)){t=void 0;for(var a=r[n],o=0,u=a.length;u>o;o++){var s=a[o];i(t)||(t=s),v(s)}var c;for(i(t)&&(c=t.url),o=0,u=p.packRequestQuadKey[n].length;u>o;o++){var l=p.packRequestQuadKey[n][o];if(-1===l.indexOf(";")&&(l+=";"+l),i(t)){if(t.throttleByServer&&!y(t.serverKey)){O(a,o),p.packRequestPromise[n][o].reject();continue}var f=t.clone();f.state=t.state,f.serverKey=t.serverKey,f.deferred=p.packRequestPromise[n][o],f.deferred.id=o;var h=new e(c);h.query=i(h.query)?h.query+"&extratiles="+l:"extratiles="+l,f.url=h.toString(),b(f,f.url)}}}E()}function g(e){return e.state===l.UNISSUED&&(e.state=l.ISSUED,e.deferred=t.defer()),e.deferred.promise}function _(e){return function(t){e.state!==l.CANCELLED&&(--S.numberOfActiveRequests,--M[e.serverKey],C.raiseEvent(),e.state=l.RECEIVED,e.deferred.resolve(t))}}function T(e){return function(t){e.state!==l.CANCELLED&&(++S.numberOfFailedRequests,--S.numberOfActiveRequests,--M[e.serverKey],C.raiseEvent(t),e.state=l.FAILED,e.deferred.reject(t))}}function b(e,t){var r=g(e);return e.state=l.ACTIVE,I.push(e),++S.numberOfActiveRequests,++S.numberOfActiveRequestsEver,++M[e.serverKey],e.requestFunction(t).then(_(e)).otherwise(T(e)),r}function R(e){var t=e.state===l.ACTIVE;e.state=l.CANCELLED,++S.numberOfCancelledRequests,e.deferred.reject(),t&&(--S.numberOfActiveRequests,--M[e.serverKey],++S.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}function A(){p.debugShowStatistics&&(0===S.numberOfActiveRequests&&S.lastNumberOfActiveRequests>0&&(S.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+S.numberOfAttemptedRequests),S.numberOfAttemptedRequests=0),S.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+S.numberOfCancelledRequests),S.numberOfCancelledRequests=0),S.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+S.numberOfCancelledActiveRequests),S.numberOfCancelledActiveRequests=0),S.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+S.numberOfFailedRequests),S.numberOfFailedRequests=0)),S.lastNumberOfActiveRequests=S.numberOfActiveRequests)}var S={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},x=20,N=new u({comparator:h});N.maximumLength=x,N.reserve(x);var I=[],M={},P="undefined"!=typeof document?new e(document.location.href):new e,C=new o;p.maximumRequests=50,p.maximumRequestsPerServer=6,p.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},p.throttleRequests=!0,p.debugShowStatistics=!1,p.requestCompletedEvent=C,a(p,{statistics:{get:function(){return S}},priorityHeapLength:{get:function(){return x},set:function(e){if(x>e)for(;N.length>e;){var t=N.pop();R(t)}x=e,N.maximumLength=e,N.reserve(e)}}});var D=20,q=120;return p.packRequests={},p.packRequestPromise={},p.packRequestQuadKey={},p.quadKeyIndex={},p.currentPacketCount={},p.totalPacketCount={},p.currentDeferIndex={},p.update=function(){var e,t,r=0,n=I.length;for(e=0;n>e;++e)t=I[e],t.cancelled&&R(t),t.state===l.ACTIVE?r>0&&(I[e-r]=t):++r;I.length-=r,w();var i=N.internalArray,a=N.length;for(e=0;a>e;++e)d(i[e]);N.resort();for(var o=Math.max(p.maximumRequests-I.length,0),u=0;o>u&&N.length>0;)t=N.pop(),t.cancelled?R(t):!t.throttleByServer||y(t.serverKey)?(b(t),++u):R(t);A()},p.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(P);n.normalize();var a=n.authority;/:/.test(a)||(a=a+":"+("https"===n.scheme?"443":"80"));var o=M[a];return i(o)||(M[a]=0),a},p.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return C.raiseEvent(),e.state=l.RECEIVED,e.requestFunction();if(++S.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=p.getServerKey(e.url)),e.type>f.OTHER)return m(e);if(!e.throttleByServer||y(e.serverKey)){if(!p.throttleRequests||!e.throttle)return b(e);if(!(I.length>=p.maximumRequests)){d(e);var t=N.insert(e);if(i(t)){if(t===e)return;R(t)}return g(e)}}},p.clearForSpecs=function(){for(;N.length>0;){var e=N.pop();R(e)}for(var t=I.length,r=0;t>r;++r)R(I[r]);I.length=0,M={},S.numberOfAttemptedRequests=0,S.numberOfActiveRequests=0,S.numberOfCancelledRequests=0,S.numberOfCancelledActiveRequests=0,S.numberOfFailedRequests=0,S.numberOfActiveRequestsEver=0,S.lastNumberOfActiveRequests=0},p.numberOfActiveRequestsByServer=function(e){return M[e]},p.requestHeap=N,p}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var a=i.split("@");i=a[1]}if(-1===i.indexOf(":")){var o=n.getScheme();if(t(o)||(o=window.location.protocol,o=o.substring(0,o.length-1)),"http"===o)i+=":80";else{if("https"!==o)return;i+=":443"}}return i}}var i={},a={};return i.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])||(a[i]=!0)},i.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])&&delete a[i]},i.contains=function(e){if(!t(e))throw new r("url is required.");var i=n(e);return t(i)&&t(a[i])?!0:!1},i.clear=function(){a={}},i}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,i,a,o,u,s,c,l,f,h,p,d,y,m,E,v,O,w,g,_,T,b,R){"use strict";function A(e,t,r,n){var i=e.query;if(!u(i)||0===i.length)return{};var a;if(-1===i.indexOf("=")){var o={};o[i]=void 0,a=o}else a=O(i);r?t._queryParameters=I(a,t._queryParameters,n):t._queryParameters=a,e.query=void 0}function S(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=v(r):e.query=n[0]}function x(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function N(e){if(e.state===T.ISSUED||e.state===T.ACTIVE)throw new b("The Resource is already being fetched.");e.state=T.UNISSUED,e.deferred=void 0}function I(e,t,r){if(!r)return a(e,t);var n=i(e,!0);for(var o in t)if(t.hasOwnProperty(o)){var s=n[o],c=t[o];u(s)?(Array.isArray(s)||(s=n[o]=[s]),n[o]=s.concat(c)):n[o]=Array.isArray(c)?c.slice():c}return n}function M(t){t=o(t,o.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=x(t.templateValues,{}),this._queryParameters=x(t.queryParameters,{}),this.headers=x(t.headers,{}),this.request=o(t.request,new w),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=o(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);A(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function P(e){var r=e.resource,n=e.flipY,i=e.preferImageBitmap,a=r.request;a.url=r.url,a.requestFunction=function(){var e=r.url,a=!1;r.isDataUri||r.isBlobUri||(a=r.isCrossOriginUrl);var o=t.defer();return M._Implementations.createImage(e,a,o,n,i),o.promise};var o=_.request(a);return u(o)?o.otherwise(function(e){return a.state!==T.FAILED?t.reject(e):r.retryOnError(e).then(function(o){return o?(a.state=T.UNISSUED,a.deferred=void 0,P({resource:r,flipY:n,preferImageBitmap:i})):t.reject(e)})}):void 0}function C(e,r,n){var i={};i[r]=n,e.setQueryParameters(i);var a=e.request;a.url=e.url,a.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(t){window[n]=void 0}},M._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var o=_.request(a);return u(o)?o.otherwise(function(i){return a.state!==T.FAILED?t.reject(i):e.retryOnError(i).then(function(o){return o?(a.state=T.UNISSUED,a.deferred=void 0,C(e,r,n)):t.reject(i)})}):void 0}function D(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function q(e,t){for(var r=D(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),a=0;a<r.length;a++)i[a]=r.charCodeAt(a);return n}function U(e,t){t=o(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return D(n,i);case"arraybuffer":return q(n,i);case"blob":var a=q(n,i);return new Blob([a],{type:r});case"document":var u=new DOMParser;return u.parseFromString(D(n,i),r);
case"json":return JSON.parse(D(n,i));default:throw new c("Unhandled responseType: "+t)}}function L(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(R.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e}function F(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function B(e,t,r,n,i,a,o){var u=global.require,s=u("url").parse(e),c=u("https:"===s.protocol?"https":"http"),l=u("zlib"),f={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:r,headers:i};c.request(f).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void a.reject(new g(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?l.gunzip(n,function(e,r){e?a.reject(new b("Error decompressing response.")):a.resolve(F(r,t))}):a.resolve(F(n,t))})}).on("error",function(e){a.reject(new g)}).end()}var j=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();M.createIfNeeded=function(e){return e instanceof M?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new M({url:e})};var z;M.supportsImageBitmapOptions=function(){if(u(z))return z;if("function"!=typeof createImageBitmap)return z=t.resolve(!1);var e="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg==";return z=M.fetchBlob({url:e}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},s(M,{isBlobSupported:{get:function(){return j}}}),s(M.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);A(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return p(this._url)}},isDataUri:{get:function(){return m(this._url)}},isBlobUri:{get:function(){return d(this._url)}},isCrossOriginUrl:{get:function(){return y(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),M.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&S(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues;return i=i.replace(/{(.*?)}/g,function(e,t){var r=a[t];return u(r)?encodeURIComponent(r):e}),r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},M.prototype.setQueryParameters=function(e,t){t?this._queryParameters=I(this._queryParameters,e,!1):this._queryParameters=I(e,this._queryParameters,!1)},M.prototype.appendQueryParameters=function(e){this._queryParameters=I(e,this._queryParameters,!0)},M.prototype.setTemplateValues=function(e,t){t?this._templateValues=a(this._templateValues,e):this._templateValues=a(e,this._templateValues)},M.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url),i=o(t.preserveQueryParameters,!1);A(n,r,!0,i),n.fragment=void 0,r._url=n.resolve(new e(f(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=a(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=a(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=a(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},M.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},M.prototype.clone=function(e){return u(e)||(e=new M({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},M.prototype.getBaseUri=function(e){return h(this.getUrlComponent(e),e)},M.prototype.appendForwardSlash=function(){this._url=r(this._url)},M.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},M.fetchArrayBuffer=function(e){var t=new M(e);return t.fetchArrayBuffer()},M.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},M.fetchBlob=function(e){var t=new M(e);return t.fetchBlob()},M.prototype.fetchImage=function(e){e=o(e,o.EMPTY_OBJECT);var r=o(e.preferImageBitmap,!1),n=o(e.preferBlob,!1),i=o(e.flipY,!1);if(N(this.request),!j||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return P({resource:this,flipY:i,preferImageBitmap:r});var a=this.fetchBlob();if(u(a)){var s,c,l,f;return M.supportsImageBitmapOptions().then(function(e){return s=e,c=s&&r,a}).then(function(e){if(u(e)){if(f=e,c)return M.createImageBitmapFromBlob(e,{flipY:i,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return l=new M({url:t}),P({resource:l,flipY:i,preferImageBitmap:!1})}}).then(function(e){return u(e)?(e.blob=f,c?e:(window.URL.revokeObjectURL(l.url),e)):void 0}).otherwise(function(e){return u(l)&&window.URL.revokeObjectURL(l.url),e.blob=f,t.reject(e)})}},M.fetchImage=function(e){var t=new M(e);return t.fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},M.prototype.fetchText=function(){return this.fetch({responseType:"text"})},M.fetchText=function(e){var t=new M(e);return t.fetchText()},M.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then(function(e){return u(e)?JSON.parse(e):void 0})},M.fetchJson=function(e){var t=new M(e);return t.fetchJson()},M.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},M.fetchXML=function(e){var t=new M(e);return t.fetchXML()},M.prototype.fetchJsonp=function(e){e=o(e,"callback"),N(this.request);var t;do t="loadJsonp"+Math.random().toString().substring(2,8);while(u(window[t]));return C(this,e,t)},M.fetchJsonp=function(e){var t=new M(e);return t.fetchJsonp(e.callbackParameterName)},M.prototype._makeRequest=function(e){var r=this;N(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(i){var o=e.responseType,s=a(e.headers,r.headers),c=e.overrideMimeType,l=e.method,f=e.data,h=t.defer(),p=u(i)?i:r.url,d=M._Implementations.loadWithXhr(p,o,l,f,s,h,c);return u(d)&&u(d.abort)&&(n.cancelFunction=function(){d.abort()}),h.promise};var i=_.request(n);return u(i)?i.then(function(e){return e}).otherwise(function(i){return n.state!==T.FAILED?t.reject(i):r.retryOnError(i).then(function(a){return a?(n.state=T.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)})}):void 0};var G=/^data:(.*?)(;base64)?,(.*)$/;M.prototype.fetch=function(e){return e=x(e,{}),e.method="GET",this._makeRequest(e)},M.fetch=function(e){var t=new M(e);return t.fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype["delete"]=function(e){return e=x(e,{}),e.method="DELETE",this._makeRequest(e)},M["delete"]=function(e){var t=new M(e);return t["delete"]({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},M.prototype.head=function(e){return e=x(e,{}),e.method="HEAD",this._makeRequest(e)},M.head=function(e){var t=new M(e);return t.head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.options=function(e){return e=x(e,{}),e.method="OPTIONS",this._makeRequest(e)},M.options=function(e){var t=new M(e);return t.options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.post=function(e,t){return n.defined("data",e),t=x(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},M.post=function(e){var t=new M(e);return t.post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.put=function(e,t){return n.defined("data",e),t=x(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},M.put=function(e){var t=new M(e);return t.put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M.prototype.patch=function(e,t){return n.defined("data",e),t=x(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},M.patch=function(e){var t=new M(e);return t.patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},M._Implementations={},M._Implementations.createImage=function(e,t,r,n,i){M.supportsImageBitmapOptions().then(function(n){return n&&i?M.fetchBlob({url:e}):void L(e,t,r)}).then(function(e){return u(e)?M.createImageBitmapFromBlob(e,{flipY:n,premultiplyAlpha:!1}):void 0}).then(function(e){u(e)&&r.resolve(e)}).otherwise(r.reject)},M.createImageBitmapFromBlob=function(e,t){return n.defined("options",t),n.typeOf.bool("options.flipY",t.flipY),n.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var V="undefined"==typeof XMLHttpRequest;return M._Implementations.loadWithXhr=function(e,t,r,n,i,a,o){var s=G.exec(e);if(null!==s)return void a.resolve(U(s,t));if(V)return void B(e,t,r,n,i,a,o);var c=new XMLHttpRequest;if(R.contains(e)&&(c.withCredentials=!0),e=e.replace(/{/g,"%7B").replace(/}/g,"%7D"),c.open(r,e,!0),u(o)&&u(c.overrideMimeType)&&c.overrideMimeType(o),u(i))for(var l in i)i.hasOwnProperty(l)&&c.setRequestHeader(l,i[l]);u(t)&&(c.responseType=t);var f=!1;return"string"==typeof e&&(f=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!f||0!==c.status))return void a.reject(new g(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var i=c.getAllResponseHeaders(),o=i.trim().split(/[\r\n]+/),s={};return o.forEach(function(e){var t=e.split(": "),r=t.shift();s[r]=t.join(": ")}),void a.resolve(s)}if(204===c.status)a.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{a.resolve(JSON.parse(e))}catch(l){a.reject(l)}else(""===n||"document"===n)&&u(c.responseXML)&&c.responseXML.hasChildNodes()?a.resolve(c.responseXML):""!==n&&"text"!==n||!u(c.responseText)?a.reject(new b("Invalid XMLHttpRequest response type.")):a.resolve(c.responseText);else a.resolve(e)},c.onerror=function(e){a.reject(new g)},c.send(n),c},M._Implementations.loadAndExecuteScript=function(e,t,r){return E(e,t).otherwise(r.reject)},M._DefaultImplementations={},M._DefaultImplementations.createImage=M._Implementations.createImage,M._DefaultImplementations.loadWithXhr=M._Implementations.loadWithXhr,M._DefaultImplementations.loadAndExecuteScript=M._Implementations.loadAndExecuteScript,M.DEFAULT=l(new M({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),M}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c,l,f){"use strict";function h(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))d(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),a=this;this._downloadPromise=e(i.fetchJson(),function(e){d(a,e)},function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function p(e,t){return o.compare(e.julianDate,t)}function d(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),h=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),d=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>c||0>h||0>d||0>y)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=r.samples,E=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=d,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var v,O=e._addNewLeapSeconds,w=0,g=m.length;g>w;w+=e._columnCount){var _=m[w+i],T=m[w+y],b=_+l.MODIFIED_JULIAN_DATE_DIFFERENCE,R=new o(b,T,f.TAI);if(E.push(R),O){if(T!==v&&n(v)){var A=o.leapSeconds,S=t(A,R,p);if(0>S){var x=new u(R,T);A.splice(~S,0,x)}}v=T}}}function y(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],l=t[a];if(c.equals(l)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(l))return y(e,r,a,s,u),u;var f=o.secondsDifference(n,c)/o.secondsDifference(l,c),h=i*s,p=a*s,d=r[h+e._ut1MinusUtcSecondsColumn],E=r[p+e._ut1MinusUtcSecondsColumn],v=E-d;if(v>.5||-.5>v){var O=r[h+e._taiMinusUtcSecondsColumn],w=r[p+e._taiMinusUtcSecondsColumn];O!==w&&(l.equals(n)?d=E:E-=w-O)}return u.xPoleWander=m(f,r[h+e._xPoleWanderRadiansColumn],r[p+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,r[h+e._yPoleWanderRadiansColumn],r[p+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,r[h+e._xCelestialPoleOffsetRadiansColumn],r[p+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,r[h+e._yCelestialPoleOffsetRadiansColumn],r[p+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,d,E),u}return h.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),h.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},h.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=a[u],h=a[u+1],p=o.lessThanOrEquals(f,e),d=!n(h),y=d||o.greaterThanOrEquals(h,e);if(p&&y)return s=u,!d&&h.equals(e)&&++s,l=s+1,E(this,a,this._samples,e,s,l,r),r}var m=t(a,e,o.compare,this._dateColumn);return m>=0?(m<a.length-1&&a[m+1].equals(e)&&++m,s=m,l=m):(l=~m,s=l-1,0>s&&(s=0)),this._lastIndex=s,E(this,a,this._samples,e,s,l,r),r}if(n(this._dataError))throw new c(this._dataError)},h}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var a=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,o),n.pitch=-Math.asin(a),n},i.fromDegrees=function(e,a,o,u){if(!t(e))throw new r("heading is required");if(!t(a))throw new r("pitch is required");if(!t(o))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=a*n.RADIANS_PER_DEGREE,u.roll=o*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){return t(e)?t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,a){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,a)&&n.equalsEpsilon(e.pitch,r.pitch,i,a)&&n.equalsEpsilon(e.roll,r.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],function(e,t,r,n,i){"use strict";function a(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),i=d.exec(n);if(null!==i)return i[1]}}function o(t){return"undefined"==typeof document?t:(e(f)||(f=document.createElement("a")),f.href=t,f.href=f.href,f.href)}function u(){if(e(h))return h;var u;if(u="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",l("Core/buildModuleUrl.js")):a(),!e(u))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return h=new n({url:o(u)}),h.appendForwardSlash(),h}function s(e){return o(i.toUrl("../"+e))}function c(e){var t=u().getDerivedResource({url:e});return t.url}function l(t){e(p)||(p=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?s:c);var r=p(t);return r}var f,h,p,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return l._cesiumScriptRegex=d,l._buildModuleUrlFromBaseUrl=c,l._clearBaseResource=function(){h=void 0},l.setBaseUrl=function(e){h=n.DEFAULT.getDerivedResource({url:e})},l.getCesiumBaseUrl=u,l}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,i,a,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=o.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;t>=c;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var l=0;t>=l;++l)l!==c&&(n[c]*=c-l);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=f;return n.dayNumber=t,n.secondsOfDay=r,a.daysDifference(n,e._sampleZeroDateTT)}function l(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var a=e.defer();r._chunkDownloadsInProgress[i]=a;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.getDerivedResource({templateValues:{0:i}}):new o({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(u.fetchJson(),function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,o=i*r._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)t[o+u]=n[u];a.resolve()}),a.promise}var f=new a(0,0,u.TAI);return s.prototype.preload=function(t,r,n,i){var a=c(this,t,r),o=c(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,h=s/this._samplesPerXysFile|0,p=[],d=f;h>=d;++d)p.push(l(this,d));return e.all(p)},s.prototype.computeXysRadians=function(e,t,r){var a=c(this,e,t);if(!(0>a)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);0>s&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,s=f-u,0>s&&(s=0));var h=!1,p=this._samples;if(n(p[3*s])||(l(this,s/this._samplesPerXysFile|0),h=!0),n(p[3*f])||(l(this,f/this._samplesPerXysFile|0),h=!0),!h){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var d,y,m=a-s*this._stepSizeDays,E=this._work,v=this._denominators,O=this._coef,w=this._xTable;for(d=0;u>=d;++d)E[d]=m-w[d];for(d=0;u>=d;++d){for(O[d]=1,y=0;u>=y;++y)y!==d&&(O[d]*=E[y]);O[d]*=v[d];var g=3*(s+d);r.x+=O[d]*p[g++],r.y+=O[d]*p[g++],r.s+=O[d]*p[g]}return r}}}},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,i,a,o,u,s,c,l,f,h,p,d,y,m,E,v,O,w){"use strict";var g={},_={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},T={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},b={},R={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},A=new r,S=new r,x=new r;g.localFrameToFixedFrameGenerator=function(e,t){if(!_.hasOwnProperty(e)||!_[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=_[e][t],a=e+t;return u(b[a])?n=b[a]:(n=function(n,a,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new v),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var l=m.sign(n.z);r.unpack(T[e],0,A),"east"!==e&&"west"!==e&&r.multiplyByScalar(A,l,A),r.unpack(T[t],0,S),"east"!==t&&"west"!==t&&r.multiplyByScalar(S,l,S),r.unpack(T[i],0,x),"east"!==i&&"west"!==i&&r.multiplyByScalar(x,l,x)}else{a=o(a,f.WGS84),a.geodeticSurfaceNormal(n,R.up);var h=R.up,p=R.east;p.x=-n.y,p.y=n.x,p.z=0,r.normalize(p,R.east),r.cross(h,p,R.north),r.multiplyByScalar(R.up,-1,R.down),r.multiplyByScalar(R.east,-1,R.west),r.multiplyByScalar(R.north,-1,R.south),A=R[e],S=R[t],x=R[i]}return c[0]=A.x,c[1]=A.y,c[2]=A.z,c[3]=0,c[4]=S.x,c[5]=S.y,c[6]=S.z,c[7]=0,c[8]=x.x,c[9]=x.y,c[10]=x.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},b[a]=n),n},g.eastNorthUpToFixedFrame=g.localFrameToFixedFrameGenerator("east","north"),g.northEastDownToFixedFrame=g.localFrameToFixedFrameGenerator("north","east"),g.northUpEastToFixedFrame=g.localFrameToFixedFrameGenerator("north","up"),g.northWestUpToFixedFrame=g.localFrameToFixedFrameGenerator("north","west");var N=new O,I=new r(1,1,1),M=new v;g.headingPitchRollToFixedFrame=function(e,t,n,i,u){a.typeOf.object("HeadingPitchRoll",t),i=o(i,g.eastNorthUpToFixedFrame);var s=O.fromHeadingPitchRoll(t,N),c=v.fromTranslationQuaternionRotationScale(r.ZERO,s,I,M);return u=i(e,n,u),v.multiply(u,c,u)};var P=new v,C=new E;g.headingPitchRollQuaternion=function(e,t,r,n,i){a.typeOf.object("HeadingPitchRoll",t);var o=g.headingPitchRollToFixedFrame(e,t,r,n,P),u=v.getRotation(o,C);return O.fromRotationMatrix(u,i)};var D=new r(1,1,1),q=new r,U=new v,L=new v,F=new E,B=new O;g.fixedFrameToHeadingPitchRoll=function(e,t,n,i){a.defined("transform",e),t=o(t,f.WGS84),n=o(n,g.eastNorthUpToFixedFrame),u(i)||(i=new h);var s=v.getTranslation(e,q);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=v.inverseTransformation(n(s,t,U),U),l=v.setScale(e,D,L);l=v.setTranslation(l,r.ZERO,l),c=v.multiply(c,l,c);var p=O.fromRotationMatrix(v.getRotation(c,F),B);return p=O.normalize(p,p),h.fromQuaternion(p,i)};var j=24110.54841,z=8640184.812866,G=.093104,V=-62e-7,W=1.1772758384668e-19,k=72921158553e-15,X=m.TWO_PI/86400,H=new y;g.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");H=y.addSeconds(e,-y.computeTaiMinusUtc(e),H);var r,n=H.dayNumber,i=H.secondsOfDay,a=n-2451545;r=i>=43200?(a+.5)/w.DAYS_PER_JULIAN_CENTURY:(a-.5)/w.DAYS_PER_JULIAN_CENTURY;var o=j+r*(z+r*(G+r*V)),c=o*X%m.TWO_PI,l=k+W*(n-2451545.5),f=(i+.5*w.SECONDS_PER_DAY)%w.SECONDS_PER_DAY,h=c+l*f,p=Math.cos(h),d=Math.sin(h);return u(t)?(t[0]=p,t[1]=-d,t[2]=0,t[3]=d,t[4]=p,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(p,d,0,-d,p,0,0,0,1)},g.iau2006XysData=new p,g.earthOrientationParameters=c.NONE;var Y=32.184,Z=2451545;g.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+Y,i=t.stop.dayNumber,a=t.stop.secondsOfDay+Y,o=g.iau2006XysData.preload(r,n,i,a),u=g.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},g.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=g.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var K=new d(0,0,0),J=new l(0,0,0,0,0,0),Q=new E,$=new E;g.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=g.earthOrientationParameters.compute(e,J);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+Y,a=g.iau2006XysData.computeXysRadians(n,i,K);if(u(a)){var o=a.x+r.xPoleOffset,c=a.y+r.yPoleOffset,l=1/(1+Math.sqrt(1-o*o-c*c)),f=Q;f[0]=1-l*o*o,f[3]=-l*o*c,f[6]=o,f[1]=-l*o*c,f[4]=1-l*c*c,f[7]=c,f[2]=-o,f[5]=-c,f[8]=1-l*(o*o+c*c);var h=E.fromRotationZ(-a.s,$),p=E.multiply(f,h,Q),d=e.dayNumber,v=e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc,O=d-2451545,_=v/w.SECONDS_PER_DAY,T=.779057273264+_+.00273781191135448*(O+_);T=T%1*m.TWO_PI;var b=E.fromRotationZ(T,$),R=E.multiply(p,b,Q),A=Math.cos(r.xPoleWander),S=Math.cos(r.yPoleWander),x=Math.sin(r.xPoleWander),N=Math.sin(r.yPoleWander),I=n-Z+i/w.SECONDS_PER_DAY;I/=36525;var M=-47e-6*I*m.RADIANS_PER_DEGREE/3600,P=Math.cos(M),C=Math.sin(M),D=$;return D[0]=A*P,D[1]=A*C,D[2]=x,D[3]=-S*C+N*x*P,D[4]=S*P+N*x*C,D[5]=-N*A,D[6]=-N*C-S*x*P,D[7]=N*P-S*x*C,D[8]=S*A,E.multiply(R,D,t)}}};var ee=new n;g.pointToWindowCoordinates=function(e,t,r,n){return n=g.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},g.pointToGLWindowCoordinates=function(e,r,i,a){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(a)||(a=new t);var o=ee;return v.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,o),o),n.multiplyByScalar(o,1/o.w,o),v.multiplyByVector(r,o,o),t.fromCartesian4(o,a)};var te=new r,re=new r,ne=new r;g.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var a=o(n,f.WGS84).geodeticSurfaceNormal(e,te),c=r.cross(t,a,re);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var l=r.cross(c,t,ne);return r.normalize(l,l),r.cross(t,l,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new E),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=l.x,i[7]=l.y,i[8]=l.z,i};var ie=new v(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),ae=new i,oe=new r,ue=new r,se=new E,ce=new v,le=new v;return g.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=v.getTranslation(t,ue),a=e.ellipsoid,o=a.cartesianToCartographic(i,ae),c=e.project(o,oe);r.fromElements(c.z,c.x,c.y,c);var l=g.eastNorthUpToFixedFrame(i,a,ce),f=v.inverseTransformation(l,le),h=v.getRotation(t,se),p=v.multiplyByMatrix3(f,h,n);return v.multiply(ie,p,n),v.setTranslation(n,c,n),n},g.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,a=g.eastNorthUpToFixedFrame(t,i,ce),o=v.inverseTransformation(a,le),c=i.cartesianToCartographic(t,ae),l=e.project(c,oe);r.fromElements(l.z,l.x,l.y,l);var f=v.fromTranslation(l,ce);return v.multiply(ie,o,n),v.multiply(f,n,n),n},g.buildUp=function(e,t){var n=t.clone(),i=e.clone();i=r.normalize(i,i),Math.abs(r.dot(i,n))>=1&&(i=Math.abs(r.dot(n,r.UNIT_Y))<1?r.clone(r.UNIT_Y,i):r.clone(r.UNIT_Z,i));var a=new r;return r.cross(i,n,a),a=r.normalize(a,a),r.cross(n,a,i),i=r.normalize(i,i)},g.getHeading=function(e,t){var r;return r=m.equalsEpsilon(Math.abs(e.z),1,m.EPSILON3)?Math.atan2(t.y,t.x)-m.PI_OVER_TWO:Math.atan2(e.y,e.x)-m.PI_OVER_TWO,m.TWO_PI-m.zeroToTwoPi(r)},g}),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],function(e,t,r,n,i,a,o,u,s,c,l,f,h,p,d,y){"use strict";function m(e){e=i(e,i.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=i(e.primitiveType,h.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=i(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}m.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&a(e.attributes[r])&&a(e.attributes[r].values)){var i=e.attributes[r],u=i.values.length/i.componentsPerAttribute;if(t!==u&&-1!==t)throw new o("All attribute lists must have the same number of attributes.");t=u}return t};var E=new r,v=new t,O=new f,w=[new r,new r,new r],g=[new e,new e,new e],_=[new e,new e,new e],T=new t,b=new p,R=new f,A=new c;return m._textureCoordinateRotationPoints=function(n,i,a,o){var u,s=d.center(o,E),h=r.toCartesian(s,a,v),m=y.eastNorthUpToFixedFrame(h,a,O),S=f.inverse(m,O),x=g,N=w;N[0].longitude=o.west,N[0].latitude=o.south,N[1].longitude=o.west,N[1].latitude=o.north,N[2].longitude=o.east,N[2].latitude=o.south;var I=T;for(u=0;3>u;u++)r.toCartesian(N[u],a,I),I=f.multiplyByPointAsVector(S,I,I),x[u].x=I.x,x[u].y=I.y;var M=p.fromAxisAngle(t.UNIT_Z,-i,b),P=l.fromQuaternion(M,R),C=n.length,D=Number.POSITIVE_INFINITY,q=Number.POSITIVE_INFINITY,U=Number.NEGATIVE_INFINITY,L=Number.NEGATIVE_INFINITY;for(u=0;C>u;u++)I=f.multiplyByPointAsVector(S,n[u],I),I=l.multiplyByVector(P,I,I),D=Math.min(D,I.x),q=Math.min(q,I.y),U=Math.max(U,I.x),L=Math.max(L,I.y);var F=c.fromRotation(i,A),B=_;B[0].x=D,B[0].y=q,B[1].x=D,B[1].y=L,B[2].x=U,B[2].y=q;var j=x[0],z=x[2].x-j.x,G=x[1].y-j.y;for(u=0;3>u;u++){var V=B[u];c.multiplyByVector(F,V,V),V.x=(V.x-j.x)/z,V.y=(V.y-j.y)/G}var W=B[0],k=B[1],X=B[2],H=new Array(6);return e.pack(W,H),e.pack(k,H,2),e.pack(X,H,4),H},m}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");
if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],function(e,t,r,n,i,a){"use strict";function o(e){return h[0]=e,h[0]}function u(e){return e>>1^-(1&e)}var s=1/256,c=256,l={};l.octEncodeInRange=function(e,n,o){r.defined("vector",e),r.defined("result",o);var u=t.magnitudeSquared(e);if(Math.abs(u-1)>a.EPSILON6)throw new i("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,c=o.y;o.x=(1-Math.abs(c))*a.signNotZero(s),o.y=(1-Math.abs(s))*a.signNotZero(c)}return o.x=a.toSNorm(o.x,n),o.y=a.toSNorm(o.y,n),o},l.octEncode=function(e,t){return l.octEncodeInRange(e,255,t)};var f=new e,h=new Uint8Array(1);l.octEncodeToCartesian4=function(e,t){return l.octEncodeInRange(e,65535,f),t.x=o(f.x*s),t.y=o(f.x),t.z=o(f.y*s),t.w=o(f.y),t},l.octDecodeInRange=function(e,n,o,u){if(r.defined("result",u),0>e||e>o||0>n||n>o)throw new i("x and y must be unsigned normalized integers between 0 and "+o);if(u.x=a.fromSNorm(e,o),u.y=a.fromSNorm(n,o),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*a.signNotZero(s),u.y=(1-Math.abs(s))*a.signNotZero(u.y)}return t.normalize(u,u)},l.octDecode=function(e,t,r){return l.octDecodeInRange(e,t,255,r)},l.octDecodeFromCartesian4=function(e,t){r.typeOf.object("encoded",e),r.typeOf.object("result",t);var n=e.x,a=e.y,o=e.z,u=e.w;if(0>n||n>255||0>a||a>255||0>o||o>255||0>u||u>255)throw new i("x, y, z, and w must be unsigned normalized integers between 0 and 255");var s=n*c+a,f=o*c+u;return l.octDecodeInRange(s,f,65535,t)},l.octPackFloat=function(e){return r.defined("encoded",e),256*e.x+e.y};var p=new e;return l.octEncodeFloat=function(e){return l.octEncode(e,p),l.octPackFloat(p)},l.octDecodeFloat=function(e,t){r.defined("value",e);var n=e/256,i=Math.floor(n),a=256*(n-i);return l.octDecode(i,a,t)},l.octPack=function(e,t,n,i){r.defined("v1",e),r.defined("v2",t),r.defined("v3",n),r.defined("result",i);var a=l.octEncodeFloat(e),o=l.octEncodeFloat(t),u=l.octEncode(n,p);return i.x=65536*u.x+a,i.y=65536*u.y+o,i},l.octUnpack=function(e,t,n,i){r.defined("packed",e),r.defined("v1",t),r.defined("v2",n),r.defined("v3",i);var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);l.octDecodeFloat(u,t),l.octDecodeFloat(c,n),l.octDecode(o,s,i)},l.compressTextureCoordinates=function(e){r.defined("textureCoordinates",e);var t=4095*e.x|0,n=4095*e.y|0;return 4096*t+n},l.decompressTextureCoordinates=function(e,t){r.defined("compressed",e),r.defined("result",t);var n=e/4096,i=Math.floor(n);return t.x=i/4095,t.y=(e-4096*i)/4095,t},l.zigZagDeltaDecode=function(e,t,i){r.defined("uBuffer",e),r.defined("vBuffer",t),r.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),n(i)&&r.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,i.length);for(var a=e.length,o=0,s=0,c=0,l=0;a>l;++l)o+=u(e[l]),s+=u(t[l]),e[l]=o,t[l]=s,n(i)&&(c+=u(i[l]),i[l]=c)},l.octShortToFloat=function(e){return a.clamp(3051850947599719e-20*e,-1,1)},l.octShortDecode=function(e,n,i){if(r.defined("result",i),i.x=l.octShortToFloat(e),i.y=l.octShortToFloat(n),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){var o=i.x;i.x=(1-Math.abs(i.y))*a.signNotZero(o),i.y=(1-Math.abs(o))*a.signNotZero(i.y)}return t.normalize(i,i)},l}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./Check","./defined","./Math"],function(e,t,r,n,i){"use strict";function a(a,c,l,f,h){r.defined("point",a),r.defined("p0",c),r.defined("p1",l),r.defined("p2",f),n(h)||(h=new t);var p,d,y,m,E,v,O,w;if(n(c.z)){if(t.equalsEpsilon(a,c,i.EPSILON14))return t.clone(t.UNIT_X,h);if(t.equalsEpsilon(a,l,i.EPSILON14))return t.clone(t.UNIT_Y,h);if(t.equalsEpsilon(a,f,i.EPSILON14))return t.clone(t.UNIT_Z,h);p=t.subtract(l,c,o),d=t.subtract(f,c,u),y=t.subtract(a,c,s),m=t.dot(p,p),E=t.dot(p,d),v=t.dot(p,y),O=t.dot(d,d),w=t.dot(d,y)}else{if(e.equalsEpsilon(a,c,i.EPSILON14))return t.clone(t.UNIT_X,h);if(e.equalsEpsilon(a,l,i.EPSILON14))return t.clone(t.UNIT_Y,h);if(e.equalsEpsilon(a,f,i.EPSILON14))return t.clone(t.UNIT_Z,h);p=e.subtract(l,c,o),d=e.subtract(f,c,u),y=e.subtract(a,c,s),m=e.dot(p,p),E=e.dot(p,d),v=e.dot(p,y),O=e.dot(d,d),w=e.dot(d,y)}var g=m*O-E*E,_=1/g;return h.y=(O*v-E*w)*_,h.z=(m*w-E*v)*_,h.x=1-h.y-h.z,h}var o=new t,u=new t,s=new t;return a}),define("Core/EncodedCartesian3",["./Cartesian3","./Check","./defined"],function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,n){t.typeOf.number("value",e),r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){t.typeOf.object("cartesian",e),r(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,r,i){t.defined("cartesianArray",r),t.typeOf.number("index",i),t.typeOf.number.greaterThanOrEquals("index",i,0),n.fromCartesian(e,a);var o=a.high,u=a.low;r[i]=o.x,r[i+1]=o.y,r[i+2]=o.z,r[i+3]=u.x,r[i+4]=u.y,r[i+5]=u.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.fromSizeInBytes=function(e){switch(e){case 2:return a.UNSIGNED_SHORT;case 4:return a.UNSIGNED_INT;case 1:return a.UNSIGNED_BYTE;default:throw new t("Size in bytes cannot be mapped to an IndexDatatype")}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},a.createTypedArrayFromArrayBuffer=function(r,i,a,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)},r(a)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if(o=-a/n,0>o)return[];var c=Math.sqrt(o);return[-c,c]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var l=i*i,f=4*n*a,h=r(l,-f,t.EPSILON14);if(0>h)return[];var p=-.5*r(i,t.sign(i)*Math.sqrt(h),t.EPSILON14);return i>0?[p/n,a/p]:[a/p,p/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,h=u*u,p=s*s,d=o*s-h,y=o*c-u*s,m=u*c-p,E=4*d*m-y*y;if(0>E){var v,O,w;h*f>=l*p?(v=o,O=d,w=-2*u*d+o*y):(v=c,O=m,w=-c*y+2*s*m);var g=0>w?-1:1,_=-g*Math.abs(v)*Math.sqrt(-E);a=-w+_;var T=a/2,b=0>T?-Math.pow(-T,1/3):Math.pow(T,1/3),R=a===_?-b:-O/b;return i=0>=O?b+R:-w/(b*b+R*R+O),h*f>=l*p?[(i-u)/o]:[-c/(i+s)]}var A=d,S=-2*u*d+o*y,x=m,N=-c*y+2*s*m,I=Math.sqrt(E),M=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*I,-S)/3);i=2*Math.sqrt(-A);var C=Math.cos(P);a=i*C;var D=i*(-C/2-M*Math.sin(P)),q=a+D>2*u?a-u:D-u,U=o,L=q/U;P=Math.abs(Math.atan2(c*I,-N)/3),i=2*Math.sqrt(-x),C=Math.cos(P),a=i*C,D=i*(-C/2-M*Math.sin(P));var F=-c,B=2*s>a+D?a+s:D+s,j=F/B,z=U*B,G=-q*B-U*F,V=q*F,W=(s*G-u*V)/(-u*G+s*z);return W>=L?j>=L?j>=W?[L,W,j]:[L,j,W]:[j,L,W]:j>=L?[W,L,j]:j>=W?[W,j,L]:[j,W,L]}var n={};return n.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=t*t,o=r*r,u=n*n,s=i*i,c=18*t*r*n*i+o*u-27*a*s-4*(t*u*n+o*r*i);return c},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return t.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var c=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===o?(u=t.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):r(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):r(n,i,0,o):0===o?(u=t.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):r(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,l=o-a*t/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,p=f[f.length-1];if(Math.abs(p)<r.EPSILON14){var d=n.computeRealRoots(1,s,l);if(2===d.length){var y,m=d[0],E=d[1];if(m>=0&&E>=0){var v=Math.sqrt(m),O=Math.sqrt(E);return[h-O,h-v,h+v,h+O]}if(m>=0&&0>E)return y=Math.sqrt(m),[h-y,h+y];if(0>m&&E>=0)return y=Math.sqrt(E),[h-y,h+y]}return[]}if(p>0){var w=Math.sqrt(p),g=(s+p-c/w)/2,_=(s+p+c/w)/2,T=n.computeRealRoots(1,w,g),b=n.computeRealRoots(1,-w,_);return 0!==T.length?(T[0]+=h,T[1]+=h,0!==b.length?(b[0]+=h,b[1]+=h,T[1]<=b[0]?[T[0],T[1],b[0],b[1]]:b[1]<=T[0]?[b[0],b[1],T[0],T[1]]:T[0]>=b[0]&&T[1]<=b[1]?[b[0],T[0],T[1],b[1]]:b[0]>=T[0]&&b[1]<=T[1]?[T[0],b[0],b[1],T[1]]:T[0]>b[0]&&T[0]<b[1]?[b[0],T[0],b[1],T[1]]:[T[0],b[0],T[1],b[1]]):T):0!==b.length?(b[0]+=h,b[1]+=h,b):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,l=-2*i,f=a*t+s-4*o,h=c*o-a*i*t+u,p=e.computeRealRoots(1,l,f,h);if(p.length>0){var d,y,m=p[0],E=i-m,v=E*E,O=t/2,w=E/2,g=v-4*o,_=v+4*Math.abs(o),T=c-4*m,b=c+4*Math.abs(m);if(0>m||T*_>g*b){var R=Math.sqrt(T);d=R/2,y=0===R?0:(t*w-a)/R}else{var A=Math.sqrt(g);d=0===A?0:(t*w-a)/A,y=A/2}var S,x;0===O&&0===d?(S=0,x=0):r.sign(O)===r.sign(d)?(S=O+d,x=m/S):(x=O-d,S=m/x);var N,I;0===w&&0===y?(N=0,I=0):r.sign(w)===r.sign(y)?(N=w+y,I=o/N):(I=w-y,N=o/I);var M=n.computeRealRoots(1,S,N),P=n.computeRealRoots(1,x,I);if(0!==M.length)return 0!==P.length?M[1]<=P[0]?[M[0],M[1],P[0],P[1]]:P[1]<=M[0]?[P[0],P[1],M[0],M[1]]:M[0]>=P[0]&&M[1]<=P[1]?[P[0],M[0],M[1],P[1]]:P[0]>=M[0]&&P[1]<=M[1]?[M[0],P[0],P[1],M[1]]:M[0]>P[0]&&M[0]<P[1]?[P[0],M[0],P[1],M[1]]:[M[0],P[0],M[1],P[1]]:M;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,u=o*e,s=r*r,c=s*r,l=n*n,f=l*n,h=i*i,p=h*i,d=a*a,y=d*a,m=s*l*h-4*c*p-4*e*f*h+18*e*r*n*p-27*o*h*h+256*u*y+a*(18*c*n*i-4*s*f+16*e*l*l-80*e*r*l*i-6*e*s*h+144*o*n*h)+d*(144*e*s*n-27*s*s-128*o*l-192*o*r*i);return m},o.computeRealRoots=function(n,o,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(o,u,s,c);var l=o/n,f=u/n,h=s/n,p=c/n,d=0>l?1:0;switch(d+=0>f?d+1:d,d+=0>h?d+1:d,d+=0>p?d+1:d){case 0:return i(l,f,h,p);case 1:return a(l,f,h,p);case 2:return a(l,f,h,p);case 3:return i(l,f,h,p);case 4:return i(l,f,h,p);case 5:return a(l,f,h,p);case 6:return i(l,f,h,p);case 7:return i(l,f,h,p);case 8:return a(l,f,h,p);case 9:return i(l,f,h,p);case 10:return i(l,f,h,p);case 11:return a(l,f,h,p);case 12:return i(l,f,h,p);case 13:return i(l,f,h,p);case 14:return i(l,f,h,p);case 15:return i(l,f,h,p);default:return}},o}),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],function(e,t,r,n){"use strict";function i(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return i.clone=function(t,r){return n(t)?n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new i(t.origin,t.direction):void 0},i.getPoint=function(r,i,a){return t.typeOf.object("ray",r),t.typeOf.number("t",i),n(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,i,a,o,u,s,c,l){"use strict";function f(e,t,r,n){var i=t*t-4*e*r;if(!(0>i)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function h(t,r,i){n(i)||(i=new a);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,l=e.subtract(o,s,v),h=e.dot(u,u),p=2*e.dot(u,l),d=e.magnitudeSquared(l)-c,y=f(h,p,d,_);return n(y)?(i.start=y.root0,i.stop=y.root1,i):void 0}function p(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function d(t,r,n,i,a){var l,f=i*i,h=a*a,d=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*h,y=a*(i*p(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),m=t[u.COLUMN0ROW0]*f+t[u.COLUMN2ROW2]*h+i*r.x+n,E=h*p(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),v=a*(i*p(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),O=[];if(0===v&&0===E){if(l=s.computeRealRoots(d,y,m),0===l.length)return O;var w=l[0],g=Math.sqrt(Math.max(1-w*w,0));if(O.push(new e(i,a*w,a*-g)),O.push(new e(i,a*w,a*g)),2===l.length){var _=l[1],T=Math.sqrt(Math.max(1-_*_,0));O.push(new e(i,a*_,a*-T)),O.push(new e(i,a*_,a*T))}return O}var b=v*v,R=E*E,A=d*d,S=v*E,x=A+R,N=2*(y*d+S),I=2*m*d+y*y-R+b,M=2*(m*y-S),P=m*m-b;if(0===x&&0===N&&0===I&&0===M)return O;l=c.computeRealRoots(x,N,I,M,P);var C=l.length;if(0===C)return O;for(var D=0;C>D;++D){var q,U=l[D],L=U*U,F=Math.max(1-L,0),B=Math.sqrt(F);q=o.sign(d)===o.sign(m)?p(d*L+m,y*U,o.EPSILON12):o.sign(m)===o.sign(y*U)?p(d*L,y*U+m,o.EPSILON12):p(d*L+y*U,m,o.EPSILON12);var j=p(E*U,v,o.EPSILON15),z=q*j;0>z?O.push(new e(i,a*U,a*B)):z>0?O.push(new e(i,a*U,a*-B)):0!==B?(O.push(new e(i,a*U,a*-B)),O.push(new e(i,a*U,a*B)),++D):O.push(new e(i,a*U,a*B))}return O}var y={};y.rayPlane=function(t,r,a){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(a)||(a=new e);var u=t.origin,s=t.direction,c=r.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON15)){var f=(-r.distance-e.dot(c,u))/l;if(!(0>f))return a=e.multiplyByScalar(s,f,a),e.add(u,a,a)}};var m=new e,E=new e,v=new e,O=new e,w=new e;y.rayTriangleParametric=function(t,a,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var l,f,h,p,d,y=t.origin,g=t.direction,_=e.subtract(u,a,m),T=e.subtract(s,a,E),b=e.cross(g,T,v),R=e.dot(_,b);if(c){if(R<o.EPSILON6)return;if(l=e.subtract(y,a,O),h=e.dot(l,b),0>h||h>R)return;if(f=e.cross(l,_,w),p=e.dot(g,f),0>p||h+p>R)return;d=e.dot(T,f)/R}else{if(Math.abs(R)<o.EPSILON6)return;var A=1/R;if(l=e.subtract(y,a,O),h=e.dot(l,b)*A,0>h||h>1)return;if(f=e.cross(l,_,w),p=e.dot(g,f)*A,0>p||h+p>1)return;d=e.dot(T,f)*A}return d},y.rayTriangle=function(t,r,i,a,o,u){var s=y.rayTriangleParametric(t,r,i,a,o);if(n(s)&&!(0>s))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var g=new l;y.lineSegmentTriangle=function(t,r,a,o,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(a))throw new i("p0 is required.");if(!n(o))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var l=g;e.clone(t,l.origin),e.subtract(r,t,l.direction),e.normalize(l.direction,l.direction);var f=y.rayTriangleParametric(l,a,o,u,s);return!n(f)||0>f||f>e.distance(t,r)?void 0:(n(c)||(c=new e),e.multiplyByScalar(l.direction,f,c),e.add(l.origin,c,c))};var _={root0:0,root1:0};y.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");return r=h(e,t,r),!n(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var T=new l;y.lineSegmentSphere=function(t,r,a,o){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=T;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);return e.normalize(s,s),o=h(u,a,o),!n(o)||o.stop<0||o.start>c?void 0:(o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,c),o)};var b=new e,R=new e;y.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o,u,s,c,l,f=r.oneOverRadii,h=e.multiplyComponents(f,t.origin,b),p=e.multiplyComponents(f,t.direction,R),d=e.magnitudeSquared(h),y=e.dot(h,p);if(d>1){if(y>=0)return;var m=y*y;if(o=d-1,u=e.magnitudeSquared(p),s=u*o,s>m)return;if(m>s){c=y*y-s,l=-y+Math.sqrt(c);var E=l/u,v=o/l;return v>E?new a(E,v):{start:v,stop:E}}var O=Math.sqrt(o/u);return new a(O,O)}return 1>d?(o=d-1,u=e.magnitudeSquared(p),s=u*o,c=y*y-s,l=-y+Math.sqrt(c),new a(0,l/u)):0>y?(u=e.magnitudeSquared(p),new a(0,-y/u)):void 0};var A=new e,S=new e,x=new e,N=new e,I=new e,M=new u,P=new u,C=new u,D=new u,q=new u,U=new u,L=new u,F=new e,B=new e,j=new t;y.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a=t.origin,s=t.direction;if(!e.equals(a,e.ZERO)){var c=r.geodeticSurfaceNormal(a,A);if(e.dot(s,c)>=0)return a}var l=n(this.rayEllipsoid(t,r)),f=r.transformPositionToScaledSpace(s,A),h=e.normalize(f,f),p=e.mostOrthogonalAxis(f,N),y=e.normalize(e.cross(p,h,S),S),m=e.normalize(e.cross(h,y,x),x),E=M;E[0]=h.x,E[1]=h.y,E[2]=h.z,E[3]=y.x,E[4]=y.y,E[5]=y.z,E[6]=m.x,E[7]=m.y,E[8]=m.z;var v=u.transpose(E,P),O=u.fromScale(r.radii,C),w=u.fromScale(r.oneOverRadii,D),g=q;g[0]=0,g[1]=-s.z,g[2]=s.y,g[3]=s.z,g[4]=0,g[5]=-s.x,g[6]=-s.y,g[7]=s.x,g[8]=0;var _,T,b=u.multiply(u.multiply(v,w,U),g,U),R=u.multiply(u.multiply(b,O,L),E,L),z=u.multiplyByVector(b,a,I),G=d(R,e.negate(z,A),0,0,1),V=G.length;if(V>0){for(var W=e.clone(e.ZERO,B),k=Number.NEGATIVE_INFINITY,X=0;V>X;++X){_=u.multiplyByVector(O,u.multiplyByVector(E,G[X],F),F);var H=e.normalize(e.subtract(_,a,N),N),Y=e.dot(H,s);Y>k&&(k=Y,W=e.clone(_,W))}var Z=r.cartesianToCartographic(W,j);return k=o.clamp(k,0,1),T=e.magnitude(e.subtract(W,a,N))*Math.sqrt(1-k*k),T=l?-T:T,Z.height=T,r.cartographicToCartesian(Z,new e)}};var z=new e;return y.lineSegmentPlane=function(t,r,a,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,z),c=a.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON6)){var f=e.dot(c,t),h=-(a.distance+f)/l;if(!(0>h||h>1))return e.multiplyByScalar(s,h,u),e.add(t,u,u),u}},y.trianglePlaneIntersection=function(t,r,a,o){if(!(n(t)&&n(r)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,c=e.dot(u,t)+s<0,l=e.dot(u,r)+s<0,f=e.dot(u,a)+s<0,h=0;h+=c?1:0,h+=l?1:0,h+=f?1:0;var p,d;if((1===h||2===h)&&(p=new e,d=new e),1===h){if(c)return y.lineSegmentPlane(t,r,o,p),y.lineSegmentPlane(t,a,o,d),{positions:[t,r,a,p,d],indices:[0,3,4,1,2,4,1,4,3]};if(l)return y.lineSegmentPlane(r,a,o,p),y.lineSegmentPlane(r,t,o,d),{positions:[t,r,a,p,d],indices:[1,3,4,2,0,4,2,4,3]};if(f)return y.lineSegmentPlane(a,t,o,p),y.lineSegmentPlane(a,r,o,d),{positions:[t,r,a,p,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!c)return y.lineSegmentPlane(r,t,o,p),y.lineSegmentPlane(a,t,o,d),{positions:[t,r,a,p,d],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return y.lineSegmentPlane(a,r,o,p),y.lineSegmentPlane(t,r,o,d),{positions:[t,r,a,p,d],indices:[2,0,4,2,4,3,1,3,4]};if(!f)return y.lineSegmentPlane(t,a,o,p),y.lineSegmentPlane(r,a,o,d),{positions:[t,r,a,p,d],indices:[0,1,4,0,4,3,2,3,4]}}},y}),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],function(e,t,r,n,i,a,o){"use strict";function u(r,i){if(t.typeOf.object("normal",r),!a.equalsEpsilon(e.magnitude(r),1,a.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",i),this.normal=e.clone(r),this.distance=i}u.fromPointNormal=function(i,o,s){if(t.typeOf.object("point",i),t.typeOf.object("normal",o),!a.equalsEpsilon(e.magnitude(o),1,a.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(o,i);return r(s)?(e.clone(o,s.normal),s.distance=c,s):new u(o,c)};var s=new e;u.fromCartesian4=function(i,o){t.typeOf.object("coefficients",i);var c=e.fromCartesian4(i,s),l=i.w;if(!a.equalsEpsilon(e.magnitude(c),1,a.EPSILON6))throw new n("normal must be normalized.");return r(o)?(e.clone(c,o.normal),o.distance=l,o):new u(c,l)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,i,a){t.typeOf.object("plane",n),t.typeOf.object("point",i),r(a)||(a=new e);var o=u.getPointDistance(n,i),s=e.multiplyByScalar(n.normal,o,c);return e.subtract(i,s,a)};var l=new e;return u.transform=function(r,n,i){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),o.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,l),o.multiplyByPoint(n,l,l),u.fromPointNormal(l,s,i)},u.clone=function(n,i){return t.typeOf.object("plane",n),r(i)?(e.clone(n.normal,i.normal),i.distance=n.distance,i):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=i(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=i(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=i(new u(e.UNIT_Y,0)),u}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var u=i.length;if(3>u||u%3!==0)throw new r("indices length must be a multiple of three.");if(0>=a)throw new r("maximumIndex must be greater than zero.");if(3>o)throw new r("cacheSize must be greater than two.");if(!t(a)){a=0;for(var s=0,c=i[s];u>s;)c>a&&(a=c),++s,c=i[s]}for(var l=[],f=0;a+1>f;f++)l[f]=0;for(var h=o+1,p=0;u>p;++p)h-l[i[p]]>o&&(l[i[p]]=h,++h);return(h-o+1)/(u/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>o;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,t,r,n,a,o,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var h=r[f];n[h].numLiveTriangles&&(s=0,a-n[h].timeStamp+2*n[h].numLiveTriangles<=t&&(s=a-n[h].timeStamp),(s>l||-1===l)&&(l=s,c=h)),++f}return-1===c?i(n,o,e,u):c}n=e(n,e.EMPTY_OBJECT);var o,u=n.indices,s=n.maximumIndex,c=e(n.cacheSize,24);if(!t(u))throw new r("indices is required.");var l=u.length;if(3>l||l%3!==0)throw new r("indices length must be a multiple of three.");if(0>=s)throw new r("maximumIndex must be greater than zero.");if(3>c)throw new r("cacheSize must be greater than two.");var f=0,h=0,p=u[h],d=l;if(t(s))f=s+1;else{for(;d>h;)p>f&&(f=p),++h,p=u[h];if(-1===f)return 0;++f}var y,m=[];for(y=0;f>y;y++)m[y]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var E=0;d>h;)m[u[h]].vertexTriangles.push(E),++m[u[h]].numLiveTriangles,m[u[h+1]].vertexTriangles.push(E),++m[u[h+1]].numLiveTriangles,m[u[h+2]].vertexTriangles.push(E),++m[u[h+2]].numLiveTriangles,++E,h+=3;var v=0,O=c+1;o=1;var w,g,_=[],T=[],b=0,R=[],A=l/3,S=[];for(y=0;A>y;y++)S[y]=!1;for(var x,N;-1!==v;){_=[],g=m[v],N=g.vertexTriangles.length;for(var I=0;N>I;++I)if(E=g.vertexTriangles[I],!S[E]){S[E]=!0,h=E+E+E;for(var M=0;3>M;++M)x=u[h],_.push(x),T.push(x),R[b]=x,++b,w=m[x],--w.numLiveTriangles,O-w.timeStamp>c&&(w.timeStamp=O,++O),++h}v=a(u,c,_,m,O,T,f)}return R},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,i,a,o,u,s,c,l,f,h,p,d,y,m,E,v,O,w,g,_,T,b){"use strict";function R(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function A(e){for(var t=e.length,r=t/3*6,n=m.createTypedArray(t,r),i=0,a=0;t>a;a+=3,i+=6)R(n,i,e[a],e[a+1],e[a+2]);return n}function S(e){var t=e.length;if(t>=3){var r=6*(t-2),n=m.createTypedArray(t,r);R(n,0,e[0],e[1],e[2]);for(var i=6,a=3;t>a;++a,i+=6)R(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function x(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=m.createTypedArray(t,r),i=e[0],a=0,o=1;t>o;++o,a+=6)R(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function N(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function I(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var i=t[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[r*i.componentsPerAttribute+a])}function M(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;n>a;a+=3)i.unpack(r,a,se),g.multiplyByPoint(e,se,se),i.pack(se,r,a)}function P(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;n>a;a+=3)i.unpack(r,a,se),w.multiplyByVector(e,se,se),se=i.normalize(se,se),i.pack(se,r,a)}function C(e,t){var r,n=e.length,i={},a=e[0][t].attributes;for(r in a)if(a.hasOwnProperty(r)&&c(a[r])&&c(a[r].values)){for(var o=a[r],s=o.values.length,l=!0,f=1;n>f;++f){var h=e[f][t].attributes[r];if(!c(h)||o.componentDatatype!==h.componentDatatype||o.componentsPerAttribute!==h.componentsPerAttribute||o.normalize!==h.normalize){l=!1;break}s+=h.values.length}l&&(i[r]=new d({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}function D(e,t){var n,a,o,u,s=e.length,f=e[0].modelMatrix,h=c(e[0][t].indices),d=e[0][t].primitiveType;for(a=1;s>a;++a){if(!g.equals(e[a].modelMatrix,f))throw new l("All instances must have the same modelMatrix.");if(c(e[a][t].indices)!==h)throw new l("All instance geometries must have an indices or not have one.");if(e[a][t].primitiveType!==d)throw new l("All instance geometries must have the same primitiveType.")}var y,E,v,O=C(e,t);for(n in O)if(O.hasOwnProperty(n))for(y=O[n].values,u=0,a=0;s>a;++a)for(E=e[a][t].attributes[n].values,v=E.length,o=0;v>o;++o)y[u++]=E[o];var w;if(h){var _=0;for(a=0;s>a;++a)_+=e[a][t].indices.length;var b=p.computeNumberOfVertices(new p({attributes:O,primitiveType:T.POINTS})),R=m.createTypedArray(b,_),A=0,S=0;for(a=0;s>a;++a){var x=e[a][t].indices,N=x.length;for(u=0;N>u;++u)R[A++]=S+x[u];S+=p.computeNumberOfVertices(e[a][t])}w=R}var I,M=new i,P=0;for(a=0;s>a;++a){if(I=e[a][t].boundingSphere,!c(I)){M=void 0;break}i.add(I.center,M,M)}if(c(M))for(i.divideByScalar(M,s,M),a=0;s>a;++a){I=e[a][t].boundingSphere;var D=i.magnitude(i.subtract(I.center,M,fe))+I.radius;D>P&&(P=D)}return new p({attributes:O,indices:w,primitiveType:d,boundingSphere:c(M)?new r(M,P):void 0})}function q(e){if(c(e.indices))return e;var t=p.computeNumberOfVertices(e);if(3>t)throw new l("The number of vertices must be at least three.");if(t%3!==0)throw new l("The number of vertices must be a multiple of three.");for(var r=m.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function U(e){var t=p.computeNumberOfVertices(e);if(3>t)throw new l("The number of vertices must be at least three.");var r=m.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,i=3;t>i;++i)r[n++]=i-1,r[n++]=0,r[n++]=i;return e.indices=r,e.primitiveType=T.TRIANGLES,e}function L(e){var t=p.computeNumberOfVertices(e);if(3>t)throw new l("The number of vertices must be at least 3.");var r=m.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,i=3;t-1>i;i+=2)r[n++]=i,r[n++]=i-1,r[n++]=i+1,t>i+2&&(r[n++]=i,r[n++]=i+1,r[n++]=i+2);return e.indices=r,e.primitiveType=T.TRIANGLES,e}function F(e){if(c(e.indices))return e;var t=p.computeNumberOfVertices(e);if(2>t)throw new l("The number of vertices must be at least two.");if(t%2!==0)throw new l("The number of vertices must be a multiple of 2.");for(var r=m.createTypedArray(t,t),n=0;t>n;++n)r[n]=n;return e.indices=r,e}function B(e){var t=p.computeNumberOfVertices(e);if(2>t)throw new l("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,i=2;t>i;++i)r[n++]=i-1,r[n++]=i;return e.indices=r,e.primitiveType=T.LINES,e}function j(e){var t=p.computeNumberOfVertices(e);if(2>t)throw new l("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,i=2;t>i;++i)r[n++]=i-1,r[n++]=i;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=T.LINES,e}function z(e){switch(e.primitiveType){case T.TRIANGLE_FAN:return U(e);case T.TRIANGLE_STRIP:return L(e);case T.TRIANGLES:return q(e);case T.LINE_STRIP:return B(e);case T.LINE_LOOP:return j(e);case T.LINES:return F(e)}return e}function G(e,t){Math.abs(e.y)<O.EPSILON6&&(t?e.y=-O.EPSILON6:e.y=O.EPSILON6)}function V(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return G(e,e.y<0),G(t,t.y<0),void G(r,r.y<0);var n,i=Math.abs(e.y),a=Math.abs(t.y),o=Math.abs(r.y);n=i>a?i>o?O.sign(e.y):O.sign(r.y):a>o?O.sign(t.y):O.sign(r.y);var u=0>n;G(e,u),G(t,u),G(r,u)}function W(e,t,r,n){i.add(e,i.multiplyByScalar(i.subtract(t,e,be),e.y/(e.y-t.y),be),r),i.clone(r,n),G(r,!0),G(n,!1)}function k(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){V(e,t,r);var n=e.y<0,i=t.y<0,a=r.y<0,o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=Ne.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(W(e,t,Re,Se),W(e,r,Ae,xe),u[0]=0,
u[3]=1,u[4]=2,u[6]=1):i?(W(t,r,Re,Se),W(t,e,Ae,xe),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(W(r,e,Re,Se),W(r,t,Ae,xe),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(W(r,e,Re,Se),W(r,t,Ae,xe),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(W(t,r,Re,Se),W(t,e,Ae,xe),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(W(e,t,Re,Se),W(e,r,Ae,xe),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ne.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,(1===o||2===o)&&(s[3]=Re,s[4]=Ae,s[5]=Se,s[6]=xe,s.length=7),Ne}}function X(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var a=n[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=p.computeNumberOfVertices(e);return e.indices=m.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function H(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var i=t[n];r[n]=new d({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new p({attributes:r,indices:[],primitiveType:e.primitiveType})}function Y(e,t,r){var n=c(e.geometry.boundingSphere);t=X(t,n),r=X(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function Z(e,t){var r=new e,n=new e,i=new e;return function(a,o,u,s,c,l,f,h){var p=e.fromArray(c,a*t,r),d=e.fromArray(c,o*t,n),y=e.fromArray(c,u*t,i);e.multiplyByScalar(p,s.x,p),e.multiplyByScalar(d,s.y,d),e.multiplyByScalar(y,s.z,y);var m=e.add(p,d,p);e.add(m,y,m),h&&e.normalize(m,m),e.pack(m,l,f*t)}}function K(e,r,n,a,o,u,s,l,f,h,p,d,y,m,E,v){if(c(u)||c(s)||c(l)||c(f)||c(h)||0!==m){var O=i.fromArray(o,3*e,De),w=i.fromArray(o,3*r,qe),g=i.fromArray(o,3*n,Ue),_=t(a,O,w,g,Le);if(c(u)&&Me(e,r,n,_,u,d.normal.values,v,!0),c(h)){var T=i.fromArray(h,3*e,De),b=i.fromArray(h,3*r,qe),R=i.fromArray(h,3*n,Ue);i.multiplyByScalar(T,_.x,T),i.multiplyByScalar(b,_.y,b),i.multiplyByScalar(R,_.z,R);var A;i.equals(T,i.ZERO)&&i.equals(b,i.ZERO)&&i.equals(R,i.ZERO)?(A=De,A.x=0,A.y=0,A.z=0):(A=i.add(T,b,T),i.add(A,R,A),i.normalize(A,A)),i.pack(A,d.extrudeDirection.values,3*v)}if(c(p)&&Ce(e,r,n,_,p,d.applyOffset.values,v),c(s)&&Me(e,r,n,_,s,d.tangent.values,v,!0),c(l)&&Me(e,r,n,_,l,d.bitangent.values,v,!0),c(f)&&Pe(e,r,n,_,f,d.st.values,v),m>0)for(var S=0;m>S;S++){var x=y[S];J(e,r,n,_,v,E[x],d[x])}}}function J(e,t,r,n,i,a,o){var u=a.componentsPerAttribute,s=a.values,c=o.values;switch(u){case 4:Ie(e,t,r,n,s,c,i,!1);break;case 3:Me(e,t,r,n,s,c,i,!1);break;case 2:Pe(e,t,r,n,s,c,i,!1);break;default:c[i]=s[e]*n.x+s[t]*n.y+s[r]*n.z}}function Q(e,t,r,n,i,a){var o=e.position.values.length/3;if(-1!==i){var u=n[i],s=r[u];return-1===s?(r[u]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}function $(e){var t=e.geometry,r=t.attributes,n=r.position.values,a=c(r.normal)?r.normal.values:void 0,o=c(r.bitangent)?r.bitangent.values:void 0,u=c(r.tangent)?r.tangent.values:void 0,s=c(r.st)?r.st.values:void 0,l=c(r.extrudeDirection)?r.extrudeDirection.values:void 0,f=c(r.applyOffset)?r.applyOffset.values:void 0,h=t.indices,p=[];for(var d in r)r.hasOwnProperty(d)&&!Fe[d]&&c(r[d])&&p.push(d);var y,m,E,v,O,w=p.length,g=H(t),_=H(t),T=[];T.length=n.length/3;var b=[];for(b.length=n.length/3,O=0;O<T.length;++O)T[O]=-1,b[O]=-1;var R=h.length;for(O=0;R>O;O+=3){var A=h[O],S=h[O+1],x=h[O+2],N=i.fromArray(n,3*A),I=i.fromArray(n,3*S),M=i.fromArray(n,3*x),P=k(N,I,M);if(c(P)&&P.positions.length>3)for(var C=P.positions,D=P.indices,q=D.length,U=0;q>U;++U){var L=D[U],F=C[L];F.y<0?(y=_.attributes,m=_.indices,E=T):(y=g.attributes,m=g.indices,E=b),v=Q(y,m,E,h,3>L?O+L:-1,F),K(A,S,x,F,n,a,u,o,s,l,f,y,p,w,r,v)}else c(P)&&(N=P.positions[0],I=P.positions[1],M=P.positions[2]),N.y<0?(y=_.attributes,m=_.indices,E=T):(y=g.attributes,m=g.indices,E=b),v=Q(y,m,E,h,O,N),K(A,S,x,N,n,a,u,o,s,l,f,y,p,w,r,v),v=Q(y,m,E,h,O+1,I),K(A,S,x,I,n,a,u,o,s,l,f,y,p,w,r,v),v=Q(y,m,E,h,O+2,M),K(A,S,x,M,n,a,u,o,s,l,f,y,p,w,r,v)}Y(e,_,g)}function ee(e,t,r,n,a,o,u){if(c(u)){var s=i.fromArray(n,3*e,De);i.equalsEpsilon(s,r,O.EPSILON10)?o.applyOffset.values[a]=u[e]:o.applyOffset.values[a]=u[t]}}function te(e){var t,r=e.geometry,n=r.attributes,a=n.position.values,o=c(n.applyOffset)?n.applyOffset.values:void 0,u=r.indices,s=H(r),l=H(r),f=u.length,h=[];h.length=a.length/3;var p=[];for(p.length=a.length/3,t=0;t<h.length;++t)h[t]=-1,p[t]=-1;for(t=0;f>t;t+=2){var d,y=u[t],m=u[t+1],E=i.fromArray(a,3*y,De),w=i.fromArray(a,3*m,qe);Math.abs(E.y)<O.EPSILON6&&(E.y<0?E.y=-O.EPSILON6:E.y=O.EPSILON6),Math.abs(w.y)<O.EPSILON6&&(w.y<0?w.y=-O.EPSILON6:w.y=O.EPSILON6);var g=s.attributes,_=s.indices,T=p,b=l.attributes,R=l.indices,A=h,S=v.lineSegmentPlane(E,w,Be,Ue);if(c(S)){var x=i.multiplyByScalar(i.UNIT_Y,5*O.EPSILON9,je);E.y<0&&(i.negate(x,x),g=l.attributes,_=l.indices,T=h,b=s.attributes,R=s.indices,A=p);var N=i.add(S,x,ze);d=Q(g,_,T,u,t,E),ee(y,m,E,a,d,g,o),d=Q(g,_,T,u,-1,N),ee(y,m,N,a,d,g,o),i.negate(x,x),i.add(S,x,N),d=Q(b,R,A,u,-1,N),ee(y,m,N,a,d,b,o),d=Q(b,R,A,u,t+1,w),ee(y,m,w,a,d,b,o)}else{var I,M,P;E.y<0?(I=l.attributes,M=l.indices,P=h):(I=s.attributes,M=s.indices,P=p),d=Q(I,M,P,u,t,E),ee(y,m,E,a,d,I,o),d=Q(I,M,P,u,t+1,w),ee(y,m,w,a,d,I,o)}}Y(e,l,s)}function re(e){for(var t=e.attributes,r=t.position.values,n=t.prevPosition.values,a=t.nextPosition.values,o=r.length,u=0;o>u;u+=3){var s=i.unpack(r,u,We);if(!(s.x>0)){var c=i.unpack(n,u,ke);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(n[u]=r[u-3],n[u+1]=r[u-2],n[u+2]=r[u-1]):i.pack(s,n,u));var l=i.unpack(a,u,Xe);(s.y<0&&l.y>0||s.y>0&&l.y<0)&&(o>u+3?(a[u]=r[u+3],a[u+1]=r[u+4],a[u+2]=r[u+5]):i.pack(s,a,u))}}}function ne(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,h=s.nextPosition.values,p=s.expandAndWidth.values,d=c(s.st)?s.st.values:void 0,y=c(s.color)?s.color.values:void 0,m=c(s.dist)?s.dist.values:void 0,E=H(u),w=H(u),g=!1,_=l.length/3;for(t=0;_>t;t+=4){var T=t,b=t+2,R=i.fromArray(l,3*T,We),A=i.fromArray(l,3*b,ke);if(Math.abs(R.y)<$e)for(R.y=$e*(A.y<0?-1:1),l[3*t+1]=R.y,l[3*(t+1)+1]=R.y,r=3*T;3*T+12>r;r+=3)f[r]=l[3*t],f[r+1]=l[3*t+1],f[r+2]=l[3*t+2];if(Math.abs(A.y)<$e)for(A.y=$e*(R.y<0?-1:1),l[3*(t+2)+1]=A.y,l[3*(t+3)+1]=A.y,r=3*T;3*T+12>r;r+=3)h[r]=l[3*(t+2)],h[r+1]=l[3*(t+2)+1],h[r+2]=l[3*(t+2)+2];var S=E.attributes,x=E.indices,N=w.attributes,I=w.indices,M=v.lineSegmentPlane(R,A,Be,He);if(c(M)){g=!0;var P=i.multiplyByScalar(i.UNIT_Y,Qe,Ye);R.y<0&&(i.negate(P,P),S=w.attributes,x=w.indices,N=E.attributes,I=E.indices);var C=i.add(M,P,Ze);S.position.values.push(R.x,R.y,R.z,R.x,R.y,R.z),S.position.values.push(C.x,C.y,C.z),S.position.values.push(C.x,C.y,C.z),S.prevPosition.values.push(f[3*T],f[3*T+1],f[3*T+2]),S.prevPosition.values.push(f[3*T+3],f[3*T+4],f[3*T+5]),S.prevPosition.values.push(R.x,R.y,R.z,R.x,R.y,R.z),S.nextPosition.values.push(C.x,C.y,C.z),S.nextPosition.values.push(C.x,C.y,C.z),S.nextPosition.values.push(C.x,C.y,C.z),S.nextPosition.values.push(C.x,C.y,C.z),i.negate(P,P),i.add(M,P,C),N.position.values.push(C.x,C.y,C.z),N.position.values.push(C.x,C.y,C.z),N.position.values.push(A.x,A.y,A.z,A.x,A.y,A.z),N.prevPosition.values.push(C.x,C.y,C.z),N.prevPosition.values.push(C.x,C.y,C.z),N.prevPosition.values.push(C.x,C.y,C.z),N.prevPosition.values.push(C.x,C.y,C.z),N.nextPosition.values.push(A.x,A.y,A.z,A.x,A.y,A.z),N.nextPosition.values.push(h[3*b],h[3*b+1],h[3*b+2]),N.nextPosition.values.push(h[3*b+3],h[3*b+4],h[3*b+5]);var D=n.fromArray(p,2*T,Ge),q=Math.abs(D.y);S.expandAndWidth.values.push(-1,q,1,q),S.expandAndWidth.values.push(-1,-q,1,-q),N.expandAndWidth.values.push(-1,q,1,q),N.expandAndWidth.values.push(-1,-q,1,-q);var U=i.magnitudeSquared(i.subtract(M,R,Xe));if(U/=i.magnitudeSquared(i.subtract(A,R,Xe)),c(y)){var L=a.fromArray(y,4*T,Je),F=a.fromArray(y,4*b,Je),B=O.lerp(L.x,F.x,U),j=O.lerp(L.y,F.y,U),z=O.lerp(L.z,F.z,U),G=O.lerp(L.w,F.w,U);for(r=4*T;4*T+8>r;++r)S.color.values.push(y[r]);for(S.color.values.push(B,j,z,G),S.color.values.push(B,j,z,G),N.color.values.push(B,j,z,G),N.color.values.push(B,j,z,G),r=4*b;4*b+8>r;++r)N.color.values.push(y[r])}if(c(d)){var V=n.fromArray(d,2*T,Ge),W=n.fromArray(d,2*(t+3),Ve),k=O.lerp(V.x,W.x,U);for(r=2*T;2*T+4>r;++r)S.st.values.push(d[r]);for(S.st.values.push(k,V.y),S.st.values.push(k,W.y),N.st.values.push(k,V.y),N.st.values.push(k,W.y),r=2*b;2*b+4>r;++r)N.st.values.push(d[r])}if(c(m)){var X=i.fromArray(m,3*T,Ke),Z=i.fromArray(m,3*b,Ke),K=O.lerp(X.x,Z.x,U);for(r=3*T;3*T+6>r;++r)S.dist.values.push(m[r]);for(S.dist.values.push(K,X.y,X.z),S.dist.values.push(K,X.y,X.z),N.dist.values.push(K,Z.y,Z.z),N.dist.values.push(K,Z.y,Z.z),r=3*b;3*b+6>r;++r)N.dist.values.push(m[r])}o=S.position.values.length/3-4,x.push(o,o+2,o+1),x.push(o+1,o+2,o+3),o=N.position.values.length/3-4,I.push(o,o+2,o+1),I.push(o+1,o+2,o+3)}else{var J,Q;for(R.y<0?(J=w.attributes,Q=w.indices):(J=E.attributes,Q=E.indices),J.position.values.push(R.x,R.y,R.z),J.position.values.push(R.x,R.y,R.z),J.position.values.push(A.x,A.y,A.z),J.position.values.push(A.x,A.y,A.z),r=3*t;3*t+12>r;++r)J.prevPosition.values.push(f[r]),J.nextPosition.values.push(h[r]);for(r=2*t;2*t+8>r;++r)J.expandAndWidth.values.push(p[r]),c(d)&&J.st.values.push(d[r]);if(c(y))for(r=4*t;4*t+16>r;++r)J.color.values.push(y[r]);if(c(m))for(r=3*t;3*t+12>r;++r)J.dist.values.push(m[r]);o=J.position.values.length/3-4,Q.push(o,o+2,o+1),Q.push(o+1,o+2,o+3)}}g&&(re(w),re(E)),Y(e,w,E)}var ie={};ie.toWireframe=function(e){if(!c(e))throw new l("geometry is required.");var t=e.indices;if(c(t)){switch(e.primitiveType){case T.TRIANGLES:e.indices=A(t);break;case T.TRIANGLE_STRIP:e.indices=S(t);break;case T.TRIANGLE_FAN:e.indices=x(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=T.LINES}return e},ie.createLineSegmentsForVectors=function(e,t,n){if(t=s(t,"normal"),!c(e))throw new l("geometry is required.");if(!c(e.attributes.position))throw new l("geometry.attributes.position is required.");if(!c(e.attributes[t]))throw new l("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=s(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,o=i.length,f=new Float64Array(2*o),h=0,y=0;o>y;y+=3)f[h++]=i[y],f[h++]=i[y+1],f[h++]=i[y+2],f[h++]=i[y]+a[y]*n,f[h++]=i[y+1]+a[y+1]*n,f[h++]=i[y+2]+a[y+2]*n;var m,E=e.boundingSphere;return c(E)&&(m=new r(E.center,E.radius+n)),new p({attributes:{position:new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:f})},primitiveType:T.LINES,boundingSphere:m})},ie.createAttributeLocations=function(e){if(!c(e))throw new l("geometry is required.");var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={},a=0,o=r.length;for(t=0;o>t;++t){var u=r[t];c(n[u])&&(i[u]=a++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=a++);return i},ie.reorderForPreVertexCache=function(e){if(!c(e))throw new l("geometry is required.");var t=p.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),i=0;t>i;i++)n[i]=-1;for(var a,o=r,s=o.length,f=m.createTypedArray(t,s),h=0,d=0,y=0;s>h;)a=n[o[h]],-1!==a?f[d]=a:(a=o[h],n[a]=y,f[d]=y,++y),++h,++d;e.indices=f;var E=e.attributes;for(var v in E)if(E.hasOwnProperty(v)&&c(E[v])&&c(E[v].values)){for(var O=E[v],w=O.values,g=0,_=O.componentsPerAttribute,T=u.createTypedArray(O.componentDatatype,y*_);t>g;){var b=n[g];if(-1!==b)for(var R=0;_>R;R++)T[_*b+R]=w[_*g+R];++g}O.values=T}}return e},ie.reorderForPostVertexCache=function(e,t){if(!c(e))throw new l("geometry is required.");var r=e.indices;if(e.primitiveType===T.TRIANGLES&&c(r)){for(var n=r.length,i=0,a=0;n>a;a++)r[a]>i&&(i=r[a]);e.indices=b.tipsify({indices:r,maximumIndex:i,cacheSize:t})}return e},ie.fitToUnsignedShortIndices=function(e){if(!c(e))throw new l("geometry is required.");if(c(e.indices)&&e.primitiveType!==T.TRIANGLES&&e.primitiveType!==T.LINES&&e.primitiveType!==T.POINTS)throw new l("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],r=p.computeNumberOfVertices(e);if(c(e.indices)&&r>=O.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=N(e.attributes),s=e.indices,f=s.length;e.primitiveType===T.TRIANGLES?n=3:e.primitiveType===T.LINES?n=2:e.primitiveType===T.POINTS&&(n=1);for(var h=0;f>h;h+=n){for(var d=0;n>d;++d){var y=s[h+d],m=i[y];c(m)||(m=o++,i[y]=m,I(u,e.attributes,y)),a.push(m)}o+n>=O.SIXTY_FOUR_KILOBYTES&&(t.push(new p({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=N(e.attributes))}0!==a.length&&t.push(new p({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var ae=new i,oe=new o;ie.projectTo2D=function(e,t,r,n,a){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeName3D is required.");if(!c(n))throw new l("attributeName2D is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var o=e.attributes[t];a=c(a)?a:new h;for(var s=a.ellipsoid,f=o.values,p=new Float64Array(f.length),y=0,m=0;m<f.length;m+=3){var E=i.fromArray(f,m,ae),v=s.cartesianToCartographic(E,oe);if(!c(v))throw new l("Could not project point ("+E.x+", "+E.y+", "+E.z+") to 2D.");var O=a.project(v,ae);p[y++]=O.x,p[y++]=O.y,p[y++]=O.z}return e.attributes[r]=o,e.attributes[n]=new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:p}),delete e.attributes[t],e};var ue={high:0,low:0};ie.encodeAttribute=function(e,t,r,n){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeHighName is required.");if(!c(n))throw new l("attributeLowName is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[t],a=i.values,o=a.length,s=new Float32Array(o),h=new Float32Array(o),p=0;o>p;++p)f.encode(a[p],ue),s[p]=ue.high,h[p]=ue.low;var y=i.componentsPerAttribute;return e.attributes[r]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:s}),e.attributes[n]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:h}),delete e.attributes[t],e};var se=new i,ce=new g,le=new w;ie.transformToWorldCoordinates=function(e){if(!c(e))throw new l("instance is required.");var t=e.modelMatrix;if(g.equals(t,g.IDENTITY))return e;var n=e.geometry.attributes;M(t,n.position),M(t,n.prevPosition),M(t,n.nextPosition),(c(n.normal)||c(n.tangent)||c(n.bitangent))&&(g.inverse(t,ce),g.transpose(ce,ce),g.getRotation(ce,le),P(le,n.normal),P(le,n.tangent),P(le,n.bitangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=g.clone(g.IDENTITY),e};var fe=new i;ie.combineInstances=function(e){if(!c(e)||e.length<1)throw new l("instances is required and must have length greater than zero.");for(var t=[],r=[],n=e.length,i=0;n>i;++i){var a=e[i];c(a.geometry)?t.push(a):c(a.westHemisphereGeometry)&&c(a.eastHemisphereGeometry)&&r.push(a)}var o=[];return t.length>0&&o.push(D(t,"geometry")),r.length>0&&(o.push(D(r,"westHemisphereGeometry")),o.push(D(r,"eastHemisphereGeometry"))),o};var he=new i,pe=new i,de=new i,ye=new i;ie.computeNormal=function(e){if(!c(e))throw new l("geometry is required.");if(!c(e.attributes.position)||!c(e.attributes.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(e.indices))throw new l("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==T.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var t,r=e.indices,n=e.attributes,a=n.position.values,o=n.position.values.length/3,s=r.length,f=new Array(o),h=new Array(s/3),p=new Array(s);for(t=0;o>t;t++)f[t]={indexOffset:0,count:0,currentCount:0};var y=0;for(t=0;s>t;t+=3){var m=r[t],E=r[t+1],v=r[t+2],w=3*m,g=3*E,_=3*v;pe.x=a[w],pe.y=a[w+1],pe.z=a[w+2],de.x=a[g],de.y=a[g+1],de.z=a[g+2],ye.x=a[_],ye.y=a[_+1],ye.z=a[_+2],f[m].count++,f[E].count++,f[v].count++,i.subtract(de,pe,de),i.subtract(ye,pe,ye),h[y]=i.cross(de,ye,new i),y++}var b=0;for(t=0;o>t;t++)f[t].indexOffset+=b,b+=f[t].count;y=0;var R;for(t=0;s>t;t+=3){R=f[r[t]];var A=R.indexOffset+R.currentCount;p[A]=y,R.currentCount++,R=f[r[t+1]],A=R.indexOffset+R.currentCount,p[A]=y,R.currentCount++,R=f[r[t+2]],A=R.indexOffset+R.currentCount,p[A]=y,R.currentCount++,y++}var S=new Float32Array(3*o);for(t=0;o>t;t++){var x=3*t;if(R=f[t],i.clone(i.ZERO,he),R.count>0){for(y=0;y<R.count;y++)i.add(he,h[p[R.indexOffset+y]],he);i.equalsEpsilon(i.ZERO,he,O.EPSILON10)&&i.clone(h[p[R.indexOffset]],he)}i.equalsEpsilon(i.ZERO,he,O.EPSILON10)&&(he.z=1),i.normalize(he,he),S[x]=he.x,S[x+1]=he.y,S[x+2]=he.z}return e.attributes.normal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var me=new i,Ee=new i,ve=new i;ie.computeTangentAndBitangent=function(e){if(!c(e))throw new l("geometry is required.");var t=e.attributes,r=e.indices;if(!c(t.position)||!c(t.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(t.normal)||!c(t.normal.values))throw new l("geometry.attributes.normal.values is required.");if(!c(t.st)||!c(t.st.values))throw new l("geometry.attributes.st.values is required.");if(!c(r))throw new l("geometry.indices is required.");if(r.length<2||r.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==T.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var n,a=e.attributes.position.values,o=e.attributes.normal.values,s=e.attributes.st.values,f=e.attributes.position.values.length/3,h=r.length,p=new Array(3*f);for(n=0;n<p.length;n++)p[n]=0;var y,m,E;for(n=0;h>n;n+=3){var v=r[n],O=r[n+1],w=r[n+2];y=3*v,m=3*O,E=3*w;var g=2*v,_=2*O,b=2*w,R=a[y],A=a[y+1],S=a[y+2],x=s[g],N=s[g+1],I=s[_+1]-N,M=s[b+1]-N,P=1/((s[_]-x)*M-(s[b]-x)*I),C=(M*(a[m]-R)-I*(a[E]-R))*P,D=(M*(a[m+1]-A)-I*(a[E+1]-A))*P,q=(M*(a[m+2]-S)-I*(a[E+2]-S))*P;p[y]+=C,p[y+1]+=D,p[y+2]+=q,p[m]+=C,p[m+1]+=D,p[m+2]+=q,p[E]+=C,p[E+1]+=D,p[E+2]+=q}var U=new Float32Array(3*f),L=new Float32Array(3*f);for(n=0;f>n;n++){y=3*n,m=y+1,E=y+2;var F=i.fromArray(o,y,me),B=i.fromArray(p,y,ve),j=i.dot(F,B);i.multiplyByScalar(F,j,Ee),i.normalize(i.subtract(B,Ee,B),B),U[y]=B.x,U[m]=B.y,U[E]=B.z,i.normalize(i.cross(F,B,B),B),L[y]=B.x,L[m]=B.y,L[E]=B.z}return e.attributes.tangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:U}),e.attributes.bitangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e};var Oe=new n,we=new i,ge=new i,_e=new i,Te=new n;ie.compressVertices=function(t){if(!c(t))throw new l("geometry is required.");var r,a,o=t.attributes.extrudeDirection;if(c(o)){var s=o.values;a=s.length/3;var f=new Float32Array(2*a),h=0;for(r=0;a>r;++r)i.fromArray(s,3*r,we),i.equals(we,i.ZERO)?h+=2:(Te=e.octEncodeInRange(we,65535,Te),f[h++]=Te.x,f[h++]=Te.y);return t.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:f}),delete t.attributes.extrudeDirection,t}var p=t.attributes.normal,y=t.attributes.st,m=c(p),E=c(y);if(!m&&!E)return t;var v,O,w,g,_=t.attributes.tangent,T=t.attributes.bitangent,b=c(_),R=c(T);m&&(v=p.values),E&&(O=y.values),b&&(w=_.values),R&&(g=T.values);var A=m?v.length:O.length,S=m?3:2;a=A/S;var x=a,N=E&&m?2:1;N+=b||R?1:0,x*=N;var I=new Float32Array(x),M=0;for(r=0;a>r;++r){E&&(n.fromArray(O,2*r,Oe),I[M++]=e.compressTextureCoordinates(Oe));var P=3*r;m&&c(w)&&c(g)?(i.fromArray(v,P,we),i.fromArray(w,P,ge),i.fromArray(g,P,_e),e.octPack(we,ge,_e,Oe),I[M++]=Oe.x,I[M++]=Oe.y):(m&&(i.fromArray(v,P,we),I[M++]=e.octEncodeFloat(we)),b&&(i.fromArray(w,P,we),I[M++]=e.octEncodeFloat(we)),R&&(i.fromArray(g,P,we),I[M++]=e.octEncodeFloat(we)))}return t.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:N,values:I}),m&&delete t.attributes.normal,E&&delete t.attributes.st,R&&delete t.attributes.bitangent,b&&delete t.attributes.tangent,t};var be=new i,Re=new i,Ae=new i,Se=new i,xe=new i,Ne={positions:new Array(7),indices:new Array(9)},Ie=Z(a,4),Me=Z(i,3),Pe=Z(n,2),Ce=function(e,t,r,n,i,a,o){var u=i[e]*n.x,s=i[t]*n.y,c=i[r]*n.z;a[o]=u+s+c>O.EPSILON6?1:0},De=new i,qe=new i,Ue=new i,Le=new i,Fe={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0},Be=_.fromPointNormal(i.ZERO,i.UNIT_Y),je=new i,ze=new i,Ge=new n,Ve=new n,We=new i,ke=new i,Xe=new i,He=new i,Ye=new i,Ze=new i,Ke=new i,Je=new a,Qe=5*O.EPSILON9,$e=O.EPSILON6;return ie.splitLongitude=function(e){if(!c(e))throw new l("instance is required.");var t=e.geometry,n=t.boundingSphere;if(c(n)){var i=n.center.x-n.radius;if(i>0||r.intersectPlane(n,_.ORIGIN_ZX_PLANE)!==E.INTERSECTING)return e}if(t.geometryType!==y.NONE)switch(t.geometryType){case y.POLYLINES:ne(e);break;case y.TRIANGLES:$(e);break;case y.LINES:te(e)}else z(t),t.primitiveType===T.TRIANGLES?$(e):t.primitiveType===T.LINES&&te(e);return e},ie}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,a){if(!t(n))throw new r("identifier is required.");t(i[n])||(i[n]=!0,console.warn(e(a,n)))}var i={};return n.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",n.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",n.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",n.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",n}),define("ThirdParty/earcut-2.1.1",[],function(){"use strict";function e(e,r,i){i=i||2;var a=r&&r.length,o=a?r[0]*i:e.length,u=t(e,0,o,i,!0),c=[];if(!u)return c;var l,f,h,p,d,y,m;if(a&&(u=s(e,r,u,i)),e.length>80*i){l=h=e[0],f=p=e[1];for(var E=i;o>E;E+=i)d=e[E],y=e[E+1],l>d&&(l=d),f>y&&(f=y),d>h&&(h=d),y>p&&(p=y);m=Math.max(h-l,p-f)}return n(u,c,i,l,f,m),c}function t(e,t,r,n,i){var a,o;if(i===x(e,t,r,n)>0)for(a=t;r>a;a+=n)o=R(a,e[a],e[a+1],o);else for(a=r-n;a>=t;a-=n)o=R(a,e[a],e[a+1],o);return o&&O(o,o.next)&&(A(o),o=o.next),o}function r(e,t){if(!e)return e;t||(t=e);var r,n=e;do if(r=!1,n.steiner||!O(n,n.next)&&0!==v(n.prev,n,n.next))n=n.next;else{if(A(n),n=t=n.prev,n===n.next)return null;r=!0}while(r||n!==t);return t}function n(e,t,s,c,l,f,p){if(e){!p&&f&&h(e,c,l,f);for(var d,y,m=e;e.prev!==e.next;)if(d=e.prev,y=e.next,f?a(e,c,l,f):i(e))t.push(d.i/s),t.push(e.i/s),t.push(y.i/s),A(e),e=y.next,m=y.next;else if(e=y,e===m){p?1===p?(e=o(e,t,s),n(e,t,s,c,l,f,2)):2===p&&u(e,t,s,c,l,f):n(r(e),t,s,c,l,f,1);break}}}function i(e){var t=e.prev,r=e,n=e.next;if(v(t,r,n)>=0)return!1;for(var i=e.next.next;i!==e.prev;){if(m(t.x,t.y,r.x,r.y,n.x,n.y,i.x,i.y)&&v(i.prev,i,i.next)>=0)return!1;i=i.next}return!0}function a(e,t,r,n){var i=e.prev,a=e,o=e.next;if(v(i,a,o)>=0)return!1;for(var u=i.x<a.x?i.x<o.x?i.x:o.x:a.x<o.x?a.x:o.x,s=i.y<a.y?i.y<o.y?i.y:o.y:a.y<o.y?a.y:o.y,c=i.x>a.x?i.x>o.x?i.x:o.x:a.x>o.x?a.x:o.x,l=i.y>a.y?i.y>o.y?i.y:o.y:a.y>o.y?a.y:o.y,f=d(u,s,t,r,n),h=d(c,l,t,r,n),p=e.nextZ;p&&p.z<=h;){if(p!==e.prev&&p!==e.next&&m(i.x,i.y,a.x,a.y,o.x,o.y,p.x,p.y)&&v(p.prev,p,p.next)>=0)return!1;p=p.nextZ}for(p=e.prevZ;p&&p.z>=f;){if(p!==e.prev&&p!==e.next&&m(i.x,i.y,a.x,a.y,o.x,o.y,p.x,p.y)&&v(p.prev,p,p.next)>=0)return!1;p=p.prevZ}return!0}function o(e,t,r){var n=e;do{var i=n.prev,a=n.next.next;!O(i,a)&&w(i,n,n.next,a)&&_(i,a)&&_(a,i)&&(t.push(i.i/r),t.push(n.i/r),t.push(a.i/r),A(n),A(n.next),n=e=a),n=n.next}while(n!==e);return n}function u(e,t,i,a,o,u){var s=e;do{for(var c=s.next.next;c!==s.prev;){if(s.i!==c.i&&E(s,c)){var l=b(s,c);return s=r(s,s.next),l=r(l,l.next),n(s,t,i,a,o,u),void n(l,t,i,a,o,u)}c=c.next}s=s.next}while(s!==e)}function s(e,n,i,a){var o,u,s,f,h,p=[];for(o=0,u=n.length;u>o;o++)s=n[o]*a,f=u-1>o?n[o+1]*a:e.length,h=t(e,s,f,a,!1),h===h.next&&(h.steiner=!0),p.push(y(h));for(p.sort(c),o=0;o<p.length;o++)l(p[o],i),i=r(i,i.next);return i}function c(e,t){return e.x-t.x}function l(e,t){if(t=f(e,t)){var n=b(t,e);r(n,n.next)}}function f(e,t){var r,n=t,i=e.x,a=e.y,o=-(1/0);do{if(a<=n.y&&a>=n.next.y){var u=n.x+(a-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(i>=u&&u>o){if(o=u,u===i){if(a===n.y)return n;if(a===n.next.y)return n.next}r=n.x<n.next.x?n:n.next}}n=n.next}while(n!==t);if(!r)return null;if(i===o)return r.prev;var s,c=r,l=r.x,f=r.y,h=1/0;for(n=r.next;n!==c;)i>=n.x&&n.x>=l&&m(f>a?i:o,a,l,f,f>a?o:i,a,n.x,n.y)&&(s=Math.abs(a-n.y)/(i-n.x),(h>s||s===h&&n.x>r.x)&&_(n,e)&&(r=n,h=s)),n=n.next;return r}function h(e,t,r,n){var i=e;do null===i.z&&(i.z=d(i.x,i.y,t,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,p(i)}function p(e){var t,r,n,i,a,o,u,s,c=1;do{for(r=e,e=null,a=null,o=0;r;){for(o++,n=r,u=0,t=0;c>t&&(u++,n=n.nextZ,n);t++);for(s=c;u>0||s>0&&n;)0===u?(i=n,n=n.nextZ,s--):0!==s&&n?r.z<=n.z?(i=r,r=r.nextZ,u--):(i=n,n=n.nextZ,s--):(i=r,r=r.nextZ,u--),a?a.nextZ=i:e=i,i.prevZ=a,a=i;r=n}a.nextZ=null,c*=2}while(o>1);return e}function d(e,t,r,n,i){return e=32767*(e-r)/i,t=32767*(t-n)/i,e=16711935&(e|e<<8),e=252645135&(e|e<<4),e=858993459&(e|e<<2),e=1431655765&(e|e<<1),t=16711935&(t|t<<8),t=252645135&(t|t<<4),t=858993459&(t|t<<2),t=1431655765&(t|t<<1),e|t<<1}function y(e){var t=e,r=e;do t.x<r.x&&(r=t),t=t.next;while(t!==e);return r}function m(e,t,r,n,i,a,o,u){return(i-o)*(t-u)-(e-o)*(a-u)>=0&&(e-o)*(n-u)-(r-o)*(t-u)>=0&&(r-o)*(a-u)-(i-o)*(n-u)>=0}function E(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!g(e,t)&&_(e,t)&&_(t,e)&&T(e,t)}function v(e,t,r){return(t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function O(e,t){return e.x===t.x&&e.y===t.y}function w(e,t,r,n){return O(e,t)&&O(r,n)||O(e,n)&&O(r,t)?!0:v(e,t,r)>0!=v(e,t,n)>0&&v(r,n,e)>0!=v(r,n,t)>0}function g(e,t){var r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&w(r,r.next,e,t))return!0;r=r.next}while(r!==e);return!1}function _(e,t){return v(e.prev,e,e.next)<0?v(e,t,e.next)>=0&&v(e,e.prev,t)>=0:v(e,t,e.prev)<0||v(e,e.next,t)<0}function T(e,t){var r=e,n=!1,i=(e.x+t.x)/2,a=(e.y+t.y)/2;do r.y>a!=r.next.y>a&&i<(r.next.x-r.x)*(a-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;while(r!==e);return n}function b(e,t){var r=new S(e.i,e.x,e.y),n=new S(t.i,t.x,t.y),i=e.next,a=t.prev;return e.next=t,t.prev=e,r.next=i,i.prev=r,n.next=r,r.prev=n,a.next=n,n.prev=a,n}function R(e,t,r,n){var i=new S(e,t,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function A(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function S(e,t,r){this.i=e,this.x=t,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function x(e,t,r,n){for(var i=0,a=t,o=r-n;r>a;a+=n)i+=(e[o]-e[a])*(e[a+1]+e[o+1]),o=a;return i}return e.deviation=function(e,t,r,n){var i=t&&t.length,a=i?t[0]*r:e.length,o=Math.abs(x(e,0,a,r));if(i)for(var u=0,s=t.length;s>u;u++){var c=t[u]*r,l=s-1>u?t[u+1]*r:e.length;o-=Math.abs(x(e,c,l,r))}var f=0;for(u=0;u<n.length;u+=3){var h=n[u]*r,p=n[u+1]*r,d=n[u+2]*r;f+=Math.abs((e[h]-e[d])*(e[p+1]-e[h+1])-(e[h]-e[p])*(e[d+1]-e[h+1]))}return 0===o&&0===f?0:Math.abs((f-o)/o)},e.flatten=function(e){for(var t=e[0][0].length,r={vertices:[],holes:[],dimensions:t},n=0,i=0;i<e.length;i++){for(var a=0;a<e[i].length;a++)for(var o=0;t>o;o++)r.vertices.push(e[i][a][o]);i>0&&(n+=e[i-1].length,r.holes.push(n))}return r},e}),define("Core/EllipsoidRhumbLine",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,i,a,o,u,s){"use strict";function c(e,t,r){if(0===e)return t*r;var n=e*e,i=n*n,a=i*n,o=a*n,u=o*n,s=u*n,c=r,l=Math.sin(2*c),f=Math.sin(4*c),h=Math.sin(6*c),p=Math.sin(8*c),d=Math.sin(10*c),y=Math.sin(12*c);return t*((1-n/4-3*i/64-5*a/256-175*o/16384-441*u/65536-4851*s/1048576)*c-(3*n/8+3*i/32+45*a/1024+105*o/4096+2205*u/131072+6237*s/524288)*l+(15*i/256+45*a/1024+525*o/16384+1575*u/65536+155925*s/8388608)*f-(35*a/3072+175*o/12288+3675*u/262144+13475*s/1048576)*h+(315*o/131072+2205*u/524288+43659*s/8388608)*p-(693*u/1310720+6237*s/5242880)*d+1001*s/8388608*y)}function l(e,t,r){var n=e/r;if(0===t)return n;var i=n*n,a=i*n,o=a*n,u=t,s=u*u,c=s*s,l=c*s,f=l*s,h=f*s,p=h*s,d=Math.sin(2*n),y=Math.cos(2*n),m=Math.sin(4*n),E=Math.cos(4*n),v=Math.sin(6*n),O=Math.cos(6*n),w=Math.sin(8*n),g=Math.cos(8*n),_=Math.sin(10*n),T=Math.cos(10*n),b=Math.sin(12*n);return n+n*s/4+7*n*c/64+15*n*l/256+579*n*f/16384+1515*n*h/65536+16837*n*p/1048576+(3*n*c/16+45*n*l/256-n*(32*i-561)*f/4096-n*(232*i-1677)*h/16384+n*(399985-90560*i+512*o)*p/5242880)*y+(21*n*l/256+483*n*f/4096-n*(224*i-1969)*h/16384-n*(33152*i-112599)*p/1048576)*E+(151*n*f/4096+4681*n*h/65536+1479*n*p/16384-453*a*p/32768)*O+(1097*n*h/65536+42783*n*p/1048576)*g+8011*n*p/1048576*T+(3*s/8+3*c/16+213*l/2048-3*i*l/64+255*f/4096-33*i*f/512+20861*h/524288-33*i*h/512+o*h/1024+28273*p/1048576-471*i*p/8192+9*o*p/4096)*d+(21*c/256+21*l/256+533*f/8192-21*i*f/512+197*h/4096-315*i*h/4096+584039*p/16777216-12517*i*p/131072+7*o*p/2048)*m+(151*l/6144+151*f/4096+5019*h/131072-453*i*h/16384+26965*p/786432-8607*i*p/131072)*v+(1097*f/131072+1097*h/65536+225797*p/10485760-1097*i*p/65536)*w+(8011*h/2621440+8011*p/1048576)*_+293393*p/251658240*b}function f(e,t){if(0===e)return Math.log(Math.tan(.5*(s.PI_OVER_TWO+t)));var r=e*Math.sin(t);return Math.log(Math.tan(.5*(s.PI_OVER_TWO+t)))-e/2*Math.log((1+r)/(1-r))}function h(e,t,r,n,i){var a=f(e._ellipticity,r),o=f(e._ellipticity,i);return Math.atan2(s.negativePiToPi(n-t),o-a)}function p(e,t,r,n,i,a,o){var u=e._heading,l=a-n,f=0;if(s.equalsEpsilon(Math.abs(u),s.PI_OVER_TWO,s.EPSILON8))if(t===r)f=t*Math.cos(i)*s.negativePiToPi(l);else{var h=Math.sin(i);f=t*Math.cos(i)*s.negativePiToPi(l)/Math.sqrt(1-e._ellipticitySquared*h*h)}else{var p=c(e._ellipticity,t,i),d=c(e._ellipticity,t,o);f=(d-p)/Math.cos(u)}return Math.abs(f)}function d(n,i,a,o){var u=e.normalize(o.cartographicToCartesian(i,v),E),s=e.normalize(o.cartographicToCartesian(a,v),v);r.typeOf.number.greaterThanOrEquals("value",Math.abs(Math.abs(e.angleBetween(u,s))-Math.PI),.0125);var c=o.maximumRadius,l=o.minimumRadius,f=c*c,d=l*l;n._ellipticitySquared=(f-d)/f,n._ellipticity=Math.sqrt(n._ellipticitySquared),n._start=t.clone(i,n._start),n._start.height=0,n._end=t.clone(a,n._end),n._end.height=0,n._heading=h(n,i.longitude,i.latitude,a.longitude,a.latitude),n._distance=p(n,o.maximumRadius,o.minimumRadius,i.longitude,i.latitude,a.longitude,a.latitude)}function y(e,r,n,a,o,u){var h,p,d,y=o*o;if(Math.abs(s.PI_OVER_TWO-Math.abs(r))>s.EPSILON8){var m=c(o,a,e.latitude),E=n*Math.cos(r),v=m+E;p=l(v,o,a);var O=f(o,e.latitude),w=f(o,p);d=Math.tan(r)*(w-O),h=s.negativePiToPi(e.longitude+d)}else{p=e.latitude;var g;if(0===o)g=a*Math.cos(e.latitude);else{var _=Math.sin(e.latitude);g=a*Math.cos(e.latitude)/Math.sqrt(1-y*_*_)}d=n/g,h=r>0?s.negativePiToPi(e.longitude+d):s.negativePiToPi(e.longitude-d)}return i(u)?(u.longitude=h,u.latitude=p,u.height=0,
u):new t(h,p,0)}function m(e,r,a){var o=n(a,u.WGS84);this._ellipsoid=o,this._start=new t,this._end=new t,this._heading=void 0,this._distance=void 0,this._ellipticity=void 0,this._ellipticitySquared=void 0,i(e)&&i(r)&&d(this,e,r,o)}var E=new e,v=new e;return a(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return r.defined("distance",this._distance),this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},heading:{get:function(){return r.defined("distance",this._distance),this._heading}}}),m.fromStartHeadingDistance=function(e,t,a,o,c){r.defined("start",e),r.defined("heading",t),r.defined("distance",a),r.typeOf.number.greaterThan("distance",a,0);var l=n(o,u.WGS84),f=l.maximumRadius,h=l.minimumRadius,p=f*f,d=h*h,E=Math.sqrt((p-d)/p);t=s.negativePiToPi(t);var v=y(e,t,a,l.maximumRadius,E);return!i(c)||i(o)&&!o.equals(c.ellipsoid)?new m(e,v,l):(c.setEndPoints(e,v),c)},m.prototype.setEndPoints=function(e,t){r.defined("start",e),r.defined("end",t),d(this,e,t,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(e*this._distance,t)},m.prototype.interpolateUsingSurfaceDistance=function(e,t){if(r.typeOf.number("distance",e),!i(this._distance)||0===this._distance)throw new o("EllipsoidRhumbLine must have distinct start and end set.");return y(this._start,this._heading,e,this._ellipsoid.maximumRadius,this._ellipticity,t)},m.prototype.findIntersectionWithLongitude=function(e,n){if(r.typeOf.number("intersectionLongitude",e),!i(this._distance)||0===this._distance)throw new o("EllipsoidRhumbLine must have distinct start and end set.");var a=this._ellipticity,u=this._heading,c=Math.abs(u),l=this._start;if(e=s.negativePiToPi(e),i(n)||(n=new t),Math.abs(s.PI_OVER_TWO-c)<=s.EPSILON8)return n.longitude=e,n.latitude=l.latitude,n.height=0,n;if(s.equalsEpsilon(Math.abs(s.PI_OVER_TWO-c),s.PI_OVER_TWO,s.EPSILON8)){if(s.equalsEpsilon(e,l.longitude,s.EPSILON12))return;return n.longitude=e,n.latitude=s.PI_OVER_TWO*Math.sign(s.PI_OVER_TWO-u),n.height=0,n}var f,h=l.latitude,p=a*Math.sin(h),d=Math.tan(.5*(s.PI_OVER_TWO+h))*Math.exp((e-l.longitude)/Math.tan(u)),y=(1+p)/(1-p),m=l.latitude;do{f=m;var E=a*Math.sin(f),v=(1+E)/(1-E);m=2*Math.atan(d*Math.pow(v/y,a/2))-s.PI_OVER_TWO}while(!s.equalsEpsilon(m,f,s.EPSILON12));return n.longitude=e,n.latitude=f,n.height=0,n},m.prototype.findIntersectionWithLatitude=function(e,n){if(r.typeOf.number("intersectionLatitude",e),!i(this._distance)||0===this._distance)throw new o("EllipsoidRhumbLine must have distinct start and end set.");var a=this._ellipticity,u=this._heading,c=this._start;if(!s.equalsEpsilon(Math.abs(u),s.PI_OVER_TWO,s.EPSILON8)){var l=f(a,c.latitude),h=f(a,e),p=Math.tan(u)*(h-l),d=s.negativePiToPi(c.longitude+p);return i(n)?(n.longitude=d,n.latitude=e,n.height=0,n):new t(d,e,0)}},m}),define("Core/WindingOrder",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={CLOCKWISE:t.CW,COUNTER_CLOCKWISE:t.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return e(r)}),define("Core/PolygonPipeline",["../ThirdParty/earcut-2.1.1","./Cartesian2","./Cartesian3","./Cartographic","./Check","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./EllipsoidRhumbLine","./Geometry","./GeometryAttribute","./Math","./PrimitiveType","./WindingOrder"],function(e,t,r,n,i,a,o,u,s,c,l,f,h,p,d){"use strict";var y=new r,m=new r,E={};E.computeArea2D=function(e){i.defined("positions",e),i.typeOf.number.greaterThanOrEquals("positions.length",e.length,3);for(var t=e.length,r=0,n=t-1,a=0;t>a;n=a++){var o=e[n],u=e[a];r+=o.x*u.y-u.x*o.y}return.5*r},E.computeWindingOrder2D=function(e){var t=E.computeArea2D(e);return t>0?d.COUNTER_CLOCKWISE:d.CLOCKWISE},E.triangulate=function(r,n){i.defined("positions",r);var a=t.packArray(r);return e(a,n,2)};var v=new r,O=new r,w=new r,g=new r,_=new r,T=new r,b=new r;E.computeSubdivision=function(e,t,n,s){s=o(s,h.RADIANS_PER_DEGREE),i.typeOf.object("ellipsoid",e),i.defined("positions",t),i.defined("indices",n),i.typeOf.number.greaterThanOrEquals("indices.length",n.length,3),i.typeOf.number.equals("indices.length % 3","0",n.length%3,0),i.typeOf.number.greaterThan("granularity",s,0);var c,d=n.slice(0),y=t.length,m=new Array(3*y),E=0;for(c=0;y>c;c++){var R=t[c];m[E++]=R.x,m[E++]=R.y,m[E++]=R.z}for(var A=[],S={},x=e.maximumRadius,N=h.chordLength(s,x),I=N*N;d.length>0;){var M,P,C=d.pop(),D=d.pop(),q=d.pop(),U=r.fromArray(m,3*q,v),L=r.fromArray(m,3*D,O),F=r.fromArray(m,3*C,w),B=r.multiplyByScalar(r.normalize(U,g),x,g),j=r.multiplyByScalar(r.normalize(L,_),x,_),z=r.multiplyByScalar(r.normalize(F,T),x,T),G=r.magnitudeSquared(r.subtract(B,j,b)),V=r.magnitudeSquared(r.subtract(j,z,b)),W=r.magnitudeSquared(r.subtract(z,B,b)),k=Math.max(G,V,W);k>I?G===k?(M=Math.min(q,D)+" "+Math.max(q,D),c=S[M],u(c)||(P=r.add(U,L,b),r.multiplyByScalar(P,.5,P),m.push(P.x,P.y,P.z),c=m.length/3-1,S[M]=c),d.push(q,c,C),d.push(c,D,C)):V===k?(M=Math.min(D,C)+" "+Math.max(D,C),c=S[M],u(c)||(P=r.add(L,F,b),r.multiplyByScalar(P,.5,P),m.push(P.x,P.y,P.z),c=m.length/3-1,S[M]=c),d.push(D,c,q),d.push(c,C,q)):W===k&&(M=Math.min(C,q)+" "+Math.max(C,q),c=S[M],u(c)||(P=r.add(F,U,b),r.multiplyByScalar(P,.5,P),m.push(P.x,P.y,P.z),c=m.length/3-1,S[M]=c),d.push(C,c,D),d.push(c,q,D)):(A.push(q),A.push(D),A.push(C))}return new l({attributes:{position:new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:m})},indices:A,primitiveType:p.TRIANGLES})};var R=new n,A=new n,S=new n,x=new n;return E.computeRhumbLineSubdivision=function(e,t,n,s){s=o(s,h.RADIANS_PER_DEGREE),i.typeOf.object("ellipsoid",e),i.defined("positions",t),i.defined("indices",n),i.typeOf.number.greaterThanOrEquals("indices.length",n.length,3),i.typeOf.number.equals("indices.length % 3","0",n.length%3,0),i.typeOf.number.greaterThan("granularity",s,0);var d,y=n.slice(0),m=t.length,E=new Array(3*m),g=0;for(d=0;m>d;d++){var _=t[d];E[g++]=_.x,E[g++]=_.y,E[g++]=_.z}for(var T=[],N={},I=e.maximumRadius,M=h.chordLength(s,I),P=new c(void 0,void 0,e),C=new c(void 0,void 0,e),D=new c(void 0,void 0,e);y.length>0;){var q=y.pop(),U=y.pop(),L=y.pop(),F=r.fromArray(E,3*L,v),B=r.fromArray(E,3*U,O),j=r.fromArray(E,3*q,w),z=e.cartesianToCartographic(F,R),G=e.cartesianToCartographic(B,A),V=e.cartesianToCartographic(j,S);P.setEndPoints(z,G);var W=P.surfaceDistance;C.setEndPoints(G,V);var k=C.surfaceDistance;D.setEndPoints(V,z);var X,H,Y,Z,K=D.surfaceDistance,J=Math.max(W,k,K);J>M?W===J?(X=Math.min(L,U)+" "+Math.max(L,U),d=N[X],u(d)||(H=P.interpolateUsingFraction(.5,x),Y=.5*(z.height+G.height),Z=r.fromRadians(H.longitude,H.latitude,Y,e,b),E.push(Z.x,Z.y,Z.z),d=E.length/3-1,N[X]=d),y.push(L,d,q),y.push(d,U,q)):k===J?(X=Math.min(U,q)+" "+Math.max(U,q),d=N[X],u(d)||(H=C.interpolateUsingFraction(.5,x),Y=.5*(G.height+V.height),Z=r.fromRadians(H.longitude,H.latitude,Y,e,b),E.push(Z.x,Z.y,Z.z),d=E.length/3-1,N[X]=d),y.push(U,d,L),y.push(d,q,L)):K===J&&(X=Math.min(q,L)+" "+Math.max(q,L),d=N[X],u(d)||(H=D.interpolateUsingFraction(.5,x),Y=.5*(V.height+z.height),Z=r.fromRadians(H.longitude,H.latitude,Y,e,b),E.push(Z.x,Z.y,Z.z),d=E.length/3-1,N[X]=d),y.push(q,d,U),y.push(d,L,U)):(T.push(L),T.push(U),T.push(q))}return new l({attributes:{position:new f({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:E})},indices:T,primitiveType:p.TRIANGLES})},E.scaleToGeodeticHeight=function(e,t,n,i){n=o(n,s.WGS84);var a=y,c=m;if(t=o(t,0),i=o(i,!0),u(e))for(var l=e.length,f=0;l>f;f+=3)r.fromArray(e,f,c),i&&(c=n.scaleToGeodeticSurface(c,c)),0!==t&&(a=n.geodeticSurfaceNormal(c,a),r.multiplyByScalar(a,t,a),r.add(c,a,c)),e[f]=c.x,e[f+1]=c.y,e[f+2]=c.z;return e},E}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./Check","./defaultValue","./defined","./Intersect"],function(e,t,r,n,i){"use strict";function a(t,i,a){this.minimum=e.clone(r(t,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),a=n(a)?e.clone(a):e.midpoint(this.minimum,this.maximum,new e),this.center=a}a.fromPoints=function(t,r){if(n(r)||(r=new a),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var i=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,h=1;f>h;h++){var p=t[h],d=p.x,y=p.y,m=p.z;i=Math.min(d,i),s=Math.max(d,s),o=Math.min(y,o),c=Math.max(y,c),u=Math.min(m,u),l=Math.max(m,l)}var E=r.minimum;E.x=i,E.y=o,E.z=u;var v=r.maximum;return v.x=s,v.y=c,v.z=l,r.center=e.midpoint(E,v,r.center),r},a.clone=function(t,r){return n(t)?n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new a(t.minimum,t.maximum,t.center):void 0},a.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return a.intersectPlane=function(r,n){t.defined("box",r),t.defined("plane",n),o=e.subtract(r.maximum,r.minimum,o);var a=e.multiplyByScalar(o,.5,o),u=n.normal,s=a.x*Math.abs(u.x)+a.y*Math.abs(u.y)+a.z*Math.abs(u.z),c=e.dot(r.center,u)+n.distance;return c-s>0?i.INSIDE:0>c+s?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersectPlane=function(e){return a.intersectPlane(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,n,i,a,o,u,s,c,l,f,h,p,d){"use strict";function y(e,t){if(i.defined("origin",e),t=a(t,c.WGS84),e=t.scaleToGeodeticSurface(e),!o(e))throw new s("origin must not be at the center of the ellipsoid.");var n=d.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(f.getColumn(n,0,m)),this._yAxis=r.fromCartesian4(f.getColumn(n,1,m));var u=r.fromCartesian4(f.getColumn(n,2,m));this._plane=h.fromPointNormal(e,u)}var m=new n;u(y.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var E=new e;y.fromPoints=function(t,r){i.defined("cartesians",t);var n=e.fromPoints(t,E);return new y(n.center,r)};var v=new p,O=new r;y.prototype.projectPointOntoPlane=function(e,n){i.defined("cartesian",e);var a=v;a.origin=e,r.normalize(e,a.direction);var u=l.rayPlane(a,this._plane,O);if(o(u)||(r.negate(a.direction,a.direction),u=l.rayPlane(a,this._plane,O)),o(u)){var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),f=r.dot(this._yAxis,s);return o(n)?(n.x=c,n.y=f,n):new t(c,f)}},y.prototype.projectPointsOntoPlane=function(e,t){i.defined("cartesians",e),o(t)||(t=[]);for(var r=0,n=e.length,a=0;n>a;a++){var u=this.projectPointOntoPlane(e[a],t[r]);o(u)&&(t[r]=u,r++)}return t.length=r,t},y.prototype.projectPointToNearestOnPlane=function(e,n){i.defined("cartesian",e),o(n)||(n=new t);var a=v;a.origin=e,r.clone(this._plane.normal,a.direction);var u=l.rayPlane(a,this._plane,O);o(u)||(r.negate(a.direction,a.direction),u=l.rayPlane(a,this._plane,O));var s=r.subtract(u,this._origin,u),c=r.dot(this._xAxis,s),f=r.dot(this._yAxis,s);return n.x=c,n.y=f,n},y.prototype.projectPointsToNearestOnPlane=function(e,t){i.defined("cartesians",e),o(t)||(t=[]);var r=e.length;t.length=r;for(var n=0;r>n;n++)t[n]=this.projectPointToNearestOnPlane(e[n],t[n]);return t};var w=new r;return y.prototype.projectPointOntoEllipsoid=function(e,t){i.defined("cartesian",e),o(t)||(t=new r);var n=this._ellipsoid,a=this._origin,u=this._xAxis,s=this._yAxis,c=w;return r.multiplyByScalar(u,e.x,c),t=r.add(a,c,t),r.multiplyByScalar(s,e.y,c),r.add(t,c,t),n.scaleToGeocentricSurface(t,t),t},y.prototype.projectPointsOntoEllipsoid=function(e,t){i.defined("cartesians",e);var r=e.length;o(t)?t.length=r:t=new Array(r);for(var n=0;r>n;++n)t[n]=this.projectPointOntoEllipsoid(e[n],t[n]);return t},y}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(r-n)/r,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-i)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,a),f=s*o,h=f*f,p=1-h,d=Math.sqrt(p),y=t/4,m=y*y,E=m*y,v=m*m,O=1+y-3*m/4+5*E/4-175*v/64,w=1-y+15*m/8-35*E/8,g=1-3*y+35*m/4,_=1-5*y,T=O*l-w*Math.sin(2*l)*y/2-g*Math.sin(4*l)*m/16-_*Math.sin(6*l)*E/48-5*Math.sin(8*l)*v/512,b=e._constants;b.a=r,b.b=n,b.f=i,b.cosineHeading=a,b.sineHeading=o,b.tanU=u,b.cosineU=s,b.sineU=c,b.sigma=l,b.sineAlpha=f,b.sineSquaredAlpha=h,b.cosineSquaredAlpha=p,b.cosineAlpha=d,b.u2Over4=y,b.u4Over16=m,b.u6Over64=E,b.u8Over256=v,b.a0=O,b.a1=w,b.a2=g,b.a3=_,b.distanceRatio=T}function c(e,t){return e*t*(4+e*(4-3*t))/16}function l(e,t,r,n,i,a,o){var u=c(e,r);return(1-u)*e*t*(n+u*i*(o+u*a*(2*o*o-1)))}function f(e,t,r,n,i,a,o){var s,c,f,h,p,d=(t-r)/t,y=a-n,m=Math.atan((1-d)*Math.tan(i)),E=Math.atan((1-d)*Math.tan(o)),v=Math.cos(m),O=Math.sin(m),w=Math.cos(E),g=Math.sin(E),_=v*w,T=v*g,b=O*g,R=O*w,A=y,S=u.TWO_PI,x=Math.cos(A),N=Math.sin(A);do{x=Math.cos(A),N=Math.sin(A);var I=T-R*x;f=Math.sqrt(w*w*N*N+I*I),c=b+_*x,s=Math.atan2(f,c);var M;0===f?(M=0,h=1):(M=_*N/f,h=1-M*M),S=A,p=c-2*b/h,isNaN(p)&&(p=0),A=y+l(d,M,h,s,f,c,p)}while(Math.abs(A-S)>u.EPSILON12);var P=h*(t*t-r*r)/(r*r),C=1+P*(4096+P*(P*(320-175*P)-768))/16384,D=P*(256+P*(P*(74-47*P)-128))/1024,q=p*p,U=D*f*(p+D*(c*(2*q-1)-D*p*(4*f*f-3)*(4*q-3)/6)/4),L=r*C*(s-U),F=Math.atan2(w*N,T-R*x),B=Math.atan2(v*N,T*x-R);e._distance=L,e._startHeading=F,e._endHeading=B,e._uSquared=P}function h(n,i,a,o){var u=e.normalize(o.cartographicToCartesian(i,y),d),c=e.normalize(o.cartographicToCartesian(a,y),y);r.typeOf.number.greaterThanOrEquals("value",Math.abs(Math.abs(e.angleBetween(u,c))-Math.PI),.0125),f(n,o.maximumRadius,o.minimumRadius,i.longitude,i.latitude,a.longitude,a.latitude),n._start=t.clone(i,n._start),n._end=t.clone(a,n._end),n._start.height=0,n._end.height=0,s(n)}function p(e,r,a){var u=n(a,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,i(e)&&i(r)&&h(this,e,r,u)}var d=new e,y=new e;return a(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return r.defined("distance",this._distance),this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return r.defined("distance",this._distance),this._startHeading}},endHeading:{get:function(){return r.defined("distance",this._distance),this._endHeading}}}),p.prototype.setEndPoints=function(e,t){r.defined("start",e),r.defined("end",t),h(this,e,t,this._ellipsoid)},p.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},p.prototype.interpolateUsingSurfaceDistance=function(e,n){r.defined("distance",this._distance);var a=this._constants,o=a.distanceRatio+e/a.b,u=Math.cos(2*o),s=Math.cos(4*o),c=Math.cos(6*o),f=Math.sin(2*o),h=Math.sin(4*o),p=Math.sin(6*o),d=Math.sin(8*o),y=o*o,m=o*y,E=a.u8Over256,v=a.u2Over4,O=a.u6Over64,w=a.u4Over16,g=2*m*E*u/3+o*(1-v+7*w/4-15*O/4+579*E/64-(w-15*O/4+187*E/16)*u-(5*O/4-115*E/16)*s-29*E*c/16)+(v/2-w+71*O/32-85*E/16)*f+(5*w/16-5*O/4+383*E/96)*h-y*((O-11*E/2)*f+5*E*h/2)+(29*O/96-29*E/16)*p+539*E*d/1536,_=Math.asin(Math.sin(g)*a.cosineAlpha),T=Math.atan(a.a/a.b*Math.tan(_));g-=a.sigma;var b=Math.cos(2*a.sigma+g),R=Math.sin(g),A=Math.cos(g),S=a.cosineU*A,x=a.sineU*R,N=Math.atan2(R*a.sineHeading,S-x*a.cosineHeading),I=N-l(a.f,a.sineAlpha,a.cosineSquaredAlpha,g,R,A,b);return i(n)?(n.longitude=this._start.longitude+I,n.latitude=T,n.height=0,n):new t(this._start.longitude+I,T,0)},p}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./EllipsoidRhumbLine","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,n,i,a,o,u,s,c,l,f,h){"use strict";function p(e,t,r){var n=S;n.length=e;var i;if(t===r){for(i=0;e>i;i++)n[i]=t;return n}var a=r-t,o=a/e;for(i=0;e>i;i++){var u=t+i*o;n[i]=u}return n}function d(e,t){var r=S;r.length=e;for(var n=0;e>n;n++)r[n]=t*Math.sin(Math.PI*n/e);return r}function y(t,r,n,i,a,o,u,s,c){var l=i.scaleToGeodeticSurface(t,M),f=i.scaleToGeodeticSurface(r,P),h=E.numberOfPoints(t,r,n),y=i.cartesianToCartographic(l,x),m=i.cartesianToCartographic(f,N),v=p(h,a,o);c>0&&(v=d(h,c)),C.setEndPoints(y,m);var O=C.surfaceDistance/h,w=s;y.height=a;var g=i.cartographicToCartesian(y,I);e.pack(g,u,w),w+=3;for(var _=1;h>_;_++){var T=C.interpolateUsingSurfaceDistance(_*O,N);T.height=v[_],g=i.cartographicToCartesian(T,I),e.pack(g,u,w),w+=3}return w}function m(t,r,n,i,a,o,s,c){var l=i.scaleToGeodeticSurface(t,M),f=i.scaleToGeodeticSurface(r,P),h=i.cartesianToCartographic(l,x),d=i.cartesianToCartographic(f,N),y=E.numberOfPointsRhumbLine(h,d,n),m=p(y,a,o);D.ellipsoid.equals(i)||(D=new u(void 0,void 0,i)),D.setEndPoints(h,d);var v=D.surfaceDistance/y,O=c;h.height=a;var w=i.cartographicToCartesian(h,I);e.pack(w,s,O),O+=3;for(var g=1;y>g;g++){var _=D.interpolateUsingSurfaceDistance(g*v,N);_.height=m[g],w=i.cartographicToCartesian(_,I),e.pack(w,s,O),O+=3}return O}var E={};E.numberOfPoints=function(t,r,n){var i=e.distance(t,r);return Math.ceil(i/n)},E.numberOfPointsRhumbLine=function(e,t,r){var n=Math.pow(e.longitude-t.longitude,2)+Math.pow(e.latitude-t.latitude,2);return Math.ceil(Math.sqrt(n/(r*r)))};var v=new t;E.extractHeights=function(e,t){for(var r=e.length,n=new Array(r),i=0;r>i;i++){var a=e[i];n[i]=t.cartesianToCartographic(a,v).height}return n};var O=new f,w=new e,g=new e,_=new h(e.UNIT_X,0),T=new e,b=new h(e.UNIT_X,0),R=new e,A=new e,S=[],x=new t,N=new t,I=new e,M=new e,P=new e,C=new o,D=new u;E.wrapLongitude=function(t,i){var a=[],o=[];if(n(t)&&t.length>0){i=r(i,f.IDENTITY);var u=f.inverseTransformation(i,O),c=f.multiplyByPoint(u,e.ZERO,w),l=e.normalize(f.multiplyByPointAsVector(u,e.UNIT_Y,g),g),p=h.fromPointNormal(c,l,_),d=e.normalize(f.multiplyByPointAsVector(u,e.UNIT_X,T),T),y=h.fromPointNormal(c,d,b),m=1;a.push(e.clone(t[0]));for(var E=a[0],v=t.length,S=1;v>S;++S){var x=t[S];if(h.getPointDistance(y,E)<0||h.getPointDistance(y,x)<0){var N=s.lineSegmentPlane(E,x,p,R);if(n(N)){var I=e.multiplyByScalar(l,5e-9,A);h.getPointDistance(p,E)<0&&e.negate(I,I),a.push(e.add(N,I,new e)),o.push(m+1),e.negate(I,I),a.push(e.add(N,I,new e)),m=1}}a.push(e.clone(t[S])),m++,E=x}o.push(m)}return{positions:a,lengths:o}},E.generateArc=function(t){n(t)||(t={});var o=t.positions;if(!n(o))throw new i("options.positions is required.");var u=o.length,s=r(t.ellipsoid,a.WGS84),f=r(t.height,0),h=c(f);if(1>u)return[];if(1===u){var p=s.scaleToGeodeticSurface(o[0],M);if(f=h?f[0]:f,0!==f){var d=s.geodeticSurfaceNormal(p,I);e.multiplyByScalar(d,f,d),e.add(p,d,p)}return[p.x,p.y,p.z]}var m=t.minDistance;if(!n(m)){var v=r(t.granularity,l.RADIANS_PER_DEGREE);m=l.chordLength(v,s.maximumRadius)}var O,w=0;for(O=0;u-1>O;O++)w+=E.numberOfPoints(o[O],o[O+1],m);var g=t.hMax,_=3*(w+1),T=new Array(_),b=0;for(O=0;u-1>O;O++){var R=o[O],A=o[O+1],N=h?f[O]:f,P=h?f[O+1]:f;b=y(R,A,m,s,N,P,T,b,g)}S.length=0;var C=o[u-1],D=s.cartesianToCartographic(C,x);D.height=h?f[u-1]:f;var q=s.cartographicToCartesian(D,I);return e.pack(q,T,_-3),T};var q=new t,U=new t;return E.generateRhumbArc=function(o){n(o)||(o={});var u=o.positions;if(!n(u))throw new i("options.positions is required.");var s=u.length,f=r(o.ellipsoid,a.WGS84),h=r(o.height,0),p=c(h);if(1>s)return[];if(1===s){var d=f.scaleToGeodeticSurface(u[0],M);if(h=p?h[0]:h,0!==h){var y=f.geodeticSurfaceNormal(d,I);e.multiplyByScalar(y,h,y),e.add(d,y,d)}return[d.x,d.y,d.z]}var v,O,w=r(o.granularity,l.RADIANS_PER_DEGREE),g=0,_=f.cartesianToCartographic(u[0],q);for(v=0;s-1>v;v++)O=f.cartesianToCartographic(u[v+1],U),g+=E.numberOfPointsRhumbLine(_,O,w),_=t.clone(O,q);var T=3*(g+1),b=new Array(T),R=0;for(v=0;s-1>v;v++){var A=u[v],N=u[v+1],P=p?h[v]:h,C=p?h[v+1]:h;R=m(A,N,w,f,P,C,b,R)}S.length=0;var D=u[s-1],L=f.cartesianToCartographic(D,x);L.height=p?h[s-1]:h;var F=f.cartographicToCartesian(L,I);return e.pack(F,b,T-3),b},E.generateCartesianArc=function(t){for(var r=E.generateArc(t),n=r.length/3,i=new Array(n),a=0;n>a;a++)i[a]=e.unpack(r,3*a);return i},E.generateCartesianRhumbArc=function(t){for(var r=E.generateRhumbArc(t),n=r.length/3,i=new Array(n),a=0;n>a;a++)i[a]=e.unpack(r,3*a);return i},E}),define("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,r,n,i,a,o,u,s,c,l,f){"use strict";function h(e,t){for(var r=new Array(e.length),n=0;n<e.length;n++){var i=e[n];q=t.cartesianToCartographic(i,q),r[n]=q.height,e[n]=t.scaleToGeodeticSurface(i,i)}return r}function p(e,r,n,i){var a,o=e[0],u=e[1],s=t.angleBetween(o,u),c=Math.ceil(s/i),l=new Array(c);if(r===n){for(a=0;c>a;a++)l[a]=r;return l.push(n),l}var f=n-r,h=f/c;for(a=1;c>a;a++){var p=r+a*h;l[a]=p}return l[0]=r,l.push(n),l}function d(r,n,i,o){var u=new a(i,o),s=u.projectPointOntoPlane(t.add(i,r,U),U),c=u.projectPointOntoPlane(t.add(i,n,L),L),l=e.angleBetween(s,c);return c.x*s.y-c.y*s.x>=0?-l:l}function y(e,r,n,i,a,o,c,l){var h=V,p=W;B=f.eastNorthUpToFixedFrame(e,a,B),h=s.multiplyByPointAsVector(B,F,h),h=t.normalize(h,h);var y=d(h,r,e,a);z=u.fromRotationZ(y,z),k.z=o,B=s.multiplyTransformation(B,s.fromRotationTranslation(z,k,j),B);var m=G;m[0]=c;for(var E=0;l>E;E++)for(var v=0;v<n.length;v+=3)p=t.fromArray(n,v,p),p=u.multiplyByVector(m,p,p),p=s.multiplyByPoint(B,p,p),i.push(p.x,p.y,p.z);return i}function m(e,r,n,i,a,o,c,l,h){var p=V,y=W;B=f.eastNorthUpToFixedFrame(e,a,B),p=s.multiplyByPointAsVector(B,F,p),p=t.normalize(p,p);var m=d(p,r,e,a);z=u.fromRotationZ(m,z),k.z=o,B=s.multiplyTransformation(B,s.fromRotationTranslation(z,k,j),B);var E=G;E[0]=c;for(var v=0;l>v;v++)for(var O=0;O<n.length;O+=3)y=t.fromArray(n,O,y),y=u.multiplyByVector(E,y,y),y=s.multiplyByPoint(B,y,y),y=s.multiplyByPoint(h,y,y),i.push(y.x,y.y,y.z);return i}function E(e,r,n,i,a,o,u){for(var s=0;s<e.length;s+=3){var c=t.fromArray(e,s,X);i=y(c,r,n,i,a,o[s/3],u,1)}return i}function v(e,r,n,i,a,o,u,s){for(var c=0;c<e.length;c+=3){var l=t.fromArray(e,c,X);i=m(l,r,n,i,a,o[c/3],u,1,s)}return i}function O(e,t){var r=e.length,n=new Array(6*r),i=0,a=t.x+t.width/2,o=t.y+t.height/2,u=e[0];n[i++]=u.x-a,n[i++]=0,n[i++]=u.y-o;for(var s=1;r>s;s++){u=e[s];var c=u.x-a,l=u.y-o;n[i++]=c,n[i++]=0,n[i++]=l,n[i++]=c,n[i++]=0,n[i++]=l}return u=e[0],n[i++]=u.x-a,n[i++]=0,n[i++]=u.y-o,n}function w(e,t){for(var r=e.length,n=new Array(3*r),i=0,a=t.x+t.width/2,o=t.y+t.height/2,u=0;r>u;u++)n[i++]=e[u].x-a,n[i++]=0,n[i++]=e[u].y-o;return n}function g(e,r,n,a,s,c,f,h,p,d){var m,E=t.angleBetween(t.subtract(r,e,P),t.subtract(n,e,C)),v=a===i.BEVELED?0:Math.ceil(E/o.toRadians(5));m=s?u.fromQuaternion(l.fromAxisAngle(t.negate(e,P),E/(v+1),H),Z):u.fromQuaternion(l.fromAxisAngle(e,E/(v+1),H),Z);var O,w;if(r=t.clone(r,Y),v>0)for(var g=d?2:1,_=0;v>_;_++)r=u.multiplyByVector(m,r,r),O=t.subtract(r,e,P),O=t.normalize(O,O),s||(O=t.negate(O,O)),w=c.scaleToGeodeticSurface(r,C),f=y(w,O,h,f,c,p,1,g);else O=t.subtract(r,e,P),O=t.normalize(O,O),s||(O=t.negate(O,O)),w=c.scaleToGeodeticSurface(r,C),f=y(w,O,h,f,c,p,1,1),n=t.clone(n,Y),O=t.subtract(n,e,P),O=t.normalize(O,O),s||(O=t.negate(O,O)),w=c.scaleToGeodeticSurface(n,C),f=y(w,O,h,f,c,p,1,1);return f}var _=[new t,new t],T=new t,b=new t,R=new t,A=new t,S=new t,x=new t,N=new t,I=new t,M=new t,P=new t,C=new t,D={},q=new n,U=new t,L=new t,F=new t(-1,0,0),B=s.clone(s.IDENTITY),j=new s,z=new u,G=u.IDENTITY.clone(),V=new t,W=new r,k=new t,X=new t,H=new l,Y=new t,Z=new u;D.removeDuplicatesFromShape=function(t){for(var r=t.length,n=[],i=r-1,a=0;r>a;i=a++){var o=t[i],u=t[a];e.equals(o,u)||n.push(u)}return n},D.angleIsGreaterThanPi=function(e,r,n,i){var o=new a(n,i),u=o.projectPointOntoPlane(t.add(n,e,U),U),s=o.projectPointOntoPlane(t.add(n,r,L),L);return s.x*u.y-s.y*u.x>=0};var K=new t,J=new t;return D.computePositions=function(e,r,n,a,u){var s=a._ellipsoid,l=h(e,s),f=a._granularity,d=a._cornerType,m=u?O(r,n):w(r,n),v=u?w(r,n):void 0,C=n.height/2,q=n.width/2,U=e.length,L=[],F=u?[]:void 0,B=T,j=b,z=R,G=A,V=S,W=x,k=N,X=I,H=M,Y=e[0],Z=e[1];G=s.geodeticSurfaceNormal(Y,G),B=t.subtract(Z,Y,B),B=t.normalize(B,B),X=t.cross(G,B,X),X=t.normalize(X,X);var Q=l[0],$=l[1];u&&(F=y(Y,X,v,F,s,Q+C,1,1)),H=t.clone(Y,H),Y=Z,j=t.negate(B,j);for(var ee,te,re=1;U-1>re;re++){var ne=u?2:1;Z=e[re+1],B=t.subtract(Z,Y,B),B=t.normalize(B,B),z=t.add(B,j,z),z=t.normalize(z,z),G=s.geodeticSurfaceNormal(Y,G);var ie=t.multiplyByScalar(G,t.dot(B,G),K);t.subtract(B,ie,ie),t.normalize(ie,ie);var ae=t.multiplyByScalar(G,t.dot(j,G),J);t.subtract(j,ae,ae),t.normalize(ae,ae);var oe=!o.equalsEpsilon(Math.abs(t.dot(ie,ae)),1,o.EPSILON7);if(oe){z=t.cross(z,G,z),z=t.cross(G,z,z),z=t.normalize(z,z);var ue=1/Math.max(.25,t.magnitude(t.cross(z,j,P))),se=D.angleIsGreaterThanPi(B,j,Y,s);se?(V=t.add(Y,t.multiplyByScalar(z,ue*q,z),V),W=t.add(V,t.multiplyByScalar(X,q,W),W),_[0]=t.clone(H,_[0]),_[1]=t.clone(W,_[1]),ee=p(_,Q+C,$+C,f),te=c.generateArc({positions:_,granularity:f,ellipsoid:s}),L=E(te,X,m,L,s,ee,1),X=t.cross(G,B,X),X=t.normalize(X,X),k=t.add(V,t.multiplyByScalar(X,q,k),k),d===i.ROUNDED||d===i.BEVELED?g(V,W,k,d,se,s,L,m,$+C,u):(z=t.negate(z,z),L=y(Y,z,m,L,s,$+C,ue,ne)),H=t.clone(k,H)):(V=t.add(Y,t.multiplyByScalar(z,ue*q,z),V),W=t.add(V,t.multiplyByScalar(X,-q,W),W),_[0]=t.clone(H,_[0]),_[1]=t.clone(W,_[1]),ee=p(_,Q+C,$+C,f),te=c.generateArc({positions:_,granularity:f,ellipsoid:s}),L=E(te,X,m,L,s,ee,1),X=t.cross(G,B,X),X=t.normalize(X,X),k=t.add(V,t.multiplyByScalar(X,-q,k),k),d===i.ROUNDED||d===i.BEVELED?g(V,W,k,d,se,s,L,m,$+C,u):L=y(Y,z,m,L,s,$+C,ue,ne),H=t.clone(k,H)),j=t.negate(B,j)}else L=y(H,X,m,L,s,Q+C,1,1),H=Y;Q=$,$=l[re+1],Y=Z}_[0]=t.clone(H,_[0]),_[1]=t.clone(Y,_[1]),ee=p(_,Q+C,$+C,f),te=c.generateArc({positions:_,granularity:f,ellipsoid:s}),L=E(te,X,m,L,s,ee,1),u&&(F=y(Y,X,v,F,s,$+C,1,1)),U=L.length;var ce=u?U+F.length:U,le=new Float64Array(ce);return le.set(L),u&&le.set(F,U),le},D.computeLocalPositions=function(e,r,n,a,u,l){var d=a._ellipsoid,y=h(e,d),C=a._granularity,q=a._cornerType,U=u?O(r,n):w(r,n),L=u?w(r,n):void 0,F=0,B=n.width/2,j=e.length,z=[],G=u?[]:void 0,V=[],W=T,k=b,X=R,H=A,Y=S,Z=x,Q=N,$=I,ee=M,te=f.eastNorthUpToFixedFrame(l,d,new s),re=s.inverse(te,new s),ne=e[0],ie=e[1];H=d.geodeticSurfaceNormal(ne,H),W=t.subtract(ie,ne,W),W=t.normalize(W,W),$=t.cross(H,W,$),$=t.normalize($,$);var ae=y[0],oe=y[1];u&&(G=m(ne,$,L,G,d,ae+F,1,1,re)),ee=t.clone(ne,ee),ne=ie,k=t.negate(W,k);for(var ue,se,ce=1;j-1>ce;ce++){var le=u?2:1;ie=e[ce+1],W=t.subtract(ie,ne,W),W=t.normalize(W,W),X=t.add(W,k,X),X=t.normalize(X,X),H=d.geodeticSurfaceNormal(ne,H);var fe=t.multiplyByScalar(H,t.dot(W,H),K);t.subtract(W,fe,fe),t.normalize(fe,fe);var he=t.multiplyByScalar(H,t.dot(k,H),J);t.subtract(k,he,he),t.normalize(he,he);var pe=!o.equalsEpsilon(Math.abs(t.dot(fe,he)),1,o.EPSILON7);if(pe){X=t.cross(X,H,X),X=t.cross(H,X,X),X=t.normalize(X,X);var de=1/Math.max(.25,t.magnitude(t.cross(X,k,P))),ye=D.angleIsGreaterThanPi(W,k,ne,d);ye?(Y=t.add(ne,t.multiplyByScalar(X,de*B,X),Y),Z=t.add(Y,t.multiplyByScalar($,B,Z),Z),_[0]=t.clone(ee,_[0]),_[1]=t.clone(Z,_[1]),ue=p(_,ae+F,oe+F,C),se=c.generateArc({positions:_,granularity:C,ellipsoid:d}),z=E(se,$,U,z,d,ue,1,fromEnu,V),$=t.cross(H,W,$),$=t.normalize($,$),Q=t.add(Y,t.multiplyByScalar($,B,Q),Q),q===i.ROUNDED||q===i.BEVELED?g(Y,Z,Q,q,ye,d,z,U,oe+F,u):(X=t.negate(X,X),z=m(ne,X,U,z,d,oe+F,de,le,re)),ee=t.clone(Q,ee)):(Y=t.add(ne,t.multiplyByScalar(X,de*B,X),Y),Z=t.add(Y,t.multiplyByScalar($,-B,Z),Z),_[0]=t.clone(ee,_[0]),_[1]=t.clone(Z,_[1]),ue=p(_,ae+F,oe+F,C),se=c.generateArc({positions:_,granularity:C,ellipsoid:d}),z=E(se,$,U,z,d,ue,1),$=t.cross(H,W,$),$=t.normalize($,$),Q=t.add(Y,t.multiplyByScalar($,-B,Q),Q),q===i.ROUNDED||q===i.BEVELED?g(Y,Z,Q,q,ye,d,z,U,oe+F,u):z=m(ne,X,U,z,d,oe+F,de,le,re),ee=t.clone(Q,ee)),k=t.negate(W,k)}else z=m(ee,$,U,z,d,ae+F,1,1,re),ee=ne;ae=oe,oe=y[ce+1],ne=ie}_[0]=t.clone(ee,_[0]),_[1]=t.clone(ne,_[1]),ue=p(_,ae+F,oe+F,C),se=c.generateArc({positions:_,granularity:C,ellipsoid:d}),z=v(se,$,U,z,d,ue,1,re),u&&(G=m(ne,$,L,G,d,oe+F,1,1,re)),j=z.length;var me=u?j+G.length:j,Ee=new Float64Array(me);return Ee.set(z),u&&Ee.set(G,j),Ee},D}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,a){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");return a=e(a,0),i[a++]=n.position?1:0,i[a++]=n.normal?1:0,i[a++]=n.st?1:0,i[a++]=n.tangent?1:0,i[a++]=n.bitangent?1:0,i[a]=n.color?1:0,i},i.unpack=function(n,a,o){if(!t(n))throw new r("array is required");return a=e(a,0),t(o)||(o=new i),o.position=1===n[a++],o.normal=1===n[a++],o.st=1===n[a++],o.tangent=1===n[a++],o.bitangent=1===n[a++],o.color=1===n[a],o},i.clone=function(e,r){return t(e)?(t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r):void 0},i}),define("Core/PolylineVolumeGeometry",["./arrayRemoveDuplicates","./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryPipeline","./IndexDatatype","./Math","./oneTimeWarning","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./VertexFormat","./WindingOrder"],function(e,t,r,n,i,a,o,u,s,c,l,f,h,p,d,y,m,E,v,O,w,g,_){"use strict";function T(e,t,n,i){var o=e.combinedPositions,u=e.combinedLocalPositions,c=new p;i.position&&(c.position=new h({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:o}));var l,m,O,g,_,T,b=t.length,R=o.length/3,A=(R-2*b)/(2*b),S=v.triangulate(t),x=(A-1)*b*6+2*S.length,N=y.createTypedArray(R,x),I=2*b,M=0;for(l=0;A-1>l;l++){for(m=0;b-1>m;m++)O=2*m+l*b*2,T=O+I,g=O+1,_=g+I,N[M++]=g,N[M++]=O,N[M++]=_,N[M++]=_,N[M++]=O,N[M++]=T;O=2*b-2+l*b*2,g=O+1,_=g+I,T=O+I,N[M++]=g,N[M++]=O,N[M++]=_,N[M++]=_,N[M++]=O,N[M++]=T}if(i.st||i.tangent||i.bitangent){var P,C,D=new Float32Array(2*R),q=1/(A-1),U=1/n.height,L=n.height/2,F=0;for(l=0;A>l;l++){for(P=l*q,C=U*(t[0].y+L),D[F++]=P,D[F++]=C,m=1;b>m;m++)C=U*(t[m].y+L),D[F++]=P,D[F++]=C,D[F++]=P,D[F++]=C;C=U*(t[0].y+L),D[F++]=P,D[F++]=C}for(m=0;b>m;m++)P=0,C=U*(t[m].y+L),D[F++]=P,D[F++]=C;for(m=0;b>m;m++)P=(A-1)*q,C=U*(t[m].y+L),D[F++]=P,D[F++]=C;c.st=new h({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:new Float32Array(D)})}var B=R-2*b;for(l=0;l<S.length;l+=3){var j=S[l]+B,z=S[l+1]+B,G=S[l+2]+B;N[M++]=j,N[M++]=z,N[M++]=G,N[M++]=G+b,N[M++]=z+b,N[M++]=j+b}var V=new f({attributes:c,indices:N,boundingSphere:r.fromVertices(o),primitiveType:w.TRIANGLES});if(i.normal&&(V=d.computeNormal(V)),i.tangent||i.bitangent){
try{V=d.computeTangentAndBitangent(V)}catch(W){E("polyline-volume-tangent-bitangent","Unable to compute tangents and bitangents for polyline volume geometry")}i.tangent||(V.attributes.tangent=void 0),i.bitangent||(V.attributes.bitangent=void 0),i.st||(V.attributes.st=void 0)}return s(u)&&(V.attributes.position.values=u,V.attributes.position.componentDatatype=a.FLOAT),V}function b(e){e=u(e,u.EMPTY_OBJECT);var t=e.polylinePositions,r=e.shapePositions;if(!s(t))throw new c("options.polylinePositions is required.");if(!s(r))throw new c("options.shapePositions is required.");this._positions=t,this._shape=r,this._ellipsoid=l.clone(u(e.ellipsoid,l.WGS84)),this._cornerType=u(e.cornerType,o.ROUNDED),this._vertexFormat=g.clone(u(e.vertexFormat,g.DEFAULT)),this._granularity=u(e.granularity,m.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry",this.enuCenter=u(e.enuCenter,i.ZERO);var a=1+t.length*i.packedLength;a+=1+r.length*n.packedLength+i.packedLength,this.packedLength=a+l.packedLength+g.packedLength+2}b.pack=function(e,t,r){if(!s(e))throw new c("value is required");if(!s(t))throw new c("array is required");r=u(r,0);var a,o=e._positions,f=o.length;for(t[r++]=f,a=0;f>a;++a,r+=i.packedLength)i.pack(o[a],t,r);var h=e._shape;for(f=h.length,t[r++]=f,a=0;f>a;++a,r+=n.packedLength)n.pack(h[a],t,r);return l.pack(e._ellipsoid,t,r),r+=l.packedLength,g.pack(e._vertexFormat,t,r),r+=g.packedLength,t[r++]=e._cornerType,t[r++]=e._granularity,i.pack(e.enuCenter,t,r),t};var R=l.clone(l.UNIT_SPHERE),A=new g,S={polylinePositions:void 0,shapePositions:void 0,ellipsoid:R,vertexFormat:A,cornerType:void 0,granularity:void 0,enuCenter:void 0};b.unpack=function(e,t,r){if(!s(e))throw new c("array is required");t=u(t,0);var a,o=e[t++],f=new Array(o);for(a=0;o>a;++a,t+=i.packedLength)f[a]=i.unpack(e,t);o=e[t++];var h=new Array(o);for(a=0;o>a;++a,t+=n.packedLength)h[a]=n.unpack(e,t);var p=l.unpack(e,t,R);t+=l.packedLength;var d=g.unpack(e,t,A);t+=g.packedLength;var y,m=e[t++],E=e[t++];return y=i.unpack(e,t),s(r)?(r._positions=f,r._shape=h,r._ellipsoid=l.clone(p,r._ellipsoid),r._vertexFormat=g.clone(d,r._vertexFormat),r._cornerType=m,r._granularity=E,r.enuCenter=y,r):(S.polylinePositions=f,S.shapePositions=h,S.cornerType=m,S.granularity=E,S.enuCenter=y,new b(S))};var x=new t;return b.createGeometry=function(r){for(var n=r._positions,a=e(n,i.equalsEpsilon),o=a.length,u=new Array(o),s=0;o>s;s++)u[s]=i.clone(a[s]);var c=r._shape;if(c=O.removeDuplicatesFromShape(c),!(a.length<2||c.length<3)){v.computeWindingOrder2D(c)===_.CLOCKWISE&&c.reverse();var l=t.fromPoints(c,x),f={};if(f.combinedPositions=O.computePositions(u,c,l,r,!0),!i.equals(r.enuCenter,i.ZERO)){for(var h=new Array(o),s=0;o>s;s++)h[s]=i.clone(a[s]);f.combinedLocalPositions=O.computeLocalPositions(h,c,l,r,!0,r.enuCenter)}return T(f,c,l,r._vertexFormat)}},b}),define("Workers/createPolylineVolumeGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolylineVolumeGeometry"],function(e,t,r){"use strict";function n(n,i){return e(i)&&(n=r.unpack(n,i)),n._ellipsoid=t.clone(n._ellipsoid),r.createGeometry(n)}return n})}();