/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(n,i){if(!e(i))throw new t(r(n))},i.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},i.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},i.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},i.typeOf.number.lessThan=function(e,r,n){if(i.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},i.typeOf.number.lessThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},i.typeOf.number.greaterThan=function(e,r,n){if(i.typeOf.number(e,r),n>=r)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},i.typeOf.number.greaterThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),n>r)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},i.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},i.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},i.typeOf.number.equals=function(e,r,n,o){if(i.typeOf.number(e,n),i.typeOf.number(r,o),n!==o)throw new t(e+" must be equal to "+r+", the actual values are "+n+" and "+o)},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e&&null!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n,i){"use strict";var o={};o.Radius=6378137,o.EPSILON1=.1,o.EPSILON2=.01,o.EPSILON3=.001,o.EPSILON4=1e-4,o.EPSILON5=1e-5,o.EPSILON6=1e-6,o.EPSILON7=1e-7,o.EPSILON8=1e-8,o.EPSILON9=1e-9,o.EPSILON10=1e-10,o.EPSILON11=1e-11,o.EPSILON12=1e-12,o.EPSILON13=1e-13,o.EPSILON14=1e-14,o.EPSILON15=1e-15,o.EPSILON16=1e-16,o.EPSILON17=1e-17,o.EPSILON18=1e-18,o.EPSILON19=1e-19,o.EPSILON20=1e-20,o.EPSILON21=1e-21,o.GRAVITATIONALPARAMETER=3986004418e5,o.SOLAR_RADIUS=6955e5,o.LUNAR_RADIUS=1737400,o.SIXTY_FOUR_KILOBYTES=65536,o.sign=r(Math.sign,function(e){return e=+e,0===e||e!==e?e:e>0?1:-1}),o.signNotZero=function(e){return 0>e?-1:1},o.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*o.clamp(e,-1,1)+.5)*t)},o.fromSNorm=function(e,t){return t=r(t,255),o.clamp(e,0,t)/t*2-1},o.sinh=r(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),o.cosh=r(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),o.lerp=function(e,t,r){return(1-r)*e+r*t},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=Math.PI/2,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI/2,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*o.RADIANS_PER_DEGREE},o.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=o.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},o.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return o.clamp(e,-1*o.PI_OVER_TWO,o.PI_OVER_TWO)},o.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return o.zeroToTwoPi(e+o.PI)-o.PI},o.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=o.mod(e,o.TWO_PI);return Math.abs(t)<o.EPSILON14&&Math.abs(e)>o.EPSILON14?o.TWO_PI:t},o.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},o.equalsEpsilon=function(e,t,o,a){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(o))throw new i("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-t);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(t))},o.lessThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return-r>e-t},o.lessThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return r>e-t},o.greaterThan=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>r},o.greaterThanOrEquals=function(e,t,r){if(!n(e))throw new i("first is required.");if(!n(t))throw new i("second is required.");if(!n(r))throw new i("relativeEpsilon is required.");return e-t>-r};var a=[1];o.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],n=t;e>=n;n++)a.push(r*n);return a[e]},o.incrementWrap=function(e,t,o){if(o=r(o,0),!n(e))throw new i("n is required.");if(o>=t)throw new i("maximumValue must be greater than minimumValue.");return++e,e>t&&(e=o),e},o.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},o.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},o.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return t>e?t:e>r?r:e};var u=new e;return o.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},o.nextRandomNumber=function(){return u.random()},o.randomBetween=function(e,t){return o.nextRandomNumber()*(t-e)+e},o.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(o.clamp(e,-1,1))},o.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(o.clamp(e,-1,1))},o.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},o.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},o.cbrt=r(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return 0>e?-t:t}),o.log2=r(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),o.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},o.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},o.fastApproximateAtan2=function(e,r){t.typeOf.number("x",e),t.typeOf.number("y",r);var n,a,u=Math.abs(e);n=Math.abs(r),a=Math.max(u,n),n=Math.min(u,n);var s=n/a;if(isNaN(s))throw new i("either x or y must be nonzero");return u=o.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?o.PI_OVER_TWO-u:u,u=0>e?o.PI-u:u,u=0>r?-u:u},o}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,o){"use strict";function a(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}a.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new a);var o=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(o),i.y=c*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var o=0;i>o;++o)a.pack(t[o],n,3*o);return n},a.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var o=t.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=u/3;i[s]=a.unpack(t,u,i[s])}return i},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a,f=new a;a.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f);var n=a.dot(c,f),i=a.magnitude(a.cross(c,f,c));return Math.atan2(i,n)};var l=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Z,r):n.y<=n.z?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_Z,r)},a.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=a.dot(t,r)/a.dot(r,r);return a.multiplyByScalar(r,i,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)&&o.equalsEpsilon(e.z,t.z,n,i)},a.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=r.x,s=r.y,c=r.z,f=o*c-a*s,l=a*u-i*c,p=i*s-o*u;return n.x=f,n.y=l,n.z=p,n},a.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},a.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=o.toRadians(t),r=o.toRadians(r),a.fromRadians(t,r,n,i,u)};var p=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445),y=new a(40680631590769,40680631590769,40680631590769);return a.fromRadians=function(n,i,u,s,c){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),u=t(u,0);var f=r(s)?s.radiiSquared:y;o.equalsEpsilon(o.Radius,6356752.314245179,o.EPSILON10)&&(f=r(s)?s.radiiSquared:d);var l=Math.cos(i);p.x=l*Math.cos(n),p.y=l*Math.sin(n),p.z=Math.sin(i),p=a.normalize(p,p),a.multiplyComponents(f,p,h);var m=Math.sqrt(a.dot(p,h));return h=a.divideByScalar(h,m,h),p=a.multiplyByScalar(p,u,p),r(c)||(c=new a),a.add(h,p,c)},a.fromDegreesArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(o)?o.length=u/2:o=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;o[l]=a.fromDegrees(c,f,0,i,o[l])}return o},a.fromRadiansArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(o)?o.length=u/2:o=new Array(u/2);for(var s=0;u>s;s+=2){var c=t[s],f=t[s+1],l=s/2;o[l]=a.fromRadians(c,f,0,i,o[l])}return o},a.fromDegreesArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(o)?o.length=u/3:o=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;o[p]=a.fromDegrees(c,f,l,i,o[p])}return o},a.fromRadiansArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(o)?o.length=u/3:o=new Array(u/3);for(var s=0;u>s;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;o[p]=a.fromRadians(c,f,l,i,o[p])}return o},a.ZERO=i(new a(0,0,0)),a.UNIT_X=i(new a(1,0,0)),a.UNIT_Y=i(new a(0,1,0)),a.UNIT_Z=i(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(i,u,s,c,f){if(!t(i))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=i.x,p=i.y,h=i.z,d=u.x,y=u.y,m=u.z,E=l*l*d*d,_=p*p*y*y,O=h*h*m*m,T=E+_+O,w=Math.sqrt(1/T),R=e.multiplyByScalar(i,w,o);if(c>T)return isFinite(w)?e.clone(R,f):void 0;var v=s.x,A=s.y,b=s.z,g=a;g.x=R.x*v*2,g.y=R.y*A*2,g.z=R.z*b*2;var S,I,N,M,C,x,P,U,D,q,F,L=(1-w)*e.magnitude(i)/(.5*e.magnitude(g)),j=0;do{L-=j,N=1/(1+L*v),M=1/(1+L*A),C=1/(1+L*b),x=N*N,P=M*M,U=C*C,D=x*N,q=P*M,F=U*C,S=E*x+_*P+O*U-1,I=E*D*v+_*q*A+O*F*b;var B=-2*I;j=S/B}while(Math.abs(S)>n.EPSILON12);return t(f)?(f.x=l*N,f.y=p*M,f.z=h*C,f):new e(l*N,p*M,h*C)}var o=new e,a=new e;return i}),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,o,a){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,o,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),o=r(o,0),n(a)?(a.longitude=e,a.latitude=i,a.height=o,a):new u(e,i,o)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=o.toRadians(e),r=o.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/6378137,1/6378137,1/6378137),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=new e(1/40680631590769,1/40680631590769,1/40680631590769),y=o.EPSILON1;return u.fromCartesian=function(t,r,i){var m=n(r)?r.oneOverRadii:p,E=n(r)?r.oneOverRadiiSquared:d,_=n(r)?r._centerToleranceSquared:y;o.equalsEpsilon(o.Radius,6356752.314245179,o.EPSILON10)&&(m=n(r)?r.oneOverRadii:l,E=n(r)?r.oneOverRadiiSquared:h);var O=a(t,m,E,_,c);if(n(O)){var T=e.multiplyComponents(O,E,s);T=e.normalize(T,T);var w=e.subtract(t,O,f),R=Math.atan2(T.y,T.x),v=Math.asin(T.z),A=o.sign(e.dot(w,t))*e.magnitude(w);return n(i)?(i.longitude=R,i.latitude=v,i.height=A,i):new u(R,v,A)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.sphericalDistance=function(e,r,n,i){if(t.defined("longitudeA",e),t.defined("longitudeB",n),t.defined("latitudeA",r),t.defined("latitudeB",i),e===n&&r===i)return 0;var a=o.toRadians(r),u=o.toRadians(i),s=o.toRadians(e),c=o.toRadians(n),f=s*s+a*a,l=c*c+u*u,p=(s-c)*(s-c)+(a-u)*(a-u),h=(f+l-p)/(2*Math.sqrt(f)*Math.sqrt(l));return h=o.clamp(h,-1,1),Math.acos(h)*o.Radius},u.clone=function(e,t){return n(e)?n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height):void 0},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,o,a,u,s,c){"use strict";function f(t,i,o,a){i=n(i,0),o=n(o,0),a=n(a,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",o,0),r.typeOf.number.greaterThanOrEquals("z",a,0),s.equalsEpsilon(a,6356752.314245179,s.EPSILON10)&&(s.Radius=a),t._radii=new e(i,o,a),t._radiiSquared=new e(i*i,o*o,a*a),t._radiiToTheFourth=new e(i*i*i*i,o*o*o*o,a*a*a*a),t._oneOverRadii=new e(0===i?0:1/i,0===o?0:1/o,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===o?0:1/(o*o),0===a?0:1/(a*a)),t._minimumRadius=Math.min(i,o,a),t._maximumRadius=Math.max(i,o,a),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}o(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return i(t)||(t=new l),i(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,s.Radius)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,i,o){return r.typeOf.object("value",t),r.defined("array",i),o=n(o,0),e.pack(t._radii,i,o),i},l.unpack=function(t,i,o){r.defined("array",t),i=n(i,0);var a=e.unpack(t,i);return l.fromCartesian3(a,o)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var o=t.longitude,a=t.latitude,u=Math.cos(a),s=u*Math.cos(o),c=u*Math.sin(o),f=Math.sin(a);return i(n)||(n=new e),n.x=s,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var p=new e,h=new e;l.prototype.cartographicToCartesian=function(t,r){var n=p,o=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(o,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var o=0;n>o;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var d=new e,y=new e,m=new e;return l.prototype.cartesianToCartographic=function(r,n){var o=this.scaleToGeodeticSurface(r,y);if(i(o)){var a=this.geodeticSurfaceNormal(o,d),u=e.subtract(r,o,m),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var o=0;n>o;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var o=t.x,a=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(o*o*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,o,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),o=n(o,0);var c=this._squaredXOverSquaredZ;return i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),Math.abs(u.z)>=this._radii.z-o?void 0:u},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,o,a){"use strict";function u(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,o=t.longitude*i,a=t.latitude*i,u=t.height;return n(r)?(r.x=o,r.y=a,r.z=u,r):new e(o,a,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=a,r.latitude=u,r.height=s,r):new t(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i,o,a,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;9>r;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function f(e){for(var t=0,r=0;3>r;++r){var n=e[s.getElementIndex(y[r],d[r])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var r=u.EPSILON15,n=0,i=1,o=0;3>o;++o){var a=Math.abs(e[s.getElementIndex(y[o],d[o])]);a>n&&(i=o,n=a)}var c=1,f=0,l=d[i],p=y[i];if(Math.abs(e[s.getElementIndex(p,l)])>r){var h,m=e[s.getElementIndex(p,p)],E=e[s.getElementIndex(l,l)],_=e[s.getElementIndex(p,l)],O=(m-E)/2/_;h=0>O?-1/(-O+Math.sqrt(1+O*O)):1/(O+Math.sqrt(1+O*O)),c=1/Math.sqrt(1+h*h),f=h*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(l,l)]=t[s.getElementIndex(p,p)]=c,t[s.getElementIndex(p,l)]=f,t[s.getElementIndex(l,p)]=-f,t}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},s.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},s.fromArray=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,p=e.z*e.z,h=e.z*e.w,d=e.w*e.w,y=i-c-p+d,m=2*(o-h),E=2*(a+l),_=2*(o+h),O=-i+c-p+d,T=2*(f-u),w=2*(a-l),R=2*(f+u),v=-i-c+p+d;return n(r)?(r[0]=y,r[1]=_,r[2]=w,r[3]=m,r[4]=O,r[5]=R,r[6]=E,r[7]=T,r[8]=v,r):new s(y,m,E,_,O,T,w,R,v)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),o=Math.cos(-e.heading),a=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=i*o,p=-a*c+f*u*o,h=f*c+a*u*o,d=i*c,y=a*o+f*u*c,m=-f*o+a*u*c,E=-u,_=f*i,O=a*i;return n(r)?(r[0]=l,r[1]=d,r[2]=E,r[3]=p,r[4]=y,r[5]=_,r[6]=h,r[7]=m,r[8]=O,r):new s(l,p,h,d,y,m,E,_,O)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new s(1,0,0,0,i,-o,0,o,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new s(i,0,o,0,1,0,-o,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-o,0,o,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,o=e[i],a=e[i+1],u=e[i+2];return n.x=o,n.y=a,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i);var o=3*r;return i[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),
t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],o=e[r+3],a=e[r+6];return n.x=i,n.y=o,n.z=a,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i),i[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var p=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],p)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],p)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],p)),n};var h=new e;s.getMaximumScale=function(t){return s.getScale(t,h),e.maximumComponent(h)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=p,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,o=r.y,a=r.z,u=e[0]*i+e[3]*o+e[6]*a,s=e[1]*i+e[4]*o+e[7]*a,c=e[2]*i+e[5]*o+e[8]*a;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=i,r[2]=o,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var d=[1,0,0],y=[2,2,1],m=new s,E=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,o=10,a=0,p=0;n(r)||(r={});for(var h=r.unitary=s.clone(s.IDENTITY,r.unitary),d=r.diagonal=s.clone(e,r.diagonal),y=i*c(d);o>p&&f(d)>y;)l(d,m),s.transpose(m,E),s.multiply(d,m,d),s.multiply(E,d,d),s.multiply(h,m,h),++a>2&&(++p,a=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],o=e[1],a=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(a*f-c*u)+o*(c*i-n*f)+s*(n*u-a*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],a=e[2],c=e[3],f=e[4],l=e[5],p=e[6],h=e[7],d=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new o("matrix is not invertible");r[0]=f*d-h*l,r[1]=h*a-i*d,r[2]=i*l-f*a,r[3]=p*l-c*d,r[4]=n*d-p*a,r[5]=c*a-n*l,r[6]=c*h-p*f,r[7]=p*i-n*h,r[8]=n*f-c*i;var m=1/y;return s.multiplyByScalar(r,m,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=a(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,o){"use strict";function a(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}a.fromElements=function(e,t,n,i,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=i,o):new a(e,t,n,i)},a.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i++],o.w=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var o=0;i>o;++o)a.pack(t[o],n,4*o);return n},a.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var o=0;i>o;o+=4){var u=o/4;n[u]=a.unpack(t,o,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,c);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)&&o.equalsEpsilon(e.z,t.z,n,i)&&o.equalsEpsilon(e.w,t.w,n,i)},a.ZERO=i(new a(0,0,0,0)),a.UNIT_X=i(new a(1,0,0,0)),a.UNIT_Y=i(new a(0,1,0,0)),a.UNIT_Z=i(new a(0,0,1,0)),a.UNIT_W=i(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1),l=256,p=65536,h=16777216,d=1/l,y=1/p,m=1/h,E=38;return a.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new a),f[0]=t,t=f[0],0===t)return a.clone(a.ZERO,n);var i,u=0>t?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(o.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=E);var s=t*l;return n.x=Math.floor(s),s=(s-n.x)*l,n.y=Math.floor(s),s=(s-n.y)*l,n.z=Math.floor(s),n.w=2*(i+E)+u,n},a.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(n-=E,i=2*i-1,i=-i,n>=E)return 0>i?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var o=i*t.x*d;return o+=i*t.y*y,o+=i*t.z*m,o*Math.pow(10,n)},a}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,o,a,u,s,c){"use strict";function f(e,t,r,i,o,a,u,s,c,f,l,p,h,d,y,m){this[0]=n(e,0),this[1]=n(o,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(a,0),this[6]=n(f,0),this[7]=n(d,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(p,0),this[15]=n(m,0)}f.packedLength=16,f.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},f.unpack=function(e,t,o){return r.defined("array",e),t=n(t,0),i(o)||(o=new f),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o[9]=e[t++],o[10]=e[t++],o[11]=e[t++],o[12]=e[t++],o[13]=e[t++],o[14]=e[t++],o[15]=e[t],o},f.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,o,a){return r.typeOf.object("rotation",t),o=n(o,e.ZERO),i(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new f(t[0],t[3],t[6],o.x,t[1],t[4],t[7],o.y,t[2],t[5],t[8],o.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,o){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(o)||(o=new f);var a=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,p=t.x*t.z,h=t.x*t.w,d=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,_=t.z*t.w,O=t.w*t.w,T=c-d-E+O,w=2*(l-_),R=2*(p+m),v=2*(l+_),A=-c+d-E+O,b=2*(y-h),g=2*(p-m),S=2*(y+h),I=-c-d+E+O;return o[0]=T*a,o[1]=v*a,o[2]=g*a,o[3]=0,o[4]=w*u,o[5]=A*u,o[6]=S*u,o[7]=0,o[8]=R*s,o[9]=b*s,o[10]=I*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,p=new e,h=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var o=t.position,a=t.direction,u=t.up;r.typeOf.object("camera.position",o),r.typeOf.object("camera.direction",a),r.typeOf.object("camera.up",u),e.normalize(a,l),e.normalize(e.cross(l,u,p),p),e.normalize(e.cross(p,l,h),h);var s=p.x,c=p.y,d=p.z,y=l.x,m=l.y,E=l.z,_=h.x,O=h.y,T=h.z,w=o.x,R=o.y,v=o.z,A=s*-w+c*-R+d*-v,b=_*-w+O*-R+T*-v,g=y*w+m*R+E*v;return i(n)?(n[0]=s,n[1]=_,n[2]=-y,n[3]=0,n[4]=c,n[5]=O,n[6]=-m,n[7]=0,n[8]=d,n[9]=T,n[10]=-E,n[11]=0,n[12]=A,n[13]=b,n[14]=g,n[15]=1,n):new f(s,c,d,A,_,O,T,b,-y,-m,-E,g,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,i,o){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",o);var a=Math.tan(.5*e),u=1/a,s=u/t,c=(i+n)/(n-i),f=2*i*n/(n-i);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=u,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=f,o[15]=0,o},f.computeOrthographicOffCenter=function(e,t,n,i,o,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),f=1/(a-o),l=-(t+e)*s,p=-(i+n)*c,h=-(a+o)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=p,u[14]=h,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,i,o,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=2*o/(t-e),c=2*o/(i-n),f=(t+e)/(t-e),l=(i+n)/(i-n),p=-(a+o)/(a-o),h=-1,d=-2*a*o/(a-o);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=p,u[11]=h,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,i,o,a){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.object("result",a);var u=2*o/(t-e),s=2*o/(i-n),c=(t+e)/(t-e),f=(i+n)/(i-n),l=-1,p=-1,h=-2*o;return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=l,a[11]=p,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},f.computeViewportTransformation=function(e,t,i,o){r.typeOf.object("result",o),e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),i=n(i,1);var f=.5*s,l=.5*c,p=.5*(i-t),h=f,d=l,y=p,m=a+f,E=u+l,_=t+p,O=1;return o[0]=h,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=d,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=y,o[11]=0,o[12]=m,o[13]=E,o[14]=_,o[15]=O,o},f.computeView=function(t,n,i,o,a){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",o),r.typeOf.object("result",a),a[0]=o.x,a[1]=i.x,a[2]=-n.x,a[3]=0,a[4]=o.y,a[5]=i.y,a[6]=-n.y,a[7]=0,a[8]=o.z,a[9]=i.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(o,t),a[13]=-e.dot(i,t),a[14]=e.dot(n,t),a[15]=1,a},f.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,o=e[i],a=e[i+1],u=e[i+2],s=e[i+3];return n.x=o,n.y=a,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i);var o=4*t;return i[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i[o+3]=n.w,i},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var d=new e;f.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var o=f.getScale(t,d),a=e.divideComponents(n,o,d);return f.multiplyByScale(t,a,i)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],o=e[t+4],a=e[t+8],u=e[t+12];return n.x=i,n.y=o,n.z=a,n.w=u,n},f.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var y=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var m=new e;f.getMaximumScale=function(t){return f.getScale(t,m),e.maximumComponent(m)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],p=e[8],h=e[9],d=e[10],y=e[11],m=e[12],E=e[13],_=e[14],O=e[15],T=t[0],w=t[1],R=t[2],v=t[3],A=t[4],b=t[5],g=t[6],S=t[7],I=t[8],N=t[9],M=t[10],C=t[11],x=t[12],P=t[13],U=t[14],D=t[15],q=i*T+s*w+p*R+m*v,F=o*T+c*w+h*R+E*v,L=a*T+f*w+d*R+_*v,j=u*T+l*w+y*R+O*v,B=i*A+s*b+p*g+m*S,z=o*A+c*b+h*g+E*S,G=a*A+f*b+d*g+_*S,V=u*A+l*b+y*g+O*S,k=i*I+s*N+p*M+m*C,X=o*I+c*N+h*M+E*C,W=a*I+f*N+d*M+_*C,H=u*I+l*N+y*M+O*C,Y=i*x+s*P+p*U+m*D,K=o*x+c*P+h*U+E*D,Z=a*x+f*P+d*U+_*D,J=u*x+l*P+y*U+O*D;return n[0]=q,n[1]=F,n[2]=L,n[3]=j,n[4]=B,n[5]=z,n[6]=G,n[7]=V,n[8]=k,n[9]=X,n[10]=W,n[11]=H,n[12]=Y,n[13]=K,n[14]=Z,n[15]=J,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],h=e[12],d=e[13],y=e[14],m=t[0],E=t[1],_=t[2],O=t[4],T=t[5],w=t[6],R=t[8],v=t[9],A=t[10],b=t[12],g=t[13],S=t[14],I=i*m+u*E+f*_,N=o*m+s*E+l*_,M=a*m+c*E+p*_,C=i*O+u*T+f*w,x=o*O+s*T+l*w,P=a*O+c*T+p*w,U=i*R+u*v+f*A,D=o*R+s*v+l*A,q=a*R+c*v+p*A,F=i*b+u*g+f*S+h,L=o*b+s*g+l*S+d,j=a*b+c*g+p*S+y;return n[0]=I,n[1]=N,n[2]=M,n[3]=0,n[4]=C,n[5]=x,n[6]=P,n[7]=0,n[8]=U,n[9]=D,n[10]=q,n[11]=0,n[12]=F,n[13]=L,n[14]=j,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],h=t[0],d=t[1],y=t[2],m=t[3],E=t[4],_=t[5],O=t[6],T=t[7],w=t[8],R=i*h+u*d+f*y,v=o*h+s*d+l*y,A=a*h+c*d+p*y,b=i*m+u*E+f*_,g=o*m+s*E+l*_,S=a*m+c*E+p*_,I=i*O+u*T+f*w,N=o*O+s*T+l*w,M=a*O+c*T+p*w;return n[0]=R,n[1]=v,n[2]=A,n[3]=0,n[4]=b,n[5]=g,n[6]=S,n[7]=0,n[8]=I,n[9]=N,n[10]=M,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=i*e[0]+o*e[4]+a*e[8]+e[12],s=i*e[1]+o*e[5]+a*e[9]+e[13],c=i*e[2]+o*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z;return 1===i&&1===o&&1===a?f.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=o*e[4],n[5]=o*e[5],n[6]=o*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=t.w,s=e[0]*i+e[4]*o+e[8]*a+e[12]*u,c=e[1]*i+e[5]*o+e[9]*a+e[13]*u,f=e[2]*i+e[6]*o+e[10]*a+e[14]*u,l=e[3]*i+e[7]*o+e[11]*a+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=e[0]*i+e[4]*o+e[8]*a,s=e[1]*i+e[5]*o+e[9]*a,c=e[2]*i+e[6]*o+e[10]*a;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=e[0]*i+e[4]*o+e[8]*a+e[12],s=e[1]*i+e[5]*o+e[9]*a+e[13],c=e[2]*i+e[6]*o+e[10]*a+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.multiplyByPlane=function(n,i,o){r.typeOf.object("matrix",n),r.typeOf.object("plane",i),r.typeOf.object("result",o);var a=new f,u=new f;f.inverse(n,a),f.transpose(a,u);var s=new t(i.normal.x,i.normal.y,i.normal.z,i.distance);f.multiplyByVector(u,s,s),o.normal.x=s.x,o.normal.y=s.y,o.normal.z=s.z;var c=e.magnitude(o.normal);return e.normalize(o.normal,o.normal),o.distance=s.w/c,o},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],o=e[3],a=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var _=new s,O=new s,T=new t,w=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],o=e[4],a=e[8],l=e[12],p=e[1],h=e[5],d=e[9],y=e[13],m=e[2],E=e[6],R=e[10],v=e[14],A=e[3],b=e[7],g=e[11],S=e[15],I=R*S,N=v*g,M=E*S,C=v*b,x=E*g,P=R*b,U=m*S,D=v*A,q=m*g,F=R*A,L=m*b,j=E*A,B=I*h+C*d+x*y-(N*h+M*d+P*y),z=N*p+U*d+F*y-(I*p+D*d+q*y),G=M*p+D*h+L*y-(C*p+U*h+j*y),V=P*p+q*h+j*d-(x*p+F*h+L*d),k=N*o+M*a+P*l-(I*o+C*a+x*l),X=I*i+D*a+q*l-(N*i+U*a+F*l),W=C*i+U*o+j*l-(M*i+D*o+L*l),H=x*i+F*o+L*a-(P*i+q*o+j*a);I=a*y,N=l*d,M=o*y,C=l*h,x=o*d,P=a*h,U=i*y,D=l*p,q=i*d,F=a*p,L=i*h,j=o*p;var Y=I*b+C*g+x*S-(N*b+M*g+P*S),K=N*A+U*g+F*S-(I*A+D*g+q*S),Z=M*A+D*b+L*S-(C*A+U*b+j*S),J=P*A+q*b+j*g-(x*A+F*b+L*g),Q=M*R+P*v+N*E-(x*v+I*E+C*R),$=q*v+I*m+D*R-(U*R+F*v+N*m),ee=U*E+j*v+C*m-(L*v+M*m+D*E),te=L*R+x*m+F*E-(q*E+j*R+P*m),re=i*B+o*z+a*G+l*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(f.getRotation(e,_),O,u.EPSILON7)&&t.equals(f.getRow(e,3,T),w))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=B*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=k*re,n[5]=X*re,n[6]=W*re,n[7]=H*re,n[8]=Y*re,n[9]=K*re,n[10]=Z*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],o=e[2],a=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],p=e[12],h=e[13],d=e[14],y=-n*p-i*h-o*d,m=-a*p-u*h-s*d,E=-c*p-f*h-l*d;return t[0]=n,t[1]=a,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=f,t[7]=0,t[8]=o,t[9]=s,t[10]=l,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,o(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,o,a){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),o=u.toRadians(r(o,0)),n(a)?(a.west=e,a.south=t,a.east=i,a.north=o,a):new s(e,t,i,o)},s.fromRadians=function(e,t,i,o,a){return n(a)?(a.west=r(e,0),a.south=r(t,0),a.east=r(i,0),a.north=r(o,0),
a):new s(e,t,i,o)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,p=0,h=e.length;h>p;p++){var d=e[p];i=Math.min(i,d.longitude),o=Math.max(o,d.longitude),f=Math.min(f,d.latitude),l=Math.max(l,d.latitude);var y=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;a=Math.min(a,y),c=Math.max(c,y)}return o-i>c-a&&(i=a,o=c,o>u.PI&&(o-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=f,r.east=o,r.north=l,r):new s(i,f,o,l)},s.fromCartesianArray=function(e,i,a){t.defined("cartesians",e),i=r(i,o.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,h=Number.MAX_VALUE,d=-Number.MAX_VALUE,y=0,m=e.length;m>y;y++){var E=i.cartesianToCartographic(e[y]);c=Math.min(c,E.longitude),f=Math.max(f,E.longitude),h=Math.min(h,E.latitude),d=Math.max(d,E.latitude);var _=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;l=Math.min(l,_),p=Math.max(p,_)}return f-c>p-l&&(c=l,f=p,f>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(a)?(a.west=c,a.south=h,a.east=f,a.north=d,a):new s(c,h,f,d)},s.clone=function(e,t){return n(e)?n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north):void 0},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var o=e.east;t.typeOf.number.greaterThanOrEquals("east",o,-Math.PI),t.typeOf.number.lessThanOrEquals("east",o,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var o=e.east,a=e.west,c=r.east,f=r.west;a>o&&c>0?o+=u.TWO_PI:f>c&&o>0&&(c+=u.TWO_PI),a>o&&0>f?f+=u.TWO_PI:f>c&&0>a&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,f)),p=u.negativePiToPi(Math.min(o,c));if(!((e.west<e.east||r.west<r.east)&&l>=p)){var h=Math.max(e.south,r.south),d=Math.min(e.north,r.north);if(!(h>=d))return n(i)?(i.west=l,i.south=h,i.east=p,i.north=d,i):new s(l,h,p,d)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);return a>=c||o>=u?void 0:n(i)?(i.west=o,i.south=a,i.east=u,i.north=c,i):new s(o,a,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var o=e.east,a=e.west,c=r.east,f=r.west;a>o&&c>0?o+=u.TWO_PI:f>c&&o>0&&(c+=u.TWO_PI),a>o&&0>f?f+=u.TWO_PI:f>c&&0>a&&(a+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(a,f)),p=u.convertLongitudeRange(Math.max(o,c));return i.west=l,i.south=Math.min(e.south,r.south),i.east=p,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,o=e.west,a=e.east;return o>a&&(a+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>o||u.equalsEpsilon(n,o,u.EPSILON14))&&(a>n||u.equalsEpsilon(n,a,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,a,f){t.typeOf.object("rectangle",e),i=r(i,o.WGS84),a=r(a,0),n(f)||(f=[]);var l=0,p=e.north,h=e.south,d=e.east,y=e.west,m=c;m.height=a,m.longitude=y,m.latitude=p,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.latitude=h,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.longitude=y,f[l]=i.cartographicToCartesian(m,f[l]),l++,0>p?m.latitude=p:h>0?m.latitude=h:m.latitude=0;for(var E=1;8>E;++E)m.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,m)&&(f[l]=i.cartographicToCartesian(m,f[l]),l++);return 0===m.latitude&&(m.longitude=y,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.longitude=d,f[l]=i.cartographicToCartesian(m,f[l]),l++),f.length=l,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,i,o,a,u,s,c,f,l,p){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var d=new e,y=new e,m=new e,E=new e,_=new e,O=new e,T=new e,w=new e,R=new e,v=new e,A=new e,b=new e,g=4/3*c.PI;h.fromPoints=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,o=e.clone(t[0],T),a=e.clone(o,d),u=e.clone(o,y),s=e.clone(o,m),c=e.clone(o,E),f=e.clone(o,_),l=e.clone(o,O),p=t.length;for(n=1;p>n;n++){e.clone(t[n],o);var g=o.x,S=o.y,I=o.z;g<a.x&&e.clone(o,a),g>c.x&&e.clone(o,c),S<u.y&&e.clone(o,u),S>f.y&&e.clone(o,f),I<s.z&&e.clone(o,s),I>l.z&&e.clone(o,l)}var N=e.magnitudeSquared(e.subtract(c,a,w)),M=e.magnitudeSquared(e.subtract(f,u,w)),C=e.magnitudeSquared(e.subtract(l,s,w)),x=a,P=c,U=N;M>U&&(U=M,x=u,P=f),C>U&&(U=C,x=s,P=l);var D=R;D.x=.5*(x.x+P.x),D.y=.5*(x.y+P.y),D.z=.5*(x.z+P.z);var q=e.magnitudeSquared(e.subtract(P,D,w)),F=Math.sqrt(q),L=v;L.x=a.x,L.y=u.y,L.z=s.z;var j=A;j.x=c.x,j.y=f.y,j.z=l.z;var B=e.midpoint(L,j,b),z=0;for(n=0;p>n;n++){e.clone(t[n],o);var G=e.magnitude(e.subtract(o,B,w));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(o,D,w));if(V>q){var k=Math.sqrt(V);F=.5*(F+k),q=F*F;var X=k-F;D.x=(F*D.x+X*o.x)/k,D.y=(F*D.y+X*o.y)/k,D.z=(F*D.z+X*o.z)/k}}return z>F?(e.clone(D,r.center),r.radius=F):(e.clone(B,r.center),r.radius=z),r};var S=new a,I=new e,N=new e,M=new t,C=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,o,a,u){if(i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,S),p.southwest(t,M),M.height=o,p.northeast(t,C),C.height=a;var s=r.project(M,I),c=r.project(C,N),f=c.x-s.x,l=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+d*d);var y=u.center;return y.x=s.x+.5*f,y.y=s.y+.5*l,y.z=s.z+.5*d,u};var x=[];h.fromRectangle3D=function(t,r,a,u){if(r=n(r,o.WGS84),a=n(a,0),i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=p.subsample(t,r,a,x);return h.fromPoints(s,u)},h.fromVertices=function(t,o,a,u){if(i(u)||(u=new h),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;o=n(o,e.ZERO),a=n(a,3),r.typeOf.number.greaterThanOrEquals("stride",a,3);var s=T;s.x=t[0]+o.x,s.y=t[1]+o.y,s.z=t[2]+o.z;var c,f=e.clone(s,d),l=e.clone(s,y),p=e.clone(s,m),g=e.clone(s,E),S=e.clone(s,_),I=e.clone(s,O),N=t.length;for(c=0;N>c;c+=a){var M=t[c]+o.x,C=t[c+1]+o.y,x=t[c+2]+o.z;s.x=M,s.y=C,s.z=x,M<f.x&&e.clone(s,f),M>g.x&&e.clone(s,g),C<l.y&&e.clone(s,l),C>S.y&&e.clone(s,S),x<p.z&&e.clone(s,p),x>I.z&&e.clone(s,I)}var P=e.magnitudeSquared(e.subtract(g,f,w)),U=e.magnitudeSquared(e.subtract(S,l,w)),D=e.magnitudeSquared(e.subtract(I,p,w)),q=f,F=g,L=P;U>L&&(L=U,q=l,F=S),D>L&&(L=D,q=p,F=I);var j=R;j.x=.5*(q.x+F.x),j.y=.5*(q.y+F.y),j.z=.5*(q.z+F.z);var B=e.magnitudeSquared(e.subtract(F,j,w)),z=Math.sqrt(B),G=v;G.x=f.x,G.y=l.y,G.z=p.z;var V=A;V.x=g.x,V.y=S.y,V.z=I.z;var k=e.midpoint(G,V,b),X=0;for(c=0;N>c;c+=a){s.x=t[c]+o.x,s.y=t[c+1]+o.y,s.z=t[c+2]+o.z;var W=e.magnitude(e.subtract(s,k,w));W>X&&(X=W);var H=e.magnitudeSquared(e.subtract(s,j,w));if(H>B){var Y=Math.sqrt(H);z=.5*(z+Y),B=z*z;var K=Y-z;j.x=(z*j.x+K*s.x)/Y,j.y=(z*j.y+K*s.y)/Y,j.z=(z*j.z+K*s.z)/Y}}return X>z?(e.clone(j,u.center),u.radius=z):(e.clone(k,u.center),u.radius=X),u},h.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new h),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var o=T;o.x=t[0]+r[0],o.y=t[1]+r[1],o.z=t[2]+r[2];var a,u=e.clone(o,d),s=e.clone(o,y),c=e.clone(o,m),f=e.clone(o,E),l=e.clone(o,_),p=e.clone(o,O),g=t.length;for(a=0;g>a;a+=3){var S=t[a]+r[a],I=t[a+1]+r[a+1],N=t[a+2]+r[a+2];o.x=S,o.y=I,o.z=N,S<u.x&&e.clone(o,u),S>f.x&&e.clone(o,f),I<s.y&&e.clone(o,s),I>l.y&&e.clone(o,l),N<c.z&&e.clone(o,c),N>p.z&&e.clone(o,p)}var M=e.magnitudeSquared(e.subtract(f,u,w)),C=e.magnitudeSquared(e.subtract(l,s,w)),x=e.magnitudeSquared(e.subtract(p,c,w)),P=u,U=f,D=M;C>D&&(D=C,P=s,U=l),x>D&&(D=x,P=c,U=p);var q=R;q.x=.5*(P.x+U.x),q.y=.5*(P.y+U.y),q.z=.5*(P.z+U.z);var F=e.magnitudeSquared(e.subtract(U,q,w)),L=Math.sqrt(F),j=v;j.x=u.x,j.y=s.y,j.z=c.z;var B=A;B.x=f.x,B.y=l.y,B.z=p.z;var z=e.midpoint(j,B,b),G=0;for(a=0;g>a;a+=3){o.x=t[a]+r[a],o.y=t[a+1]+r[a+1],o.z=t[a+2]+r[a+2];var V=e.magnitude(e.subtract(o,z,w));V>G&&(G=V);var k=e.magnitudeSquared(e.subtract(o,q,w));if(k>F){var X=Math.sqrt(k);L=.5*(L+X),F=L*L;var W=X-L;q.x=(L*q.x+W*o.x)/X,q.y=(L*q.y+W*o.y)/X,q.z=(L*q.z+W*o.z)/X}}return G>L?(e.clone(q,n.center),n.radius=L):(e.clone(z,n.center),n.radius=G),n},h.fromCornerPoints=function(t,n,o){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(o)||(o=new h);var a=e.midpoint(t,n,o.center);return o.radius=e.distance(a,n),o},h.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;h.fromBoundingSpheres=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var o,a=[];for(o=0;n>o;o++)a.push(t[o].center);r=h.fromPoints(a,r);var u=r.center,s=r.radius;for(o=0;n>o;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var U=new e,D=new e,q=new e;h.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new h);var o=t.halfAxes,a=f.getColumn(o,0,U),u=f.getColumn(o,1,D),s=f.getColumn(o,2,q);return e.add(a,u,a),e.add(a,s,a),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(a),n},h.clone=function(t,r){return i(t)?i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius):void 0},h.packedLength=4,h.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var o=e.center;return t[i++]=o.x,t[i++]=o.y,t[i++]=o.z,t[i]=e.radius,t},h.unpack=function(e,t,o){r.defined("array",e),t=n(t,0),i(o)||(o=new h);var a=o.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],o.radius=e[t],o};var F=new e,L=new e;h.union=function(t,n,o){r.typeOf.object("left",t),r.typeOf.object("right",n),i(o)||(o=new h);var a=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,a,F),l=e.magnitude(f);if(u>=l+c)return t.clone(o),o;if(c>=l+u)return n.clone(o),o;var p=.5*(u+l+c),d=e.multiplyByScalar(f,(-u+p)/l,L);return e.add(d,a,d),e.clone(d,o.center),o.radius=p,o};var j=new e;h.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=h.clone(t,i);var o=e.magnitude(e.subtract(n,i.center,j));return o>i.radius&&(i.radius=o),i},h.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,o=t.radius,a=n.normal,s=e.dot(a,i)+n.distance;return-o>s?u.OUTSIDE:o>s?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var B=new e;h.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,B);return e.magnitudeSquared(i)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;h.computePlaneDistances=function(t,n,o,a){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",o),i(a)||(a=new s);var u=e.subtract(t.center,n,z),c=e.dot(o,u);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var G=new e,V=new e,k=new e,X=new e,W=new e,H=new t,Y=new Array(8),K=0;8>K;++K)Y[K]=new e;var Z=new a;return h.projectTo2D=function(t,i,o){r.typeOf.object("sphere",t),i=n(i,Z);var a=i.ellipsoid,u=t.center,s=t.radius,c=a.geodeticSurfaceNormal(u,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,k);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var p=e.negate(l,W),d=e.negate(f,X),y=Y,m=y[0];e.add(c,l,m),e.add(m,f,m),m=y[1],e.add(c,l,m),e.add(m,d,m),m=y[2],e.add(c,p,m),e.add(m,d,m),m=y[3],e.add(c,p,m),e.add(m,f,m),e.negate(c,c),m=y[4],e.add(c,l,m),e.add(m,f,m),m=y[5],e.add(c,l,m),e.add(m,d,m),m=y[6],e.add(c,p,m),e.add(m,d,m),m=y[7],e.add(c,p,m),e.add(m,f,m);for(var E=y.length,_=0;E>_;++_){var O=y[_];e.add(u,O,O);var T=a.cartesianToCartographic(O,H);i.project(T,O)}o=h.fromPoints(y,o),u=o.center;var w=u.x,R=u.y,v=u.z;return u.x=v,u.y=w,u.z=R,o},h.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return g*e*e*e},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,i){return t(e).then(r,n,i)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=i(e),t}function r(t){return e(t,o)}function n(e){this.then=e}function i(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(n){return o(n)}});return r}function o(e){var r=new n(function(r,n){try{return n?t(n(e)):o(e)}catch(i){return o(i)}});return r}function a(){function e(e,t,r){return p(e,t,r)}function r(e){return d(e)}function i(e){return d(o(e))}function u(e){return h(e)}var s,c,f,l,p,h,d;return c=new n(e),s={then:e,resolve:r,reject:i,progress:u,promise:c,resolver:{resolve:r,reject:i,progress:u}},f=[],l=[],p=function(e,t,r){var n,i;return n=a(),i="function"==typeof r?function(e){try{n.progress(r(e))}catch(t){n.progress(t)}}:function(e){n.progress(e)},f.push(function(r){r.then(e,t).then(n.resolve,n.reject,i)}),l.push(i),n.promise},h=function(e){return y(l,e),e},d=function(e){return e=t(e),p=e.then,d=t,h=E,y(f,e),l=f=w,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,i,o){return m(2,arguments),e(t,function(t){function u(e){y(e)}function s(e){d(e)}var c,f,l,p,h,d,y,m,_,O;if(_=t.length>>>0,c=Math.max(0,Math.min(r,_)),l=[],f=_-c+1,p=[],h=a(),c)for(m=h.progress,y=function(e){p.push(e),--f||(d=y=E,h.reject(p))},d=function(e){l.push(e),--c||(d=y=E,h.resolve(l))},O=0;_>O;++O)O in t&&e(t[O],s,u,m);else h.resolve(l);return h.then(n,i,o)})}function c(e,t,r,n){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,r,n)}function f(e,t,r,n){return m(1,arguments),p(e,_).then(t,r,n)}function l(){return p(arguments,_)}function p(t,r){return e(t,function(t){var n,i,o,u,s,c;if(o=i=t.length>>>0,n=[],c=a(),o)for(u=function(t,i){e(t,r).then(function(e){n[i]=e,--o||c.resolve(n)},c.reject)},s=0;i>s;s++)s in t?u(t[s],s):--o;else c.resolve(n);return c.promise})}function h(t,r){var n=T.call(arguments,1);return e(t,function(t){var i;return i=t.length,n[0]=function(t,n,o){return e(t,function(t){return e(n,function(e){return r(t,e,o,i)})})},O.apply(t,n)})}function d(t,r,n){var i=arguments.length>2;return e(t,function(e){return e=i?n:e,r.resolve(e),e},function(e){return r.reject(e),o(e)},r.progress)}function y(e,t){for(var r,n=0;r=e[n++];)r(t)}function m(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function E(){}function _(e){return e}var O,T,w;return e.defer=a,e.resolve=t,e.reject=r,e.join=l,e.all=f,e.map=p,e.reduce=h,e.any=c,e.some=s,e.chain=d,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(w,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return f(t,function(t){return e.apply(w,t)})})}},T=[].slice,O=[].reduce||function(e){var t,r,n,i,o;if(o=0,t=Object(this),i=t.length>>>0,r=arguments,r.length<=1)for(;;){if(o in t){n=t[o++];break}if(++o>=i)throw new TypeError}else n=r[1];for(;i>o;++o)o in t&&(n=e(n,t[o],o,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen","./RuntimeError","../ThirdParty/when"],function(e,t,r,n,i){"use strict";function o(e){for(var t=e.split("."),r=0,n=t.length;n>r;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(S)&&(S=!1,!d())){var e=/ Chrome\/([\.0-9]+)/.exec(g.userAgent);null!==e&&(S=!0,I=o(e[1]))}return S}function u(){return a()&&I}function s(){if(!t(N)&&(N=!1,!a()&&!d()&&/ Safari\/[\.0-9]+/.test(g.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(g.userAgent);null!==e&&(N=!0,M=o(e[1]))}return N}function c(){return s()&&M}function f(){if(!t(C)){C=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(g.userAgent);null!==e&&(C=!0,x=o(e[1]),x.isNightly=!!e[2])}return C}function l(){return f()&&x}function p(){if(!t(P)){P=!1;var e;"Microsoft Internet Explorer"===g.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(g.userAgent),null!==e&&(P=!0,U=o(e[1]))):"Netscape"===g.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(g.userAgent),null!==e&&(P=!0,U=o(e[1])))}return P}function h(){return p()&&U}function d(){if(!t(D)){D=!1;var e=/ Edge\/([\.0-9]+)/.exec(g.userAgent);null!==e&&(D=!0,q=o(e[1]))}return D}function y(){return d()&&q}function m(){if(!t(F)){F=!1;var e=/Firefox\/([\.0-9]+)/.exec(g.userAgent);null!==e&&(F=!0,L=o(e[1]))}return F}function E(){return t(j)||(j=/Windows/i.test(g.appVersion)),j}function _(){return m()&&L}function O(){return t(B)||(B="object"==typeof process&&"[object process]"===Object.prototype.toString.call(process)),B}function T(){return t(z)||(z=!m()&&"undefined"!=typeof PointerEvent&&(!t(g.pointerEnabled)||g.pointerEnabled)),z}function w(){if(!t(V)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;V=t(r)&&""!==r,V&&(G=r)}return V}function R(){return w()?G:void 0}function v(){if(t(X))return X.promise;X=i.defer(),d()&&(k=!1,X.resolve(k));var e=new Image;return e.onload=function(){k=e.width>0&&e.height>0,X.resolve(k)},e.onerror=function(){k=!1,X.resolve(k)},e.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",X.promise}function A(){return t(X)||v(),k}function b(){var e=window.navigator.userAgent.toLowerCase(),t="ipad"==e.match(/ipad/i),r="iphone os"==e.match(/iphone os/i),n="midp"==e.match(/midp/i),i="rv:1.2.3.4"==e.match(/rv:1.2.3.4/i),o="ucweb"==e.match(/ucweb/i),a="android"==e.match(/android/i),u="windows ce"==e.match(/windows ce/i),s="windows mobile"==e.match(/windows mobile/i);return t||r||n||i||o||a||u||s?!1:!0}var g;g="undefined"!=typeof navigator?navigator:{};var S,I,N,M,C,x,P,U,D,q,F,L,j,B,z,G,V,k,X,W=[];"undefined"!=typeof ArrayBuffer&&(W.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&W.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&W.push(CanvasPixelArray));var H={isChrome:a,chromeVersion:u,isSafari:s,safariVersion:c,isWebkit:f,webkitVersion:l,isInternetExplorer:p,internetExplorerVersion:h,isEdge:d,edgeVersion:y,isFirefox:m,firefoxVersion:_,isWindows:E,isNodeJs:O,hardwareConcurrency:e(g.hardwareConcurrency,3),supportsPointerEvents:T,supportsImageRenderingPixelated:w,supportsWebP:v,supportsWebPSync:A,imageRenderingValue:R,typedArrayTypes:W,isPCBroswer:b};return H.supportsFullscreen=function(){return r.supportsFullscreen()},H.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},H.supportsWebWorkers=function(){return"undefined"!=typeof Worker},H.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!H.isEdge()},H}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,
DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,i,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:o.BYTE,UNSIGNED_BYTE:o.UNSIGNED_BYTE,SHORT:o.SHORT,UNSIGNED_SHORT:o.UNSIGNED_SHORT,INT:o.INT,UNSIGNED_INT:o.UNSIGNED_INT,FLOAT:o.FLOAT,DOUBLE:o.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.INT:return Int32Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Int32Array?a.INT:e instanceof Uint32Array?a.UNSIGNED_INT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.INT||e===a.UNSIGNED_INT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(n);case a.UNSIGNED_BYTE:return new Uint8Array(n);case a.SHORT:return new Int16Array(n);case a.UNSIGNED_SHORT:return new Uint16Array(n);case a.INT:return new Int32Array(n);case a.UNSIGNED_INT:return new Uint32Array(n);case a.FLOAT:return new Float32Array(n);case a.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(n,i,o,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(o=e(o,0),u=e(u,(i.byteLength-o)/a.getSizeInBytes(n)),n){case a.BYTE:return new Int8Array(i,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,u);case a.SHORT:return new Int16Array(i,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,u);case a.INT:return new Int32Array(i,o,u);case a.UNSIGNED_INT:return new Uint32Array(i,o,u);case a.FLOAT:return new Float32Array(i,o,u);case a.DOUBLE:return new Float64Array(i,o,u);default:throw new r("componentDatatype is not a valid value.")}},a.fromName=function(e){switch(e){case"BYTE":return a.BYTE;case"UNSIGNED_BYTE":return a.UNSIGNED_BYTE;case"SHORT":return a.SHORT;case"UNSIGNED_SHORT":return a.UNSIGNED_SHORT;case"INT":return a.INT;case"UNSIGNED_INT":return a.UNSIGNED_INT;case"FLOAT":return a.FLOAT;case"DOUBLE":return a.DOUBLE;default:throw new r("name is not a valid value.")}},i(a)}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,o){"use strict";function a(e,r){this.x=t(e,0),this.y=t(r,0)}a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var o=0;i>o;++o)a.pack(t[o],n,2*o);return n},a.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var o=0;i>o;o+=2){var u=o/2;n[u]=a.unpack(t,o,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a,f=new a;a.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f),o.acosClamped(a.dot(c,f))};var l=new a;return a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Y,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)},a.ZERO=i(new a(0,0)),a.UNIT_X=i(new a(1,0)),a.UNIT_Y=i(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,TOP:1,ALL:2};return e(t)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],function(e,t,r,n,i,o){"use strict";function a(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}a.packedLength=4,a.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},a.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new a),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o},a.clone=function(e,t){return n(e)?n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new a(e[0],e[2],e[1],e[3]):void 0},a.fromArray=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new a),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o},a.fromColumnMajorArray=function(e,r){return t.defined("values",e),a.clone(e,r)},a.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new a(e[0],e[1],e[2],e[3])},a.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new a(e.x,0,0,e.y)},a.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new a(e,0,0,e)},a.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=o,r[2]=-o,r[3]=i,r):new a(i,-o,o,i)},a.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},a.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},a.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,o=e[i],a=e[i+1];return n.x=o,n.y=a,n},a.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=a.clone(e,i);var o=2*r;return i[o]=n.x,i[o+1]=n.y,i},a.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],o=e[r+2];return n.x=i,n.y=o,n},a.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=a.clone(e,i),i[r]=n.x,i[r+2]=n.y,i};var u=new e;a.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return a.getMaximumScale=function(t){return a.getScale(t,s),e.maximumComponent(s)},a.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],o=e[0]*r[2]+e[2]*r[3],a=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n},a.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},a.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},a.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,o=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=o,n},a.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},a.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},a.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},a.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],o=e[1],a=e[3];return r[0]=n,r[1]=i,r[2]=o,r[3]=a,r},a.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},a.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},a.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},a.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},a.IDENTITY=o(new a(1,0,0,1)),a.ZERO=o(new a(0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,i(a.prototype,{length:{get:function(){return a.packedLength}}}),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},a}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,o){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var a=i/2,u=Math.sin(a);c=e.normalize(r,c);var f=c.x*u,l=c.y*u,p=c.z*u,h=Math.cos(a);return n(o)?(o.x=f,o.y=l,o.z=p,o.w=h,o):new s(f,l,p,h)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var i,o,a,c,p,h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],y=e[u.COLUMN2ROW2],m=h+d+y;if(m>0)i=Math.sqrt(m+1),p=.5*i,i=.5/i,o=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var E=f,_=0;d>h&&(_=1),y>h&&y>d&&(_=2);var O=E[_],T=E[O];i=Math.sqrt(e[u.getElementIndex(_,_)]-e[u.getElementIndex(O,O)]-e[u.getElementIndex(T,T)]+1);var w=l;w[_]=.5*i,i=.5/i,p=(e[u.getElementIndex(T,O)]-e[u.getElementIndex(O,T)])*i,w[O]=(e[u.getElementIndex(O,_)]+e[u.getElementIndex(_,O)])*i,w[T]=(e[u.getElementIndex(T,_)]+e[u.getElementIndex(_,T)])*i,o=-w[0],a=-w[1],c=-w[2]}return n(r)?(r.x=o,r.y=a,r.z=c,r.w=p,r):new s(o,a,c,p)};var p=new s,h=new s,d=new s,y=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=s.fromAxisAngle(e.UNIT_X,r.roll,p),d=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(d,y,d),h=s.fromAxisAngle(e.UNIT_Z,-r.heading,p),s.multiply(h,n,n)};var m=new e,E=new e,_=new s,O=new s,T=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o.x=e[i],o.y=e[i+1],o.z=e[i+2],o.w=e[i+3],o},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,T),s.conjugate(T,T);for(var i=0,o=r-t+1;o>i;i++){var a=3*i;s.unpack(e,4*(t+i),_),s.multiply(_,T,_),_.w<0&&s.negate(_,_),s.computeAxis(_,m);var u=s.computeAngle(_);n[a]=m.x*u,n[a+1]=m.y*u,n[a+2]=m.z*u}},s.unpackInterpolationResult=function(t,r,i,o,a){n(a)||(a=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*o,O),0===u?s.clone(s.IDENTITY,_):s.fromAxisAngle(E,u,_),s.multiply(_,O,a)},s.clone=function(e,t){return n(e)?n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,o=e.y*n,a=e.z*n,u=e.w*n;return r.x=i,r.y=o,r.z=a,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,o=e.y,a=e.z,u=e.w,s=r.x,c=r.y,f=r.z,l=r.w,p=u*s+i*l+o*f-a*c,h=u*c-i*f+o*l+a*s,d=u*f+i*c-o*s+a*l,y=u*l-i*s-o*c-a*f;return n.x=p,n.y=h,n.z=d,n.w=y,n},s.multiplyByVec=function(t,r,n){var i=new e,o=new e,a=new e(t.x,t.y,t.z);i=e.cross(a,r,i),o=e.cross(a,i,o);var u=new e;u=e.multiplyByScalar(i,2*t.w,u);var s=new e;return s=e.multiplyByScalar(i,2,s),n=e.add(r,u,n),n=e.add(n,s,n)},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var w=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),w=s.multiplyByScalar(r,n,w),i=s.multiplyByScalar(e,1-n,i),s.add(w,i,i)};var R=new s,v=new s,A=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var o=s.dot(e,r),u=r;if(0>o&&(o=-o,u=R=s.negate(r,R)),1-o<a.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(o);return v=s.multiplyByScalar(e,Math.sin((1-n)*c),v),A=s.multiplyByScalar(u,Math.sin(n*c),A),i=s.add(v,A,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=a.acosClamped(r.w),o=0;return 0!==i&&(o=i/Math.sin(i)),e.multiplyByScalar(r,o,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),o=0;return 0!==i&&(o=Math.sin(i)/i),n.x=r.x*o,n.y=r.y*o,n.z=r.z*o,n.w=Math.cos(i),n};var b=new e,g=new e,S=new s,I=new s;s.computeInnerQuadrangle=function(r,n,i,o){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",o);var a=s.conjugate(n,S);s.multiply(a,i,I);var u=s.log(I,b);s.multiply(a,r,I);var c=s.log(I,g);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,S),s.multiply(n,S,o)},s.squad=function(e,r,n,i,o,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",o),t.typeOf.object("result",a);var u=s.slerp(e,r,o,S),c=s.slerp(n,i,o,I);return s.slerp(u,c,2*o*(1-o),a)};for(var N=new s,M=1.9011074535173003,C=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],U=i.supportsTypedArrays()?new Float32Array(8):[],D=0;7>D;++D){var q=D+1,F=2*q+1;C[D]=1/(q*F),x[D]=q/F}return C[7]=M/136,x[7]=8*M/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var o,a=s.dot(e,r);a>=0?o=1:(o=-1,a=-a);for(var u=a-1,c=1-n,f=n*n,l=c*c,p=7;p>=0;--p)P[p]=(C[p]*f-x[p])*u,U[p]=(C[p]*l-x[p])*u;var h=o*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),d=c*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),y=s.multiplyByScalar(e,d,N);return s.multiplyByScalar(r,h,i),s.add(y,i,i)},s.fastSquad=function(e,r,n,i,o,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",o),t.typeOf.object("result",a);var u=s.fastSlerp(e,r,o,S),c=s.fastSlerp(n,i,o,I);return s.fastSlerp(u,c,2*o*(1-o),a)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=o(new s(0,0,0,0)),s.IDENTITY=o(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/binarySearch",["./Check"],function(e){"use strict";function t(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,o,a=0,u=t.length-1;u>=a;)if(i=~~((a+u)/2),o=n(t[i],r),0>o)a=i+1;else{if(!(o>0))return i;u=i-1}return~(u+1)}return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},o=function(e,t,r,n,o,a){var u=n-e.length;return u>0&&(e=r||!o?i(e,n,a,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,n,a,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+i(c.toString(t),u||0,"0",!1),o(e,r,n,a,s)},u=function(e,t,r,n,i,a){return null!=n&&(e=e.slice(0,n)),o(e,"",t,r,i,a)},s=function(e,n,s,c,f,l,p){var h,d,y,m,E;if("%%"==e)return"%";for(var _=!1,O="",T=!1,w=!1,R=" ",v=s.length,A=0;s&&v>A;A++)switch(s.charAt(A)){case" ":O=" ";break;case"+":O="+";break;case"-":_=!0;break;case"'":R=s.charAt(A+1);break;case"0":T=!0;break;case"#":w=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,0>c&&(c=-c,_=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(p)>-1?6:"d"==p?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],p){case"s":return u(String(E),_,c,l,T,R);case"c":return u(String.fromCharCode(+E),_,c,l,T);case"b":return a(E,2,w,_,c,l,T);case"o":return a(E,8,w,_,c,l,T);case"x":return a(E,16,w,_,c,l,T);case"X":return a(E,16,w,_,c,l,T).toUpperCase();case"u":return a(E,10,w,_,c,l,T);case"i":case"d":return h=+E||0,h=Math.round(h-h%1),d=0>h?"-":O,E=d+i(String(Math.abs(h)),l,"0",!1),o(E,d,_,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return h=+E,d=0>h?"-":O,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(p.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(p)%2],E=d+Math.abs(h)[y](l),o(E,d,_,c,T)[m]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,i,o,a,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=o,this.millisecond=a,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,o,a,u,s,c){"use strict";function f(e,t){return y.compare(e.julianDate,t.julianDate)}function l(e){O.julianDate=e;var r=y.leapSeconds,n=t(r,O,f);0>n&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;if(n>0){var o=y.secondsDifference(r[n].julianDate,e);o>i&&(n--,i=r[n].offset)}y.addSeconds(e,i,e)}function p(e,r){O.julianDate=e;var n=y.leapSeconds,i=t(n,O,f);if(0>i&&(i=~i),0===i)return y.addSeconds(e,-n[0].offset,r);if(i>=n.length)return y.addSeconds(e,-n[i-1].offset,r);var o=y.secondsDifference(n[i].julianDate,e);return 0===o?y.addSeconds(e,-n[i].offset,r):1>=o?void 0:y.addSeconds(e,-n[--i].offset,r)}function h(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,0>t&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function d(e,t,r,n,i,o,a){var u=(t-14)/12|0,c=e+4800+u,f=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;n-=12,0>n&&(n+=24);var l=o+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+a*s.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}function y(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;t+=(e-i)*s.SECONDS_PER_DAY,h(i,t,this),n===c.UTC&&l(this)}var m=new o,E=[31,28,31,30,31,30,31,31,30,31,30,31],_=29,O=new u,T=/^(\d{4})$/,w=/^(\d{4})-(\d{2})$/,R=/^(\d{4})-?(\d{3})$/,v=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,A=/^(\d{4})-?(\d{2})-?(\d{2})$/,b=/([Z+\-])?(\d{2})?:?(\d{2})?$/,g=/^(\d{2})(\.\d+)?/.source+b.source,S=/^(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,I=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,N="Invalid ISO 8601 date.";
y.fromGregorianDate=function(e,t){if(!(e instanceof o))throw new i("date must be a valid GregorianDate.");var r=d(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(h(r[0],r[1],t),l(t),t):new y(r[0],r[1],c.UTC)},y.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=d(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(h(r[0],r[1],t),l(t),t):new y(r[0],r[1],c.UTC)},y.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(N);e=e.replace(",",".");var r,o,u,s=e.split("T"),f=1,p=1,m=0,O=0,b=0,M=0,C=s[0],x=s[1];if(!n(C))throw new i(N);var P;if(s=C.match(A),null!==s){if(P=C.split("-").length-1,P>0&&2!==P)throw new i(N);r=+s[1],f=+s[2],p=+s[3]}else if(s=C.match(w),null!==s)r=+s[1],f=+s[2];else if(s=C.match(T),null!==s)r=+s[1];else{var U;if(s=C.match(R),null!==s){if(r=+s[1],U=+s[2],u=a(r),1>U||u&&U>366||!u&&U>365)throw new i(N)}else{if(s=C.match(v),null===s)throw new i(N);r=+s[1];var D=+s[2],q=+s[3]||0;if(P=C.split("-").length-1,P>0&&(!n(s[3])&&1!==P||n(s[3])&&2!==P))throw new i(N);var F=new Date(Date.UTC(r,0,4));U=7*D+q-F.getUTCDay()-3}o=new Date(Date.UTC(r,0,1)),o.setUTCDate(U),f=o.getUTCMonth()+1,p=o.getUTCDate()}if(u=a(r),1>f||f>12||1>p||(2!==f||!u)&&p>E[f-1]||u&&2===f&&p>_)throw new i(N);var L;if(n(x)){if(s=x.match(I),null!==s){if(P=x.split(":").length-1,P>0&&2!==P&&3!==P)throw new i(N);m=+s[1],O=+s[2],b=+s[3],M=1e3*+(s[4]||0),L=5}else if(s=x.match(S),null!==s){if(P=x.split(":").length-1,P>2)throw new i(N);m=+s[1],O=+s[2],b=60*+(s[3]||0),L=4}else{if(s=x.match(g),null===s)throw new i(N);m=+s[1],O=60*+(s[2]||0),L=3}if(O>=60||b>=61||m>24||24===m&&(O>0||b>0||M>0))throw new i(N);var j=s[L],B=+s[L+1],z=+(s[L+2]||0);switch(j){case"+":m-=B,O-=z;break;case"-":m+=B,O+=z;break;case"Z":break;default:O+=new Date(Date.UTC(r,f-1,p,m,O)).getTimezoneOffset()}}var G=60===b;for(G&&b--;O>=60;)O-=60,m++;for(;m>=24;)m-=24,p++;for(o=u&&2===f?_:E[f-1];p>o;)p-=o,f++,f>12&&(f-=12,r++),o=u&&2===f?_:E[f-1];for(;0>O;)O+=60,m--;for(;0>m;)m+=24,p--;for(;1>p;)f--,1>f&&(f+=12,r--),o=u&&2===f?_:E[f-1],p+=o;var V=d(r,f,p,m,O,b,M);return n(t)?(h(V[0],V[1],t),l(t)):t=new y(V[0],V[1],c.UTC),G&&y.addSeconds(t,1,t),t},y.now=function(e){return y.fromDate(new Date,e)};var M=new y(0,0,c.TAI);return y.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,a=p(e,M);n(a)||(y.addSeconds(e,-1,M),a=p(M,M),r=!0);var u=a.dayNumber,c=a.secondsOfDay;c>=43200&&(u+=1);var f=u+68569|0,l=4*f/146097|0;f=f-((146097*l+3)/4|0)|0;var h=4e3*(f+1)/1461001|0;f=f-(1461*h/4|0)+31|0;var d=80*f/2447|0,m=f-(2447*d/80|0)|0;f=d/11|0;var E=d+2-12*f|0,_=100*(l-49)+h+f|0,O=c/s.SECONDS_PER_HOUR|0,T=c-O*s.SECONDS_PER_HOUR,w=T/s.SECONDS_PER_MINUTE|0;T-=w*s.SECONDS_PER_MINUTE;var R=0|T,v=(T-R)/s.SECONDS_PER_MILLISECOND;return O+=12,O>23&&(O-=24),r&&(R+=1),n(t)?(t.year=_,t.month=E,t.day=m,t.hour=O,t.minute=w,t.second=R,t.millisecond=v,t.isLeapSecond=r,t):new o(_,E,m,O,w,R,v,r)},y.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=y.toGregorianDate(e,m),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},y.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var o=y.toGregorianDate(t,m),a=o.year,u=o.month,s=o.day,c=o.hour,f=o.minute,l=o.second,p=o.millisecond;1e4===a&&1===u&&1===s&&0===c&&0===f&&0===l&&0===p&&(a=9999,u=12,s=31,c=24);var h;return n(r)||0===p?n(r)&&0!==r?(h=(.01*p).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a,u,s,c,f,l,h)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a,u,s,c,f,l):(h=(.01*p).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a,u,s,c,f,l,h))},y.clone=function(e,t){return n(e)?n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new y(e.dayNumber,e.secondsOfDay,c.TAI):void 0},y.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},y.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},y.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(y.secondsDifference(e,t))<=r},y.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},y.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},y.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber,o=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+o},y.computeTaiMinusUtc=function(e){O.julianDate=e;var r=y.leapSeconds,n=t(r,O,f);return 0>n&&(n=~n,--n,0>n&&(n=0)),r[n].offset},y.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return h(e.dayNumber,e.secondsOfDay+t,r)},y.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var o=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,o,r)},y.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var o=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,o,r)},y.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");var o=e.dayNumber+t;return h(o,e.secondsOfDay,r)},y.lessThan=function(e,t){return y.compare(e,t)<0},y.lessThanOrEquals=function(e,t){return y.compare(e,t)<=0},y.greaterThan=function(e,t){return y.compare(e,t)>0},y.greaterThanOrEquals=function(e,t){return y.compare(e,t)>=0},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y.prototype.equalsEpsilon=function(e,t){return y.equalsEpsilon(this,e,t)},y.prototype.toString=function(){return y.toIso8601(this)},y.leapSeconds=[new u(new y(2441317,43210,c.TAI),10),new u(new y(2441499,43211,c.TAI),11),new u(new y(2441683,43212,c.TAI),12),new u(new y(2442048,43213,c.TAI),13),new u(new y(2442413,43214,c.TAI),14),new u(new y(2442778,43215,c.TAI),15),new u(new y(2443144,43216,c.TAI),16),new u(new y(2443509,43217,c.TAI),17),new u(new y(2443874,43218,c.TAI),18),new u(new y(2444239,43219,c.TAI),19),new u(new y(2444786,43220,c.TAI),20),new u(new y(2445151,43221,c.TAI),21),new u(new y(2445516,43222,c.TAI),22),new u(new y(2446247,43223,c.TAI),23),new u(new y(2447161,43224,c.TAI),24),new u(new y(2447892,43225,c.TAI),25),new u(new y(2448257,43226,c.TAI),26),new u(new y(2448804,43227,c.TAI),27),new u(new y(2449169,43228,c.TAI),28),new u(new y(2449534,43229,c.TAI),29),new u(new y(2450083,43230,c.TAI),30),new u(new y(2450630,43231,c.TAI),31),new u(new y(2451179,43232,c.TAI),32),new u(new y(2453736,43233,c.TAI),33),new u(new y(2454832,43234,c.TAI),34),new u(new y(2456109,43235,c.TAI),35),new u(new y(2457204,43236,c.TAI),36),new u(new y(2457754,43237,c.TAI),37)],y}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return o.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,r).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,o=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/appendForwardSlash",[],function(){"use strict";function e(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e}return e}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var o in r)if(r.hasOwnProperty(o)){var a=r[o];n&&(a=t(a,n)),i[o]=a}return i}return t}),define("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";function r(n,i,o){o=e(o,!1);var a,u,s,c={},f=t(n),l=t(i);if(f)for(a in n)n.hasOwnProperty(a)&&(u=n[a],l&&o&&"object"==typeof u&&i.hasOwnProperty(a)?(s=i[a],"object"==typeof s?c[a]=r(u,s,o):c[a]=u):c[a]=u);if(l)for(a in i)i.hasOwnProperty(a)&&!c.hasOwnProperty(a)&&(s=i[a],c[a]=s);return c}return r}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,o,a){if(!r(i))throw new n("relative uri is required.");if(!r(o)){if("undefined"==typeof a)return i;o=t(a.baseURI,a.location.href)}var u=new e(o),s=new e(i);return s.resolve(u).toString()},i}),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,i){if(!t(n))throw new r("uri is required.");var o="",a=n.lastIndexOf("/");return-1!==a&&(o=n.substring(0,a+1)),i?(n=new e(n),t(n.query)&&(o+="?"+n.query),t(n.fragment)&&(o+="#"+n.fragment),o):o}return n}),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var o=i.path,a=o.lastIndexOf("/");return-1!==a&&(o=o.substr(a+1)),a=o.lastIndexOf("."),o=-1===a?"":o.substr(a+1)}return n}),define("Core/isBlobUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^blob:/i;return t}),define("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";function t(t){e(r)||(r=document.createElement("a")),r.href=window.location.href;var n=r.host,i=r.protocol;return r.href=t,r.href=r.href,i!==r.protocol||n!==r.host}var r;return t}),define("Core/isDataUri",["./Check"],function(e){"use strict";function t(t){return e.typeOf.string("uri",t),r.test(t)}var r=/^data:/i;return t}),define("Core/loadAndExecuteScript",["../ThirdParty/when"],function(e){"use strict";function t(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}return t}),define("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("obj is required.");var i="";for(var o in n)if(n.hasOwnProperty(o)){var a=n[o],u=encodeURIComponent(o)+"=";if(r(a))for(var s=0,c=a.length;c>s;++s)i+=u+encodeURIComponent(a[s])+"&";else i+=u+encodeURIComponent(a)+"&"}return i=i.slice(0,-1)}return n}),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";function n(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var o=n.replace(/\+/g,"%20").split(/[&;]/),a=0,u=o.length;u>a;++a){var s=o[a].split("="),c=decodeURIComponent(s[0]),f=s[1];f=e(f)?decodeURIComponent(f):"";var l=i[c];"string"==typeof l?i[c]=[l,f]:r(l)?l.push(f):i[c]=f}return i}return n}),define("Core/RequestState",["../Core/freezeObject"],function(e){"use strict";var t={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5};return e(t)}),define("Core/RequestType",["../Core/freezeObject"],function(e){"use strict";var t={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3,PACK_TERRAIN:4,PACK_IMAGERY:5};return e(t)}),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),o=e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=o,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],o=i.indexOf(": ");if(o>0){var a=i.substring(0,o),u=i.substring(o+2);t[a]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("Core/Event",["./Check","./defined","./defineProperties"],function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,o=-1,a=0;a<n.length;a++)if(n[a]===t&&i[a]===r){o=a;break}return-1!==o?(this._insideRaiseEvent?(this._toRemove.push(o),n[o]=void 0,i[o]=void 0):(n.splice(o,1),i.splice(o,1)),!0):!1},n.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,o=r.length;for(e=0;o>e;e++){var a=r[e];t(a)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if(o=u.length,o>0){for(u.sort(i),e=0;o>e;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n}),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function o(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,a=-1,u=!0;u;){var s=2*(e+1),c=s-1;a=r>c&&n(i[c],i[e])<0?c:e,r>s&&n(i[s],i[a])<0&&(a=s),a!==e?(o(i,a,e),e=a):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n=this._array,i=this._comparator,a=this._maximumLength,u=this._length++;for(u<n.length?n[u]=t:n.push(t);0!==u;){var s=Math.floor((u-1)/2);if(!(i(n[u],n[s])<0))break;o(n,u,s),u=s}var c;return r(a)&&this._length>a&&(c=n[a],this._length=a),c},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return o(n,r,--this._length),this.heapify(r),i}},i}),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState","./RequestType"],function(e,t,r,n,i,o,a,u,s,c,f,l){"use strict";function p(e,t){return e.priority-t.priority}function h(){}function d(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function y(e){var t=n(h.requestsByServer[e],h.maximumRequestsPerServer);return C[e]<t}function m(e){var r=e.serverKey+"_"+e.providerName;if(i(h.packRequests[r])||(h.packRequests[r]=[]),!(h.packRequests[r].length>=D)){i(h.packRequestQuadKey[r])||(h.packRequestQuadKey[r]=[],h.quadKeyIndex[r]=0,h.totalPacketCount[r]=0,h.currentDeferIndex[r]=0),i(h.currentPacketCount[r])||(h.currentPacketCount[r]=0),i(h.packRequestPromise[r])||(h.packRequestPromise[r]=[t.defer()]),h.totalPacketCount[r]>=U&&(h.totalPacketCount[r]=0,h.currentDeferIndex[r]++,h.packRequestPromise[r].push(t.defer()));var n=h.currentDeferIndex[r];return e.deferred=h.packRequestPromise[r][n],e.state=f.ISSUED,h.packRequests[r].push(e),h.totalPacketCount[r]++,e.deferred.promise}}function E(){h.packRequests={},h.packRequestPromise={},h.packRequestQuadKey={},h.quadKeyIndex={},h.currentPacketCount={},h.totalPacketCount={},h.currentDeferIndex={}}function _(e){var t=e.serverKey+"_"+e.providerName,r=h.packRequestQuadKey[t],n=h.quadKeyIndex[t];i(r[n])?r[n]+=";"+e.quadKey:r[n]=e.quadKey,e.quadKeyIndex=h.currentPacketCount[t],++h.currentPacketCount[t],h.currentPacketCount[t]>=U&&(h.currentPacketCount[t]=0,h.quadKeyIndex[t]++)}function O(e,t){for(var r=U*t,n=0,i=e.length;i>n;n++)if(n>=r){var o=e[n];o.state=f.CANCELLED}}function T(){var t,r=h.packRequests;for(var n in r)if(r.hasOwnProperty(n)){t=void 0;for(var o=r[n],a=0,u=o.length;u>a;a++){var s=o[a];i(t)||(t=s),_(s)}var c;for(i(t)&&(c=t.url),a=0,u=h.packRequestQuadKey[n].length;u>a;a++){var f=h.packRequestQuadKey[n][a];if(-1===f.indexOf(";")&&(f+=";"+f),i(t)){if(t.throttleByServer&&!y(t.serverKey)){O(o,a),h.packRequestPromise[n][a].reject();continue}var l=t.clone();l.state=t.state,l.serverKey=t.serverKey,l.deferred=h.packRequestPromise[n][a],l.deferred.id=a;var p=new e(c);p.query=i(p.query)?p.query+"&extratiles="+f:"extratiles="+f,l.url=p.toString(),A(l,l.url)}}}E()}function w(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function R(e){return function(t){e.state!==f.CANCELLED&&(--S.numberOfActiveRequests,--C[e.serverKey],P.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}function v(e){return function(t){e.state!==f.CANCELLED&&(++S.numberOfFailedRequests,--S.numberOfActiveRequests,--C[e.serverKey],P.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}function A(e,t){var r=w(e);return e.state=f.ACTIVE,M.push(e),++S.numberOfActiveRequests,++S.numberOfActiveRequestsEver,++C[e.serverKey],e.requestFunction(t).then(R(e)).otherwise(v(e)),r}function b(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++S.numberOfCancelledRequests,e.deferred.reject(),t&&(--S.numberOfActiveRequests,--C[e.serverKey],++S.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}function g(){h.debugShowStatistics&&(0===S.numberOfActiveRequests&&S.lastNumberOfActiveRequests>0&&(S.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+S.numberOfAttemptedRequests),S.numberOfAttemptedRequests=0),S.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+S.numberOfCancelledRequests),S.numberOfCancelledRequests=0),S.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+S.numberOfCancelledActiveRequests),S.numberOfCancelledActiveRequests=0),S.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+S.numberOfFailedRequests),S.numberOfFailedRequests=0)),S.lastNumberOfActiveRequests=S.numberOfActiveRequests)}var S={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},I=20,N=new u({comparator:p});N.maximumLength=I,N.reserve(I);var M=[],C={},x="undefined"!=typeof document?new e(document.location.href):new e,P=new a;h.maximumRequests=50,h.maximumRequestsPerServer=6,h.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},h.throttleRequests=!0,h.debugShowStatistics=!1,h.requestCompletedEvent=P,o(h,{statistics:{get:function(){return S}},priorityHeapLength:{get:function(){return I},set:function(e){if(I>e)for(;N.length>e;){var t=N.pop();b(t)}I=e,N.maximumLength=e,N.reserve(e)}}});var U=20,D=120;return h.packRequests={},h.packRequestPromise={},h.packRequestQuadKey={},h.quadKeyIndex={},h.currentPacketCount={},h.totalPacketCount={},h.currentDeferIndex={},h.update=function(){var e,t,r=0,n=M.length;for(e=0;n>e;++e)t=M[e],t.cancelled&&b(t),t.state===f.ACTIVE?r>0&&(M[e-r]=t):++r;M.length-=r,T();var i=N.internalArray,o=N.length;for(e=0;o>e;++e)d(i[e]);N.resort();for(var a=Math.max(h.maximumRequests-M.length,0),u=0;a>u&&N.length>0;)t=N.pop(),t.cancelled?b(t):!t.throttleByServer||y(t.serverKey)?(A(t),++u):b(t);g()},h.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(x);n.normalize();var o=n.authority;/:/.test(o)||(o=o+":"+("https"===n.scheme?"443":"80"));var a=C[o];return i(a)||(C[o]=0),o},h.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return P.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++S.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=h.getServerKey(e.url)),e.type>l.OTHER)return m(e);if(!e.throttleByServer||y(e.serverKey)){if(!h.throttleRequests||!e.throttle)return A(e);if(!(M.length>=h.maximumRequests)){d(e);var t=N.insert(e);if(i(t)){if(t===e)return;b(t)}return w(e)}}},h.clearForSpecs=function(){for(;N.length>0;){var e=N.pop();b(e)}for(var t=M.length,r=0;t>r;++r)b(M[r]);M.length=0,C={},S.numberOfAttemptedRequests=0,S.numberOfActiveRequests=0,S.numberOfCancelledRequests=0,S.numberOfCancelledActiveRequests=0,S.numberOfFailedRequests=0,S.numberOfActiveRequestsEver=0,S.lastNumberOfActiveRequests=0},h.numberOfActiveRequestsByServer=function(e){return C[e]},h.requestHeap=N,h}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var o=i.split("@");i=o[1]}if(-1===i.indexOf(":")){var a=n.getScheme();if(t(a)||(a=window.location.protocol,a=a.substring(0,a.length-1)),"http"===a)i+=":80";else{if("https"!==a)return;i+=":443"}}return i}}var i={},o={};return i.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(o[i])||(o[i]=!0)},i.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||0>=n)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(o[i])&&delete o[i]},i.contains=function(e){if(!t(e))throw new r("url is required.");var i=n(e);return t(i)&&t(o[i])?!0:!1},i.clear=function(){o={}},i}),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],function(e,t,r,n,i,o,a,u,s,c,f,l,p,h,d,y,m,E,_,O,T,w,R,v,A,b){"use strict";function g(e,t,r,n){var i=e.query;if(!u(i)||0===i.length)return{};var o;if(-1===i.indexOf("=")){var a={};a[i]=void 0,o=a}else o=O(i);r?t._queryParameters=M(o,t._queryParameters,n):t._queryParameters=o,e.query=void 0}function S(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=_(r):e.query=n[0]}function I(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function N(e){if(e.state===v.ISSUED||e.state===v.ACTIVE)throw new A("The Resource is already being fetched.");e.state=v.UNISSUED,e.deferred=void 0}function M(e,t,r){if(!r)return o(e,t);var n=i(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var s=n[a],c=t[a];u(s)?(Array.isArray(s)||(s=n[a]=[s]),n[a]=s.concat(c)):n[a]=Array.isArray(c)?c.slice():c}return n}function C(t){t=a(t,a.EMPTY_OBJECT),"string"==typeof t&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=I(t.templateValues,{}),this._queryParameters=I(t.queryParameters,{}),this.headers=I(t.headers,{}),this.request=a(t.request,new T),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=a(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);g(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function x(e){var r=e.resource,n=e.flipY,i=e.preferImageBitmap,o=r.request;o.url=r.url,o.requestFunction=function(){var e=r.url,o=!1;r.isDataUri||r.isBlobUri||(o=r.isCrossOriginUrl);var a=t.defer();return C._Implementations.createImage(e,o,a,n,i),a.promise};var a=R.request(o);return u(a)?a.otherwise(function(e){return o.state!==v.FAILED?t.reject(e):r.retryOnError(e).then(function(a){return a?(o.state=v.UNISSUED,o.deferred=void 0,x({resource:r,flipY:n,preferImageBitmap:i})):t.reject(e)})}):void 0}function P(e,r,n){var i={};i[r]=n,e.setQueryParameters(i);var o=e.request;o.url=e.url,o.requestFunction=function(){var r=t.defer();return window[n]=function(e){r.resolve(e);try{delete window[n]}catch(t){window[n]=void 0}},C._Implementations.loadAndExecuteScript(e.url,n,r),r.promise};var a=R.request(o);return u(a)?a.otherwise(function(i){return o.state!==v.FAILED?t.reject(i):e.retryOnError(i).then(function(a){return a?(o.state=v.UNISSUED,o.deferred=void 0,P(e,r,n)):t.reject(i)})}):void 0}function U(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function D(e,t){for(var r=U(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),o=0;o<r.length;o++)i[o]=r.charCodeAt(o);return n}function q(e,t){t=a(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return U(n,i);case"arraybuffer":return D(n,i);case"blob":var o=D(n,i);return new Blob([o],{type:r});case"document":var u=new DOMParser;return u.parseFromString(U(n,i),r);case"json":return JSON.parse(U(n,i));default:throw new c("Unhandled responseType: "+t)}}function F(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(b.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e}function L(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function j(e,t,r,n,i,o,a){var u=global.require,s=u("url").parse(e),c=u("https:"===s.protocol?"https":"http"),f=u("zlib"),l={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:r,headers:i};c.request(l).on("response",function(e){if(e.statusCode<200||e.statusCode>=300)return void o.reject(new w(e.statusCode,e,e.headers));var r=[];e.on("data",function(e){r.push(e)}),e.on("end",function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?f.gunzip(n,function(e,r){e?o.reject(new A("Error decompressing response.")):o.resolve(L(r,t))}):o.resolve(L(n,t))})}).on("error",function(e){o.reject(new w)}).end()}var B=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();C.createIfNeeded=function(e){return e instanceof C?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new C({url:e})};var z;C.supportsImageBitmapOptions=function(){if(u(z))return z;if("function"!=typeof createImageBitmap)return z=t.resolve(!1);var e="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg==";return z=C.fetchBlob({url:e}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},s(C,{isBlobSupported:{get:function(){return B}}}),s(C.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);g(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return h(this._url)}},isDataUri:{get:function(){return m(this._url)}},isBlobUri:{get:function(){return d(this._url)}},isCrossOriginUrl:{get:function(){return y(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),C.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&S(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),o=this._templateValues;return i=i.replace(/{(.*?)}/g,function(e,t){var r=o[t];return u(r)?encodeURIComponent(r):e}),r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},C.prototype.setQueryParameters=function(e,t){t?this._queryParameters=M(this._queryParameters,e,!1):this._queryParameters=M(e,this._queryParameters,!1)},C.prototype.appendQueryParameters=function(e){this._queryParameters=M(e,this._queryParameters,!0)},C.prototype.setTemplateValues=function(e,t){t?this._templateValues=o(this._templateValues,e):this._templateValues=o(e,this._templateValues);
},C.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url),i=a(t.preserveQueryParameters,!1);g(n,r,!0,i),n.fragment=void 0,r._url=n.resolve(new e(l(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=o(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=o(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=o(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},C.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then(function(e){return++n._retryCount,e})},C.prototype.clone=function(e){return u(e)||(e=new C({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},C.prototype.getBaseUri=function(e){return p(this.getUrlComponent(e),e)},C.prototype.appendForwardSlash=function(){this._url=r(this._url)},C.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},C.fetchArrayBuffer=function(e){var t=new C(e);return t.fetchArrayBuffer()},C.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},C.fetchBlob=function(e){var t=new C(e);return t.fetchBlob()},C.prototype.fetchImage=function(e){e=a(e,a.EMPTY_OBJECT);var r=a(e.preferImageBitmap,!1),n=a(e.preferBlob,!1),i=a(e.flipY,!1);if(N(this.request),!B||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return x({resource:this,flipY:i,preferImageBitmap:r});var o=this.fetchBlob();if(u(o)){var s,c,f,l;return C.supportsImageBitmapOptions().then(function(e){return s=e,c=s&&r,o}).then(function(e){if(u(e)){if(l=e,c)return C.createImageBitmapFromBlob(e,{flipY:i,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return f=new C({url:t}),x({resource:f,flipY:i,preferImageBitmap:!1})}}).then(function(e){return u(e)?(e.blob=l,c?e:(window.URL.revokeObjectURL(f.url),e)):void 0}).otherwise(function(e){return u(f)&&window.URL.revokeObjectURL(f.url),e.blob=l,t.reject(e)})}},C.fetchImage=function(e){var t=new C(e);return t.fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},C.prototype.fetchText=function(){return this.fetch({responseType:"text"})},C.fetchText=function(e){var t=new C(e);return t.fetchText()},C.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then(function(e){return u(e)?JSON.parse(e):void 0})},C.fetchJson=function(e){var t=new C(e);return t.fetchJson()},C.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},C.fetchXML=function(e){var t=new C(e);return t.fetchXML()},C.prototype.fetchJsonp=function(e){e=a(e,"callback"),N(this.request);var t;do t="loadJsonp"+Math.random().toString().substring(2,8);while(u(window[t]));return P(this,e,t)},C.fetchJsonp=function(e){var t=new C(e);return t.fetchJsonp(e.callbackParameterName)},C.prototype._makeRequest=function(e){var r=this;N(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(i){var a=e.responseType,s=o(e.headers,r.headers),c=e.overrideMimeType,f=e.method,l=e.data,p=t.defer(),h=u(i)?i:r.url,d=C._Implementations.loadWithXhr(h,a,f,l,s,p,c);return u(d)&&u(d.abort)&&(n.cancelFunction=function(){d.abort()}),p.promise};var i=R.request(n);return u(i)?i.then(function(e){return e}).otherwise(function(i){return n.state!==v.FAILED?t.reject(i):r.retryOnError(i).then(function(o){return o?(n.state=v.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)})}):void 0};var G=/^data:(.*?)(;base64)?,(.*)$/;C.prototype.fetch=function(e){return e=I(e,{}),e.method="GET",this._makeRequest(e)},C.fetch=function(e){var t=new C(e);return t.fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype["delete"]=function(e){return e=I(e,{}),e.method="DELETE",this._makeRequest(e)},C["delete"]=function(e){var t=new C(e);return t["delete"]({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},C.prototype.head=function(e){return e=I(e,{}),e.method="HEAD",this._makeRequest(e)},C.head=function(e){var t=new C(e);return t.head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.options=function(e){return e=I(e,{}),e.method="OPTIONS",this._makeRequest(e)},C.options=function(e){var t=new C(e);return t.options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.post=function(e,t){return n.defined("data",e),t=I(t,{}),t.method="POST",t.data=e,this._makeRequest(t)},C.post=function(e){var t=new C(e);return t.post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.put=function(e,t){return n.defined("data",e),t=I(t,{}),t.method="PUT",t.data=e,this._makeRequest(t)},C.put=function(e){var t=new C(e);return t.put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.patch=function(e,t){return n.defined("data",e),t=I(t,{}),t.method="PATCH",t.data=e,this._makeRequest(t)},C.patch=function(e){var t=new C(e);return t.patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C._Implementations={},C._Implementations.createImage=function(e,t,r,n,i){C.supportsImageBitmapOptions().then(function(n){return n&&i?C.fetchBlob({url:e}):void F(e,t,r)}).then(function(e){return u(e)?C.createImageBitmapFromBlob(e,{flipY:n,premultiplyAlpha:!1}):void 0}).then(function(e){u(e)&&r.resolve(e)}).otherwise(r.reject)},C.createImageBitmapFromBlob=function(e,t){return n.defined("options",t),n.typeOf.bool("options.flipY",t.flipY),n.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var V="undefined"==typeof XMLHttpRequest;return C._Implementations.loadWithXhr=function(e,t,r,n,i,o,a){var s=G.exec(e);if(null!==s)return void o.resolve(q(s,t));if(V)return void j(e,t,r,n,i,o,a);var c=new XMLHttpRequest;if(b.contains(e)&&(c.withCredentials=!0),e=e.replace(/{/g,"%7B").replace(/}/g,"%7D"),c.open(r,e,!0),u(a)&&u(c.overrideMimeType)&&c.overrideMimeType(a),u(i))for(var f in i)i.hasOwnProperty(f)&&c.setRequestHeader(f,i[f]);u(t)&&(c.responseType=t);var l=!1;return"string"==typeof e&&(l=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),c.onload=function(){if((c.status<200||c.status>=300)&&(!l||0!==c.status))return void o.reject(new w(c.status,c.response,c.getAllResponseHeaders()));var e=c.response,n=c.responseType;if("HEAD"===r||"OPTIONS"===r){var i=c.getAllResponseHeaders(),a=i.trim().split(/[\r\n]+/),s={};return a.forEach(function(e){var t=e.split(": "),r=t.shift();s[r]=t.join(": ")}),void o.resolve(s)}if(204===c.status)o.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{o.resolve(JSON.parse(e))}catch(f){o.reject(f)}else(""===n||"document"===n)&&u(c.responseXML)&&c.responseXML.hasChildNodes()?o.resolve(c.responseXML):""!==n&&"text"!==n||!u(c.responseText)?o.reject(new A("Invalid XMLHttpRequest response type.")):o.resolve(c.responseText);else o.resolve(e)},c.onerror=function(e){o.reject(new w)},c.send(n),c},C._Implementations.loadAndExecuteScript=function(e,t,r){return E(e,t).otherwise(r.reject)},C._DefaultImplementations={},C._DefaultImplementations.createImage=C._Implementations.createImage,C._DefaultImplementations.loadWithXhr=C._Implementations.loadWithXhr,C._DefaultImplementations.loadAndExecuteScript=C._Implementations.loadAndExecuteScript,C.DEFAULT=f(new C({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),C}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,o,a,u,s,c,f,l){"use strict";function p(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))d(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),o=this;this._downloadPromise=e(i.fetchJson(),function(e){d(o,e)},function(){o._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return a.compare(e.julianDate,t)}function d(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=r.columnNames.indexOf("modifiedJulianDateUtc"),o=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),p=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),d=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>o||0>s||0>c||0>p||0>d||0>y)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=r.samples,E=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=p,e._yCelestialPoleOffsetRadiansColumn=d,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _,O=e._addNewLeapSeconds,T=0,w=m.length;w>T;T+=e._columnCount){var R=m[T+i],v=m[T+y],A=R+f.MODIFIED_JULIAN_DATE_DIFFERENCE,b=new a(A,v,l.TAI);if(E.push(b),O){if(v!==_&&n(_)){var g=a.leapSeconds,S=t(g,b,h);if(0>S){var I=new u(b,v);g.splice(~S,0,I)}}_=v}}}function y(e,t,r,n,i){var o=r*n;i.xPoleWander=t[o+e._xPoleWanderRadiansColumn],i.yPoleWander=t[o+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,i,o,u){var s=e._columnCount;if(o>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],f=t[o];if(c.equals(f)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(f))return y(e,r,o,s,u),u;var l=a.secondsDifference(n,c)/a.secondsDifference(f,c),p=i*s,h=o*s,d=r[p+e._ut1MinusUtcSecondsColumn],E=r[h+e._ut1MinusUtcSecondsColumn],_=E-d;if(_>.5||-.5>_){var O=r[p+e._taiMinusUtcSecondsColumn],T=r[h+e._taiMinusUtcSecondsColumn];O!==T&&(f.equals(n)?d=E:E-=T-O)}return u.xPoleWander=m(l,r[p+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(l,r[p+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(l,r[p+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(l,r[p+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(l,d,E),u}return p.NONE=o({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var o=this._dates,u=this._lastIndex,s=0,f=0;if(n(u)){var l=o[u],p=o[u+1],h=a.lessThanOrEquals(l,e),d=!n(p),y=d||a.greaterThanOrEquals(p,e);if(h&&y)return s=u,!d&&p.equals(e)&&++s,f=s+1,E(this,o,this._samples,e,s,f,r),r}var m=t(o,e,a.compare,this._dateColumn);return m>=0?(m<o.length-1&&o[m+1].equals(e)&&++m,s=m,f=m):(f=~m,s=f-1,0>s&&(s=0)),this._lastIndex=s,E(this,o,this._samples,e,s,f,r),r}if(n(this._dataError))throw new c(this._dataError)},p}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var o=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,a),n.pitch=-Math.asin(o),n},i.fromDegrees=function(e,o,a,u){if(!t(e))throw new r("heading is required");if(!t(o))throw new r("pitch is required");if(!t(a))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=o*n.RADIANS_PER_DEGREE,u.roll=a*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){return t(e)?t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll):void 0},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,o)&&n.equalsEpsilon(e.pitch,r.pitch,i,o)&&n.equalsEpsilon(e.roll,r.roll,i,o)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i}),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],function(e,t,r,n,i){"use strict";function o(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var n=e[t].getAttribute("src"),i=d.exec(n);if(null!==i)return i[1]}}function a(t){return"undefined"==typeof document?t:(e(l)||(l=document.createElement("a")),l.href=t,l.href=l.href,l.href)}function u(){if(e(p))return p;var u;if(u="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",f("Core/buildModuleUrl.js")):o(),!e(u))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return p=new n({url:a(u)}),p.appendForwardSlash(),p}function s(e){return a(i.toUrl("../"+e))}function c(e){var t=u().getDerivedResource({url:e});return t.url}function f(t){e(h)||(h=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?s:c);var r=h(t);return r}var l,p,h,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return f._cesiumScriptRegex=d,f._buildModuleUrlFromBaseUrl=c,f._clearBaseResource=function(){p=void 0},f.setBaseUrl=function(e){p=n.DEFAULT.getDerivedResource({url:e})},f.getCesiumBaseUrl=u,f}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],function(e,t,r,n,i,o,a,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=a.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new o(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;t>=c;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var f=0;t>=f;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=l;return n.dayNumber=t,n.secondsOfDay=r,o.daysDifference(n,e._sampleZeroDateTT)}function f(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var o=e.defer();r._chunkDownloadsInProgress[i]=o;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.getDerivedResource({templateValues:{0:i}}):new a({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(u.fetchJson(),function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,a=i*r._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)t[a+u]=n[u];o.resolve()}),o.promise}var l=new o(0,0,u.TAI);return s.prototype.preload=function(t,r,n,i){var o=c(this,t,r),a=c(this,n,i),u=o/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var s=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var l=u/this._samplesPerXysFile|0,p=s/this._samplesPerXysFile|0,h=[],d=l;p>=d;++d)h.push(f(this,d));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var o=c(this,e,t);if(!(0>o)){var a=o/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var u=this._interpolationOrder,s=a-(u/2|0);0>s&&(s=0);var l=s+u;l>=this._totalSamples&&(l=this._totalSamples-1,s=l-u,0>s&&(s=0));var p=!1,h=this._samples;if(n(h[3*s])||(f(this,s/this._samplesPerXysFile|0),p=!0),n(h[3*l])||(f(this,l/this._samplesPerXysFile|0),p=!0),!p){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var d,y,m=o-s*this._stepSizeDays,E=this._work,_=this._denominators,O=this._coef,T=this._xTable;for(d=0;u>=d;++d)E[d]=m-T[d];for(d=0;u>=d;++d){for(O[d]=1,y=0;u>=y;++y)y!==d&&(O[d]*=E[y]);O[d]*=_[d];var w=3*(s+d);r.x+=O[d]*h[w++],r.y+=O[d]*h[w++],r.s+=O[d]*h[w]}return r}}}},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,i,o,a,u,s,c,f,l,p,h,d,y,m,E,_,O,T){"use strict";var w={},R={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},v={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},A={},b={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},g=new r,S=new r,I=new r;w.localFrameToFixedFrameGenerator=function(e,t){if(!R.hasOwnProperty(e)||!R[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=R[e][t],o=e+t;return u(A[o])?n=A[o]:(n=function(n,o,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new _),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var f=m.sign(n.z);r.unpack(v[e],0,g),"east"!==e&&"west"!==e&&r.multiplyByScalar(g,f,g),r.unpack(v[t],0,S),"east"!==t&&"west"!==t&&r.multiplyByScalar(S,f,S),r.unpack(v[i],0,I),"east"!==i&&"west"!==i&&r.multiplyByScalar(I,f,I)}else{o=a(o,l.WGS84),o.geodeticSurfaceNormal(n,b.up);var p=b.up,h=b.east;h.x=-n.y,h.y=n.x,h.z=0,r.normalize(h,b.east),r.cross(p,h,b.north),r.multiplyByScalar(b.up,-1,b.down),r.multiplyByScalar(b.east,-1,b.west),r.multiplyByScalar(b.north,-1,b.south),g=b[e],S=b[t],I=b[i]}return c[0]=g.x,c[1]=g.y,c[2]=g.z,c[3]=0,c[4]=S.x,c[5]=S.y,c[6]=S.z,c[7]=0,c[8]=I.x,c[9]=I.y,c[10]=I.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},A[o]=n),n},w.eastNorthUpToFixedFrame=w.localFrameToFixedFrameGenerator("east","north"),w.northEastDownToFixedFrame=w.localFrameToFixedFrameGenerator("north","east"),w.northUpEastToFixedFrame=w.localFrameToFixedFrameGenerator("north","up"),w.northWestUpToFixedFrame=w.localFrameToFixedFrameGenerator("north","west");var N=new O,M=new r(1,1,1),C=new _;w.headingPitchRollToFixedFrame=function(e,t,n,i,u){o.typeOf.object("HeadingPitchRoll",t),i=a(i,w.eastNorthUpToFixedFrame);var s=O.fromHeadingPitchRoll(t,N),c=_.fromTranslationQuaternionRotationScale(r.ZERO,s,M,C);return u=i(e,n,u),_.multiply(u,c,u)};var x=new _,P=new E;w.headingPitchRollQuaternion=function(e,t,r,n,i){o.typeOf.object("HeadingPitchRoll",t);var a=w.headingPitchRollToFixedFrame(e,t,r,n,x),u=_.getRotation(a,P);return O.fromRotationMatrix(u,i)};var U=new r(1,1,1),D=new r,q=new _,F=new _,L=new E,j=new O;w.fixedFrameToHeadingPitchRoll=function(e,t,n,i){o.defined("transform",e),t=a(t,l.WGS84),n=a(n,w.eastNorthUpToFixedFrame),u(i)||(i=new p);var s=_.getTranslation(e,D);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=_.inverseTransformation(n(s,t,q),q),f=_.setScale(e,U,F);f=_.setTranslation(f,r.ZERO,f),c=_.multiply(c,f,c);var h=O.fromRotationMatrix(_.getRotation(c,L),j);return h=O.normalize(h,h),p.fromQuaternion(h,i)};var B=24110.54841,z=8640184.812866,G=.093104,V=-62e-7,k=1.1772758384668e-19,X=72921158553e-15,W=m.TWO_PI/86400,H=new y;w.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");H=y.addSeconds(e,-y.computeTaiMinusUtc(e),H);var r,n=H.dayNumber,i=H.secondsOfDay,o=n-2451545;r=i>=43200?(o+.5)/T.DAYS_PER_JULIAN_CENTURY:(o-.5)/T.DAYS_PER_JULIAN_CENTURY;var a=B+r*(z+r*(G+r*V)),c=a*W%m.TWO_PI,f=X+k*(n-2451545.5),l=(i+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY,p=c+f*l,h=Math.cos(p),d=Math.sin(p);return u(t)?(t[0]=h,t[1]=-d,t[2]=0,t[3]=d,t[4]=h,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(h,d,0,-d,h,0,0,0,1)},w.iau2006XysData=new h,w.earthOrientationParameters=c.NONE;var Y=32.184,K=2451545;w.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+Y,i=t.stop.dayNumber,o=t.stop.secondsOfDay+Y,a=w.iau2006XysData.preload(r,n,i,o),u=w.earthOrientationParameters.getPromiseToLoad();return e.all([a,u])},w.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=w.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var Z=new d(0,0,0),J=new f(0,0,0,0,0,0),Q=new E,$=new E;w.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=w.earthOrientationParameters.compute(e,J);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+Y,o=w.iau2006XysData.computeXysRadians(n,i,Z);if(u(o)){var a=o.x+r.xPoleOffset,c=o.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-a*a-c*c)),l=Q;l[0]=1-f*a*a,l[3]=-f*a*c,l[6]=a,l[1]=-f*a*c,l[4]=1-f*c*c,l[7]=c,l[2]=-a,l[5]=-c,l[8]=1-f*(a*a+c*c);var p=E.fromRotationZ(-o.s,$),h=E.multiply(l,p,Q),d=e.dayNumber,_=e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc,O=d-2451545,R=_/T.SECONDS_PER_DAY,v=.779057273264+R+.00273781191135448*(O+R);v=v%1*m.TWO_PI;var A=E.fromRotationZ(v,$),b=E.multiply(h,A,Q),g=Math.cos(r.xPoleWander),S=Math.cos(r.yPoleWander),I=Math.sin(r.xPoleWander),N=Math.sin(r.yPoleWander),M=n-K+i/T.SECONDS_PER_DAY;M/=36525;var C=-47e-6*M*m.RADIANS_PER_DEGREE/3600,x=Math.cos(C),P=Math.sin(C),U=$;return U[0]=g*x,U[1]=g*P,U[2]=I,U[3]=-S*P+N*I*x,U[4]=S*x+N*I*P,U[5]=-N*g,U[6]=-N*P-S*I*x,U[7]=N*x-S*I*P,U[8]=S*g,E.multiply(b,U,t)}}};var ee=new n;w.pointToWindowCoordinates=function(e,t,r,n){return n=w.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},w.pointToGLWindowCoordinates=function(e,r,i,o){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(o)||(o=new t);var a=ee;return _.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,a),a),n.multiplyByScalar(a,1/a.w,a),_.multiplyByVector(r,a,a),t.fromCartesian4(a,o)};var te=new r,re=new r,ne=new r;w.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var o=a(n,l.WGS84).geodeticSurfaceNormal(e,te),c=r.cross(t,o,re);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,ne);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new E),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=f.x,i[7]=f.y,i[8]=f.z,i};var ie=new _(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),oe=new i,ae=new r,ue=new r,se=new E,ce=new _,fe=new _;return w.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=_.getTranslation(t,ue),o=e.ellipsoid,a=o.cartesianToCartographic(i,oe),c=e.project(a,ae);r.fromElements(c.z,c.x,c.y,c);var f=w.eastNorthUpToFixedFrame(i,o,ce),l=_.inverseTransformation(f,fe),p=_.getRotation(t,se),h=_.multiplyByMatrix3(l,p,n);return _.multiply(ie,h,n),_.setTranslation(n,c,n),n},w.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,o=w.eastNorthUpToFixedFrame(t,i,ce),a=_.inverseTransformation(o,fe),c=i.cartesianToCartographic(t,oe),f=e.project(c,ae);r.fromElements(f.z,f.x,f.y,f);var l=_.fromTranslation(f,ce);return _.multiply(ie,a,n),_.multiply(l,n,n),n},w.buildUp=function(e,t){var n=t.clone(),i=e.clone();i=r.normalize(i,i),Math.abs(r.dot(i,n))>=1&&(i=Math.abs(r.dot(n,r.UNIT_Y))<1?r.clone(r.UNIT_Y,i):r.clone(r.UNIT_Z,i));var o=new r;return r.cross(i,n,o),o=r.normalize(o,o),r.cross(n,o,i),i=r.normalize(i,i)},w.getHeading=function(e,t){var r;return r=m.equalsEpsilon(Math.abs(e.z),1,m.EPSILON3)?Math.atan2(t.y,t.x)-m.PI_OVER_TWO:Math.atan2(e.y,e.x)-m.PI_OVER_TWO,m.TWO_PI-m.zeroToTwoPi(r)},w}),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],function(e,t,r,n,i,o,a,u,s,c,f,l,p,h,d,y){"use strict";function m(e){e=i(e,i.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=i(e.primitiveType,p.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=i(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}m.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&o(e.attributes[r])&&o(e.attributes[r].values)){var i=e.attributes[r],u=i.values.length/i.componentsPerAttribute;if(t!==u&&-1!==t)throw new a("All attribute lists must have the same number of attributes.");t=u}return t};var E=new r,_=new t,O=new l,T=[new r,new r,new r],w=[new e,new e,new e],R=[new e,new e,new e],v=new t,A=new h,b=new l,g=new c;return m._textureCoordinateRotationPoints=function(n,i,o,a){var u,s=d.center(a,E),p=r.toCartesian(s,o,_),m=y.eastNorthUpToFixedFrame(p,o,O),S=l.inverse(m,O),I=w,N=T;N[0].longitude=a.west,N[0].latitude=a.south,N[1].longitude=a.west,N[1].latitude=a.north,N[2].longitude=a.east,N[2].latitude=a.south;var M=v;for(u=0;3>u;u++)r.toCartesian(N[u],o,M),M=l.multiplyByPointAsVector(S,M,M),I[u].x=M.x,I[u].y=M.y;var C=h.fromAxisAngle(t.UNIT_Z,-i,A),x=f.fromQuaternion(C,b),P=n.length,U=Number.POSITIVE_INFINITY,D=Number.POSITIVE_INFINITY,q=Number.NEGATIVE_INFINITY,F=Number.NEGATIVE_INFINITY;for(u=0;P>u;u++)M=l.multiplyByPointAsVector(S,n[u],M),M=f.multiplyByVector(x,M,M),U=Math.min(U,M.x),D=Math.min(D,M.y),q=Math.max(q,M.x),F=Math.max(F,M.y);var L=c.fromRotation(i,g),j=R;j[0].x=U,j[0].y=D,j[1].x=U,j[1].y=F,j[2].x=q,j[2].y=D;var B=I[0],z=I[2].x-B.x,G=I[1].y-B.y;for(u=0;3>u;u++){var V=j[u];c.multiplyByVector(L,V,V),V.x=(V.x-B.x)/z,V.y=(V.y-B.y)/G}var k=j[0],X=j[1],W=j[2],H=new Array(6);return e.pack(k,H),e.pack(X,H,2),e.pack(W,H,4),H},m}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],function(e,t,r,n,i,o,a){"use strict";function u(r,i){if(t.typeOf.object("normal",r),!o.equalsEpsilon(e.magnitude(r),1,o.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",i),this.normal=e.clone(r),this.distance=i}u.fromPointNormal=function(i,a,s){if(t.typeOf.object("point",i),t.typeOf.object("normal",a),!o.equalsEpsilon(e.magnitude(a),1,o.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(a,i);return r(s)?(e.clone(a,s.normal),s.distance=c,s):new u(a,c)};var s=new e;u.fromCartesian4=function(i,a){t.typeOf.object("coefficients",i);var c=e.fromCartesian4(i,s),f=i.w;if(!o.equalsEpsilon(e.magnitude(c),1,o.EPSILON6))throw new n("normal must be normalized.");return r(a)?(e.clone(c,a.normal),a.distance=f,a):new u(c,f)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,i,o){t.typeOf.object("plane",n),t.typeOf.object("point",i),r(o)||(o=new e);var a=u.getPointDistance(n,i),s=e.multiplyByScalar(n.normal,a,c);return e.subtract(i,s,o)};var f=new e;return u.transform=function(r,n,i){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),a.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,f),a.multiplyByPoint(n,f,f),u.fromPointNormal(f,s,i)},u.clone=function(n,i){return t.typeOf.object("plane",n),r(i)?(e.clone(n.normal,i.normal),i.distance=n.distance,i):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=i(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=i(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=i(new u(e.UNIT_Y,0)),u}),define("Core/CullingVolume",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./Intersect","./Plane"],function(e,t,r,n,i,o,a){"use strict";function u(e){this.planes=r(e,[])}var s=[new e,new e,new e];e.clone(e.UNIT_X,s[0]),e.clone(e.UNIT_Y,s[1]),e.clone(e.UNIT_Z,s[2]);var c=new e,f=new e,l=new a(new e(1,0,0),0);return u.fromBoundingSphere=function(r,o){if(!n(r))throw new i("boundingSphere is required.");n(o)||(o=new u);var a=s.length,l=o.planes;l.length=2*a;for(var p=r.center,h=r.radius,d=0,y=0;a>y;++y){var m=s[y],E=l[d],_=l[d+1];n(E)||(E=l[d]=new t),n(_)||(_=l[d+1]=new t),
e.multiplyByScalar(m,-h,c),e.add(p,c,c),E.x=m.x,E.y=m.y,E.z=m.z,E.w=-e.dot(m,c),e.multiplyByScalar(m,h,c),e.add(p,c,c),_.x=-m.x,_.y=-m.y,_.z=-m.z,_.w=-e.dot(e.negate(m,f),c),d+=2}return o},u.prototype.computeVisibility=function(e){if(!n(e))throw new i("boundingVolume is required.");for(var t=this.planes,r=!1,u=0,s=t.length;s>u;++u){var c=e.intersectPlane(a.fromCartesian4(t[u],l));if(c===o.OUTSIDE)return o.OUTSIDE;c===o.INTERSECTING&&(r=!0)}return r?o.INTERSECTING:o.INSIDE},u.prototype.computeVisibilityWithPlaneMask=function(e,t){if(!n(e))throw new i("boundingVolume is required.");if(!n(t))throw new i("parentPlaneMask is required.");if(t===u.MASK_OUTSIDE||t===u.MASK_INSIDE)return t;for(var r=u.MASK_INSIDE,s=this.planes,c=0,f=s.length;f>c;++c){var p=31>c?1<<c:0;if(!(31>c&&0===(t&p))){var h=e.intersectPlane(a.fromCartesian4(s[c],l));if(h===o.OUTSIDE)return u.MASK_OUTSIDE;h===o.INTERSECTING&&(r|=p)}}return r},u.MASK_OUTSIDE=4294967295,u.MASK_INSIDE=0,u.MASK_INDETERMINATE=2147483647,u}),define("Core/OrthographicOffCenterFrustum",["./Cartesian3","./Cartesian4","./CullingVolume","./defaultValue","./defined","./defineProperties","./DeveloperError","./Math","./Matrix4"],function(e,t,r,n,i,o,a,u,s){"use strict";function c(e){e=n(e,n.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=n(e.near,1),this._near=this.near,this.far=n(e.far,5e8),this._far=this.far,this._cullingVolume=new r,this._orthographicMatrix=new s}function f(e){if(!(i(e.right)&&i(e.left)&&i(e.top)&&i(e.bottom)&&i(e.near)&&i(e.far)))throw new a("right, left, top, bottom, near, or far parameters are not set.");if(e.top!==e._top||e.bottom!==e._bottom||e.left!==e._left||e.right!==e._right||e.near!==e._near||e.far!==e._far){if(e.left>e.right)throw new a("right must be greater than left.");if(e.bottom>e.top)throw new a("top must be greater than bottom.");if(e.near<=0||e.near>e.far)throw new a("near must be greater than zero and less than far.");e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=s.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix)}}o(c.prototype,{projectionMatrix:{get:function(){return f(this),this._orthographicMatrix}}});var l=new e,p=new e,h=new e,d=new e;return c.prototype.computeCullingVolume=function(r,n,o){if(!i(r))throw new a("position is required.");if(!i(n))throw new a("direction is required.");if(!i(o))throw new a("up is required.");var u=this._cullingVolume.planes,s=this.top,c=this.bottom,f=this.right,y=this.left,m=this.near,E=this.far,_=e.cross(n,o,l);e.normalize(_,_);var O=p;e.multiplyByScalar(n,m,O),e.add(r,O,O);var T=h;e.multiplyByScalar(_,y,T),e.add(O,T,T);var w=u[0];return i(w)||(w=u[0]=new t),w.x=_.x,w.y=_.y,w.z=_.z,w.w=-e.dot(_,T),e.multiplyByScalar(_,f,T),e.add(O,T,T),w=u[1],i(w)||(w=u[1]=new t),w.x=-_.x,w.y=-_.y,w.z=-_.z,w.w=-e.dot(e.negate(_,d),T),e.multiplyByScalar(o,c,T),e.add(O,T,T),w=u[2],i(w)||(w=u[2]=new t),w.x=o.x,w.y=o.y,w.z=o.z,w.w=-e.dot(o,T),e.multiplyByScalar(o,s,T),e.add(O,T,T),w=u[3],i(w)||(w=u[3]=new t),w.x=-o.x,w.y=-o.y,w.z=-o.z,w.w=-e.dot(e.negate(o,d),T),w=u[4],i(w)||(w=u[4]=new t),w.x=n.x,w.y=n.y,w.z=n.z,w.w=-e.dot(n,O),e.multiplyByScalar(n,E,T),e.add(r,T,T),w=u[5],i(w)||(w=u[5]=new t),w.x=-n.x,w.y=-n.y,w.z=-n.z,w.w=-e.dot(e.negate(n,d),T),this._cullingVolume},c.prototype.getPixelDimensions=function(e,t,r,n){if(f(this),!i(e)||!i(t))throw new a("Both drawingBufferWidth and drawingBufferHeight are required.");if(0>=e)throw new a("drawingBufferWidth must be greater than zero.");if(0>=t)throw new a("drawingBufferHeight must be greater than zero.");if(!i(r))throw new a("distance is required.");if(!i(n))throw new a("A result object is required.");var o=this.right-this.left,u=this.top-this.bottom,s=o/e,c=u/t;return n.x=s,n.y=c,n},c.prototype.clone=function(e){return i(e)||(e=new c),e.left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},c.prototype.equals=function(e){return i(e)&&e instanceof c&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},c.prototype.equalsEpsilon=function(e,t,r){return e===this||i(e)&&e instanceof c&&u.equalsEpsilon(this.right,e.right,t,r)&&u.equalsEpsilon(this.left,e.left,t,r)&&u.equalsEpsilon(this.top,e.top,t,r)&&u.equalsEpsilon(this.bottom,e.bottom,t,r)&&u.equalsEpsilon(this.near,e.near,t,r)&&u.equalsEpsilon(this.far,e.far,t,r)},c}),define("Core/OrthographicFrustum",["./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Math","./OrthographicOffCenterFrustum"],function(e,t,r,n,i,o,a){"use strict";function u(e){e=t(e,t.EMPTY_OBJECT),this._offCenterFrustum=new a,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=t(e.near,1),this._near=this.near,this.far=t(e.far,5e8),this._far=this.far}function s(e){if(!(r(e.width)&&r(e.aspectRatio)&&r(e.near)&&r(e.far)))throw new i("width, aspectRatio, near, or far parameters are not set.");var t=e._offCenterFrustum;if(e.width!==e._width||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far){if(e.aspectRatio<0)throw new i("aspectRatio must be positive.");if(e.near<0||e.near>e.far)throw new i("near must be greater than zero and less than far.");e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far;var n=1/e.aspectRatio;t.right=.5*e.width,t.left=-t.right,t.top=n*t.right,t.bottom=-t.top,t.near=e.near,t.far=e.far}}return u.packedLength=4,u.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.width,n[i++]=r.aspectRatio,n[i++]=r.near,n[i]=r.far,n},u.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new u),o.width=n[i++],o.aspectRatio=n[i++],o.near=n[i++],o.far=n[i],o},n(u.prototype,{projectionMatrix:{get:function(){return s(this),this._offCenterFrustum.projectionMatrix}}}),u.prototype.computeCullingVolume=function(e,t,r){return s(this),this._offCenterFrustum.computeCullingVolume(e,t,r)},u.prototype.getPixelDimensions=function(e,t,r,n){return s(this),this._offCenterFrustum.getPixelDimensions(e,t,r,n)},u.prototype.clone=function(e){return r(e)||(e=new u),e.aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},u.prototype.equals=function(e){return r(e)&&e instanceof u?(s(this),s(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum)):!1},u.prototype.equalsEpsilon=function(e,t,n){return r(e)&&e instanceof u?(s(this),s(e),o.equalsEpsilon(this.width,e.width,t,n)&&o.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,n)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,n)):!1},u}),define("Core/PerspectiveOffCenterFrustum",["./Cartesian3","./Cartesian4","./CullingVolume","./defaultValue","./defined","./defineProperties","./DeveloperError","./Math","./Matrix4"],function(e,t,r,n,i,o,a,u,s){"use strict";function c(e){e=n(e,n.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=n(e.near,1),this._near=this.near,this.far=n(e.far,5e8),this._far=this.far,this._cullingVolume=new r,this._perspectiveMatrix=new s,this._infinitePerspective=new s}function f(e){if(!(i(e.right)&&i(e.left)&&i(e.top)&&i(e.bottom)&&i(e.near)&&i(e.far)))throw new a("right, left, top, bottom, near, or far parameters are not set.");var t=e.top,r=e.bottom,n=e.right,o=e.left,u=e.near,c=e.far;if(t!==e._top||r!==e._bottom||o!==e._left||n!==e._right||u!==e._near||c!==e._far){if(e.near<=0||e.near>e.far)throw new a("near must be greater than zero and less than far.");e._left=o,e._right=n,e._top=t,e._bottom=r,e._near=u,e._far=c,e._perspectiveMatrix=s.computePerspectiveOffCenter(o,n,r,t,u,c,e._perspectiveMatrix),e._infinitePerspective=s.computeInfinitePerspectiveOffCenter(o,n,r,t,u,e._infinitePerspective)}}o(c.prototype,{projectionMatrix:{get:function(){return f(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return f(this),this._infinitePerspective}}});var l=new e,p=new e,h=new e,d=new e;return c.prototype.resetProjectionMatrix=function(){if(!(i(this.right)&&i(this.left)&&i(this.top)&&i(this.bottom)&&i(this.near)&&i(this.far)))throw new a("right, left, top, bottom, near, or far parameters are not set.");var e=this.top,t=this.bottom,r=this.right,n=this.left,o=this.near,u=this.far;if(this.near<=0||this.near>this.far)throw new a("near must be greater than zero and less than far.");this._left=n,this._right=r,this._top=e,this._bottom=t,this._near=o,this._far=u,this._perspectiveMatrix=s.computePerspectiveOffCenter(n,r,t,e,o,u,this._perspectiveMatrix),this._infinitePerspective=s.computeInfinitePerspectiveOffCenter(n,r,t,e,o,this._infinitePerspective)},c.prototype.computeCullingVolume=function(r,n,o){if(!i(r))throw new a("position is required.");if(!i(n))throw new a("direction is required.");if(!i(o))throw new a("up is required.");var u=this._cullingVolume.planes,s=this.top,c=this.bottom,f=this.right,y=this.left,m=this.near,E=this.far,_=e.cross(n,o,l),O=p;e.multiplyByScalar(n,m,O),e.add(r,O,O);var T=h;e.multiplyByScalar(n,E,T),e.add(r,T,T);var w=d;e.multiplyByScalar(_,y,w),e.add(O,w,w),e.subtract(w,r,w),e.normalize(w,w),e.cross(w,o,w),e.normalize(w,w);var R=u[0];return i(R)||(R=u[0]=new t),R.x=w.x,R.y=w.y,R.z=w.z,R.w=-e.dot(w,r),e.multiplyByScalar(_,f,w),e.add(O,w,w),e.subtract(w,r,w),e.cross(o,w,w),e.normalize(w,w),R=u[1],i(R)||(R=u[1]=new t),R.x=w.x,R.y=w.y,R.z=w.z,R.w=-e.dot(w,r),e.multiplyByScalar(o,c,w),e.add(O,w,w),e.subtract(w,r,w),e.cross(_,w,w),e.normalize(w,w),R=u[2],i(R)||(R=u[2]=new t),R.x=w.x,R.y=w.y,R.z=w.z,R.w=-e.dot(w,r),e.multiplyByScalar(o,s,w),e.add(O,w,w),e.subtract(w,r,w),e.cross(w,_,w),e.normalize(w,w),R=u[3],i(R)||(R=u[3]=new t),R.x=w.x,R.y=w.y,R.z=w.z,R.w=-e.dot(w,r),R=u[4],i(R)||(R=u[4]=new t),R.x=n.x,R.y=n.y,R.z=n.z,R.w=-e.dot(n,O),e.negate(n,w),R=u[5],i(R)||(R=u[5]=new t),R.x=w.x,R.y=w.y,R.z=w.z,R.w=-e.dot(w,T),this._cullingVolume},c.prototype.getPixelDimensions=function(e,t,r,n){if(f(this),!i(e)||!i(t))throw new a("Both drawingBufferWidth and drawingBufferHeight are required.");if(0>=e)throw new a("drawingBufferWidth must be greater than zero.");if(0>=t)throw new a("drawingBufferHeight must be greater than zero.");if(!i(r))throw new a("distance is required.");if(!i(n))throw new a("A result object is required.");var o=1/this.near,u=this.top*o,s=2*r*u/t;u=this.right*o;var c=2*r*u/e;return n.x=c,n.y=s,n},c.prototype.clone=function(e){return i(e)||(e=new c),e.right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},c.prototype.equals=function(e){return i(e)&&e instanceof c&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},c.prototype.equalsEpsilon=function(e,t,r){return e===this||i(e)&&e instanceof c&&u.equalsEpsilon(this.right,e.right,t,r)&&u.equalsEpsilon(this.left,e.left,t,r)&&u.equalsEpsilon(this.top,e.top,t,r)&&u.equalsEpsilon(this.bottom,e.bottom,t,r)&&u.equalsEpsilon(this.near,e.near,t,r)&&u.equalsEpsilon(this.far,e.far,t,r)},c}),define("Core/PerspectiveFrustum",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Math","./Matrix4","./PerspectiveOffCenterFrustum","./Plane"],function(e,t,r,n,i,o,a,u,s,c,f){"use strict";function l(e){e=n(e,n.EMPTY_OBJECT),this._offCenterFrustum=new c,this.fov=e.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=n(e.near,1),this._near=this.near,this.far=n(e.far,5e8),this._far=this.far,this.xOffset=n(e.xOffset,0),this._xOffset=this.xOffset,this.yOffset=n(e.yOffset,0),this._yOffset=this.yOffset,this.reflect=!1}function p(e){if(!(i(e.fov)&&i(e.aspectRatio)&&i(e.near)&&i(e.far)))throw new a("fov, aspectRatio, near, or far parameters are not set.");var t=e._offCenterFrustum;if(e.fov!==e._fov||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far||e.xOffset!==e._xOffset||e.yOffset!==e._yOffset){if(e.fov<0||e.fov>=Math.PI)throw new a("fov must be in the range [0, PI).");if(e.aspectRatio<0)throw new a("aspectRatio must be positive.");if(e.near<0||e.near>e.far)throw new a("near must be greater than zero and less than far.");e._aspectRatio=e.aspectRatio,e._fov=e.fov,e._fovy=e.aspectRatio<=1?e.fov:2*Math.atan(Math.tan(.5*e.fov)/e.aspectRatio),e._near=e.near,e._far=e.far,e._sseDenominator=2*Math.tan(.5*e._fovy),e._xOffset=e.xOffset,e._yOffset=e.yOffset,t.top=e.near*Math.tan(.5*e._fovy),t.bottom=-t.top,t.right=e.aspectRatio*t.top,t.left=-t.right,t.near=e.near,t.far=e.far,t.right+=e.xOffset,t.left+=e.xOffset,t.top+=e.yOffset,t.bottom+=e.yOffset}}function h(e){if(i(e.clipPlane)&&i(e.currentViewMatrix)){var r=e.currentViewMatrix,n=e._offCenterFrustum.projectionMatrix;s.multiplyByPlane(r,e.clipPlane,d),y.x=(u.sign(d.normal.x)+n[8])/n[0],y.y=(u.sign(d.normal.y)+n[9])/n[5],y.z=-1,y.w=(1+n[10])/n[14],m.x=d.normal.x,m.y=d.normal.y,m.z=d.normal.z,m.w=d.distance,t.multiplyByScalar(m,2/t.dot(m,y),E),n[2]=E.x,n[6]=E.y,n[10]=E.z+1,n[14]=E.w}}l.packedLength=6,l.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e.fov,t[i++]=e.aspectRatio,t[i++]=e.near,t[i++]=e.far,t[i++]=e.xOffset,t[i]=e.yOffset,t},l.unpack=function(e,t,o){return r.defined("array",e),t=n(t,0),i(o)||(o=new l),o.fov=e[t++],o.aspectRatio=e[t++],o.near=e[t++],o.far=e[t++],o.xOffset=e[t++],o.yOffset=e[t],o},o(l.prototype,{projectionMatrix:{get:function(){return p(this),this.reflect&&h(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return p(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return p(this),this._fovy}},sseDenominator:{get:function(){return p(this),this._sseDenominator}}}),l.prototype.resetProjectionMatrix=function(){return this._offCenterFrustum.resetProjectionMatrix()},l.prototype.computeCullingVolume=function(e,t,r){return p(this),this._offCenterFrustum.computeCullingVolume(e,t,r)},l.prototype.getPixelDimensions=function(e,t,r,n){return p(this),this._offCenterFrustum.getPixelDimensions(e,t,r,n)},l.prototype.clone=function(e){return i(e)||(e=new l),e.aspectRatio=this.aspectRatio,e.fov=this.fov,e.near=this.near,e.far=this.far,e.reflect=this.reflect,e.clipPlane=this.clipPlane,e.currentViewMatrix=this.currentViewMatrix,e._aspectRatio=void 0,e._fov=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},l.prototype.equals=function(e){return i(e)&&e instanceof l?(p(this),p(e),this.fov===e.fov&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum)):!1},l.prototype.equalsEpsilon=function(e,t,r){return i(e)&&e instanceof l?(p(this),p(e),u.equalsEpsilon(this.fov,e.fov,t,r)&&u.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,r)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,r)):!1};var d=new f(e.UNIT_Z,1),y=new t,m=new t,E=new t;return l}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,o){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");return o=e(o,0),i[o++]=n.position?1:0,i[o++]=n.normal?1:0,i[o++]=n.st?1:0,i[o++]=n.tangent?1:0,i[o++]=n.bitangent?1:0,i[o]=n.color?1:0,i},i.unpack=function(n,o,a){if(!t(n))throw new r("array is required");return o=e(o,0),t(a)||(a=new i),a.position=1===n[o++],a.normal=1===n[o++],a.st=1===n[o++],a.tangent=1===n[o++],a.bitangent=1===n[o++],a.color=1===n[o],a},i.clone=function(e,r){return t(e)?(t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r):void 0},i}),define("Core/FrustumGeometry",["./BoundingSphere","./Cartesian3","./Cartesian4","./Check","./ComponentDatatype","./defaultValue","./defined","./Geometry","./GeometryAttribute","./GeometryAttributes","./Matrix3","./Matrix4","./OrthographicFrustum","./PerspectiveFrustum","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,n,i,o,a,u,s,c,f,l,p,h,d,y,m){"use strict";function E(e){n.typeOf.object("options",e),n.typeOf.object("options.frustum",e.frustum),n.typeOf.object("options.origin",e.origin),n.typeOf.object("options.orientation",e.orientation);var r,i,a=e.frustum,u=e.orientation,s=e.origin,c=o(e.vertexFormat,m.DEFAULT),f=o(e._drawNearPlane,!0);a instanceof h?(r=O,i=h.packedLength):a instanceof p&&(r=T,i=p.packedLength),this._frustumType=r,this._frustum=a.clone(),this._origin=t.clone(s),this._orientation=y.clone(u),this._drawNearPlane=f,this._vertexFormat=c,this._workerName="createFrustumGeometry",this.packedLength=2+i+t.packedLength+y.packedLength+m.packedLength}function _(e,t,r,n,i,o,u,s){for(var c=e/3*2,f=0;4>f;++f)a(t)&&(t[e]=o.x,t[e+1]=o.y,t[e+2]=o.z),a(r)&&(r[e]=u.x,r[e+1]=u.y,r[e+2]=u.z),a(n)&&(n[e]=s.x,n[e+1]=s.y,n[e+2]=s.z),e+=3;i[c]=0,i[c+1]=0,i[c+2]=1,i[c+3]=0,i[c+4]=1,i[c+5]=1,i[c+6]=0,i[c+7]=1}var O=0,T=1;E.pack=function(e,r,i){n.typeOf.object("value",e),n.defined("array",r),i=o(i,0);var a=e._frustumType,u=e._frustum;return r[i++]=a,a===O?(h.pack(u,r,i),i+=h.packedLength):(p.pack(u,r,i),i+=p.packedLength),t.pack(e._origin,r,i),i+=t.packedLength,y.pack(e._orientation,r,i),i+=y.packedLength,m.pack(e._vertexFormat,r,i),i+=m.packedLength,r[i]=e._drawNearPlane?1:0,r};var w=new h,R=new p,v=new y,A=new t,b=new m;E.unpack=function(e,r,i){n.defined("array",e),r=o(r,0);var u,s=e[r++];s===O?(u=h.unpack(e,r,w),r+=h.packedLength):(u=p.unpack(e,r,R),r+=p.packedLength);var c=t.unpack(e,r,A);r+=t.packedLength;var f=y.unpack(e,r,v);r+=y.packedLength;var l=m.unpack(e,r,b);r+=m.packedLength;var d=1===e[r];if(!a(i))return new E({frustum:u,origin:c,orientation:f,vertexFormat:l,_drawNearPlane:d});var _=s===i._frustumType?i._frustum:void 0;return i._frustum=u.clone(_),i._frustumType=s,i._origin=t.clone(c,i._origin),i._orientation=y.clone(f,i._orientation),i._vertexFormat=m.clone(l,i._vertexFormat),i._drawNearPlane=d,i};var g=new f,S=new l,I=new l,N=new t,M=new t,C=new t,x=new t,P=new t,U=new t,D=new Array(3),q=new Array(4);q[0]=new r(-1,-1,1,1),q[1]=new r(1,-1,1,1),q[2]=new r(1,1,1,1),q[3]=new r(-1,1,1,1);for(var F=new Array(4),L=0;4>L;++L)F[L]=new r;return E._computeNearFarPlanes=function(e,n,i,u,s,c,p,h){var d=f.fromQuaternion(n,g),y=o(c,N),m=o(p,M),E=o(h,C);y=f.getColumn(d,0,y),m=f.getColumn(d,1,m),E=f.getColumn(d,2,E),t.normalize(y,y),t.normalize(m,m),t.normalize(E,E),t.negate(y,y);var _,T,w=l.computeView(e,E,m,y,S);if(i===O){var R=u.projectionMatrix,v=l.multiply(R,w,I);T=l.inverse(v,I)}else _=l.inverseTransformation(w,I);a(T)?(D[0]=u.near,D[1]=u.far):(D[0]=0,D[1]=u.near,D[2]=u.far);for(var A=0;2>A;++A)for(var b=0;4>b;++b){var x=r.clone(q[b],F[b]);if(a(T)){x=l.multiplyByVector(T,x,x);var P=1/x.w;t.multiplyByScalar(x,P,x),t.subtract(x,e,x),t.normalize(x,x);var U=t.dot(E,x);t.multiplyByScalar(x,D[A]/U,x),t.add(x,e,x)}else{a(u._offCenterFrustum)&&(u=u._offCenterFrustum);var L=D[A],j=D[A+1];x.x=.5*(x.x*(u.right-u.left)+u.left+u.right),x.y=.5*(x.y*(u.top-u.bottom)+u.bottom+u.top),x.z=.5*(x.z*(L-j)-L-j),x.w=1,l.multiplyByVector(_,x,x)}s[12*A+3*b]=x.x,s[12*A+3*b+1]=x.y,s[12*A+3*b+2]=x.z}},E.createGeometry=function(r){var n=r._frustumType,o=r._frustum,f=r._origin,l=r._orientation,p=r._drawNearPlane,h=r._vertexFormat,y=p?6:5,m=new Float64Array(72);E._computeNearFarPlanes(f,l,n,o,m);var O=24;m[O]=m[12],m[O+1]=m[13],m[O+2]=m[14],m[O+3]=m[0],m[O+4]=m[1],m[O+5]=m[2],m[O+6]=m[9],m[O+7]=m[10],m[O+8]=m[11],m[O+9]=m[21],m[O+10]=m[22],m[O+11]=m[23],O+=12,m[O]=m[15],m[O+1]=m[16],m[O+2]=m[17],m[O+3]=m[3],m[O+4]=m[4],m[O+5]=m[5],m[O+6]=m[0],m[O+7]=m[1],m[O+8]=m[2],m[O+9]=m[12],m[O+10]=m[13],m[O+11]=m[14],O+=12,m[O]=m[3],m[O+1]=m[4],m[O+2]=m[5],m[O+3]=m[15],m[O+4]=m[16],m[O+5]=m[17],m[O+6]=m[18],m[O+7]=m[19],m[O+8]=m[20],m[O+9]=m[6],m[O+10]=m[7],m[O+11]=m[8],O+=12,m[O]=m[6],m[O+1]=m[7],m[O+2]=m[8],m[O+3]=m[18],m[O+4]=m[19],m[O+5]=m[20],m[O+6]=m[21],m[O+7]=m[22],m[O+8]=m[23],m[O+9]=m[9],m[O+10]=m[10],m[O+11]=m[11],p||(m=m.subarray(12));var T=new c({position:new s({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:m})});if(a(h.normal)||a(h.tangent)||a(h.bitangent)||a(h.st)){var w=a(h.normal)?new Float32Array(12*y):void 0,R=a(h.tangent)?new Float32Array(12*y):void 0,v=a(h.bitangent)?new Float32Array(12*y):void 0,A=a(h.st)?new Float32Array(8*y):void 0,b=N,g=M,S=C,I=t.negate(b,x),D=t.negate(g,P),q=t.negate(S,U);O=0,p&&(_(O,w,R,v,A,q,b,g),O+=12),_(O,w,R,v,A,S,I,g),O+=12,_(O,w,R,v,A,I,q,g),O+=12,_(O,w,R,v,A,D,q,I),O+=12,_(O,w,R,v,A,b,S,g),O+=12,_(O,w,R,v,A,g,S,I),a(w)&&(T.normal=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:w})),a(R)&&(T.tangent=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R})),a(v)&&(T.bitangent=new s({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:v})),a(A)&&(T.st=new s({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:A}))}for(var F=new Uint16Array(6*y),L=0;y>L;++L){var j=6*L,B=4*L;F[j]=B,F[j+1]=B+1,F[j+2]=B+2,F[j+3]=B,F[j+4]=B+2,F[j+5]=B+3}return new u({attributes:T,indices:F,primitiveType:d.TRIANGLES,boundingSphere:e.fromVertices(m)})},E}),define("Core/FrustumOutlineGeometry",["./BoundingSphere","./Cartesian3","./Check","./ComponentDatatype","./defaultValue","./defined","./FrustumGeometry","./Geometry","./GeometryAttribute","./GeometryAttributes","./OrthographicFrustum","./PerspectiveFrustum","./PrimitiveType","./Quaternion"],function(e,t,r,n,i,o,a,u,s,c,f,l,p,h){"use strict";function d(e){r.typeOf.object("options",e),r.typeOf.object("options.frustum",e.frustum),r.typeOf.object("options.origin",e.origin),r.typeOf.object("options.orientation",e.orientation);var n,o,a=e.frustum,u=e.orientation,s=e.origin,c=i(e._drawNearPlane,!0);a instanceof l?(n=y,o=l.packedLength):a instanceof f&&(n=m,o=f.packedLength),this._frustumType=n,this._frustum=a.clone(),this._origin=t.clone(s),this._orientation=h.clone(u),this._drawNearPlane=c,this._workerName="createFrustumOutlineGeometry",this.packedLength=2+o+t.packedLength+h.packedLength}var y=0,m=1;d.pack=function(e,n,o){r.typeOf.object("value",e),r.defined("array",n),o=i(o,0);var a=e._frustumType,u=e._frustum;return n[o++]=a,a===y?(l.pack(u,n,o),o+=l.packedLength):(f.pack(u,n,o),o+=f.packedLength),t.pack(e._origin,n,o),o+=t.packedLength,h.pack(e._orientation,n,o),o+=h.packedLength,n[o]=e._drawNearPlane?1:0,n};var E=new l,_=new f,O=new h,T=new t;return d.unpack=function(e,n,a){r.defined("array",e),n=i(n,0);var u,s=e[n++];s===y?(u=l.unpack(e,n,E),n+=l.packedLength):(u=f.unpack(e,n,_),n+=f.packedLength);var c=t.unpack(e,n,T);n+=t.packedLength;var p=h.unpack(e,n,O);n+=h.packedLength;var m=1===e[n];if(!o(a))return new d({frustum:u,origin:c,orientation:p,_drawNearPlane:m});var w=s===a._frustumType?a._frustum:void 0;return a._frustum=u.clone(w),a._frustumType=s,a._origin=t.clone(c,a._origin),a._orientation=h.clone(p,a._orientation),a._drawNearPlane=m,a},d.createGeometry=function(t){var r=t._frustumType,i=t._frustum,o=t._origin,f=t._orientation,l=t._drawNearPlane,h=new Float64Array(24);a._computeNearFarPlanes(o,f,r,i,h);for(var d,y,m=new c({position:new s({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:h})}),E=l?2:1,_=new Uint16Array(8*(E+1)),O=l?0:1;2>O;++O)d=l?8*O:0,y=4*O,_[d]=y,_[d+1]=y+1,_[d+2]=y+1,_[d+3]=y+2,_[d+4]=y+2,_[d+5]=y+3,_[d+6]=y+3,_[d+7]=y;for(O=0;2>O;++O)d=8*(E+O),y=4*O,_[d]=y,_[d+1]=y+4,_[d+2]=y+1,_[d+3]=y+5,_[d+4]=y+2,_[d+5]=y+6,_[d+6]=y+3,_[d+7]=y+7;return new u({attributes:m,indices:_,primitiveType:p.LINES,boundingSphere:e.fromVertices(h)})},d}),define("Workers/createFrustumOutlineGeometry",["../Core/defined","../Core/FrustumOutlineGeometry"],function(e,t){"use strict";function r(r,n){return e(n)&&(r=t.unpack(r,n)),t.createGeometry(r)}return r})}();