/**
 *  创建后台UI的导航树搜索框查询组件
 *  by yxw
 *  date: 2019/08/27
 **/

layui.define(['element', 'exception', 'common'], function (exports) {
    "use strict";
    var $ = layui.jquery,
        element = layui.element,
        exception = layui.exception,
        common = layui.common,
        cacheName = 'gtmap-searchbar',
        treeId;

    var SearchBar = function () {
        this.info = {
            name: 'SearchBar',
            version: 'v1.1',
            el: '#gtmap-searchbar',//默认容器
            treeId: 'zTree',
            data: 'main/SearchBar'
        };
        this.config = {
            el: undefined,
            treeId: undefined,
            data: undefined
        };
    };
    //渲染
    SearchBar.prototype.render = function (options) {
        var _that = this;
        var _config = _that.config;
        if (options === undefined || options === null) {
            //如果未配置
            _config.el = _that.info.el;
            _config.treeId = _that.info.treeId;
            _config.data = _that.info.data;
        } else {
            _that.config.data = undefined;
            $.extend(true, _that.config, options);
        }
        var $container = common.getContainer(_that);
        if ($container === null) {
            return;
        }
        //检查是否存在缓存
        var sideBarData = null;
        var cache = layui.data(cacheName);
        if (cache !== undefined && cache !== null && cache.value !== undefined && cache.value !== null) {
            sideBarData = cache;
        } else if (_config.data !== undefined && _config.data !== null) {
            sideBarData = _config.data.data;
            _that.config.el = $container;
        } else {
            exception.throwDataCinfigError(_that, 'data');
        }

        var html = getSearchHtml();
        $container.html(html);
        element.init();
    };

    /**
     * 绑定事件
     * @param {String} events
     * @param {Function} callback
     */
    SearchBar.prototype.on = function (eventName) {
        var that = this;
        if (that.config.el === undefined && that.config.el === null) {
            that.config.el = that.info.el;
            that.config.treeId = that.info.treeId;
        }
        var _con = that.config.el;
        treeId = that.config.treeId;
        //alert(_con);
        if (typeof (eventName) !== 'string') {
            common.throwError('SearchBar error:事件名配置出错，请参考API文档.');
        }

        //点击事件
        if (eventName === 'click') {

            $("#searchBtn").on('click', function () {
                search();
            });

        }

        //enter键,按下事件
        document.onkeydown = function (ev) {
            key = $("#key");
            var search = key.val();
            $('#name').val(search);
            var e = ev || window.event;
            if(e && e.keyCode == 13){

                searchNode();

                searchResult();
            }
        };

        //向上查询
        $("#clickUp").on('click', function () {
            clickUp();
        });

        //向下查询
        $("#clickDown").on('click', function () {
            clickDown();
        });
    };
    /**
     * 清除缓存
     */
    SearchBar.prototype.cleanCached = function () {
        layui.data(cacheName, null);
    };

    var key;
    /**
     * 点击搜索按钮，查询结果
     */
    function search(){
        key = $("#key");
        var search = key.val();
        $('#name').val(search);
        searchNode();

        searchResult();
    }

    var lastValue = "", nodeList = [],nodeIndex=0,clickCount;

    /**
     * 当enter键盘按下：当输入框的键盘按键被按下时，把查询到的数据结果显示在标签中
     */
    function searchResult(){

        var zTree = $.fn.zTree.getZTreeObj(treeId);

        //如果结果有值，则显示比例；如果结果为0，则显示"[0/0]"；如果结果为空，则清空标签框；
        if(nodeList.length){
            //让结果集里边的第一个获取焦点（主要为了设置背景色），再把焦点返回给搜索框
            zTree.selectNode(nodeList[0],false );
            document.getElementById("key").focus();

            clickCount=1; //防止重新输入的搜索信息的时候，没有清空上一次记录

            //显示当前所在的是第一条
            document.getElementById("number").innerHTML="["+clickCount+"/"+nodeList.length+"]";

        }else if(nodeList.length == 0){
            document.getElementById("number").innerHTML="[0/0]";
            zTree.cancelSelectedNode(); //取消焦点
        }

        //如果输入框中没有搜索内容，则清空标签框
        if(document.getElementById("key").value ==""){
            document.getElementById("number").innerHTML="";
            zTree.cancelSelectedNode();
        }
    }

    /**
     * 搜索节点
     */
    function searchNode() {
        var zTree = $.fn.zTree.getZTreeObj(treeId);
        var value = $.trim(key.get(0).value);
        var keyType = "name";

        if (key.hasClass("empty")) {
            value = "";
        }
        if (lastValue === value) return;
        lastValue = value;
        if (value === ""){
            updateNodes(false);
            return;
        };

        nodeList = zTree.getNodesByParamFuzzy(keyType, value); //调用ztree的模糊查询功能，得到符合条件的节点
        updateNodes(true); //更新节点
    }

    /**
     * 高亮显示被搜索到的节点
     */
    function updateNodes(highlight) {
        var zTree = $.fn.zTree.getZTreeObj(treeId);
        for( var i=0, l=nodeList.length; i<l; i++) {
            nodeList[i].highlight = highlight; //高亮显示搜索到的节点(highlight是自己设置的一个属性)
            zTree.expandNode(nodeList[i].getParentNode(), true, false, false); //将搜索到的节点的父节点展开
            zTree.updateNode(nodeList[i]); //更新节点数据，主要用于该节点显示属性的更新
        }
    }

    /**
     *  点击向上按钮时，将焦点移向上一条数据
     */
    function clickUp(){

        var zTree = $.fn.zTree.getZTreeObj(treeId);

        //如果焦点已经移动到了最后一条数据上，就返回第一条重新开始，否则继续移动到下一条
        if(nodeList.length==0){
            layer.msg("没有搜索结果！");
            return ;
        }else if(clickCount==1) {
            layer.msg("已位于第一条记录上！");
            return;
        }else{

            nodeIndex --;

            //让结果集里边的第一个获取焦点（主要为了设置背景色），再把焦点返回给搜索框
            zTree.selectNode(nodeList[nodeIndex], false);
            clickCount --;
        }
        document.getElementById("key").focus();

        //显示当前所在的是条数
        document.getElementById("number").innerHTML = "[" + clickCount + "/" + nodeList.length + "]";
    }

    /**
     * 点击向下按钮时，将焦点移向下一条数据
     */
    function clickDown(){

        var zTree = $.fn.zTree.getZTreeObj(treeId);

        //如果焦点已经移动到了最后一条数据上，则提示用户（或者返回第一条重新开始），否则继续移动到下一条
        if(nodeList.length==0){
            layer.msg("没有搜索结果！");
            return ;
        }else if(nodeList.length==clickCount) {
            layer.msg("已位于最后一条记录上！")
            return;
        }else{

            nodeIndex ++;

            //让结果集里边的第一个获取焦点（主要为了设置背景色），再把焦点返回给搜索框
            zTree.selectNode(nodeList[nodeIndex], false);
            clickCount ++;
        }
        document.getElementById("key").focus();

        //显示当前所在的条数
        document.getElementById("number").innerHTML = "[" + clickCount + "/" + nodeList.length + "]";
    }

    /**
     * 获取html字符串
     * @param {Object} data
     */
    function getSearchHtml() {
        var arrow_up =base+'/webjars/lp-webjars/image/ghfl/arrow_up.png';
        var arrow_down =base+'/webjars/lp-webjars/image/ghfl/arrow_down.png';
        var html = '<div class="search">' +
            '<!--搜索框-->' +
            '<div class="searchKag">' +
            '<input type="text" id="key" name="key" placeholder="请输入关键字" autocomplete="off" class="layui-input-bd">' +
            '</div>' +
            '<div class="searchBtn">' +
            '<!--上下按钮-->' +
            '<div class="clickUD">' +
            '<div id="clickUp" class="clickBtn">' +
            '<img src='+arrow_up+'>' +
            '</div>' +
            '<div id="clickDown" class="clickBtn">' +
            '<img src='+arrow_down+'>' +
            '</div>' +
            '</div>' +
            '<div class="clickLabel">' +
            '<label id="number"></label>' +
            '</div>' +
            '</div>' +
            '</div>' +
            '<!--搜索按钮-->' +
            '<div id="searchBtn" class="iconfont icon-search searchIcon"></div>';

        return html;
    }

    var SearchBar = new SearchBar();

    exports('searchbar', SearchBar);
});