/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/6/11/14:25  Copyright gtmap Corp
 */

define([
       'easyMap/main',
        'easyMap/core/DrawGeometry',
    'mustache',
    'easyMap/tp/clipboard/clipboard',
    'popup',
    'easyMap/tp/jsonEditor/jsoneditor',
    'css!easyMap/tp/jsonEditor/jsoneditor.css'
    ],
    function (
        main,
        DrawGeo,
        Mustache,
        clipboardJs,
        Pop,
        jsonEditor
    ) {
    var instance,
        me,
        $that = me = {
            // init fun
            init: function () {
                $that.initMeasure();
                window.copyBoard = clipboardJs;
                $that.clipboard = new copyBoard('.copy-latlng', {
                    text: function() {
                        return $that.copyTemp;
                    }
                });
                $that.clipboard.on('success', function(e) {
                    Pop.msg({type:"success",message:"成功复制坐标点"});
                });
                $(".measure-image").each(function (i,v) {
                    var $this = $(v);
                    var name = $this.attr("name");
                    $this.attr("src",base+"/webjars/lp-webjars/js/easyMap/assets/images/"+name+".png");
                })
            },
            // open event
            onOpen: function () {

            },
            // close event
            onClose: function () {
                $that.leave();
            },

            // pause event
            onPause: function () {
                $that.leave();
            },

            $map: main.map.get$Map(),

            // 测距单位
            measureLength: [],

            // 测面单位
            measurePolygon: [],

            // 是否在绘制过程中进行计算
            measureAtOnce: false,

            // 选中单位
            utils: "",

            // layui
            measureForm: "",

            // 选择框
            getRadio: '<input type="radio" class="measure-check" name="measureRadio" {{check}} value="{{unit}}" title={{unit}} lay-filter={{unit}}>',

            // 拾取点坐标
            marker: false,

            // 测距
            length: false,

            // 测面
            area: false,

            // 绘线数据的featureCollection格式
            featureCollection:"",

            // jsonEditor
            editor: "",

            copyTemp:"",

            // 初始化测面功能
            initMeasure: function () {
                // 初始化layui
                layui.use('form', function () {
                    $that.measureForm = layui.form;
                });

                // 展示featureCollection
                var container = document.getElementById("measureShowCollection");


                var options = {
                    navigationBar: false,
                    mainMenuBar: false,
                    mode: 'view'
                };

                $that.editor = new jsonEditor(container, options);
                $that.editor.set("请绘制图形");
                $that.initConfig();

                // 测距点击事件
                $(".icon-line").click(function () {
                    $("body").find(".measure-icon-change").removeClass("measure-icon-point");
                    $(this).addClass("measure-icon-point");
                    $(".measure-radio").html($that.getHtml($that.measureLength));
                    $that.$map.off('click', $that.mouseClick);
                    $that.measureForm.render();
                    $that.measureJudge();
                    $that.clickMeasureLine();
                    $(".measure-unit").removeClass("measure-hide");
                });

                // 测面点击事件
                $(".icon-polygon").click(function () {
                    $("body").find(".measure-icon-change").removeClass("measure-icon-point");
                    $(this).addClass("measure-icon-point");
                    $(".measure-radio").html($that.getHtml($that.measurePolygon));
                    $that.$map.off('click', $that.mouseClick);
                    $that.measureForm.render();
                    $that.measureJudge();
                    $that.clickMeasurePolygon();
                    $(".measure-unit").removeClass("measure-hide");
                });

                // 坐标点拾取事件
                $(".icon-mark").click(function () {
                    $("body").find(".measure-icon-change").removeClass("measure-icon-point");
                    $(this).addClass("measure-icon-point");
                    $that.clickMeasurePolygon();
                    if ($that.marker === false) {
                        $that.marker = true;
                        $that.length = false;
                        $that.area = false;
                        $that.clearMarker();
                        $(".measure-unit").addClass("measure-hide");
                    }
                    $that.$map.on('mousemove', $that.mouseCoords);
                    $that.$map.on('click', $that.mouseClick);
                    DrawGeo.draw({
                        type: 'point',
                        measureType: 'measurePoint'
                    },main.map.get$Map(),main.appConfig.interface.geometryService);
                });

                //坐标删除
                $(".icon-remove").click(function () {
                    $that.leave();
                })
            },

            // 初始化配置
            initConfig: function () {
                //读取配置文件中的单位,并初始化测量线的单位下拉框,并选中第一个长度单位
                this.config.measureLength.forEach(function (unit) {
                    $that.measureLength.push(unit);
                });
                this.config.measurePolygon.forEach(function (unit) {
                    $that.measurePolygon.push(unit);
                });
                //读取配置文件中的实时计算
                if(this.config.measureAtOnce) {
                    $that.measureAtOnce = this.config.measureAtOnce;
                }
            },

            // 拼接页面
            getHtml: function (data) {
                var html = "";
                var check = "";
                for (var i = 0; i < data.length; i++) {
                    if (i === 0) {
                        check = "checked";
                        $that.unit = data[i];
                    }
                    else {
                        check = "";
                    }
                    html += Mustache.render(me.getRadio, {unit: data[i], check: check});
                }
                return html;
            },

            // 拾取坐标点点击方法
            mouseClick: function (e) {
                $that.copyTemp = "";
                $that.copyTemp = e.latlng.lng.toFixed(6)+ ',' + e.latlng.lat.toFixed(6);
                $("#pointLatLng").text($that.copyTemp);
                layui.use('table', function(){
                    var table = layui.table;
                    table.init('measure-mark', { //转化静态表格
                        height: '55'
                    });
                });
                $(".measure-result").css("display", "block");
            },

            // 判断进行哪种测量
            measureJudge: function () {
                $that.measureLength.forEach(function (e) {
                    var key = "radio(" + e + ")";
                    $that.measureForm.on(key, function (data) {
                        if (data.elem.checked === true) {
                            $that.unit = e;
                            $that.clickMeasureLine();
                        }
                    });
                });

                $that.measurePolygon.forEach(function (e) {
                    var key = "radio(" + e + ")";
                    $that.measureForm.on(key, function (data) {
                        if (data.elem.checked === true) {
                            $that.unit = e;
                            $that.clickMeasurePolygon();
                        }
                    });
                });

            },

            // 测距方法
            clickMeasureLine: function () {
                if ($that.length === false) {
                    $that.length = true;
                    $that.area = false;
                    $that.marker = false;
                    $that.featureCollection = "";
                    $that.clearMarker();
                    $that.displayMarker();
                }
                DrawGeo.draw({
                    type: 'line',
                    measureType: 'measureLength',
                    measureUnit: $that.unit,
                    measureAtOnce: $that.measureAtOnce,
                    fun: $that.getGeo
                },main.map.get$Map(),main.appConfig.interface.geometryService);
            },

            // 获取图形数据，并以featureCollection格式展示
            getGeo: function (feature) {
                var rings = "";
                var type = "";

                if(feature._rings) {
                    rings = feature._latlngs[0];
                    type = 'Polygon';
                }else{
                    rings = feature._latlngs;
                    type = 'LineString';
                }
                if($that.featureCollection === ""){
                    var geoFeature = [{
                        type: 'Feature',
                        properties: {},
                        geometry: {
                            type: '',
                            coordinates: []
                        }
                    }];
                    geoFeature[0].geometry.type = type;
                    var coord;
                    if(type === 'LineString'){
                        coord = geoFeature[0].geometry.coordinates = [];
                    }else{
                        coord = geoFeature[0].geometry.coordinates[0] = [];
                    }
                    $.each(rings, function (index, value) {
                        coord.push([value.lng, value.lat]);
                        if(rings.length - 1 === index && type === 'Polygon'){
                            coord.push([rings[0].lng, rings[0].lat]);
                        }
                    });
                    $that.featureCollection = {
                        features: geoFeature,
                        type: 'FeatureCollection'
                    };
                }else{
                    var geoFeature = {
                        type: 'Feature',
                        properties: {},
                        geometry: {
                            type: '',
                            properties: {},
                            coordinates: []
                        }
                    };
                    geoFeature.geometry.type = type;
                    var coord;
                    if(type === 'LineString'){
                        coord = geoFeature.geometry.coordinates = [];
                    }else{
                        coord = geoFeature.geometry.coordinates[0] = [];
                    }
                    $.each(rings, function (index, value) {
                        coord.push([value.lng, value.lat]);
                        if(rings.length - 1 === index && type === 'Polygon'){
                            coord.push([rings[0].lng, rings[0].lat]);
                        }
                    });
                    $that.featureCollection.features.push(geoFeature);
                }
                // WidgetUtils.loadScrollBar2("#measureShowCollection",100);
                $that.editor.set($that.featureCollection);
            },

            // 标记关闭监听
            clearMarker: function () {
                $that.$map.off('mousemove', $that.mouseCoords);
                $that.$map.off('click', $that.mouseClick);
                DrawGeo.close();
            },

            // 鼠标移动坐标
            mouseCoords: function (e) {
                $("#mouseLat").text(e.latlng.lat.toFixed(6));
                $("#mouseLng").text(e.latlng.lng.toFixed(6));
            },

            // 隐藏标记结果界面
            displayMarker: function () {
                $(".measure-unit").addClass("measure-hide");
                $(".measure-result").css("display", "none");
            },

            // 测面方法
            clickMeasurePolygon: function () {
                if ($that.area === false) {
                    $that.area = true;
                    $that.length = false;
                    $that.marker = false;
                    $that.featureCollection = "";
                    $that.clearMarker();
                    $that.displayMarker();
                }
                DrawGeo.draw({
                    type: 'polygon',
                    measureType: 'measureArea',
                    measureUnit: $that.unit,
                    measureAtOnce: $that.measureAtOnce,
                    fun: $that.getGeo
                },main.map.get$Map(),main.appConfig.interface.geometryService);
            },

            // 离开方法
            leave: function () {
                // 绘线绘面不清除图形
                if($(".measure-icon-change").hasClass('measure-icon-point')) {
                    DrawGeo.close();
                    $that.clearResult();
                    $that.clearMarker()
                    $("#mouseMovePop").empty();
                    $that.editor.set("请绘制图形");
                }
            },

            // 清除结果
            clearResult: function () {
                $(".measure-unit").addClass("measure-hide");
                $(".measure-result").css("display", "none");
                $("body").find(".measure-icon-change").removeClass("measure-icon-point");
            }
        };

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});
