/**
 *
 *  图层控制
 * @author Liu Shanshan
 * @version v1.0 2019/6/10
 */
define([
    'popup',
    'easyMap/main',
    'slider',
    'dragSort',
    'jQueryXDomainRequest',
    'css! tp/ztree/css/zTreeBlue.css',
    'ztree'
], function (
    Popup,
    MainMap
) {
    var instance,
        me = {
            name: 'layerList',

            showLegend: true,

            // init fun
            init: function () {
                $map = MainMap.map.get$Map();
                openLayerList();
            },
            // open event
            onOpen: function () {
                openLayerList();
            },
            // close event
            onClose: function () {
                // closeLayerList();
            }

        };


    var $map = undefined;
    var layersOptions = []; //所有图层属性
    var layersAll = []; //所有图层
    var allLyrMinZoom = [];

    //读取是否显示图例的配置
    // var _appConfig = WidgetUtils.appConfig;
    // if (_appConfig.hasOwnProperty('showLegend')) {
    //     me.showLegend = _appConfig.showLegend;
    // }

    var form;
    layui.use('form', function () {
        form = layui.form;
    });

    /**
     * 开启或关闭图层控制
     */
    function openLayerList1() {
        // $(".layerlist-widget").css('height', $('.map-widget-pane').height() * 0.99 - 40);
        //BaseWidget.loadScrollBar(".layerDataList");
        var headHeight, tittleHeight = $(".widget-head-label").height();
        if ($('.map-header').css("display") === 'none') {
            headHeight = 0;
        } else {
            headHeight = $('.map-header').outerHeight();
        }
        var resultPaneHeight = $(window).height() - headHeight - tittleHeight - $(".execute-select").height() - 10;
        WidgetUtils.loadScrollBar2(".layerDataList", resultPaneHeight);
        // 监听事件，如果进入规划实施初始化，改变面板高度
        $("#execute-label").on('click', function () {
            var tempHeight = resultPaneHeight - $(".execute-select").height() - 10;
            $(".layerDataList").height(tempHeight);
            WidgetUtils.loadScrollBar2('.layerDataList', tempHeight);
        });
        $("#home-label").on('click', function () {
            $(".layerDataList").height(resultPaneHeight);
            WidgetUtils.loadScrollBar2('.layerDataList', resultPaneHeight);
        });
        $(".layerDataList .os-content").height('99%');
        refreshLayers();
        document.onselectstart = function () {
            return false;
        };
    }

    function openLayerList() {
        refreshLayers();
        document.onselectstart = function () {
            return false;
        };
    }

    /**
     * 关闭图层控制
     */
    function closeLayerList() {
        console.log("关闭" + me.name);
        $map.off('zoomend', changeItemCss);
        document.onselectstart = function () {
            return true;
        };
    }

    /**
     * 获取当前全部图层和图层的信息
     */
    function refreshLayers() {
        var allLayers = [];
        //遍历地图图层
        layersAll = MainMap.map.getAllLayers();
        layersAll.forEach(function (lyr) {
            var lyrType = lyr.options.type;
            switch (lyrType) {
                case 'ags_test':
                    lyr.options.visible = true;
                    break;
                case 'ags_tile':
                    if (lyr.options.opacity > 0) {
                        lyr.options.visible = true;
                    }
                    break;
                case 'ags_vector_tile':
                    lyr.options.visible = true;
            }
        });

        //关联层不显示
        // layersOptions.forEach(function (option, index) {
        //    if(option != undefined && option.zIndex == 2) {
        //        layersOptions.splice(index,1);
        //    }
        // });

        var lyrsOptions = [];
        layersAll.forEach(function (lyr) {
            lyrsOptions.push(lyr.options);
        });
        lyrsOptions.reverse();
        layersOptions = unique(lyrsOptions);
        addLayersLabel(layersOptions);

        var zId = layersAll.length;
    }

    /**
     * 展示图层信息
     * @param options
     */
    function addLayersLabel(options) {
        $('#layer_dataList').off('mousedown.DDSort touchstart.DDSort mousemove.DDSort touchmove.DDSort mouseup.DDSort touchend.DDSort');
        $('#layer_dataList').empty();
        allLyrMinZoom = [];
        var zoom = $map.getZoom();

        options.forEach(function (option, opIndex) {
            var layerLebelDiv = '<div id="layerLabel' + opIndex + '" class="layer-legend-pane" data-lyrid=' + option.id + '></div>';
            $('#layer_dataList').append(layerLebelDiv);
            var layersListHtml = '';

            if (option.hasOwnProperty('alias')) {
                layersListHtml += '<div class="list-pane"><div class="list-pane-item pane-item-name"><div class="list-pane-layer"><span class="icon-f-right fold" data-id="' +
                    opIndex + '" title="点击显示图例"></span></div><div class="list-pane-layer"><span class="layer-label-name" title="' +
                    option.alias + '">' +
                    option.alias + '</span></div></div><div id="layer-slider' +
                    opIndex +
                    '" class="layer-slider list-pane-item"></div>' +
                    // '<div class="up-to-top icon-f-fold" title="图层置顶"></div>' +
                    '<div class="close-layer icon-f-close" title="删除图层"></div></div><div id="lyrList' + option.id + '" class="layui-form list-legend ztree"></div>';
            } else if (option.hasOwnProperty('label')) {
                layersListHtml += '<div class="list-pane"><div class="list-pane-item pane-item-name"><div class="list-pane-layer"><span class="icon-f-right fold" data-id="' +
                    opIndex + '" title="点击显示图例"></span></div><div class="list-pane-layer"><span class="layer-label-name" title="' +
                    option.label + '">' +
                    option.label + '</span></div></div><div id="layer-slider' +
                    opIndex +
                    '" class="layer-slider list-pane-item"></div>' +
                    // '<div class="up-to-top icon-f-fold" title="图层置顶"></div>' +
                    '<div class="close-layer icon-f-close" title="删除图层"></div></div><div id="lyrList' + option.id + '" class="layui-form list-legend ztree"></div>';
            } else if (option.hasOwnProperty('title')) {
                layersListHtml += '<div class="list-pane"><div class="list-pane-item pane-item-name"><div class="list-pane-layer"><span class="icon-f-right fold" data-id="' +
                    opIndex + '" title="点击显示图例"></span></div><div class="list-pane-layer"><span class="layer-label-name" title="' +
                    option.title + '">' +
                    option.title + '</span></div></div><div id="layer-slider' +
                    opIndex +
                    '" class="layer-slider list-pane-item"></div>' +
                    // '<div class="up-to-top icon-f-fold" title="图层置顶"></div>' +
                    '<div class="close-layer icon-f-close" title="删除图层"></div></div><div id="lyrList' + option.id + '" class="layui-form list-legend ztree"></div>';
            }
            $('#layerLabel' + opIndex).html(layersListHtml);

            //构建滑块
            var slider = sliderChange(option, opIndex);

            //服务只有在可视层级内可以滑动调整透明度
            if (option.hasOwnProperty('minZoomRecord')) {
                allLyrMinZoom.push({lyrid: option.id, minZoomRecord: option.minZoomRecord, slider: slider});
                if (option.minZoomRecord > zoom) {
                    //禁用滑块
                    slider.data.settings.active = false;
                    var lyrItemDom = $('.layerDataList [data-lyrid=' + option.id + ']');
                    // lyrItemDom.css('color', 'grey');
                    // lyrItemDom.find('.layer-label-name').css('color', 'grey');
                    lyrItemDom.find('.jquery-completed').css('background-color', 'grey');
                    lyrItemDom.find('.jquery-jslider').css('border', '2px solid grey');
                }
            }
        });
        $map.on('zoomend', changeItemCss);
        if (me.showLegend === false){
            foldClick();
        } else {
            $(".layer-list .icon-f-right.fold").hide();
        }
        unToTop();
        deleteLayer();
        //拖拽排序
        $('#layer_dataList').DDSort({
            target: '.pane-item-name',		 // 触发点击事件的元素，
            moveTarget: '.layer-legend-pane',//要拖拽排序的元素
            delay: 100,                      // 延时处理，默认为 50 ms，防止手抖点击 A 链接无效
            floatStyle: {                    //拖拽浮动时样式
                'border': '1px solid #ccc',
                'background-color': '#fff'
            },
            up: function () {   //拖拽结束时出发
                var index = --$('.layer-legend-pane').length;
                var temp = [];
                //按拖拽后的元素相反顺序遍历
                while (index >= 0) {
                    var allLayers = MainMap.map.getAllLayers($map, []);
                    $.each(allLayers, function (i, lyr) {
                        if (lyr.options.id === $('.layer-legend-pane').eq(index).data('lyrid')) {
                            //根据便利顺序，修改图层层级，上面的图层zindex比下面的图层zindex大
                            lyr.bringToFront();
                            temp.push(lyr);
                        }
                        if (lyr.options.type === 'ags_tile' || lyr.options.type === 'sp_ags_tile') {
                            lyr.setZIndex(1);
                        }
                    });
                    --index;
                }
                // MapUtils.updateAllLayers(layersAll);
            }
        });
    }

    /**
     * 在服务可视层级内启用透明度滑块功能，可视层级外禁用透明度滑块功能
     * @param e
     */
    function changeItemCss(e) {
        var zoom = e.target.getZoom();
        $.each(allLyrMinZoom, function (i, value) {
            var lyrItemDom = $('.layerDataList [data-lyrid=' + value.lyrid + ']');
            if (value.minZoomRecord > zoom) {
                //禁用滑块
                value.slider.data.settings.active = false;
                // lyrItemDom.css('color', 'grey');
                // lyrItemDom.find('.layer-label-name').css('color', 'grey');
                lyrItemDom.find('.jquery-completed').css('background-color', 'grey');
                lyrItemDom.find('.jquery-jslider').css('border', '2px solid grey');
            } else {
                //启用滑块
                value.slider.data.settings.active = true;
                // lyrItemDom.css('color', 'black');
                // lyrItemDom.find('.layer-label-name').css('color', 'black');
                lyrItemDom.find('.jquery-completed').css('background-color', '#2a8aff');
                lyrItemDom.find('.jquery-jslider').css('border', '2px solid #2a8aff');
            }
        });
    }


    /**
     * 滑块功能
     * @param option
     * @param index
     */
    function sliderChange(option, index) {
        //构建滑块
        var slider = $.jSlider({
            renderTo: '#layer-slider' + index,  //滑块元素
            tipRenderTo: '.slider-tips',        //提示标签
            relativeElem: '#widgetsPopup',      //标签所在的元素
            initPosition: option.opacity,       //滑块初始位置（这里用图层透明度）
            size: {
                barWidth: 105,
                sliderWidth: 10
            },
            //显示标签
            showTip: true,
            //change事件
            onChanging: function (percentage, e) {
                $map.eachLayer(function (layer) {
                    // layer的option中存在相同
                    if (layer.hasOwnProperty('options') && layer.options.id == option.id) {
                        //设置图层透明度
                        layer.setOpacity(percentage);
                    }
                });
            }
        });

        return slider;
    }

    /**
     * 图层置顶
     */
    function unToTop() {
        $('.up-to-top').on('click', function () {
            var lyrId = $(this).parent().parent().data('lyrid');
            var item = $(this).parent().parent();
            $('#layer_dataList').prepend(item);
            $.each(layersAll, function (i, lyr) {
                if (lyr.options.id === lyrId) {
                    //图层置顶
                    lyr.bringToFront();
                    layersAll.splice(0, 0, lyr);
                    layersAll.splice(i + 1, 1);
                    MapUtils.updateAllLayers(layersAll);
                }
                if (lyr.options.type === 'ags_tile' || lyr.options.type === 'sp_ags_tile') {
                    lyr.setZIndex(1);
                }
            });
        });
    }

    /**
     * 删除图层
     */
    function deleteLayer() {
        $('.close-layer').on('click', function () {
            var lyrId = $(this).parent().parent().data('lyrid');
            var item = $(this).parent().parent();
            $.each(layersAll, function (i, lyr) {
                if (lyr.options.id === lyrId) {
                    var treeObj = $.fn.zTree.getZTreeObj("zymlTree");
                    var node = treeObj.getNodesByFilter(function (node) {
                        //有些服务的url和树子节点的value匹配不上
                        if (lyr.options.url.indexOf(node.value) !== -1) {
                            return node;
                        }
                        return null;
                    }, true);
                    if (node !== null && node.isChecked) {
                        //取消节点勾选，执行节点取消勾选时的方法
                        treeObj.checkNode(node, false, true, true);
                    }
                    //$map.removeLayer(lyr);
                    item.remove();
                }
            });
        });
    }

    /**
     * 图层图例面板展开与关闭
     */
    function foldClick() {
        $('.fold, .layer-label-name').off('click');
        $('.fold, .layer-label-name').on('click', function () {
            var that;
            if ($(this).hasClass('layer-label-name')) {
                that = $(this).parent().prev().children('.fold');
            } else {
                that = $(this);
            }
            var opId = that.data('id');
            if (that.parent().parent().parent().next().css('display') != 'none') {
                that.removeClass('icon-f-bottom');
                that.addClass('icon-f-right');
            } else {
                //获得对应图层的图例信息，并展示
                that.removeClass('icon-f-right');
                that.addClass('icon-f-bottom');
            }

            var legendListPane = that.parent().parent().parent().next();
            if (legendListPane.css('display') === 'none' && legendListPane.html() === '') {
                //获得对应图层的图例信息，并展示
                //openLengend(opId, legendListPane);
                openLegengTree(opId, legendListPane);
            }
            legendListPane.slideToggle();
        });
    }

    /**
     * 获得对应图层的图例信息，并展示
     * @param index
     * @param legendDom
     */
    /*function openLengend(index, legendDom) {
        legendDom.empty();
        var url = layersOptions[index].url;
        var type = layersOptions[index].type;
        //跨域问题
        $.support.cors = true;
        //获得包含图例信息的json文件
        $.ajax({
            url: url + '/legend',
            type: 'get',
            dataType: 'jsonp',
            data: {f: 'pjson'},
            success: function (data, status) {
                if (status == 'success') {
                    var legendHtml = '';
                    data.layers.forEach(function (item) {
                        legendHtml += '<div class="layer-label-legend"><span>' +
                            item.layerName + '</span>';
                        if (type === 'ags_rest' || type === 'ag_ags_rest' || type === 'sp_ags_rest') {
                            var options = layersOptions[index];
                            if (options.hasOwnProperty('hideLysr') && options.hideLysr.indexOf(item.layerId) !== -1) {
                                legendHtml += '<input type="checkbox" lay-filter = "switchLayer" class="checkbox-style" data-serId="' + index +
                                    '" data-lyrId="' + item.layerId + '" name="checkBox" lay-skin="primary" />';
                            } else {
                                legendHtml += '<input type="checkbox" lay-filter = "switchLayer" class="checkbox-style" data-serId="' + index +
                                    '" data-lyrId="' + item.layerId + '" checked name="checkBox" lay-skin="primary" />';
                            }
                        }
                        legendHtml += '</div>';
                        legendHtml += '<div class="layer-all-legends">';
                        item.legend.forEach(function (legend) {
                            var imgUrl = url + '//' + item.layerId + '/images/' + legend.url;
                            legendHtml += '<div>';
                            legendHtml += '<img src="' + imgUrl + '">';
                            legendHtml += '<span>&nbsp;&nbsp;' + legend.label + '</span>';
                            legendHtml += '</div>';
                        });
                        legendHtml += '</div>';
                    });
                    legendDom.html(legendHtml);

                    form.on('checkbox(switchLayer)', function (data) {
                        var layerId = Number($(this).attr('data-lyrId'));
                        var serviceId = Number($(this).attr('data-serId'));
                        var options = layersOptions[serviceId];
                        if (data.elem.checked === true) {
                            if (options.hasOwnProperty('hideLysr')) {
                                if (options.hideLysr.length > 0) {
                                    var lyrIndex = options.hideLysr.findIndex(function (value) {
                                        return value === layerId;
                                    });
                                    options.hideLysr.splice(lyrIndex, 1);
                                }
                            }
                        } else {
                            if (options.hasOwnProperty('hideLysr')) {
                                options.hideLysr.push(layerId);
                            } else {
                                options.hideLysr = [layerId];
                            }
                        }
                        layersAll.forEach(function (lyr) {
                            if (lyr.options.url === options.url) {
                                lyr.redraw();
                            }
                        });
                    });

                    form.render('checkbox');
                } else if (status == 'error') {
                    Popup.msg('请求数据失败，请联系管理员！');
                }
            }
        });

    }*/

    /**
     * 获得对应图层的图例信息，并树状结构展示
     * @param index
     * @param legendDom
     */
    function openLegengTree(index, legendDom) {
        legendDom.empty();
        var url = layersOptions[index].url;
        var type = layersOptions[index].type;

        //树的参数
        var setting = {
            check: {
                enable: true,
                autoCheckTrigger: false,
                chkPosition: 'before',
                nocheckInherit: false
            },
            view: {
                showLine: true,
                showTitle: true,
                selectedMulti: false,
                dblClickExpand: false,
                expandSpeed: "slow"
            },
            data: {
                key: {
                    checked: "isChecked",
                    name: "label",
                    title: "label"
                }
            },
            callback: {
                onClick: onClick,
                onCheck: onCheck
            }
        };

        //跨域问题
        $.support.cors = true;
        //获得服务图层信息的json文件
        $.ajax({
            url: url,
            type: 'get',
            dataType: 'jsonp',
            data: {f: 'pjson'},
            success: function (data, status) {
                if (status === 'success') {
                    //构建树
                    $.fn.zTree.init(legendDom, setting, manageTreeData(data.layers, index, type));
                    //将图层图例追加进树里
                    getAllLegend(url, legendDom);
                } else if (status === 'error') {
                    Popup.msg('请求数据失败，请联系管理员！');
                }
            }
        });
    }

    /**
     * 组织数据
     * @param data
     * @param serId  地图服务id
     * @param type  服务类型（动态、静态）
     */
    function manageTreeData(data, serId, type) {
        function toParse(data, parentLayerId) {
            var result = [], temp;
            var options = layersOptions[serId];
            for (var i = 0; i < data.length; i++) {
                if (data[i].parentLayerId === parentLayerId) {
                    var obj = {
                        "label": data[i].name,
                        "id": data[i].id,
                        "lyrId": data[i].id,
                        "serId": serId,
                        "open": true,
                        "children": []
                    };
                    //当服务为动态服务  且不是土地利用现状，节点才有checkbox
                    if (type === 'ags_rest' || type === 'ag_ags_rest' || type === 'sp_ags_rest') {
                        if (options.hasOwnProperty('tileUrl')) {
                            if (options.tileUrl.indexOf('TDLY') !== -1 || options.title.indexOf('土地利用现状') !== -1) {
                                obj.nocheck = true;
                            } else {
                                //图层隐藏时，checkbox不勾选
                                if (!options.hasOwnProperty('hideLysr') || options.hideLysr.indexOf(data[i].id) === -1) {
                                    obj.isChecked = true;
                                }
                            }
                        } else {
                            //图层不隐藏时，checkbox不勾选
                            if (!options.hasOwnProperty('hideLysr') || options.hideLysr.indexOf(data[i].id) === -1) {
                                obj.isChecked = true;
                            }
                        }
                    } else {
                        obj.nocheck = true;
                    }
                    temp = toParse(data, data[i].id);
                    if (temp.length > 0) {
                        obj.children = temp;
                    } else {
                        obj.isLast = true;
                    }
                    result.push(obj);
                }
            }
            return result;
        }

        return toParse(data, -1);
    }

    /**
     * 获取图例，追加进树中
     * @param serverUrl
     * @param legendDom
     */
    function getAllLegend(serverUrl, legendDom) {
        //跨域问题
        $.support.cors = true;
        //获得包含图例信息的json文件
        $.ajax({
            url: serverUrl + '/legend',
            type: 'get',
            dataType: 'jsonp',
            data: {f: 'pjson'},
            success: function (data, status) {
                var treeObj = $.fn.zTree.getZTreeObj(legendDom.attr("id"));
                var treeNodes = getAllNotParentNodes(treeObj);
                $.each(treeNodes, function (index, node) {
                    $.each(data.layers, function (i, layer) {
                        if (node.lyrId === layer.layerId) {
                            var legendData = [];
                            layer.legend.forEach(function (value) {
                                var legend = {
                                    id: value.id,
                                    label: value.label,
                                    nocheck: true,
                                    icon: serverUrl + '/' + layer.layerId + '/images/' + value.url
                                };
                                legendData.push(legend);
                            });
                            //追加进树节点
                            treeObj.addNodes(node, legendData, true);
                        }
                    });
                });
            }
        });
    }

    /**
     * 找到所有子节点
     * @param treeObj
     * @returns {Array}
     */
    function getAllNotParentNodes(treeObj) {
        var nodes = treeObj.transformToArray(treeObj.getNodes());
        var treeNode = [];
        $.each(nodes, function (index, node) {
            if (!node.children || node.children.length === 0) {
                treeNode.push(node);
            }
        });
        return treeNode;
    }

    /**
     * 节点点击展开
     * @param event
     * @param treeId
     * @param treeNode
     * @param clickFlag
     */
    function onClick(event, treeId, treeNode, clickFlag) {
        var expandChild = $.fn.zTree.getZTreeObj(treeId);
        expandChild.expandNode(treeNode, null, null, false);
    }

    /**
     * checkbox勾选事件
     * @param event
     * @param treeId
     * @param node
     */
    function onCheck(event, treeId, node) {
        node.getCheckStatus().checked ? checkNode(node, treeId) : uncheckNode(node, treeId);
    }

    /**
     * 勾选节点
     * @param node
     * @param treeId
     */
    function checkNode(node, treeId) {
        var treeObj = $.fn.zTree.getZTreeObj(treeId);
        var serviceId = Number(node.serId);
        var options = layersOptions[serviceId];
        //判断是否为子节点
        if (node.isLast) {
            //是则直接将图层id，从图层hideLysr的属性移除
            if (options.hasOwnProperty('hideLysr') && options.hideLysr.length > 0) {
                var lyrIndex = options.hideLysr.findIndex(function (value) {
                    return value === Number(node.lyrId);
                });
                if (lyrIndex !== -1) {
                    options.hideLysr.splice(lyrIndex, 1);
                }
            }
        } else {
            //当为父节点时获得其子节点，将所有子节点对应的图层id从hideLysr的属性里移除
            var temNodes = treeObj.transformToArray(node.children);
            var tempLyrs = [];
            temNodes.forEach(function (value) {
                if (value.isLast) {
                    tempLyrs.push(value.lyrId);
                }
            });
            var tempHideLyrs = [];
            if (options.hasOwnProperty('hideLysr') && options.hideLysr.length > 0) {
                options.hideLysr.forEach(function (value) {
                    if (tempLyrs.indexOf(value) === -1) {
                        tempHideLyrs.push(value);
                    }
                });
            }
            options.hideLysr = tempHideLyrs;
        }
        //刷新地图服务，展示勾选的图层
        refreshLayer(options);
    }

    /**
     * 取消勾选
     * @param node
     * @param treeId
     */
    function uncheckNode(node, treeId) {
        var treeObj = $.fn.zTree.getZTreeObj(treeId);
        var serviceId = Number(node.serId);
        var options = layersOptions[serviceId];
        //判断是否为子节点
        if (node.isLast) {
            //是则直接将图层id，追加进图层hideLysr的属性里
            if (options.hasOwnProperty('hideLysr')) {
                if (options.hideLysr.indexOf(node.lyrId) === -1) {
                    options.hideLysr.push(Number(node.lyrId));
                }
            } else {
                options.hideLysr = [Number(node.lyrId)];
            }
        } else {
            //当为父节点时获得其子节点，将所有子节点对应的图层id追加进hideLysr的属性里
            var temNodes = treeObj.transformToArray(node.children);
            temNodes.forEach(function (value) {
                if (value.isLast) {
                    if (options.hasOwnProperty('hideLysr')) {
                        if (options.hideLysr.indexOf(value.lyrId) === -1) {
                            options.hideLysr.push(Number(value.lyrId));
                        }
                    } else {
                        options.hideLysr = [Number(value.lyrId)];
                    }
                }
            });
        }
        //刷新地图服务，隐藏勾选的图层
        refreshLayer(options);
    }

    /**
     * 图层刷新
     * @param options
     */
    function refreshLayer(options) {
        layersAll.forEach(function (lyr) {
            if (lyr.options.url === options.url) {
                lyr.redraw();
            }
        });
    }

    /**
     * 去重
     * @param arr
     * @returns {Array}
     */
    function unique(arr) {
        var result = [];
        for (var i = 0; i < arr.length; i++) {
            //如果在结果数组result中没有找到arr[i]，则把arr[i]压入result中
            if (result.indexOf(arr[i]) == -1) {
                result.push(arr[i]);
            }
        }
        return result;
    }


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});