/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2019 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 6.0.0
 * @date    2019-06-12
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(window,function(){return n={},o.m=i=[function(e,t,i){"use strict";i(5);var o,n=["en","pt-BR","zh-CN","tr"],r={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",collapseAll:"Collapse all fields",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",examples:"Examples",default:"Default"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",collapseAll:"缩进所有字段",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",examples:"例子",default:"缺省"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",collapseAll:"Fechar todos campos",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",selectNode:"Select a node...",showAll:"mostre tudo",showMore:"mostre mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"Texto",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan"}},s="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0;o=(o=n.find(function(e){return e===s}))||"en",e.exports={_locales:n,_defs:r,_lang:o,setLanguage:function(t){if(t){var e=n.find(function(e){return e===t});e?o=e:console.error("Language not found")}},setLanguages:function(e){if(e)for(var t in e){n.find(function(e){return e===t})||n.push(t),r[t]=Object.assign({},r.en,r[t],e[t])}},translate:function(e,t,i){var n=r[i=i||o][e];if(t)for(e in t)n=n.replace("${"+e+"}",t[e]);return n||e}}},function(e,c,t){"use strict";t(5);var i=t(19),n=t(20),o=t(0).translate;c.parse=function(t){try{return JSON.parse(t)}catch(e){throw c.validate(t),e}},c.sanitize=function(i){var n=[],o=0,e=i.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);e&&(i=e[3]);var r={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};function s(){return i.charAt(o)}function t(){return i.charAt(o+1)}function a(e){return" "===e||"\n"===e||"\r"===e||"\t"===e}function l(){for(var e=n.length-1;0<=e;){var t=n[e];if(!a(t))return t;e--}return""}function c(){for(var e=o+1;e<i.length&&a(i[e]);)e++;return i[e]}function h(){for(o+=2;o<i.length&&("*"!==s()||"/"!==t());)o++;o+=2}function d(){for(o+=2;o<i.length&&"\n"!==s();)o++}function u(e){n.push('"'),o++;for(var t=s();o<i.length&&t!==e;)'"'===t&&"\\"!==i.charAt(o-1)?n.push('\\"'):r.hasOwnProperty(t)?n.push(r[t]):("\\"===t&&(o++,"'"!==(t=s())&&n.push("\\")),n.push(t)),o++,t=s();t===e&&(n.push('"'),o++)}function p(){for(var e="",t=s(),i=/[a-zA-Z_$\d]/;i.test(t);)e+=t,o++,t=s();-1===["null","true","false"].indexOf(e)?n.push('"'+e+'"'):n.push(e)}for(;o<i.length;){var f=s();"/"===f&&"*"===t()?h():"/"===f&&"/"===t()?d():" "===f||" "<=f&&f<=" "||" "===f||" "===f||"　"===f?(n.push(" "),o++):"'"===f?u("'"):'"'===f?u('"'):"`"===f?u("´"):"‘"===f?u("’"):"“"===f?u("”"):","===f&&-1!==["]","}"].indexOf(c())?o++:/[a-zA-Z_$]/.test(f)&&-1!==["{",","].indexOf(l())?p():(n.push(f),o++)}return n.join("")},c.escapeUnicodeChars=function(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})},c.validate=function(e){void 0!==i?i.parse(e):JSON.parse(e)},c.extend=function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},c.clear=function(e){for(var t in e)e.hasOwnProperty(t)&&delete e[t];return e},c.type=function(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp||"regexp"==typeof e?"regexp":c.isArray(e)?"array":"object"};var r=/^https?:\/\/\S+$/;c.isUrl=function(e){return("string"==typeof e||e instanceof String)&&r.test(e)},c.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)},c.getAbsoluteLeft=function(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0},c.getAbsoluteTop=function(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0},c.addClassName=function(e,t){var i=e.className.split(" ");-1==i.indexOf(t)&&(i.push(t),e.className=i.join(" "))},c.removeAllClassNames=function(e){e.className=""},c.removeClassName=function(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!=n&&(i.splice(n,1),e.className=i.join(" "))},c.stripFormatting=function(e){for(var t=e.childNodes,i=0,n=t.length;i<n;i++){var o=t[i];o.style&&o.removeAttribute("style");var r=o.attributes;if(r)for(var s=r.length-1;0<=s;s--){var a=r[s];!0===a.specified&&o.removeAttribute(a.name)}c.stripFormatting(o)}},c.setEndOfContentEditable=function(e){var t,i;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t))},c.selectContentEditable=function(e){var t,i;e&&"DIV"==e.nodeName&&window.getSelection&&document.createRange&&((i=document.createRange()).selectNodeContents(e),(t=window.getSelection()).removeAllRanges(),t.addRange(i))},c.getSelection=function(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null},c.setSelection=function(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}},c.getSelectionOffset=function(){var e=c.getSelection();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer==e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null},c.setSelectionOffset=function(e){if(document.createRange&&window.getSelection&&window.getSelection()){var t=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),c.setSelection(t)}},c.getInnerText=function(e,t){if(null==t&&(t={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return t.flush()+e.nodeValue;if(e.hasChildNodes()){for(var i=e.childNodes,n="",o=0,r=i.length;o<r;o++){var s=i[o];if("DIV"==s.nodeName||"P"==s.nodeName){var a=i[o-1],l=a?a.nodeName:void 0;l&&"DIV"!=l&&"P"!=l&&"BR"!=l&&(n+="\n",t.flush()),n+=c.getInnerText(s,t),t.set("\n")}else"BR"==s.nodeName?(n+=t.flush(),t.set("\n")):n+=c.getInnerText(s,t)}return n}return"P"==e.nodeName&&-1!=c.getInternetExplorerVersion()?t.flush():""},c.hasParentNode=function(e,t){for(var i=e?e.parentNode:void 0;i;){if(i===t)return!0;i=i.parentNode}return!1},c.getInternetExplorerVersion=function(){if(-1==s){var e=-1;if("undefined"!=typeof navigator&&"Microsoft Internet Explorer"==navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})").exec(t)&&(e=parseFloat(RegExp.$1))}s=e}return s},c.isFirefox=function(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")};var s=-1;c.addEventListener=function(e,t,i,n){if(e.addEventListener)return void 0===n&&(n=!1),"mousewheel"===t&&c.isFirefox()&&(t="DOMMouseScroll"),e.addEventListener(t,i,n),i;if(e.attachEvent){var o=function(){return i.call(e,window.event)};return e.attachEvent("on"+t,o),o}},c.removeEventListener=function(e,t,i,n){e.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===t&&c.isFirefox()&&(t="DOMMouseScroll"),e.removeEventListener(t,i,n)):e.detachEvent&&e.detachEvent("on"+t,i)},c.isChildOf=function(e,t){for(var i=e.parentNode;i;){if(i===t)return!0;i=i.parentNode}return!1},c.parsePath=function(i){var e=[],n=0;function t(){for(var e="";void 0!==i[n]&&/[\w$]/.test(i[n]);)e+=i[n],n++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+n);return e}function o(e){for(var t="";void 0!==i[n]&&i[n]!==e;)t+=i[n],n++;if(i[n]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==i[n];)if("."===i[n])n++,e.push(t());else{if("["!==i[n])throw new Error('Invalid JSON path: unexpected character "'+i[n]+'" at index '+n);if("'"===i[++n]||'"'===i[n]){var r=i[n];if(n++,e.push(o(r)),i[n]!==r)throw new Error("Invalid JSON path: closing quote ' expected at index "+n);n++}else{var s=o("]").trim();if(0===s.length)throw new Error("Invalid JSON path: array value expected at index "+n);s="*"===s?s:JSON.parse(s),e.push(s)}if("]"!==i[n])throw new Error("Invalid JSON path: closing bracket ] expected at index "+n);n++}return e},c.stringifyPath=function(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")},c.improveSchemaError=function(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(5<(t=t.map(function(e){return JSON.stringify(e)})).length){var i=["("+(t.length-5)+" more...)"];(t=t.slice(0,5)).push(i)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e},c.isPromise=function(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch},c.isValidValidationError=function(e){return"object"==typeof e&&Array.isArray(e.path)&&"string"==typeof e.message},c.insideRect=function(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom},c.debounce=function(n,o,r){var s;return function(){var e=this,t=arguments,i=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||n.apply(e,t)},o),i&&n.apply(e,t)}},c.textDiff=function(e,t){for(var i=t.length,n=0,o=e.length,r=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(r-1)===e.charAt(o-1)&&n<r&&0<o;)r--,o--;return{start:n,end:r}},c.getInputSelection=function(i){var e,t,n,o,r,s=0,a=0;return"number"==typeof i.selectionStart&&"number"==typeof i.selectionEnd?(s=i.selectionStart,a=i.selectionEnd):(t=document.selection.createRange())&&t.parentElement()==i&&(o=i.value.length,e=i.value.replace(/\r\n/g,"\n"),(n=i.createTextRange()).moveToBookmark(t.getBookmark()),(r=i.createTextRange()).collapse(!1),-1<n.compareEndPoints("StartToEnd",r)?s=a=o:(s=-n.moveStart("character",-o),s+=e.slice(0,s).split("\n").length-1,-1<n.compareEndPoints("EndToEnd",r)?a=o:(a=-n.moveEnd("character",-o),a+=e.slice(0,a).split("\n").length-1))),{startIndex:s,endIndex:a,start:l(s),end:l(a)};function l(e){var t=i.value.substring(0,e);return{row:(t.match(/\n/g)||[]).length+1,column:t.length-t.lastIndexOf("\n")}}},c.getIndexForPosition=function(e,t,i){var n=e.value||"";if(0<t&&0<i){var o=n.split("\n",t);t=Math.min(o.length,t),i=Math.min(o[t-1].length,i-1);var r=1==t?i:i+1;return o.slice(0,t-1).join("\n").length+r}return-1},c.getPositionForPath=function(e,t){var o,r=this,s=[];if(!t||!t.length)return s;try{o=n.parse(e)}catch(e){return s}return t.forEach(function(e){var t=r.parsePath(e),i=t.length?"/"+t.join("/"):"",n=o.pointers[i];n&&s.push({path:e,line:n.key?n.key.line:n.value?n.value.line:0,column:n.key?n.key.column:n.value?n.value.column:0})}),s},c.getColorCSS=function(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null},c.isValidColor=function(e){return!!c.getColorCSS(e)},c.makeFieldTooltip=function(i,e){if(!i)return"";var n="";return i.title&&(n+=i.title),i.description&&(0<n.length&&(n+="\n"),n+=i.description),i.default&&(0<n.length&&(n+="\n\n"),n+=o("default",void 0,e)+"\n",n+=JSON.stringify(i.default,null,2)),Array.isArray(i.examples)&&0<i.examples.length&&(0<n.length&&(n+="\n\n"),n+=o("examples",void 0,e)+"\n",i.examples.forEach(function(e,t){n+=JSON.stringify(e,null,2),t!==i.examples.length-1&&(n+="\n")})),n},c.get=function(e,t){for(var i=e,n=0;n<t.length&&null!=i;n++)i=i[t[n]];return i},c.findUniqueName=function(e,t){for(var i=e.replace(/ \(copy( \d+)?\)$/,""),n=i,o=1;-1!==t.indexOf(n);){n=i+" ("+("copy"+(1<o?" "+o:""))+")",o++}return n}},function(e,t,i){"use strict";var d=i(6).createAbsoluteAnchor,u=i(1),g=i(0).translate;function p(i,e){this.dom={};var m=this,t=this.dom;this.anchor=void 0,this.items=i,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0;var n=document.createElement("div");n.className="jsoneditor-contextmenu-root",t.root=n;var o=document.createElement("div");o.className="jsoneditor-contextmenu",t.menu=o,n.appendChild(o);var r=document.createElement("ul");r.className="jsoneditor-menu",o.appendChild(r),t.list=r,t.items=[];var s=document.createElement("button");s.type="button",t.focusButton=s;var a=document.createElement("li");a.style.overflow="hidden",a.style.height="0",a.appendChild(s),r.appendChild(a),function u(p,f,e){e.forEach(function(t){if("separator"==t.type){var e=document.createElement("div");e.className="jsoneditor-separator",(n=document.createElement("li")).appendChild(e),p.appendChild(n)}else{var i={},n=document.createElement("li");p.appendChild(n);var o=document.createElement("button");if(o.type="button",o.className=t.className,i.button=o,t.title&&(o.title=t.title),t.click&&(o.onclick=function(e){e.preventDefault(),m.hide(),t.click()}),n.appendChild(o),t.submenu){var r=document.createElement("div");r.className="jsoneditor-icon",o.appendChild(r);var s,a=document.createElement("div");if(a.className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),a.appendChild(document.createTextNode(t.text)),o.appendChild(a),t.click){o.className+=" jsoneditor-default";var l=document.createElement("button");l.type="button",(i.buttonExpand=l).className="jsoneditor-expand",l.innerHTML='<div class="jsoneditor-expand"></div>',n.appendChild(l),t.submenuTitle&&(l.title=t.submenuTitle),s=l}else{var c=document.createElement("div");c.className="jsoneditor-expand",o.appendChild(c),s=o}s.onclick=function(e){e.preventDefault(),m._onExpandItem(i),s.focus()};var h=[];i.subItems=h;var d=document.createElement("ul");(i.ul=d).className="jsoneditor-menu",d.style.height="0",n.appendChild(d),u(d,h,t.submenu)}else o.innerHTML='<div class="jsoneditor-icon"></div><div class="jsoneditor-text">'+g(t.text)+"</div>";f.push(i)}})}(r,this.dom.items,i),this.maxHeight=0,i.forEach(function(e){var t=24*(i.length+(e.submenu?e.submenu.length:0));m.maxHeight=Math.max(m.maxHeight,t)})}p.prototype._getVisibleButtons=function(){var t=[],i=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e==i.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t},p.visibleMenu=void 0,p.prototype.show=function(e,t,i){this.hide();var n=!0,o=e.parentNode,r=e.getBoundingClientRect(),s=o.getBoundingClientRect(),a=t.getBoundingClientRect(),l=this;this.dom.absoluteAnchor=d(e,t,function(){l.hide()}),r.bottom+this.maxHeight<a.bottom||r.top-this.maxHeight>a.top&&(n=!1);var c=i?0:r.top-s.top;if(n){var h=e.offsetHeight;this.dom.menu.style.left="0",this.dom.menu.style.top=c+h+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px";this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=u.getSelection(),this.anchor=e,setTimeout(function(){l.dom.focusButton.focus()},0),p.visibleMenu&&p.visibleMenu.hide(),p.visibleMenu=this},p.prototype.hide=function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),p.visibleMenu==this&&(p.visibleMenu=void 0)},p.prototype._onExpandItem=function(i){var n=this,e=i==this.expandedItem,t=this.expandedItem;if(t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){n.expandedItem!=t&&(t.ul.style.display="",u.removeClassName(t.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!e){var o=i.ul;o.style.display="block";o.clientHeight;setTimeout(function(){if(n.expandedItem==i){for(var e=0,t=0;t<o.childNodes.length;t++)e+=o.childNodes[t].clientHeight;o.style.height=e+"px",o.style.padding="5px 10px"}},0),u.addClassName(o.parentNode,"jsoneditor-selected"),this.expandedItem=i}},p.prototype._onKeyDown=function(e){var t,i,n,o,r=e.target,s=e.which,a=!1;27==s?(this.selection&&u.setSelection(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9==s?e.shiftKey?0==(i=(t=this._getVisibleButtons()).indexOf(r))&&(t[t.length-1].focus(),a=!0):(i=(t=this._getVisibleButtons()).indexOf(r))==t.length-1&&(t[0].focus(),a=!0):37==s?("jsoneditor-expand"==r.className&&(i=(t=this._getVisibleButtons()).indexOf(r),(n=t[i-1])&&n.focus()),a=!0):38==s?(i=(t=this._getVisibleButtons()).indexOf(r),(n=t[i-1])&&"jsoneditor-expand"==n.className&&(n=t[i-2]),(n=n||t[t.length-1])&&n.focus(),a=!0):39==s?(i=(t=this._getVisibleButtons()).indexOf(r),(o=t[i+1])&&"jsoneditor-expand"==o.className&&o.focus(),a=!0):40==s&&(i=(t=this._getVisibleButtons()).indexOf(r),(o=t[i+1])&&"jsoneditor-expand"==o.className&&(o=t[i+2]),(o=o||t[0])&&(o.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())},e.exports=p},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(!function(){var e=new Error("Cannot find module 'brace'");throw e.code="MODULE_NOT_FOUND",e}()),i(13),i(15)}catch(e){}e.exports=n},function(e,t,i){var n;if(window.Picker)n=window.Picker;else try{n=i(!function(){var e=new Error("Cannot find module 'vanilla-picker'");throw e.code="MODULE_NOT_FOUND",e}())}catch(e){}e.exports=n},function(e,t){function i(e){e.hasOwnProperty("remove")||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){null!=this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&("undefined"!=typeof Element&&i(Element.prototype),"undefined"!=typeof CharacterData&&i(CharacterData.prototype),"undefined"!=typeof DocumentType&&i(DocumentType.prototype)),String.prototype.startsWith||(String.prototype.startsWith=function(e,t){return t=t||0,this.substr(t,e.length)===e}),Array.prototype.find||(Array.prototype.find=function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return i}}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},function(e,t,i){var h=i(1);t.createAbsoluteAnchor=function(i,e,n){var o=function(e){return"function"==typeof e.getRootNode?e.getRootNode():window}(i),r={},t=i.getBoundingClientRect(),s=e.getBoundingClientRect(),a=document.createElement("div");function l(){if(a&&a.parentNode){for(var e in a.parentNode.removeChild(a),r)if(r.hasOwnProperty(e)){var t=r[e];t&&h.removeEventListener(o,e,t),delete r[e]}"function"==typeof n&&n(i)}}a.className="jsoneditor-anchor",a.style.position="absolute",a.style.left=t.left-s.left+"px",a.style.top=t.top-s.top+"px",a.style.width=t.width-2+"px",a.style.height=t.height-2+"px",a.style.boxSizing="border-box",e.appendChild(a);function c(e){var t=e.target;t===a||h.isChildOf(t,a)||l()}return r.mousedown=h.addEventListener(o,"mousedown",c),r.mousewheel=h.addEventListener(o,"mousewheel",c),a.destroy=l,a}},function(e,t,i){!function(e){"use strict";function T(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function k(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function j(e,t){if(e===t)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===T(e)){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!1===j(e[i],t[i]))return!1;return!0}if(!0!==k(e))return!1;var n={};for(var o in e)if(hasOwnProperty.call(e,o)){if(!1===j(e[o],t[o]))return!1;n[o]=!0}for(var r in t)if(hasOwnProperty.call(t,r)&&!0!==n[r])return!1;return!0}function O(e){if(""===e||!1===e||null===e)return!0;if(T(e)&&0===e.length)return!0;if(k(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var s;s="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]};var c=0,r=1,h=2,a=3,t=4,i=6,l=8,d=9,u="UnquotedIdentifier",p="QuotedIdentifier",f="Rbracket",m="Rparen",g="Comma",v="Colon",y="Rbrace",b="Number",I="Current",P="Expref",A="Pipe",D="GTE",R="LTE",L="Flatten",x="Star",w="Filter",_="Dot",C="Lbrace",E="Lbracket",S="Lparen",N="Literal",M={".":_,"*":x,",":g,":":v,"{":C,"}":y,"]":f,"(":S,")":m,"@":I},F={"<":!0,">":!0,"=":!0,"!":!0},B={" ":!0,"\t":!0,"\n":!0};function V(e){return"0"<=e&&e<="9"||"-"===e}function n(){}n.prototype={tokenize:function(e){var t,i,n,o,r=[];for(this._current=0;this._current<e.length;)if("a"<=(o=e[this._current])&&o<="z"||"A"<=o&&o<="Z"||"_"===o)t=this._current,i=this._consumeUnquotedIdentifier(e),r.push({type:u,value:i,start:t});else if(void 0!==M[e[this._current]])r.push({type:M[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(V(e[this._current]))n=this._consumeNumber(e),r.push(n);else if("["===e[this._current])n=this._consumeLBracket(e),r.push(n);else if('"'===e[this._current])t=this._current,i=this._consumeQuotedIdentifier(e),r.push({type:p,value:i,start:t});else if("'"===e[this._current])t=this._current,i=this._consumeRawStringLiteral(e),r.push({type:N,value:i,start:t});else if("`"===e[this._current]){t=this._current;var s=this._consumeLiteral(e);r.push({type:N,value:s,start:t})}else if(void 0!==F[e[this._current]])r.push(this._consumeOperator(e));else if(void 0!==B[e[this._current]])this._current++;else if("&"===e[this._current])t=this._current,this._current++,"&"===e[this._current]?(this._current++,r.push({type:"And",value:"&&",start:t})):r.push({type:P,value:"&",start:t});else{if("|"!==e[this._current]){var a=new Error("Unknown character:"+e[this._current]);throw a.name="LexerError",a}t=this._current,this._current++,"|"===e[this._current]?(this._current++,r.push({type:"Or",value:"||",start:t})):r.push({type:A,value:"|",start:t})}return r},_consumeUnquotedIdentifier:function(e){var t,i=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(i,this._current)},_consumeQuotedIdentifier:function(e){var t=this._current;this._current++;for(var i=e.length;'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){var t=this._current;this._current++;for(var i=e.length;"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){var t=this._current;this._current++;for(var i=e.length;V(e[this._current])&&this._current<i;)this._current++;var n=parseInt(e.slice(t,this._current));return{type:b,value:n,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:w,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:L,value:"[]",start:t}):{type:E,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:R,value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:D,value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t,i=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var o=this._current;"\\"!==e[o]||"\\"!==e[o+1]&&"`"!==e[o+1]?o++:o+=2,this._current=o}var r=s(e.slice(i,this._current));return r=r.replace("\\`","`"),t=this._looksLikeJSON(r)?JSON.parse(r):JSON.parse('"'+r+'"'),this._current++,t},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var H={};function z(){}function $(e){this.runtime=e}function q(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[c]}]},avg:{_func:this._functionAvg,_signature:[{types:[l]}]},ceil:{_func:this._functionCeil,_signature:[{types:[c]}]},contains:{_func:this._functionContains,_signature:[{types:[h,a]},{types:[r]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[h]},{types:[h]}]},floor:{_func:this._functionFloor,_signature:[{types:[c]}]},length:{_func:this._functionLength,_signature:[{types:[h,a,t]}]},map:{_func:this._functionMap,_signature:[{types:[i]},{types:[a]}]},max:{_func:this._functionMax,_signature:[{types:[l,d]}]},merge:{_func:this._functionMerge,_signature:[{types:[t],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[a]},{types:[i]}]},sum:{_func:this._functionSum,_signature:[{types:[l]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[h]},{types:[h]}]},min:{_func:this._functionMin,_signature:[{types:[l,d]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[a]},{types:[i]}]},type:{_func:this._functionType,_signature:[{types:[r]}]},keys:{_func:this._functionKeys,_signature:[{types:[t]}]},values:{_func:this._functionValues,_signature:[{types:[t]}]},sort:{_func:this._functionSort,_signature:[{types:[d,l]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[a]},{types:[i]}]},join:{_func:this._functionJoin,_signature:[{types:[h]},{types:[d]}]},reverse:{_func:this._functionReverse,_signature:[{types:[h,a]}]},to_array:{_func:this._functionToArray,_signature:[{types:[r]}]},to_string:{_func:this._functionToString,_signature:[{types:[r]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[r]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[r],variadic:!0}]}}}H.EOF=0,H[u]=0,H[p]=0,H[f]=0,H[m]=0,H[g]=0,H[y]=0,H[b]=0,H[I]=0,H[P]=0,H[A]=1,H.Or=2,H.And=3,H.EQ=5,H.GT=5,H.LT=5,H.GTE=5,H.LTE=5,H.NE=5,H[L]=9,H[x]=20,H[w]=21,H.Dot=40,H.Not=45,H[C]=50,H[E]=55,H[S]=60,z.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t=this.expression(0);if("EOF"===this._lookahead(0))return t;var i=this._lookaheadToken(0),n=new Error("Unexpected token type: "+i.type+", value: "+i.value);throw n.name="ParserError",n},_loadTokens:function(e){var t=(new n).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){var t=this._lookaheadToken(0);this._advance();for(var i=this.nud(t),n=this._lookahead(0);e<H[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i;switch(e.type){case N:return{type:"Literal",value:e.value};case u:return{type:"Field",name:e.value};case p:var n={type:"Field",name:e.value};if(this._lookahead(0)===S)throw new Error("Quoted identifier not allowed for function names.");return n;case"Not":return{type:"NotExpression",children:[t=this.expression(H.Not)]};case x:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===f?{type:"Identity"}:this._parseProjectionRHS(H.Star)]};case w:return this.led(e.type,{type:"Identity"});case C:return this._parseMultiselectHash();case L:return{type:"Projection",children:[{type:L,children:[{type:"Identity"}]},t=this._parseProjectionRHS(H.Flatten)]};case E:return this._lookahead(0)===b||this._lookahead(0)===v?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===x&&this._lookahead(1)===f?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(H.Star)]}):this._parseMultiselectList();case I:return{type:I};case P:return{type:"ExpressionReference",children:[i=this.expression(H.Expref)]};case S:for(var o=[];this._lookahead(0)!==m;)this._lookahead(0)===I?(i={type:I},this._advance()):i=this.expression(0),o.push(i);return this._match(m),o[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case _:var n=H.Dot;return this._lookahead(0)!==x?{type:"Subexpression",children:[t,i=this._parseDotRHS(n)]}:(this._advance(),{type:"ValueProjection",children:[t,i=this._parseProjectionRHS(n)]});case A:return i=this.expression(H.Pipe),{type:A,children:[t,i]};case"Or":return{type:"OrExpression",children:[t,i=this.expression(H.Or)]};case"And":return{type:"AndExpression",children:[t,i=this.expression(H.And)]};case S:for(var o,r=t.name,s=[];this._lookahead(0)!==m;)this._lookahead(0)===I?(o={type:I},this._advance()):o=this.expression(0),this._lookahead(0)===g&&this._match(g),s.push(o);return this._match(m),{type:"Function",name:r,children:s};case w:var a=this.expression(0);return this._match(f),{type:"FilterProjection",children:[t,i=this._lookahead(0)===L?{type:"Identity"}:this._parseProjectionRHS(H.Filter),a]};case L:return{type:"Projection",children:[{type:L,children:[t]},this._parseProjectionRHS(H.Flatten)]};case"EQ":case"NE":case"GT":case D:case"LT":case R:return this._parseComparator(t,e);case E:var l=this._lookaheadToken(0);return l.type===b||l.type===v?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match(x),this._match(f),{type:"Projection",children:[t,i=this._parseProjectionRHS(H.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){if(this._lookahead(0)!==e){var t=this._lookaheadToken(0),i=new Error("Expected "+e+", got: "+t.type);throw i.name="ParserError",i}this._advance()},_errorToken:function(e){var t=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw t.name="ParserError",t},_parseIndexExpression:function(){if(this._lookahead(0)===v||this._lookahead(1)===v)return this._parseSliceExpression();var e={type:"Index",value:this._lookaheadToken(0).value};return this._advance(),this._match(f),e},_projectIfSlice:function(e,t){var i={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[i,this._parseProjectionRHS(H.Star)]}:i},_parseSliceExpression:function(){for(var e=[null,null,null],t=0,i=this._lookahead(0);i!==f&&t<3;){if(i===v)t++,this._advance();else{if(i!==b){var n=this._lookahead(0),o=new Error("Syntax error, unexpected token: "+n.value+"("+n.type+")");throw o.name="Parsererror",o}e[t]=this._lookaheadToken(0).value,this._advance()}i=this._lookahead(0)}return this._match(f),{type:"Slice",children:e}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(H[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[u,p,x].indexOf(t)?this.expression(e):t===E?(this._match(E),this._parseMultiselectList()):t===C?(this._match(C),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t;if(H[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===E)t=this.expression(e);else if(this._lookahead(0)===w)t=this.expression(e);else{if(this._lookahead(0)!==_){var i=this._lookaheadToken(0),n=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")");throw n.name="ParserError",n}this._match(_),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==f;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===g&&(this._match(g),this._lookahead(0)===f))throw new Error("Unexpected token Rbracket")}return this._match(f),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i,n=[],o=[u,p];;){if(e=this._lookaheadToken(0),o.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(t=e.value,this._advance(),this._match(v),i={type:"KeyValuePair",name:t,value:this.expression(0)},n.push(i),this._lookahead(0)===g)this._match(g);else if(this._lookahead(0)===y){this._match(y);break}}return{type:"MultiSelectHash",children:n}}},$.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var i,n,o,r,s,a,l,c,h;switch(e.type){case"Field":return null===t?null:k(t)?void 0===(a=t[e.name])?null:a:null;case"Subexpression":for(o=this.visit(e.children[0],t),h=1;h<e.children.length;h++)if(null===(o=this.visit(e.children[1],o)))return null;return o;case"IndexExpression":return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case"Index":if(!T(t))return null;var d=e.value;return d<0&&(d=t.length+d),void 0===(o=t[d])&&(o=null),o;case"Slice":if(!T(t))return null;var u=e.children.slice(0),p=this.computeSliceParams(t.length,u),f=p[0],m=p[1],g=p[2];if(o=[],0<g)for(h=f;h<m;h+=g)o.push(t[h]);else for(h=f;m<h;h+=g)o.push(t[h]);return o;case"Projection":var v=this.visit(e.children[0],t);if(!T(v))return null;for(c=[],h=0;h<v.length;h++)null!==(n=this.visit(e.children[1],v[h]))&&c.push(n);return c;case"ValueProjection":if(!k(v=this.visit(e.children[0],t)))return null;c=[];var y=function(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}(v);for(h=0;h<y.length;h++)null!==(n=this.visit(e.children[1],y[h]))&&c.push(n);return c;case"FilterProjection":if(!T(v=this.visit(e.children[0],t)))return null;var b=[],x=[];for(h=0;h<v.length;h++)O(i=this.visit(e.children[2],v[h]))||b.push(v[h]);for(var w=0;w<b.length;w++)null!==(n=this.visit(e.children[1],b[w]))&&x.push(n);return x;case"Comparator":switch(r=this.visit(e.children[0],t),s=this.visit(e.children[1],t),e.name){case"EQ":o=j(r,s);break;case"NE":o=!j(r,s);break;case"GT":o=s<r;break;case D:o=s<=r;break;case"LT":o=r<s;break;case R:o=r<=s;break;default:throw new Error("Unknown comparator: "+e.name)}return o;case L:var _=this.visit(e.children[0],t);if(!T(_))return null;var C=[];for(h=0;h<_.length;h++)T(n=_[h])?C.push.apply(C,n):C.push(n);return C;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(c=[],h=0;h<e.children.length;h++)c.push(this.visit(e.children[h],t));return c;case"MultiSelectHash":if(null===t)return null;var E;for(c={},h=0;h<e.children.length;h++)c[(E=e.children[h]).name]=this.visit(E.value,t);return c;case"OrExpression":return O(i=this.visit(e.children[0],t))&&(i=this.visit(e.children[1],t)),i;case"AndExpression":return!0===O(r=this.visit(e.children[0],t))?r:this.visit(e.children[1],t);case"NotExpression":return O(r=this.visit(e.children[0],t));case"Literal":return e.value;case A:return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case I:return t;case"Function":var S=[];for(h=0;h<e.children.length;h++)S.push(this.visit(e.children[h],t));return this.runtime.callFunction(e.name,S);case"ExpressionReference":var N=e.children[0];return N.jmespathType=P,N;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],o=t[2],r=[null,null,null];if(null===o)o=1;else if(0===o){var s=new Error("Invalid slice, step cannot be 0");throw s.name="RuntimeError",s}var a=o<0;return i=null===i?a?e-1:0:this.capSliceRange(e,i,o),n=null===n?a?-1:e:this.capSliceRange(e,n,o),r[0]=i,r[1]=n,r[2]=o,r},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):e<=t&&(t=i<0?e-1:e),t}},q.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n,o,r,s;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var a=0;a<i.length;a++){s=!1,o=i[a].types,r=this._getTypeName(t[a]);for(var l=0;l<o.length;l++)if(this._typeMatches(r,o[l],t[a])){s=!0;break}if(!s)throw new Error("TypeError: "+e+"() expected argument "+(a+1)+" to be type "+o+" but received type "+r+" instead.")}},_typeMatches:function(e,t,i){if(t===r)return!0;if(t!==d&&t!==l&&t!==a)return e===t;if(t===a)return e===a;if(e===a){var n;t===l?n=c:t===d&&(n=h);for(var o=0;o<i.length;o++)if(!this._typeMatches(this._getTypeName(i[o]),n,i[o]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return h;case"[object Number]":return c;case"[object Array]":return a;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===P?i:t}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],i=e[1];return-1!==t.indexOf(i,t.length-i.length)},_functionReverse:function(e){if(this._getTypeName(e[0])===h){for(var t=e[0],i="",n=t.length-1;0<=n;n--)i+=t[n];return i}var o=e[0].slice(0);return o.reverse(),o},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return k(e[0])?Object.keys(e[0]).length:e[0].length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],o=e[1],r=0;r<o.length;r++)t.push(i.visit(n,o[r]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n=e[i];for(var o in n)t[o]=n[o]}return t},_functionMax:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case c:return"number";case h:return"string";case a:return"array";case t:return"object";case 5:return"boolean";case i:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],o=0;o<i.length;o++)n.push(t[i[o]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return this._getTypeName(e[0])===a?e[0]:[e[0]]},_functionToString:function(e){return this._getTypeName(e[0])===h?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return i===c?e[0]:i!==h||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){var t=e[0].slice(0);return t.sort(),t},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var o=this._interpreter,r=e[1],s=this._getTypeName(o.visit(r,t[0]));if([c,h].indexOf(s)<0)throw new Error("TypeError");for(var a=this,i=[],n=0;n<t.length;n++)i.push([n,t[n]]);i.sort(function(e,t){var i=o.visit(r,e[1]),n=o.visit(r,t[1]);if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));return n<i?1:i<n?-1:e[0]-t[0]});for(var l=0;l<i.length;l++)t[l]=i[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],o=e[0],r=this.createKeyFunction(n,[c,h]),s=-1/0,a=0;a<o.length;a++)s<(i=r(o[a]))&&(s=i,t=o[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],o=e[0],r=this.createKeyFunction(n,[c,h]),s=1/0,a=0;a<o.length;a++)(i=r(o[a]))<s&&(s=i,t=o[a]);return t},createKeyFunction:function(n,o){var r=this,s=this._interpreter;return function(e){var t=s.visit(n,e);if(o.indexOf(r._getTypeName(t))<0){var i="TypeError: expected one of "+o+", received "+r._getTypeName(t);throw new Error(i)}return t}}},e.tokenize=function(e){return(new n).tokenize(e)},e.compile=function(e){return(new z).parse(e)},e.search=function(e,t){var i=new z,n=new q,o=new $(n);n._interpreter=o;var r=i.parse(t);return o.search(r,e)},e.strictDeepEqual=j}(t)},function(e,t,i){var n=i(9),o=i(0).translate;e.exports=function(a,e){var t='<div class="pico-modal-contents"><div class="pico-modal-header">'+o("sort")+"</div><form><table><tbody><tr>  <td>"+o("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+o("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+o("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+o("sortAscending")+'" title="'+o("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+o("sortDescending")+'" title="'+o("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+o("ok")+'" /></td></tr></tbody></table></form></div>';n({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(n){var e=n.modalElem().querySelector("form"),t=n.modalElem().querySelector("#ok"),o=n.modalElem().querySelector("#field"),r=n.modalElem().querySelector("#direction"),i="array"===a.type?a.getChildPaths():["."];function s(e){r.value=e,r.className="jsoneditor-button-group jsoneditor-button-group-value-"+r.value}i.forEach(function(e){var t=document.createElement("option");t.text=e,t.value=e,o.appendChild(t)}),o.value=a.sortedBy?a.sortedBy.path:i[0],s(a.sortedBy?a.sortedBy.direction:"asc"),r.onclick=function(e){s(e.target.getAttribute("data-value"))},t.onclick=function(e){e.preventDefault(),e.stopPropagation(),n.close();var t=o.value,i="."===t?[]:t.split(".").slice(1);a.sortedBy={path:t,direction:r.value},a.sort(i,r.value)},e&&(e.onsubmit=t.onclick)}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){var n,o,r;!function(){"use strict";o=[],void 0===(r="function"==typeof(n=function(){"use strict";function g(e){if(typeof Node==="object"){return e instanceof Node}else{return e&&typeof e==="object"&&typeof e.nodeType==="number"}}function e(e){return"string"==typeof e}function v(){var r=[];return{watch:r.push.bind(r),trigger:function(e,t){var i=true;var n={detail:t,preventDefault:function e(){i=false}};for(var o=0;o<r.length;o++){r[o](e,n)}return i}}}function y(e){return window.getComputedStyle(e).display==="none"}function b(e){this.elem=e}function t(e,t){return b.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}b.make=function(e,t){if(typeof e==="string"){e=document.querySelector(e)}var i=document.createElement(t||"div");(e||document.body).appendChild(i);return new b(i)},b.prototype={child:function(e){return b.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined"){e.filter="alpha(opacity="+e.opacity*100+")"}for(var t in e){if(e.hasOwnProperty(t)){this.elem.style[t]=e[t]}}return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(g(e)){this.elem.appendChild(e)}else{this.elem.innerHTML=e}return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined){this.elem.setAttribute(e,t)}return this},anyAncestor:function(e){var t=this.elem;while(t){if(e(new b(t))){return true}else{t=t.parentNode}}return false},isVisible:function(){return!y(this.elem)}};var x=1;function i(e,t){var i=e("width","auto");if("number"==typeof i)i+="px";var n=e("modalId","pico-"+x++);return b.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new b(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function n(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function w(e){return function(){return e().elem}}var _=v(),C=v();function o(n,o){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function r(e){return!(y(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(r(t[i]))return t[i]}function r(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(r(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(o()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){o()&&e&&e.focus(),e=null}),C.watch(function(e){if(o()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(r(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}function r(e,t){var i,n=new b(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?_.trigger():9===t&&C.trigger(e)}),function(n){(function(e){return"string"==typeof e}(n)||g(n))&&(n={content:n});var o=v(),t=v(),i=v(),r=v(),s=v();function a(e,t){var i=n[e];return"function"==typeof i&&(i=i(t)),void 0===i?t:i}var l,c,h=m.bind(window,"modal"),d=m.bind(window,"overlay"),u=m.bind(window,"close");function p(e){d().hide(),h().hide(),s.trigger(l,e)}function f(e){r.trigger(l,e)&&p(e)}function e(e){return function(){return e.apply(this,arguments),l}}function m(e,t){if(!c){var i=function(e,t){var i=e("width","auto");"number"==typeof i&&(i+="px");var n=e("modalId","pico-"+x++);return b.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new b(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}(a,f);c={modal:i,overlay:function(e,t){return b.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}(a,f),close:function(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}(i,a)},o.trigger(l,t)}return c[e]}return function(n,o){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function r(e){return!(y(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(r(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(o()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){o()&&e&&e.focus(),e=null}),C.watch(function(e){if(o()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(r(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}(l={modalElem:w(h),closeElem:w(u),overlayElem:w(d),buildDom:e(m.bind(null,null)),isVisible:function(){return!!(c&&h&&h().isVisible())},show:function(e){return t.trigger(l,e)&&(d().show(),u(),h().show(),i.trigger(l,e)),this},close:e(f),forceClose:e(p),destroy:function(){h().destroy(),d().destroy(),d=h=u=void 0},options:function(t){Object.keys(t).map(function(e){n[e]=t[e]})},afterCreate:e(o.watch),beforeShow:e(t.watch),afterShow:e(i.watch),beforeClose:e(r.watch),afterClose:e(s.watch)},a.bind(null,"focus",!0)),function(e,t){var i,n=new b(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}(l,a.bind(null,"bodyOverflow",!0)),_.watch(function(){a("escCloses",!0)&&l.isVisible()&&l.close()}),l}})?n.apply(t,o):n)||(e.exports=r)}()},function(e,t,i){var E=i(7),n=i(9),S=i(27),o=i(0).translate,N=i(1),T=N.debounce;e.exports=function(_,e){var C=_.getValue(),t='<label class="pico-modal-contents"><div class="pico-modal-header">'+o("transform")+'</div><p>Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.</p><div class="jsoneditor-jmespath-label">'+o("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+o("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+o("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+o("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+o("transformQueryLabel"
)+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+o("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+o("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+o("ok")+'" autofocus /></div></div>';n({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){var e=t.modalElem(),i=e.querySelector("#wizard"),n=e.querySelector("#ok"),a=e.querySelector("#filterField"),l=e.querySelector("#filterRelation"),c=e.querySelector("#filterValue"),h=e.querySelector("#sortField"),d=e.querySelector("#sortOrder"),u=e.querySelector("#selectFields"),p=e.querySelector("#query"),o=e.querySelector("#preview");Array.isArray(C)||(i.style.fontStyle="italic",i.innerHTML="(wizard not available for objects, only for arrays)"),_.getChildPaths().forEach(function(e){var t=b(e),i=document.createElement("option");i.text=t,i.value=t,a.appendChild(i);var n=document.createElement("option");n.text=t,n.value=t,h.appendChild(n)});var r=_.getChildPaths(!0).filter(function(e){return"."!==e});if(0<r.length)r.forEach(function(e){var t=b(e),i=document.createElement("option");i.text=t,i.value=t,u.appendChild(i)});else{var s=e.querySelector("#selectFieldsPart");s&&(s.style.display="none")}var f=new S(a,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),m=new S(l,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),g=new S(h,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),v=new S(d,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),y=new S(u,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function b(e){return"."===e[0]?"."===e?"@":e.slice(1):e}function x(){if(a.value&&l.value&&c.value){var e=a.value,t="@"!==e?["0"].concat(N.parsePath("."+e)):["0"],i="string"==typeof N.get(C,t)?c.value:_._stringCast(c.value);p.value="[? "+e+" "+l.value+" `"+JSON.stringify(i)+"`]"}else p.value="[*]";if(h.value&&d.value){var n=h.value;"desc"===d.value?p.value+=" | reverse(sort_by(@, &"+n+"))":p.value+=" | sort_by(@, &"+n+")"}if(u.value){for(var o=[],r=0;r<u.options.length;r++)if(u.options[r].selected){var s=u.options[r].value;o.push(s)}"]"!==p.value[p.value.length-1]&&(p.value+=" | [*]"),1===o.length?p.value+="."+o[0]:1<o.length&&(p.value+=".{"+o.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")}w()}f.on("selectr.change",x),m.on("selectr.change",x),c.oninput=x,g.on("selectr.change",x),v.on("selectr.change",x),y.on("selectr.change",x),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()},p.value=Array.isArray(C)?"[*]":"@";var w=T(function(){try{var e=E.search(C,p.value),t=JSON.stringify(e,null,2).split("\n");100<t.length&&(t=t.slice(0,100).concat(["..."])),o.className="jsoneditor-transform-preview",o.value=t.join("\n"),n.disabled=!1}catch(e){o.className="jsoneditor-transform-preview jsoneditor-error",o.value=e.toString(),n.disabled=!0}},300);(p.oninput=w)(),n.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),_.transform(p.value)},setTimeout(function(){p.select(),p.focus(),p.selectionStart=3,p.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){"use strict";var p=i(2),f=i(0).translate;function n(e,t,i,n){for(var o={code:{text:f("modeCodeText"),title:f("modeCodeTitle"),click:function(){n("code")}},form:{text:f("modeFormText"),title:f("modeFormTitle"),click:function(){n("form")}},text:{text:f("modeTextText"),title:f("modeTextTitle"),click:function(){n("text")}},tree:{text:f("modeTreeText"),title:f("modeTreeTitle"),click:function(){n("tree")}},view:{text:f("modeViewText"),title:f("modeViewTitle"),click:function(){n("view")}}},r=[],s=0;s<t.length;s++){var a=t[s],l=o[a];if(!l)throw new Error('Unknown mode "'+a+'"');l.className="jsoneditor-type-modes"+(i==a?" jsoneditor-selected":""),r.push(l)}var c=o[i];if(!c)throw new Error('Unknown mode "'+i+'"');var h=c.text,d=document.createElement("button");d.type="button",d.className="jsoneditor-modes jsoneditor-separator",d.innerHTML=h+" &#x25BE;",d.title="Switch editor mode",d.onclick=function(){new p(r).show(d,e)};var u=document.createElement("div");u.className="jsoneditor-modes",u.style.position="relative",u.appendChild(d),e.appendChild(u),this.dom={container:e,box:d,frame:u}}n.prototype.focus=function(){this.dom.box.focus()},n.prototype.destroy=function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null},e.exports=n},function(e,t,o){"use strict";var r;try{r=o(!function(){var e=new Error("Cannot find module 'ajv'");throw e.code="MODULE_NOT_FOUND",e}())}catch(e){}var i=o(3),n=o(4),s=o(16),a=o(29),l=o(1);function c(e,t,i){if(!(this instanceof c))throw new Error('JSONEditor constructor called without "new".');var n=l.getInternetExplorerVersion();if(-1!=n&&n<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"!==t.mode&&"code"!==t.mode&&(!t.modes||-1===t.modes.indexOf("text")&&-1===t.modes.indexOf("code"))||console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.')),t&&Object.keys(t).forEach(function(e){-1===c.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})),arguments.length&&this._create(e,t,i)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),c.modes={},c.prototype.DEBOUNCE_INTERVAL=150,c.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","colorPicker","onColorPicker","timestampTag","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","maxVisibleChilds"],c.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(n)},c.prototype.destroy=function(){},c.prototype.set=function(e){this.json=e},c.prototype.get=function(){return this.json},c.prototype.setText=function(e){this.json=l.parse(e)},c.prototype.getText=function(){return JSON.stringify(this.json)},c.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},c.prototype.getName=function(){return this.options&&this.options.name},c.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t,i,n=this.container,o=l.extend({},this.options),r=o.mode;o.mode=e;var s=c.modes[e];if(!s)throw new Error('Unknown mode "'+o.mode+'"');try{var a="text"==s.data;if(i=this.getName(),t=this[a?"getText":"get"](),this.destroy(),l.clear(this),l.extend(this,s.mixin),this.create(n,o),this.setName(i),this[a?"setText":"set"](t),"function"==typeof s.load)try{s.load.call(this)}catch(e){console.error(e)}if("function"==typeof o.onModeChange&&e!==r)try{o.onModeChange(e,r)}catch(e){console.error(e)}}catch(e){this._onError(e)}}},c.prototype.getMode=function(){return this.options.mode},c.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},c.prototype.setSchema=function(e,t){if(e){var i;try{this.options.ajv?i=this.options.ajv:((i=r({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(o(!function(){var e=new Error("Cannot find module 'ajv/lib/refs/json-schema-draft-04.json'");throw e.code="MODULE_NOT_FOUND",e}())),i.addMetaSchema(o(!function(){var e=new Error("Cannot find module 'ajv/lib/refs/json-schema-draft-06.json'");throw e.code="MODULE_NOT_FOUND",e}())))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},c.prototype.validate=function(){},c.prototype.refresh=function(){},c.registerMode=function(e){var t,i;if(l.isArray(e))for(t=0;t<e.length;t++)c.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var n=e.mode;if(n in c.modes)throw new Error('Mode "'+n+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var o=["setMode","registerMode","modes"];for(t=0;t<o.length;t++)if((i=o[t])in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');c.modes[n]=e}},c.registerMode(s),c.registerMode(a),c.ace=i,c.Ajv=r,c.VanillaPicker=n,c.default=c,e.exports=c},function(e,t,d){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var o=e("../lib/oop"),r=e("./text_highlight_rules").TextHighlightRules;o.inherits(n,r),t.JsonHighlightRules=n}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){}var s=e("../range").Range;(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t).match(/^(\s*\})/);if(!i)return 0;var n=i[1].length,o=e.findMatchingBracket({row:t,column:n});if(!o||o.row==t)return 0;var r=this.$getIndent(e.getLine(o.row));e.replace(new s(t,0,t,n-1),r)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(n.prototype),t.MatchingBraceOutdent=n}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),h=e("../../range").Range,o=e("./fold_mode").FoldMode,r=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(r,o),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";var o=this._getFoldWidgetBase(e,t,i);return!o&&this.startRegionRe.test(n)?"start":o},this.getFoldWidgetRange=function(e,t,i,n){var o,r=e.getLine(i);if(this.startRegionRe.test(r))return this.getCommentRegionBlock(e,r,i);if(o=r.match(this.foldingStartMarker)){var s=o.index;if(o[1])return this.openingBracketBlock(e,o[1],i,s);var a=e.getCommentFoldRange(i,s+o[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t&&(o=r.match(this.foldingStopMarker))){s=o.index+o[0].length;return o[1]?this.closingBracketBlock(e,o[1],i,s):e.getCommentFoldRange(i,s,-1)}},this.getSectionRange=function(e,t){for(var i=e.getLine(t),n=i.search(/\S/),o=t,r=i.length,s=t+=1,a=e.getLength();++t<a;){var l=(i=e.getLine(t)).search(/\S/);if(-1!==l){if(l<n)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=o)break;if(c.isMultiLine())t=c.end.row;else if(n==l)break}s=t}}return new h(o,r,s,e.getLine(s).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),o=e.getLength(),r=i,s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++i<o;){t=e.getLine(i);var l=s.exec(t);if(l&&(l[1]?a--:a++,!a))break}if(r<i)return new h(r,n,i,t.length)}}.call(r.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,i){"use strict";function n(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c}var o=e("../lib/oop"),r=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,h=e("../worker/worker_client").WorkerClient;o.inherits(n,r),function(){this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);"start"==e&&t.match(/^.*[\{\(\[]\s*$/)&&(n+=i);return n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(t){var e=new h(["ace"],d(14),"JsonWorker");return e.attachToDocument(t.getDocument()),e.on("annotate",function(e){t.setAnnotations(e.data)}),e.on("terminate",function(){t.clearAnnotations()}),e},this.$id="ace/mode/json"}.call(n.prototype),t.Mode=n})},function(e,t){e.exports.id="ace/mode/json_worker",e.exports.src='"no use strict";!function(window){function resolveModuleId(id,paths){for(var testPath=id,tail="";testPath;){var alias=paths[testPath];if("string"==typeof alias)return alias+tail;if(alias)return alias.location.replace(/\\/*$/,"/")+(tail||alias.main||alias.name);if(alias===!1)return"";var i=testPath.lastIndexOf("/");if(-1===i)break;tail=testPath.substr(i)+tail,testPath=testPath.slice(0,i)}return id}if(!(void 0!==window.window&&window.document||window.acequire&&window.define)){window.console||(window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console),window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,data:err.data,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function acequire(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;if(!window.acequire.tlns)return console.log("unable to load "+id);var path=resolveModuleId(id,window.acequire.tlns);return".js"!=path.slice(-3)&&(path+=".js"),window.acequire.id=id,window.acequire.modules[id]={},importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},acequire.tlns={},window.initBaseUrls=function(topLevelNamespaces){for(var i in topLevelNamespaces)acequire.tlns[i]=topLevelNamespaces[i]},window.initSender=function(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.event&&sender)sender._signal(msg.event,msg.data);else if(msg.command)if(main[msg.command])main[msg.command].apply(main,msg.args);else{if(!window[msg.command])throw Error("Unknown command:"+msg.command);window[msg.command].apply(window,msg.args)}else if(msg.init){window.initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=window.initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}}}}(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/apply_delta",["require","exports","module"],function(acequire,exports){"use strict";exports.applyDelta=function(docLines,delta){var row=delta.start.row,startColumn=delta.start.column,line=docLines[row]||"";switch(delta.action){case"insert":var lines=delta.lines;if(1===lines.length)docLines[row]=line.substring(0,startColumn)+delta.lines[0]+line.substring(startColumn);else{var args=[row,1].concat(delta.lines);docLines.splice.apply(docLines,args),docLines[row]=line.substring(0,startColumn)+docLines[row],docLines[row+delta.lines.length-1]+=line.substring(startColumn)}break;case"remove":var endColumn=delta.end.column,endRow=delta.end.row;row===endRow?docLines[row]=line.substring(0,startColumn)+line.substring(endColumn):docLines.splice(row,endRow-row+1,line.substring(0,startColumn)+docLines[endRow].substring(endColumn))}}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){function $pointsInOrder(point1,point2,equalPointsInOrder){var bColIsAfter=equalPointsInOrder?point1.column<=point2.column:point1.column<point2.column;return point1.row<point2.row||point1.row==point2.row&&bColIsAfter}function $getTransformedPoint(delta,point,moveIfEqual){var deltaIsInsert="insert"==delta.action,deltaRowShift=(deltaIsInsert?1:-1)*(delta.end.row-delta.start.row),deltaColShift=(deltaIsInsert?1:-1)*(delta.end.column-delta.start.column),deltaStart=delta.start,deltaEnd=deltaIsInsert?deltaStart:delta.end;return $pointsInOrder(point,deltaStart,moveIfEqual)?{row:point.row,column:point.column}:$pointsInOrder(deltaEnd,point,!moveIfEqual)?{row:point.row+deltaRowShift,column:point.column+(point.row==deltaEnd.row?deltaColShift:0)}:{row:deltaStart.row,column:deltaStart.column}}oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(delta){if(!(delta.start.row==delta.end.row&&delta.start.row!=this.row||delta.start.row>this.row)){var point=$getTransformedPoint(delta,{row:this.row,column:this.column},this.$insertRight);this.setPosition(point.row,point.column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),applyDelta=acequire("./apply_delta").applyDelta,EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(textOrLines){this.$lines=[""],0===textOrLines.length?this.$lines=[""]:Array.isArray(textOrLines)?this.insertMergedLines({row:0,column:0},textOrLines):this.insert({row:0,column:0},textOrLines)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength()-1;this.remove(new Range(0,0,len,this.getLine(len).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){return this.getLinesForRange(range).join(this.getNewLineCharacter())},this.getLinesForRange=function(range){var lines;if(range.start.row===range.end.row)lines=[this.getLine(range.start.row).substring(range.start.column,range.end.column)];else{lines=this.getLines(range.start.row,range.end.row),lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column))}return lines},this.insertLines=function(row,lines){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(row,lines)},this.removeLines=function(firstRow,lastRow){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(firstRow,lastRow)},this.insertNewLine=function(position){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead."),this.insertMergedLines(position,["",""])},this.insert=function(position,text){return 1>=this.getLength()&&this.$detectNewLine(text),this.insertMergedLines(position,this.$split(text))},this.insertInLine=function(position,text){var start=this.clippedPos(position.row,position.column),end=this.pos(position.row,position.column+text.length);return this.applyDelta({start:start,end:end,action:"insert",lines:[text]},!0),this.clonePos(end)},this.clippedPos=function(row,column){var length=this.getLength();void 0===row?row=length:0>row?row=0:row>=length&&(row=length-1,column=void 0);var line=this.getLine(row);return void 0==column&&(column=line.length),column=Math.min(Math.max(column,0),line.length),{row:row,column:column}},this.clonePos=function(pos){return{row:pos.row,column:pos.column}},this.pos=function(row,column){return{row:row,column:column}},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):(position.row=Math.max(0,position.row),position.column=Math.min(Math.max(position.column,0),this.getLine(position.row).length)),position},this.insertFullLines=function(row,lines){row=Math.min(Math.max(row,0),this.getLength());var column=0;this.getLength()>row?(lines=lines.concat([""]),column=0):(lines=[""].concat(lines),row--,column=this.$lines[row].length),this.insertMergedLines({row:row,column:column},lines)},this.insertMergedLines=function(position,lines){var start=this.clippedPos(position.row,position.column),end={row:start.row+lines.length-1,column:(1==lines.length?start.column:0)+lines[lines.length-1].length};return this.applyDelta({start:start,end:end,action:"insert",lines:lines}),this.clonePos(end)},this.remove=function(range){var start=this.clippedPos(range.start.row,range.start.column),end=this.clippedPos(range.end.row,range.end.column);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})}),this.clonePos(start)},this.removeInLine=function(row,startColumn,endColumn){var start=this.clippedPos(row,startColumn),end=this.clippedPos(row,endColumn);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})},!0),this.clonePos(start)},this.removeFullLines=function(firstRow,lastRow){firstRow=Math.min(Math.max(0,firstRow),this.getLength()-1),lastRow=Math.min(Math.max(0,lastRow),this.getLength()-1);var deleteFirstNewLine=lastRow==this.getLength()-1&&firstRow>0,deleteLastNewLine=this.getLength()-1>lastRow,startRow=deleteFirstNewLine?firstRow-1:firstRow,startCol=deleteFirstNewLine?this.getLine(startRow).length:0,endRow=deleteLastNewLine?lastRow+1:lastRow,endCol=deleteLastNewLine?0:this.getLine(endRow).length,range=new Range(startRow,startCol,endRow,endCol),deletedLines=this.$lines.slice(firstRow,lastRow+1);return this.applyDelta({start:range.start,end:range.end,action:"remove",lines:this.getLinesForRange(range)}),deletedLines},this.removeNewLine=function(row){this.getLength()-1>row&&row>=0&&this.applyDelta({start:this.pos(row,this.getLine(row).length),end:this.pos(row+1,0),action:"remove",lines:["",""]})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0===text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;this.remove(range);var end;return end=text?this.insert(range.start,text):range.start},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++)this.applyDelta(deltas[i])},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--)this.revertDelta(deltas[i])},this.applyDelta=function(delta,doNotValidate){var isInsert="insert"==delta.action;(isInsert?1>=delta.lines.length&&!delta.lines[0]:!Range.comparePoints(delta.start,delta.end))||(isInsert&&delta.lines.length>2e4&&this.$splitAndapplyLargeDelta(delta,2e4),applyDelta(this.$lines,delta,doNotValidate),this._signal("change",delta))},this.$splitAndapplyLargeDelta=function(delta,MAX){for(var lines=delta.lines,l=lines.length,row=delta.start.row,column=delta.start.column,from=0,to=0;;){from=to,to+=MAX-1;var chunk=lines.slice(from,to);if(to>l){delta.lines=chunk,delta.start.row=row+from,delta.start.column=column;break}chunk.push(""),this.applyDelta({start:this.pos(row+from,column),end:this.pos(row+to,column=0),action:delta.action,lines:chunk},!0)}},this.revertDelta=function(delta){this.applyDelta({start:this.clonePos(delta.start),end:this.clonePos(delta.end),action:"insert"==delta.action?"remove":"insert",lines:delta.lines.slice()})},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function deepCopy(obj){if("object"!=typeof obj||!obj)return obj;var copy;if(Array.isArray(obj)){copy=[];for(var key=0;obj.length>key;key++)copy[key]=deepCopy(obj[key]);return copy}if("[object Object]"!==Object.prototype.toString.call(obj))return obj;copy={};for(var key in obj)copy[key]=deepCopy(obj[key]);return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";acequire("../range").Range;var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){var data=e.data;if(data[0].start)doc.applyDeltas(data);else for(var i=0;data.length>i;i+=2){if(Array.isArray(data[i+1]))var d={action:"insert",start:data[i],lines:data[i+1]};else var d={action:"remove",start:data[i],end:data[i+1]};doc.applyDelta(d,!0)}return _self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"\t"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue(),errors=[];try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);errors.push({row:pos.row,column:pos.column,text:e.message,type:"error"})}this.sender.emit("annotate",errors)}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0\n}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;for(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="\t\\n\v\\f\\r   ᠎             　\\u2028\\u2029\ufeff";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});'},function(e,t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,i){"use strict";var o=e("../lib/dom"),n=e("../lib/lang"),s=e("../lib/event"),r=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys");o.importCssString('.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;box-sizing: border-box!important;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;box-sizing: content-box!important;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',"ace_searchbox");function l(e,t,i){var n=o.createElement("div");n.innerHTML=c,this.element=n.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e)}var c='<div class="ace_search right">    <span action="hide" class="ace_searchbtn_close"></span>    <div class="ace_search_form">        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>        <span action="findPrev" class="ace_searchbtn prev"></span>        <span action="findNext" class="ace_searchbtn next"></span>        <span action="findAll" class="ace_searchbtn" title="Alt-Enter">All</span>    </div>    <div class="ace_replace_form">        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>        <span action="replaceAndFindNext" class="ace_searchbtn">Replace</span>        <span action="replaceAll" class="ace_searchbtn">All</span>    </div>    <div class="ace_search_options">        <span action="toggleReplace" class="ace_button" title="Toggel Replace mode"            style="float:left;margin-top:-2px;padding:0 5px;">+</span>        <span class="ace_search_counter"></span>        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>        <span action="searchInSelection" class="ace_button" title="Search In Selection">S</span>    </div></div>'.replace(/> +/g,">");(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var r=this;s.addListener(e,"mousedown",function(e){setTimeout(function(){r.activeInput.focus()},0),s.stopPropagation(e)}),s.addListener(e,"click",function(e){var t=(e.target||e.srcElement).getAttribute(
"action");t&&r[t]?r[t]():r.$searchBarKb.commands[t]&&r.$searchBarKb.commands[t].exec(r),s.stopPropagation(e)}),s.addCommandKeyListener(e,function(e,t,i){var n=a.keyCodeToString(i),o=r.$searchBarKb.findKeyCommand(t,n);o&&o.exec&&(o.exec(r),s.stopEvent(e))}),this.$onChange=n.delayedCall(function(){r.find(!1,!1)}),s.addListener(this.searchInput,"input",function(){r.$onChange.schedule(20)}),s.addListener(this.searchInput,"focus",function(){r.activeInput=r.searchInput,r.searchInput.value&&r.highlight()}),s.addListener(this.replaceInput,"focus",function(){r.activeInput=r.replaceInput,r.searchInput.value&&r.highlight()})},this.$closeSearchBarKb=new r([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new r,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus()},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){(this.searchRange=e)?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){o.setCssClass(this.replaceOption,"checked",this.searchRange),o.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",o.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),o.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),o.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked),this.replaceBox.style.display=this.replaceOption.checked?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){var n=!this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i,range:this.searchRange})&&this.searchInput.value;o.setCssClass(this.searchBox,"ace_nomatch",n),this.editor._emit("findSearchBox",{match:!n}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,i=0,n=0;if(t){var o=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),r=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(r-=e.session.doc.positionToIndex(this.searchRange.start));for(var s,a=t.lastIndex=0;(s=t.exec(o))&&(i++,(a=s.index)<=r&&n++,!(999<i))&&(s[0]||(t.lastIndex=a+=1,!(a>=o.length))););}this.searchCounter.textContent=n+" of "+(999<i?"999+":i)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;o.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(l.prototype),t.SearchBox=l,t.Search=function(e,t){(e.searchBox||new l(e)).show(e.session.getTextRange(),t)}}),ace.acequire(["ace/ext/searchbox"],function(){})},function(e,t,i){"use strict";var n=i(4),o=i(17),r=i(18),c=i(21),s=i(2),h=i(22),l=i(23),d=i(11),u=i(1),a=i(28),p=i(8),f=i(10),m=i(0).translate,g=i(0).setLanguages,v=i(0).setLanguage,y=document.body,b={create:function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new o,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=new a(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new r(this)),this._createFrame(),this._createTable()},destroy:function(){this.frame&&this.container&&this.frame.parentNode==this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},_setOptions:function(e){if(this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,i){n?new n({parent:e,color:t,popup:"bottom",onDone:function(e){var t=1===e.rgba[3]?e.hex.substr(0,7):e.hex;i(t)}}).show():console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,onEvent:null,enableSort:!0,enableTransform:!0},e)for(var t in e)e.hasOwnProperty(t)&&(this.options[t]=e[t]);this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=u.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),e.onSelectionChange&&this.onSelectionChange(e.onSelectionChange),g(this.options.languages),v(this.options.language)},set:function(e){if(e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var t={field:this.options.name,value:e},i=new l(this,t);this._setRoot(i),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},update:function(e){if(!this.node.deepEqual(e)){var t=this.getSelection();if(this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this.validate(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end){var i=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path);i&&n?this.setSelection(t.start,t.end):this.setSelection({},{})}else this.setSelection({},{})}},get:function(){return this.node?this.node.getValue():void 0},getText:function(){return JSON.stringify(this.get())},setText:function(t){try{this.set(u.parse(t))}catch(e){var i=u.sanitize(t);this.set(u.parse(i))}},updateText:function(t){try{this.update(u.parse(t))}catch(e){var i=u.sanitize(t);this.update(u.parse(i))}},setName:function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},getName:function(){return this.options.name},focus:function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},clear:function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},_setRoot:function(e){this.clear(),this.node=e,this.tbody.appendChild(e.getDom())},search:function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},expandAll:function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},collapseAll:function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},_onAction:function(e,t){this.history&&this.history.add(e,t),this._onChange()},_onChange:function(){if(!this.onChangeDisabled){if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath){var e=this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0;e?this._updateTreePath(e.getNodePath()):this.treePath.reset()}if(this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},validate:function(){var t=this.node;if(t){var e=t.getValue(),i=[];if(this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return u.improveSchemaError(e)}).map(function(e){return{node:t.findNode(e.dataPath),error:e}}).filter(function(e){return null!=e.node}));try{this.validationSequence++;var n=this,o=this.validationSequence;this._validateCustom(e).then(function(e){if(o===n.validationSequence){var t=[].concat(i,e||[]);n._renderValidationErrors(t)}}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}},_renderValidationErrors:function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},_validateCustom:function(e){try{if(this.options.onValidate){var i=this.node,t=this.options.onValidate(e);return(u.isPromise(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=u.isValidValidationError(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?i.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}}catch(e){return Promise.reject(e)}return Promise.resolve(null)},refresh:function(){this.node&&this.node.updateDom({recurse:!0})},startAutoScroll:function(e){var t=this,i=this.scrollableContent,n=u.getAbsoluteTop(i),o=i.clientHeight,r=n+o;e<n+24&&0<i.scrollTop?this.autoScrollStep=(n+24-e)/3:r-24<e&&o+i.scrollTop<i.scrollHeight?this.autoScrollStep=(r-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},stopAutoScroll:function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},setDomSelection:function(e){if(e)if("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths){var t=this,i=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)});this.select(i)}else{var n=e.path?this.node.findNodeByInternalPath(e.path):null,o=n&&e.domName?n.dom[e.domName]:null;if(e.range&&o){var r=Object.assign({},e.range,{container:o});u.setSelectionOffset(r)}else n&&n.focus()}},getDomSelection:function(){var t=l.getNodeFromTarget(this.focusTarget),i=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===i}):null,n=u.getSelectionOffset();return n&&"DIV"!==n.container.nodeName&&(n=null),n&&n.container!==i&&(n=null),n&&delete n.container,{path:t?t.getInternalPath():null,domName:e,range:n,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},scrollTo:function(e,i){var n=this.scrollableContent;if(n){var o=this;o.animateTimeout&&(clearTimeout(o.animateTimeout),delete o.animateTimeout),o.animateCallback&&(o.animateCallback(!1),delete o.animateCallback);var t=n.clientHeight,r=n.scrollHeight-t,s=Math.min(Math.max(e-t/4,0),r),a=function(){var e=n.scrollTop,t=s-e;3<Math.abs(t)?(n.scrollTop+=t/3,o.animateCallback=i,o.animateTimeout=setTimeout(a,50)):(i&&i(!0),n.scrollTop=s,delete o.animateTimeout,delete o.animateCallback)};a()}else i&&i(!1)},_createFrame:function(){this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer";var t=this;function i(e){t._onEvent&&t._onEvent(e)}if(this.frame.onclick=function(e){var t=e.target;i(e),"BUTTON"==t.nodeName&&e.preventDefault()},this.frame.oninput=i,this.frame.onchange=i,this.frame.onkeydown=i,this.frame.onkeyup=i,this.frame.oncut=i,this.frame.onpaste=i,this.frame.onmousedown=i,this.frame.onmouseup=i,this.frame.onmouseover=i,this.frame.onmouseout=i,u.addEventListener(this.frame,"focus",i,!0),u.addEventListener(this.frame,"blur",i,!0),this.frame.onfocusin=i,this.frame.onfocusout=i,this.options.mainMenuBar){u.addClassName(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var e=document.createElement("button");e.type="button",e.className="jsoneditor-expand-all",e.title=m("expandAll"),e.onclick=function(){t.expandAll()},this.menu.appendChild(e);var n=document.createElement("button");if(n.type="button",n.title=m("collapseAll"),n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n),this.options.enableSort){var o=document.createElement("button");o.type="button",o.className="jsoneditor-sort",o.title=m("sortTitleShort"),o.onclick=function(){var e=t.options.modalAnchor||y;p(t.node,e)},this.menu.appendChild(o)}if(this.options.enableTransform){var r=document.createElement("button");r.type="button",r.title=m("transformTitleShort"),r.className="jsoneditor-transform",r.onclick=function(){var e=t.options.modalAnchor||y;f(t.node,e)},this.menu.appendChild(r)}if(this.history){var s=document.createElement("button");s.type="button",s.className="jsoneditor-undo jsoneditor-separator",s.title=m("undo"),s.onclick=function(){t._onUndo()},this.menu.appendChild(s),this.dom.undo=s;var a=document.createElement("button");a.type="button",a.className="jsoneditor-redo",a.title=m("redo"),a.onclick=function(){t._onRedo()},this.menu.appendChild(a),this.dom.redo=a,this.history.onChange=function(){s.disabled=!t.history.canUndo(),a.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var l=this;this.modeSwitcher=new d(this.menu,this.options.modes,this.options.mode,function(e){l.setMode(e),l.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new c(this,this.menu))}this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new h(this.navBar,this.frame),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},_onUndo:function(){this.history&&(this.history.undo(),this._onChange())},_onRedo:function(){this.history&&(this.history.redo(),this._onChange())},_onEvent:function(e){if(!l.targetIsColorPicker(e.target)){var t=l.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target)),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),t&&this.options&&this.options.navigationBar&&t&&("keydown"===e.type||"mousedown"===e.type)){var i=this;setTimeout(function(){i._updateTreePath(t.getNodePath())})}if(t&&t.selected){if("click"===e.type){if(e.target===t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&l.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&u.hasParentNode(e.target,this.content)&&(this.deselect(),t&&e.target===t.dom.drag?l.onDragStart(t,e):t&&(e.target===t.dom.field||e.target===t.dom.value||e.target===t.dom.select)||this._onMultiSelectStart(e));t&&t.onEvent(e)}},_updateTreePath:function(e){if(e&&e.length){u.removeClassName(this.navBar,"nav-bar-empty");var i=[];e.forEach(function(e){var t={name:n(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:n(e),node:e})}),i.push(t)}),this.treePath.setPath(i)}else u.addClassName(this.navBar,"nav-bar-empty");function n(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.type}},_onTreePathSectionSelected:function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},_onTreePathMenuItemSelected:function(e,t){if(e&&e.children.length){var i=e.children.find(function(e){return e.name===t});i&&i.node&&(this._updateTreePath(i.node.getNodePath()),i.node.expandTo(),i.node.focus())}},_startDragDistance:function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},_updateDragDistance:function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},_onMultiSelectStart:function(e){var t=l.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var i=this;this.mousemove||(this.mousemove=u.addEventListener(window,"mousemove",function(e){i._onMultiSelect(e)})),this.mouseup||(this.mouseup=u.addEventListener(window,"mouseup",function(e){i._onMultiSelectEnd(e)})),e.preventDefault()}},_onMultiSelect:function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=l.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start;if(i&&n){if(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.multiselection.nodes&&this.multiselection.nodes.length){var o=this.multiselection.nodes[0];this.multiselection.start===o||this.multiselection.start.isDescendantOf(o)?this.multiselection.direction="down":this.multiselection.direction="up"}this.select(this.multiselection.nodes)}}},_onMultiSelectEnd:function(){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(u.removeEventListener(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(u.removeEventListener(window,"mouseup",this.mouseup),delete this.mouseup)},deselect:function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},select:function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];if(e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler){var i=this.getSelection();this._selectionChangedHandler(i.start,i.end)}}},_findTopLevelNodes:function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),o=0;o<i.length&&i[o]===n[o];)o++;var r=i[o-1],s=i[o],a=n[o];if(s&&a||(r.parent?r=(a=s=r).parent:(s=r.childs[0],a=r.childs[r.childs.length-1])),r&&s&&a){var l=r.childs.indexOf(s),c=r.childs.indexOf(a),h=Math.min(l,c),d=Math.max(l,c);return r.childs.slice(h,d+1)}return[]},_showAutoComplete:function(t){var i=l.getNodeFromTarget(t),n="";0<=event.target.className.indexOf("jsoneditor-value")&&(n="value"),0<=event.target.className.indexOf("jsoneditor-field")&&(n="field");var o=this;setTimeout(function(){if("focus"===o.options.autocomplete.trigger||0<t.innerText.length){var e=o.options.autocomplete.getOptions(t.innerText,i.getPath(),n,i.editor);null===e?o.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?o.autocomplete.hideDropDown():e.options?o.autocomplete.show(t,e.startFrom,e.options):o.autocomplete.show(t,0,e)}.bind(o)):e.options?o.autocomplete.show(t,e.startFrom,e.options):o.autocomplete.show(t,0,e)}else o.autocomplete.hideDropDown()},50)},_onKeyDown:function(e){var t=e.which||e.keyCode,i=e.altKey,n=e.ctrlKey,o=e.metaKey,r=e.shiftKey,s=!1;if(9==t){var a=this;setTimeout(function(){u.selectContentEditable(a.focusTarget)},0)}if(this.searchBox)if(n&&70==t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),s=!0;else if(114==t||n&&71==t){r?this.searchBox.previous(!0):this.searchBox.next(!0),s=!0}if(this.history&&(n&&!r&&90==t?(this._onUndo(),s=!0):n&&r&&90==t&&(this._onRedo(),s=!0)),this.options.autocomplete&&!s&&!(n||i||o||1!=e.key.length&&8!=t&&46!=t)){s=!1;l.getNodeFromTarget(e.target);this._showAutoComplete(e.target)}s&&(e.preventDefault(),e.stopPropagation())},_createTable:function(){var e;this.options.navigationBar&&u.addClassName(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},showContextMenu:function(e,t){var i=[],n=this.multiselection.nodes.slice();if(i.push({text:m("duplicateText"),title:m("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){l.onDuplicate(n)}}),i.push({text:m("remove"),title:m("removeTitle"),className:"jsoneditor-remove",click:function(){l.onRemove(n)}}),this.options.onCreateMenu){var o=n.map(function(e){return e.getPath()});i=this.options.onCreateMenu(i,{type:"multiple",path:o[0],paths:o})}new s(i,{close:t}).show(e,this.frame)},getSelection:function(){var e={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var t=this.multiselection.nodes[0],i=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(e.start=t.serialize(),e.end=i.serialize()):(e.start=i.serialize(),e.end=t.serialize())}return e},onSelectionChange:function(e){"function"==typeof e&&(this._selectionChangedHandler=u.debounce(e,this.DEBOUNCE_INTERVAL))},setSelection:function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));var i=this._getNodeInstancesByRange(e,t);i.forEach(function(e){e.expandTo()}),this.select(i)},_getNodeInstancesByRange:function(e,t){var i,n;e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var o=[];if(i instanceof l)if(n instanceof l&&n!==i)if(i.parent===n.parent){t=i.getIndex()<n.getIndex()?(e=i,n):(e=n,i);var r=e;for(o.push(r);r=r.nextSibling(),o.push(r),r&&r!==t;);}else o=this._findTopLevelNodes(i,n);else o.push(i);return o},getNodesByRange:function(e,t){var i=this._getNodeInstancesByRange(e,t),n=[];return i.forEach(function(e){n.push(e.serialize())}),n}};e.exports=[{mode:"tree",mixin:b,data:"json"},{mode:"view",mixin:b,data:"json"},{mode:"form",mixin:b,data:"json"}]},function(e,t,i){"use strict";function n(){this.locked=!1}n.prototype.highlight=function(e){this.locked||(this.node!=e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())},n.prototype.unhighlight=function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},n.prototype._cancelUnhighlight=function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)},n.prototype.lock=function(){this.locked=!0},n.prototype.unlock=function(){this.locked=!1},e.exports=n},function(e,t,i){"use strict";var s=i(1);function n(t){function r(e){return t.node.findNodeByInternalPath(e)}this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){r(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){r(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){r(e.path).updateValue(e.oldValue)},redo:function(e){r(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){r(e.path).changeType(e.oldType)},redo:function(e){r(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),i=r(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,i)})}},insertAfterNodes:{undo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=r(e.parentPath),i=r(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,i),i=e})}},removeNodes:{undo:function(e){var t=r(e.parentPath),i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){var t=r(e.parentPath);e.paths.map(r).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=r(e.parentPath);e.clonePaths.map(r).forEach(function(e){t.removeChild(e)})},redo:function(e){var n=r(e.parentPath),o=r(e.afterPath);e.paths.map(r).forEach(function(e){var t=e.clone();if("object"===n.type){var i=n.getFieldNames();t.field=s.findUniqueName(e.field,i)}n.insertAfter(t,o),o=t})}},moveNodes:{undo:function(i){var n=r(i.oldParentPath),e=r(i.newParentPath),o=n.childs[i.oldIndex]||n.append;e.childs.slice(i.newIndex,i.newIndex+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,o)}),null===i.newParentPathRedo&&(i.newParentPathRedo=e.getInternalPath())},redo:function(i){var e=r(i.oldParentPathRedo),n=r(i.newParentPathRedo),o=n.childs[i.newIndexRedo]||n.append;e.childs.slice(i.oldIndexRedo,i.oldIndexRedo+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,o)})}},sort:{undo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=r(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){r(e.path).setInternalValue(e.oldValue)},redo:function(e){r(e.path).setInternalValue(e.newValue)}}}}n.prototype.onChange=function(){},n.prototype.add=function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()},n.prototype.clear=function(){this.history=[],this.index=-1,this.onChange()},n.prototype.canUndo=function(){return 0<=this.index},n.prototype.canRedo=function(){return this.index<this.history.length-1},n.prototype.undo=function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}},n.prototype.redo=function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}},n.prototype.destroy=function(){this.editor=null,this.history=[],this.index=-1},e.exports=n},function(e,t,i){var n,o=((n={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,o,r,s){var a=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[a-1];case 13:this.$={};break;case 14:this.$=r[a-1];break;case 15:this.$=[r[a-2],r[a]];break;case 16:this.$={},this.$[r[a][0]]=r[a][1];break;case 17:this.$=r[a-2],r[a-2][r[a][0]]=r[a][1];break;case 18:this.$=[];break;case 19:this.$=r[a-1];break;case 20:this.$=[r[a]];break;case 21:this.$=r[a-2],r[a-2].push(r[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){var t=this,i=[0],n=[null],o=[],r=this.table,s="",a=0,l=0,c=0;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var h=this.lexer.yylloc;function d(){var e;return"number"!=typeof(e=t.lexer.lex()||1)&&(e=t.symbols_[e]||e),e}o.push(h),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var u,p,f,m,g,v,y,b,x,w,_={};;){if(f=i[i.length-1],void 0===(m=this.defaultActions[f]?this.defaultActions[f]:(null==u&&(u=d()),r[f]&&r[f][u]))||!m.length||!m[0]){if(!c){for(v in x=[],r[f])this.terminals_[v]&&2<v&&x.push("'"+this.terminals_[v]+"'");var C="";C=this.lexer.showPosition?"Parse error on line "+(a+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+x.join(", ")+", got '"+this.terminals_[u]+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==u?"end of input":"'"+(this.terminals_[u]||u)+"'"),this.parseError(C,{text:this.lexer.match,token:this.terminals_[u]||u,line:this.lexer.yylineno,loc:h,expected:x})}if(3==c){if(1==u)throw new Error(C||"Parsing halted.");l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,u=d()}for(;!(2..toString()in r[f]);){if(0==f)throw new Error(C||"Parsing halted.");w=1,i.length=i.length-2*w,n.length=n.length-w,o.length=o.length-w,f=i[i.length-1]}p=u,u=2,m=r[f=i[i.length-1]]&&r[f][2],c=3}if(m[0]instanceof Array&&1<m.length)throw new Error("Parse Error: multiple actions possible at state: "+f+", token: "+u);switch(m[0]){case 1:i.push(u),n.push(this.lexer.yytext),o.push(this.lexer.yylloc),i.push(m[1]),u=null,p?(u=p,p=null):(l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,0<c&&c--);break;case 2:if(y=this.productions_[m[1]][1],_.$=n[n.length-y],_._$={first_line:o[o.length-(y||1)].first_line,last_line:o[o.length-1].last_line,first_column:o[o.length-(y||1)].first_column,last_column:o[o.length-1].last_column},void 0!==(g=this.performAction.call(_,s,l,a,this.yy,m[1],n,o)))return g;y&&(i=i.slice(0,-1*y*2),n=n.slice(0,-1*y),o=o.slice(0,-1*y)),i.push(this.productions_[m[1]][0]),n.push(_.$),o.push(_._$),b=r[i[i.length-2]][i[i.length-1]],i.push(b);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;var e,t,i,n,o;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var r=this._currentRules(),s=0;s<r.length&&(!(i=this._input.match(this.rules[r[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?((o=t[0].match(/\n.*/g))&&(this.yylineno+=o.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:o?o[o.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,r[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,i,n){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}},n);t.parser=o,t.parse=o.parse.bind(o)},function(e,t,i){"use strict";var b={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},x="a".charCodeAt();t.parse=function(o){var n={},e=0,t=0,r=0;return{data:s("",!0),pointers:n};function s(e,t){var i;a(),p(e,"value");var n=h();switch(n){case"t":c("rue"),i=!0;break;case"f":c("alse"),i=!1;break;case"n":c("ull"),i=null;break;case'"':i=l();break;case"[":i=function(e){a();var t=[],i=0;if("]"==h())return t;d();for(;;){var n=e+"/"+i;t.push(s(n)),a();var o=h();if("]"==o)break;","!=o&&v(),a(),i++}return t}(e);break;case"{":i=function(e){a();var t={};if("}"==h())return t;d();for(;;){var i=m();'"'!=h()&&v();var n=l(),o=e+"/"+w(n);f(o,"key",i),p(o,"keyEnd"),a(),":"!=h()&&v(),a(),t[n]=s(o),a();var r=h();if("}"==r)break;","!=r&&v(),a()}return t}(e);break;default:d(),0<="-0123456789".indexOf(n)?i=function(){var e="";"-"==o[r]&&(e+=h());e+="0"==o[r]?h():u(),"."==o[r]&&(e+=h()+u());"e"!=o[r]&&"E"!=o[r]||(e+=h(),"+"!=o[r]&&"-"!=o[r]||(e+=h()),e+=u());return+e}():g()}return p(e,"valueEnd"),a(),t&&r<o.length&&g(),i}function a(){e:for(;r<o.length;){switch(o[r]){case" ":t++;break;case"\t":t+=4;break;case"\r":t=0;break;case"\n":t=0,e++;break;default:break e}r++}}function l(){for(var e,t="";'"'!=(e=h());)"\\"==e?(e=h())in b?t+=b[e]:"u"==e?t+=i():v():t+=e;return t}function c(e){for(var t=0;t<e.length;t++)h()!==e[t]&&v()}function h(){y();var e=o[r];return r++,t++,e}function d(){r--,t--}function i(){for(var e=4,t=0;e--;){t<<=4;var i=h().toLowerCase();"a"<=i&&i<="f"?t+=i.charCodeAt()-x+10:"0"<=i&&i<="9"?t+=+i:v()}return String.fromCharCode(t)}function u(){for(var e="";"0"<=o[r]&&o[r]<="9";)e+=h();if(e.length)return e;y(),g()}function p(e,t){f(e,t,m())}function f(e,t,i){n[e]=n[e]||{},n[e][t]=i}function m(){return{line:e,column:t,pos:r}}function g(){throw new SyntaxError("Unexpected token "+o[r]+" in JSON at position "+r)}function v(){d(),g()}function y(){if(r>=o.length)throw new SyntaxError("Unexpected end of JSON input")}},t.stringify=function(e,t,h){if(v(e)){var i,n,o=0;switch(typeof h){case"number":var r=10<h?10:h<0?0:Math.floor(h);h=r&&g(r," "),n=i=r;break;case"string":h=h.slice(0,10);for(var s=n=i=0;s<h.length;s++){switch(h[s]){case" ":n++;break;case"\t":n+=4;break;case"\r":n=0;break;case"\n":n=0,o++;break;default:throw new Error("whitespace characters not allowed in JSON")}i++}break;default:h=void 0}var a="",l={},c=0,d=0,u=0;return function s(a,l,c){m(c,"value");switch(typeof a){case"number":case"boolean":p(""+a);break;case"string":p(y(a));break;case"object":null===a?p("null"):"function"==typeof a.toJSON?p(y(a.toJSON())):Array.isArray(a)?e():t()}m(c,"valueEnd");function e(){if(a.length){p("[");for(var e=l+1,t=0;t<a.length;t++){t&&p(","),f(e);var i=v(a[t])?a[t]:null,n=c+"/"+t;s(i,e,n)}f(l),p("]")}else p("[]")}function t(){var e=Object.keys(a);if(e.length){p("{");for(var t=l+1,i=0;i<e.length;i++){var n=e[i],o=a[n];if(v(o)){i&&p(",");var r=c+"/"+w(n);f(t),m(r,"key"),p(y(n)),m(r,"keyEnd"),p(":"),h&&p(" "),s(o,t,r)}}f(l),p("}")}else p("{}")}}(e,0,""),{json:a,pointers:l}}function p(e){d+=e.length,u+=e.length,a+=e}function f(e){if(h){for(a+="\n"+g(e,h),c++,d=0;e--;)o?(c+=o,d=n):d+=n,u+=i;u+=1}}function m(e,t){l[e]=l[e]||{},l[e][t]={line:c,column:d,pos:u}}function g(e,t){return Array(e+1).join(t)}};var n=["number","boolean","string","object"];function v(e){return 0<=n.indexOf(typeof e)}var o=/"|\\/g,r=/[\b]/g,s=/\f/g,a=/\n/g,l=/\r/g,c=/\t/g;function y(e){return'"'+(e=e.replace(o,"\\$&").replace(s,"\\f").replace(r,"\\b").replace(a,"\\n").replace(l,"\\r").replace(c,"\\t"))+'"'}var h=/~/g,d=/\//g;function w(e){return e.replace(h,"~0").replace(d,"~1")}},function(e,t,i){"use strict";function n(e,t){var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.dom={},this.dom.container=t;var n=document.createElement("table");(this.dom.table=n).className="jsoneditor-search",t.appendChild(n);var o=document.createElement("tbody");this.dom.tbody=o,n.appendChild(o);var r=document.createElement("tr");o.appendChild(r);var s=document.createElement("td");r.appendChild(s);var a=document.createElement("div");(this.dom.results=a).className="jsoneditor-results",s.appendChild(a),s=document.createElement("td"),r.appendChild(s);var l=document.createElement("div");(this.dom.input=l).className="jsoneditor-frame",l.title="Search fields and values",s.appendChild(l);var c=document.createElement("table");l.appendChild(c);var h=document.createElement("tbody");c.appendChild(h),r=document.createElement("tr"),h.appendChild(r);var d=document.createElement("button");d.type="button",d.className="jsoneditor-refresh",(s=document.createElement("td")).appendChild(d),r.appendChild(s);var u=document.createElement("input");(this.dom.search=u).oninput=function(e){i._onDelayedSearch(e)},u.onchange=function(e){i._onSearch()},u.onkeydown=function(e){i._onKeyDown(e)},u.onkeyup=function(e){i._onKeyUp(e)},d.onclick=function(e){u.select()},(s=document.createElement("td")).appendChild(u),r.appendChild(s);var p=document.createElement("button");p.type="button",p.title="Next result (Enter)",p.className="jsoneditor-next",p.onclick=function(){i.next()},(s=document.createElement("td")).appendChild(p),r.appendChild(s);var f=document.createElement("button");f.type="button",f.title="Previous result (Shift+Enter)",f.className="jsoneditor-previous",f.onclick=function(){i.previous()},(s=document.createElement("td")).appendChild(f),r.appendChild(s)}n.prototype.next=function(e){if(null!=this.results){var t=null!=this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}},n.prototype.previous=function(e){if(null!=this.results){var t=this.results.length-1,i=null!=this.resultIndex?this.resultIndex-1:t;i<0&&(i=t),this._setActiveResult(i,e)}},n.prototype._setActiveResult=function(e,t){if(this.activeResult){var i=this.activeResult.node;"field"==this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,o=this.results[this.resultIndex].elem;"field"==o?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(o)})},n.prototype._clearDelay=function(){null!=this.timeout&&(clearTimeout(this.timeout),delete this.timeout)},n.prototype._onDelayedSearch=function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)},n.prototype._onSearch=function(e){this._clearDelay();var t=this.dom.search.value,i=0<t.length?t:void 0;if(i!==this.lastText||e){this.lastText=i,this.results=this.editor.search(i);var n=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,o=0;if(this.activeResult)for(var r=0;r<this.results.length;r++)if(this.results[r].node===this.activeResult.node){o=r;break}if(this._setActiveResult(o,!1),void 0!==i){var s=this.results.length;this.dom.results.innerHTML=0===s?"no&nbsp;results":1===s?"1&nbsp;result":n<s?n+"+&nbsp;results":s+"&nbsp;results"}else this.dom.results.innerHTML=""}},n.prototype._onKeyDown=function(e){var t=e.which;27==t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13==t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())},n.prototype._onKeyUp=function(e){var t=e.keyCode;27!=t&&13!=t&&this._onDelayedSearch(e)},n.prototype.clear=function(){this.dom.search.value="",this._onSearch()},n.prototype.forceSearch=function(){this._onSearch(!0)},n.prototype.isEmpty=function(){return""===this.dom.search.value},n.prototype.destroy=function(){this.editor=null,this.dom.container.removeChild(this.dom.table),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()},e.exports=n},function(e,t,i){"use strict";var l=i(2),n=i(0).translate,c=i(1);function o(e,t){e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked,e.appendChild(this.path),this.reset())}o.prototype.reset=function(){this.path.innerHTML=n("selectNode")},o.prototype.setPath=function(s){var a=this;this.path.innerHTML="",s&&s.length&&s.forEach(function(i,n){var e,t=document.createElement("span");if(t.className="jsoneditor-treepath-element",t.innerText=i.name,t.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(a,i),a.path.appendChild(t),i.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.innerHTML="&#9658;",e.onclick=function(){a.contentMenuClicked=!0;var t=[];i.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(s[n+1]+1&&s[n+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(a,i,e.name)})}),new l(t).show(e,a.root,!0)},a.path.appendChild(e)),n===s.length-1){var o=(e||t).getBoundingClientRect().right;if(a.path.offsetWidth<o&&(a.path.scrollLeft=o),a.path.scrollLeft){var r=document.createElement("span");r.className="jsoneditor-treepath-show-all-btn",r.title="show all path",r.innerHTML="...",r.onclick=function(e){a.contentMenuClicked=!1,c.addClassName(a.path,"show-all"),a.path.style.width=a.path.parentNode.getBoundingClientRect().width-10+"px",a.path.onblur=function(){if(a.contentMenuClicked)return a.contentMenuClicked=!1,void a.path.focus();c.removeClassName(a.path,"show-all"),a.path.onblur=void 0,a.path.style.width="",a.setPath(e)}}.bind(a,s),a.path.insertBefore(r,a.path.firstChild)}}})},o.prototype.onSectionSelected=function(e){"function"==typeof e&&(this.selectionCallback=e)},o.prototype.onContextMenuItemSelected=function(e){"function"==typeof e&&(this.contextMenuCallback=e)},e.exports=o},function(e,t,i){"use strict";var r=i(7),l=i(24),n=i(6).createAbsoluteAnchor,c=i(2),o=i(25),s=i(26),h=i(8),d=i(10),A=i(1),u=i(0).translate,p=document.body;function D(e,t){this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=A.debounce(this._onChangeValue.bind(this),D.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=A.debounce(this._onChangeField.bind(this),D.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}D.prototype.DEBOUNCE_INTERVAL=150,D.prototype.MAX_SEARCH_RESULTS=999;function f(e){return e.getInternalPath()}function R(e){return e.getField()}D.prototype.getMaxVisibleChilds=function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:100},D.prototype._updateEditability=function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}},D.prototype.getPath=function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t},D.prototype.getInternalPath=function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t},D.prototype.getName=function(){return this.parent?"array"!=this.parent.type?this.field:this.index:void 0},D.prototype.findNodeByPath=function(e){if(e){if(0==e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}},D.prototype.findNodeByInternalPath=function(e){if(e){for(var t=this,i=0;i<e.length&&t;i++){var n=e[i];t=t.childs[n]}return t}},D.prototype.serialize=function(){return{value:this.getValue(),path:this.getPath()}},D.prototype.findNode=function(e){for(var t=A.parsePath(e),i=this;i&&0<t.length;){var n=t.shift();if("number"==typeof n){if("array"!==i.type)throw new Error("Cannot get child node at index "+n+": node is no array");i=i.childs[n]}else{if("object"!==i.type)throw new Error("Cannot get child node "+n+": node is no object");i=i.childs.filter(function(e){return e.field===n})[0]}}return i},D.prototype.findParents=function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e},D.prototype.setError=function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()},D.prototype.updateError=function(){var e=this.fieldError||this.valueError||this.error,t=this.dom.tdError;if(e&&this.dom&&this.dom.tr){A.addClassName(this.dom.tr,"jsoneditor-validation-error"),t||(t=document.createElement("td"),this.dom.tdError=t,this.dom.tdValue.parentNode.appendChild(t));var r=document.createElement("div");r.className="jsoneditor-popover jsoneditor-right",r.appendChild(document.createTextNode(e.message));var i=document.createElement("button");i.type="button",i.className="jsoneditor-button jsoneditor-schema-error",i.appendChild(r),i.onmouseover=i.onfocus=function(){for(var e=["right","above","below","left"],t=0;t<e.length;t++){var i=e[t];r.className="jsoneditor-popover jsoneditor-"+i;var n=this.editor.content.getBoundingClientRect(),o=r.getBoundingClientRect();if(A.insideRect(n,o,20))break}}.bind(this);var n=this.errorChild;for(n&&(i.onclick=function(){n.findParents().forEach(function(e){e.expand(!1)}),n.scrollTo(function(){n.focus()})});t.firstChild;)t.removeChild(t.firstChild);t.appendChild(i)}else this.dom.tr&&A.removeClassName(this.dom.tr,"jsoneditor-validation-error"),t&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)},D.prototype.getIndex=function(){if(this.parent){var e=this.parent.childs.indexOf(this);return-1!==e?e:null}return-1},D.prototype.setParent=function(e){this.parent=e},D.prototype.setField=function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t},D.prototype.getField=function(){return void 0===this.field&&this._getDomField(),this.field},D.prototype.setValue=function(e,t){var i,n,o,r,s,a=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),r=0;r<e.length;r++)void 0===(i=e[r])||i instanceof Function||(r<this.childs.length?((n=this.childs[r]).fieldEditable=!1,n.index=r,n.setValue(i)):(n=new D(this.editor,{value:i}),o=r<this.getMaxVisibleChilds(),this.appendChild(n,o,!1)));for(s=this.childs.length;s>=e.length;s--)this.removeChild(this.childs[s],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),s=this.childs.length-1;0<=s;s--)e.hasOwnProperty(this.childs[s].field)||this.removeChild(this.childs[s],!1);for(var l in r=0,e)e.hasOwnProperty(l)&&(void 0===(i=e[l])||i instanceof Function||((n=this.findChildByProperty(l))?(n.setField(l,!0),n.setValue(i)):(n=new D(this.editor,{field:l,value:i}),o=r<this.getMaxVisibleChilds(),this.appendChild(n,o,!1))),r++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc")}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(a)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value},D.prototype.setInternalValue=function(e){var t,i,n,o,r,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?((i=this.childs[o]).fieldEditable=!1,i.index=o,i.setInternalValue(t)):(i=new D(this.editor,{internalValue:t}),n=o<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),o=0;o<e.childs.length;o++)void 0===(t=e.childs[o])||t instanceof Function||(o<this.childs.length?(delete(i=this.childs[o]).index,i.setField(t.field,!0),i.setInternalValue(t.value)):(i=new D(this.editor,{field:t.field,internalValue:t.value}),n=o<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(r=this.childs.length;r>=e.childs.length;r--)this.removeChild(this.childs[r],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value},D.prototype.recreateDom=function(){if(this.dom&&this.dom.tr&&this.dom.tr.parentNode){var e=this._detachFromDom();this.clearDom(),this._attachToDom(e)}else this.clearDom()},D.prototype.getValue=function(){if("array"==this.type){var t=[];return this.childs.forEach(function(e){t.push(e.getValue())}),t}if("object"!=this.type)return void 0===this.value&&this._getDomValue(),this.value;var i={};return this.childs.forEach(function(e){i[e.getField()]=e.getValue()}),i},D.prototype.getInternalValue=function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})},D.prototype.getLevel=function(){return this.parent?this.parent.getLevel()+1:0},D.prototype.getNodePath=function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e},D.prototype.clone=function(){var i=new D(this.editor);if(i.type=this.type,i.field=this.field,i.fieldInnerText=this.fieldInnerText,i.fieldEditable=this.fieldEditable,i.previousField=this.previousField,i.value=this.value,i.valueInnerText=this.valueInnerText,i.previousValue=this.previousValue,i.expanded=this.expanded,i.visibleChilds=this.visibleChilds,this.childs){var n=[];this.childs.forEach(function(e){var t=e.clone();t.setParent(i),n.push(t)}),i.childs=n}else i.childs=void 0;return i},D.prototype.expand=function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}))},D.prototype.collapse=function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1)},D.prototype.showChilds=function(){if(this.childs&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){var i=this.getAppendDom();if(!i.parentNode)(o=e.nextSibling)?t.insertBefore(i,o):t.appendChild(i);for(var n=Math.min(this.childs.length,this.visibleChilds),o=this._getNextTr(),r=0;r<n;r++){var s=this.childs[r];s.getDom().parentNode||t.insertBefore(s.getDom(),o),s.showChilds()}var a=this.getShowMoreDom();o=this._getNextTr();a.parentNode||t.insertBefore(a,o),this.showMore.updateDom()}}},D.prototype._getNextTr=function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0},D.prototype.hide=function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.hideChilds(e)},D.prototype.hideChilds=function(e){if(this.childs&&this.expanded){var t=this.getAppendDom();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()});var i=this.getShowMoreDom();i.parentNode&&i.parentNode.removeChild(i),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds())}},D.prototype._updateCssClassName=function(){if(this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree){A.removeAllClassNames(this.dom.tree);var e=this.editor.options.onClassName({path:this.getPath(),field:this.field,value:this.value})||"";A.addClassName(this.dom.tree,"jsoneditor-values "+e)}},D.prototype.recursivelyUpdateCssClassesOnNodes=function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()},D.prototype.expandTo=function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent},D.prototype.appendChild=function(e,t,i){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"==this.type,"array"==this.type&&(e.index=this.childs.length),"object"===this.type&&null==e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t){var n=e.getDom(),o=this._getNextTr(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds(),this.visibleChilds++}!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}},D.prototype.moveBefore=function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}if(e.parent&&e.parent.removeChild(e),t instanceof L||!t)if(this.childs.length+1>this.visibleChilds){var o=this.childs[this.visibleChilds-1];this.insertBefore(e,o)}else this.appendChild(e);else this.insertBefore(e,t);i&&i.removeChild(n)}},D.prototype.insertBefore=function(e,t){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&null==e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"==this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1==i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"==this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),o=t.getDom(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds(),this.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},D.prototype.insertAfter=function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}},D.prototype.search=function(t,i){Array.isArray(i)||(i=[]);var e=t?t.toLowerCase():void 0;delete this.searchField,delete this.searchValue,void 0!==this.field&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField());this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,i)}):void 0!==this.value&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,i.push({node:this,elem:"value"})),this._updateDomValue());return i},D.prototype.scrollTo=function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)},D.prototype.expandPathToNode=function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}},D.focusElement=void 0,D.prototype.focus=function(e){if(D.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),A.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),A.selectContentEditable(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),A.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),A.selectContentEditable(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),A.selectContentEditable(t.value)):t.field&&this.fieldEditable?(t.field.focus(),A.selectContentEditable(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}},D.select=function(e){setTimeout(function(){A.selectContentEditable(e)},0)},
D.prototype.containsNode=function(e){if(this==e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1},D.prototype.removeChild=function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i){i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(i,1)[0];return n.parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),n}}},D.prototype._remove=function(e){this.removeChild(e)},D.prototype.changeType=function(e){var t=this.type;if(t!=e){if("string"!=e&&"auto"!=e||"string"!=t&&"auto"!=t){var i=this._detachFromDom();this.clearDom(),"object"==(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,null==e.field&&(e.field="")}),"string"!=t&&"auto"!=t||(this.expanded=!0)):"array"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!=t&&"auto"!=t||(this.expanded=!0)):this.expanded=!1,this._attachToDom(i)}else this.type=e;"auto"!=e&&"string"!=e||(this.value="string"==e?String(this.value):this._stringCast(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}},D.prototype.deepEqual=function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!=typeof e||!e)return!1;var i={},n=0;for(t=0;t<this.childs.length;t++){var o=this.childs[t];if(!i[o.field]){if(i[o.field]=!0,n++,!(o.field in e))return!1;if(!o.deepEqual(e[o.field]))return!1}}if(n!==Object.keys(e).length)return!1}else if(this.value!==e)return!1;return!0},D.prototype._getDomValue=function(){if(this._clearValueError(),this.dom.value&&"array"!=this.type&&"object"!=this.type&&(this.valueInnerText=A.getInnerText(this.dom.value)),null!=this.valueInnerText)try{var e;if("string"==this.type)e=this._unescapeHTML(this.valueInnerText);else{var t=this._unescapeHTML(this.valueInnerText);e=this._stringCast(t)}e!==this.value&&(this.value=e,this._debouncedOnChangeValue())}catch(e){this._setValueError(u("cannotParseValueError"))}},D.prototype._setValueError=function(e){this.valueError={message:e},this.updateError()},D.prototype._clearValueError=function(){this.valueError&&(this.valueError=null,this.updateError())},D.prototype._setFieldError=function(e){this.fieldError={message:e},this.updateError()},D.prototype._clearFieldError=function(){this.fieldError&&(this.fieldError=null,this.updateError())},D.prototype._onChangeValue=function(){var e=this.editor.getDomSelection();if(e.range){var t=A.textDiff(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getDomSelection();if(i.range){var n=A.textDiff(String(this.previousValue),String(this.value));i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:i}),this.previousValue=this.value},D.prototype._onChangeField=function(){var e=this.editor.getDomSelection(),t=this.previousField||"";if(e.range){var i=A.textDiff(this.field,t);e.range.startOffset=i.start,e.range.endOffset=i.end}var n=this.editor.getDomSelection();if(n.range){var o=A.textDiff(t,this.field);n.range.startOffset=o.start,n.range.endOffset=o.end}this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field},D.prototype._updateDomValue=function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"==this.type?A.type(i):this.type,o="string"==n&&A.isUrl(i);if(t.push("jsoneditor-"+n),o&&t.push("jsoneditor-url"),""==String(this.value)&&"array"!=this.type&&"object"!=this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"==n||"object"==n){var r=this.childs?this.childs.length:0;e.title=this.type+" containing "+r+" items"}else o&&this.editable.value?e.title=u("openUrl"):e.title="";if("boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value==this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||this.schema.hasOwnProperty("oneOf")||this.schema.hasOwnProperty("anyOf")||this.schema.hasOwnProperty("allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);this.editable.value&&this.editor.options.colorPicker&&"string"==typeof i&&A.isValidColor(i)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue),this.dom.value.style.color="#1A1A1A"),this.dom.color.style.backgroundColor=i):this._deleteDomColor(),this.editor.options.timestampTag&&"number"==typeof i&&9466848e5<i&&!isNaN(new Date(i).valueOf())?(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),this.dom.date.innerHTML=new Date(i).toISOString(),this.dom.date.title=new Date(i).toString()):this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date),A.stripFormatting(e),this._updateDomDefault()}},D.prototype._deleteDomColor=function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,this.dom.value.style.color="")},D.prototype._updateDomField=function(){var e=this.dom.field;if(e){var t=A.makeFieldTooltip(this.schema,this.editor.options.language);t&&(e.title=t),""==String(this.field)&&"array"!=this.parent.type?A.addClassName(e,"jsoneditor-empty"):A.removeClassName(e,"jsoneditor-empty"),this.searchFieldActive?A.addClassName(e,"jsoneditor-highlight-active"):A.removeClassName(e,"jsoneditor-highlight-active"),this.searchField?A.addClassName(e,"jsoneditor-highlight"):A.removeClassName(e,"jsoneditor-highlight"),A.stripFormatting(e)}},D.prototype._getDomField=function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=A.getInnerText(this.dom.field)),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),i=this.parent.getFieldNames(this);-1!==i.indexOf(t)?e?(t=A.findUniqueName(t,i))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError(u("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError(u("cannotParseFieldError"))}},D.prototype._updateDomDefault=function(){if(this.schema&&void 0!==this.schema.default&&!this._hasChilds()){var e=this.dom.select?this.dom.select:this.dom.value;e&&(this.value===this.schema.default?(e.title=u("default"),A.addClassName(e,"jsoneditor-is-default"),A.removeClassName(e,"jsoneditor-is-not-default")):(e.removeAttribute("title"),A.removeClassName(e,"jsoneditor-is-default"),A.addClassName(e,"jsoneditor-is-not-default")))}},D.prototype.clearDom=function(){this.dom={}},D.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),"tree"===(e.tr.node=this).editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");i.type="button",(e.drag=i).className="jsoneditor-button jsoneditor-dragarea",i.title=u("drag"),t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),o=document.createElement("button");o.type="button",(e.menu=o).className="jsoneditor-button jsoneditor-contextmenu",o.title=u("actionsMenu"),n.appendChild(e.menu),e.tr.appendChild(n)}var r=document.createElement("td");return e.tr.appendChild(r),e.tree=this._createDomTree(),r.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr},D.prototype.isVisible=function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1},D.onDragStart=function(t,e){if(!Array.isArray(t))return D.onDragStart([t],e);if(0!==t.length){var i=t[0],n=t[t.length-1],o=i.parent,r=D.getNodeFromTarget(e.target),s=i.editor,a=A.getAbsoluteTop(r.dom.tr)-A.getAbsoluteTop(i.dom.tr);s.mousemove||(s.mousemove=A.addEventListener(window,"mousemove",function(e){D.onDrag(t,e)})),s.mouseup||(s.mouseup=A.addEventListener(window,"mouseup",function(e){D.onDragEnd(t,e)})),s.highlighter.lock(),s.drag={oldCursor:document.body.style.cursor,oldSelection:s.getDomSelection(),oldPaths:t.map(f),oldParent:o,oldNextNode:o.childs[n.getIndex()+1]||o.append,oldParentPathRedo:o.getInternalPath(),oldIndexRedo:i.getIndex(),mouseX:e.pageX,offsetY:a,level:i.getLevel()},document.body.style.cursor="move",e.preventDefault()}},D.onDrag=function(e,t){if(!Array.isArray(e))return D.onDrag([e],t);if(0!==e.length){var i,n,o,r,s,a,l,c,h,d,u,p,f,m,g=e[0].editor,v=t.pageY-g.drag.offsetY,y=t.pageX,b=!1,x=e[0];if(i=x.dom.tr,h=A.getAbsoluteTop(i),p=i.offsetHeight,v<h){for(n=i;n=n.previousSibling,l=D.getNodeFromTarget(n),d=n?A.getAbsoluteTop(n):0,n&&v<d;);l&&!l.parent&&(l=void 0),l||(n=(a=i.parentNode.firstChild)?a.nextSibling:void 0,(l=D.getNodeFromTarget(n))==x&&(l=void 0)),l&&l.isVisible()&&(d=(n=l.dom.tr)?A.getAbsoluteTop(n):0)+p<v&&(l=void 0),l&&(e.forEach(function(e){l.parent.moveBefore(e,l)}),b=!0)}else{var w=e[e.length-1];if(r=(s=w.expanded&&w.append?w.append.getDom():w.dom.tr)?s.nextSibling:void 0){for(u=A.getAbsoluteTop(r),o=r;c=D.getNodeFromTarget(o),o&&(f=o.nextSibling?A.getAbsoluteTop(o.nextSibling):0,m=o?f-u:0,c&&c.parent.childs.length==e.length&&c.parent.childs[e.length-1]==w&&(h+=27),o=o.nextSibling),o&&h+m<v;);if(c&&c.parent){var _=y-g.drag.mouseX,C=Math.round(_/24/2),E=g.drag.level+C,S=c.getLevel();for(n=c.dom.tr&&c.dom.tr.previousSibling;S<E&&n;){if(l=D.getNodeFromTarget(n),e.some(function(e){return e===l||l.isDescendantOf(e)}));else{if(!(l instanceof L))break;var N=l.parent.childs;if(N.length==e.length&&N[e.length-1]==w)break;S=(c=D.getNodeFromTarget(n)).getLevel()}n=n.previousSibling}c instanceof L&&!c.isVisible()&&c.parent.showMore.isVisible()&&(c=c._nextNode()),c&&c.dom.tr&&s.nextSibling!=c.dom.tr&&(e.forEach(function(e){c.parent.moveBefore(e,c)}),b=!0)}}}b&&(g.drag.mouseX=y,g.drag.level=x.getLevel()),g.startAutoScroll(v),t.preventDefault()}},D.onDragEnd=function(e,t){if(!Array.isArray(e))return D.onDrag([e],t);if(0!==e.length){var i=e[0],n=i.editor;e[0]&&e[0].dom.menu.focus();var o=n.drag.oldParent.getInternalPath(),r=i.parent.getInternalPath(),s=n.drag.oldParent===i.parent,a=n.drag.oldNextNode.getIndex(),l=i.getIndex(),c=n.drag.oldParentPathRedo,h=n.drag.oldIndexRedo,d=s&&h<l?l+e.length:l;s&&h===l||n._onAction("moveNodes",{count:e.length,fieldNames:e.map(R),oldParentPath:o,newParentPath:r,oldIndex:a,newIndex:l,oldIndexRedo:h,newIndexRedo:d,oldParentPathRedo:c,newParentPathRedo:null,oldSelection:n.drag.oldSelection,newSelection:n.getDomSelection()}),document.body.style.cursor=n.drag.oldCursor,n.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&n.highlighter.unhighlight()}),delete n.drag,n.mousemove&&(A.removeEventListener(window,"mousemove",n.mousemove),delete n.mousemove),n.mouseup&&(A.removeEventListener(window,"mouseup",n.mouseup),delete n.mouseup),n.stopAutoScroll(),t.preventDefault()}},D.prototype.isDescendantOf=function(e){for(var t=this.parent;t;){if(t==e)return!0;t=t.parent}return!1},D.prototype._createDomField=function(){return document.createElement("div")},D.prototype.setHighlight=function(t){this.dom.tr&&(t?A.addClassName(this.dom.tr,"jsoneditor-highlight"):A.removeClassName(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs&&this.childs.forEach(function(e){e.setHighlight(t)}))},D.prototype.setSelected=function(t,e){this.selected=t,this.dom.tr&&(t?A.addClassName(this.dom.tr,"jsoneditor-selected"):A.removeClassName(this.dom.tr,"jsoneditor-selected"),e?A.addClassName(this.dom.tr,"jsoneditor-first"):A.removeClassName(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs&&this.childs.forEach(function(e){e.setSelected(t)}))},D.prototype.updateValue=function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()},D.prototype.updateField=function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()},D.prototype.updateDom=function(t){var e=this.dom.tree;e&&(e.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){var n;if(this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):(i.contentEditable=!1,i.className="jsoneditor-readonly"),null!=this.index)n=this.index;else if(null!=this.field)n=this.field;else{var o=this.editor.options.schema?D._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0;n=o&&o.title?o.title:this._hasChilds()?this.type:""}i.innerHTML=this._escapeHTML(n),this._updateSchema()}var r=this.dom.value;r&&("array"==this.type?(this.updateNodeName(),A.addClassName(this.dom.tr,"jsoneditor-expandable")):"object"==this.type?(this.updateNodeName(),A.addClassName(this.dom.tr,"jsoneditor-expandable")):(r.innerHTML=this._escapeHTML(this.value),A.removeClassName(this.dom.tr,"jsoneditor-expandable"))),this._updateDomField(),this._updateDomValue(),this._updateCssClassName(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom()},D.prototype._updateSchema=function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?D._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=D._findEnum(this.schema):delete this.enum)},D._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(0<i.length)return i[0].enum}return null},D._findSchema=function(e,t,i){var n=e,o=n,r=e.oneOf||e.anyOf||e.allOf;r=r||[e];for(var s=0;s<r.length;s++){"$ref"in(n=r[s])&&"string"==typeof n.$ref&&(n=t[n.$ref])&&(o=D._findSchema(n,t,i));for(var a=0;a<i.length&&n;a++){var l=i.slice(a+1,i.length),c=i[a];if("string"!=typeof c||!n.patternProperties||n.properties&&c in n.properties)"string"==typeof c&&n.properties?c in n.properties?(n=n.properties[c])&&(o=D._findSchema(n,t,l)):o=null:"number"==typeof c&&n.items&&(n=n.items)&&(o=D._findSchema(n,t,l));else for(var h in n.patternProperties)c.match(h)&&(o=D._findSchema(n.patternProperties[h],t,l))}}return o===e&&0<i.length?null:o},D.prototype._updateDomIndexes=function(){var e=this.dom.value,t=this.childs;e&&t&&("array"==this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"==this.type&&t.forEach(function(e){null!=e.index&&(delete e.index,null==e.field&&(e.field=""))}))},D.prototype._createDomValue=function(){var e;return"array"==this.type?(e=document.createElement("div")).innerHTML="[...]":"object"==this.type?(e=document.createElement("div")).innerHTML="{...}":(!this.editable.value&&A.isUrl(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e},D.prototype._createDomExpandButton=function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=u("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e},D.prototype._createDomTree=function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.expand=this._createDomExpandButton(),o.appendChild(e.expand),e.tdExpand=o;var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.field=this._createDomField(),r.appendChild(e.field),e.tdField=r;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!=this.type&&"array"!=this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t},D.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,o=this,r=this._hasChilds();if("function"==typeof this.editor.options.onEvent&&this._onEvent(e),i!=n.drag&&i!=n.menu||("mouseover"==t?this.editor.highlighter.highlight(this):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var s=o.editor.highlighter;s.highlight(o),s.lock(),A.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){A.removeClassName(n.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"==t&&(i==n.expand||("view"===o.editor.options.mode||"form"===o.editor.options.mode)&&"DIV"===i.nodeName)&&r){var a=e.ctrlKey;this._onExpand(a)}"click"!==t||e.target!==o.dom.tdColor&&e.target!==o.dom.color||this._showColorPicker(),"change"==t&&i==n.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue(),this._updateDomDefault()),"change"==t&&i==n.select&&(this.dom.value.innerHTML=n.select.value,this._getDomValue(),this._updateDomValue());var l=n.value;if(i==l)switch(t){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue(),this.value&&(l.innerHTML=this._escapeHTML(this.value));break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&A.isUrl(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){o._getDomValue(),o._updateDomValue()},1)}var c=n.field;if(i==c)switch(t){case"blur":this._getDomField(!0),this._updateDomField(),this.field&&(c.innerHTML=this._escapeHTML(this.field));break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){o._getDomField(),o._updateDomField()},1)}var h=n.tree;h&&i==h.parentNode&&"click"==t&&!e.hasMoved&&((null!=e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<A.getAbsoluteLeft(n.tdSeparator))||r?c&&(A.setEndOfContentEditable(c),c.focus()):l&&!this.enum&&(A.setEndOfContentEditable(l),l.focus()));(i!=n.tdExpand||r)&&i!=n.tdField&&i!=n.tdSeparator||"click"!=t||e.hasMoved||c&&(A.setEndOfContentEditable(c),c.focus()),"keydown"==t&&this.onKeyDown(e)},D.prototype._onEvent=function(e){var t=e.target;if(t===this.dom.field||t===this.dom.value){var i={field:this.getField(),path:this.getPath()};this._hasChilds()||t!==this.dom.value||(i.value=this.getValue()),this.editor.options.onEvent(i,e)}},D.prototype.onKeyDown=function(e){var t,i,n,o,r,s,a,l,c,h,d,u,p,f=e.which||e.keyCode,m=e.target||e.srcElement,g=e.ctrlKey,v=e.shiftKey,y=e.altKey,b=!1,x="tree"===this.editor.options.mode,w=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],_=w[0],C=w[w.length-1];if(13==f){if(m==this.dom.value)this.editable.value&&!e.ctrlKey||A.isUrl(this.value)&&(window.open(this.value,"_blank"),b=!0);else if(m==this.dom.expand){if(this._hasChilds()){var E=e.ctrlKey;this._onExpand(E),m.focus(),b=!0}}}else if(68==f)g&&x&&(D.onDuplicate(w),b=!0);else if(69==f)g&&(this._onExpand(v),m.focus(),b=!0);else if(77==f&&x)g&&(this.showContextMenu(m),b=!0);else if(46==f&&x)g&&(D.onRemove(w),b=!0);else if(45==f&&x)g&&!v?(this._onInsertBefore(),b=!0):g&&v&&(this._onInsertAfter(),b=!0);else if(35==f){if(y){var S=this._lastNode();S&&S.focus(D.focusElement||this._getElementName(m)),b=!0}}else if(36==f){if(y){var N=this._firstNode();N&&N.focus(D.focusElement||this._getElementName(m)),b=!0}}else if(37==f){if(y&&!v){var T=this._previousElement(m);T&&this.focus(this._getElementName(T)),b=!0}else if(y&&v&&x){if(C.expanded){var k=C.getAppendDom();n=k?k.nextSibling:void 0}else{var j=C.getDom();n=j.nextSibling}n&&(i=D.getNodeFromTarget(n),o=n.nextSibling,P=D.getNodeFromTarget(o),i&&i instanceof L&&1!=C.parent.childs.length&&P&&P.parent&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[C.getIndex()+1]||a.append,l=_.getIndex(),c=P.getIndex(),h=a.getInternalPath(),d=P.parent.getInternalPath(),w.forEach(function(e){P.parent.moveBefore(e,P)}),this.focus(D.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:w.length,fieldNames:w.map(R),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:_.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:r,newSelection:this.editor.getDomSelection()})))}}else if(38==f)y&&!v?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(D.focusElement||this._getElementName(m))),b=!0):!y&&g&&v&&x?((t=this._previousNode())&&((p=this.editor.multiselection).start=p.start||this,p.end=t,u=this.editor._findTopLevelNodes(p.start,p.end),this.editor.select(u),t.focus("field")),b=!0):y&&v&&x&&((t=_._previousNode())&&t.parent&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[C.getIndex()+1]||a.append,l=_.getIndex(),c=t.getIndex(),h=a.getInternalPath(),d=t.parent.getInternalPath(),w.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(D.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:w.length,fieldNames:w.map(R),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:_.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:r,newSelection:this.editor.getDomSelection()})),b=!0);else if(39==f){if(y&&!v){var O=this._nextElement(m);O&&this.focus(this._getElementName(O)),b=!0}else if(y&&v&&x){var I=(j=_.getDom()).previousSibling;I&&(t=D.getNodeFromTarget(I))&&t.parent&&!t.isVisible()&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[C.getIndex()+1]||a.append,l=_.getIndex(),c=t.getIndex(),h=a.getInternalPath(),d=t.parent.getInternalPath(),w.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(D.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:w.length,fieldNames:w.map(R),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:_.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:r,newSelection:this.editor.getDomSelection()}))}}else if(40==f)if(y&&!v)(i=this._nextNode())&&(this.editor.deselect(!0),i.focus(D.focusElement||this._getElementName(m))),b=!0;else if(!y&&g&&v&&x)(i=this._nextNode())&&((p=this.editor.multiselection).start=p.start||this,p.end=i,u=this.editor._findTopLevelNodes(p.start,p.end),this.editor.select(u),i.focus("field")),b=!0;else if(y&&v&&x){(i=C.expanded?C.append?C.append._nextNode():void 0:C._nextNode())&&!i.isVisible()&&(i=i.parent.showMore),i&&i instanceof L&&(i=C);var P=i&&(i._nextNode()||i.parent.append);P&&P.parent&&(r=this.editor.getDomSelection(),s=(a=_.parent).childs[C.getIndex()+1]||a.append,l=_.getIndex(),c=P.getIndex(),h=a.getInternalPath(),d=P.parent.getInternalPath(),w.forEach(function(e){P.parent.moveBefore(e,P)}),this.focus(D.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:w.length,fieldNames:w.map(R),oldParentPath:a.getInternalPath(),newParentPath:_.parent.getInternalPath(),oldParentPathRedo:h,newParentPathRedo:d,oldIndexRedo:l,newIndexRedo:c,oldIndex:s.getIndex(),newIndex:_.getIndex(),oldSelection:r,newSelection:this.editor.getDomSelection()})),b=!0}b&&(e.preventDefault(),e.stopPropagation())},D.prototype._onExpand=function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)},D.prototype._showColorPicker=function(){if("function"==typeof this.editor.options.onColorPicker&&this.dom.color){var t=this;t._deleteDomColor(),t.updateDom();var e=n(this.dom.color,this.editor.frame);this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())})}},D.prototype.getFieldNames=function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]},D.onRemove=function(e){if(!Array.isArray(e))return D.onRemove([e]);if(e&&0<e.length){var t=e[0],i=t.parent,n=t.editor,o=t.getIndex();n.highlighter.unhighlight();var r=n.getDomSelection();D.blurNodes(e);var s=n.getDomSelection(),a=e.map(f);e.forEach(function(e){e.parent._remove(e)}),n._onAction("removeNodes",{nodes:e,paths:a,parentPath:i.getInternalPath(),index:o,oldSelection:r,newSelection:s})}},D.onDuplicate=function(e){if(!Array.isArray(e))return D.onDuplicate([e]);if(e&&0<e.length){var t=e[e.length-1],n=t.parent,i=t.editor;i.deselect(i.multiselection.nodes);var o=i.getDomSelection(),r=t,s=e.map(function(e){var t=e.clone();if("object"===e.parent.type){var i=e.parent.getFieldNames();t.field=A.findUniqueName(e.field,i)}return n.insertAfter(t,r),r=t});1===e.length?s[0].focus():i.select(s);var a=i.getDomSelection();i._onAction("duplicateNodes",{paths:e.map(f),clonePaths:s.map(f),afterPath:t.getInternalPath(),parentPath:n.getInternalPath(),oldSelection:o,newSelection:a})}},D.prototype._onInsertBefore=function(e,t,i){var n=this.editor.getDomSelection(),o=new D(this.editor,{field:null!=e?e:"",value:null!=t?t:"",type:i});o.expand(!0);var r=this.getInternalPath();this.parent.insertBefore(o,this),this.editor.highlighter.unhighlight(),o.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[o],paths:[o.getInternalPath()],beforePath:r,parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:s})},D.prototype._onInsertAfter=function(e,t,i){var n=this.editor.getDomSelection(),o=new D(this.editor,{field:null!=e?e:"",value:null!=t?t:"",type:i});o.expand(!0),this.parent.insertAfter(o,this),this.editor.highlighter.unhighlight(),o.focus("field");var r=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[o],paths:[o.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:r})},D.prototype._onAppend=function(e,t,i){var n=this.editor.getDomSelection(),o=new D(this.editor,{field:null!=e?e:"",value:null!=t?t:"",type:i});o.expand(!0),this.parent.appendChild(o),this.editor.highlighter.unhighlight(),o.focus("field");var r=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[o],paths:[o.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:r})},D.prototype._onChangeType=function(e){var t=this.type;if(e!=t){var i=this.editor.getDomSelection();this.changeType(e);var n=this.editor.getDomSelection();this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:t,newType:e,oldSelection:i,newSelection:n})}},D.prototype.sort=function(s,e){if(this._hasChilds()){this.hideChilds();var t=this.childs;this.childs=this.childs.concat();var a="desc"===e?-1:1;"object"===this.type?this.childs.sort(function(e,t){return a*l(e.field,t.field)}):this.childs.sort(function(e,t){var i=e.getNestedChild(s),n=t.getNestedChild(s);if(!i)return a;if(!n)return-a;var o=i.value,r=n.value;return"string"!=typeof o&&"string"!=typeof r?r<o?a:o<r?-a:0:a*l(o,r)}),this._updateDomIndexes(),this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:t,newChilds:this.childs}),this.showChilds()}},D.prototype.update=function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})},D.prototype._detachFromDom=function(){var e,t=this.dom.tr?this.dom.tr.parentNode:void 0,i=(e=this.expanded?this.getAppendDom():this.getDom())&&e.parentNode?e.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:t,nextTr:i}},D.prototype._attachToDom=function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()},D.prototype.transform=function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),i=this.getValue(),n=r.search(i,e);this.setValue(n);var o=this.getInternalValue();this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:o}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}},D.prototype.getNestedChild=function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i},D.prototype.findChildByProperty=function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})},D.prototype.getChildPaths=function(t){var i={};return this._getChildPaths(i,"",t),"array"===this.type&&this.childs.forEach(function(e){e._getChildPaths(i,"",t)}),Object.keys(i).sort()},D.prototype._getChildPaths=function(t,i,n){"auto"!==this.type&&"string"!==this.type&&!n||(t[i||"."]=!0),"object"===this.type&&this.childs.forEach(function(e){e._getChildPaths(t,i+"."+e.field,n)})},D.prototype.getAppendDom=function(){return this.append||(this.append=new L(this.editor),this.append.setParent(this)),this.append.getDom()},D.prototype.getShowMoreDom=function(){return this.showMore||(this.showMore=new a(this.editor,this)),this.showMore.getDom()},D.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},D.targetIsColorPicker=function(e){var t=D.getNodeFromTarget(e);if(t)for(var i=e&&e.parentNode;i;){if(i===t.dom.color)return!0;i=i.parentNode}return!1},D.blurNodes=function(e){if(Array.isArray(e)){var t=e[0],i=t.parent,n=t.getIndex();i.childs[n+e.length]?i.childs[n+e.length].focus():i.childs[n-1]?i.childs[n-1].focus():i.focus()}else D.blurNodes([e])},D.prototype.nextSibling=function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append},D.prototype._previousNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.previousSibling,e=D.getNodeFromTarget(i),i&&e&&e instanceof L&&!e.isVisible(););return e},D.prototype._nextNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.nextSibling,e=D.getNodeFromTarget(i),i&&e&&e instanceof L&&!e.isVisible(););return e},D.prototype._firstNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=D.getNodeFromTarget(i)}return e},D.prototype._lastNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=D.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=D.getNodeFromTarget(i)}return e},D.prototype._previousElement=function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}},D.prototype._nextElement=function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}},D.prototype._getElementName=function(e){var t=this.dom;for(var i in t)if(t.hasOwnProperty(i)&&t[i]==e)return i;return null},D.prototype._hasChilds=function(){return"array"==this.type||"object"==this.type},D.TYPE_TITLES={auto:u("autoType"),object:u("objectType"),array:u("arrayType"),string:u("stringType")},D.prototype.addTemplates=function(t,i){var n=this,e=n.editor.options.templates;if(null!=e){e.length&&t.push({type:"separator"});e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:i?function(e,t){n._onAppend(e,t)}.bind(this,e.field,e.value):function(e,t){n._onInsertBefore(e,t)}.bind(this,e.field,e.value)})})}},D.prototype.showContextMenu=function(e,t){var i=this,n=D.TYPE_TITLES,o=[];if(this.editable.value&&o.push({text:u("type"),title:u("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:u("auto"),className:"jsoneditor-type-auto"+("auto"==this.type?" jsoneditor-selected":""),title:n.auto,click:function(){i._onChangeType("auto")}},{text:u("array"),className:"jsoneditor-type-array"+("array"==this.type?" jsoneditor-selected":""),title:n.array,click:function(){i._onChangeType("array")}},{text:u("object"),className:"jsoneditor-type-object"+("object"==this.type?" jsoneditor-selected":""),title:n.object,click:function(){i._onChangeType("object")}},{text:u("string"),className:"jsoneditor-type-string"+("string"==this.type?" jsoneditor-selected":""),title:n.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&o.push({text:u("sort"),title:u("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){var e=i.editor.options.modalAnchor||p;h(i,e)}}),this.editor.options.enableTransform&&o.push({text:u("transform"),title:u("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){var e=i.editor.options.modalAnchor||p;d(i,e)}})),this.parent&&this.parent._hasChilds()){o.length&&o.push({type:"separator"});var r=i.parent.childs;if(i==r[r.length-1]){var s=[{text:u("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:u("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:u("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:u("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(s,!0),o.push({text:u("appendText"),title:u("appendTitle"),submenuTitle:u("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:s})}var a=[{text:u("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onInsertBefore("","","auto")}},{text:u("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onInsertBefore("",[])}},{text:u("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onInsertBefore("",{})}},{text:u("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onInsertBefore("","","string")}}];i.addTemplates(a,!1),o.push({text:u("insert"),title:u("insertTitle"),submenuTitle:u("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:a}),this.editable.field&&(o.push({text:u("duplicateText"),title:u("duplicateField"),className:"jsoneditor-duplicate",click:function(){D.onDuplicate(i)}}),o.push({text:u("removeText"),title:u("removeField"),className:"jsoneditor-remove",click:function(){D.onRemove(i)}}))}if(this.editor.options.onCreateMenu){var l=i.getPath();o=this.editor.options.onCreateMenu(o,{type:"single",path:l,paths:[l]})}new c(o,{close:t}).show(e,this.editor.frame)},D.prototype._getType=function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof this._stringCast(e)?"string":"auto"},D.prototype._stringCast=function(e){var t=e.toLowerCase(),i=Number(e),n=parseFloat(e);return""==e?"":"null"==t?null:"true"==t||"false"!=t&&(isNaN(i)||isNaN(n)?e:i)},D.prototype._escapeHTML=function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/  /g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=A.escapeUnicodeChars(n)),n},D.prototype._unescapeHTML=function(e){var t='"'+this._escapeJSON(e)+'"';return A.parse(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")},D.prototype._escapeJSON=function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"==n?t+="\\n":"\\"==n?(t+=n,i++,""!==(n=e.charAt(i))&&-1!='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'==n?'\\"':n,i++}return t},D.prototype.updateNodeName=function(){var e,t=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{e=this.editor.options.onNodeName({path:this.getPath(),size:t,type:this.type})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.innerHTML="object"===this.type?"{"+(e||t)+"}":"["+(e||t)+"]"}},D.prototype.recursivelyUpdateNodeName=function(){var e;if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(e in this.childs)this.childs[e].recursivelyUpdateNodeName()};var L=o(D),a=s(D);e.exports=D},function(e,t){e.exports=function t(e,i){"use strict";function n(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var o,r,s=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,a=/(^[ ]*|[ ]*$)/g,l=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,h=/^0/,d=n(e).replace(a,"")||"",u=n(i).replace(a,"")||"",p=d.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),f=u.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=parseInt(d.match(c),16)||1!==p.length&&d.match(l)&&Date.parse(d),g=parseInt(u.match(c),16)||m&&u.match(l)&&Date.parse(u)||null;if(g){if(m<g)return-1;if(g<m)return 1}for(var v=0,y=Math.max(p.length,f.length);v<y;v++){if(o=!(p[v]||"").match(h)&&parseFloat(p[v])||p[v]||0,r=!(f[v]||"").match(h)&&parseFloat(f[v])||f[v]||0,isNaN(o)!==isNaN(r))return isNaN(o)?1:-1;if(typeof o!=typeof r&&(o+="",r+=""),o<r)return-1;if(r<o)return 1}return 0}},function(e,t,i){"use strict";var r=i(1),l=i(2),c=i(0).translate;e.exports=function(a){function e(e){this.editor=e,this.dom={}}return(e.prototype=new a).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.type="button",n.className="jsoneditor-button jsoneditor-contextmenu",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var o=document.createElement("td"),r=document.createElement("div");return r.innerHTML="("+c("empty")+")",r.className="jsoneditor-readonly",o.appendChild(r),e.td=o,e.text=r,this.updateDom(),t},e.prototype.getPath=function(){return null},e.prototype.getIndex=function(){return null},e.prototype.updateDom=function(e){var t=this.dom,i=t.td;i&&(i.style.paddingLeft=24*this.getLevel()+26+"px");var n=t.text;n&&(n.innerHTML="("+c("empty")+" "+this.parent.type+")");var o=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&o.appendChild(t.tdDrag),t.tdMenu&&o.appendChild(t.tdMenu),o.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&o.removeChild(t.tdDrag),t.tdMenu&&o.removeChild(t.tdMenu),o.removeChild(i))},e.prototype.isVisible=function(){return 0==this.parent.childs.length},e.prototype.showContextMenu=function(e,t){var i=this,n=a.TYPE_TITLES,o=[{text:c("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:c("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:c("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:c("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(o,!0);var r=[{text:c("appendText"),title:c("appendTitleAuto"),submenuTitle:c("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:o}];if(this.editor.options.onCreateMenu){var s=i.parent.getPath();r=this.editor.options.onCreateMenu(r,{type:"append",path:s,paths:[s]})}new l(r,{close:t}).show(e,this.editor.frame)},e.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom;if(i==n.menu&&("mouseover"==t?this.editor.highlighter.highlight(this.parent):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var o=this.editor.highlighter;o.highlight(this.parent),o.lock(),r.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){r.removeClassName(n.menu,"jsoneditor-selected"),o.unlock(),o.unhighlight()})}"keydown"==t&&this.onKeyDown(e)},e}},function(e,t,i){"use strict";var l=i(0).translate;e.exports=function(e){function t(e,t){this.editor=e,this.parent=t,this.dom={}}return(t.prototype=new e).getDom=function(){if(this.dom.tr)return this.dom.tr;if(this._updateEditability(),!this.dom.tr){var t=this,i=this.parent,e=document.createElement("a");e.appendChild(document.createTextNode(l("showMore"))),e.href="#",e.onclick=function(e){return i.visibleChilds=Math.floor(i.visibleChilds/i.getMaxVisibleChilds()+1)*i.getMaxVisibleChilds(),t.updateDom(),i.showChilds(),e.preventDefault(),!1};var n=document.createElement("a");n.appendChild(document.createTextNode(l("showAll"))),n.href="#",n.onclick=function(e){return i.visibleChilds=1/0,t.updateDom(),i.showChilds(),e.preventDefault(),!1};var o=document.createElement("div"),r=document.createTextNode(this._getShowMoreText());o.className="jsoneditor-show-more",o.appendChild(r),o.appendChild(e),o.appendChild(document.createTextNode(". ")),o.appendChild(n),o.appendChild(document.createTextNode(". "));var s=document.createElement("td");s.appendChild(o);var a=document.createElement("tr");"tree"===this.editor.options.mode&&(a.appendChild(document.createElement("td")),a.appendChild(document.createElement("td"))),a.appendChild(s),a.className="jsoneditor-show-more",this.dom.tr=a,this.dom.moreContents=o,this.dom.moreText=r}return this.updateDom(),this.dom.tr},t.prototype.updateDom=function(e){if(this.isVisible()){if(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],!this.dom.tr.parentNode){var t=this.parent._getNextTr();t&&t.parentNode.insertBefore(this.dom.tr,t)}this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"}else this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},t.prototype._getShowMoreText=function(){return l("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},t.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},t.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},t}},function(e,t,i){"use strict";function n(){}var o={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."};n.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},n.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=n.prototype[t[i]]:e[t[i]]=n.prototype[t[i]];return e};var l={extend:function(e,t){var i;for(i in t=t||{},e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var o=0,r=e.length;o<r;o++)t.call(i,o,e[o],e)},createElement:function(e,t){var i,n=document,o=n.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(i in t)if(i in o)o[i]=t[i];else if("html"===i)o.innerHTML=t[i];else if("text"===i){var r=n.createTextNode(t[i]);o.appendChild(r)}else o.setAttribute(i,t[i]);return o},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){l.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){l.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:l.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(n,o,r){var s;return function(){var e=this,t=arguments,i=r&&!s;clearTimeout(s),s=setTimeout(function(){s=null,r||n.apply(e,t)},o),i&&n.apply(e,t)}},rect:function(e,t){var i=window,n=e.getBoundingClientRect(),o=t?i.pageXOffset:0,r=t?i.pageYOffset:0;return{bottom:n.bottom+r,height:n.height,left:n.left+o,right:n.right+o,top:n.top+r,width:n.width}},includes:function(e,t){return-1<e.indexOf(t)},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}};function c(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function r(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),l.removeClass(e,"excluded"),i||(e.innerHTML=e.textContent)}function s(){if(this.items.length){var i=document.createDocumentFragment();if(this.config.pagination){var e=this.pages.slice(0,this.pageIndex);l.each(e,function(e,t){l.each(t,function(e,t){r(t,i,this.customOption)},this)},this)}else l.each(this.items,function(e,t){r(t,i,this.customOption)},this);i.childElementCount&&(l.removeClass(this.items[this.navIndex],"active"),this.navIndex=i.querySelector(".selectr-option").idx,l.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(i)}}function h(e,t){t=t||e;var i=this.customOption?this.config.renderOption(t):e.textContent,n=l.createElement("li",{class:"selectr-option",html:i,role:"treeitem","aria-selected":!1});return n.idx=e.idx,this.items.push(n),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(n.disabled=!0,l.addClass(n,"disabled")),n}function a(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&l.removeClass(this.inputContainer,"active"),l.hasClass(this.container,"notice")&&(l.removeClass(this.container,"notice"),l.addClass(this.container,"open"),this.input.focus()),l.each(this.items,function(e,t){l.removeClass(t,"excluded"),this.customOption||(t.innerHTML=t.textContent)},this))}function d(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}var u=function(){var e=this.tree,t=e.scrollTop;if(e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length){var i=document.createDocumentFragment();l.each(this.pages[this.pageIndex],function(e,t){r(t,i,this.customOption)},this),e.appendChild(i),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}};d.prototype.render=function(e){if(!this.rendered){this.config=l.extend(o,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=c(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,n.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,c(this.config,"width")&&(l.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":l.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=l.createElement("div",{class:"selectr-container"}),this.config.customClass&&l.addClass(this.container,this.config.customClass),this.mobileDevice?l.addClass(this.container,"selectr-mobile"):l.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?l.addClass(this.el,"selectr-visible"):l.addClass(this.el,"selectr-hidden"),this.selected=l.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=l.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=l.createElement("div",{class:"selectr-options-container"});if(this.tree=l.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=l.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(l.addClass(this.label,"selectr-tags"),l.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=l.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),l.addClass(this.container,"clearable")),this.config.taggable){var t=l.createElement("li",{class:"input-tag"});this.input=l.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),l.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=l.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=l.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=l.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var i,n=!1,o=0;if(this.el.children.length&&l.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),l.each(t.children,function(e,t){t.idx=o,n.appendChild(h.call(this,t,n)),o++},this)):(t.idx=o,h.call(this,t),o++)},this),this.config.data&&Array.isArray(this.config.data)){var r,s=!(this.data=[]);n=!1,o=0,l.each(this.config.data,function(e,t){c(t,"children")?(s=l.createElement("optgroup",{label:t.text}),n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),l.each(t.children,function(e,t){(r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(r),s.appendChild(r),r.idx=o,n.appendChild(h.call(this,r,t)),this.data[o]=t,o++},this)):((r=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(r),r.idx=o,h.call(this,r,t),this.data[o]=t,o++)},this)}this.setSelected(!0);for(var a=this.navIndex=0;a<this.items.length;a++)if(i=this.items[a],!l.hasClass(i,"disabled")){l.addClass(i,"active"),this.navIndex=a;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=l.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=l.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var t=this;setTimeout(function(){t.emit("selectr.init")},20)}},d.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},d.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},d.prototype.bindEvents=function(){var n=this;if(this.events={},this.events.dismiss=function(e){var t=e.target;this.container.contains(t)||!this.opened&&!l.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&l.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:t=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;l.hasClass(this.items[this.navIndex],"disabled")||l.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}var n=l.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:n.top+n.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(n.top+n.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&u.call(this)):0===this.navIndex?this.tree.scrollTop=0:n.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(n.top-this.optsRect.top)),i&&l.removeClass(i,"active"),l.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===n.el&&n.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation(),e.target===n.el&&n.toggle()});this.el.addEventListener("change",function(e){if(n.el.multiple){var t=n.getSelectedProperties("idx"),i=function(e,t){for(var i,n=[],o=e.slice(0),r=0;r<t.length;r++)-1<(i=o.indexOf(t[r]))?o.splice(i,1):n.push(t[r]);return[n,o]}(n.selectedIndexes,t);l.each(i[0],function(e,t){n.select(t)},n),l.each(i[1],function(e,t){n.deselect(t)},n)}else-1<n.el.selectedIndex&&n.select(n.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&n.selected===document.activeElement&&(n.toggle(),setTimeout(function(){n.el.focus()},200))}),this.selected.addEventListener("click",function(e){n.disabled||n.toggle(),e.preventDefault(),e.stopPropagation()}),this.label.addEventListener("click",function(e){l.hasClass(e.target,"selectr-tag-remove")&&n.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation();var t=l.closest(e.target,function(e){return e&&l.hasClass(e,"selectr-option")});t&&(l.hasClass(t,"disabled")||(l.hasClass(t,"selected")?(n.el.multiple||!n.el.multiple&&n.config.allowDeselect)&&n.deselect(t.idx):n.select(t.idx),n.opened&&!n.el.multiple&&n.close()))}),this.tree.addEventListener("mouseover",function(e){l.hasClass(e.target,"selectr-option")&&(l.hasClass(e.target,"disabled")||(l.removeClass(n.items[n.navIndex],"active"),l.addClass(e.target,"active"),n.navIndex=[].slice.call(n.items).indexOf(e.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){n.searching=!0}),this.input.addEventListener("blur",function(e){n.searching=!1}),this.input.addEventListener("keyup",function(e){n.search(),n.config.taggable||(this.value.length?l.addClass(this.parentNode,"active"):l.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){n.input.value=null,a.call(n),n.tree.childElementCount||s.call(n)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){if(n.search(),n.config.taggable&&this.value.length){var i=this.value.trim();if(13===e.which||l.includes(n.tagSeperators,e.key))l.each(n.tagSeperators,function(e,t){i=i.replace(t,"")}),n.add({value:i,text:i,selected:!0},!0)?(n.close(),a.call(n)):(this.value="",n.setMessage("That tag is already in use."))}}),this.update=l.debounce(function(){n.opened&&n.config.closeOnScroll&&n.close(),n.width&&(n.container.style.width=n.width),n.invert()},50),this.requiresPagination&&(this.paginateItems=l.debounce(function(){u.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},d.prototype.setSelected=function(e){if(this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),l.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data){!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0);var i=0;l.each(this.config.data,function(e,t){c(t,"children")?l.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++)},this)}},d.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),l.removeClass(this.el,"selectr-hidden"),this.el.form&&l.off(this.el.form,"reset",this.events.reset),l.off(document,"click",this.events.dismiss),l.off(document,"keydown",this.events.navigate),l.off(window,"resize",this.update),l.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},d.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&l.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},d.prototype.select=function(n){var e=this.items[n],t=[].slice.call(this.el.options),i=this.options[n];if(this.el.multiple){if(l.includes(this.selectedIndexes,n))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(i.value),this.selectedIndexes.push(n),function(e){var c,h=this,i=document.createDocumentFragment(),t=this.options[e.idx],n=this.data?this.data[e.idx]:t,o=this.customSelected?this.config.renderSelection(n):t.textContent,r=l.createElement("li",{class:"selectr-tag",html:o}),s=l.createElement("button",{class:"selectr-tag-remove",type:"button"});if(r.appendChild(s),r.idx=e.idx,r.tag=t.value,this.tags.push(r),this.config.sortSelected){var a=this.tags.slice();c=function(e,n){e.replace(/(\d+)|(\D+)/g,function(e,t,i){n.push([t||1/0,i||""])})},a.sort(function(e,t){var i,n,o=[],r=[];for(!0===h.config.sortSelected?(i=e.tag,n=t.tag):"text"===h.config.sortSelected&&(i=e.textContent,n=t.textContent),c(i,o),c(n,r);o.length&&r.length;){var s=o.shift(),a=r.shift(),l=s[0]-a[0]||s[1].localeCompare(a[1]);if(l)return l}return o.length-r.length}),l.each(a,function(e,t){i.appendChild(t)}),this.label.innerHTML=""}else i.appendChild(r);this.config.taggable?this.label.insertBefore(i,this.input.parentNode):this.label.appendChild(i)}.call(this,e)}else{var o=this.data?this.data[n]:i;this.label.innerHTML=this.customSelected?this.config.renderSelection(o):i.textContent,this.selectedValue=i.value,this.selectedIndex=n,l.each(this.options,function(e,t){var i=this.items[e];e!==n&&(i&&l.removeClass(i,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}l.includes(t,i)||this.el.add(i)
,e.setAttribute("aria-selected",!0),l.addClass(e,"selected"),l.addClass(this.container,"has-selected"),i.selected=!0,i.setAttribute("selected",""),this.emit("selectr.change",i),this.emit("selectr.select",i)},d.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var o=this.selectedIndexes.indexOf(e);this.selectedIndexes.splice(o,1);var r=this.selectedValues.indexOf(n.value);this.selectedValues.splice(r,1),function(i){var n=!1;l.each(this.tags,function(e,t){t.idx===i.idx&&(n=t)},this),n&&(this.label.removeChild(n),this.tags.splice(this.tags.indexOf(n),1))}.call(this,i),this.tags.length||l.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,l.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),l.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},d.prototype.setValue=function(i){var n=Array.isArray(i);if(n||(i=i.toString().trim()),!this.el.multiple&&n)return!1;l.each(this.options,function(e,t){(n&&l.includes(i.toString(),t.value)||t.value===i)&&this.change(t.idx)},this)},d.prototype.getValue=function(e,t){var n;if(this.el.multiple)e?this.selectedIndexes.length&&(n={values:[]},l.each(this.selectedIndexes,function(e,t){var i=this.options[t];n.values[e]={value:i.value,text:i.textContent}},this)):n=this.selectedValues.slice();else if(e){var i=this.options[this.selectedIndex];n={value:i.value,text:i.textContent}}else n=this.selectedValue;return e&&t&&(n=JSON.stringify(n)),n},d.prototype.add=function(i,n){if(i){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(i))l.each(i,function(e,t){this.add(t,n)},this);else if("[object Object]"===Object.prototype.toString.call(i)){if(n){var o=!1;if(l.each(this.options,function(e,t){t.value.toLowerCase()===i.value.toLowerCase()&&(o=!0)}),o)return!1}var e=l.createElement("option",i);return this.data.push(i),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,h.call(this,e),i.selected&&this.select(e.idx),e}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},d.prototype.remove=function(i){var n,o=[];Array.isArray(i)?l.each(i,function(e,t){l.isInt(t)?o.push(this.getOptionByIndex(t)):"string"==typeof i&&o.push(this.getOptionByValue(t))},this):l.isInt(i)?o.push(this.getOptionByIndex(i)):"string"==typeof i&&o.push(this.getOptionByValue(i)),o.length&&(l.each(o,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);var i=this.items[n].parentNode;i&&i.removeChild(this.items[n]),this.items.splice(n,1),l.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate())},d.prototype.removeAll=function(){this.clear(!0),l.each(this.el.options,function(e,t){this.el.remove(t)},this),l.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},d.prototype.search=function(n){if(!this.navigating){n=n||this.input.value;var o=document.createDocumentFragment();if(this.removeMessage(),l.truncate(this.tree),1<n.length)if(l.each(this.options,function(e,t){var i=this.items[t.idx];l.includes(t.textContent.toLowerCase(),n.toLowerCase())&&!t.disabled?(r(i,o,this.customOption),l.removeClass(i,"excluded"),this.customOption||(i.innerHTML=function(e,t){var i=new RegExp(e,"i").exec(t.textContent);return!!i&&t.textContent.replace(i[0],"<span class='selectr-match'>"+i[0]+"</span>")}(n,t))):l.addClass(i,"excluded")},this),o.childElementCount){var e=this.items[this.navIndex],t=o.firstElementChild;l.removeClass(e,"active"),this.navIndex=t.idx,l.addClass(t,"active")}else this.config.taggable||this.setMessage("no results.");else s.call(this);this.tree.appendChild(o)}},d.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},d.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(l.addClass(this.container,"native-open"),void(this.config.data&&l.each(this.options,function(e,t){this.el.add(t)},this))):(l.addClass(this.container,"open"),s.call(this),this.invert(),this.tree.scrollTop=0,l.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},d.prototype.close=function(){if(this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown)l.removeClass(this.container,"native-open");else{var e=l.hasClass(this.container,"notice");this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(l.removeClass(this.container,"notice"),this.notice.textContent=""),l.removeClass(this.container,"open"),l.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),l.truncate(this.tree),a.call(this)}},d.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),l.removeClass(this.container,"selectr-disabled")},d.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,l.addClass(this.container,"selectr-disabled")},d.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),l.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},d.prototype.clear=function(e){if(this.el.multiple){if(this.selectedIndexes.length){var t=this.selectedIndexes.slice();l.each(t,function(e,t){this.deselect(t)},this)}}else-1<this.selectedIndex&&this.deselect(this.selectedIndex,e);this.emit("selectr.clear")},d.prototype.serialise=function(e){var n=[];return l.each(this.options,function(e,t){var i={value:t.value,text:t.textContent};t.selected&&(i.selected=!0),t.disabled&&(i.disabled=!0),n[e]=i}),e?JSON.stringify(n):n},d.prototype.serialize=function(e){return this.serialise(e)},d.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.innerHTML=e},d.prototype.paginate=function(){if(this.items.length){var i=this;return this.pages=this.items.map(function(e,t){return t%i.config.pagination==0?i.items.slice(t,t+i.config.pagination):null}).filter(function(e){return e}),this.pages}},d.prototype.setMessage=function(e,t){t&&this.close(),l.addClass(this.container,"notice"),this.notice.textContent=e},d.prototype.removeMessage=function(){l.removeClass(this.container,"notice"),this.notice.innerHTML=""},d.prototype.invert=function(){var e=l.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(l.addClass(this.container,"inverted"),this.isInverted=!0):(l.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=l.rect(this.tree)},d.prototype.getOptionByIndex=function(e){return this.options[e]},d.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=d},function(e,t,i){"use strict";var _={start:function(e,t,i){return 0===t.indexOf(e)},contain:function(e,t,i){return-1<t.indexOf(e)}};e.exports=function(l){(l=l||{}).filter=l.filter||"start",l.trigger=l.trigger||"keydown",l.confirmKeys=l.confirmKeys||[39,35,9],l.caseSensitive=l.caseSensitive||!1;var n="",o="",r=document.createElement("div");r.style.position="relative",r.style.outline="0",r.style.border="0",r.style.margin="0",r.style.padding="0";var t,s,a=document.createElement("div");function c(e){var t,i;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function h(e){return void 0===t&&((t=document.createElement("span")).style.visibility="hidden",t.style.position="fixed",t.style.outline="0",t.style.margin="0",t.style.padding="0",t.style.border="0",t.style.left="0",t.style.whiteSpace="pre",t.style.fontSize=n,t.style.fontFamily=o,t.style.fontWeight="normal",document.body.appendChild(t)),t.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),t.getBoundingClientRect().right}a.className="autocomplete dropdown",a.style.position="absolute",a.style.visibility="hidden";var d,u,p,i,f,m={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:r,show:function(e,t,i){this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""==n&&(n=window.getComputedStyle(e).getPropertyValue("font-size")),""==o&&(o=window.getComputedStyle(e).getPropertyValue("font-family"));e.getBoundingClientRect().right,e.getBoundingClientRect().left;a.style.marginLeft="0",a.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i,this.element!=e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){this.element.focus()}.bind(this),this.element.addEventListener&&(this.element.removeEventListener("keydown",x),this.element.addEventListener("keydown",x,!1),this.element.removeEventListener("blur",w),this.element.addEventListener("blur",w,!1)),r.appendChild(this.elementHint),r.appendChild(a),e.parentElement.appendChild(r),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,g.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var t=e.innerText;t=t.replace("\n","");this.startFrom,this.options;var i=this.options.length,n=t.substring(this.startFrom);s=t.substring(0,this.startFrom);for(var o=0;o<i;o++){var r=this.options[o];if(!l.caseSensitive&&0===r.toLowerCase().indexOf(n.toLowerCase())||l.caseSensitive&&0===r.indexOf(n)){this.elementHint.innerText=s+n+r.substring(n.length),this.elementHint.realInnerText=s+r;break}}a.style.left=h(s)+"px",g.refresh(n,this.options),this.elementHint.style.width=h(this.elementHint.innerText)+10+"px","hidden"==a.style.visibility||(this.elementHint.style.width=h(this.elementHint.innerText)+a.clientWidth+"px")}},g=(d=a,u=[],p=0,i=-1,f={rs:m,hide:function(){d.style.visibility="hidden"},refresh:function(i,e){d.style.visibility="hidden",p=0,d.innerHTML="";var t=window.innerHeight||document.documentElement.clientHeight,n=d.parentNode.getBoundingClientRect(),o=n.top-6,r=t-n.bottom-6;u=[];var s="function"==typeof l.filter?l.filter:_[l.filter],a=s?e.filter(function(e){return s(l.caseSensitive?i:i.toLowerCase(),l.caseSensitive?e:e.toLowerCase(),l)}):[];0!==(u=a.map(function(e){var t=document.createElement("div");return t.className="item",t.onmouseover=v,t.onmouseout=y,t.onmousedown=b,t.__hint=e,t.innerHTML=e.substring(0,i.length)+"<b>"+e.substring(i.length)+"</b>",d.appendChild(t),t})).length&&(1===u.length&&(i.toLowerCase()===u[0].__hint.toLowerCase()&&!l.caseSensitive||i===u[0].__hint&&l.caseSensitive)||u.length<2||(f.highlight(0),3*r<o?(d.style.maxHeight=o+"px",d.style.top="",d.style.bottom="100%"):(d.style.top="100%",d.style.bottom="",d.style.maxHeight=r+"px"),d.style.visibility="visible"))},highlight:function(e){-1!=i&&u[i]&&(u[i].className="item"),u[e].className="item hover",i=e},move:function(e){return"hidden"===d.style.visibility?"":(p+e===-1||p+e===u.length||(p+=e,f.highlight(p)),u[p].__hint)},onmouseselection:function(){}});function v(){this.style.outline="1px solid #ddd"}function y(){this.style.outline="0"}function b(){f.hide(),f.onmouseselection(this.__hint,f.rs)}var x=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!=t&&34!=t){if(27==t)return m.hideDropDown(),m.element.focus(),e.preventDefault(),void e.stopPropagation();var i=this.element.innerText;i=i.replace("\n","");this.startFrom;if(0<=l.confirmKeys.indexOf(t))return 9==t&&0==this.elementHint.innerText.length&&m.onTab(),void(0<this.elementHint.innerText.length&&this.element.innerText!=this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,m.hideDropDown(),c(this.element),9==t&&(m.element.focus(),e.preventDefault(),e.stopPropagation())));if(13!=t){if(40==t){var n=i.substring(this.startFrom);return""==(o=g.move(1))&&m.onArrowDown(),this.elementHint.innerText=s+n+o.substring(n.length),this.elementHint.realInnerText=s+o,e.preventDefault(),void e.stopPropagation()}if(38==t){var o;n=i.substring(this.startFrom);return""==(o=g.move(-1))&&m.onArrowUp(),this.elementHint.innerText=s+n+o.substring(n.length),this.elementHint.realInnerText=s+o,e.preventDefault(),void e.stopPropagation()}}else if(0==this.elementHint.innerText.length)m.onEnter();else{var r="hidden"==a.style.visibility;if(g.hide(),r)return m.hideDropDown(),m.element.focus(),void m.onEnter();this.element.innerText=this.elementHint.realInnerText,m.hideDropDown(),c(this.element),e.preventDefault(),e.stopPropagation()}}}.bind(m),w=function(e){m.hideDropDown()}.bind(m);return g.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=s+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),c(t.element)},1)},m}},function(e,t,E){"use strict";var S=E(3),N=E(11),T=E(1),i={},k="ace/theme/jsoneditor";function n(){try{this.format()}catch(e){}}i.create=function(e,t){void 0===(t=t||{}).statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2;var i=t.ace?t.ace:S;if(this.mode="code"==t.mode?"code":"text","code"==this.mode&&void 0===i&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||k,this.theme===k&&i)try{E(30)}catch(e){console.error(e)}t.onTextSelectionChange&&this.onTextSelectionChange(t.onTextSelectionChange);var n=this;if(this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.validationSequence=0,this.annotations=[],this.errorTableVisible=void 0,this._debouncedValidate=T.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){n._onKeyDown(e)},this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar){T.addClassName(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var o=document.createElement("button");o.type="button",o.className="jsoneditor-format",o.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(o),o.onclick=function(){try{n.format(),n._onChange()}catch(e){n._onError(e)}};var r=document.createElement("button");r.type="button",r.className="jsoneditor-compact",r.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(r),r.onclick=function(){try{n.compact(),n._onChange()}catch(e){n._onError(e)}};var s=document.createElement("button");if(s.type="button",s.className="jsoneditor-repair",s.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(s),s.onclick=function(){try{n.repair(),n._onChange()}catch(e){n._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new N(this.menu,this.options.modes,this.options.mode,function(e){n.setMode(e),n.modeSwitcher.focus()})),"code"==this.mode){var a=document.createElement("a");a.appendChild(document.createTextNode("powered by ace")),a.href="http://ace.ajax.org",a.target="_blank",a.className="jsoneditor-poweredBy",a.onclick=function(){window.open(a.href,a.target)},this.menu.appendChild(a)}}var l=this.options.onEditable&&typeof("function"===this.options.onEditable)&&!this.options.onEditable({});if(this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"==this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var c=i.edit(this.editorDom),h=c.getSession();c.$blockScrolling=1/0,c.setTheme(this.theme),c.setOptions({readOnly:l}),c.setShowPrintMargin(!1),c.setFontSize(13),h.setMode("ace/mode/json"),h.setTabSize(this.indentation),h.setUseSoftTabs(!0),h.setUseWrapMode(!0);var d=h.setAnnotations;h.setAnnotations=function(e){d.call(this,e&&e.length?e:n.annotations)},c.commands.bindKey("Ctrl-L",null),c.commands.bindKey("Command-L",null),this.aceEditor=c,this.hasOwnProperty("editor")||Object.defineProperty(this,"editor",{get:function(){return console.warn('Property "editor" has been renamed to "aceEditor".'),n.aceEditor},set:function(e){console.warn('Property "editor" has been renamed to "aceEditor".'),n.aceEditor=e}}),c.on("change",this._onChange.bind(this)),c.on("changeSelection",this._onSelect.bind(this))}else{var u=document.createElement("textarea");u.className="jsoneditor-text",u.spellcheck=!1,this.content.appendChild(u),this.textarea=u,this.textarea.readOnly=l,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),u.onselect=this._onSelect.bind(this),u.onmousedown=this._onMouseDown.bind(this),u.onblur=this._onBlur.bind(this)}var p=document.createElement("div");p.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=p,this.frame.appendChild(p);var f=document.createElement("div");if(f.style.display="none",f.className="jsoneditor-additional-errors fadein",f.innerHTML="Scroll for more &#9663;",this.dom.additionalErrorsIndication=f,p.appendChild(f),t.statusBar){T.addClassName(this.content,"has-status-bar"),this.curserInfoElements={};var m=document.createElement("div");(this.dom.statusBar=m).className="jsoneditor-statusbar",this.frame.appendChild(m);var g=document.createElement("span");g.className="jsoneditor-curserinfo-label",g.innerText="Ln:";var v=document.createElement("span");v.className="jsoneditor-curserinfo-val",v.innerText="1",m.appendChild(g),m.appendChild(v);var y=document.createElement("span");y.className="jsoneditor-curserinfo-label",y.innerText="Col:";var b=document.createElement("span");b.className="jsoneditor-curserinfo-val",b.innerText="1",m.appendChild(y),m.appendChild(b),this.curserInfoElements.colVal=b,this.curserInfoElements.lnVal=v;var x=document.createElement("span");x.className="jsoneditor-curserinfo-label",x.innerText="characters selected",x.style.display="none";var w=document.createElement("span");w.className="jsoneditor-curserinfo-count",w.innerText="0",w.style.display="none",this.curserInfoElements.countLabel=x,this.curserInfoElements.countVal=w,m.appendChild(w),m.appendChild(x);var _=document.createElement("span");_.className="jsoneditor-validation-error-icon",_.style.display="none";var C=document.createElement("span");C.className="jsoneditor-validation-error-count",C.style.display="none",this.validationErrorIndication={validationErrorIcon:_,validationErrorCount:C},m.appendChild(C),m.appendChild(_),this.parseErrorIndication=document.createElement("span"),this.parseErrorIndication.className="jsoneditor-parse-error-icon",this.parseErrorIndication.style.display="none",m.appendChild(this.parseErrorIndication)}this.setSchema(this.options.schema,this.options.schemaRefs)},i._onChange=function(){if(!this.onChangeDisabled){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},i._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},i._onKeyDown=function(e){var t=!1;220==(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},i._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},i._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},i._updateCursorInfo=function(){var t,i,n,o=this;if(this.textarea)setTimeout(function(){var e=T.getInputSelection(o.textarea);e.startIndex!==e.endIndex&&(n=e.endIndex-e.startIndex),i=n&&o.cursorInfo&&o.cursorInfo.line===e.end.row&&o.cursorInfo.column===e.end.column?(t=e.start.row,e.start.column):(t=e.end.row,e.end.column),o.cursorInfo={line:t,column:i,count:n},o.options.statusBar&&s()},0);else if(this.aceEditor&&this.curserInfoElements){var e=this.aceEditor.getCursorPosition(),r=this.aceEditor.getSelectedText();t=e.row+1,i=e.column+1,n=r.length,o.cursorInfo={line:t,column:i,count:n},this.options.statusBar&&s()}function s(){o.curserInfoElements.countVal.innerText!==n&&(o.curserInfoElements.countVal.innerText=n,o.curserInfoElements.countVal.style.display=n?"inline":"none",o.curserInfoElements.countLabel.style.display=n?"inline":"none"),o.curserInfoElements.lnVal.innerText=t,o.curserInfoElements.colVal.innerText=i}},i._emitSelectionChange=function(){if(this._selectionChangedHandler){var e=this.getTextSelection();this._selectionChangedHandler(e.start,e.end,e.text)}},i._refreshAnnotations=function(){var e=this.aceEditor&&this.aceEditor.getSession();if(e){var t=e.getAnnotations().filter(function(e){return"error"===e.type});e.setAnnotations(t)}},i.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode==this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},i.compact=function(){var e=this.get(),t=JSON.stringify(e);this.setText(t)},i.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this.setText(t)},i.repair=function(){var e=this.getText(),t=T.sanitize(e);this.setText(t)},i.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},i.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},i.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},i.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},i.get=function(){var t,i=this.getText();try{t=T.parse(i)}catch(e){i=T.sanitize(i),t=T.parse(i)}return t},i.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},i.setText=function(e){var t;t=!0===this.options.escapeUnicode?T.escapeUnicodeChars(e):e,this.textarea&&(this.textarea.value=t),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(t,-1),this.onChangeDisabled=!1),this._debouncedValidate()},i.updateText=function(e){this.getText()!==e&&(this.onChangeDisabled=!0,this.setText(e),this.onChangeDisabled=!1)},i.validate=function(){var e,t=!1,i=[],n=[];try{e=this.get(),this.parseErrorIndication&&(this.parseErrorIndication.style.display="none"),t=!0}catch(e){if(this.getText()){this.parseErrorIndication&&(this.parseErrorIndication.style.display="block");var o,r=/\w*line\s*(\d+)\w*/g.exec(e.message);r&&(o=+r[1]),this.parseErrorIndication&&(this.parseErrorIndication.title=isNaN(o)?"parse error - check that the json is valid":"parse error on line "+o),n.push({type:"error",message:e.message.replace(/\n/g,"<br>"),line:o})}}if(t){if(this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return e.type="validation",T.improveSchemaError(e)}));try{this.validationSequence++;var s=this,a=this.validationSequence;this._validateCustom(e).then(function(e){if(a===s.validationSequence){var t=i.concat(n||[]).concat(e||[]);s._renderErrors(t)}}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}else this._renderErrors(n||[],!0)},i._validateCustom=function(e){if(this.options.onValidate)try{var t=this.options.onValidate(e);return(T.isPromise(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=T.isValidValidationError(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:T.stringifyPath(e.path),message:e.message}}):null})}catch(e){return Promise.reject(e)}return Promise.resolve(null)},i._renderErrors=function(n,e){var r=this,s=0;this.errorTableVisible=void 0===this.errorTableVisible?!this.aceEditor:this.errorTableVisible,this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none",this.content.style.marginBottom="",this.content.style.paddingBottom="");var t=this.getText(),i=[];n.reduce(function(e,t){return-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},i);var a=T.getPositionForPath(t,i);if(0<n.length)if(this.aceEditor&&(this.annotations=a.map(function(t){var e=n.filter(function(e){return e.dataPath===t.path}),i=e.map(function(e){return e.message}).join("\n");return i?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+i,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),e?!this.aceEditor:this.errorTableVisible){var o=document.createElement("div");o.innerHTML='<table class="jsoneditor-text-errors"><tbody></tbody></table>';var l=o.getElementsByTagName("tbody")[0];n.forEach(function(t){var e,i;if(e="string"==typeof t?'<td colspan="2"><pre>'+t+"</pre></td>":"<td>"+(t.dataPath||"")+"</td><td>"+t.message+"</td>",isNaN(t.line)){if(t.dataPath){var n=a.find(function(e){return e.path===t.dataPath});n&&(i=n.line+1)}}else i=t.line;var o=document.createElement("tr");o.className=isNaN(i)?"":"jump-to-line","error"===t.type?o.className+=" parse-error":(o.className+=" validation-error",++s),o.innerHTML='<td><button class="jsoneditor-schema-error"></button></td><td style="white-space:nowrap;">'+(isNaN(i)?"":"Ln "+i)+"</td>"+e,o.onclick=function(){r.isFocused=!0,isNaN(i)||r.setTextSelection({row:i,column:1},{row:i,column:1e3})},l.appendChild(o)}),this.dom.validationErrors=o,this.dom.validationErrorsContainer.appendChild(o),this.dom.additionalErrorsIndication.title=n.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){r.dom.additionalErrorsIndication.style.display=0<r.dom.validationErrorsContainer.clientHeight&&0===r.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0;var c=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0);this.content.style.marginBottom=-c+"px",this.content.style.paddingBottom=c+"px"}else s=n.reduce(function(e,t){return"validation"===t.type?++e:e},0);else this.aceEditor&&(this.annotations=[],this._refreshAnnotations());if(this.options.statusBar){var h=!!(s=s||this.annotations.length);this.validationErrorIndication.validationErrorIcon.style.display=h?"inline":"none",this.validationErrorIndication.validationErrorCount.style.display=h?"inline":"none",h&&(this.validationErrorIndication.validationErrorCount.innerText=s,this.validationErrorIndication.validationErrorIcon.title=s+" schema validation error(s) found",this.validationErrorIndication.validationErrorCount.onclick=this.validationErrorIndication.validationErrorIcon.onclick=this._toggleErrorTableVisibility.bind(this))}if(this.aceEditor){this.aceEditor.resize(!1)}},i._toggleErrorTableVisibility=function(){this.errorTableVisible=!this.errorTableVisible,this.validate()},i.getTextSelection=function(){var e={};if(this.textarea){var t=T.getInputSelection(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var i=this.aceEditor.getSelection(),n=this.aceEditor.getSelectedText(),o=i.getRange(),r=i.getSelectionLead();return r.row===o.end.row&&r.column===o.end.column?e=o:(e.start=o.end,e.end=o.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:n}}},i.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=T.debounce(e,this.DEBOUNCE_INTERVAL))},i.setTextSelection=function(e,t){if(e&&t)if(this.textarea){var i=T.getIndexForPosition(this.textarea,e.row,e.column),n=T.getIndexForPosition(this.textarea,t.row,t.column);if(-1<i&&-1<n){if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(i,n);else if(this.textarea.createTextRange){(a=this.textarea.createTextRange()).collapse(!0),a.moveEnd("character",n),a.moveStart("character",i),a.select()}var o=(this.textarea.value.match(/\n/g)||[]).length+1,r=this.textarea.scrollHeight/o,s=e.row*r;this.textarea.scrollTop=s>this.textarea.clientHeight?s-this.textarea.clientHeight/2:0}}else if(this.aceEditor){var a={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}};this.aceEditor.selection.setRange(a),this.aceEditor.scrollToLine(e.row-1,!0)}},e.exports=[{mode:"text",mixin:i,data:"text",load:n},{mode:"code",mixin:i,data:"text",load:n}]},function(e,t){ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {background: #ebebeb;color: #333}.ace-jsoneditor.ace_editor {font-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;line-height: 1.3;background-color: #fff;}.ace-jsoneditor .ace_print-margin {width: 1px;background: #e8e8e8}.ace-jsoneditor .ace_scroller {background-color: #FFFFFF}.ace-jsoneditor .ace_text-layer {color: gray}.ace-jsoneditor .ace_variable {color: #1a1a1a}.ace-jsoneditor .ace_cursor {border-left: 2px solid #000000}.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {border-left: 0px;border-bottom: 1px solid #000000}.ace-jsoneditor .ace_marker-layer .ace_selection {background: lightgray}.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px #FFFFFF;border-radius: 2px}.ace-jsoneditor .ace_marker-layer .ace_step {background: rgb(255, 255, 0)}.ace-jsoneditor .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid #BFBFBF}.ace-jsoneditor .ace_marker-layer .ace_active-line {background: #FFFBD1}.ace-jsoneditor .ace_gutter-active-line {background-color : #dcdcdc}.ace-jsoneditor .ace_marker-layer .ace_selected-word {border: 1px solid lightgray}.ace-jsoneditor .ace_invisible {color: #BFBFBF}.ace-jsoneditor .ace_keyword,.ace-jsoneditor .ace_meta,.ace-jsoneditor .ace_support.ace_constant.ace_property-value {color: #AF956F}.ace-jsoneditor .ace_keyword.ace_operator {color: #484848}.ace-jsoneditor .ace_keyword.ace_other.ace_unit {color: #96DC5F}.ace-jsoneditor .ace_constant.ace_language {color: darkorange}.ace-jsoneditor .ace_constant.ace_numeric {color: red}.ace-jsoneditor .ace_constant.ace_character.ace_entity {color: #BF78CC}.ace-jsoneditor .ace_invalid {color: #FFFFFF;background-color: #FF002A;}.ace-jsoneditor .ace_fold {background-color: #AF956F;border-color: #000000}.ace-jsoneditor .ace_storage,.ace-jsoneditor .ace_support.ace_class,.ace-jsoneditor .ace_support.ace_function,.ace-jsoneditor .ace_support.ace_other,.ace-jsoneditor .ace_support.ace_type {color: #C52727}.ace-jsoneditor .ace_string {color: green}.ace-jsoneditor .ace_comment {color: #BCC8BA}.ace-jsoneditor .ace_entity.ace_name.ace_tag,.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {color: #606060}.ace-jsoneditor .ace_markup.ace_underline {text-decoration: underline}.ace-jsoneditor .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})}],o.c=n,o.d=function(e,t,i){o.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:i})},o.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},o.t=function(t,e){if(1&e&&(t=o(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var i=Object.create(null);if(o.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)o.d(i,n,function(e){return t[e]}.bind(null,n));return i},o.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return o.d(t,"a",t),t},o.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},o.p="",o(o.s=12);function o(e){if(n[e])return n[e].exports;var t=n[e]={i:e,l:!1,exports:{}};return i[e].call(t.exports,t,t.exports,o),t.l=!0,t.exports}var i,n});
//# sourceMappingURL=jsoneditor-minimalist.map