/**
 *  requireJS 配置
 * @author
 * @version 
 */


var root = "/" + window.location.pathname.split("/")[1];
var eMapRelaPath = "/static/js/easyMap";
require.config({
    baseUrl: "/",
    waitSeconds: 200,
    optimizeCss: 'standard',
    packages:[
        {
            name: "easyMap",
            location: eMapRelaPath
        }
    ],
    paths: {
        leaflet: 'webjars/map-2d/tp/Leaflet-1.0.3/dist/leaflet-src',
        mapv: eMapRelaPath+'tp/mapV/mapv',
        'proj4-leaflet': eMapRelaPath+'/tp/Proj4Leaflet/src/proj4leaflet',
        'esri-leaflet': '/webjars/map-2d/tp/esri-leaflet-2.2.3/dist/esri-leaflet-debug',
        knockout: '/webjars/map-2d/tp/knockout/dist/knockout',
        mustache: '/webjars/map-2d/tp/mustache/mustache',
        // echarts:eMapRelaPath+'/tp/echarts.v4/echarts.min',
        echarts:'/webjars/echarts/echarts',
        dragSort: '/webjars/map-2d/tp/DragSort/ddsort',
        ztree: eMapRelaPath+'/tp/jquery.ztree.all.min',
        popup: '/webjars/map-2d/map/core/Popup',
        slider: eMapRelaPath+'/tp/slider/jslider',
        jQueryXDomainRequest: eMapRelaPath+'/tp/jquery/jQuery.XDomainRequest',
        // easyMap: '/static/js/easyMap',
        'leaflet-pip': eMapRelaPath+'/tp/leaflet-pip-gh-pages/leaflet-pip',
        'esri-leaflet-gp':eMapRelaPath+'/tp/esri-leaflet-gp/esri-leaflet-gp'
    },
    shim: {
        'esri-leaflet': {
            deps: ['leaflet'],
            exports: 'L.esri'
        }

    },
    map: {
        '*': {
            text: 'webjars/map-2d/tp/requirejs-plugins/lib/text',
            css: 'webjars/map-2d/tp/require-css/css.min',
            less: ''
        }
    }
});
