/**
 * 组件读取事件传递
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/4/9/11:16  Copyright gtmap Corp
 */
define([
    'knockout',
    'mustache',
    'easyMap/core/EventBus'
], function (
    ko,
    Mustache,
    EventBus) {
    'use strict';


    var that, previousWidget, mapKnockout, widgetPaneHeight,toolsLoadIndex;

    /**
     * 组件的数据传递
     * @export WidgetsManager
     * @param widgets
     * @constructor
     */
    function WidgetsManager(config,mapId) {
        if (!config) {
            // throw new Error ('widgetsConfig cannot null')
            return;
        }
        var tools = config.tools;
        var widgets = config.widgets;
        var widgetDic = {};
        this.isLoaded = false;
        this.appConfig = config;
        that = this;
        toolsLoadIndex=0;

        /**
         * 加载所有
         */
        function loadWidgets() {
            $(widgets).each(function (i, config) {
                loadWidget(config);
            });
            if(tools.length==0){
                that.isLoaded=true;
            }
            $(tools).each(function (i, config) {
                loadTool(config);
            });
        }

        /*
        *加载单个组件
         */
        function loadWidget(widget) {
            var widgetId = widget.id;
            var url = "map/widgets/" + widgetId;
            try {
                require(["text!" + url + "/Index.html", "css!" + url + "/Style"], function (html) {
                    require([url + "/Index"], function (index) {
                        //to do
                    });
                }, function (err) {
                    console.log("模块 [" + widgetId + "] 加载异常请添加配置！")
                });
            } catch (e) {
                console.log("模块 [" + widgetId + "] 加载异常 [" + e.message + "]");
            }
        }

        /*
        *加载单个工具
         */
        function loadTool(widget) {
            var widgetId = widget.id;
            var url = "easyMap/widgets/" + widgetId;
            try {
                require(["text!" + url + "/Index.html", "css!" + url + "/Style"], function (html) {
                    //widget包含面板
                    require([url + "/Index"], function (index) {
                        if (html) {
                            $('#'+mapId).find('#' + widgetId + '_pane').append(html);
                        }
                        index.config = widget.config;
                        var main = $.extend({
                            id: widgetId,
                            label: widget.label
                        }, index);
                        if(widget.initialize){
                            main.init();
                            main.inited =true;
                        }
                        widgetDic[widgetId] = main;
                        console.log('组件 [' + widgetId + '] 加载完成 ');
                        isToolsLoaded();
                    }, function (err) {
                        console.log("模块 [" + widgetId + "] 加载异常请添加配置！");
                        isToolsLoaded();
                    });
                }, function (err) {
                    require([url + "/Index"], function (index) {
                        index.config = widget.config;
                        var main = $.extend({
                            id: widgetId,
                            label: widget.label,
                            noHtml: true,
                        }, index);
                        if(widget.initialize){
                            main.init();
                            main.inited =true;
                        }
                        widgetDic[widgetId] = main;
                        console.log('组件 [' + widgetId + '] 加载完成 ');
                        isToolsLoaded();
                    }, function (err) {
                        console.log("模块 [" + widgetId + "] 加载异常请添加配置！");
                        isToolsLoaded();
                    });
                });
            } catch (e) {
                console.log("模块 [" + widgetId + "] 加载异常 [" + e.message + "]");
                isToolsLoaded();
            }
        }

        this.loadWidgets = loadWidgets;

        this.getWidget = function (id) {
            return widgetDic[id];
        }

        /**
         * 所有工具是否加载完成
         */
        function isToolsLoaded() {
            var count = tools.length;
            toolsLoadIndex++;
            if(toolsLoadIndex>=count){
                //加载完成
                EventBus.trigger(EventBus.WIDGETS_LOADED);
                that.isLoaded = true;
                return true;
            }
            return false;
        }
    }

    return WidgetsManager;
});