/**
 *
 * @author: zzf
 * @date:  2018年11月20日
 * @version: v1.0
 */
define(['leaflet', 'esri-leaflet'], function (L, LEsri) {
    var that=this;
    var Overlay = L.ImageOverlay.extend({
        onAdd: function (map) {
            this._topLeft = map.getPixelBounds().min;
            L.ImageOverlay.prototype.onAdd.call(this, map);
        },
        _reset: function () {
            if (this._map.options.crs === L.CRS.EPSG3857) {
                L.ImageOverlay.prototype._reset.call(this);
            } else {
                L.DomUtil.setPosition(this._image, this._topLeft.subtract(this._map.getPixelOrigin()));
            }
        }
    });

    var StDynamicMapLayer = LEsri.DynamicMapLayer.extend({
        // override
        _renderImage: function (url, bounds, contentType) {
            if (this._map) {
                url = this._replaceUrl(url);
                // if no output directory has been specified for a service, MIME data will be returned
                if (contentType) {
                    url = 'data:' + contentType + ';base64,' + url;
                }
                // create a new image overlay and add it to the map
                // to start loading the image
                // opacity is 0 while the image is loading
                // 添加 自定义参数 regionCode
                this.options.regionCode =that.xzqdm;
                if (this.options.regionCode !== 'undefined' && this.options.regionCode && url.indexOf('regionCode') < 0) {
                    url = url.concat("?regionCode=").concat(this.options.regionCode);
                }
                var image = new Overlay(url, bounds, {
                    opacity: 0,
                    crossOrigin: this.options.useCors,
                    alt: this.options.alt,
                    pane: this.options.pane || this.getPane(),
                    interactive: this.options.interactive
                }).addTo(this._map);

                var onOverlayError = function () {
                    this._map.removeLayer(image);
                    this.fire('error');
                    image.off('load', onOverlayLoad, this);
                };

                var onOverlayLoad = function (e) {
                    image.off('error', onOverlayLoad, this);
                    if (this._map) {
                        var newImage = e.target;
                        var oldImage = this._currentImage;

                        $(newImage._image).css('z-index', 1);

                        // if the bounds of this image matches the bounds that
                        // _renderImage was called with and we have a map with the same bounds
                        // hide the old image if there is one and set the opacity
                        // of the new image otherwise remove the new image
                        if (newImage._bounds.equals(bounds) && newImage._bounds.equals(this._map.getBounds())) {
                            this._currentImage = newImage;

                            if (this.options.position === 'front') {
                                this.bringToFront();
                            } else {
                                this.bringToBack();
                            }

                            if (this._map && this._currentImage._map) {
                                this._currentImage.setOpacity(this.options.opacity);
                            } else {
                                this._currentImage._map.removeLayer(this._currentImage);
                            }

                            if (oldImage && this._map) {
                                $(oldImage._image).before($(newImage._image));
                                this._map.removeLayer(oldImage);
                            }

                            if (oldImage && oldImage._map) {
                                oldImage._map.removeLayer(oldImage);
                            }
                        } else {
                            this._map.removeLayer(newImage);
                        }
                    }

                    this.fire('load', {
                        bounds: bounds
                    });
                };

                // If loading the image fails
                image.once('error', onOverlayError, this);

                // once the image loads
                image.once('load', onOverlayLoad, this);

                this.fire('loading', {
                    bounds: bounds
                });
            }
        },
        _buildExportParams: function () {
            var sr = parseInt(this._map.options.crs.code.split(':')[1], 10);

            var params = {
                bbox: this._calculateBbox(),
                size: this._calculateImageSize(),
                dpi: 96,
                // format: "png"||this.options.format,
                format: "png"||this.options.format,
                transparent: this.options.transparent,
                bboxSR: sr,
                imageSR: sr,
                regionCode: that.xzqdm
            };

            if (this.options.dynamicLayers) {
                params.dynamicLayers = this.options.dynamicLayers;
            }

            if (this.options.layers) {
                if (this.options.layers.length === 0) {
                    return;
                } else {
                    params.layers = 'show:' + this.options.layers.join(',');
                }
            }

            if (this.options.hideLysr) {
                if (this.options.hideLysr.length !== 0) {
                    params.layers = 'hide:' + this.options.hideLysr.join(',');
                }
            }

            if (this.options.layerDefs) {
                params.layerDefs = typeof this.options.layerDefs === 'string' ? this.options.layerDefs : JSON.stringify(this.options.layerDefs);
            }

            if (this.options.timeOptions) {
                params.timeOptions = JSON.stringify(this.options.timeOptions);
            }

            if (this.options.from && this.options.to) {
                params.time = this.options.from.valueOf() + ',' + this.options.to.valueOf();
            }

            if (this.service.options.token) {
                params.token = this.service.options.token;
            }

            if (this.options.proxy) {
                params.proxy = this.options.proxy;
            }

            // use a timestamp to bust server cache
            if (this.options.disableCache) {
                params._ts = Date.now();
            }

            return params;
        },
        // 添加替换后的映射地址
        _replaceUrl: function (url) {
            return url.replace(/172.23.22.22/g, '172.18.2.91')
                .replace(/172.23.22.23/g, '172.18.2.92')
                .replace(/172.23.22.26/g, '172.18.2.203');
        },
        setZIndex: function (value) {
            this.options.zIndex = value;
            return this;
        }
    });

    function stDynamicMapLayer(url, options,xzqdm) {
        that.xzqdm=xzqdm;
        return new StDynamicMapLayer(url, options,xzqdm);
    }

    return stDynamicMapLayer;
});
