// ycx 事件加载机制
define([],function () {

    //事件加载机制
    var eventDic ={};
    var eventBus = {
        /**
         * content init
         */
        CONTENT_INITIALIZE: "contextInitialize",

        /**
         * main map resize
         */
        CONTENT_RESIZE: "contentResize",

        /**
         * all widgets loaded
         */
        WIDGETS_LOADED: "widgetsLoaded",

        /**
         * main map init
         */
        MAIN_MAP_INITIALIZED: "mainMapInitialized",

        /**
         * main map init extent set already
         */
        MAIN_MAP_INIT_EXTENT_SET: "mainMapInitExtentSet",

        /**
         * 主地图 图形要素清除事件
         */
        MAIN_MAP_GRAPHICS_REMOVED: "mainMapGrasRemoved",

        /**
         * 系统初始化完成
         */
        APP_INITIALIZED: "appInitialized",

        /**
         * widget开启
         */
        WIDGET_OPEN:'WIDGET_OPEN',

        /**
         * widget关闭
         */
        WIDGET_CLOSE:'WIDGET_CLOSE',
    };
    eventBus.listener = function (evt,func,id) {
        eventDic[evt]=eventDic[evt]||[];
        var obj ={
            func:func,
            id:id
        };
        eventDic[evt].push(obj);
    }
    eventBus.trigger = function (evt,data,_id) {
        if(eventDic[evt]&&eventDic[evt].length>0){
            $(eventDic[evt]).map(function (i,obj) {
                var id = obj["id"];
                var func = obj["func"];
                func(data);
            })
        }
    }
    eventBus.remove = function (evt,_id) {
        //使用回调函数删除
        if(typeof _id=="function"){
            eventDic[evt]=eventDic[evt]||[];
            for(var i=eventDic[evt].length-1;i>=0;i--){
                var obj =eventDic[evt][i];
                if(_id(obj)){
                    eventDic[evt].splice(i,1);
                }
            }
            return ;
        }
        if(!_id){
            eventDic[evt] =[];
        }else {
            eventDic[evt]=eventDic[evt]||[];
            for(var i=eventDic[evt].length-1;i>=0;i--){
                var obj =eventDic[evt][i];
                if(obj.id==_id){
                    eventDic[evt].splice(i,1);
                }
            }
        }

    }
    return eventBus;
})