/**
 */

define([
        "leaflet",
        "echarts"
    ], function (
        L,
        echarts
    ) {
        'use strict';
        function EchartsUtils() {
            var that = this;
            var iconArr=[];
            var map = null;
            var region = null;
            var mainMap = null;
            var appConfig=null;

            this.destroy = function () {
                $(iconArr).map(function (i,v) {
                    map.removeLayer(v);
                });
                iconArr=[];
            };

            var createDivICon = function (option) {
                var $div = $("<div></div>")
                    .addClass("echarts-container")
                    .attr("id",option.id);
                var icon =L.divIcon({
                    className: 'div-icon',
                    iconSize: [option.width||80, option.height||400],
                    html:$div.prop("outerHTML")
                });
                return icon;
            }

            /**
             * x:y
             * data
             * @param data
             */
            var addChartsToMap =function (data,_map) {
                map =_map;
                $(data).map(function (i,v) {
                    var option = v.option;
                    //创建marker
                    var icon = createDivICon(option);
                    var marker = L.marker([option.y,option.x],{icon:icon});
                    marker.addTo(map);
                    var myChart = echarts.init(document.getElementById(option.id));
                    myChart.setOption(v.data);
                    iconArr.push(marker);
                });
            };
            var addMarkerToMap =function (data,_map) {
                map =_map;
                //创建marker
                var icon =L.divIcon({
                    className: 'marker-m-icon',
                    iconSize:[30,30],
                    html:"<div><span>"+data.detail+"</span></div>"
                });
                var marker = L.marker([data.y,data.x],{icon:icon});
                marker.addTo(map);

            }

            /**
             * 行政区编码组织url并查询
             */
            var queryByXZQ = function (xzqdm,callBack) {
                    if (xzqdm.indexOf('00') !== -1) {
                        xzqdm = xzqdm.split('00')[0];
                    }
                    var regionUrl = "";
                    var regionUrlPre = appConfig.interface.queryUrlPre;
                    //判断行政市和区对应的图层
                    if (xzqdm.length > 6) {
                        regionUrl = regionUrlPre + "?xzqdm=" + xzqdm + "&index="
                            + appConfig.regionIndex.split(',')[0] + ',' + appConfig.regionIndex.split(',')[1] + ',' + appConfig.regionIndex.split(',')[2];
                    } else if (xzqdm.length > 5) {
                        //index根据tpl模板中的regionIndex进行获取
                        regionUrl = regionUrlPre + "?xzqdm=" + xzqdm + "&index="
                            + appConfig.regionIndex.split(',')[0] + ',' + appConfig.regionIndex.split(',')[1];
                    } else {
                        //检索市数据时需要将index拆分获取regionIndex的xzq_c_2016_2k索引
                        regionUrl = regionUrlPre + "?xzqdm=" + xzqdm + "&index="
                            + appConfig.regionIndex.split(',')[0];
                    }
                //获取geojson数据
                //渲染图层
                $.support.cors = true;
                //根据拼接的url拿到需要的市区数据
                $.getJSON(regionUrl).done(function (data) {
                    if(callBack){
                        callBack(data);
                    }
                });
            };

            /**
             * 通过行政区显示
             */
            this.echartsByRegion =function (MainMap,xzq,callBack,chartOption,showMarker) {
                debugger;
                appConfig = MainMap.appConfig;
                var xzqInterface = appConfig.interface.getAllRegionsUrl;
                if(!this.region){
                    $.ajax({
                        url: xzqInterface + xzq,
                        type: 'get',
                        success:function (data) {
                            region = data;
                            var targetCity = null;
                            //获取目标行政区(市级)
                            $(region).map(function (i,v) {
                                if(v.value==xzq){
                                    targetCity = v;
                                }
                            });
                            if(!targetCity){
                                return;
                            }
                            //获取到当前范围
                            queryByXZQ(targetCity.value,function (n) {
                                //定位
                                try {
                                    var feature = n.content[0];
                                    if(feature==undefined){
                                        return;
                                    }
                                    //渲染图层
                                    var regionLayer = L.geoJson(feature);
                                    //设定bounds中心及视图缩放比例
                                    var geoBounds = regionLayer.getBounds();
                                    var zoom = MainMap.map.get$Map().getBoundsZoom(geoBounds);
                                    MainMap.map.get$Map().flyTo(geoBounds.getCenter(), zoom);
                                } catch (e) {
                                    console.error(e);
                                }
                            });
                            $(targetCity.children).map(function (i,v) {
                                queryByXZQ(v.value,function (xzqData) {
                                    var feature = xzqData.content[0];
                                    var regionLayer = L.geoJson(feature);
                                    var center = regionLayer.getBounds().getCenter();
                                    var featureData = null;
                                    if(callBack){
                                        featureData =callBack(feature);
                                    }
                                    $.extend(chartOption,{
                                        x:center.lng,
                                        y:center.lat,
                                        xAxis:featureData.xAxis,
                                        data:featureData.data,
                                        label:featureData.label
                                    });
                                    debugger
                                    var chart = getEchartsData(chartOption);
                                    if(!showMarker){
                                        addChartsToMap(chart,MainMap.map.get$Map());
                                    }else {
                                        var markerData={
                                            x:'',
                                            y:'',
                                            detail:''
                                        };
                                        markerData.x=chart.option.x;
                                        markerData.y=chart.option.y;
                                        markerData.detail=chartOption.data[0]
                                        addMarkerToMap(markerData,MainMap.map.get$Map());
                                    }
                                })
                            })
                        }
                    });
                }

            }


        }

        var getEchartsData = function (option) {
            var id =Math.floor(Math.random()*(1000000000));
            var app={};
            app.config = {
                rotate: 90,
                align: 'left',
                verticalAlign: 'middle',
                position: 'insideBottom',
                distance: 15,
                onChange: function () {
                    var labelOption = {
                        normal: {
                            rotate: app.config.rotate,
                            align: app.config.align,
                            verticalAlign: app.config.verticalAlign,
                            position: app.config.position,
                            distance: app.config.distance
                        }
                    };
                    myChart.setOption({
                        series: [{
                            label: labelOption
                        }, {
                            label: labelOption
                        }, {
                            label: labelOption
                        }, {
                            label: labelOption
                        }]
                    });
                }
            };
            var labelOption = {
                normal: {
                    show: true,
                    position: app.config.position,
                    distance: app.config.distance,
                    align: app.config.align,
                    verticalAlign: app.config.verticalAlign,
                    rotate: app.config.rotate,
                    // formatter: '{c}  {name|{a}}',
                    fontSize: 16,
                    rich: {
                        name: {
                            textBorderColor: '#fff'
                        }
                    }
                }
            };

            var data ={
                option: {
                    // x: 118.511785,
                    // y: 31.284697,
                    x: option.x,
                    y: option.y,
                    id:id,
                    width:option.width||80,
                    height:option.height||150
                },
                data:{
                    title : {
                        show:true,//显示策略，默认值true,可选为：true（显示） | false（隐藏）
                        text: option.label||'主标题',//主标题文本，'\n'指定换行
                        subtarget: null,//指定窗口打开副标题超链接，支持'self' | 'blank'，不指定等同为'blank'（新窗口）
                        x:'center',//水平安放位置，默认为'left'，可选为：'center' | 'left' | 'right' | {number}（x坐标，单位px）
                        y: 110,//垂直安放位置，默认为top，可选为：'top' | 'bottom' | 'center' | {number}（y坐标，单位px）
                        // botton:200,
                        textAlign: null,//水平对齐方式，默认根据x设置自动调整，可选为： left' | 'right' | 'center
                        backgroundColor: 'rgba(0,0,0,0)',//标题背景颜色，默认'rgba(0,0,0,0)'透明
                        borderColor: '#ccc',//标题边框颜色,默认'#ccc'
                        borderWidth: 0,//标题边框线宽，单位px，默认为0（无边框）
                        padding: 5,//标题内边距，单位px，默认各方向内边距为5，接受数组分别设定上右下左边距
                        itemGap: 10,//主副标题纵向间隔，单位px，默认为10
                        textStyle: {//主标题文本样式{"fontSize": 18,"fontWeight": "bolder","color": "#333"}
                            "fontSize": 16,
                            color:"#FF5400",
                        },
                    },
                    tooltip : {
                        trigger: 'axis',
                        axisPointer : {            // 坐标轴指示器，坐标轴触发有效
                            type : 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                        }
                    },
                    xAxis: {
                        type: 'category',
                        data: option.xAxis||['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                        axisLabel:{
                            show:false,
                            textStyle:{
                                color:"red",
                                fontSize:2
                            }
                        },
                        "axisTick":{       //y轴刻度线
                            "show":false
                        },
                        axisLine:{
                            lineStyle:{
                                // color:'#FF0000', //更改坐标轴颜色
                                width:3,
                                color:'#24B0EC', //更改坐标轴颜色
                            }
                        }
                    },
                    yAxis: {
                        type: 'value',
                        axisLabel:{
                            show:true,
                            textStyle:{
                                color:"red",
                                // color:"#24B0EC",
                                fontSize:2
                            }
                        },
                        "axisTick":{       //y轴刻度线
                            "show":false
                        },
                        "splitLine": {     //网格线
                            "show": false
                        },
                        axisLine:{
                            "show":false,
                            lineStyle:{
                                // color:'#FF0000', //更改坐标轴颜色
                                color:'#24B0EC', //更改坐标轴颜色
                            }
                        }
                    },
                    grid:option.grid||{
                        // top:"10px",
                        // left:"30px",
                        // right:"15px",
                        // bottom:"30px"
                        top:"0px",
                        left:"0px",
                        right:"0px",
                        bottom:"40px"
                    },

                    backgroundColor: 'rgba(255,255,255,0)',
                    series: [{
                        data: option.data||[120, 200, 150, 80, 70, 110, 130],
                        label: labelOption,
                        type: 'bar',
                        barWidth:20,
                        itemStyle: {
                            normal: {
                                // color: '#24B0EC'
                                color: function (param) {
                                    // debugger
                                    var colorList =option.colorList|| ['#24B0EC','#24B0EC','#24B0EC','#24B0EC']
                                    return colorList[param.dataIndex];
                                }
                            }
                        }
                    }]
                }

            };

            return data;
        }

        return new EchartsUtils();
    }
);
